// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var crc32_flag_p string

func init() {
	crc32Cmd.Flags().StringVarP(&crc32_flag_p, "polynomial", "p", "ieee", "CRC32 polynomial (ieee, castagnoli, koopman)")
	rootCmd.AddCommand(crc32Cmd)
}

var crc32Cmd = &cobra.Command{
	Use:     "crc32 [string]",
	Short:   "Get the CRC32 checksum of your text",
	Aliases: []string{"crc32-sum", "crc32-checksum"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var out string

		flags := make([]processors.Flag, 0)
		p := processors.CRC32{}
		flags = append(flags, processors.Flag{Short: "p", Value: crc32_flag_p})

		if len(args) == 0 {
			// Handle stdin/interactive input
			in := []byte(utils.ReadMultilineInput())
			out, err = p.Transform(in, flags...)
			if err != nil {
				return err
			}
		} else {
			// Check if it's a file
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				// It's a file - check if we should use streaming
				const largeFileThreshold = 10 * 1024 * 1024 // 10MB
				
				// Use central streaming function for all processors
				if processors.CanStream(p) && (fi.Size() > largeFileThreshold || processors.PreferStream(p)) {
					// Use streaming
					file, err := os.Open(args[0])
					if err != nil {
						return err
					}
					defer file.Close()
					
					err = processors.TransformStream(p, file, os.Stdout, flags...)
					return err
				} else {
					// Use traditional method for small files
					d, err := os.ReadFile(args[0])
					if err != nil {
						return err
					}
					out, err = p.Transform(d, flags...)
					if err != nil {
						return err
					}
				}
			} else {
				// Not a file, treat as string input
				out, err = p.Transform([]byte(args[0]), flags...)
				if err != nil {
					return err
				}
			}
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
