package extensions

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// StorageArea storage areas.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Extensions#type-StorageArea
type StorageArea string

// String returns the StorageArea as string value.
func (t StorageArea) String() string {
	return string(t)
}

// StorageArea values.
const (
	StorageAreaSession StorageArea = "session"
	StorageAreaLocal   StorageArea = "local"
	StorageAreaSync    StorageArea = "sync"
	StorageAreaManaged StorageArea = "managed"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *StorageArea) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch StorageArea(s) {
	case StorageAreaSession:
		*t = StorageAreaSession
	case StorageAreaLocal:
		*t = StorageAreaLocal
	case StorageAreaSync:
		*t = StorageAreaSync
	case StorageAreaManaged:
		*t = StorageAreaManaged
	default:
		return fmt.Errorf("unknown StorageArea value: %v", s)
	}
	return nil
}
