// Copyright 2022-2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package serial

import (
	"strconv"
)

type Collation uint16

const (
	Collationinvalid                     Collation = 0
	Collationbig5_chinese_ci             Collation = 1
	Collationlatin2_czech_cs             Collation = 2
	Collationdec8_swedish_ci             Collation = 3
	Collationcp850_general_ci            Collation = 4
	Collationlatin1_german1_ci           Collation = 5
	Collationhp8_english_ci              Collation = 6
	Collationkoi8r_general_ci            Collation = 7
	Collationlatin1_swedish_ci           Collation = 8
	Collationlatin2_general_ci           Collation = 9
	Collationswe7_swedish_ci             Collation = 10
	Collationascii_general_ci            Collation = 11
	Collationujis_japanese_ci            Collation = 12
	Collationsjis_japanese_ci            Collation = 13
	Collationcp1251_bulgarian_ci         Collation = 14
	Collationlatin1_danish_ci            Collation = 15
	Collationhebrew_general_ci           Collation = 16
	Collationtis620_thai_ci              Collation = 18
	Collationeuckr_korean_ci             Collation = 19
	Collationlatin7_estonian_cs          Collation = 20
	Collationlatin2_hungarian_ci         Collation = 21
	Collationkoi8u_general_ci            Collation = 22
	Collationcp1251_ukrainian_ci         Collation = 23
	Collationgb2312_chinese_ci           Collation = 24
	Collationgreek_general_ci            Collation = 25
	Collationcp1250_general_ci           Collation = 26
	Collationlatin2_croatian_ci          Collation = 27
	Collationgbk_chinese_ci              Collation = 28
	Collationcp1257_lithuanian_ci        Collation = 29
	Collationlatin5_turkish_ci           Collation = 30
	Collationlatin1_german2_ci           Collation = 31
	Collationarmscii8_general_ci         Collation = 32
	Collationutf8mb3_general_ci          Collation = 33
	Collationcp1250_czech_cs             Collation = 34
	Collationucs2_general_ci             Collation = 35
	Collationcp866_general_ci            Collation = 36
	Collationkeybcs2_general_ci          Collation = 37
	Collationmacce_general_ci            Collation = 38
	Collationmacroman_general_ci         Collation = 39
	Collationcp852_general_ci            Collation = 40
	Collationlatin7_general_ci           Collation = 41
	Collationlatin7_general_cs           Collation = 42
	Collationmacce_bin                   Collation = 43
	Collationcp1250_croatian_ci          Collation = 44
	Collationutf8mb4_general_ci          Collation = 45
	Collationutf8mb4_bin                 Collation = 46
	Collationlatin1_bin                  Collation = 47
	Collationlatin1_general_ci           Collation = 48
	Collationlatin1_general_cs           Collation = 49
	Collationcp1251_bin                  Collation = 50
	Collationcp1251_general_ci           Collation = 51
	Collationcp1251_general_cs           Collation = 52
	Collationmacroman_bin                Collation = 53
	Collationutf16_general_ci            Collation = 54
	Collationutf16_bin                   Collation = 55
	Collationutf16le_general_ci          Collation = 56
	Collationcp1256_general_ci           Collation = 57
	Collationcp1257_bin                  Collation = 58
	Collationcp1257_general_ci           Collation = 59
	Collationutf32_general_ci            Collation = 60
	Collationutf32_bin                   Collation = 61
	Collationutf16le_bin                 Collation = 62
	Collationbinary                      Collation = 63
	Collationarmscii8_bin                Collation = 64
	Collationascii_bin                   Collation = 65
	Collationcp1250_bin                  Collation = 66
	Collationcp1256_bin                  Collation = 67
	Collationcp866_bin                   Collation = 68
	Collationdec8_bin                    Collation = 69
	Collationgreek_bin                   Collation = 70
	Collationhebrew_bin                  Collation = 71
	Collationhp8_bin                     Collation = 72
	Collationkeybcs2_bin                 Collation = 73
	Collationkoi8r_bin                   Collation = 74
	Collationkoi8u_bin                   Collation = 75
	Collationutf8mb3_tolower_ci          Collation = 76
	Collationlatin2_bin                  Collation = 77
	Collationlatin5_bin                  Collation = 78
	Collationlatin7_bin                  Collation = 79
	Collationcp850_bin                   Collation = 80
	Collationcp852_bin                   Collation = 81
	Collationswe7_bin                    Collation = 82
	Collationutf8mb3_bin                 Collation = 83
	Collationbig5_bin                    Collation = 84
	Collationeuckr_bin                   Collation = 85
	Collationgb2312_bin                  Collation = 86
	Collationgbk_bin                     Collation = 87
	Collationsjis_bin                    Collation = 88
	Collationtis620_bin                  Collation = 89
	Collationucs2_bin                    Collation = 90
	Collationujis_bin                    Collation = 91
	Collationgeostd8_general_ci          Collation = 92
	Collationgeostd8_bin                 Collation = 93
	Collationlatin1_spanish_ci           Collation = 94
	Collationcp932_japanese_ci           Collation = 95
	Collationcp932_bin                   Collation = 96
	Collationeucjpms_japanese_ci         Collation = 97
	Collationeucjpms_bin                 Collation = 98
	Collationcp1250_polish_ci            Collation = 99
	Collationutf16_unicode_ci            Collation = 101
	Collationutf16_icelandic_ci          Collation = 102
	Collationutf16_latvian_ci            Collation = 103
	Collationutf16_romanian_ci           Collation = 104
	Collationutf16_slovenian_ci          Collation = 105
	Collationutf16_polish_ci             Collation = 106
	Collationutf16_estonian_ci           Collation = 107
	Collationutf16_spanish_ci            Collation = 108
	Collationutf16_swedish_ci            Collation = 109
	Collationutf16_turkish_ci            Collation = 110
	Collationutf16_czech_ci              Collation = 111
	Collationutf16_danish_ci             Collation = 112
	Collationutf16_lithuanian_ci         Collation = 113
	Collationutf16_slovak_ci             Collation = 114
	Collationutf16_spanish2_ci           Collation = 115
	Collationutf16_roman_ci              Collation = 116
	Collationutf16_persian_ci            Collation = 117
	Collationutf16_esperanto_ci          Collation = 118
	Collationutf16_hungarian_ci          Collation = 119
	Collationutf16_sinhala_ci            Collation = 120
	Collationutf16_german2_ci            Collation = 121
	Collationutf16_croatian_ci           Collation = 122
	Collationutf16_unicode_520_ci        Collation = 123
	Collationutf16_vietnamese_ci         Collation = 124
	Collationucs2_unicode_ci             Collation = 128
	Collationucs2_icelandic_ci           Collation = 129
	Collationucs2_latvian_ci             Collation = 130
	Collationucs2_romanian_ci            Collation = 131
	Collationucs2_slovenian_ci           Collation = 132
	Collationucs2_polish_ci              Collation = 133
	Collationucs2_estonian_ci            Collation = 134
	Collationucs2_spanish_ci             Collation = 135
	Collationucs2_swedish_ci             Collation = 136
	Collationucs2_turkish_ci             Collation = 137
	Collationucs2_czech_ci               Collation = 138
	Collationucs2_danish_ci              Collation = 139
	Collationucs2_lithuanian_ci          Collation = 140
	Collationucs2_slovak_ci              Collation = 141
	Collationucs2_spanish2_ci            Collation = 142
	Collationucs2_roman_ci               Collation = 143
	Collationucs2_persian_ci             Collation = 144
	Collationucs2_esperanto_ci           Collation = 145
	Collationucs2_hungarian_ci           Collation = 146
	Collationucs2_sinhala_ci             Collation = 147
	Collationucs2_german2_ci             Collation = 148
	Collationucs2_croatian_ci            Collation = 149
	Collationucs2_unicode_520_ci         Collation = 150
	Collationucs2_vietnamese_ci          Collation = 151
	Collationucs2_general_mysql500_ci    Collation = 159
	Collationutf32_unicode_ci            Collation = 160
	Collationutf32_icelandic_ci          Collation = 161
	Collationutf32_latvian_ci            Collation = 162
	Collationutf32_romanian_ci           Collation = 163
	Collationutf32_slovenian_ci          Collation = 164
	Collationutf32_polish_ci             Collation = 165
	Collationutf32_estonian_ci           Collation = 166
	Collationutf32_spanish_ci            Collation = 167
	Collationutf32_swedish_ci            Collation = 168
	Collationutf32_turkish_ci            Collation = 169
	Collationutf32_czech_ci              Collation = 170
	Collationutf32_danish_ci             Collation = 171
	Collationutf32_lithuanian_ci         Collation = 172
	Collationutf32_slovak_ci             Collation = 173
	Collationutf32_spanish2_ci           Collation = 174
	Collationutf32_roman_ci              Collation = 175
	Collationutf32_persian_ci            Collation = 176
	Collationutf32_esperanto_ci          Collation = 177
	Collationutf32_hungarian_ci          Collation = 178
	Collationutf32_sinhala_ci            Collation = 179
	Collationutf32_german2_ci            Collation = 180
	Collationutf32_croatian_ci           Collation = 181
	Collationutf32_unicode_520_ci        Collation = 182
	Collationutf32_vietnamese_ci         Collation = 183
	Collationutf8mb3_unicode_ci          Collation = 192
	Collationutf8mb3_icelandic_ci        Collation = 193
	Collationutf8mb3_latvian_ci          Collation = 194
	Collationutf8mb3_romanian_ci         Collation = 195
	Collationutf8mb3_slovenian_ci        Collation = 196
	Collationutf8mb3_polish_ci           Collation = 197
	Collationutf8mb3_estonian_ci         Collation = 198
	Collationutf8mb3_spanish_ci          Collation = 199
	Collationutf8mb3_swedish_ci          Collation = 200
	Collationutf8mb3_turkish_ci          Collation = 201
	Collationutf8mb3_czech_ci            Collation = 202
	Collationutf8mb3_danish_ci           Collation = 203
	Collationutf8mb3_lithuanian_ci       Collation = 204
	Collationutf8mb3_slovak_ci           Collation = 205
	Collationutf8mb3_spanish2_ci         Collation = 206
	Collationutf8mb3_roman_ci            Collation = 207
	Collationutf8mb3_persian_ci          Collation = 208
	Collationutf8mb3_esperanto_ci        Collation = 209
	Collationutf8mb3_hungarian_ci        Collation = 210
	Collationutf8mb3_sinhala_ci          Collation = 211
	Collationutf8mb3_german2_ci          Collation = 212
	Collationutf8mb3_croatian_ci         Collation = 213
	Collationutf8mb3_unicode_520_ci      Collation = 214
	Collationutf8mb3_vietnamese_ci       Collation = 215
	Collationutf8mb3_general_mysql500_ci Collation = 223
	Collationutf8mb4_unicode_ci          Collation = 224
	Collationutf8mb4_icelandic_ci        Collation = 225
	Collationutf8mb4_latvian_ci          Collation = 226
	Collationutf8mb4_romanian_ci         Collation = 227
	Collationutf8mb4_slovenian_ci        Collation = 228
	Collationutf8mb4_polish_ci           Collation = 229
	Collationutf8mb4_estonian_ci         Collation = 230
	Collationutf8mb4_spanish_ci          Collation = 231
	Collationutf8mb4_swedish_ci          Collation = 232
	Collationutf8mb4_turkish_ci          Collation = 233
	Collationutf8mb4_czech_ci            Collation = 234
	Collationutf8mb4_danish_ci           Collation = 235
	Collationutf8mb4_lithuanian_ci       Collation = 236
	Collationutf8mb4_slovak_ci           Collation = 237
	Collationutf8mb4_spanish2_ci         Collation = 238
	Collationutf8mb4_roman_ci            Collation = 239
	Collationutf8mb4_persian_ci          Collation = 240
	Collationutf8mb4_esperanto_ci        Collation = 241
	Collationutf8mb4_hungarian_ci        Collation = 242
	Collationutf8mb4_sinhala_ci          Collation = 243
	Collationutf8mb4_german2_ci          Collation = 244
	Collationutf8mb4_croatian_ci         Collation = 245
	Collationutf8mb4_unicode_520_ci      Collation = 246
	Collationutf8mb4_vietnamese_ci       Collation = 247
	Collationgb18030_chinese_ci          Collation = 248
	Collationgb18030_bin                 Collation = 249
	Collationgb18030_unicode_520_ci      Collation = 250
	Collationutf8mb4_0900_ai_ci          Collation = 255
	Collationutf8mb4_de_pb_0900_ai_ci    Collation = 256
	Collationutf8mb4_is_0900_ai_ci       Collation = 257
	Collationutf8mb4_lv_0900_ai_ci       Collation = 258
	Collationutf8mb4_ro_0900_ai_ci       Collation = 259
	Collationutf8mb4_sl_0900_ai_ci       Collation = 260
	Collationutf8mb4_pl_0900_ai_ci       Collation = 261
	Collationutf8mb4_et_0900_ai_ci       Collation = 262
	Collationutf8mb4_es_0900_ai_ci       Collation = 263
	Collationutf8mb4_sv_0900_ai_ci       Collation = 264
	Collationutf8mb4_tr_0900_ai_ci       Collation = 265
	Collationutf8mb4_cs_0900_ai_ci       Collation = 266
	Collationutf8mb4_da_0900_ai_ci       Collation = 267
	Collationutf8mb4_lt_0900_ai_ci       Collation = 268
	Collationutf8mb4_sk_0900_ai_ci       Collation = 269
	Collationutf8mb4_es_trad_0900_ai_ci  Collation = 270
	Collationutf8mb4_la_0900_ai_ci       Collation = 271
	Collationutf8mb4_eo_0900_ai_ci       Collation = 273
	Collationutf8mb4_hu_0900_ai_ci       Collation = 274
	Collationutf8mb4_hr_0900_ai_ci       Collation = 275
	Collationutf8mb4_vi_0900_ai_ci       Collation = 277
	Collationutf8mb4_0900_as_cs          Collation = 278
	Collationutf8mb4_de_pb_0900_as_cs    Collation = 279
	Collationutf8mb4_is_0900_as_cs       Collation = 280
	Collationutf8mb4_lv_0900_as_cs       Collation = 281
	Collationutf8mb4_ro_0900_as_cs       Collation = 282
	Collationutf8mb4_sl_0900_as_cs       Collation = 283
	Collationutf8mb4_pl_0900_as_cs       Collation = 284
	Collationutf8mb4_et_0900_as_cs       Collation = 285
	Collationutf8mb4_es_0900_as_cs       Collation = 286
	Collationutf8mb4_sv_0900_as_cs       Collation = 287
	Collationutf8mb4_tr_0900_as_cs       Collation = 288
	Collationutf8mb4_cs_0900_as_cs       Collation = 289
	Collationutf8mb4_da_0900_as_cs       Collation = 290
	Collationutf8mb4_lt_0900_as_cs       Collation = 291
	Collationutf8mb4_sk_0900_as_cs       Collation = 292
	Collationutf8mb4_es_trad_0900_as_cs  Collation = 293
	Collationutf8mb4_la_0900_as_cs       Collation = 294
	Collationutf8mb4_eo_0900_as_cs       Collation = 296
	Collationutf8mb4_hu_0900_as_cs       Collation = 297
	Collationutf8mb4_hr_0900_as_cs       Collation = 298
	Collationutf8mb4_vi_0900_as_cs       Collation = 300
	Collationutf8mb4_ja_0900_as_cs       Collation = 303
	Collationutf8mb4_ja_0900_as_cs_ks    Collation = 304
	Collationutf8mb4_0900_as_ci          Collation = 305
	Collationutf8mb4_ru_0900_ai_ci       Collation = 306
	Collationutf8mb4_ru_0900_as_cs       Collation = 307
	Collationutf8mb4_zh_0900_as_cs       Collation = 308
	Collationutf8mb4_0900_bin            Collation = 309
)

var EnumNamesCollation = map[Collation]string{
	Collationinvalid:                     "invalid",
	Collationbig5_chinese_ci:             "big5_chinese_ci",
	Collationlatin2_czech_cs:             "latin2_czech_cs",
	Collationdec8_swedish_ci:             "dec8_swedish_ci",
	Collationcp850_general_ci:            "cp850_general_ci",
	Collationlatin1_german1_ci:           "latin1_german1_ci",
	Collationhp8_english_ci:              "hp8_english_ci",
	Collationkoi8r_general_ci:            "koi8r_general_ci",
	Collationlatin1_swedish_ci:           "latin1_swedish_ci",
	Collationlatin2_general_ci:           "latin2_general_ci",
	Collationswe7_swedish_ci:             "swe7_swedish_ci",
	Collationascii_general_ci:            "ascii_general_ci",
	Collationujis_japanese_ci:            "ujis_japanese_ci",
	Collationsjis_japanese_ci:            "sjis_japanese_ci",
	Collationcp1251_bulgarian_ci:         "cp1251_bulgarian_ci",
	Collationlatin1_danish_ci:            "latin1_danish_ci",
	Collationhebrew_general_ci:           "hebrew_general_ci",
	Collationtis620_thai_ci:              "tis620_thai_ci",
	Collationeuckr_korean_ci:             "euckr_korean_ci",
	Collationlatin7_estonian_cs:          "latin7_estonian_cs",
	Collationlatin2_hungarian_ci:         "latin2_hungarian_ci",
	Collationkoi8u_general_ci:            "koi8u_general_ci",
	Collationcp1251_ukrainian_ci:         "cp1251_ukrainian_ci",
	Collationgb2312_chinese_ci:           "gb2312_chinese_ci",
	Collationgreek_general_ci:            "greek_general_ci",
	Collationcp1250_general_ci:           "cp1250_general_ci",
	Collationlatin2_croatian_ci:          "latin2_croatian_ci",
	Collationgbk_chinese_ci:              "gbk_chinese_ci",
	Collationcp1257_lithuanian_ci:        "cp1257_lithuanian_ci",
	Collationlatin5_turkish_ci:           "latin5_turkish_ci",
	Collationlatin1_german2_ci:           "latin1_german2_ci",
	Collationarmscii8_general_ci:         "armscii8_general_ci",
	Collationutf8mb3_general_ci:          "utf8mb3_general_ci",
	Collationcp1250_czech_cs:             "cp1250_czech_cs",
	Collationucs2_general_ci:             "ucs2_general_ci",
	Collationcp866_general_ci:            "cp866_general_ci",
	Collationkeybcs2_general_ci:          "keybcs2_general_ci",
	Collationmacce_general_ci:            "macce_general_ci",
	Collationmacroman_general_ci:         "macroman_general_ci",
	Collationcp852_general_ci:            "cp852_general_ci",
	Collationlatin7_general_ci:           "latin7_general_ci",
	Collationlatin7_general_cs:           "latin7_general_cs",
	Collationmacce_bin:                   "macce_bin",
	Collationcp1250_croatian_ci:          "cp1250_croatian_ci",
	Collationutf8mb4_general_ci:          "utf8mb4_general_ci",
	Collationutf8mb4_bin:                 "utf8mb4_bin",
	Collationlatin1_bin:                  "latin1_bin",
	Collationlatin1_general_ci:           "latin1_general_ci",
	Collationlatin1_general_cs:           "latin1_general_cs",
	Collationcp1251_bin:                  "cp1251_bin",
	Collationcp1251_general_ci:           "cp1251_general_ci",
	Collationcp1251_general_cs:           "cp1251_general_cs",
	Collationmacroman_bin:                "macroman_bin",
	Collationutf16_general_ci:            "utf16_general_ci",
	Collationutf16_bin:                   "utf16_bin",
	Collationutf16le_general_ci:          "utf16le_general_ci",
	Collationcp1256_general_ci:           "cp1256_general_ci",
	Collationcp1257_bin:                  "cp1257_bin",
	Collationcp1257_general_ci:           "cp1257_general_ci",
	Collationutf32_general_ci:            "utf32_general_ci",
	Collationutf32_bin:                   "utf32_bin",
	Collationutf16le_bin:                 "utf16le_bin",
	Collationbinary:                      "binary",
	Collationarmscii8_bin:                "armscii8_bin",
	Collationascii_bin:                   "ascii_bin",
	Collationcp1250_bin:                  "cp1250_bin",
	Collationcp1256_bin:                  "cp1256_bin",
	Collationcp866_bin:                   "cp866_bin",
	Collationdec8_bin:                    "dec8_bin",
	Collationgreek_bin:                   "greek_bin",
	Collationhebrew_bin:                  "hebrew_bin",
	Collationhp8_bin:                     "hp8_bin",
	Collationkeybcs2_bin:                 "keybcs2_bin",
	Collationkoi8r_bin:                   "koi8r_bin",
	Collationkoi8u_bin:                   "koi8u_bin",
	Collationutf8mb3_tolower_ci:          "utf8mb3_tolower_ci",
	Collationlatin2_bin:                  "latin2_bin",
	Collationlatin5_bin:                  "latin5_bin",
	Collationlatin7_bin:                  "latin7_bin",
	Collationcp850_bin:                   "cp850_bin",
	Collationcp852_bin:                   "cp852_bin",
	Collationswe7_bin:                    "swe7_bin",
	Collationutf8mb3_bin:                 "utf8mb3_bin",
	Collationbig5_bin:                    "big5_bin",
	Collationeuckr_bin:                   "euckr_bin",
	Collationgb2312_bin:                  "gb2312_bin",
	Collationgbk_bin:                     "gbk_bin",
	Collationsjis_bin:                    "sjis_bin",
	Collationtis620_bin:                  "tis620_bin",
	Collationucs2_bin:                    "ucs2_bin",
	Collationujis_bin:                    "ujis_bin",
	Collationgeostd8_general_ci:          "geostd8_general_ci",
	Collationgeostd8_bin:                 "geostd8_bin",
	Collationlatin1_spanish_ci:           "latin1_spanish_ci",
	Collationcp932_japanese_ci:           "cp932_japanese_ci",
	Collationcp932_bin:                   "cp932_bin",
	Collationeucjpms_japanese_ci:         "eucjpms_japanese_ci",
	Collationeucjpms_bin:                 "eucjpms_bin",
	Collationcp1250_polish_ci:            "cp1250_polish_ci",
	Collationutf16_unicode_ci:            "utf16_unicode_ci",
	Collationutf16_icelandic_ci:          "utf16_icelandic_ci",
	Collationutf16_latvian_ci:            "utf16_latvian_ci",
	Collationutf16_romanian_ci:           "utf16_romanian_ci",
	Collationutf16_slovenian_ci:          "utf16_slovenian_ci",
	Collationutf16_polish_ci:             "utf16_polish_ci",
	Collationutf16_estonian_ci:           "utf16_estonian_ci",
	Collationutf16_spanish_ci:            "utf16_spanish_ci",
	Collationutf16_swedish_ci:            "utf16_swedish_ci",
	Collationutf16_turkish_ci:            "utf16_turkish_ci",
	Collationutf16_czech_ci:              "utf16_czech_ci",
	Collationutf16_danish_ci:             "utf16_danish_ci",
	Collationutf16_lithuanian_ci:         "utf16_lithuanian_ci",
	Collationutf16_slovak_ci:             "utf16_slovak_ci",
	Collationutf16_spanish2_ci:           "utf16_spanish2_ci",
	Collationutf16_roman_ci:              "utf16_roman_ci",
	Collationutf16_persian_ci:            "utf16_persian_ci",
	Collationutf16_esperanto_ci:          "utf16_esperanto_ci",
	Collationutf16_hungarian_ci:          "utf16_hungarian_ci",
	Collationutf16_sinhala_ci:            "utf16_sinhala_ci",
	Collationutf16_german2_ci:            "utf16_german2_ci",
	Collationutf16_croatian_ci:           "utf16_croatian_ci",
	Collationutf16_unicode_520_ci:        "utf16_unicode_520_ci",
	Collationutf16_vietnamese_ci:         "utf16_vietnamese_ci",
	Collationucs2_unicode_ci:             "ucs2_unicode_ci",
	Collationucs2_icelandic_ci:           "ucs2_icelandic_ci",
	Collationucs2_latvian_ci:             "ucs2_latvian_ci",
	Collationucs2_romanian_ci:            "ucs2_romanian_ci",
	Collationucs2_slovenian_ci:           "ucs2_slovenian_ci",
	Collationucs2_polish_ci:              "ucs2_polish_ci",
	Collationucs2_estonian_ci:            "ucs2_estonian_ci",
	Collationucs2_spanish_ci:             "ucs2_spanish_ci",
	Collationucs2_swedish_ci:             "ucs2_swedish_ci",
	Collationucs2_turkish_ci:             "ucs2_turkish_ci",
	Collationucs2_czech_ci:               "ucs2_czech_ci",
	Collationucs2_danish_ci:              "ucs2_danish_ci",
	Collationucs2_lithuanian_ci:          "ucs2_lithuanian_ci",
	Collationucs2_slovak_ci:              "ucs2_slovak_ci",
	Collationucs2_spanish2_ci:            "ucs2_spanish2_ci",
	Collationucs2_roman_ci:               "ucs2_roman_ci",
	Collationucs2_persian_ci:             "ucs2_persian_ci",
	Collationucs2_esperanto_ci:           "ucs2_esperanto_ci",
	Collationucs2_hungarian_ci:           "ucs2_hungarian_ci",
	Collationucs2_sinhala_ci:             "ucs2_sinhala_ci",
	Collationucs2_german2_ci:             "ucs2_german2_ci",
	Collationucs2_croatian_ci:            "ucs2_croatian_ci",
	Collationucs2_unicode_520_ci:         "ucs2_unicode_520_ci",
	Collationucs2_vietnamese_ci:          "ucs2_vietnamese_ci",
	Collationucs2_general_mysql500_ci:    "ucs2_general_mysql500_ci",
	Collationutf32_unicode_ci:            "utf32_unicode_ci",
	Collationutf32_icelandic_ci:          "utf32_icelandic_ci",
	Collationutf32_latvian_ci:            "utf32_latvian_ci",
	Collationutf32_romanian_ci:           "utf32_romanian_ci",
	Collationutf32_slovenian_ci:          "utf32_slovenian_ci",
	Collationutf32_polish_ci:             "utf32_polish_ci",
	Collationutf32_estonian_ci:           "utf32_estonian_ci",
	Collationutf32_spanish_ci:            "utf32_spanish_ci",
	Collationutf32_swedish_ci:            "utf32_swedish_ci",
	Collationutf32_turkish_ci:            "utf32_turkish_ci",
	Collationutf32_czech_ci:              "utf32_czech_ci",
	Collationutf32_danish_ci:             "utf32_danish_ci",
	Collationutf32_lithuanian_ci:         "utf32_lithuanian_ci",
	Collationutf32_slovak_ci:             "utf32_slovak_ci",
	Collationutf32_spanish2_ci:           "utf32_spanish2_ci",
	Collationutf32_roman_ci:              "utf32_roman_ci",
	Collationutf32_persian_ci:            "utf32_persian_ci",
	Collationutf32_esperanto_ci:          "utf32_esperanto_ci",
	Collationutf32_hungarian_ci:          "utf32_hungarian_ci",
	Collationutf32_sinhala_ci:            "utf32_sinhala_ci",
	Collationutf32_german2_ci:            "utf32_german2_ci",
	Collationutf32_croatian_ci:           "utf32_croatian_ci",
	Collationutf32_unicode_520_ci:        "utf32_unicode_520_ci",
	Collationutf32_vietnamese_ci:         "utf32_vietnamese_ci",
	Collationutf8mb3_unicode_ci:          "utf8mb3_unicode_ci",
	Collationutf8mb3_icelandic_ci:        "utf8mb3_icelandic_ci",
	Collationutf8mb3_latvian_ci:          "utf8mb3_latvian_ci",
	Collationutf8mb3_romanian_ci:         "utf8mb3_romanian_ci",
	Collationutf8mb3_slovenian_ci:        "utf8mb3_slovenian_ci",
	Collationutf8mb3_polish_ci:           "utf8mb3_polish_ci",
	Collationutf8mb3_estonian_ci:         "utf8mb3_estonian_ci",
	Collationutf8mb3_spanish_ci:          "utf8mb3_spanish_ci",
	Collationutf8mb3_swedish_ci:          "utf8mb3_swedish_ci",
	Collationutf8mb3_turkish_ci:          "utf8mb3_turkish_ci",
	Collationutf8mb3_czech_ci:            "utf8mb3_czech_ci",
	Collationutf8mb3_danish_ci:           "utf8mb3_danish_ci",
	Collationutf8mb3_lithuanian_ci:       "utf8mb3_lithuanian_ci",
	Collationutf8mb3_slovak_ci:           "utf8mb3_slovak_ci",
	Collationutf8mb3_spanish2_ci:         "utf8mb3_spanish2_ci",
	Collationutf8mb3_roman_ci:            "utf8mb3_roman_ci",
	Collationutf8mb3_persian_ci:          "utf8mb3_persian_ci",
	Collationutf8mb3_esperanto_ci:        "utf8mb3_esperanto_ci",
	Collationutf8mb3_hungarian_ci:        "utf8mb3_hungarian_ci",
	Collationutf8mb3_sinhala_ci:          "utf8mb3_sinhala_ci",
	Collationutf8mb3_german2_ci:          "utf8mb3_german2_ci",
	Collationutf8mb3_croatian_ci:         "utf8mb3_croatian_ci",
	Collationutf8mb3_unicode_520_ci:      "utf8mb3_unicode_520_ci",
	Collationutf8mb3_vietnamese_ci:       "utf8mb3_vietnamese_ci",
	Collationutf8mb3_general_mysql500_ci: "utf8mb3_general_mysql500_ci",
	Collationutf8mb4_unicode_ci:          "utf8mb4_unicode_ci",
	Collationutf8mb4_icelandic_ci:        "utf8mb4_icelandic_ci",
	Collationutf8mb4_latvian_ci:          "utf8mb4_latvian_ci",
	Collationutf8mb4_romanian_ci:         "utf8mb4_romanian_ci",
	Collationutf8mb4_slovenian_ci:        "utf8mb4_slovenian_ci",
	Collationutf8mb4_polish_ci:           "utf8mb4_polish_ci",
	Collationutf8mb4_estonian_ci:         "utf8mb4_estonian_ci",
	Collationutf8mb4_spanish_ci:          "utf8mb4_spanish_ci",
	Collationutf8mb4_swedish_ci:          "utf8mb4_swedish_ci",
	Collationutf8mb4_turkish_ci:          "utf8mb4_turkish_ci",
	Collationutf8mb4_czech_ci:            "utf8mb4_czech_ci",
	Collationutf8mb4_danish_ci:           "utf8mb4_danish_ci",
	Collationutf8mb4_lithuanian_ci:       "utf8mb4_lithuanian_ci",
	Collationutf8mb4_slovak_ci:           "utf8mb4_slovak_ci",
	Collationutf8mb4_spanish2_ci:         "utf8mb4_spanish2_ci",
	Collationutf8mb4_roman_ci:            "utf8mb4_roman_ci",
	Collationutf8mb4_persian_ci:          "utf8mb4_persian_ci",
	Collationutf8mb4_esperanto_ci:        "utf8mb4_esperanto_ci",
	Collationutf8mb4_hungarian_ci:        "utf8mb4_hungarian_ci",
	Collationutf8mb4_sinhala_ci:          "utf8mb4_sinhala_ci",
	Collationutf8mb4_german2_ci:          "utf8mb4_german2_ci",
	Collationutf8mb4_croatian_ci:         "utf8mb4_croatian_ci",
	Collationutf8mb4_unicode_520_ci:      "utf8mb4_unicode_520_ci",
	Collationutf8mb4_vietnamese_ci:       "utf8mb4_vietnamese_ci",
	Collationgb18030_chinese_ci:          "gb18030_chinese_ci",
	Collationgb18030_bin:                 "gb18030_bin",
	Collationgb18030_unicode_520_ci:      "gb18030_unicode_520_ci",
	Collationutf8mb4_0900_ai_ci:          "utf8mb4_0900_ai_ci",
	Collationutf8mb4_de_pb_0900_ai_ci:    "utf8mb4_de_pb_0900_ai_ci",
	Collationutf8mb4_is_0900_ai_ci:       "utf8mb4_is_0900_ai_ci",
	Collationutf8mb4_lv_0900_ai_ci:       "utf8mb4_lv_0900_ai_ci",
	Collationutf8mb4_ro_0900_ai_ci:       "utf8mb4_ro_0900_ai_ci",
	Collationutf8mb4_sl_0900_ai_ci:       "utf8mb4_sl_0900_ai_ci",
	Collationutf8mb4_pl_0900_ai_ci:       "utf8mb4_pl_0900_ai_ci",
	Collationutf8mb4_et_0900_ai_ci:       "utf8mb4_et_0900_ai_ci",
	Collationutf8mb4_es_0900_ai_ci:       "utf8mb4_es_0900_ai_ci",
	Collationutf8mb4_sv_0900_ai_ci:       "utf8mb4_sv_0900_ai_ci",
	Collationutf8mb4_tr_0900_ai_ci:       "utf8mb4_tr_0900_ai_ci",
	Collationutf8mb4_cs_0900_ai_ci:       "utf8mb4_cs_0900_ai_ci",
	Collationutf8mb4_da_0900_ai_ci:       "utf8mb4_da_0900_ai_ci",
	Collationutf8mb4_lt_0900_ai_ci:       "utf8mb4_lt_0900_ai_ci",
	Collationutf8mb4_sk_0900_ai_ci:       "utf8mb4_sk_0900_ai_ci",
	Collationutf8mb4_es_trad_0900_ai_ci:  "utf8mb4_es_trad_0900_ai_ci",
	Collationutf8mb4_la_0900_ai_ci:       "utf8mb4_la_0900_ai_ci",
	Collationutf8mb4_eo_0900_ai_ci:       "utf8mb4_eo_0900_ai_ci",
	Collationutf8mb4_hu_0900_ai_ci:       "utf8mb4_hu_0900_ai_ci",
	Collationutf8mb4_hr_0900_ai_ci:       "utf8mb4_hr_0900_ai_ci",
	Collationutf8mb4_vi_0900_ai_ci:       "utf8mb4_vi_0900_ai_ci",
	Collationutf8mb4_0900_as_cs:          "utf8mb4_0900_as_cs",
	Collationutf8mb4_de_pb_0900_as_cs:    "utf8mb4_de_pb_0900_as_cs",
	Collationutf8mb4_is_0900_as_cs:       "utf8mb4_is_0900_as_cs",
	Collationutf8mb4_lv_0900_as_cs:       "utf8mb4_lv_0900_as_cs",
	Collationutf8mb4_ro_0900_as_cs:       "utf8mb4_ro_0900_as_cs",
	Collationutf8mb4_sl_0900_as_cs:       "utf8mb4_sl_0900_as_cs",
	Collationutf8mb4_pl_0900_as_cs:       "utf8mb4_pl_0900_as_cs",
	Collationutf8mb4_et_0900_as_cs:       "utf8mb4_et_0900_as_cs",
	Collationutf8mb4_es_0900_as_cs:       "utf8mb4_es_0900_as_cs",
	Collationutf8mb4_sv_0900_as_cs:       "utf8mb4_sv_0900_as_cs",
	Collationutf8mb4_tr_0900_as_cs:       "utf8mb4_tr_0900_as_cs",
	Collationutf8mb4_cs_0900_as_cs:       "utf8mb4_cs_0900_as_cs",
	Collationutf8mb4_da_0900_as_cs:       "utf8mb4_da_0900_as_cs",
	Collationutf8mb4_lt_0900_as_cs:       "utf8mb4_lt_0900_as_cs",
	Collationutf8mb4_sk_0900_as_cs:       "utf8mb4_sk_0900_as_cs",
	Collationutf8mb4_es_trad_0900_as_cs:  "utf8mb4_es_trad_0900_as_cs",
	Collationutf8mb4_la_0900_as_cs:       "utf8mb4_la_0900_as_cs",
	Collationutf8mb4_eo_0900_as_cs:       "utf8mb4_eo_0900_as_cs",
	Collationutf8mb4_hu_0900_as_cs:       "utf8mb4_hu_0900_as_cs",
	Collationutf8mb4_hr_0900_as_cs:       "utf8mb4_hr_0900_as_cs",
	Collationutf8mb4_vi_0900_as_cs:       "utf8mb4_vi_0900_as_cs",
	Collationutf8mb4_ja_0900_as_cs:       "utf8mb4_ja_0900_as_cs",
	Collationutf8mb4_ja_0900_as_cs_ks:    "utf8mb4_ja_0900_as_cs_ks",
	Collationutf8mb4_0900_as_ci:          "utf8mb4_0900_as_ci",
	Collationutf8mb4_ru_0900_ai_ci:       "utf8mb4_ru_0900_ai_ci",
	Collationutf8mb4_ru_0900_as_cs:       "utf8mb4_ru_0900_as_cs",
	Collationutf8mb4_zh_0900_as_cs:       "utf8mb4_zh_0900_as_cs",
	Collationutf8mb4_0900_bin:            "utf8mb4_0900_bin",
}

var EnumValuesCollation = map[string]Collation{
	"invalid":                     Collationinvalid,
	"big5_chinese_ci":             Collationbig5_chinese_ci,
	"latin2_czech_cs":             Collationlatin2_czech_cs,
	"dec8_swedish_ci":             Collationdec8_swedish_ci,
	"cp850_general_ci":            Collationcp850_general_ci,
	"latin1_german1_ci":           Collationlatin1_german1_ci,
	"hp8_english_ci":              Collationhp8_english_ci,
	"koi8r_general_ci":            Collationkoi8r_general_ci,
	"latin1_swedish_ci":           Collationlatin1_swedish_ci,
	"latin2_general_ci":           Collationlatin2_general_ci,
	"swe7_swedish_ci":             Collationswe7_swedish_ci,
	"ascii_general_ci":            Collationascii_general_ci,
	"ujis_japanese_ci":            Collationujis_japanese_ci,
	"sjis_japanese_ci":            Collationsjis_japanese_ci,
	"cp1251_bulgarian_ci":         Collationcp1251_bulgarian_ci,
	"latin1_danish_ci":            Collationlatin1_danish_ci,
	"hebrew_general_ci":           Collationhebrew_general_ci,
	"tis620_thai_ci":              Collationtis620_thai_ci,
	"euckr_korean_ci":             Collationeuckr_korean_ci,
	"latin7_estonian_cs":          Collationlatin7_estonian_cs,
	"latin2_hungarian_ci":         Collationlatin2_hungarian_ci,
	"koi8u_general_ci":            Collationkoi8u_general_ci,
	"cp1251_ukrainian_ci":         Collationcp1251_ukrainian_ci,
	"gb2312_chinese_ci":           Collationgb2312_chinese_ci,
	"greek_general_ci":            Collationgreek_general_ci,
	"cp1250_general_ci":           Collationcp1250_general_ci,
	"latin2_croatian_ci":          Collationlatin2_croatian_ci,
	"gbk_chinese_ci":              Collationgbk_chinese_ci,
	"cp1257_lithuanian_ci":        Collationcp1257_lithuanian_ci,
	"latin5_turkish_ci":           Collationlatin5_turkish_ci,
	"latin1_german2_ci":           Collationlatin1_german2_ci,
	"armscii8_general_ci":         Collationarmscii8_general_ci,
	"utf8mb3_general_ci":          Collationutf8mb3_general_ci,
	"cp1250_czech_cs":             Collationcp1250_czech_cs,
	"ucs2_general_ci":             Collationucs2_general_ci,
	"cp866_general_ci":            Collationcp866_general_ci,
	"keybcs2_general_ci":          Collationkeybcs2_general_ci,
	"macce_general_ci":            Collationmacce_general_ci,
	"macroman_general_ci":         Collationmacroman_general_ci,
	"cp852_general_ci":            Collationcp852_general_ci,
	"latin7_general_ci":           Collationlatin7_general_ci,
	"latin7_general_cs":           Collationlatin7_general_cs,
	"macce_bin":                   Collationmacce_bin,
	"cp1250_croatian_ci":          Collationcp1250_croatian_ci,
	"utf8mb4_general_ci":          Collationutf8mb4_general_ci,
	"utf8mb4_bin":                 Collationutf8mb4_bin,
	"latin1_bin":                  Collationlatin1_bin,
	"latin1_general_ci":           Collationlatin1_general_ci,
	"latin1_general_cs":           Collationlatin1_general_cs,
	"cp1251_bin":                  Collationcp1251_bin,
	"cp1251_general_ci":           Collationcp1251_general_ci,
	"cp1251_general_cs":           Collationcp1251_general_cs,
	"macroman_bin":                Collationmacroman_bin,
	"utf16_general_ci":            Collationutf16_general_ci,
	"utf16_bin":                   Collationutf16_bin,
	"utf16le_general_ci":          Collationutf16le_general_ci,
	"cp1256_general_ci":           Collationcp1256_general_ci,
	"cp1257_bin":                  Collationcp1257_bin,
	"cp1257_general_ci":           Collationcp1257_general_ci,
	"utf32_general_ci":            Collationutf32_general_ci,
	"utf32_bin":                   Collationutf32_bin,
	"utf16le_bin":                 Collationutf16le_bin,
	"binary":                      Collationbinary,
	"armscii8_bin":                Collationarmscii8_bin,
	"ascii_bin":                   Collationascii_bin,
	"cp1250_bin":                  Collationcp1250_bin,
	"cp1256_bin":                  Collationcp1256_bin,
	"cp866_bin":                   Collationcp866_bin,
	"dec8_bin":                    Collationdec8_bin,
	"greek_bin":                   Collationgreek_bin,
	"hebrew_bin":                  Collationhebrew_bin,
	"hp8_bin":                     Collationhp8_bin,
	"keybcs2_bin":                 Collationkeybcs2_bin,
	"koi8r_bin":                   Collationkoi8r_bin,
	"koi8u_bin":                   Collationkoi8u_bin,
	"utf8mb3_tolower_ci":          Collationutf8mb3_tolower_ci,
	"latin2_bin":                  Collationlatin2_bin,
	"latin5_bin":                  Collationlatin5_bin,
	"latin7_bin":                  Collationlatin7_bin,
	"cp850_bin":                   Collationcp850_bin,
	"cp852_bin":                   Collationcp852_bin,
	"swe7_bin":                    Collationswe7_bin,
	"utf8mb3_bin":                 Collationutf8mb3_bin,
	"big5_bin":                    Collationbig5_bin,
	"euckr_bin":                   Collationeuckr_bin,
	"gb2312_bin":                  Collationgb2312_bin,
	"gbk_bin":                     Collationgbk_bin,
	"sjis_bin":                    Collationsjis_bin,
	"tis620_bin":                  Collationtis620_bin,
	"ucs2_bin":                    Collationucs2_bin,
	"ujis_bin":                    Collationujis_bin,
	"geostd8_general_ci":          Collationgeostd8_general_ci,
	"geostd8_bin":                 Collationgeostd8_bin,
	"latin1_spanish_ci":           Collationlatin1_spanish_ci,
	"cp932_japanese_ci":           Collationcp932_japanese_ci,
	"cp932_bin":                   Collationcp932_bin,
	"eucjpms_japanese_ci":         Collationeucjpms_japanese_ci,
	"eucjpms_bin":                 Collationeucjpms_bin,
	"cp1250_polish_ci":            Collationcp1250_polish_ci,
	"utf16_unicode_ci":            Collationutf16_unicode_ci,
	"utf16_icelandic_ci":          Collationutf16_icelandic_ci,
	"utf16_latvian_ci":            Collationutf16_latvian_ci,
	"utf16_romanian_ci":           Collationutf16_romanian_ci,
	"utf16_slovenian_ci":          Collationutf16_slovenian_ci,
	"utf16_polish_ci":             Collationutf16_polish_ci,
	"utf16_estonian_ci":           Collationutf16_estonian_ci,
	"utf16_spanish_ci":            Collationutf16_spanish_ci,
	"utf16_swedish_ci":            Collationutf16_swedish_ci,
	"utf16_turkish_ci":            Collationutf16_turkish_ci,
	"utf16_czech_ci":              Collationutf16_czech_ci,
	"utf16_danish_ci":             Collationutf16_danish_ci,
	"utf16_lithuanian_ci":         Collationutf16_lithuanian_ci,
	"utf16_slovak_ci":             Collationutf16_slovak_ci,
	"utf16_spanish2_ci":           Collationutf16_spanish2_ci,
	"utf16_roman_ci":              Collationutf16_roman_ci,
	"utf16_persian_ci":            Collationutf16_persian_ci,
	"utf16_esperanto_ci":          Collationutf16_esperanto_ci,
	"utf16_hungarian_ci":          Collationutf16_hungarian_ci,
	"utf16_sinhala_ci":            Collationutf16_sinhala_ci,
	"utf16_german2_ci":            Collationutf16_german2_ci,
	"utf16_croatian_ci":           Collationutf16_croatian_ci,
	"utf16_unicode_520_ci":        Collationutf16_unicode_520_ci,
	"utf16_vietnamese_ci":         Collationutf16_vietnamese_ci,
	"ucs2_unicode_ci":             Collationucs2_unicode_ci,
	"ucs2_icelandic_ci":           Collationucs2_icelandic_ci,
	"ucs2_latvian_ci":             Collationucs2_latvian_ci,
	"ucs2_romanian_ci":            Collationucs2_romanian_ci,
	"ucs2_slovenian_ci":           Collationucs2_slovenian_ci,
	"ucs2_polish_ci":              Collationucs2_polish_ci,
	"ucs2_estonian_ci":            Collationucs2_estonian_ci,
	"ucs2_spanish_ci":             Collationucs2_spanish_ci,
	"ucs2_swedish_ci":             Collationucs2_swedish_ci,
	"ucs2_turkish_ci":             Collationucs2_turkish_ci,
	"ucs2_czech_ci":               Collationucs2_czech_ci,
	"ucs2_danish_ci":              Collationucs2_danish_ci,
	"ucs2_lithuanian_ci":          Collationucs2_lithuanian_ci,
	"ucs2_slovak_ci":              Collationucs2_slovak_ci,
	"ucs2_spanish2_ci":            Collationucs2_spanish2_ci,
	"ucs2_roman_ci":               Collationucs2_roman_ci,
	"ucs2_persian_ci":             Collationucs2_persian_ci,
	"ucs2_esperanto_ci":           Collationucs2_esperanto_ci,
	"ucs2_hungarian_ci":           Collationucs2_hungarian_ci,
	"ucs2_sinhala_ci":             Collationucs2_sinhala_ci,
	"ucs2_german2_ci":             Collationucs2_german2_ci,
	"ucs2_croatian_ci":            Collationucs2_croatian_ci,
	"ucs2_unicode_520_ci":         Collationucs2_unicode_520_ci,
	"ucs2_vietnamese_ci":          Collationucs2_vietnamese_ci,
	"ucs2_general_mysql500_ci":    Collationucs2_general_mysql500_ci,
	"utf32_unicode_ci":            Collationutf32_unicode_ci,
	"utf32_icelandic_ci":          Collationutf32_icelandic_ci,
	"utf32_latvian_ci":            Collationutf32_latvian_ci,
	"utf32_romanian_ci":           Collationutf32_romanian_ci,
	"utf32_slovenian_ci":          Collationutf32_slovenian_ci,
	"utf32_polish_ci":             Collationutf32_polish_ci,
	"utf32_estonian_ci":           Collationutf32_estonian_ci,
	"utf32_spanish_ci":            Collationutf32_spanish_ci,
	"utf32_swedish_ci":            Collationutf32_swedish_ci,
	"utf32_turkish_ci":            Collationutf32_turkish_ci,
	"utf32_czech_ci":              Collationutf32_czech_ci,
	"utf32_danish_ci":             Collationutf32_danish_ci,
	"utf32_lithuanian_ci":         Collationutf32_lithuanian_ci,
	"utf32_slovak_ci":             Collationutf32_slovak_ci,
	"utf32_spanish2_ci":           Collationutf32_spanish2_ci,
	"utf32_roman_ci":              Collationutf32_roman_ci,
	"utf32_persian_ci":            Collationutf32_persian_ci,
	"utf32_esperanto_ci":          Collationutf32_esperanto_ci,
	"utf32_hungarian_ci":          Collationutf32_hungarian_ci,
	"utf32_sinhala_ci":            Collationutf32_sinhala_ci,
	"utf32_german2_ci":            Collationutf32_german2_ci,
	"utf32_croatian_ci":           Collationutf32_croatian_ci,
	"utf32_unicode_520_ci":        Collationutf32_unicode_520_ci,
	"utf32_vietnamese_ci":         Collationutf32_vietnamese_ci,
	"utf8mb3_unicode_ci":          Collationutf8mb3_unicode_ci,
	"utf8mb3_icelandic_ci":        Collationutf8mb3_icelandic_ci,
	"utf8mb3_latvian_ci":          Collationutf8mb3_latvian_ci,
	"utf8mb3_romanian_ci":         Collationutf8mb3_romanian_ci,
	"utf8mb3_slovenian_ci":        Collationutf8mb3_slovenian_ci,
	"utf8mb3_polish_ci":           Collationutf8mb3_polish_ci,
	"utf8mb3_estonian_ci":         Collationutf8mb3_estonian_ci,
	"utf8mb3_spanish_ci":          Collationutf8mb3_spanish_ci,
	"utf8mb3_swedish_ci":          Collationutf8mb3_swedish_ci,
	"utf8mb3_turkish_ci":          Collationutf8mb3_turkish_ci,
	"utf8mb3_czech_ci":            Collationutf8mb3_czech_ci,
	"utf8mb3_danish_ci":           Collationutf8mb3_danish_ci,
	"utf8mb3_lithuanian_ci":       Collationutf8mb3_lithuanian_ci,
	"utf8mb3_slovak_ci":           Collationutf8mb3_slovak_ci,
	"utf8mb3_spanish2_ci":         Collationutf8mb3_spanish2_ci,
	"utf8mb3_roman_ci":            Collationutf8mb3_roman_ci,
	"utf8mb3_persian_ci":          Collationutf8mb3_persian_ci,
	"utf8mb3_esperanto_ci":        Collationutf8mb3_esperanto_ci,
	"utf8mb3_hungarian_ci":        Collationutf8mb3_hungarian_ci,
	"utf8mb3_sinhala_ci":          Collationutf8mb3_sinhala_ci,
	"utf8mb3_german2_ci":          Collationutf8mb3_german2_ci,
	"utf8mb3_croatian_ci":         Collationutf8mb3_croatian_ci,
	"utf8mb3_unicode_520_ci":      Collationutf8mb3_unicode_520_ci,
	"utf8mb3_vietnamese_ci":       Collationutf8mb3_vietnamese_ci,
	"utf8mb3_general_mysql500_ci": Collationutf8mb3_general_mysql500_ci,
	"utf8mb4_unicode_ci":          Collationutf8mb4_unicode_ci,
	"utf8mb4_icelandic_ci":        Collationutf8mb4_icelandic_ci,
	"utf8mb4_latvian_ci":          Collationutf8mb4_latvian_ci,
	"utf8mb4_romanian_ci":         Collationutf8mb4_romanian_ci,
	"utf8mb4_slovenian_ci":        Collationutf8mb4_slovenian_ci,
	"utf8mb4_polish_ci":           Collationutf8mb4_polish_ci,
	"utf8mb4_estonian_ci":         Collationutf8mb4_estonian_ci,
	"utf8mb4_spanish_ci":          Collationutf8mb4_spanish_ci,
	"utf8mb4_swedish_ci":          Collationutf8mb4_swedish_ci,
	"utf8mb4_turkish_ci":          Collationutf8mb4_turkish_ci,
	"utf8mb4_czech_ci":            Collationutf8mb4_czech_ci,
	"utf8mb4_danish_ci":           Collationutf8mb4_danish_ci,
	"utf8mb4_lithuanian_ci":       Collationutf8mb4_lithuanian_ci,
	"utf8mb4_slovak_ci":           Collationutf8mb4_slovak_ci,
	"utf8mb4_spanish2_ci":         Collationutf8mb4_spanish2_ci,
	"utf8mb4_roman_ci":            Collationutf8mb4_roman_ci,
	"utf8mb4_persian_ci":          Collationutf8mb4_persian_ci,
	"utf8mb4_esperanto_ci":        Collationutf8mb4_esperanto_ci,
	"utf8mb4_hungarian_ci":        Collationutf8mb4_hungarian_ci,
	"utf8mb4_sinhala_ci":          Collationutf8mb4_sinhala_ci,
	"utf8mb4_german2_ci":          Collationutf8mb4_german2_ci,
	"utf8mb4_croatian_ci":         Collationutf8mb4_croatian_ci,
	"utf8mb4_unicode_520_ci":      Collationutf8mb4_unicode_520_ci,
	"utf8mb4_vietnamese_ci":       Collationutf8mb4_vietnamese_ci,
	"gb18030_chinese_ci":          Collationgb18030_chinese_ci,
	"gb18030_bin":                 Collationgb18030_bin,
	"gb18030_unicode_520_ci":      Collationgb18030_unicode_520_ci,
	"utf8mb4_0900_ai_ci":          Collationutf8mb4_0900_ai_ci,
	"utf8mb4_de_pb_0900_ai_ci":    Collationutf8mb4_de_pb_0900_ai_ci,
	"utf8mb4_is_0900_ai_ci":       Collationutf8mb4_is_0900_ai_ci,
	"utf8mb4_lv_0900_ai_ci":       Collationutf8mb4_lv_0900_ai_ci,
	"utf8mb4_ro_0900_ai_ci":       Collationutf8mb4_ro_0900_ai_ci,
	"utf8mb4_sl_0900_ai_ci":       Collationutf8mb4_sl_0900_ai_ci,
	"utf8mb4_pl_0900_ai_ci":       Collationutf8mb4_pl_0900_ai_ci,
	"utf8mb4_et_0900_ai_ci":       Collationutf8mb4_et_0900_ai_ci,
	"utf8mb4_es_0900_ai_ci":       Collationutf8mb4_es_0900_ai_ci,
	"utf8mb4_sv_0900_ai_ci":       Collationutf8mb4_sv_0900_ai_ci,
	"utf8mb4_tr_0900_ai_ci":       Collationutf8mb4_tr_0900_ai_ci,
	"utf8mb4_cs_0900_ai_ci":       Collationutf8mb4_cs_0900_ai_ci,
	"utf8mb4_da_0900_ai_ci":       Collationutf8mb4_da_0900_ai_ci,
	"utf8mb4_lt_0900_ai_ci":       Collationutf8mb4_lt_0900_ai_ci,
	"utf8mb4_sk_0900_ai_ci":       Collationutf8mb4_sk_0900_ai_ci,
	"utf8mb4_es_trad_0900_ai_ci":  Collationutf8mb4_es_trad_0900_ai_ci,
	"utf8mb4_la_0900_ai_ci":       Collationutf8mb4_la_0900_ai_ci,
	"utf8mb4_eo_0900_ai_ci":       Collationutf8mb4_eo_0900_ai_ci,
	"utf8mb4_hu_0900_ai_ci":       Collationutf8mb4_hu_0900_ai_ci,
	"utf8mb4_hr_0900_ai_ci":       Collationutf8mb4_hr_0900_ai_ci,
	"utf8mb4_vi_0900_ai_ci":       Collationutf8mb4_vi_0900_ai_ci,
	"utf8mb4_0900_as_cs":          Collationutf8mb4_0900_as_cs,
	"utf8mb4_de_pb_0900_as_cs":    Collationutf8mb4_de_pb_0900_as_cs,
	"utf8mb4_is_0900_as_cs":       Collationutf8mb4_is_0900_as_cs,
	"utf8mb4_lv_0900_as_cs":       Collationutf8mb4_lv_0900_as_cs,
	"utf8mb4_ro_0900_as_cs":       Collationutf8mb4_ro_0900_as_cs,
	"utf8mb4_sl_0900_as_cs":       Collationutf8mb4_sl_0900_as_cs,
	"utf8mb4_pl_0900_as_cs":       Collationutf8mb4_pl_0900_as_cs,
	"utf8mb4_et_0900_as_cs":       Collationutf8mb4_et_0900_as_cs,
	"utf8mb4_es_0900_as_cs":       Collationutf8mb4_es_0900_as_cs,
	"utf8mb4_sv_0900_as_cs":       Collationutf8mb4_sv_0900_as_cs,
	"utf8mb4_tr_0900_as_cs":       Collationutf8mb4_tr_0900_as_cs,
	"utf8mb4_cs_0900_as_cs":       Collationutf8mb4_cs_0900_as_cs,
	"utf8mb4_da_0900_as_cs":       Collationutf8mb4_da_0900_as_cs,
	"utf8mb4_lt_0900_as_cs":       Collationutf8mb4_lt_0900_as_cs,
	"utf8mb4_sk_0900_as_cs":       Collationutf8mb4_sk_0900_as_cs,
	"utf8mb4_es_trad_0900_as_cs":  Collationutf8mb4_es_trad_0900_as_cs,
	"utf8mb4_la_0900_as_cs":       Collationutf8mb4_la_0900_as_cs,
	"utf8mb4_eo_0900_as_cs":       Collationutf8mb4_eo_0900_as_cs,
	"utf8mb4_hu_0900_as_cs":       Collationutf8mb4_hu_0900_as_cs,
	"utf8mb4_hr_0900_as_cs":       Collationutf8mb4_hr_0900_as_cs,
	"utf8mb4_vi_0900_as_cs":       Collationutf8mb4_vi_0900_as_cs,
	"utf8mb4_ja_0900_as_cs":       Collationutf8mb4_ja_0900_as_cs,
	"utf8mb4_ja_0900_as_cs_ks":    Collationutf8mb4_ja_0900_as_cs_ks,
	"utf8mb4_0900_as_ci":          Collationutf8mb4_0900_as_ci,
	"utf8mb4_ru_0900_ai_ci":       Collationutf8mb4_ru_0900_ai_ci,
	"utf8mb4_ru_0900_as_cs":       Collationutf8mb4_ru_0900_as_cs,
	"utf8mb4_zh_0900_as_cs":       Collationutf8mb4_zh_0900_as_cs,
	"utf8mb4_0900_bin":            Collationutf8mb4_0900_bin,
}

func (v Collation) String() string {
	if s, ok := EnumNamesCollation[v]; ok {
		return s
	}
	return "Collation(" + strconv.FormatInt(int64(v), 10) + ")"
}
