#!/usr/bin/env bash

# Copyright 2017 The Kubernetes Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -o errexit
set -o nounset
set -o pipefail

SCRIPT_ROOT=$(dirname "${BASH_SOURCE[0]}")/..
CODE_GEN_VERSION=$(go mod edit -print |grep 'k8s.io/code-generator' | cut -f2 -d' ')
CODE_GEN_PKG=${CODE_GEN_PKG:-$GOPATH/pkg/mod/k8s.io/code-generator\@${CODE_GEN_VERSION}}
chmod +x ${CODE_GEN_PKG}/kube_codegen.sh
# generate the code with:
# --output-base    because this script should also be able to run inside the vendor dir of
#                  k8s.io/kubernetes. The output-base is needed for the generators to output into the vendor dir
#                  instead of the $GOPATH directly. For normal projects this can be dropped.
"${CODE_GEN_PKG}"/kube_codegen.sh "deepcopy,client,informer,lister" \
  sigs.k8s.io/aws-iam-authenticator/pkg/mapper/crd/generated sigs.k8s.io/aws-iam-authenticator/pkg/mapper/crd/apis \
  iamauthenticator:v1alpha1 \
  --output-base "$(dirname "${BASH_SOURCE[0]}")/../../.." \
  --go-header-file "${SCRIPT_ROOT}"/hack/boilerplate.go.txt

# To use your own boilerplate text append:
#   --go-header-file "${SCRIPT_ROOT}"/hack/custom-boilerplate.go.txt
