//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/vmwarecloudsimple/armvmwarecloudsimple"
	"net/http"
	"net/url"
	"regexp"
)

// VirtualNetworksServer is a fake server for instances of the armvmwarecloudsimple.VirtualNetworksClient type.
type VirtualNetworksServer struct {
	// Get is the fake for method VirtualNetworksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, regionID string, pcName string, virtualNetworkName string, options *armvmwarecloudsimple.VirtualNetworksClientGetOptions) (resp azfake.Responder[armvmwarecloudsimple.VirtualNetworksClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VirtualNetworksClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(regionID string, pcName string, resourcePoolName string, options *armvmwarecloudsimple.VirtualNetworksClientListOptions) (resp azfake.PagerResponder[armvmwarecloudsimple.VirtualNetworksClientListResponse])
}

// NewVirtualNetworksServerTransport creates a new instance of VirtualNetworksServerTransport with the provided implementation.
// The returned VirtualNetworksServerTransport instance is connected to an instance of armvmwarecloudsimple.VirtualNetworksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualNetworksServerTransport(srv *VirtualNetworksServer) *VirtualNetworksServerTransport {
	return &VirtualNetworksServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armvmwarecloudsimple.VirtualNetworksClientListResponse]](),
	}
}

// VirtualNetworksServerTransport connects instances of armvmwarecloudsimple.VirtualNetworksClient to instances of VirtualNetworksServer.
// Don't use this type directly, use NewVirtualNetworksServerTransport instead.
type VirtualNetworksServerTransport struct {
	srv          *VirtualNetworksServer
	newListPager *tracker[azfake.PagerResponder[armvmwarecloudsimple.VirtualNetworksClientListResponse]]
}

// Do implements the policy.Transporter interface for VirtualNetworksServerTransport.
func (v *VirtualNetworksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualNetworksClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualNetworksClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualNetworksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworks/(?P<virtualNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
	if err != nil {
		return nil, err
	}
	pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), regionIDParam, pcNameParam, virtualNetworkNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworksServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.VMwareCloudSimple/locations/(?P<regionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateClouds/(?P<pcName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		regionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("regionId")])
		if err != nil {
			return nil, err
		}
		pcNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pcName")])
		if err != nil {
			return nil, err
		}
		resourcePoolNameParam, err := url.QueryUnescape(qp.Get("resourcePoolName"))
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(regionIDParam, pcNameParam, resourcePoolNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armvmwarecloudsimple.VirtualNetworksClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
