//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolDatabasePrincipalAssignmentsCheckNameAvailability.json
func ExampleKustoPoolDatabasePrincipalAssignmentsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKustoPoolDatabasePrincipalAssignmentsClient().CheckNameAvailability(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "Kustodatabase8", "kustorptest", armsynapse.DatabasePrincipalAssignmentCheckNameRequest{
		Name: to.Ptr("kustoprincipal1"),
		Type: to.Ptr("Microsoft.Synapse/workspaces/kustoPools/databases/principalAssignments"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameResult = armsynapse.CheckNameResult{
	// 	Name: to.Ptr("kustoprincipal1"),
	// 	Message: to.Ptr("Name 'kustoprincipal1' is already taken. Please specify a different name"),
	// 	NameAvailable: to.Ptr(false),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolDatabasePrincipalAssignmentsList.json
func ExampleKustoPoolDatabasePrincipalAssignmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewKustoPoolDatabasePrincipalAssignmentsClient().NewListPager("synapseWorkspaceName", "kustoclusterrptest4", "Kustodatabase8", "kustorptest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabasePrincipalAssignmentListResult = armsynapse.DatabasePrincipalAssignmentListResult{
		// 	Value: []*armsynapse.DatabasePrincipalAssignment{
		// 		{
		// 			Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal1"),
		// 			Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/Databases/PrincipalAssignments"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/Databases/Kustodatabase8/PrincipalAssignments/kustoprincipal1"),
		// 			Properties: &armsynapse.DatabasePrincipalProperties{
		// 				AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
		// 				PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
		// 				PrincipalName: to.Ptr("TestApp"),
		// 				PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
		// 				ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
		// 				Role: to.Ptr(armsynapse.DatabasePrincipalRoleAdmin),
		// 				TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
		// 				TenantName: to.Ptr("tenantName"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal2"),
		// 			Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/Databases/PrincipalAssignments"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/Databases/Kustodatabase8/PrincipalAssignments/kustoprincipal2"),
		// 			Properties: &armsynapse.DatabasePrincipalProperties{
		// 				AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
		// 				PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
		// 				PrincipalName: to.Ptr("TestApp"),
		// 				PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
		// 				ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
		// 				Role: to.Ptr(armsynapse.DatabasePrincipalRoleAdmin),
		// 				TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
		// 				TenantName: to.Ptr("tenantName"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolDatabasePrincipalAssignmentsGet.json
func ExampleKustoPoolDatabasePrincipalAssignmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKustoPoolDatabasePrincipalAssignmentsClient().Get(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "Kustodatabase8", "kustoprincipal1", "kustorptest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabasePrincipalAssignment = armsynapse.DatabasePrincipalAssignment{
	// 	Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal1"),
	// 	Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/Databases/PrincipalAssignments"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/Databases/Kustodatabase8/PrincipalAssignments/kustoprincipal1"),
	// 	Properties: &armsynapse.DatabasePrincipalProperties{
	// 		AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
	// 		PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
	// 		PrincipalName: to.Ptr("TestApp"),
	// 		PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
	// 		ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
	// 		Role: to.Ptr(armsynapse.DatabasePrincipalRoleAdmin),
	// 		TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
	// 		TenantName: to.Ptr("tenantName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolDatabasePrincipalAssignmentsCreateOrUpdate.json
func ExampleKustoPoolDatabasePrincipalAssignmentsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewKustoPoolDatabasePrincipalAssignmentsClient().BeginCreateOrUpdate(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "Kustodatabase8", "kustoprincipal1", "kustorptest", armsynapse.DatabasePrincipalAssignment{
		Properties: &armsynapse.DatabasePrincipalProperties{
			PrincipalID:   to.Ptr("87654321-1234-1234-1234-123456789123"),
			PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
			Role:          to.Ptr(armsynapse.DatabasePrincipalRoleAdmin),
			TenantID:      to.Ptr("12345678-1234-1234-1234-123456789123"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabasePrincipalAssignment = armsynapse.DatabasePrincipalAssignment{
	// 	Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal1"),
	// 	Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/Databases/PrincipalAssignments"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/Databases/Kustodatabase8/PrincipalAssignments/kustoprincipal1"),
	// 	Properties: &armsynapse.DatabasePrincipalProperties{
	// 		AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
	// 		PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
	// 		PrincipalName: to.Ptr("TestApp"),
	// 		PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
	// 		ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
	// 		Role: to.Ptr(armsynapse.DatabasePrincipalRoleAdmin),
	// 		TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
	// 		TenantName: to.Ptr("tenantName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolDatabasePrincipalAssignmentsDelete.json
func ExampleKustoPoolDatabasePrincipalAssignmentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewKustoPoolDatabasePrincipalAssignmentsClient().BeginDelete(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "Kustodatabase8", "kustoprincipal1", "kustorptest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
