//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolConnectionPoliciesServer is a fake server for instances of the armsynapse.SQLPoolConnectionPoliciesClient type.
type SQLPoolConnectionPoliciesServer struct {
	// Get is the fake for method SQLPoolConnectionPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, connectionPolicyName armsynapse.ConnectionPolicyName, options *armsynapse.SQLPoolConnectionPoliciesClientGetOptions) (resp azfake.Responder[armsynapse.SQLPoolConnectionPoliciesClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSQLPoolConnectionPoliciesServerTransport creates a new instance of SQLPoolConnectionPoliciesServerTransport with the provided implementation.
// The returned SQLPoolConnectionPoliciesServerTransport instance is connected to an instance of armsynapse.SQLPoolConnectionPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolConnectionPoliciesServerTransport(srv *SQLPoolConnectionPoliciesServer) *SQLPoolConnectionPoliciesServerTransport {
	return &SQLPoolConnectionPoliciesServerTransport{srv: srv}
}

// SQLPoolConnectionPoliciesServerTransport connects instances of armsynapse.SQLPoolConnectionPoliciesClient to instances of SQLPoolConnectionPoliciesServer.
// Don't use this type directly, use NewSQLPoolConnectionPoliciesServerTransport instead.
type SQLPoolConnectionPoliciesServerTransport struct {
	srv *SQLPoolConnectionPoliciesServer
}

// Do implements the policy.Transporter interface for SQLPoolConnectionPoliciesServerTransport.
func (s *SQLPoolConnectionPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolConnectionPoliciesClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolConnectionPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectionPolicies/(?P<connectionPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	connectionPolicyNameParam, err := parseWithCast(matches[regex.SubexpIndex("connectionPolicyName")], func(v string) (armsynapse.ConnectionPolicyName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsynapse.ConnectionPolicyName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, connectionPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLPoolConnectionPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
