//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armsynapse.ClientFactory type.
type ServerFactory struct {
	AzureADOnlyAuthenticationsServer                              AzureADOnlyAuthenticationsServer
	BigDataPoolsServer                                            BigDataPoolsServer
	DataMaskingPoliciesServer                                     DataMaskingPoliciesServer
	DataMaskingRulesServer                                        DataMaskingRulesServer
	ExtendedSQLPoolBlobAuditingPoliciesServer                     ExtendedSQLPoolBlobAuditingPoliciesServer
	GetServer                                                     GetServer
	IPFirewallRulesServer                                         IPFirewallRulesServer
	IntegrationRuntimeAuthKeysServer                              IntegrationRuntimeAuthKeysServer
	IntegrationRuntimeConnectionInfosServer                       IntegrationRuntimeConnectionInfosServer
	IntegrationRuntimeCredentialsServer                           IntegrationRuntimeCredentialsServer
	IntegrationRuntimeMonitoringDataServer                        IntegrationRuntimeMonitoringDataServer
	IntegrationRuntimeNodeIPAddressServer                         IntegrationRuntimeNodeIPAddressServer
	IntegrationRuntimeNodesServer                                 IntegrationRuntimeNodesServer
	IntegrationRuntimeObjectMetadataServer                        IntegrationRuntimeObjectMetadataServer
	IntegrationRuntimeStatusServer                                IntegrationRuntimeStatusServer
	IntegrationRuntimesServer                                     IntegrationRuntimesServer
	KeysServer                                                    KeysServer
	KustoOperationsServer                                         KustoOperationsServer
	KustoPoolAttachedDatabaseConfigurationsServer                 KustoPoolAttachedDatabaseConfigurationsServer
	KustoPoolChildResourceServer                                  KustoPoolChildResourceServer
	KustoPoolDataConnectionsServer                                KustoPoolDataConnectionsServer
	KustoPoolDatabasePrincipalAssignmentsServer                   KustoPoolDatabasePrincipalAssignmentsServer
	KustoPoolDatabasesServer                                      KustoPoolDatabasesServer
	KustoPoolPrincipalAssignmentsServer                           KustoPoolPrincipalAssignmentsServer
	KustoPoolPrivateLinkResourcesServer                           KustoPoolPrivateLinkResourcesServer
	KustoPoolsServer                                              KustoPoolsServer
	LibrariesServer                                               LibrariesServer
	LibraryServer                                                 LibraryServer
	OperationsServer                                              OperationsServer
	PrivateEndpointConnectionsServer                              PrivateEndpointConnectionsServer
	PrivateEndpointConnectionsPrivateLinkHubServer                PrivateEndpointConnectionsPrivateLinkHubServer
	PrivateLinkHubPrivateLinkResourcesServer                      PrivateLinkHubPrivateLinkResourcesServer
	PrivateLinkHubsServer                                         PrivateLinkHubsServer
	PrivateLinkResourcesServer                                    PrivateLinkResourcesServer
	RestorableDroppedSQLPoolsServer                               RestorableDroppedSQLPoolsServer
	SQLPoolBlobAuditingPoliciesServer                             SQLPoolBlobAuditingPoliciesServer
	SQLPoolColumnsServer                                          SQLPoolColumnsServer
	SQLPoolConnectionPoliciesServer                               SQLPoolConnectionPoliciesServer
	SQLPoolDataWarehouseUserActivitiesServer                      SQLPoolDataWarehouseUserActivitiesServer
	SQLPoolGeoBackupPoliciesServer                                SQLPoolGeoBackupPoliciesServer
	SQLPoolMaintenanceWindowOptionsServer                         SQLPoolMaintenanceWindowOptionsServer
	SQLPoolMaintenanceWindowsServer                               SQLPoolMaintenanceWindowsServer
	SQLPoolMetadataSyncConfigsServer                              SQLPoolMetadataSyncConfigsServer
	SQLPoolOperationResultsServer                                 SQLPoolOperationResultsServer
	SQLPoolOperationsServer                                       SQLPoolOperationsServer
	SQLPoolRecommendedSensitivityLabelsServer                     SQLPoolRecommendedSensitivityLabelsServer
	SQLPoolReplicationLinksServer                                 SQLPoolReplicationLinksServer
	SQLPoolRestorePointsServer                                    SQLPoolRestorePointsServer
	SQLPoolSchemasServer                                          SQLPoolSchemasServer
	SQLPoolSecurityAlertPoliciesServer                            SQLPoolSecurityAlertPoliciesServer
	SQLPoolSensitivityLabelsServer                                SQLPoolSensitivityLabelsServer
	SQLPoolTableColumnsServer                                     SQLPoolTableColumnsServer
	SQLPoolTablesServer                                           SQLPoolTablesServer
	SQLPoolTransparentDataEncryptionsServer                       SQLPoolTransparentDataEncryptionsServer
	SQLPoolUsagesServer                                           SQLPoolUsagesServer
	SQLPoolVulnerabilityAssessmentRuleBaselinesServer             SQLPoolVulnerabilityAssessmentRuleBaselinesServer
	SQLPoolVulnerabilityAssessmentScansServer                     SQLPoolVulnerabilityAssessmentScansServer
	SQLPoolVulnerabilityAssessmentsServer                         SQLPoolVulnerabilityAssessmentsServer
	SQLPoolWorkloadClassifierServer                               SQLPoolWorkloadClassifierServer
	SQLPoolWorkloadGroupServer                                    SQLPoolWorkloadGroupServer
	SQLPoolsServer                                                SQLPoolsServer
	SparkConfigurationServer                                      SparkConfigurationServer
	SparkConfigurationsServer                                     SparkConfigurationsServer
	WorkspaceAADAdminsServer                                      WorkspaceAADAdminsServer
	WorkspaceManagedIdentitySQLControlSettingsServer              WorkspaceManagedIdentitySQLControlSettingsServer
	WorkspaceManagedSQLServerBlobAuditingPoliciesServer           WorkspaceManagedSQLServerBlobAuditingPoliciesServer
	WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer
	WorkspaceManagedSQLServerEncryptionProtectorServer            WorkspaceManagedSQLServerEncryptionProtectorServer
	WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer   WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer
	WorkspaceManagedSQLServerRecoverableSQLPoolsServer            WorkspaceManagedSQLServerRecoverableSQLPoolsServer
	WorkspaceManagedSQLServerSecurityAlertPolicyServer            WorkspaceManagedSQLServerSecurityAlertPolicyServer
	WorkspaceManagedSQLServerUsagesServer                         WorkspaceManagedSQLServerUsagesServer
	WorkspaceManagedSQLServerVulnerabilityAssessmentsServer       WorkspaceManagedSQLServerVulnerabilityAssessmentsServer
	WorkspaceSQLAADAdminsServer                                   WorkspaceSQLAADAdminsServer
	WorkspacesServer                                              WorkspacesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armsynapse.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armsynapse.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                             *ServerFactory
	trMu                                                            sync.Mutex
	trAzureADOnlyAuthenticationsServer                              *AzureADOnlyAuthenticationsServerTransport
	trBigDataPoolsServer                                            *BigDataPoolsServerTransport
	trDataMaskingPoliciesServer                                     *DataMaskingPoliciesServerTransport
	trDataMaskingRulesServer                                        *DataMaskingRulesServerTransport
	trExtendedSQLPoolBlobAuditingPoliciesServer                     *ExtendedSQLPoolBlobAuditingPoliciesServerTransport
	trGetServer                                                     *GetServerTransport
	trIPFirewallRulesServer                                         *IPFirewallRulesServerTransport
	trIntegrationRuntimeAuthKeysServer                              *IntegrationRuntimeAuthKeysServerTransport
	trIntegrationRuntimeConnectionInfosServer                       *IntegrationRuntimeConnectionInfosServerTransport
	trIntegrationRuntimeCredentialsServer                           *IntegrationRuntimeCredentialsServerTransport
	trIntegrationRuntimeMonitoringDataServer                        *IntegrationRuntimeMonitoringDataServerTransport
	trIntegrationRuntimeNodeIPAddressServer                         *IntegrationRuntimeNodeIPAddressServerTransport
	trIntegrationRuntimeNodesServer                                 *IntegrationRuntimeNodesServerTransport
	trIntegrationRuntimeObjectMetadataServer                        *IntegrationRuntimeObjectMetadataServerTransport
	trIntegrationRuntimeStatusServer                                *IntegrationRuntimeStatusServerTransport
	trIntegrationRuntimesServer                                     *IntegrationRuntimesServerTransport
	trKeysServer                                                    *KeysServerTransport
	trKustoOperationsServer                                         *KustoOperationsServerTransport
	trKustoPoolAttachedDatabaseConfigurationsServer                 *KustoPoolAttachedDatabaseConfigurationsServerTransport
	trKustoPoolChildResourceServer                                  *KustoPoolChildResourceServerTransport
	trKustoPoolDataConnectionsServer                                *KustoPoolDataConnectionsServerTransport
	trKustoPoolDatabasePrincipalAssignmentsServer                   *KustoPoolDatabasePrincipalAssignmentsServerTransport
	trKustoPoolDatabasesServer                                      *KustoPoolDatabasesServerTransport
	trKustoPoolPrincipalAssignmentsServer                           *KustoPoolPrincipalAssignmentsServerTransport
	trKustoPoolPrivateLinkResourcesServer                           *KustoPoolPrivateLinkResourcesServerTransport
	trKustoPoolsServer                                              *KustoPoolsServerTransport
	trLibrariesServer                                               *LibrariesServerTransport
	trLibraryServer                                                 *LibraryServerTransport
	trOperationsServer                                              *OperationsServerTransport
	trPrivateEndpointConnectionsServer                              *PrivateEndpointConnectionsServerTransport
	trPrivateEndpointConnectionsPrivateLinkHubServer                *PrivateEndpointConnectionsPrivateLinkHubServerTransport
	trPrivateLinkHubPrivateLinkResourcesServer                      *PrivateLinkHubPrivateLinkResourcesServerTransport
	trPrivateLinkHubsServer                                         *PrivateLinkHubsServerTransport
	trPrivateLinkResourcesServer                                    *PrivateLinkResourcesServerTransport
	trRestorableDroppedSQLPoolsServer                               *RestorableDroppedSQLPoolsServerTransport
	trSQLPoolBlobAuditingPoliciesServer                             *SQLPoolBlobAuditingPoliciesServerTransport
	trSQLPoolColumnsServer                                          *SQLPoolColumnsServerTransport
	trSQLPoolConnectionPoliciesServer                               *SQLPoolConnectionPoliciesServerTransport
	trSQLPoolDataWarehouseUserActivitiesServer                      *SQLPoolDataWarehouseUserActivitiesServerTransport
	trSQLPoolGeoBackupPoliciesServer                                *SQLPoolGeoBackupPoliciesServerTransport
	trSQLPoolMaintenanceWindowOptionsServer                         *SQLPoolMaintenanceWindowOptionsServerTransport
	trSQLPoolMaintenanceWindowsServer                               *SQLPoolMaintenanceWindowsServerTransport
	trSQLPoolMetadataSyncConfigsServer                              *SQLPoolMetadataSyncConfigsServerTransport
	trSQLPoolOperationResultsServer                                 *SQLPoolOperationResultsServerTransport
	trSQLPoolOperationsServer                                       *SQLPoolOperationsServerTransport
	trSQLPoolRecommendedSensitivityLabelsServer                     *SQLPoolRecommendedSensitivityLabelsServerTransport
	trSQLPoolReplicationLinksServer                                 *SQLPoolReplicationLinksServerTransport
	trSQLPoolRestorePointsServer                                    *SQLPoolRestorePointsServerTransport
	trSQLPoolSchemasServer                                          *SQLPoolSchemasServerTransport
	trSQLPoolSecurityAlertPoliciesServer                            *SQLPoolSecurityAlertPoliciesServerTransport
	trSQLPoolSensitivityLabelsServer                                *SQLPoolSensitivityLabelsServerTransport
	trSQLPoolTableColumnsServer                                     *SQLPoolTableColumnsServerTransport
	trSQLPoolTablesServer                                           *SQLPoolTablesServerTransport
	trSQLPoolTransparentDataEncryptionsServer                       *SQLPoolTransparentDataEncryptionsServerTransport
	trSQLPoolUsagesServer                                           *SQLPoolUsagesServerTransport
	trSQLPoolVulnerabilityAssessmentRuleBaselinesServer             *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport
	trSQLPoolVulnerabilityAssessmentScansServer                     *SQLPoolVulnerabilityAssessmentScansServerTransport
	trSQLPoolVulnerabilityAssessmentsServer                         *SQLPoolVulnerabilityAssessmentsServerTransport
	trSQLPoolWorkloadClassifierServer                               *SQLPoolWorkloadClassifierServerTransport
	trSQLPoolWorkloadGroupServer                                    *SQLPoolWorkloadGroupServerTransport
	trSQLPoolsServer                                                *SQLPoolsServerTransport
	trSparkConfigurationServer                                      *SparkConfigurationServerTransport
	trSparkConfigurationsServer                                     *SparkConfigurationsServerTransport
	trWorkspaceAADAdminsServer                                      *WorkspaceAADAdminsServerTransport
	trWorkspaceManagedIdentitySQLControlSettingsServer              *WorkspaceManagedIdentitySQLControlSettingsServerTransport
	trWorkspaceManagedSQLServerBlobAuditingPoliciesServer           *WorkspaceManagedSQLServerBlobAuditingPoliciesServerTransport
	trWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServerTransport
	trWorkspaceManagedSQLServerEncryptionProtectorServer            *WorkspaceManagedSQLServerEncryptionProtectorServerTransport
	trWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer   *WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServerTransport
	trWorkspaceManagedSQLServerRecoverableSQLPoolsServer            *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport
	trWorkspaceManagedSQLServerSecurityAlertPolicyServer            *WorkspaceManagedSQLServerSecurityAlertPolicyServerTransport
	trWorkspaceManagedSQLServerUsagesServer                         *WorkspaceManagedSQLServerUsagesServerTransport
	trWorkspaceManagedSQLServerVulnerabilityAssessmentsServer       *WorkspaceManagedSQLServerVulnerabilityAssessmentsServerTransport
	trWorkspaceSQLAADAdminsServer                                   *WorkspaceSQLAADAdminsServerTransport
	trWorkspacesServer                                              *WorkspacesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AzureADOnlyAuthenticationsClient":
		initServer(s, &s.trAzureADOnlyAuthenticationsServer, func() *AzureADOnlyAuthenticationsServerTransport {
			return NewAzureADOnlyAuthenticationsServerTransport(&s.srv.AzureADOnlyAuthenticationsServer)
		})
		resp, err = s.trAzureADOnlyAuthenticationsServer.Do(req)
	case "BigDataPoolsClient":
		initServer(s, &s.trBigDataPoolsServer, func() *BigDataPoolsServerTransport { return NewBigDataPoolsServerTransport(&s.srv.BigDataPoolsServer) })
		resp, err = s.trBigDataPoolsServer.Do(req)
	case "DataMaskingPoliciesClient":
		initServer(s, &s.trDataMaskingPoliciesServer, func() *DataMaskingPoliciesServerTransport {
			return NewDataMaskingPoliciesServerTransport(&s.srv.DataMaskingPoliciesServer)
		})
		resp, err = s.trDataMaskingPoliciesServer.Do(req)
	case "DataMaskingRulesClient":
		initServer(s, &s.trDataMaskingRulesServer, func() *DataMaskingRulesServerTransport {
			return NewDataMaskingRulesServerTransport(&s.srv.DataMaskingRulesServer)
		})
		resp, err = s.trDataMaskingRulesServer.Do(req)
	case "ExtendedSQLPoolBlobAuditingPoliciesClient":
		initServer(s, &s.trExtendedSQLPoolBlobAuditingPoliciesServer, func() *ExtendedSQLPoolBlobAuditingPoliciesServerTransport {
			return NewExtendedSQLPoolBlobAuditingPoliciesServerTransport(&s.srv.ExtendedSQLPoolBlobAuditingPoliciesServer)
		})
		resp, err = s.trExtendedSQLPoolBlobAuditingPoliciesServer.Do(req)
	case "GetClient":
		initServer(s, &s.trGetServer, func() *GetServerTransport { return NewGetServerTransport(&s.srv.GetServer) })
		resp, err = s.trGetServer.Do(req)
	case "IPFirewallRulesClient":
		initServer(s, &s.trIPFirewallRulesServer, func() *IPFirewallRulesServerTransport {
			return NewIPFirewallRulesServerTransport(&s.srv.IPFirewallRulesServer)
		})
		resp, err = s.trIPFirewallRulesServer.Do(req)
	case "IntegrationRuntimeAuthKeysClient":
		initServer(s, &s.trIntegrationRuntimeAuthKeysServer, func() *IntegrationRuntimeAuthKeysServerTransport {
			return NewIntegrationRuntimeAuthKeysServerTransport(&s.srv.IntegrationRuntimeAuthKeysServer)
		})
		resp, err = s.trIntegrationRuntimeAuthKeysServer.Do(req)
	case "IntegrationRuntimeConnectionInfosClient":
		initServer(s, &s.trIntegrationRuntimeConnectionInfosServer, func() *IntegrationRuntimeConnectionInfosServerTransport {
			return NewIntegrationRuntimeConnectionInfosServerTransport(&s.srv.IntegrationRuntimeConnectionInfosServer)
		})
		resp, err = s.trIntegrationRuntimeConnectionInfosServer.Do(req)
	case "IntegrationRuntimeCredentialsClient":
		initServer(s, &s.trIntegrationRuntimeCredentialsServer, func() *IntegrationRuntimeCredentialsServerTransport {
			return NewIntegrationRuntimeCredentialsServerTransport(&s.srv.IntegrationRuntimeCredentialsServer)
		})
		resp, err = s.trIntegrationRuntimeCredentialsServer.Do(req)
	case "IntegrationRuntimeMonitoringDataClient":
		initServer(s, &s.trIntegrationRuntimeMonitoringDataServer, func() *IntegrationRuntimeMonitoringDataServerTransport {
			return NewIntegrationRuntimeMonitoringDataServerTransport(&s.srv.IntegrationRuntimeMonitoringDataServer)
		})
		resp, err = s.trIntegrationRuntimeMonitoringDataServer.Do(req)
	case "IntegrationRuntimeNodeIPAddressClient":
		initServer(s, &s.trIntegrationRuntimeNodeIPAddressServer, func() *IntegrationRuntimeNodeIPAddressServerTransport {
			return NewIntegrationRuntimeNodeIPAddressServerTransport(&s.srv.IntegrationRuntimeNodeIPAddressServer)
		})
		resp, err = s.trIntegrationRuntimeNodeIPAddressServer.Do(req)
	case "IntegrationRuntimeNodesClient":
		initServer(s, &s.trIntegrationRuntimeNodesServer, func() *IntegrationRuntimeNodesServerTransport {
			return NewIntegrationRuntimeNodesServerTransport(&s.srv.IntegrationRuntimeNodesServer)
		})
		resp, err = s.trIntegrationRuntimeNodesServer.Do(req)
	case "IntegrationRuntimeObjectMetadataClient":
		initServer(s, &s.trIntegrationRuntimeObjectMetadataServer, func() *IntegrationRuntimeObjectMetadataServerTransport {
			return NewIntegrationRuntimeObjectMetadataServerTransport(&s.srv.IntegrationRuntimeObjectMetadataServer)
		})
		resp, err = s.trIntegrationRuntimeObjectMetadataServer.Do(req)
	case "IntegrationRuntimeStatusClient":
		initServer(s, &s.trIntegrationRuntimeStatusServer, func() *IntegrationRuntimeStatusServerTransport {
			return NewIntegrationRuntimeStatusServerTransport(&s.srv.IntegrationRuntimeStatusServer)
		})
		resp, err = s.trIntegrationRuntimeStatusServer.Do(req)
	case "IntegrationRuntimesClient":
		initServer(s, &s.trIntegrationRuntimesServer, func() *IntegrationRuntimesServerTransport {
			return NewIntegrationRuntimesServerTransport(&s.srv.IntegrationRuntimesServer)
		})
		resp, err = s.trIntegrationRuntimesServer.Do(req)
	case "KeysClient":
		initServer(s, &s.trKeysServer, func() *KeysServerTransport { return NewKeysServerTransport(&s.srv.KeysServer) })
		resp, err = s.trKeysServer.Do(req)
	case "KustoOperationsClient":
		initServer(s, &s.trKustoOperationsServer, func() *KustoOperationsServerTransport {
			return NewKustoOperationsServerTransport(&s.srv.KustoOperationsServer)
		})
		resp, err = s.trKustoOperationsServer.Do(req)
	case "KustoPoolAttachedDatabaseConfigurationsClient":
		initServer(s, &s.trKustoPoolAttachedDatabaseConfigurationsServer, func() *KustoPoolAttachedDatabaseConfigurationsServerTransport {
			return NewKustoPoolAttachedDatabaseConfigurationsServerTransport(&s.srv.KustoPoolAttachedDatabaseConfigurationsServer)
		})
		resp, err = s.trKustoPoolAttachedDatabaseConfigurationsServer.Do(req)
	case "KustoPoolChildResourceClient":
		initServer(s, &s.trKustoPoolChildResourceServer, func() *KustoPoolChildResourceServerTransport {
			return NewKustoPoolChildResourceServerTransport(&s.srv.KustoPoolChildResourceServer)
		})
		resp, err = s.trKustoPoolChildResourceServer.Do(req)
	case "KustoPoolDataConnectionsClient":
		initServer(s, &s.trKustoPoolDataConnectionsServer, func() *KustoPoolDataConnectionsServerTransport {
			return NewKustoPoolDataConnectionsServerTransport(&s.srv.KustoPoolDataConnectionsServer)
		})
		resp, err = s.trKustoPoolDataConnectionsServer.Do(req)
	case "KustoPoolDatabasePrincipalAssignmentsClient":
		initServer(s, &s.trKustoPoolDatabasePrincipalAssignmentsServer, func() *KustoPoolDatabasePrincipalAssignmentsServerTransport {
			return NewKustoPoolDatabasePrincipalAssignmentsServerTransport(&s.srv.KustoPoolDatabasePrincipalAssignmentsServer)
		})
		resp, err = s.trKustoPoolDatabasePrincipalAssignmentsServer.Do(req)
	case "KustoPoolDatabasesClient":
		initServer(s, &s.trKustoPoolDatabasesServer, func() *KustoPoolDatabasesServerTransport {
			return NewKustoPoolDatabasesServerTransport(&s.srv.KustoPoolDatabasesServer)
		})
		resp, err = s.trKustoPoolDatabasesServer.Do(req)
	case "KustoPoolPrincipalAssignmentsClient":
		initServer(s, &s.trKustoPoolPrincipalAssignmentsServer, func() *KustoPoolPrincipalAssignmentsServerTransport {
			return NewKustoPoolPrincipalAssignmentsServerTransport(&s.srv.KustoPoolPrincipalAssignmentsServer)
		})
		resp, err = s.trKustoPoolPrincipalAssignmentsServer.Do(req)
	case "KustoPoolPrivateLinkResourcesClient":
		initServer(s, &s.trKustoPoolPrivateLinkResourcesServer, func() *KustoPoolPrivateLinkResourcesServerTransport {
			return NewKustoPoolPrivateLinkResourcesServerTransport(&s.srv.KustoPoolPrivateLinkResourcesServer)
		})
		resp, err = s.trKustoPoolPrivateLinkResourcesServer.Do(req)
	case "KustoPoolsClient":
		initServer(s, &s.trKustoPoolsServer, func() *KustoPoolsServerTransport { return NewKustoPoolsServerTransport(&s.srv.KustoPoolsServer) })
		resp, err = s.trKustoPoolsServer.Do(req)
	case "LibrariesClient":
		initServer(s, &s.trLibrariesServer, func() *LibrariesServerTransport { return NewLibrariesServerTransport(&s.srv.LibrariesServer) })
		resp, err = s.trLibrariesServer.Do(req)
	case "LibraryClient":
		initServer(s, &s.trLibraryServer, func() *LibraryServerTransport { return NewLibraryServerTransport(&s.srv.LibraryServer) })
		resp, err = s.trLibraryServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateEndpointConnectionsPrivateLinkHubClient":
		initServer(s, &s.trPrivateEndpointConnectionsPrivateLinkHubServer, func() *PrivateEndpointConnectionsPrivateLinkHubServerTransport {
			return NewPrivateEndpointConnectionsPrivateLinkHubServerTransport(&s.srv.PrivateEndpointConnectionsPrivateLinkHubServer)
		})
		resp, err = s.trPrivateEndpointConnectionsPrivateLinkHubServer.Do(req)
	case "PrivateLinkHubPrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkHubPrivateLinkResourcesServer, func() *PrivateLinkHubPrivateLinkResourcesServerTransport {
			return NewPrivateLinkHubPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkHubPrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkHubPrivateLinkResourcesServer.Do(req)
	case "PrivateLinkHubsClient":
		initServer(s, &s.trPrivateLinkHubsServer, func() *PrivateLinkHubsServerTransport {
			return NewPrivateLinkHubsServerTransport(&s.srv.PrivateLinkHubsServer)
		})
		resp, err = s.trPrivateLinkHubsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "RestorableDroppedSQLPoolsClient":
		initServer(s, &s.trRestorableDroppedSQLPoolsServer, func() *RestorableDroppedSQLPoolsServerTransport {
			return NewRestorableDroppedSQLPoolsServerTransport(&s.srv.RestorableDroppedSQLPoolsServer)
		})
		resp, err = s.trRestorableDroppedSQLPoolsServer.Do(req)
	case "SQLPoolBlobAuditingPoliciesClient":
		initServer(s, &s.trSQLPoolBlobAuditingPoliciesServer, func() *SQLPoolBlobAuditingPoliciesServerTransport {
			return NewSQLPoolBlobAuditingPoliciesServerTransport(&s.srv.SQLPoolBlobAuditingPoliciesServer)
		})
		resp, err = s.trSQLPoolBlobAuditingPoliciesServer.Do(req)
	case "SQLPoolColumnsClient":
		initServer(s, &s.trSQLPoolColumnsServer, func() *SQLPoolColumnsServerTransport {
			return NewSQLPoolColumnsServerTransport(&s.srv.SQLPoolColumnsServer)
		})
		resp, err = s.trSQLPoolColumnsServer.Do(req)
	case "SQLPoolConnectionPoliciesClient":
		initServer(s, &s.trSQLPoolConnectionPoliciesServer, func() *SQLPoolConnectionPoliciesServerTransport {
			return NewSQLPoolConnectionPoliciesServerTransport(&s.srv.SQLPoolConnectionPoliciesServer)
		})
		resp, err = s.trSQLPoolConnectionPoliciesServer.Do(req)
	case "SQLPoolDataWarehouseUserActivitiesClient":
		initServer(s, &s.trSQLPoolDataWarehouseUserActivitiesServer, func() *SQLPoolDataWarehouseUserActivitiesServerTransport {
			return NewSQLPoolDataWarehouseUserActivitiesServerTransport(&s.srv.SQLPoolDataWarehouseUserActivitiesServer)
		})
		resp, err = s.trSQLPoolDataWarehouseUserActivitiesServer.Do(req)
	case "SQLPoolGeoBackupPoliciesClient":
		initServer(s, &s.trSQLPoolGeoBackupPoliciesServer, func() *SQLPoolGeoBackupPoliciesServerTransport {
			return NewSQLPoolGeoBackupPoliciesServerTransport(&s.srv.SQLPoolGeoBackupPoliciesServer)
		})
		resp, err = s.trSQLPoolGeoBackupPoliciesServer.Do(req)
	case "SQLPoolMaintenanceWindowOptionsClient":
		initServer(s, &s.trSQLPoolMaintenanceWindowOptionsServer, func() *SQLPoolMaintenanceWindowOptionsServerTransport {
			return NewSQLPoolMaintenanceWindowOptionsServerTransport(&s.srv.SQLPoolMaintenanceWindowOptionsServer)
		})
		resp, err = s.trSQLPoolMaintenanceWindowOptionsServer.Do(req)
	case "SQLPoolMaintenanceWindowsClient":
		initServer(s, &s.trSQLPoolMaintenanceWindowsServer, func() *SQLPoolMaintenanceWindowsServerTransport {
			return NewSQLPoolMaintenanceWindowsServerTransport(&s.srv.SQLPoolMaintenanceWindowsServer)
		})
		resp, err = s.trSQLPoolMaintenanceWindowsServer.Do(req)
	case "SQLPoolMetadataSyncConfigsClient":
		initServer(s, &s.trSQLPoolMetadataSyncConfigsServer, func() *SQLPoolMetadataSyncConfigsServerTransport {
			return NewSQLPoolMetadataSyncConfigsServerTransport(&s.srv.SQLPoolMetadataSyncConfigsServer)
		})
		resp, err = s.trSQLPoolMetadataSyncConfigsServer.Do(req)
	case "SQLPoolOperationResultsClient":
		initServer(s, &s.trSQLPoolOperationResultsServer, func() *SQLPoolOperationResultsServerTransport {
			return NewSQLPoolOperationResultsServerTransport(&s.srv.SQLPoolOperationResultsServer)
		})
		resp, err = s.trSQLPoolOperationResultsServer.Do(req)
	case "SQLPoolOperationsClient":
		initServer(s, &s.trSQLPoolOperationsServer, func() *SQLPoolOperationsServerTransport {
			return NewSQLPoolOperationsServerTransport(&s.srv.SQLPoolOperationsServer)
		})
		resp, err = s.trSQLPoolOperationsServer.Do(req)
	case "SQLPoolRecommendedSensitivityLabelsClient":
		initServer(s, &s.trSQLPoolRecommendedSensitivityLabelsServer, func() *SQLPoolRecommendedSensitivityLabelsServerTransport {
			return NewSQLPoolRecommendedSensitivityLabelsServerTransport(&s.srv.SQLPoolRecommendedSensitivityLabelsServer)
		})
		resp, err = s.trSQLPoolRecommendedSensitivityLabelsServer.Do(req)
	case "SQLPoolReplicationLinksClient":
		initServer(s, &s.trSQLPoolReplicationLinksServer, func() *SQLPoolReplicationLinksServerTransport {
			return NewSQLPoolReplicationLinksServerTransport(&s.srv.SQLPoolReplicationLinksServer)
		})
		resp, err = s.trSQLPoolReplicationLinksServer.Do(req)
	case "SQLPoolRestorePointsClient":
		initServer(s, &s.trSQLPoolRestorePointsServer, func() *SQLPoolRestorePointsServerTransport {
			return NewSQLPoolRestorePointsServerTransport(&s.srv.SQLPoolRestorePointsServer)
		})
		resp, err = s.trSQLPoolRestorePointsServer.Do(req)
	case "SQLPoolSchemasClient":
		initServer(s, &s.trSQLPoolSchemasServer, func() *SQLPoolSchemasServerTransport {
			return NewSQLPoolSchemasServerTransport(&s.srv.SQLPoolSchemasServer)
		})
		resp, err = s.trSQLPoolSchemasServer.Do(req)
	case "SQLPoolSecurityAlertPoliciesClient":
		initServer(s, &s.trSQLPoolSecurityAlertPoliciesServer, func() *SQLPoolSecurityAlertPoliciesServerTransport {
			return NewSQLPoolSecurityAlertPoliciesServerTransport(&s.srv.SQLPoolSecurityAlertPoliciesServer)
		})
		resp, err = s.trSQLPoolSecurityAlertPoliciesServer.Do(req)
	case "SQLPoolSensitivityLabelsClient":
		initServer(s, &s.trSQLPoolSensitivityLabelsServer, func() *SQLPoolSensitivityLabelsServerTransport {
			return NewSQLPoolSensitivityLabelsServerTransport(&s.srv.SQLPoolSensitivityLabelsServer)
		})
		resp, err = s.trSQLPoolSensitivityLabelsServer.Do(req)
	case "SQLPoolTableColumnsClient":
		initServer(s, &s.trSQLPoolTableColumnsServer, func() *SQLPoolTableColumnsServerTransport {
			return NewSQLPoolTableColumnsServerTransport(&s.srv.SQLPoolTableColumnsServer)
		})
		resp, err = s.trSQLPoolTableColumnsServer.Do(req)
	case "SQLPoolTablesClient":
		initServer(s, &s.trSQLPoolTablesServer, func() *SQLPoolTablesServerTransport {
			return NewSQLPoolTablesServerTransport(&s.srv.SQLPoolTablesServer)
		})
		resp, err = s.trSQLPoolTablesServer.Do(req)
	case "SQLPoolTransparentDataEncryptionsClient":
		initServer(s, &s.trSQLPoolTransparentDataEncryptionsServer, func() *SQLPoolTransparentDataEncryptionsServerTransport {
			return NewSQLPoolTransparentDataEncryptionsServerTransport(&s.srv.SQLPoolTransparentDataEncryptionsServer)
		})
		resp, err = s.trSQLPoolTransparentDataEncryptionsServer.Do(req)
	case "SQLPoolUsagesClient":
		initServer(s, &s.trSQLPoolUsagesServer, func() *SQLPoolUsagesServerTransport {
			return NewSQLPoolUsagesServerTransport(&s.srv.SQLPoolUsagesServer)
		})
		resp, err = s.trSQLPoolUsagesServer.Do(req)
	case "SQLPoolVulnerabilityAssessmentRuleBaselinesClient":
		initServer(s, &s.trSQLPoolVulnerabilityAssessmentRuleBaselinesServer, func() *SQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport {
			return NewSQLPoolVulnerabilityAssessmentRuleBaselinesServerTransport(&s.srv.SQLPoolVulnerabilityAssessmentRuleBaselinesServer)
		})
		resp, err = s.trSQLPoolVulnerabilityAssessmentRuleBaselinesServer.Do(req)
	case "SQLPoolVulnerabilityAssessmentScansClient":
		initServer(s, &s.trSQLPoolVulnerabilityAssessmentScansServer, func() *SQLPoolVulnerabilityAssessmentScansServerTransport {
			return NewSQLPoolVulnerabilityAssessmentScansServerTransport(&s.srv.SQLPoolVulnerabilityAssessmentScansServer)
		})
		resp, err = s.trSQLPoolVulnerabilityAssessmentScansServer.Do(req)
	case "SQLPoolVulnerabilityAssessmentsClient":
		initServer(s, &s.trSQLPoolVulnerabilityAssessmentsServer, func() *SQLPoolVulnerabilityAssessmentsServerTransport {
			return NewSQLPoolVulnerabilityAssessmentsServerTransport(&s.srv.SQLPoolVulnerabilityAssessmentsServer)
		})
		resp, err = s.trSQLPoolVulnerabilityAssessmentsServer.Do(req)
	case "SQLPoolWorkloadClassifierClient":
		initServer(s, &s.trSQLPoolWorkloadClassifierServer, func() *SQLPoolWorkloadClassifierServerTransport {
			return NewSQLPoolWorkloadClassifierServerTransport(&s.srv.SQLPoolWorkloadClassifierServer)
		})
		resp, err = s.trSQLPoolWorkloadClassifierServer.Do(req)
	case "SQLPoolWorkloadGroupClient":
		initServer(s, &s.trSQLPoolWorkloadGroupServer, func() *SQLPoolWorkloadGroupServerTransport {
			return NewSQLPoolWorkloadGroupServerTransport(&s.srv.SQLPoolWorkloadGroupServer)
		})
		resp, err = s.trSQLPoolWorkloadGroupServer.Do(req)
	case "SQLPoolsClient":
		initServer(s, &s.trSQLPoolsServer, func() *SQLPoolsServerTransport { return NewSQLPoolsServerTransport(&s.srv.SQLPoolsServer) })
		resp, err = s.trSQLPoolsServer.Do(req)
	case "SparkConfigurationClient":
		initServer(s, &s.trSparkConfigurationServer, func() *SparkConfigurationServerTransport {
			return NewSparkConfigurationServerTransport(&s.srv.SparkConfigurationServer)
		})
		resp, err = s.trSparkConfigurationServer.Do(req)
	case "SparkConfigurationsClient":
		initServer(s, &s.trSparkConfigurationsServer, func() *SparkConfigurationsServerTransport {
			return NewSparkConfigurationsServerTransport(&s.srv.SparkConfigurationsServer)
		})
		resp, err = s.trSparkConfigurationsServer.Do(req)
	case "WorkspaceAADAdminsClient":
		initServer(s, &s.trWorkspaceAADAdminsServer, func() *WorkspaceAADAdminsServerTransport {
			return NewWorkspaceAADAdminsServerTransport(&s.srv.WorkspaceAADAdminsServer)
		})
		resp, err = s.trWorkspaceAADAdminsServer.Do(req)
	case "WorkspaceManagedIdentitySQLControlSettingsClient":
		initServer(s, &s.trWorkspaceManagedIdentitySQLControlSettingsServer, func() *WorkspaceManagedIdentitySQLControlSettingsServerTransport {
			return NewWorkspaceManagedIdentitySQLControlSettingsServerTransport(&s.srv.WorkspaceManagedIdentitySQLControlSettingsServer)
		})
		resp, err = s.trWorkspaceManagedIdentitySQLControlSettingsServer.Do(req)
	case "WorkspaceManagedSQLServerBlobAuditingPoliciesClient":
		initServer(s, &s.trWorkspaceManagedSQLServerBlobAuditingPoliciesServer, func() *WorkspaceManagedSQLServerBlobAuditingPoliciesServerTransport {
			return NewWorkspaceManagedSQLServerBlobAuditingPoliciesServerTransport(&s.srv.WorkspaceManagedSQLServerBlobAuditingPoliciesServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerBlobAuditingPoliciesServer.Do(req)
	case "WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient":
		initServer(s, &s.trWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer, func() *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServerTransport {
			return NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServerTransport(&s.srv.WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsServer.Do(req)
	case "WorkspaceManagedSQLServerEncryptionProtectorClient":
		initServer(s, &s.trWorkspaceManagedSQLServerEncryptionProtectorServer, func() *WorkspaceManagedSQLServerEncryptionProtectorServerTransport {
			return NewWorkspaceManagedSQLServerEncryptionProtectorServerTransport(&s.srv.WorkspaceManagedSQLServerEncryptionProtectorServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerEncryptionProtectorServer.Do(req)
	case "WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient":
		initServer(s, &s.trWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer, func() *WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServerTransport {
			return NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServerTransport(&s.srv.WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesServer.Do(req)
	case "WorkspaceManagedSQLServerRecoverableSQLPoolsClient":
		initServer(s, &s.trWorkspaceManagedSQLServerRecoverableSQLPoolsServer, func() *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport {
			return NewWorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport(&s.srv.WorkspaceManagedSQLServerRecoverableSQLPoolsServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerRecoverableSQLPoolsServer.Do(req)
	case "WorkspaceManagedSQLServerSecurityAlertPolicyClient":
		initServer(s, &s.trWorkspaceManagedSQLServerSecurityAlertPolicyServer, func() *WorkspaceManagedSQLServerSecurityAlertPolicyServerTransport {
			return NewWorkspaceManagedSQLServerSecurityAlertPolicyServerTransport(&s.srv.WorkspaceManagedSQLServerSecurityAlertPolicyServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerSecurityAlertPolicyServer.Do(req)
	case "WorkspaceManagedSQLServerUsagesClient":
		initServer(s, &s.trWorkspaceManagedSQLServerUsagesServer, func() *WorkspaceManagedSQLServerUsagesServerTransport {
			return NewWorkspaceManagedSQLServerUsagesServerTransport(&s.srv.WorkspaceManagedSQLServerUsagesServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerUsagesServer.Do(req)
	case "WorkspaceManagedSQLServerVulnerabilityAssessmentsClient":
		initServer(s, &s.trWorkspaceManagedSQLServerVulnerabilityAssessmentsServer, func() *WorkspaceManagedSQLServerVulnerabilityAssessmentsServerTransport {
			return NewWorkspaceManagedSQLServerVulnerabilityAssessmentsServerTransport(&s.srv.WorkspaceManagedSQLServerVulnerabilityAssessmentsServer)
		})
		resp, err = s.trWorkspaceManagedSQLServerVulnerabilityAssessmentsServer.Do(req)
	case "WorkspaceSQLAADAdminsClient":
		initServer(s, &s.trWorkspaceSQLAADAdminsServer, func() *WorkspaceSQLAADAdminsServerTransport {
			return NewWorkspaceSQLAADAdminsServerTransport(&s.srv.WorkspaceSQLAADAdminsServer)
		})
		resp, err = s.trWorkspaceSQLAADAdminsServer.Do(req)
	case "WorkspacesClient":
		initServer(s, &s.trWorkspacesServer, func() *WorkspacesServerTransport { return NewWorkspacesServerTransport(&s.srv.WorkspacesServer) })
		resp, err = s.trWorkspacesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
