//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import "time"

// AccessKeyInfoBase - The access key directly from target resource properties, which target service is Azure Resource, such
// as Microsoft.Storage
type AccessKeyInfoBase struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Permissions of the accessKey. Read and Write are for Azure Cosmos DB and Azure App Configuration, Listen, Send and Manage
	// are for Azure Event Hub and Azure Service Bus.
	Permissions []*AccessKeyPermissions
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type AccessKeyInfoBase.
func (a *AccessKeyInfoBase) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: a.AuthMode,
		AuthType: a.AuthType,
	}
}

// AuthInfoBase - The authentication info
type AuthInfoBase struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type AuthInfoBase.
func (a *AuthInfoBase) GetAuthInfoBase() *AuthInfoBase { return a }

// AzureKeyVaultProperties - The resource properties when type is Azure Key Vault
type AzureKeyVaultProperties struct {
	// REQUIRED; The azure resource type.
	Type *AzureResourceType

	// True if connect via Kubernetes CSI Driver.
	ConnectAsKubernetesCsiDriver *bool
}

// GetAzureResourcePropertiesBase implements the AzureResourcePropertiesBaseClassification interface for type AzureKeyVaultProperties.
func (a *AzureKeyVaultProperties) GetAzureResourcePropertiesBase() *AzureResourcePropertiesBase {
	return &AzureResourcePropertiesBase{
		Type: a.Type,
	}
}

// AzureResource - The azure resource info when target service type is AzureResource
type AzureResource struct {
	// REQUIRED; The target service type.
	Type *TargetServiceType

	// The Id of azure resource.
	ID *string

	// The azure resource connection related properties.
	ResourceProperties AzureResourcePropertiesBaseClassification
}

// GetTargetServiceBase implements the TargetServiceBaseClassification interface for type AzureResource.
func (a *AzureResource) GetTargetServiceBase() *TargetServiceBase {
	return &TargetServiceBase{
		Type: a.Type,
	}
}

// AzureResourcePropertiesBase - The azure resource properties
type AzureResourcePropertiesBase struct {
	// REQUIRED; The azure resource type.
	Type *AzureResourceType
}

// GetAzureResourcePropertiesBase implements the AzureResourcePropertiesBaseClassification interface for type AzureResourcePropertiesBase.
func (a *AzureResourcePropertiesBase) GetAzureResourcePropertiesBase() *AzureResourcePropertiesBase {
	return a
}

// BasicErrorDryrunPrerequisiteResult - The represent of basic error
type BasicErrorDryrunPrerequisiteResult struct {
	// REQUIRED; The type of dryrun result.
	Type *DryrunPrerequisiteResultType

	// The error code.
	Code *string

	// The error message.
	Message *string
}

// GetDryrunPrerequisiteResult implements the DryrunPrerequisiteResultClassification interface for type BasicErrorDryrunPrerequisiteResult.
func (b *BasicErrorDryrunPrerequisiteResult) GetDryrunPrerequisiteResult() *DryrunPrerequisiteResult {
	return &DryrunPrerequisiteResult{
		Type: b.Type,
	}
}

// ConfigurationInfo - The configuration information, used to generate configurations or save to applications
type ConfigurationInfo struct {
	// Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied
	// to the source application. Default is enable. If optOut, no configuration
	// change will be made on source.
	Action *ActionType

	// A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this
	// property is to full fill more customized configurations
	AdditionalConfigurations map[string]*string

	// A dictionary of additional properties to be added in the end of connection string.
	AdditionalConnectionStringProperties map[string]*string

	// An option to store configuration into different place
	ConfigurationStore *ConfigurationStore

	// Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be
	// used for generate configurations
	CustomizedKeys map[string]*string

	// Indicates some additional properties for dapr client type
	DaprProperties *DaprProperties

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior
}

// ConfigurationName - The configuration names.
type ConfigurationName struct {
	// Description for the configuration name.
	Description *string

	// Represent the configuration is required or not
	Required *bool
	Value    *string
}

type ConfigurationNameItem struct {
	// The result detail.
	Properties *ConfigurationNames
}

// ConfigurationNameResult - Configuration Name list which will be set based on different target resource, client type, auth
// type.
type ConfigurationNameResult struct {
	// Expected configuration names for each target service.
	Value []*ConfigurationNameItem

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ConfigurationNames - The configuration names which will be set based on specific target resource, client type, auth type.
type ConfigurationNames struct {
	// The auth type.
	AuthType *AuthType

	// The client type for configuration names.
	ClientType *ClientType

	// Deprecated, please use #/definitions/DaprConfigurationList instead
	DaprProperties *DaprProperties

	// The configuration names to be set in compute service environment.
	Names []*ConfigurationName

	// Indicates where the secrets in configuration from. Used when secrets are from Keyvault.
	SecretType *SecretSourceType

	// The target service provider name and resource name.
	TargetService *string
}

// ConfigurationResult - Configurations for source resource, include appSettings, connectionString and serviceBindings
type ConfigurationResult struct {
	// The configuration properties for source resource.
	Configurations []*SourceConfiguration
}

// ConfigurationStore - An option to store configuration into different place
type ConfigurationStore struct {
	// The app configuration id to store configuration
	AppConfigurationID *string
}

// ConfluentBootstrapServer - The service properties when target service type is ConfluentBootstrapServer
type ConfluentBootstrapServer struct {
	// REQUIRED; The target service type.
	Type *TargetServiceType

	// The endpoint of service.
	Endpoint *string
}

// GetTargetServiceBase implements the TargetServiceBaseClassification interface for type ConfluentBootstrapServer.
func (c *ConfluentBootstrapServer) GetTargetServiceBase() *TargetServiceBase {
	return &TargetServiceBase{
		Type: c.Type,
	}
}

// ConfluentSchemaRegistry - The service properties when target service type is ConfluentSchemaRegistry
type ConfluentSchemaRegistry struct {
	// REQUIRED; The target service type.
	Type *TargetServiceType

	// The endpoint of service.
	Endpoint *string
}

// GetTargetServiceBase implements the TargetServiceBaseClassification interface for type ConfluentSchemaRegistry.
func (c *ConfluentSchemaRegistry) GetTargetServiceBase() *TargetServiceBase {
	return &TargetServiceBase{
		Type: c.Type,
	}
}

// CreateOrUpdateDryrunParameters - The dryrun parameters for creation or update a linker
type CreateOrUpdateDryrunParameters struct {
	// REQUIRED; The name of action for you dryrun job.
	ActionName *DryrunActionName

	// The authentication type.
	AuthInfo AuthInfoBaseClassification

	// The application client type
	ClientType *ClientType

	// The connection information consumed by applications, including secrets, connection strings.
	ConfigurationInfo *ConfigurationInfo

	// The network solution.
	PublicNetworkSolution *PublicNetworkSolution

	// connection scope in source service.
	Scope *string

	// An option to store secret value in secure place
	SecretStore *SecretStore

	// The target service properties
	TargetService TargetServiceBaseClassification

	// The VNet solution.
	VNetSolution *VNetSolution

	// READ-ONLY; The provisioning state.
	ProvisioningState *string
}

// GetDryrunParameters implements the DryrunParametersClassification interface for type CreateOrUpdateDryrunParameters.
func (c *CreateOrUpdateDryrunParameters) GetDryrunParameters() *DryrunParameters {
	return &DryrunParameters{
		ActionName: c.ActionName,
	}
}

// DaprConfigurationList - Dapr configuration list supported by Service Connector
type DaprConfigurationList struct {
	// The list of dapr configurations
	Value []*DaprConfigurationResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

type DaprConfigurationProperties struct {
	// The authentication type.
	AuthType *AuthType

	// Indicates some additional properties for dapr client type
	DaprProperties *DaprProperties

	// Supported target resource type, extract from resource id, uppercase
	TargetType *string
}

// DaprConfigurationResource - Represent one resource of the dapr configuration list
type DaprConfigurationResource struct {
	// The properties of the dapr configuration.
	Properties *DaprConfigurationProperties
}

// DaprMetadata - The dapr component metadata.
type DaprMetadata struct {
	// The description of the metadata, returned from configuration api
	Description *string

	// Metadata property name.
	Name *string

	// The value indicating whether the metadata is required or not
	Required *DaprMetadataRequired

	// The secret name where dapr could get value
	SecretRef *string

	// Metadata property value.
	Value *string
}

// DaprProperties - Indicates some additional properties for dapr client type
type DaprProperties struct {
	// The dapr component type
	ComponentType *string

	// Additional dapr metadata
	Metadata []*DaprMetadata

	// The dapr component scopes
	Scopes []*string

	// The name of a secret store dapr to retrieve secret
	SecretStoreComponent *string

	// The dapr component version
	Version *string

	// READ-ONLY; The direction supported by the dapr binding component
	BindingComponentDirection *DaprBindingComponentDirection

	// READ-ONLY; The runtime version supported by the properties
	RuntimeVersion *string
}

// DatabaseAADAuthInfo - The extra auth info required by Database AAD authentication.
type DatabaseAADAuthInfo struct {
	// Username created in the database which is mapped to a user in AAD.
	UserName *string
}

// DryrunList - The list of dryrun.
type DryrunList struct {
	// The link used to get the next page of dryrun list.
	NextLink *string

	// The list of dryrun.
	Value []*DryrunResource
}

// DryrunOperationPreview - The preview of the operations for creation
type DryrunOperationPreview struct {
	// The action defined by RBAC, refer https://docs.microsoft.com/azure/role-based-access-control/role-definitions#actions-format
	Action *string

	// The description of the operation
	Description *string

	// The operation name
	Name *string

	// The operation type
	OperationType *DryrunPreviewOperationType

	// The scope of the operation, refer https://docs.microsoft.com/azure/role-based-access-control/scope-overview
	Scope *string
}

// DryrunParameters - The parameters of the dryrun
type DryrunParameters struct {
	// REQUIRED; The name of action for you dryrun job.
	ActionName *DryrunActionName
}

// GetDryrunParameters implements the DryrunParametersClassification interface for type DryrunParameters.
func (d *DryrunParameters) GetDryrunParameters() *DryrunParameters { return d }

// DryrunPatch - a dryrun job to be updated.
type DryrunPatch struct {
	// The properties of the dryrun job.
	Properties *DryrunProperties
}

// DryrunPrerequisiteResult - A result of dryrun
type DryrunPrerequisiteResult struct {
	// REQUIRED; The type of dryrun result.
	Type *DryrunPrerequisiteResultType
}

// GetDryrunPrerequisiteResult implements the DryrunPrerequisiteResultClassification interface for type DryrunPrerequisiteResult.
func (d *DryrunPrerequisiteResult) GetDryrunPrerequisiteResult() *DryrunPrerequisiteResult { return d }

// DryrunProperties - The properties of the dryrun job
type DryrunProperties struct {
	// The parameters of the dryrun
	Parameters DryrunParametersClassification

	// READ-ONLY; the preview of the operations for creation
	OperationPreviews []*DryrunOperationPreview

	// READ-ONLY; the result of the dryrun
	PrerequisiteResults []DryrunPrerequisiteResultClassification

	// READ-ONLY; The provisioning state.
	ProvisioningState *string
}

// DryrunResource - a dryrun job resource
type DryrunResource struct {
	// The properties of the dryrun job.
	Properties *DryrunProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EasyAuthMicrosoftEntraIDAuthInfo - The authentication info when authType is EasyAuth Microsoft Entra ID
type EasyAuthMicrosoftEntraIDAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Application clientId for EasyAuth Microsoft Entra ID.
	ClientID *string

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Application Secret for EasyAuth Microsoft Entra ID.
	Secret *string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type EasyAuthMicrosoftEntraIDAuthInfo.
func (e *EasyAuthMicrosoftEntraIDAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: e.AuthMode,
		AuthType: e.AuthType,
	}
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// FirewallRules - Target service's firewall rules. to allow connections from source service.
type FirewallRules struct {
	// Allow Azure services to access the target service if true.
	AzureServices *AllowType

	// Allow caller client IP to access the target service if true. the property is used when connecting local application to
	// target service.
	CallerClientIP *AllowType

	// This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client
	// IPs for a given database account.
	IPRanges []*string
}

// KeyVaultSecretReferenceSecretInfo - The secret info when type is keyVaultSecretReference. It's for scenario that user provides
// a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to
// secretStore.keyVaultId.
type KeyVaultSecretReferenceSecretInfo struct {
	// REQUIRED; The secret type.
	SecretType *SecretType

	// Name of the Key Vault secret.
	Name *string

	// Version of the Key Vault secret.
	Version *string
}

// GetSecretInfoBase implements the SecretInfoBaseClassification interface for type KeyVaultSecretReferenceSecretInfo.
func (k *KeyVaultSecretReferenceSecretInfo) GetSecretInfoBase() *SecretInfoBase {
	return &SecretInfoBase{
		SecretType: k.SecretType,
	}
}

// KeyVaultSecretURISecretInfo - The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret
// stored in user's keyvault and source is Web App, Spring Cloud or Container App.
type KeyVaultSecretURISecretInfo struct {
	// REQUIRED; The secret type.
	SecretType *SecretType

	// URI to the keyvault secret
	Value *string
}

// GetSecretInfoBase implements the SecretInfoBaseClassification interface for type KeyVaultSecretURISecretInfo.
func (k *KeyVaultSecretURISecretInfo) GetSecretInfoBase() *SecretInfoBase {
	return &SecretInfoBase{
		SecretType: k.SecretType,
	}
}

// LinkerPatch - A Linker to be updated.
type LinkerPatch struct {
	// Linker properties
	Properties *LinkerProperties
}

// LinkerProperties - The properties of the Linker.
type LinkerProperties struct {
	// The authentication type.
	AuthInfo AuthInfoBaseClassification

	// The application client type
	ClientType *ClientType

	// The connection information consumed by applications, including secrets, connection strings.
	ConfigurationInfo *ConfigurationInfo

	// The network solution.
	PublicNetworkSolution *PublicNetworkSolution

	// connection scope in source service.
	Scope *string

	// An option to store secret value in secure place
	SecretStore *SecretStore

	// The target service properties
	TargetService TargetServiceBaseClassification

	// The VNet solution.
	VNetSolution *VNetSolution

	// READ-ONLY; The provisioning state.
	ProvisioningState *string
}

// LinkerResource - Linker of source and target resource
type LinkerResource struct {
	// REQUIRED; The properties of the Linker.
	Properties *LinkerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// PermissionsMissingDryrunPrerequisiteResult - The represent of missing permissions
type PermissionsMissingDryrunPrerequisiteResult struct {
	// REQUIRED; The type of dryrun result.
	Type *DryrunPrerequisiteResultType

	// The permission list
	Permissions []*string

	// The recommended role to resolve permissions missing
	RecommendedRole *string

	// The permission scope
	Scope *string
}

// GetDryrunPrerequisiteResult implements the DryrunPrerequisiteResultClassification interface for type PermissionsMissingDryrunPrerequisiteResult.
func (p *PermissionsMissingDryrunPrerequisiteResult) GetDryrunPrerequisiteResult() *DryrunPrerequisiteResult {
	return &DryrunPrerequisiteResult{
		Type: p.Type,
	}
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PublicNetworkSolution - Indicates public network solution, include firewall rules
type PublicNetworkSolution struct {
	// Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default
	// is enable. If optOut, opt out public network access configuration.
	Action *ActionType

	// Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Describe firewall rules of target service to make sure source application could connect to the target.
	FirewallRules *FirewallRules
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceList - The list of Linker.
type ResourceList struct {
	// The Linker used to get the next page of Linker list.
	NextLink *string

	// The list of Linkers.
	Value []*LinkerResource
}

// SecretAuthInfo - The authentication info when authType is secret
type SecretAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Username or account name for secret auth.
	Name *string

	// Password or key vault secret for secret auth.
	SecretInfo SecretInfoBaseClassification
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type SecretAuthInfo.
func (s *SecretAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: s.AuthMode,
		AuthType: s.AuthType,
	}
}

// SecretInfoBase - The secret info
type SecretInfoBase struct {
	// REQUIRED; The secret type.
	SecretType *SecretType
}

// GetSecretInfoBase implements the SecretInfoBaseClassification interface for type SecretInfoBase.
func (s *SecretInfoBase) GetSecretInfoBase() *SecretInfoBase { return s }

// SecretStore - An option to store secret value in secure place
type SecretStore struct {
	// The key vault id to store secret
	KeyVaultID *string

	// The key vault secret name to store secret, only valid when storing one secret
	KeyVaultSecretName *string
}

// SelfHostedServer - The service properties when target service type is SelfHostedServer
type SelfHostedServer struct {
	// REQUIRED; The target service type.
	Type *TargetServiceType

	// The endpoint of service.
	Endpoint *string
}

// GetTargetServiceBase implements the TargetServiceBaseClassification interface for type SelfHostedServer.
func (s *SelfHostedServer) GetTargetServiceBase() *TargetServiceBase {
	return &TargetServiceBase{
		Type: s.Type,
	}
}

// ServicePrincipalCertificateAuthInfo - The authentication info when authType is servicePrincipal certificate
type ServicePrincipalCertificateAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// REQUIRED; ServicePrincipal certificate for servicePrincipal auth.
	Certificate *string

	// REQUIRED; Application clientId for servicePrincipal auth.
	ClientID *string

	// REQUIRED; Principal Id for servicePrincipal auth.
	PrincipalID *string

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Optional, this value specifies the Azure roles to be assigned. Automatically
	Roles []*string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type ServicePrincipalCertificateAuthInfo.
func (s *ServicePrincipalCertificateAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: s.AuthMode,
		AuthType: s.AuthType,
	}
}

// ServicePrincipalSecretAuthInfo - The authentication info when authType is servicePrincipal secret
type ServicePrincipalSecretAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// REQUIRED; ServicePrincipal application clientId for servicePrincipal auth.
	ClientID *string

	// REQUIRED; Principal Id for servicePrincipal auth.
	PrincipalID *string

	// REQUIRED; Secret for servicePrincipal auth.
	Secret *string

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Optional, this value specifies the Azure roles to be assigned. Automatically
	Roles []*string

	// Username created in the database which is mapped to a user in AAD.
	UserName *string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type ServicePrincipalSecretAuthInfo.
func (s *ServicePrincipalSecretAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: s.AuthMode,
		AuthType: s.AuthType,
	}
}

// SourceConfiguration - A configuration item for source resource
type SourceConfiguration struct {
	// Descriptive information for the configuration
	Description *string

	// The identity for key vault reference, system or user-assigned managed identity ID
	KeyVaultReferenceIdentity *string

	// The name of setting.
	Name *string

	// The value of setting
	Value *string

	// READ-ONLY; The type of setting
	ConfigType *LinkerConfigurationType
}

// SystemAssignedIdentityAuthInfo - The authentication info when authType is systemAssignedIdentity
type SystemAssignedIdentityAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Optional, this value specifies the Azure role to be assigned
	Roles []*string

	// Username created in the database which is mapped to a user in AAD.
	UserName *string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type SystemAssignedIdentityAuthInfo.
func (s *SystemAssignedIdentityAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: s.AuthMode,
		AuthType: s.AuthType,
	}
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TargetServiceBase - The target service properties
type TargetServiceBase struct {
	// REQUIRED; The target service type.
	Type *TargetServiceType
}

// GetTargetServiceBase implements the TargetServiceBaseClassification interface for type TargetServiceBase.
func (t *TargetServiceBase) GetTargetServiceBase() *TargetServiceBase { return t }

// UserAccountAuthInfo - The authentication info when authType is user account
type UserAccountAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Principal Id for user account.
	PrincipalID *string

	// Optional, this value specifies the Azure roles to be assigned. Automatically
	Roles []*string

	// Username created in the database which is mapped to a user in AAD.
	UserName *string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type UserAccountAuthInfo.
func (u *UserAccountAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: u.AuthMode,
		AuthType: u.AuthType,
	}
}

// UserAssignedIdentityAuthInfo - The authentication info when authType is userAssignedIdentity
type UserAssignedIdentityAuthInfo struct {
	// REQUIRED; The authentication type.
	AuthType *AuthType

	// Optional. Indicates how to configure authentication. If optInAllAuth, service linker configures authentication such as
	// enabling identity on source resource and granting RBAC roles. If optOutAllAuth,
	// opt out authentication setup. Default is optInAllAuth.
	AuthMode *AuthMode

	// Client Id for userAssignedIdentity.
	ClientID *string

	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Optional, this value specifies the Azure role to be assigned
	Roles []*string

	// Subscription id for userAssignedIdentity.
	SubscriptionID *string

	// Username created in the database which is mapped to a user in AAD.
	UserName *string
}

// GetAuthInfoBase implements the AuthInfoBaseClassification interface for type UserAssignedIdentityAuthInfo.
func (u *UserAssignedIdentityAuthInfo) GetAuthInfoBase() *AuthInfoBase {
	return &AuthInfoBase{
		AuthMode: u.AuthMode,
		AuthType: u.AuthType,
	}
}

// VNetSolution - The VNet solution for linker
type VNetSolution struct {
	// Indicates whether to clean up previous operation when Linker is updating or deleting
	DeleteOrUpdateBehavior *DeleteOrUpdateBehavior

	// Type of VNet solution.
	Type *VNetSolutionType
}

// ValidateOperationResult - The validation operation result for a Linker.
type ValidateOperationResult struct {
	// The validation result detail.
	Properties *ValidateResult

	// Validated Linker id.
	ResourceID *string

	// Validation operation status.
	Status *string
}

// ValidateResult - The validation result for a Linker.
type ValidateResult struct {
	// The authentication type.
	AuthType *AuthType

	// A boolean value indicating whether the connection is available or not
	IsConnectionAvailable *bool

	// The linker name.
	LinkerName *string

	// The end time of the validation report.
	ReportEndTimeUTC *time.Time

	// The start time of the validation report.
	ReportStartTimeUTC *time.Time

	// The resource id of the Linker source application.
	SourceID *string

	// The resource Id of target service.
	TargetID *string

	// The detail of validation result
	ValidationDetail []*ValidationResultItem
}

// ValidationResultItem - The validation item for a Linker.
type ValidationResultItem struct {
	// The display name of validation item
	Description *string

	// The error code of validation result
	ErrorCode *string

	// The error message of validation result
	ErrorMessage *string

	// The validation item name.
	Name *string

	// The result of validation
	Result *ValidationResultStatus
}

// ValueSecretInfo - The secret info when type is rawValue. It's for scenarios that user input the secret.
type ValueSecretInfo struct {
	// REQUIRED; The secret type.
	SecretType *SecretType

	// The actual value of the secret.
	Value *string
}

// GetSecretInfoBase implements the SecretInfoBaseClassification interface for type ValueSecretInfo.
func (v *ValueSecretInfo) GetSecretInfoBase() *SecretInfoBase {
	return &SecretInfoBase{
		SecretType: v.SecretType,
	}
}
