//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
	"net/http"
)

// ExchangeServer is a fake server for instances of the armreservations.ExchangeClient type.
type ExchangeServer struct {
	// BeginPost is the fake for method ExchangeClient.BeginPost
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPost func(ctx context.Context, body armreservations.ExchangeRequest, options *armreservations.ExchangeClientBeginPostOptions) (resp azfake.PollerResponder[armreservations.ExchangeClientPostResponse], errResp azfake.ErrorResponder)
}

// NewExchangeServerTransport creates a new instance of ExchangeServerTransport with the provided implementation.
// The returned ExchangeServerTransport instance is connected to an instance of armreservations.ExchangeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExchangeServerTransport(srv *ExchangeServer) *ExchangeServerTransport {
	return &ExchangeServerTransport{
		srv:       srv,
		beginPost: newTracker[azfake.PollerResponder[armreservations.ExchangeClientPostResponse]](),
	}
}

// ExchangeServerTransport connects instances of armreservations.ExchangeClient to instances of ExchangeServer.
// Don't use this type directly, use NewExchangeServerTransport instead.
type ExchangeServerTransport struct {
	srv       *ExchangeServer
	beginPost *tracker[azfake.PollerResponder[armreservations.ExchangeClientPostResponse]]
}

// Do implements the policy.Transporter interface for ExchangeServerTransport.
func (e *ExchangeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExchangeClient.BeginPost":
		resp, err = e.dispatchBeginPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExchangeServerTransport) dispatchBeginPost(req *http.Request) (*http.Response, error) {
	if e.srv.BeginPost == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPost not implemented")}
	}
	beginPost := e.beginPost.get(req)
	if beginPost == nil {
		body, err := server.UnmarshalRequestAsJSON[armreservations.ExchangeRequest](req)
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginPost(req.Context(), body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPost = &respr
		e.beginPost.add(req, beginPost)
	}

	resp, err := server.PollerResponderNext(beginPost, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginPost.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPost) {
		e.beginPost.remove(req)
	}

	return resp, nil
}
