//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicessiterecovery_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationAlertSettings_List.json
func ExampleReplicationAlertSettingsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReplicationAlertSettingsClient().NewListPager("vault1", "resourceGroupPS1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertCollection = armrecoveryservicessiterecovery.AlertCollection{
		// 	Value: []*armrecoveryservicessiterecovery.Alert{
		// 		{
		// 			Name: to.Ptr("defaultAlertSetting"),
		// 			Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationAlertSettings"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationAlertSettings/defaultAlertSetting"),
		// 			Properties: &armrecoveryservicessiterecovery.AlertProperties{
		// 				CustomEmailAddresses: []*string{
		// 					to.Ptr("ronehr@microsoft.com")},
		// 					Locale: to.Ptr("en-US"),
		// 					SendToOwners: to.Ptr("false"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationAlertSettings_Get.json
func ExampleReplicationAlertSettingsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReplicationAlertSettingsClient().Get(ctx, "vault1", "resourceGroupPS1", "defaultAlertSetting", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armrecoveryservicessiterecovery.Alert{
	// 	Name: to.Ptr("defaultAlertSetting"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationAlertSettings"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationAlertSettings/defaultAlertSetting"),
	// 	Properties: &armrecoveryservicessiterecovery.AlertProperties{
	// 		CustomEmailAddresses: []*string{
	// 			to.Ptr("ronehr@microsoft.com")},
	// 			Locale: to.Ptr("en-US"),
	// 			SendToOwners: to.Ptr("false"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationAlertSettings_Create.json
func ExampleReplicationAlertSettingsClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReplicationAlertSettingsClient().Create(ctx, "vault1", "resourceGroupPS1", "defaultAlertSetting", armrecoveryservicessiterecovery.ConfigureAlertRequest{
		Properties: &armrecoveryservicessiterecovery.ConfigureAlertRequestProperties{
			CustomEmailAddresses: []*string{
				to.Ptr("ronehr@microsoft.com")},
			Locale:       to.Ptr(""),
			SendToOwners: to.Ptr("false"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armrecoveryservicessiterecovery.Alert{
	// 	Name: to.Ptr("defaultAlertSetting"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/replicationAlertSettings"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationAlertSettings/defaultAlertSetting"),
	// 	Properties: &armrecoveryservicessiterecovery.AlertProperties{
	// 		CustomEmailAddresses: []*string{
	// 			to.Ptr("ronehr@microsoft.com")},
	// 			Locale: to.Ptr("en-US"),
	// 			SendToOwners: to.Ptr("false"),
	// 		},
	// 	}
}
