//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// MigrationRecoveryPointsServer is a fake server for instances of the armrecoveryservicessiterecovery.MigrationRecoveryPointsClient type.
type MigrationRecoveryPointsServer struct {
	// Get is the fake for method MigrationRecoveryPointsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, migrationRecoveryPointName string, options *armrecoveryservicessiterecovery.MigrationRecoveryPointsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.MigrationRecoveryPointsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByReplicationMigrationItemsPager is the fake for method MigrationRecoveryPointsClient.NewListByReplicationMigrationItemsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationMigrationItemsPager func(resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, options *armrecoveryservicessiterecovery.MigrationRecoveryPointsClientListByReplicationMigrationItemsOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.MigrationRecoveryPointsClientListByReplicationMigrationItemsResponse])
}

// NewMigrationRecoveryPointsServerTransport creates a new instance of MigrationRecoveryPointsServerTransport with the provided implementation.
// The returned MigrationRecoveryPointsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.MigrationRecoveryPointsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMigrationRecoveryPointsServerTransport(srv *MigrationRecoveryPointsServer) *MigrationRecoveryPointsServerTransport {
	return &MigrationRecoveryPointsServerTransport{
		srv:                                     srv,
		newListByReplicationMigrationItemsPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.MigrationRecoveryPointsClientListByReplicationMigrationItemsResponse]](),
	}
}

// MigrationRecoveryPointsServerTransport connects instances of armrecoveryservicessiterecovery.MigrationRecoveryPointsClient to instances of MigrationRecoveryPointsServer.
// Don't use this type directly, use NewMigrationRecoveryPointsServerTransport instead.
type MigrationRecoveryPointsServerTransport struct {
	srv                                     *MigrationRecoveryPointsServer
	newListByReplicationMigrationItemsPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.MigrationRecoveryPointsClientListByReplicationMigrationItemsResponse]]
}

// Do implements the policy.Transporter interface for MigrationRecoveryPointsServerTransport.
func (m *MigrationRecoveryPointsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MigrationRecoveryPointsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MigrationRecoveryPointsClient.NewListByReplicationMigrationItemsPager":
		resp, err = m.dispatchNewListByReplicationMigrationItemsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MigrationRecoveryPointsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationRecoveryPoints/(?P<migrationRecoveryPointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
	if err != nil {
		return nil, err
	}
	migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
	if err != nil {
		return nil, err
	}
	migrationRecoveryPointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationRecoveryPointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, migrationRecoveryPointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrationRecoveryPoint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MigrationRecoveryPointsServerTransport) dispatchNewListByReplicationMigrationItemsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByReplicationMigrationItemsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationMigrationItemsPager not implemented")}
	}
	newListByReplicationMigrationItemsPager := m.newListByReplicationMigrationItemsPager.get(req)
	if newListByReplicationMigrationItemsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrationRecoveryPoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByReplicationMigrationItemsPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, nil)
		newListByReplicationMigrationItemsPager = &resp
		m.newListByReplicationMigrationItemsPager.add(req, newListByReplicationMigrationItemsPager)
		server.PagerResponderInjectNextLinks(newListByReplicationMigrationItemsPager, req, func(page *armrecoveryservicessiterecovery.MigrationRecoveryPointsClientListByReplicationMigrationItemsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationMigrationItemsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByReplicationMigrationItemsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationMigrationItemsPager) {
		m.newListByReplicationMigrationItemsPager.remove(req)
	}
	return resp, nil
}
