//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbiprivatelinks/armpowerbiprivatelinks/v2"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateLinkServicesServer is a fake server for instances of the armpowerbiprivatelinks.PrivateLinkServicesClient type.
type PrivateLinkServicesServer struct {
	// ListByResourceGroup is the fake for method PrivateLinkServicesClient.ListByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	ListByResourceGroup func(ctx context.Context, resourceGroupName string, options *armpowerbiprivatelinks.PrivateLinkServicesClientListByResourceGroupOptions) (resp azfake.Responder[armpowerbiprivatelinks.PrivateLinkServicesClientListByResourceGroupResponse], errResp azfake.ErrorResponder)
}

// NewPrivateLinkServicesServerTransport creates a new instance of PrivateLinkServicesServerTransport with the provided implementation.
// The returned PrivateLinkServicesServerTransport instance is connected to an instance of armpowerbiprivatelinks.PrivateLinkServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateLinkServicesServerTransport(srv *PrivateLinkServicesServer) *PrivateLinkServicesServerTransport {
	return &PrivateLinkServicesServerTransport{srv: srv}
}

// PrivateLinkServicesServerTransport connects instances of armpowerbiprivatelinks.PrivateLinkServicesClient to instances of PrivateLinkServicesServer.
// Don't use this type directly, use NewPrivateLinkServicesServerTransport instead.
type PrivateLinkServicesServerTransport struct {
	srv *PrivateLinkServicesServer
}

// Do implements the policy.Transporter interface for PrivateLinkServicesServerTransport.
func (p *PrivateLinkServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateLinkServicesClient.ListByResourceGroup":
		resp, err = p.dispatchListByResourceGroup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateLinkServicesServerTransport) dispatchListByResourceGroup(req *http.Request) (*http.Response, error) {
	if p.srv.ListByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/privateLinkServicesForPowerBI`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListByResourceGroup(req.Context(), resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantResourceArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
