//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armplaywrighttesting

import "time"

// Account - An account resource
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The resource-specific properties for this resource.
	Properties *AccountProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccountListResult - The response of a Account list operation.
type AccountListResult struct {
	// REQUIRED; The Account items on this page
	Value []*Account

	// The link to the next page of items
	NextLink *string
}

// AccountProperties - Account properties
type AccountProperties struct {
	// This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect
	// to browsers in the closest Azure region, ensuring lower latency. If
	// disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
	RegionalAffinity *EnablementStatus

	// When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and
	// screenshots, in the Playwright portal. This enables faster and more efficient
	// troubleshooting.
	Reporting *EnablementStatus

	// When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel
	// workers for a test run, significantly minimizing test completion durations.
	ScalableExecution *EnablementStatus

	// READ-ONLY; The Playwright testing dashboard URI for the account resource.
	DashboardURI *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// AccountUpdate - The type used for update operations of the Account.
type AccountUpdate struct {
	// The updatable properties of the Account.
	Properties *AccountUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// AccountUpdateProperties - The updatable properties of the Account.
type AccountUpdateProperties struct {
	// This property sets the connection region for Playwright client workers to cloud-hosted browsers. If enabled, workers connect
	// to browsers in the closest Azure region, ensuring lower latency. If
	// disabled, workers connect to browsers in the Azure region in which the workspace was initially created.
	RegionalAffinity *EnablementStatus

	// When enabled, this feature allows the workspace to upload and display test results, including artifacts like traces and
	// screenshots, in the Playwright portal. This enables faster and more efficient
	// troubleshooting.
	Reporting *EnablementStatus

	// When enabled, Playwright client workers can connect to cloud-hosted browsers. This can increase the number of parallel
	// workers for a test run, significantly minimizing test completion durations.
	ScalableExecution *EnablementStatus
}

// FreeTrialProperties - The free-trial properties
type FreeTrialProperties struct {
	// READ-ONLY; The playwright account id.
	AccountID *string

	// READ-ONLY; The free-trial allocated limit value eg. allocated free minutes.
	AllocatedValue *int32

	// READ-ONLY; The free-trial createdAt utcDateTime.
	CreatedAt *time.Time

	// READ-ONLY; The free-trial expiryAt utcDateTime.
	ExpiryAt *time.Time

	// READ-ONLY; The free-trial percentage used.
	PercentageUsed *float64

	// READ-ONLY; The free-trial state.
	State *FreeTrialState

	// READ-ONLY; The free-trial used value eg. used free minutes.
	UsedValue *int32
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// Quota - A quota resource
type Quota struct {
	// The resource-specific properties for this resource.
	Properties *QuotaProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// QuotaListResult - The response of a Quota list operation.
type QuotaListResult struct {
	// REQUIRED; The Quota items on this page
	Value []*Quota

	// The link to the next page of items
	NextLink *string
}

// QuotaProperties - Quota properties
type QuotaProperties struct {
	// The free-trial quota.
	FreeTrial *FreeTrialProperties

	// READ-ONLY; The status of the last operation.
	ProvisioningState *ProvisioningState
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
