//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LegacyPeeringsServer is a fake server for instances of the armpeering.LegacyPeeringsClient type.
type LegacyPeeringsServer struct {
	// NewListPager is the fake for method LegacyPeeringsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(peeringLocation string, kind armpeering.LegacyPeeringsKind, options *armpeering.LegacyPeeringsClientListOptions) (resp azfake.PagerResponder[armpeering.LegacyPeeringsClientListResponse])
}

// NewLegacyPeeringsServerTransport creates a new instance of LegacyPeeringsServerTransport with the provided implementation.
// The returned LegacyPeeringsServerTransport instance is connected to an instance of armpeering.LegacyPeeringsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLegacyPeeringsServerTransport(srv *LegacyPeeringsServer) *LegacyPeeringsServerTransport {
	return &LegacyPeeringsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armpeering.LegacyPeeringsClientListResponse]](),
	}
}

// LegacyPeeringsServerTransport connects instances of armpeering.LegacyPeeringsClient to instances of LegacyPeeringsServer.
// Don't use this type directly, use NewLegacyPeeringsServerTransport instead.
type LegacyPeeringsServerTransport struct {
	srv          *LegacyPeeringsServer
	newListPager *tracker[azfake.PagerResponder[armpeering.LegacyPeeringsClientListResponse]]
}

// Do implements the policy.Transporter interface for LegacyPeeringsServerTransport.
func (l *LegacyPeeringsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LegacyPeeringsClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LegacyPeeringsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/legacyPeerings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		peeringLocationParam, err := url.QueryUnescape(qp.Get("peeringLocation"))
		if err != nil {
			return nil, err
		}
		kindParam, err := parseWithCast(qp.Get("kind"), func(v string) (armpeering.LegacyPeeringsKind, error) {
			p, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpeering.LegacyPeeringsKind(p), nil
		})
		if err != nil {
			return nil, err
		}
		asnUnescaped, err := url.QueryUnescape(qp.Get("asn"))
		if err != nil {
			return nil, err
		}
		asnParam, err := parseOptional(asnUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armpeering.LegacyPeeringsClientListOptions
		if asnParam != nil {
			options = &armpeering.LegacyPeeringsClientListOptions{
				Asn: asnParam,
			}
		}
		resp := l.srv.NewListPager(peeringLocationParam, kindParam, options)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpeering.LegacyPeeringsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}
