//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// GlobalRulestackServer is a fake server for instances of the armpanngfw.GlobalRulestackClient type.
type GlobalRulestackServer struct {
	// BeginCommit is the fake for method GlobalRulestackClient.BeginCommit
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginCommit func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientBeginCommitOptions) (resp azfake.PollerResponder[armpanngfw.GlobalRulestackClientCommitResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method GlobalRulestackClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, globalRulestackName string, resource armpanngfw.GlobalRulestackResource, options *armpanngfw.GlobalRulestackClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.GlobalRulestackClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method GlobalRulestackClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.GlobalRulestackClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method GlobalRulestackClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientGetOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientGetResponse], errResp azfake.ErrorResponder)

	// GetChangeLog is the fake for method GlobalRulestackClient.GetChangeLog
	// HTTP status codes to indicate success: http.StatusOK
	GetChangeLog func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientGetChangeLogOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientGetChangeLogResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method GlobalRulestackClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armpanngfw.GlobalRulestackClientListOptions) (resp azfake.PagerResponder[armpanngfw.GlobalRulestackClientListResponse])

	// ListAdvancedSecurityObjects is the fake for method GlobalRulestackClient.ListAdvancedSecurityObjects
	// HTTP status codes to indicate success: http.StatusOK
	ListAdvancedSecurityObjects func(ctx context.Context, globalRulestackName string, typeParam armpanngfw.AdvSecurityObjectTypeEnum, options *armpanngfw.GlobalRulestackClientListAdvancedSecurityObjectsOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListAdvancedSecurityObjectsResponse], errResp azfake.ErrorResponder)

	// ListAppIDs is the fake for method GlobalRulestackClient.ListAppIDs
	// HTTP status codes to indicate success: http.StatusOK
	ListAppIDs func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientListAppIDsOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListAppIDsResponse], errResp azfake.ErrorResponder)

	// ListCountries is the fake for method GlobalRulestackClient.ListCountries
	// HTTP status codes to indicate success: http.StatusOK
	ListCountries func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientListCountriesOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListCountriesResponse], errResp azfake.ErrorResponder)

	// ListFirewalls is the fake for method GlobalRulestackClient.ListFirewalls
	// HTTP status codes to indicate success: http.StatusOK
	ListFirewalls func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientListFirewallsOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListFirewallsResponse], errResp azfake.ErrorResponder)

	// ListPredefinedURLCategories is the fake for method GlobalRulestackClient.ListPredefinedURLCategories
	// HTTP status codes to indicate success: http.StatusOK
	ListPredefinedURLCategories func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientListPredefinedURLCategoriesOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListPredefinedURLCategoriesResponse], errResp azfake.ErrorResponder)

	// ListSecurityServices is the fake for method GlobalRulestackClient.ListSecurityServices
	// HTTP status codes to indicate success: http.StatusOK
	ListSecurityServices func(ctx context.Context, globalRulestackName string, typeParam armpanngfw.SecurityServicesTypeEnum, options *armpanngfw.GlobalRulestackClientListSecurityServicesOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientListSecurityServicesResponse], errResp azfake.ErrorResponder)

	// Revert is the fake for method GlobalRulestackClient.Revert
	// HTTP status codes to indicate success: http.StatusNoContent
	Revert func(ctx context.Context, globalRulestackName string, options *armpanngfw.GlobalRulestackClientRevertOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientRevertResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method GlobalRulestackClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, globalRulestackName string, properties armpanngfw.GlobalRulestackResourceUpdate, options *armpanngfw.GlobalRulestackClientUpdateOptions) (resp azfake.Responder[armpanngfw.GlobalRulestackClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewGlobalRulestackServerTransport creates a new instance of GlobalRulestackServerTransport with the provided implementation.
// The returned GlobalRulestackServerTransport instance is connected to an instance of armpanngfw.GlobalRulestackClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGlobalRulestackServerTransport(srv *GlobalRulestackServer) *GlobalRulestackServerTransport {
	return &GlobalRulestackServerTransport{
		srv:                 srv,
		beginCommit:         newTracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientCommitResponse]](),
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armpanngfw.GlobalRulestackClientListResponse]](),
	}
}

// GlobalRulestackServerTransport connects instances of armpanngfw.GlobalRulestackClient to instances of GlobalRulestackServer.
// Don't use this type directly, use NewGlobalRulestackServerTransport instead.
type GlobalRulestackServerTransport struct {
	srv                 *GlobalRulestackServer
	beginCommit         *tracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientCommitResponse]]
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armpanngfw.GlobalRulestackClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armpanngfw.GlobalRulestackClientListResponse]]
}

// Do implements the policy.Transporter interface for GlobalRulestackServerTransport.
func (g *GlobalRulestackServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GlobalRulestackClient.BeginCommit":
		resp, err = g.dispatchBeginCommit(req)
	case "GlobalRulestackClient.BeginCreateOrUpdate":
		resp, err = g.dispatchBeginCreateOrUpdate(req)
	case "GlobalRulestackClient.BeginDelete":
		resp, err = g.dispatchBeginDelete(req)
	case "GlobalRulestackClient.Get":
		resp, err = g.dispatchGet(req)
	case "GlobalRulestackClient.GetChangeLog":
		resp, err = g.dispatchGetChangeLog(req)
	case "GlobalRulestackClient.NewListPager":
		resp, err = g.dispatchNewListPager(req)
	case "GlobalRulestackClient.ListAdvancedSecurityObjects":
		resp, err = g.dispatchListAdvancedSecurityObjects(req)
	case "GlobalRulestackClient.ListAppIDs":
		resp, err = g.dispatchListAppIDs(req)
	case "GlobalRulestackClient.ListCountries":
		resp, err = g.dispatchListCountries(req)
	case "GlobalRulestackClient.ListFirewalls":
		resp, err = g.dispatchListFirewalls(req)
	case "GlobalRulestackClient.ListPredefinedURLCategories":
		resp, err = g.dispatchListPredefinedURLCategories(req)
	case "GlobalRulestackClient.ListSecurityServices":
		resp, err = g.dispatchListSecurityServices(req)
	case "GlobalRulestackClient.Revert":
		resp, err = g.dispatchRevert(req)
	case "GlobalRulestackClient.Update":
		resp, err = g.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchBeginCommit(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCommit == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommit not implemented")}
	}
	beginCommit := g.beginCommit.get(req)
	if beginCommit == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commit`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCommit(req.Context(), globalRulestackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommit = &respr
		g.beginCommit.add(req, beginCommit)
	}

	resp, err := server.PollerResponderNext(beginCommit, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		g.beginCommit.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommit) {
		g.beginCommit.remove(req)
	}

	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := g.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.GlobalRulestackResource](req)
		if err != nil {
			return nil, err
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateOrUpdate(req.Context(), globalRulestackNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		g.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		g.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		g.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if g.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := g.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginDelete(req.Context(), globalRulestackNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		g.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		g.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		g.beginDelete.remove(req)
	}

	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), globalRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GlobalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchGetChangeLog(req *http.Request) (*http.Response, error) {
	if g.srv.GetChangeLog == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetChangeLog not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getChangeLog`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.GetChangeLog(req.Context(), globalRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Changelog, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := g.newListPager.get(req)
	if newListPager == nil {
		resp := g.srv.NewListPager(nil)
		newListPager = &resp
		g.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpanngfw.GlobalRulestackClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		g.newListPager.remove(req)
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListAdvancedSecurityObjects(req *http.Request) (*http.Response, error) {
	if g.srv.ListAdvancedSecurityObjects == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAdvancedSecurityObjects not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAdvancedSecurityObjects`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	typeParamParam, err := parseWithCast(qp.Get("type"), func(v string) (armpanngfw.AdvSecurityObjectTypeEnum, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpanngfw.AdvSecurityObjectTypeEnum(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.GlobalRulestackClientListAdvancedSecurityObjectsOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.GlobalRulestackClientListAdvancedSecurityObjectsOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := g.srv.ListAdvancedSecurityObjects(req.Context(), globalRulestackNameParam, typeParamParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdvSecurityObjectListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListAppIDs(req *http.Request) (*http.Response, error) {
	if g.srv.ListAppIDs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAppIDs not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAppIds`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	appIDVersionUnescaped, err := url.QueryUnescape(qp.Get("appIdVersion"))
	if err != nil {
		return nil, err
	}
	appIDVersionParam := getOptional(appIDVersionUnescaped)
	appPrefixUnescaped, err := url.QueryUnescape(qp.Get("appPrefix"))
	if err != nil {
		return nil, err
	}
	appPrefixParam := getOptional(appPrefixUnescaped)
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.GlobalRulestackClientListAppIDsOptions
	if appIDVersionParam != nil || appPrefixParam != nil || skipParam != nil || topParam != nil {
		options = &armpanngfw.GlobalRulestackClientListAppIDsOptions{
			AppIDVersion: appIDVersionParam,
			AppPrefix:    appPrefixParam,
			Skip:         skipParam,
			Top:          topParam,
		}
	}
	respr, errRespr := g.srv.ListAppIDs(req.Context(), globalRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListAppIDResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListCountries(req *http.Request) (*http.Response, error) {
	if g.srv.ListCountries == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListCountries not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listCountries`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.GlobalRulestackClientListCountriesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.GlobalRulestackClientListCountriesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := g.srv.ListCountries(req.Context(), globalRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CountriesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListFirewalls(req *http.Request) (*http.Response, error) {
	if g.srv.ListFirewalls == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListFirewalls not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFirewalls`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.ListFirewalls(req.Context(), globalRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListFirewallsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListPredefinedURLCategories(req *http.Request) (*http.Response, error) {
	if g.srv.ListPredefinedURLCategories == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPredefinedURLCategories not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listPredefinedUrlCategories`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.GlobalRulestackClientListPredefinedURLCategoriesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.GlobalRulestackClientListPredefinedURLCategoriesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := g.srv.ListPredefinedURLCategories(req.Context(), globalRulestackNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PredefinedURLCategoriesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchListSecurityServices(req *http.Request) (*http.Response, error) {
	if g.srv.ListSecurityServices == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSecurityServices not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecurityServices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("top"))
	if err != nil {
		return nil, err
	}
	topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	typeParamParam, err := parseWithCast(qp.Get("type"), func(v string) (armpanngfw.SecurityServicesTypeEnum, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armpanngfw.SecurityServicesTypeEnum(p), nil
	})
	if err != nil {
		return nil, err
	}
	var options *armpanngfw.GlobalRulestackClientListSecurityServicesOptions
	if skipParam != nil || topParam != nil {
		options = &armpanngfw.GlobalRulestackClientListSecurityServicesOptions{
			Skip: skipParam,
			Top:  topParam,
		}
	}
	respr, errRespr := g.srv.ListSecurityServices(req.Context(), globalRulestackNameParam, typeParamParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SecurityServicesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchRevert(req *http.Request) (*http.Response, error) {
	if g.srv.Revert == nil {
		return nil, &nonRetriableError{errors.New("fake for method Revert not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revert`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Revert(req.Context(), globalRulestackNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GlobalRulestackServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpanngfw.GlobalRulestackResourceUpdate](req)
	if err != nil {
		return nil, err
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Update(req.Context(), globalRulestackNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GlobalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
