//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/DataSourcesCreate.json
func ExampleDataSourcesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSourcesClient().CreateOrUpdate(ctx, "OIAutoRest5123", "AzTest9724", "AzTestDS774", armoperationalinsights.DataSource{
		Kind: to.Ptr(armoperationalinsights.DataSourceKindAzureActivityLog),
		Properties: map[string]any{
			"LinkedResourceId": "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataSource = armoperationalinsights.DataSource{
	// 	Name: to.Ptr("AzTestDS774"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest5123/providers/Microsoft.OperationalInsights/workspaces/AzTest9724/datasources/AzTestDS774"),
	// 	Etag: to.Ptr("W/\"datetime'2017-10-01T08%3A01%3A21.2351243Z'\""),
	// 	Kind: to.Ptr(armoperationalinsights.DataSourceKindAzureActivityLog),
	// 	Properties: map[string]any{
	// 		"linkedResourceId": "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/DataSourcesDelete.json
func ExampleDataSourcesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDataSourcesClient().Delete(ctx, "OIAutoRest5123", "AzTest9724", "AzTestDS774", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/DataSourcesGet.json
func ExampleDataSourcesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataSourcesClient().Get(ctx, "OIAutoRest5123", "AzTest9724", "AzTestDS774", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataSource = armoperationalinsights.DataSource{
	// 	Name: to.Ptr("AzTestDS774"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest5123/providers/Microsoft.OperationalInsights/workspaces/AzTest9724/datasources/AzTestDS774"),
	// 	Etag: to.Ptr("W/\"datetime'2017-10-01T08%3A01%3A21.2351243Z'\""),
	// 	Kind: to.Ptr(armoperationalinsights.DataSourceKindAzureActivityLog),
	// 	Properties: map[string]any{
	// 		"linkedResourceId": "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/DataSourcesListByWorkspace.json
func ExampleDataSourcesClient_NewListByWorkspacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataSourcesClient().NewListByWorkspacePager("OIAutoRest5123", "AzTest9724", "kind='WindowsEvent'", &armoperationalinsights.DataSourcesClientListByWorkspaceOptions{Skiptoken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataSourceListResult = armoperationalinsights.DataSourceListResult{
		// 	Value: []*armoperationalinsights.DataSource{
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1011"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1011"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A08.5629323Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent14",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1013"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1013"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A22.2533211Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent64",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1020"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1020"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A04.4645698Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent202",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1074"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1074"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A12.5871672Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent231",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1117"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1117"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A28.9325389Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent86",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1128"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1128"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A13.2185735Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent30",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1176"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1176"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A22.7779289Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent66",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1293"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1293"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A03.5114136Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent199",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE134"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE134"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A33.6788897Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent102",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1352"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1352"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A36.2312139Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent111",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1360"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1360"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A13.4685716Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent31",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1382"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1382"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A19.2840543Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent53",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1410"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1410"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A42.7070374Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent132",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1417"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1417"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A06.8922838Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent211",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1560"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1560"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A26.6932412Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent274",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1618"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1618"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A07.1422661Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent212",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1662"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1662"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A09.5980265Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent221",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1675"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1675"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A39.6167744Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent121",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE169"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE169"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A50.1064668Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent157",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1735"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1735"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A02.4954752Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent196",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1742"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1742"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A08.0452997Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent12",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1815"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1815"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A46.5966089Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent145",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1828"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1828"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A23.6529754Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent69",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE188"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE188"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A20.7216320Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent58",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1962"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1962"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A17.9341560Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent48",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE1997"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE1997"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A17.3081821Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent246",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2046"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2046"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A49.2918213Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent154",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2056"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2056"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A52.4111189Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent165",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2116"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2116"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A54.7598026Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent172",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2142"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2142"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A07.2711237Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent9",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE22"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE22"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A48.2064500Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent150",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2208"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2208"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A08.7849248Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent218",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2221"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2221"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A51.3306230Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent161",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2226"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2226"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A25.5991266Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent75",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2231"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2231"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A15.3592513Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent38",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2242"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2242"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A06.0641077Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent208",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2263"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2263"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A11.7829226Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent228",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2369"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2369"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A21.5874093Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent259",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE240"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE240"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A06.6266574Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent210",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2423"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2423"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A23.4752361Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent265",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2463"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2463"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A36.5611370Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent112",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2499"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2499"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A13.7187131Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent32",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2509"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2509"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A09.3324224Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent220",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2541"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2541"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A29.2312540Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent87",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2578"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2578"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A05.3117461Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent2",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2619"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2619"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A38.5379572Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent119",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE274"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE274"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A05.0735592Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent1",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2754"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2754"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A30.6297451Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent92",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE281"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE281"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A05.2972963Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent205",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2818"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2818"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A33.3820072Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent101",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2860"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2860"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A14.0876077Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent236",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2867"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2867"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A30.9266089Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent93",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2923"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2923"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A27.9342580Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent278",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE2979"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE2979"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A44.4311007Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent138",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3009"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3009"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A08.5349323Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent217",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3033"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3033"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A24.9696296Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent269",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3095"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3095"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A18.2006423Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent49",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3114"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3114"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A38.2879169Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent118",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3132"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3132"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A37.6889867Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent116",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3147"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3147"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A58.9331954Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent185",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3159"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3159"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A35.6843083Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent109",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE317"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE317"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A17.4118415Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent46",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3175"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3175"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A35.0592573Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent107",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3183"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3183"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A12.6247906Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent28",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3217"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3217"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A14.4938899Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent237",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3220"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3220"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A21.7373059Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent62",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3228"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3228"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A18.7785353Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent51",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3395"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3395"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A54.4936956Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent171",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3416"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3416"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A22.0032694Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent63",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3506"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3506"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A28.8251658Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent280",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3517"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3517"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A11.2153209Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent23",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3528"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3528"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A12.0402565Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent229",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3530"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3530"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A43.8027590Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent136",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3594"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3594"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A01.9173304Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent194",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3615"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3615"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A00.8990889Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent191",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3645"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3645"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A16.0877829Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent242",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3676"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3676"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A07.8068460Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent11",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3700"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3700"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A49.5439700Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent155",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3738"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3738"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A38.0363694Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent117",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3740"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3740"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A50.6390339Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent159",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3754"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3754"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A31.5203823Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent95",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3761"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3761"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A31.7860159Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent96",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3787"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3787"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A20.0966078Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent56",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3880"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3880"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A57.8394298Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent181",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3887"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3887"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A51.0806178Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent160",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3899"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3899"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A16.6987634Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent244",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE3928"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE3928"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A41.4223363Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent127",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4005"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4005"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A59.1831854Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent186",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4021"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4021"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A31.5314824Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent288",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4054"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4054"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A01.6667691Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent193",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE406"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE406"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A42.9581303Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent133",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4128"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4128"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A29.4890798Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent88",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4140"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4140"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A00.2051432Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent189",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4209"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4209"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A58.3706603Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent183",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4216"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4216"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A23.1240354Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent67",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4240"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4240"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A33.5368097Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent294",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4279"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4279"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A30.3641074Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent91",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4289"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4289"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A26.3963554Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent273",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4317"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4317"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A47.6751803Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent148",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4324"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4324"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A05.8120517Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent4",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4362"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4362"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A04.1208323Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent201",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4416"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4416"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A08.3109506Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent13",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4424"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4424"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A48.9744951Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent153",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4466"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4466"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A19.0457713Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent52",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4467"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4467"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A15.0936374Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent37",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4503"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4503"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A41.9399246Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent129",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4521"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4521"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A27.2714771Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent276",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4530"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4530"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A26.7419933Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent79",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4600"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4600"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A37.4227966Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent115",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4644"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4644"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A43.5519204Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent135",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4694"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4694"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A51.6431386Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent162",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4715"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4715"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A06.0530002Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent5",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE472"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE472"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A24.3989962Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent267",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4721"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4721"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A16.3706498Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent243",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4734"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4734"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A33.8337155Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent295",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4755"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4755"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A25.2712759Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent270",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4779"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4779"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A27.5076680Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent81",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4791"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4791"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A04.6828938Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent0",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4798"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4798"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A54.0073520Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent170",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE480"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE480"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A22.9077505Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent263",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4847"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4847"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A11.7028912Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent25",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4876"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4876"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A04.9847854Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent204",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4900"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4900"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A23.4029367Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent68",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4918"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4918"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A34.5280091Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent105",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4928"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4928"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A34.2882196Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent296",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4930"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4930"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A33.2381803Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent293",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4945"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4945"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A36.8423994Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent113",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4967"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4967"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A08.9379456Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent15",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4969"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4969"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A57.5893926Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent180",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE4983"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE4983"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A19.5497139Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent54",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5011"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5011"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A48.4588661Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent151",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5082"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5082"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A32.2694295Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent290",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5136"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5136"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A17.8863220Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent248",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5141"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5141"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A05.5484906Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent206",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5166"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5166"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A23.9283342Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent266",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5207"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5207"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A29.4970655Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent282",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5223"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5223"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A04.7146038Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent203",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5233"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5233"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A10.3237629Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent20",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5253"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5253"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A18.1831872Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent249",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5255"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5255"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A30.9049829Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent286",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5263"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5263"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A12.8904269Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent29",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5351"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5351"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A20.4543884Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent255",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5385"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5385"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A19.7997319Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent55",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5394"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5394"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A29.7703365Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent89",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE541"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE541"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A09.4692151Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent17",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5439"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5439"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A15.7994161Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent241",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5460"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5460"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A10.3032105Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent223",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5479"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5479"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A24.6802546Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent268",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5483"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5483"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A01.1670463Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent192",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5486"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5486"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A37.1393156Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent114",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5554"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5554"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A41.1205470Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent126",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5559"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5559"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A20.7200407Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent256",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5585"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5585"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A18.4534330Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent50",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE568"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE568"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A40.8861587Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent125",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5741"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5741"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A12.3059271Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent230",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE58"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE58"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A39.0692471Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent120",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5810"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5810"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A16.9117573Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent44",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5815"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5815"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A45.4055476Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent141",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5858"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5858"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A55.0097893Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent173",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5866"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5866"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A18.9931389Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent251",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5888"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5888"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A59.4332080Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent187",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE5905"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE5905"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A09.7599986Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent18",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6027"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6027"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A10.6395291Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent224",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE607"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE607"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A13.7282386Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent235",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6099"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6099"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A33.1319662Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent100",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6122"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6122"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A06.3186640Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent6",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6218"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6218"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A11.4528829Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent24",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE622"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE622"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A47.9407875Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent149",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6222"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6222"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A06.3453921Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent209",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6240"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6240"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A21.2372832Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent60",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6251"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6251"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A08.2849036Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent216",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6274"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6274"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A02.1829375Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent195",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6296"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6296"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A32.3491070Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent98",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6301"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6301"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A22.1811938Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent261",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6404"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6404"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A06.7093003Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent7",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6406"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6406"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A05.5617435Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent3",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6432"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6432"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A40.2886854Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent123",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6439"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6439"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A35.9811949Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent110",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6451"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6451"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A13.1344490Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent233",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6486"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6486"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A10.9653354Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent22",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6505"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6505"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A10.0582011Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent19",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6514"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6514"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A52.8955201Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent166",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6518"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6518"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A10.9395226Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent225",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6537"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6537"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A24.0123335Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent70",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6547"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6547"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A57.3394082Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent179",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6556"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6556"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A33.9457044Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent103",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6718"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6718"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A13.4313542Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent234",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6724"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6724"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A35.4186784Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent108",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6741"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6741"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A12.3279180Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent27",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6796"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6796"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A24.5764501Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent72",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6826"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6826"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A35.2579899Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent299",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6829"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6829"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A34.6319483Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent297",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6893"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6893"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A28.5887776Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent85",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE6974"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE6974"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A16.1249736Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent41",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7008"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7008"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A28.3876585Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent279",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7014"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7014"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A29.1220764Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent281",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7068"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7068"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A26.0213457Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent272",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7080"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7080"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A21%3A21.8686663Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent260",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7166"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7166"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A40.5423724Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent124",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("AzTestDSWE7178"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/datasources"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourceGroups/OIAutoRest7887/providers/Microsoft.OperationalInsights/workspaces/AzTest218/datasources/AzTestDSWE7178"),
		// 			Etag: to.Ptr("W/\"datetime'2017-10-02T23%3A20%3A16.3906307Z'\""),
		// 			Kind: to.Ptr(armoperationalinsights.DataSourceKindWindowsEvent),
		// 			Properties: map[string]any{
		// 				"eventLogName": "windowsEvent42",
		// 				"eventTypes":[]any{
		// 					map[string]any{
		// 						"eventType": "Error",
		// 					},
		// 				},
		// 			},
		// 	}},
		// }
	}
}
