//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
)

// GetPrivateDNSZoneSuffixServer is a fake server for instances of the armmysqlflexibleservers.GetPrivateDNSZoneSuffixClient type.
type GetPrivateDNSZoneSuffixServer struct {
	// Execute is the fake for method GetPrivateDNSZoneSuffixClient.Execute
	// HTTP status codes to indicate success: http.StatusOK
	Execute func(ctx context.Context, options *armmysqlflexibleservers.GetPrivateDNSZoneSuffixClientExecuteOptions) (resp azfake.Responder[armmysqlflexibleservers.GetPrivateDNSZoneSuffixClientExecuteResponse], errResp azfake.ErrorResponder)
}

// NewGetPrivateDNSZoneSuffixServerTransport creates a new instance of GetPrivateDNSZoneSuffixServerTransport with the provided implementation.
// The returned GetPrivateDNSZoneSuffixServerTransport instance is connected to an instance of armmysqlflexibleservers.GetPrivateDNSZoneSuffixClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGetPrivateDNSZoneSuffixServerTransport(srv *GetPrivateDNSZoneSuffixServer) *GetPrivateDNSZoneSuffixServerTransport {
	return &GetPrivateDNSZoneSuffixServerTransport{srv: srv}
}

// GetPrivateDNSZoneSuffixServerTransport connects instances of armmysqlflexibleservers.GetPrivateDNSZoneSuffixClient to instances of GetPrivateDNSZoneSuffixServer.
// Don't use this type directly, use NewGetPrivateDNSZoneSuffixServerTransport instead.
type GetPrivateDNSZoneSuffixServerTransport struct {
	srv *GetPrivateDNSZoneSuffixServer
}

// Do implements the policy.Transporter interface for GetPrivateDNSZoneSuffixServerTransport.
func (g *GetPrivateDNSZoneSuffixServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GetPrivateDNSZoneSuffixClient.Execute":
		resp, err = g.dispatchExecute(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GetPrivateDNSZoneSuffixServerTransport) dispatchExecute(req *http.Request) (*http.Response, error) {
	if g.srv.Execute == nil {
		return nil, &nonRetriableError{errors.New("fake for method Execute not implemented")}
	}
	respr, errRespr := g.srv.Execute(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetPrivateDNSZoneSuffixResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
