//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// CryptoKeysClient contains the methods for the CryptoKeys group.
// Don't use this type directly, use NewCryptoKeysClient() instead.
type CryptoKeysClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewCryptoKeysClient creates a new instance of CryptoKeysClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewCryptoKeysClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*CryptoKeysClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &CryptoKeysClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListByFirmwarePager - Lists cryptographic key analysis results found in a firmware.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - CryptoKeysClientListByFirmwareOptions contains the optional parameters for the CryptoKeysClient.NewListByFirmwarePager
//     method.
func (client *CryptoKeysClient) NewListByFirmwarePager(resourceGroupName string, workspaceName string, firmwareID string, options *CryptoKeysClientListByFirmwareOptions) *runtime.Pager[CryptoKeysClientListByFirmwareResponse] {
	return runtime.NewPager(runtime.PagingHandler[CryptoKeysClientListByFirmwareResponse]{
		More: func(page CryptoKeysClientListByFirmwareResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *CryptoKeysClientListByFirmwareResponse) (CryptoKeysClientListByFirmwareResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "CryptoKeysClient.NewListByFirmwarePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByFirmwareCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return CryptoKeysClientListByFirmwareResponse{}, err
			}
			return client.listByFirmwareHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByFirmwareCreateRequest creates the ListByFirmware request.
func (client *CryptoKeysClient) listByFirmwareCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *CryptoKeysClientListByFirmwareOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/cryptoKeys"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFirmwareHandleResponse handles the ListByFirmware response.
func (client *CryptoKeysClient) listByFirmwareHandleResponse(resp *http.Response) (CryptoKeysClientListByFirmwareResponse, error) {
	result := CryptoKeysClientListByFirmwareResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CryptoKeyListResult); err != nil {
		return CryptoKeysClientListByFirmwareResponse{}, err
	}
	return result, nil
}
