//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armintegrationspaces

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// ApplicationsClient contains the methods for the Applications group.
// Don't use this type directly, use NewApplicationsClient() instead.
type ApplicationsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewApplicationsClient creates a new instance of ApplicationsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewApplicationsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ApplicationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ApplicationsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create a Application
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - resource - Resource create parameters.
//   - options - ApplicationsClientCreateOrUpdateOptions contains the optional parameters for the ApplicationsClient.CreateOrUpdate
//     method.
func (client *ApplicationsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, resource Application, options *ApplicationsClientCreateOrUpdateOptions) (ApplicationsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ApplicationsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, spaceName, applicationName, resource, options)
	if err != nil {
		return ApplicationsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ApplicationsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, resource Application, options *ApplicationsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ApplicationsClient) createOrUpdateHandleResponse(resp *http.Response) (ApplicationsClientCreateOrUpdateResponse, error) {
	result := ApplicationsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Application); err != nil {
		return ApplicationsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a Application
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - options - ApplicationsClientDeleteOptions contains the optional parameters for the ApplicationsClient.Delete method.
func (client *ApplicationsClient) Delete(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientDeleteOptions) (ApplicationsClientDeleteResponse, error) {
	var err error
	const operationName = "ApplicationsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, spaceName, applicationName, options)
	if err != nil {
		return ApplicationsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientDeleteResponse{}, err
	}
	return ApplicationsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ApplicationsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteBusinessProcessDevelopmentArtifact - The delete business process development artifact action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - body - The content of the action request
//   - options - ApplicationsClientDeleteBusinessProcessDevelopmentArtifactOptions contains the optional parameters for the ApplicationsClient.DeleteBusinessProcessDevelopmentArtifact
//     method.
func (client *ApplicationsClient) DeleteBusinessProcessDevelopmentArtifact(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body GetOrDeleteBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientDeleteBusinessProcessDevelopmentArtifactOptions) (ApplicationsClientDeleteBusinessProcessDevelopmentArtifactResponse, error) {
	var err error
	const operationName = "ApplicationsClient.DeleteBusinessProcessDevelopmentArtifact"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteBusinessProcessDevelopmentArtifactCreateRequest(ctx, resourceGroupName, spaceName, applicationName, body, options)
	if err != nil {
		return ApplicationsClientDeleteBusinessProcessDevelopmentArtifactResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientDeleteBusinessProcessDevelopmentArtifactResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientDeleteBusinessProcessDevelopmentArtifactResponse{}, err
	}
	return ApplicationsClientDeleteBusinessProcessDevelopmentArtifactResponse{}, nil
}

// deleteBusinessProcessDevelopmentArtifactCreateRequest creates the DeleteBusinessProcessDevelopmentArtifact request.
func (client *ApplicationsClient) deleteBusinessProcessDevelopmentArtifactCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body GetOrDeleteBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientDeleteBusinessProcessDevelopmentArtifactOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/deleteBusinessProcessDevelopmentArtifact"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Get a Application
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - options - ApplicationsClientGetOptions contains the optional parameters for the ApplicationsClient.Get method.
func (client *ApplicationsClient) Get(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientGetOptions) (ApplicationsClientGetResponse, error) {
	var err error
	const operationName = "ApplicationsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, spaceName, applicationName, options)
	if err != nil {
		return ApplicationsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ApplicationsClient) getCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ApplicationsClient) getHandleResponse(resp *http.Response) (ApplicationsClientGetResponse, error) {
	result := ApplicationsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Application); err != nil {
		return ApplicationsClientGetResponse{}, err
	}
	return result, nil
}

// GetBusinessProcessDevelopmentArtifact - The get business process development artifact action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - body - The content of the action request
//   - options - ApplicationsClientGetBusinessProcessDevelopmentArtifactOptions contains the optional parameters for the ApplicationsClient.GetBusinessProcessDevelopmentArtifact
//     method.
func (client *ApplicationsClient) GetBusinessProcessDevelopmentArtifact(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body GetOrDeleteBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientGetBusinessProcessDevelopmentArtifactOptions) (ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse, error) {
	var err error
	const operationName = "ApplicationsClient.GetBusinessProcessDevelopmentArtifact"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getBusinessProcessDevelopmentArtifactCreateRequest(ctx, resourceGroupName, spaceName, applicationName, body, options)
	if err != nil {
		return ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse{}, err
	}
	resp, err := client.getBusinessProcessDevelopmentArtifactHandleResponse(httpResp)
	return resp, err
}

// getBusinessProcessDevelopmentArtifactCreateRequest creates the GetBusinessProcessDevelopmentArtifact request.
func (client *ApplicationsClient) getBusinessProcessDevelopmentArtifactCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body GetOrDeleteBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientGetBusinessProcessDevelopmentArtifactOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/getBusinessProcessDevelopmentArtifact"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getBusinessProcessDevelopmentArtifactHandleResponse handles the GetBusinessProcessDevelopmentArtifact response.
func (client *ApplicationsClient) getBusinessProcessDevelopmentArtifactHandleResponse(resp *http.Response) (ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse, error) {
	result := ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SaveOrGetBusinessProcessDevelopmentArtifactResponse); err != nil {
		return ApplicationsClientGetBusinessProcessDevelopmentArtifactResponse{}, err
	}
	return result, nil
}

// ListBusinessProcessDevelopmentArtifacts - The list business process development artifacts action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - options - ApplicationsClientListBusinessProcessDevelopmentArtifactsOptions contains the optional parameters for the ApplicationsClient.ListBusinessProcessDevelopmentArtifacts
//     method.
func (client *ApplicationsClient) ListBusinessProcessDevelopmentArtifacts(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientListBusinessProcessDevelopmentArtifactsOptions) (ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse, error) {
	var err error
	const operationName = "ApplicationsClient.ListBusinessProcessDevelopmentArtifacts"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listBusinessProcessDevelopmentArtifactsCreateRequest(ctx, resourceGroupName, spaceName, applicationName, options)
	if err != nil {
		return ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse{}, err
	}
	resp, err := client.listBusinessProcessDevelopmentArtifactsHandleResponse(httpResp)
	return resp, err
}

// listBusinessProcessDevelopmentArtifactsCreateRequest creates the ListBusinessProcessDevelopmentArtifacts request.
func (client *ApplicationsClient) listBusinessProcessDevelopmentArtifactsCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, options *ApplicationsClientListBusinessProcessDevelopmentArtifactsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/listBusinessProcessDevelopmentArtifacts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBusinessProcessDevelopmentArtifactsHandleResponse handles the ListBusinessProcessDevelopmentArtifacts response.
func (client *ApplicationsClient) listBusinessProcessDevelopmentArtifactsHandleResponse(resp *http.Response) (ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse, error) {
	result := ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListBusinessProcessDevelopmentArtifactsResponse); err != nil {
		return ApplicationsClientListBusinessProcessDevelopmentArtifactsResponse{}, err
	}
	return result, nil
}

// NewListBySpacePager - List Application resources by Space
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - options - ApplicationsClientListBySpaceOptions contains the optional parameters for the ApplicationsClient.NewListBySpacePager
//     method.
func (client *ApplicationsClient) NewListBySpacePager(resourceGroupName string, spaceName string, options *ApplicationsClientListBySpaceOptions) *runtime.Pager[ApplicationsClientListBySpaceResponse] {
	return runtime.NewPager(runtime.PagingHandler[ApplicationsClientListBySpaceResponse]{
		More: func(page ApplicationsClientListBySpaceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ApplicationsClientListBySpaceResponse) (ApplicationsClientListBySpaceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ApplicationsClient.NewListBySpacePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySpaceCreateRequest(ctx, resourceGroupName, spaceName, options)
			}, nil)
			if err != nil {
				return ApplicationsClientListBySpaceResponse{}, err
			}
			return client.listBySpaceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySpaceCreateRequest creates the ListBySpace request.
func (client *ApplicationsClient) listBySpaceCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, options *ApplicationsClientListBySpaceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	if options != nil && options.Top != nil {
		reqQP.Set("top", strconv.FormatInt(int64(*options.Top), 10))
	}
	if options != nil && options.Skip != nil {
		reqQP.Set("skip", strconv.FormatInt(int64(*options.Skip), 10))
	}
	if options != nil && options.Maxpagesize != nil {
		reqQP.Set("maxpagesize", strconv.FormatInt(int64(*options.Maxpagesize), 10))
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("filter", *options.Filter)
	}
	if options != nil && options.Select != nil {
		for _, qv := range options.Select {
			reqQP.Add("select", qv)
		}
	}
	if options != nil && options.Expand != nil {
		for _, qv := range options.Expand {
			reqQP.Add("expand", qv)
		}
	}
	if options != nil && options.Orderby != nil {
		for _, qv := range options.Orderby {
			reqQP.Add("orderby", qv)
		}
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySpaceHandleResponse handles the ListBySpace response.
func (client *ApplicationsClient) listBySpaceHandleResponse(resp *http.Response) (ApplicationsClientListBySpaceResponse, error) {
	result := ApplicationsClientListBySpaceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ApplicationListResult); err != nil {
		return ApplicationsClientListBySpaceResponse{}, err
	}
	return result, nil
}

// Patch - Update a Application
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - properties - The resource properties to be updated.
//   - options - ApplicationsClientPatchOptions contains the optional parameters for the ApplicationsClient.Patch method.
func (client *ApplicationsClient) Patch(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, properties ApplicationUpdate, options *ApplicationsClientPatchOptions) (ApplicationsClientPatchResponse, error) {
	var err error
	const operationName = "ApplicationsClient.Patch"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchCreateRequest(ctx, resourceGroupName, spaceName, applicationName, properties, options)
	if err != nil {
		return ApplicationsClientPatchResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientPatchResponse{}, err
	}
	resp, err := client.patchHandleResponse(httpResp)
	return resp, err
}

// patchCreateRequest creates the Patch request.
func (client *ApplicationsClient) patchCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, properties ApplicationUpdate, options *ApplicationsClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// patchHandleResponse handles the Patch response.
func (client *ApplicationsClient) patchHandleResponse(resp *http.Response) (ApplicationsClientPatchResponse, error) {
	result := ApplicationsClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Application); err != nil {
		return ApplicationsClientPatchResponse{}, err
	}
	return result, nil
}

// SaveBusinessProcessDevelopmentArtifact - The save business process development artifact action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - body - The content of the action request
//   - options - ApplicationsClientSaveBusinessProcessDevelopmentArtifactOptions contains the optional parameters for the ApplicationsClient.SaveBusinessProcessDevelopmentArtifact
//     method.
func (client *ApplicationsClient) SaveBusinessProcessDevelopmentArtifact(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body SaveOrValidateBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientSaveBusinessProcessDevelopmentArtifactOptions) (ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse, error) {
	var err error
	const operationName = "ApplicationsClient.SaveBusinessProcessDevelopmentArtifact"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.saveBusinessProcessDevelopmentArtifactCreateRequest(ctx, resourceGroupName, spaceName, applicationName, body, options)
	if err != nil {
		return ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse{}, err
	}
	resp, err := client.saveBusinessProcessDevelopmentArtifactHandleResponse(httpResp)
	return resp, err
}

// saveBusinessProcessDevelopmentArtifactCreateRequest creates the SaveBusinessProcessDevelopmentArtifact request.
func (client *ApplicationsClient) saveBusinessProcessDevelopmentArtifactCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body SaveOrValidateBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientSaveBusinessProcessDevelopmentArtifactOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/saveBusinessProcessDevelopmentArtifact"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// saveBusinessProcessDevelopmentArtifactHandleResponse handles the SaveBusinessProcessDevelopmentArtifact response.
func (client *ApplicationsClient) saveBusinessProcessDevelopmentArtifactHandleResponse(resp *http.Response) (ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse, error) {
	result := ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SaveOrGetBusinessProcessDevelopmentArtifactResponse); err != nil {
		return ApplicationsClientSaveBusinessProcessDevelopmentArtifactResponse{}, err
	}
	return result, nil
}

// ValidateBusinessProcessDevelopmentArtifact - The validate business process development artifact action.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-14-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - spaceName - The name of the space
//   - applicationName - The name of the Application
//   - body - The content of the action request
//   - options - ApplicationsClientValidateBusinessProcessDevelopmentArtifactOptions contains the optional parameters for the
//     ApplicationsClient.ValidateBusinessProcessDevelopmentArtifact method.
func (client *ApplicationsClient) ValidateBusinessProcessDevelopmentArtifact(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body SaveOrValidateBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientValidateBusinessProcessDevelopmentArtifactOptions) (ApplicationsClientValidateBusinessProcessDevelopmentArtifactResponse, error) {
	var err error
	const operationName = "ApplicationsClient.ValidateBusinessProcessDevelopmentArtifact"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateBusinessProcessDevelopmentArtifactCreateRequest(ctx, resourceGroupName, spaceName, applicationName, body, options)
	if err != nil {
		return ApplicationsClientValidateBusinessProcessDevelopmentArtifactResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ApplicationsClientValidateBusinessProcessDevelopmentArtifactResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ApplicationsClientValidateBusinessProcessDevelopmentArtifactResponse{}, err
	}
	return ApplicationsClientValidateBusinessProcessDevelopmentArtifactResponse{}, nil
}

// validateBusinessProcessDevelopmentArtifactCreateRequest creates the ValidateBusinessProcessDevelopmentArtifact request.
func (client *ApplicationsClient) validateBusinessProcessDevelopmentArtifactCreateRequest(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, body SaveOrValidateBusinessProcessDevelopmentArtifactRequest, options *ApplicationsClientValidateBusinessProcessDevelopmentArtifactOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/validateBusinessProcessDevelopmentArtifact"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if spaceName == "" {
		return nil, errors.New("parameter spaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{spaceName}", url.PathEscape(spaceName))
	if applicationName == "" {
		return nil, errors.New("parameter applicationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{applicationName}", url.PathEscape(applicationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-14-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}
