//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ConfigurationGroupSchemasClient contains the methods for the ConfigurationGroupSchemas group.
// Don't use this type directly, use NewConfigurationGroupSchemasClient() instead.
type ConfigurationGroupSchemasClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewConfigurationGroupSchemasClient creates a new instance of ConfigurationGroupSchemasClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewConfigurationGroupSchemasClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ConfigurationGroupSchemasClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ConfigurationGroupSchemasClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates a configuration group schema.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - configurationGroupSchemaName - The name of the configuration group schema.
//   - parameters - Parameters supplied to the create or update configuration group schema resource.
//   - options - ConfigurationGroupSchemasClientBeginCreateOrUpdateOptions contains the optional parameters for the ConfigurationGroupSchemasClient.BeginCreateOrUpdate
//     method.
func (client *ConfigurationGroupSchemasClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchema, options *ConfigurationGroupSchemasClientBeginCreateOrUpdateOptions) (*runtime.Poller[ConfigurationGroupSchemasClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConfigurationGroupSchemasClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConfigurationGroupSchemasClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates a configuration group schema.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ConfigurationGroupSchemasClient) createOrUpdate(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchema, options *ConfigurationGroupSchemasClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "ConfigurationGroupSchemasClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ConfigurationGroupSchemasClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchema, options *ConfigurationGroupSchemasClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if configurationGroupSchemaName == "" {
		return nil, errors.New("parameter configurationGroupSchemaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationGroupSchemaName}", url.PathEscape(configurationGroupSchemaName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a specified configuration group schema.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - configurationGroupSchemaName - The name of the configuration group schema.
//   - options - ConfigurationGroupSchemasClientBeginDeleteOptions contains the optional parameters for the ConfigurationGroupSchemasClient.BeginDelete
//     method.
func (client *ConfigurationGroupSchemasClient) BeginDelete(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, options *ConfigurationGroupSchemasClientBeginDeleteOptions) (*runtime.Poller[ConfigurationGroupSchemasClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConfigurationGroupSchemasClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConfigurationGroupSchemasClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a specified configuration group schema.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ConfigurationGroupSchemasClient) deleteOperation(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, options *ConfigurationGroupSchemasClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ConfigurationGroupSchemasClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ConfigurationGroupSchemasClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, options *ConfigurationGroupSchemasClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if configurationGroupSchemaName == "" {
		return nil, errors.New("parameter configurationGroupSchemaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationGroupSchemaName}", url.PathEscape(configurationGroupSchemaName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets information about the specified configuration group schema.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - configurationGroupSchemaName - The name of the configuration group schema.
//   - options - ConfigurationGroupSchemasClientGetOptions contains the optional parameters for the ConfigurationGroupSchemasClient.Get
//     method.
func (client *ConfigurationGroupSchemasClient) Get(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, options *ConfigurationGroupSchemasClientGetOptions) (ConfigurationGroupSchemasClientGetResponse, error) {
	var err error
	const operationName = "ConfigurationGroupSchemasClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, options)
	if err != nil {
		return ConfigurationGroupSchemasClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationGroupSchemasClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationGroupSchemasClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ConfigurationGroupSchemasClient) getCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, options *ConfigurationGroupSchemasClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if configurationGroupSchemaName == "" {
		return nil, errors.New("parameter configurationGroupSchemaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationGroupSchemaName}", url.PathEscape(configurationGroupSchemaName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ConfigurationGroupSchemasClient) getHandleResponse(resp *http.Response) (ConfigurationGroupSchemasClientGetResponse, error) {
	result := ConfigurationGroupSchemasClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationGroupSchema); err != nil {
		return ConfigurationGroupSchemasClientGetResponse{}, err
	}
	return result, nil
}

// NewListByPublisherPager - Gets information of the configuration group schemas under a publisher.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - options - ConfigurationGroupSchemasClientListByPublisherOptions contains the optional parameters for the ConfigurationGroupSchemasClient.NewListByPublisherPager
//     method.
func (client *ConfigurationGroupSchemasClient) NewListByPublisherPager(resourceGroupName string, publisherName string, options *ConfigurationGroupSchemasClientListByPublisherOptions) *runtime.Pager[ConfigurationGroupSchemasClientListByPublisherResponse] {
	return runtime.NewPager(runtime.PagingHandler[ConfigurationGroupSchemasClientListByPublisherResponse]{
		More: func(page ConfigurationGroupSchemasClientListByPublisherResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ConfigurationGroupSchemasClientListByPublisherResponse) (ConfigurationGroupSchemasClientListByPublisherResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ConfigurationGroupSchemasClient.NewListByPublisherPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByPublisherCreateRequest(ctx, resourceGroupName, publisherName, options)
			}, nil)
			if err != nil {
				return ConfigurationGroupSchemasClientListByPublisherResponse{}, err
			}
			return client.listByPublisherHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByPublisherCreateRequest creates the ListByPublisher request.
func (client *ConfigurationGroupSchemasClient) listByPublisherCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, options *ConfigurationGroupSchemasClientListByPublisherOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByPublisherHandleResponse handles the ListByPublisher response.
func (client *ConfigurationGroupSchemasClient) listByPublisherHandleResponse(resp *http.Response) (ConfigurationGroupSchemasClientListByPublisherResponse, error) {
	result := ConfigurationGroupSchemasClientListByPublisherResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationGroupSchemaListResult); err != nil {
		return ConfigurationGroupSchemasClientListByPublisherResponse{}, err
	}
	return result, nil
}

// Update - Updates a configuration group schema resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - configurationGroupSchemaName - The name of the configuration group schema.
//   - parameters - Parameters supplied to the create or update network service design version operation.
//   - options - ConfigurationGroupSchemasClientUpdateOptions contains the optional parameters for the ConfigurationGroupSchemasClient.Update
//     method.
func (client *ConfigurationGroupSchemasClient) Update(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters TagsObject, options *ConfigurationGroupSchemasClientUpdateOptions) (ConfigurationGroupSchemasClientUpdateResponse, error) {
	var err error
	const operationName = "ConfigurationGroupSchemasClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, parameters, options)
	if err != nil {
		return ConfigurationGroupSchemasClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationGroupSchemasClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationGroupSchemasClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ConfigurationGroupSchemasClient) updateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters TagsObject, options *ConfigurationGroupSchemasClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if configurationGroupSchemaName == "" {
		return nil, errors.New("parameter configurationGroupSchemaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationGroupSchemaName}", url.PathEscape(configurationGroupSchemaName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ConfigurationGroupSchemasClient) updateHandleResponse(resp *http.Response) (ConfigurationGroupSchemasClientUpdateResponse, error) {
	result := ConfigurationGroupSchemasClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationGroupSchema); err != nil {
		return ConfigurationGroupSchemasClientUpdateResponse{}, err
	}
	return result, nil
}

// BeginUpdateState - Update configuration group schema state.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - publisherName - The name of the publisher.
//   - configurationGroupSchemaName - The name of the configuration group schema.
//   - parameters - Parameters supplied to update the state of configuration group schema.
//   - options - ConfigurationGroupSchemasClientBeginUpdateStateOptions contains the optional parameters for the ConfigurationGroupSchemasClient.BeginUpdateState
//     method.
func (client *ConfigurationGroupSchemasClient) BeginUpdateState(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchemaVersionUpdateState, options *ConfigurationGroupSchemasClientBeginUpdateStateOptions) (*runtime.Poller[ConfigurationGroupSchemasClientUpdateStateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateState(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ConfigurationGroupSchemasClientUpdateStateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ConfigurationGroupSchemasClientUpdateStateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateState - Update configuration group schema state.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
func (client *ConfigurationGroupSchemasClient) updateState(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchemaVersionUpdateState, options *ConfigurationGroupSchemasClientBeginUpdateStateOptions) (*http.Response, error) {
	var err error
	const operationName = "ConfigurationGroupSchemasClient.BeginUpdateState"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateStateCreateRequest(ctx, resourceGroupName, publisherName, configurationGroupSchemaName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateStateCreateRequest creates the UpdateState request.
func (client *ConfigurationGroupSchemasClient) updateStateCreateRequest(ctx context.Context, resourceGroupName string, publisherName string, configurationGroupSchemaName string, parameters ConfigurationGroupSchemaVersionUpdateState, options *ConfigurationGroupSchemasClientBeginUpdateStateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/configurationGroupSchemas/{configurationGroupSchemaName}/updateState"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if publisherName == "" {
		return nil, errors.New("parameter publisherName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{publisherName}", url.PathEscape(publisherName))
	if configurationGroupSchemaName == "" {
		return nil, errors.New("parameter configurationGroupSchemaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationGroupSchemaName}", url.PathEscape(configurationGroupSchemaName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
