//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armengagementfabric

// Account - The EngagementFabric account
type Account struct {
	// REQUIRED; The location of the resource
	Location *string

	// REQUIRED; The SKU of the resource
	SKU *SKU

	// The tags of the resource
	Tags map[string]*string

	// READ-ONLY; The ID of the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The fully qualified type of the resource
	Type *string
}

// AccountList - The list of the EngagementFabric accounts
type AccountList struct {
	// EngagementFabric accounts
	Value []*Account
}

// AccountPatch - The patch of EngagementFabric account
type AccountPatch struct {
	// The tags of the resource
	Tags map[string]*string
}

// Channel - The EngagementFabric channel
type Channel struct {
	// The properties of the channel
	Properties *ChannelProperties

	// READ-ONLY; The ID of the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The fully qualified type of the resource
	Type *string
}

// ChannelList - The list of the EngagementFabric channels
type ChannelList struct {
	// EngagementFabric channels
	Value []*Channel
}

// ChannelProperties - The EngagementFabric channel properties
type ChannelProperties struct {
	// REQUIRED; The channel type
	ChannelType *string

	// The functions to be enabled for the channel
	ChannelFunctions []*string

	// The channel credentials
	Credentials map[string]*string
}

// ChannelTypeDescription - EngagementFabric channel description
type ChannelTypeDescription struct {
	// Text description for the channel
	ChannelDescription *string

	// All the available functions for the channel
	ChannelFunctions []*string

	// Channel type
	ChannelType *string
}

// ChannelTypeDescriptionList - List of the EngagementFabric channel descriptions
type ChannelTypeDescriptionList struct {
	// Channel descriptions
	Value []*ChannelTypeDescription
}

// CheckNameAvailabilityParameter - The parameter for name availability check
type CheckNameAvailabilityParameter struct {
	// REQUIRED; The name to be checked
	Name *string

	// REQUIRED; The fully qualified resource type for the name to be checked
	Type *string
}

// CheckNameAvailabilityResult - The result of name availability check
type CheckNameAvailabilityResult struct {
	// READ-ONLY; The message if name is unavailable
	Message *string

	// READ-ONLY; The name to be checked
	NameAvailable *bool

	// READ-ONLY; The reason if name is unavailable
	Reason *CheckNameUnavailableReason
}

// KeyDescription - The description of the EngagementFabric account key
type KeyDescription struct {
	// READ-ONLY; The name of the key
	Name *string

	// READ-ONLY; The rank of the key
	Rank *KeyRank

	// READ-ONLY; The value of the key
	Value *string
}

// KeyDescriptionList - The list of the EngagementFabric account keys
type KeyDescriptionList struct {
	// READ-ONLY; Account keys
	Value []*KeyDescription
}

// Operation - The EngagementFabric operation
type Operation struct {
	// READ-ONLY; The display content of the EngagementFabric operation
	Display *OperationDisplay

	// READ-ONLY; The name of the EngagementFabric operation
	Name *string
}

// OperationDisplay - The display information of the EngagementFabric operation
type OperationDisplay struct {
	// READ-ONLY; The description of the EngagementFabric operation
	Description *string

	// READ-ONLY; The name of the EngagementFabric operation
	Operation *string

	// READ-ONLY; The resource provider namespace of the EngagementFabric operation
	Provider *string

	// READ-ONLY; The resource type of the EngagementFabric operation
	Resource *string
}

// OperationList - The list of the EngagementFabric operations
type OperationList struct {
	// READ-ONLY; The EngagementFabric operations
	Value []*Operation
}

// ProxyOnlyResource - The base model for the proxy-only Azure resource
type ProxyOnlyResource struct {
	// READ-ONLY; The ID of the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The fully qualified type of the resource
	Type *string
}

// RegenerateKeyParameter - The parameter to regenerate single EngagementFabric account key
type RegenerateKeyParameter struct {
	// REQUIRED; The name of key to be regenerated
	Name *string

	// REQUIRED; The rank of the key to be regenerated
	Rank *KeyRank
}

// Resource - The base model for Azure resource
type Resource struct {
	// READ-ONLY; The ID of the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The fully qualified type of the resource
	Type *string
}

// SKU - The EngagementFabric SKU
type SKU struct {
	// REQUIRED; The name of the SKU
	Name *string

	// The price tier of the SKU
	Tier *string
}

// SKUDescription - The EngagementFabric SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string

	// READ-ONLY; The name of the SKU
	Name *string

	// READ-ONLY; The fully qualified resource type
	ResourceType *string

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []any

	// READ-ONLY; The price tier of the SKU
	Tier *string
}

// SKUDescriptionList - The list of the EngagementFabric SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription
}

// SKULocationInfoItem - The Locations and zones info for SKU
type SKULocationInfoItem struct {
	// The available location of the SKU
	Location *string

	// The available zone of the SKU
	Zones []*string
}

// TrackedResource - The base model for the tracked Azure resource
type TrackedResource struct {
	// REQUIRED; The location of the resource
	Location *string

	// REQUIRED; The SKU of the resource
	SKU *SKU

	// The tags of the resource
	Tags map[string]*string

	// READ-ONLY; The ID of the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The fully qualified type of the resource
	Type *string
}
