//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armdatalakeanalytics.ClientFactory type.
type ServerFactory struct {
	AccountsServer              AccountsServer
	ComputePoliciesServer       ComputePoliciesServer
	DataLakeStoreAccountsServer DataLakeStoreAccountsServer
	FirewallRulesServer         FirewallRulesServer
	LocationsServer             LocationsServer
	OperationsServer            OperationsServer
	StorageAccountsServer       StorageAccountsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armdatalakeanalytics.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armdatalakeanalytics.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                           *ServerFactory
	trMu                          sync.Mutex
	trAccountsServer              *AccountsServerTransport
	trComputePoliciesServer       *ComputePoliciesServerTransport
	trDataLakeStoreAccountsServer *DataLakeStoreAccountsServerTransport
	trFirewallRulesServer         *FirewallRulesServerTransport
	trLocationsServer             *LocationsServerTransport
	trOperationsServer            *OperationsServerTransport
	trStorageAccountsServer       *StorageAccountsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountsClient":
		initServer(s, &s.trAccountsServer, func() *AccountsServerTransport { return NewAccountsServerTransport(&s.srv.AccountsServer) })
		resp, err = s.trAccountsServer.Do(req)
	case "ComputePoliciesClient":
		initServer(s, &s.trComputePoliciesServer, func() *ComputePoliciesServerTransport {
			return NewComputePoliciesServerTransport(&s.srv.ComputePoliciesServer)
		})
		resp, err = s.trComputePoliciesServer.Do(req)
	case "DataLakeStoreAccountsClient":
		initServer(s, &s.trDataLakeStoreAccountsServer, func() *DataLakeStoreAccountsServerTransport {
			return NewDataLakeStoreAccountsServerTransport(&s.srv.DataLakeStoreAccountsServer)
		})
		resp, err = s.trDataLakeStoreAccountsServer.Do(req)
	case "FirewallRulesClient":
		initServer(s, &s.trFirewallRulesServer, func() *FirewallRulesServerTransport {
			return NewFirewallRulesServerTransport(&s.srv.FirewallRulesServer)
		})
		resp, err = s.trFirewallRulesServer.Do(req)
	case "LocationsClient":
		initServer(s, &s.trLocationsServer, func() *LocationsServerTransport { return NewLocationsServerTransport(&s.srv.LocationsServer) })
		resp, err = s.trLocationsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "StorageAccountsClient":
		initServer(s, &s.trStorageAccountsServer, func() *StorageAccountsServerTransport {
			return NewStorageAccountsServerTransport(&s.srv.StorageAccountsServer)
		})
		resp, err = s.trStorageAccountsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
