//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armconnectedvmware.ClientFactory type.
type ServerFactory struct {
	ClustersServer                         ClustersServer
	DatastoresServer                       DatastoresServer
	HostsServer                            HostsServer
	InventoryItemsServer                   InventoryItemsServer
	OperationsServer                       OperationsServer
	ResourcePoolsServer                    ResourcePoolsServer
	VCentersServer                         VCentersServer
	VMInstanceGuestAgentsServer            VMInstanceGuestAgentsServer
	VMInstanceHybridIdentityMetadataServer VMInstanceHybridIdentityMetadataServer
	VirtualMachineInstancesServer          VirtualMachineInstancesServer
	VirtualMachineTemplatesServer          VirtualMachineTemplatesServer
	VirtualNetworksServer                  VirtualNetworksServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armconnectedvmware.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armconnectedvmware.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                      *ServerFactory
	trMu                                     sync.Mutex
	trClustersServer                         *ClustersServerTransport
	trDatastoresServer                       *DatastoresServerTransport
	trHostsServer                            *HostsServerTransport
	trInventoryItemsServer                   *InventoryItemsServerTransport
	trOperationsServer                       *OperationsServerTransport
	trResourcePoolsServer                    *ResourcePoolsServerTransport
	trVCentersServer                         *VCentersServerTransport
	trVMInstanceGuestAgentsServer            *VMInstanceGuestAgentsServerTransport
	trVMInstanceHybridIdentityMetadataServer *VMInstanceHybridIdentityMetadataServerTransport
	trVirtualMachineInstancesServer          *VirtualMachineInstancesServerTransport
	trVirtualMachineTemplatesServer          *VirtualMachineTemplatesServerTransport
	trVirtualNetworksServer                  *VirtualNetworksServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ClustersClient":
		initServer(s, &s.trClustersServer, func() *ClustersServerTransport { return NewClustersServerTransport(&s.srv.ClustersServer) })
		resp, err = s.trClustersServer.Do(req)
	case "DatastoresClient":
		initServer(s, &s.trDatastoresServer, func() *DatastoresServerTransport { return NewDatastoresServerTransport(&s.srv.DatastoresServer) })
		resp, err = s.trDatastoresServer.Do(req)
	case "HostsClient":
		initServer(s, &s.trHostsServer, func() *HostsServerTransport { return NewHostsServerTransport(&s.srv.HostsServer) })
		resp, err = s.trHostsServer.Do(req)
	case "InventoryItemsClient":
		initServer(s, &s.trInventoryItemsServer, func() *InventoryItemsServerTransport {
			return NewInventoryItemsServerTransport(&s.srv.InventoryItemsServer)
		})
		resp, err = s.trInventoryItemsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ResourcePoolsClient":
		initServer(s, &s.trResourcePoolsServer, func() *ResourcePoolsServerTransport {
			return NewResourcePoolsServerTransport(&s.srv.ResourcePoolsServer)
		})
		resp, err = s.trResourcePoolsServer.Do(req)
	case "VCentersClient":
		initServer(s, &s.trVCentersServer, func() *VCentersServerTransport { return NewVCentersServerTransport(&s.srv.VCentersServer) })
		resp, err = s.trVCentersServer.Do(req)
	case "VMInstanceGuestAgentsClient":
		initServer(s, &s.trVMInstanceGuestAgentsServer, func() *VMInstanceGuestAgentsServerTransport {
			return NewVMInstanceGuestAgentsServerTransport(&s.srv.VMInstanceGuestAgentsServer)
		})
		resp, err = s.trVMInstanceGuestAgentsServer.Do(req)
	case "VMInstanceHybridIdentityMetadataClient":
		initServer(s, &s.trVMInstanceHybridIdentityMetadataServer, func() *VMInstanceHybridIdentityMetadataServerTransport {
			return NewVMInstanceHybridIdentityMetadataServerTransport(&s.srv.VMInstanceHybridIdentityMetadataServer)
		})
		resp, err = s.trVMInstanceHybridIdentityMetadataServer.Do(req)
	case "VirtualMachineInstancesClient":
		initServer(s, &s.trVirtualMachineInstancesServer, func() *VirtualMachineInstancesServerTransport {
			return NewVirtualMachineInstancesServerTransport(&s.srv.VirtualMachineInstancesServer)
		})
		resp, err = s.trVirtualMachineInstancesServer.Do(req)
	case "VirtualMachineTemplatesClient":
		initServer(s, &s.trVirtualMachineTemplatesServer, func() *VirtualMachineTemplatesServerTransport {
			return NewVirtualMachineTemplatesServerTransport(&s.srv.VirtualMachineTemplatesServer)
		})
		resp, err = s.trVirtualMachineTemplatesServer.Do(req)
	case "VirtualNetworksClient":
		initServer(s, &s.trVirtualNetworksServer, func() *VirtualNetworksServerTransport {
			return NewVirtualNetworksServerTransport(&s.srv.VirtualNetworksServer)
		})
		resp, err = s.trVirtualNetworksServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
