//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AFDOriginsServer is a fake server for instances of the armcdn.AFDOriginsClient type.
type AFDOriginsServer struct {
	// BeginCreate is the fake for method AFDOriginsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, origin armcdn.AFDOrigin, options *armcdn.AFDOriginsClientBeginCreateOptions) (resp azfake.PollerResponder[armcdn.AFDOriginsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AFDOriginsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, options *armcdn.AFDOriginsClientBeginDeleteOptions) (resp azfake.PollerResponder[armcdn.AFDOriginsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AFDOriginsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, options *armcdn.AFDOriginsClientGetOptions) (resp azfake.Responder[armcdn.AFDOriginsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByOriginGroupPager is the fake for method AFDOriginsClient.NewListByOriginGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByOriginGroupPager func(resourceGroupName string, profileName string, originGroupName string, options *armcdn.AFDOriginsClientListByOriginGroupOptions) (resp azfake.PagerResponder[armcdn.AFDOriginsClientListByOriginGroupResponse])

	// BeginUpdate is the fake for method AFDOriginsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, profileName string, originGroupName string, originName string, originUpdateProperties armcdn.AFDOriginUpdateParameters, options *armcdn.AFDOriginsClientBeginUpdateOptions) (resp azfake.PollerResponder[armcdn.AFDOriginsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAFDOriginsServerTransport creates a new instance of AFDOriginsServerTransport with the provided implementation.
// The returned AFDOriginsServerTransport instance is connected to an instance of armcdn.AFDOriginsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAFDOriginsServerTransport(srv *AFDOriginsServer) *AFDOriginsServerTransport {
	return &AFDOriginsServerTransport{
		srv:                       srv,
		beginCreate:               newTracker[azfake.PollerResponder[armcdn.AFDOriginsClientCreateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armcdn.AFDOriginsClientDeleteResponse]](),
		newListByOriginGroupPager: newTracker[azfake.PagerResponder[armcdn.AFDOriginsClientListByOriginGroupResponse]](),
		beginUpdate:               newTracker[azfake.PollerResponder[armcdn.AFDOriginsClientUpdateResponse]](),
	}
}

// AFDOriginsServerTransport connects instances of armcdn.AFDOriginsClient to instances of AFDOriginsServer.
// Don't use this type directly, use NewAFDOriginsServerTransport instead.
type AFDOriginsServerTransport struct {
	srv                       *AFDOriginsServer
	beginCreate               *tracker[azfake.PollerResponder[armcdn.AFDOriginsClientCreateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armcdn.AFDOriginsClientDeleteResponse]]
	newListByOriginGroupPager *tracker[azfake.PagerResponder[armcdn.AFDOriginsClientListByOriginGroupResponse]]
	beginUpdate               *tracker[azfake.PollerResponder[armcdn.AFDOriginsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for AFDOriginsServerTransport.
func (a *AFDOriginsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AFDOriginsClient.BeginCreate":
		resp, err = a.dispatchBeginCreate(req)
	case "AFDOriginsClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AFDOriginsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AFDOriginsClient.NewListByOriginGroupPager":
		resp, err = a.dispatchNewListByOriginGroupPager(req)
	case "AFDOriginsClient.BeginUpdate":
		resp, err = a.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AFDOriginsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := a.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/originGroups/(?P<originGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/origins/(?P<originName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcdn.AFDOrigin](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		originGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originGroupName")])
		if err != nil {
			return nil, err
		}
		originNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreate(req.Context(), resourceGroupNameParam, profileNameParam, originGroupNameParam, originNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		a.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		a.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		a.beginCreate.remove(req)
	}

	return resp, nil
}

func (a *AFDOriginsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/originGroups/(?P<originGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/origins/(?P<originName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		originGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originGroupName")])
		if err != nil {
			return nil, err
		}
		originNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, profileNameParam, originGroupNameParam, originNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AFDOriginsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/originGroups/(?P<originGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/origins/(?P<originName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	originGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originGroupName")])
	if err != nil {
		return nil, err
	}
	originNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, profileNameParam, originGroupNameParam, originNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AFDOrigin, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AFDOriginsServerTransport) dispatchNewListByOriginGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByOriginGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByOriginGroupPager not implemented")}
	}
	newListByOriginGroupPager := a.newListByOriginGroupPager.get(req)
	if newListByOriginGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/originGroups/(?P<originGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/origins`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		originGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByOriginGroupPager(resourceGroupNameParam, profileNameParam, originGroupNameParam, nil)
		newListByOriginGroupPager = &resp
		a.newListByOriginGroupPager.add(req, newListByOriginGroupPager)
		server.PagerResponderInjectNextLinks(newListByOriginGroupPager, req, func(page *armcdn.AFDOriginsClientListByOriginGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByOriginGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByOriginGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByOriginGroupPager) {
		a.newListByOriginGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AFDOriginsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := a.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/originGroups/(?P<originGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/origins/(?P<originName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcdn.AFDOriginUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		originGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originGroupName")])
		if err != nil {
			return nil, err
		}
		originNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("originName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginUpdate(req.Context(), resourceGroupNameParam, profileNameParam, originGroupNameParam, originNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		a.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		a.beginUpdate.remove(req)
	}

	return resp, nil
}
