//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblueprint

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewArtifactsClient creates a new instance of ArtifactsClient.
func (c *ClientFactory) NewArtifactsClient() *ArtifactsClient {
	subClient, _ := NewArtifactsClient(c.credential, c.options)
	return subClient
}

// NewAssignmentOperationsClient creates a new instance of AssignmentOperationsClient.
func (c *ClientFactory) NewAssignmentOperationsClient() *AssignmentOperationsClient {
	subClient, _ := NewAssignmentOperationsClient(c.credential, c.options)
	return subClient
}

// NewAssignmentsClient creates a new instance of AssignmentsClient.
func (c *ClientFactory) NewAssignmentsClient() *AssignmentsClient {
	subClient, _ := NewAssignmentsClient(c.credential, c.options)
	return subClient
}

// NewBlueprintsClient creates a new instance of BlueprintsClient.
func (c *ClientFactory) NewBlueprintsClient() *BlueprintsClient {
	subClient, _ := NewBlueprintsClient(c.credential, c.options)
	return subClient
}

// NewPublishedArtifactsClient creates a new instance of PublishedArtifactsClient.
func (c *ClientFactory) NewPublishedArtifactsClient() *PublishedArtifactsClient {
	subClient, _ := NewPublishedArtifactsClient(c.credential, c.options)
	return subClient
}

// NewPublishedBlueprintsClient creates a new instance of PublishedBlueprintsClient.
func (c *ClientFactory) NewPublishedBlueprintsClient() *PublishedBlueprintsClient {
	subClient, _ := NewPublishedBlueprintsClient(c.credential, c.options)
	return subClient
}
