//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
	"net/http"
	"net/url"
	"regexp"
)

// WorkloadNetworksServer is a fake server for instances of the armavs.WorkloadNetworksClient type.
type WorkloadNetworksServer struct {
	// BeginCreateDNSService is the fake for method WorkloadNetworksClient.BeginCreateDNSService
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateDNSService func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsServiceID string, workloadNetworkDNSService armavs.WorkloadNetworkDNSService, options *armavs.WorkloadNetworksClientBeginCreateDNSServiceOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSServiceResponse], errResp azfake.ErrorResponder)

	// BeginCreateDNSZone is the fake for method WorkloadNetworksClient.BeginCreateDNSZone
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateDNSZone func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsZoneID string, workloadNetworkDNSZone armavs.WorkloadNetworkDNSZone, options *armavs.WorkloadNetworksClientBeginCreateDNSZoneOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSZoneResponse], errResp azfake.ErrorResponder)

	// BeginCreateDhcp is the fake for method WorkloadNetworksClient.BeginCreateDhcp
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateDhcp func(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp armavs.WorkloadNetworkDhcp, options *armavs.WorkloadNetworksClientBeginCreateDhcpOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDhcpResponse], errResp azfake.ErrorResponder)

	// BeginCreatePortMirroring is the fake for method WorkloadNetworksClient.BeginCreatePortMirroring
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreatePortMirroring func(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring armavs.WorkloadNetworkPortMirroring, options *armavs.WorkloadNetworksClientBeginCreatePortMirroringOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePortMirroringResponse], errResp azfake.ErrorResponder)

	// BeginCreatePublicIP is the fake for method WorkloadNetworksClient.BeginCreatePublicIP
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreatePublicIP func(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string, workloadNetworkPublicIP armavs.WorkloadNetworkPublicIP, options *armavs.WorkloadNetworksClientBeginCreatePublicIPOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePublicIPResponse], errResp azfake.ErrorResponder)

	// BeginCreateSegments is the fake for method WorkloadNetworksClient.BeginCreateSegments
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateSegments func(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment armavs.WorkloadNetworkSegment, options *armavs.WorkloadNetworksClientBeginCreateSegmentsOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreateSegmentsResponse], errResp azfake.ErrorResponder)

	// BeginCreateVMGroup is the fake for method WorkloadNetworksClient.BeginCreateVMGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateVMGroup func(ctx context.Context, resourceGroupName string, privateCloudName string, vmGroupID string, workloadNetworkVMGroup armavs.WorkloadNetworkVMGroup, options *armavs.WorkloadNetworksClientBeginCreateVMGroupOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientCreateVMGroupResponse], errResp azfake.ErrorResponder)

	// BeginDeleteDNSService is the fake for method WorkloadNetworksClient.BeginDeleteDNSService
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteDNSService func(ctx context.Context, resourceGroupName string, dnsServiceID string, privateCloudName string, options *armavs.WorkloadNetworksClientBeginDeleteDNSServiceOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSServiceResponse], errResp azfake.ErrorResponder)

	// BeginDeleteDNSZone is the fake for method WorkloadNetworksClient.BeginDeleteDNSZone
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteDNSZone func(ctx context.Context, resourceGroupName string, dnsZoneID string, privateCloudName string, options *armavs.WorkloadNetworksClientBeginDeleteDNSZoneOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSZoneResponse], errResp azfake.ErrorResponder)

	// BeginDeleteDhcp is the fake for method WorkloadNetworksClient.BeginDeleteDhcp
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteDhcp func(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, options *armavs.WorkloadNetworksClientBeginDeleteDhcpOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDhcpResponse], errResp azfake.ErrorResponder)

	// BeginDeletePortMirroring is the fake for method WorkloadNetworksClient.BeginDeletePortMirroring
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePortMirroring func(ctx context.Context, resourceGroupName string, portMirroringID string, privateCloudName string, options *armavs.WorkloadNetworksClientBeginDeletePortMirroringOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePortMirroringResponse], errResp azfake.ErrorResponder)

	// BeginDeletePublicIP is the fake for method WorkloadNetworksClient.BeginDeletePublicIP
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePublicIP func(ctx context.Context, resourceGroupName string, publicIPID string, privateCloudName string, options *armavs.WorkloadNetworksClientBeginDeletePublicIPOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePublicIPResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSegment is the fake for method WorkloadNetworksClient.BeginDeleteSegment
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteSegment func(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, options *armavs.WorkloadNetworksClientBeginDeleteSegmentOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteSegmentResponse], errResp azfake.ErrorResponder)

	// BeginDeleteVMGroup is the fake for method WorkloadNetworksClient.BeginDeleteVMGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteVMGroup func(ctx context.Context, resourceGroupName string, vmGroupID string, privateCloudName string, options *armavs.WorkloadNetworksClientBeginDeleteVMGroupOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteVMGroupResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WorkloadNetworksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, privateCloudName string, workloadNetworkName armavs.WorkloadNetworkName, options *armavs.WorkloadNetworksClientGetOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetResponse], errResp azfake.ErrorResponder)

	// GetDNSService is the fake for method WorkloadNetworksClient.GetDNSService
	// HTTP status codes to indicate success: http.StatusOK
	GetDNSService func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsServiceID string, options *armavs.WorkloadNetworksClientGetDNSServiceOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetDNSServiceResponse], errResp azfake.ErrorResponder)

	// GetDNSZone is the fake for method WorkloadNetworksClient.GetDNSZone
	// HTTP status codes to indicate success: http.StatusOK
	GetDNSZone func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsZoneID string, options *armavs.WorkloadNetworksClientGetDNSZoneOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetDNSZoneResponse], errResp azfake.ErrorResponder)

	// GetDhcp is the fake for method WorkloadNetworksClient.GetDhcp
	// HTTP status codes to indicate success: http.StatusOK
	GetDhcp func(ctx context.Context, resourceGroupName string, dhcpID string, privateCloudName string, options *armavs.WorkloadNetworksClientGetDhcpOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetDhcpResponse], errResp azfake.ErrorResponder)

	// GetGateway is the fake for method WorkloadNetworksClient.GetGateway
	// HTTP status codes to indicate success: http.StatusOK
	GetGateway func(ctx context.Context, resourceGroupName string, privateCloudName string, gatewayID string, options *armavs.WorkloadNetworksClientGetGatewayOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetGatewayResponse], errResp azfake.ErrorResponder)

	// GetPortMirroring is the fake for method WorkloadNetworksClient.GetPortMirroring
	// HTTP status codes to indicate success: http.StatusOK
	GetPortMirroring func(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, options *armavs.WorkloadNetworksClientGetPortMirroringOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetPortMirroringResponse], errResp azfake.ErrorResponder)

	// GetPublicIP is the fake for method WorkloadNetworksClient.GetPublicIP
	// HTTP status codes to indicate success: http.StatusOK
	GetPublicIP func(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string, options *armavs.WorkloadNetworksClientGetPublicIPOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetPublicIPResponse], errResp azfake.ErrorResponder)

	// GetSegment is the fake for method WorkloadNetworksClient.GetSegment
	// HTTP status codes to indicate success: http.StatusOK
	GetSegment func(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, options *armavs.WorkloadNetworksClientGetSegmentOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetSegmentResponse], errResp azfake.ErrorResponder)

	// GetVMGroup is the fake for method WorkloadNetworksClient.GetVMGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetVMGroup func(ctx context.Context, resourceGroupName string, privateCloudName string, vmGroupID string, options *armavs.WorkloadNetworksClientGetVMGroupOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetVMGroupResponse], errResp azfake.ErrorResponder)

	// GetVirtualMachine is the fake for method WorkloadNetworksClient.GetVirtualMachine
	// HTTP status codes to indicate success: http.StatusOK
	GetVirtualMachine func(ctx context.Context, resourceGroupName string, privateCloudName string, virtualMachineID string, options *armavs.WorkloadNetworksClientGetVirtualMachineOptions) (resp azfake.Responder[armavs.WorkloadNetworksClientGetVirtualMachineResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WorkloadNetworksClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListResponse])

	// NewListDNSServicesPager is the fake for method WorkloadNetworksClient.NewListDNSServicesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDNSServicesPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListDNSServicesOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSServicesResponse])

	// NewListDNSZonesPager is the fake for method WorkloadNetworksClient.NewListDNSZonesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDNSZonesPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListDNSZonesOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSZonesResponse])

	// NewListDhcpPager is the fake for method WorkloadNetworksClient.NewListDhcpPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDhcpPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListDhcpOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListDhcpResponse])

	// NewListGatewaysPager is the fake for method WorkloadNetworksClient.NewListGatewaysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGatewaysPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListGatewaysOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListGatewaysResponse])

	// NewListPortMirroringPager is the fake for method WorkloadNetworksClient.NewListPortMirroringPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPortMirroringPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListPortMirroringOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListPortMirroringResponse])

	// NewListPublicIPsPager is the fake for method WorkloadNetworksClient.NewListPublicIPsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPublicIPsPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListPublicIPsOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListPublicIPsResponse])

	// NewListSegmentsPager is the fake for method WorkloadNetworksClient.NewListSegmentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSegmentsPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListSegmentsOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListSegmentsResponse])

	// NewListVMGroupsPager is the fake for method WorkloadNetworksClient.NewListVMGroupsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVMGroupsPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListVMGroupsOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListVMGroupsResponse])

	// NewListVirtualMachinesPager is the fake for method WorkloadNetworksClient.NewListVirtualMachinesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVirtualMachinesPager func(resourceGroupName string, privateCloudName string, options *armavs.WorkloadNetworksClientListVirtualMachinesOptions) (resp azfake.PagerResponder[armavs.WorkloadNetworksClientListVirtualMachinesResponse])

	// BeginUpdateDNSService is the fake for method WorkloadNetworksClient.BeginUpdateDNSService
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateDNSService func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsServiceID string, workloadNetworkDNSService armavs.WorkloadNetworkDNSService, options *armavs.WorkloadNetworksClientBeginUpdateDNSServiceOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSServiceResponse], errResp azfake.ErrorResponder)

	// BeginUpdateDNSZone is the fake for method WorkloadNetworksClient.BeginUpdateDNSZone
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateDNSZone func(ctx context.Context, resourceGroupName string, privateCloudName string, dnsZoneID string, workloadNetworkDNSZone armavs.WorkloadNetworkDNSZone, options *armavs.WorkloadNetworksClientBeginUpdateDNSZoneOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSZoneResponse], errResp azfake.ErrorResponder)

	// BeginUpdateDhcp is the fake for method WorkloadNetworksClient.BeginUpdateDhcp
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateDhcp func(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp armavs.WorkloadNetworkDhcp, options *armavs.WorkloadNetworksClientBeginUpdateDhcpOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDhcpResponse], errResp azfake.ErrorResponder)

	// BeginUpdatePortMirroring is the fake for method WorkloadNetworksClient.BeginUpdatePortMirroring
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdatePortMirroring func(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring armavs.WorkloadNetworkPortMirroring, options *armavs.WorkloadNetworksClientBeginUpdatePortMirroringOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdatePortMirroringResponse], errResp azfake.ErrorResponder)

	// BeginUpdateSegments is the fake for method WorkloadNetworksClient.BeginUpdateSegments
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateSegments func(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment armavs.WorkloadNetworkSegment, options *armavs.WorkloadNetworksClientBeginUpdateSegmentsOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateSegmentsResponse], errResp azfake.ErrorResponder)

	// BeginUpdateVMGroup is the fake for method WorkloadNetworksClient.BeginUpdateVMGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateVMGroup func(ctx context.Context, resourceGroupName string, privateCloudName string, vmGroupID string, workloadNetworkVMGroup armavs.WorkloadNetworkVMGroup, options *armavs.WorkloadNetworksClientBeginUpdateVMGroupOptions) (resp azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateVMGroupResponse], errResp azfake.ErrorResponder)
}

// NewWorkloadNetworksServerTransport creates a new instance of WorkloadNetworksServerTransport with the provided implementation.
// The returned WorkloadNetworksServerTransport instance is connected to an instance of armavs.WorkloadNetworksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkloadNetworksServerTransport(srv *WorkloadNetworksServer) *WorkloadNetworksServerTransport {
	return &WorkloadNetworksServerTransport{
		srv:                         srv,
		beginCreateDNSService:       newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSServiceResponse]](),
		beginCreateDNSZone:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSZoneResponse]](),
		beginCreateDhcp:             newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDhcpResponse]](),
		beginCreatePortMirroring:    newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePortMirroringResponse]](),
		beginCreatePublicIP:         newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePublicIPResponse]](),
		beginCreateSegments:         newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateSegmentsResponse]](),
		beginCreateVMGroup:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateVMGroupResponse]](),
		beginDeleteDNSService:       newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSServiceResponse]](),
		beginDeleteDNSZone:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSZoneResponse]](),
		beginDeleteDhcp:             newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDhcpResponse]](),
		beginDeletePortMirroring:    newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePortMirroringResponse]](),
		beginDeletePublicIP:         newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePublicIPResponse]](),
		beginDeleteSegment:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteSegmentResponse]](),
		beginDeleteVMGroup:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteVMGroupResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListResponse]](),
		newListDNSServicesPager:     newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSServicesResponse]](),
		newListDNSZonesPager:        newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSZonesResponse]](),
		newListDhcpPager:            newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDhcpResponse]](),
		newListGatewaysPager:        newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListGatewaysResponse]](),
		newListPortMirroringPager:   newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListPortMirroringResponse]](),
		newListPublicIPsPager:       newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListPublicIPsResponse]](),
		newListSegmentsPager:        newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListSegmentsResponse]](),
		newListVMGroupsPager:        newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListVMGroupsResponse]](),
		newListVirtualMachinesPager: newTracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListVirtualMachinesResponse]](),
		beginUpdateDNSService:       newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSServiceResponse]](),
		beginUpdateDNSZone:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSZoneResponse]](),
		beginUpdateDhcp:             newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDhcpResponse]](),
		beginUpdatePortMirroring:    newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdatePortMirroringResponse]](),
		beginUpdateSegments:         newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateSegmentsResponse]](),
		beginUpdateVMGroup:          newTracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateVMGroupResponse]](),
	}
}

// WorkloadNetworksServerTransport connects instances of armavs.WorkloadNetworksClient to instances of WorkloadNetworksServer.
// Don't use this type directly, use NewWorkloadNetworksServerTransport instead.
type WorkloadNetworksServerTransport struct {
	srv                         *WorkloadNetworksServer
	beginCreateDNSService       *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSServiceResponse]]
	beginCreateDNSZone          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDNSZoneResponse]]
	beginCreateDhcp             *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateDhcpResponse]]
	beginCreatePortMirroring    *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePortMirroringResponse]]
	beginCreatePublicIP         *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreatePublicIPResponse]]
	beginCreateSegments         *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateSegmentsResponse]]
	beginCreateVMGroup          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientCreateVMGroupResponse]]
	beginDeleteDNSService       *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSServiceResponse]]
	beginDeleteDNSZone          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDNSZoneResponse]]
	beginDeleteDhcp             *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteDhcpResponse]]
	beginDeletePortMirroring    *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePortMirroringResponse]]
	beginDeletePublicIP         *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeletePublicIPResponse]]
	beginDeleteSegment          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteSegmentResponse]]
	beginDeleteVMGroup          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientDeleteVMGroupResponse]]
	newListPager                *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListResponse]]
	newListDNSServicesPager     *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSServicesResponse]]
	newListDNSZonesPager        *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDNSZonesResponse]]
	newListDhcpPager            *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListDhcpResponse]]
	newListGatewaysPager        *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListGatewaysResponse]]
	newListPortMirroringPager   *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListPortMirroringResponse]]
	newListPublicIPsPager       *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListPublicIPsResponse]]
	newListSegmentsPager        *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListSegmentsResponse]]
	newListVMGroupsPager        *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListVMGroupsResponse]]
	newListVirtualMachinesPager *tracker[azfake.PagerResponder[armavs.WorkloadNetworksClientListVirtualMachinesResponse]]
	beginUpdateDNSService       *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSServiceResponse]]
	beginUpdateDNSZone          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDNSZoneResponse]]
	beginUpdateDhcp             *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateDhcpResponse]]
	beginUpdatePortMirroring    *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdatePortMirroringResponse]]
	beginUpdateSegments         *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateSegmentsResponse]]
	beginUpdateVMGroup          *tracker[azfake.PollerResponder[armavs.WorkloadNetworksClientUpdateVMGroupResponse]]
}

// Do implements the policy.Transporter interface for WorkloadNetworksServerTransport.
func (w *WorkloadNetworksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkloadNetworksClient.BeginCreateDNSService":
		resp, err = w.dispatchBeginCreateDNSService(req)
	case "WorkloadNetworksClient.BeginCreateDNSZone":
		resp, err = w.dispatchBeginCreateDNSZone(req)
	case "WorkloadNetworksClient.BeginCreateDhcp":
		resp, err = w.dispatchBeginCreateDhcp(req)
	case "WorkloadNetworksClient.BeginCreatePortMirroring":
		resp, err = w.dispatchBeginCreatePortMirroring(req)
	case "WorkloadNetworksClient.BeginCreatePublicIP":
		resp, err = w.dispatchBeginCreatePublicIP(req)
	case "WorkloadNetworksClient.BeginCreateSegments":
		resp, err = w.dispatchBeginCreateSegments(req)
	case "WorkloadNetworksClient.BeginCreateVMGroup":
		resp, err = w.dispatchBeginCreateVMGroup(req)
	case "WorkloadNetworksClient.BeginDeleteDNSService":
		resp, err = w.dispatchBeginDeleteDNSService(req)
	case "WorkloadNetworksClient.BeginDeleteDNSZone":
		resp, err = w.dispatchBeginDeleteDNSZone(req)
	case "WorkloadNetworksClient.BeginDeleteDhcp":
		resp, err = w.dispatchBeginDeleteDhcp(req)
	case "WorkloadNetworksClient.BeginDeletePortMirroring":
		resp, err = w.dispatchBeginDeletePortMirroring(req)
	case "WorkloadNetworksClient.BeginDeletePublicIP":
		resp, err = w.dispatchBeginDeletePublicIP(req)
	case "WorkloadNetworksClient.BeginDeleteSegment":
		resp, err = w.dispatchBeginDeleteSegment(req)
	case "WorkloadNetworksClient.BeginDeleteVMGroup":
		resp, err = w.dispatchBeginDeleteVMGroup(req)
	case "WorkloadNetworksClient.Get":
		resp, err = w.dispatchGet(req)
	case "WorkloadNetworksClient.GetDNSService":
		resp, err = w.dispatchGetDNSService(req)
	case "WorkloadNetworksClient.GetDNSZone":
		resp, err = w.dispatchGetDNSZone(req)
	case "WorkloadNetworksClient.GetDhcp":
		resp, err = w.dispatchGetDhcp(req)
	case "WorkloadNetworksClient.GetGateway":
		resp, err = w.dispatchGetGateway(req)
	case "WorkloadNetworksClient.GetPortMirroring":
		resp, err = w.dispatchGetPortMirroring(req)
	case "WorkloadNetworksClient.GetPublicIP":
		resp, err = w.dispatchGetPublicIP(req)
	case "WorkloadNetworksClient.GetSegment":
		resp, err = w.dispatchGetSegment(req)
	case "WorkloadNetworksClient.GetVMGroup":
		resp, err = w.dispatchGetVMGroup(req)
	case "WorkloadNetworksClient.GetVirtualMachine":
		resp, err = w.dispatchGetVirtualMachine(req)
	case "WorkloadNetworksClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	case "WorkloadNetworksClient.NewListDNSServicesPager":
		resp, err = w.dispatchNewListDNSServicesPager(req)
	case "WorkloadNetworksClient.NewListDNSZonesPager":
		resp, err = w.dispatchNewListDNSZonesPager(req)
	case "WorkloadNetworksClient.NewListDhcpPager":
		resp, err = w.dispatchNewListDhcpPager(req)
	case "WorkloadNetworksClient.NewListGatewaysPager":
		resp, err = w.dispatchNewListGatewaysPager(req)
	case "WorkloadNetworksClient.NewListPortMirroringPager":
		resp, err = w.dispatchNewListPortMirroringPager(req)
	case "WorkloadNetworksClient.NewListPublicIPsPager":
		resp, err = w.dispatchNewListPublicIPsPager(req)
	case "WorkloadNetworksClient.NewListSegmentsPager":
		resp, err = w.dispatchNewListSegmentsPager(req)
	case "WorkloadNetworksClient.NewListVMGroupsPager":
		resp, err = w.dispatchNewListVMGroupsPager(req)
	case "WorkloadNetworksClient.NewListVirtualMachinesPager":
		resp, err = w.dispatchNewListVirtualMachinesPager(req)
	case "WorkloadNetworksClient.BeginUpdateDNSService":
		resp, err = w.dispatchBeginUpdateDNSService(req)
	case "WorkloadNetworksClient.BeginUpdateDNSZone":
		resp, err = w.dispatchBeginUpdateDNSZone(req)
	case "WorkloadNetworksClient.BeginUpdateDhcp":
		resp, err = w.dispatchBeginUpdateDhcp(req)
	case "WorkloadNetworksClient.BeginUpdatePortMirroring":
		resp, err = w.dispatchBeginUpdatePortMirroring(req)
	case "WorkloadNetworksClient.BeginUpdateSegments":
		resp, err = w.dispatchBeginUpdateSegments(req)
	case "WorkloadNetworksClient.BeginUpdateVMGroup":
		resp, err = w.dispatchBeginUpdateVMGroup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreateDNSService(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateDNSService == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateDNSService not implemented")}
	}
	beginCreateDNSService := w.beginCreateDNSService.get(req)
	if beginCreateDNSService == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsServices/(?P<dnsServiceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDNSService](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dnsServiceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsServiceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateDNSService(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsServiceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateDNSService = &respr
		w.beginCreateDNSService.add(req, beginCreateDNSService)
	}

	resp, err := server.PollerResponderNext(beginCreateDNSService, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreateDNSService.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateDNSService) {
		w.beginCreateDNSService.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreateDNSZone(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateDNSZone == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateDNSZone not implemented")}
	}
	beginCreateDNSZone := w.beginCreateDNSZone.get(req)
	if beginCreateDNSZone == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsZones/(?P<dnsZoneId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDNSZone](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dnsZoneIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsZoneId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateDNSZone(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsZoneIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateDNSZone = &respr
		w.beginCreateDNSZone.add(req, beginCreateDNSZone)
	}

	resp, err := server.PollerResponderNext(beginCreateDNSZone, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreateDNSZone.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateDNSZone) {
		w.beginCreateDNSZone.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreateDhcp(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateDhcp == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateDhcp not implemented")}
	}
	beginCreateDhcp := w.beginCreateDhcp.get(req)
	if beginCreateDhcp == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dhcpConfigurations/(?P<dhcpId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDhcp](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dhcpIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dhcpId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateDhcp(req.Context(), resourceGroupNameParam, privateCloudNameParam, dhcpIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateDhcp = &respr
		w.beginCreateDhcp.add(req, beginCreateDhcp)
	}

	resp, err := server.PollerResponderNext(beginCreateDhcp, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreateDhcp.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateDhcp) {
		w.beginCreateDhcp.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreatePortMirroring(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreatePortMirroring == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreatePortMirroring not implemented")}
	}
	beginCreatePortMirroring := w.beginCreatePortMirroring.get(req)
	if beginCreatePortMirroring == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/portMirroringProfiles/(?P<portMirroringId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkPortMirroring](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		portMirroringIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("portMirroringId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreatePortMirroring(req.Context(), resourceGroupNameParam, privateCloudNameParam, portMirroringIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreatePortMirroring = &respr
		w.beginCreatePortMirroring.add(req, beginCreatePortMirroring)
	}

	resp, err := server.PollerResponderNext(beginCreatePortMirroring, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreatePortMirroring.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreatePortMirroring) {
		w.beginCreatePortMirroring.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreatePublicIP(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreatePublicIP == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreatePublicIP not implemented")}
	}
	beginCreatePublicIP := w.beginCreatePublicIP.get(req)
	if beginCreatePublicIP == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/publicIPs/(?P<publicIPId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkPublicIP](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		publicIPIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIPId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreatePublicIP(req.Context(), resourceGroupNameParam, privateCloudNameParam, publicIPIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreatePublicIP = &respr
		w.beginCreatePublicIP.add(req, beginCreatePublicIP)
	}

	resp, err := server.PollerResponderNext(beginCreatePublicIP, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreatePublicIP.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreatePublicIP) {
		w.beginCreatePublicIP.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreateSegments(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateSegments == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateSegments not implemented")}
	}
	beginCreateSegments := w.beginCreateSegments.get(req)
	if beginCreateSegments == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/segments/(?P<segmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkSegment](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		segmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("segmentId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateSegments(req.Context(), resourceGroupNameParam, privateCloudNameParam, segmentIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateSegments = &respr
		w.beginCreateSegments.add(req, beginCreateSegments)
	}

	resp, err := server.PollerResponderNext(beginCreateSegments, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreateSegments.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateSegments) {
		w.beginCreateSegments.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginCreateVMGroup(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateVMGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateVMGroup not implemented")}
	}
	beginCreateVMGroup := w.beginCreateVMGroup.get(req)
	if beginCreateVMGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/vmGroups/(?P<vmGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkVMGroup](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		vmGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmGroupId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateVMGroup(req.Context(), resourceGroupNameParam, privateCloudNameParam, vmGroupIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateVMGroup = &respr
		w.beginCreateVMGroup.add(req, beginCreateVMGroup)
	}

	resp, err := server.PollerResponderNext(beginCreateVMGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		w.beginCreateVMGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateVMGroup) {
		w.beginCreateVMGroup.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeleteDNSService(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeleteDNSService == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteDNSService not implemented")}
	}
	beginDeleteDNSService := w.beginDeleteDNSService.get(req)
	if beginDeleteDNSService == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsServices/(?P<dnsServiceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsServiceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsServiceId")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeleteDNSService(req.Context(), resourceGroupNameParam, dnsServiceIDParam, privateCloudNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteDNSService = &respr
		w.beginDeleteDNSService.add(req, beginDeleteDNSService)
	}

	resp, err := server.PollerResponderNext(beginDeleteDNSService, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeleteDNSService.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteDNSService) {
		w.beginDeleteDNSService.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeleteDNSZone(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeleteDNSZone == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteDNSZone not implemented")}
	}
	beginDeleteDNSZone := w.beginDeleteDNSZone.get(req)
	if beginDeleteDNSZone == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsZones/(?P<dnsZoneId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsZoneIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsZoneId")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeleteDNSZone(req.Context(), resourceGroupNameParam, dnsZoneIDParam, privateCloudNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteDNSZone = &respr
		w.beginDeleteDNSZone.add(req, beginDeleteDNSZone)
	}

	resp, err := server.PollerResponderNext(beginDeleteDNSZone, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeleteDNSZone.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteDNSZone) {
		w.beginDeleteDNSZone.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeleteDhcp(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeleteDhcp == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteDhcp not implemented")}
	}
	beginDeleteDhcp := w.beginDeleteDhcp.get(req)
	if beginDeleteDhcp == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dhcpConfigurations/(?P<dhcpId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dhcpIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dhcpId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeleteDhcp(req.Context(), resourceGroupNameParam, privateCloudNameParam, dhcpIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteDhcp = &respr
		w.beginDeleteDhcp.add(req, beginDeleteDhcp)
	}

	resp, err := server.PollerResponderNext(beginDeleteDhcp, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeleteDhcp.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteDhcp) {
		w.beginDeleteDhcp.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeletePortMirroring(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeletePortMirroring == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePortMirroring not implemented")}
	}
	beginDeletePortMirroring := w.beginDeletePortMirroring.get(req)
	if beginDeletePortMirroring == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/portMirroringProfiles/(?P<portMirroringId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		portMirroringIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("portMirroringId")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeletePortMirroring(req.Context(), resourceGroupNameParam, portMirroringIDParam, privateCloudNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePortMirroring = &respr
		w.beginDeletePortMirroring.add(req, beginDeletePortMirroring)
	}

	resp, err := server.PollerResponderNext(beginDeletePortMirroring, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeletePortMirroring.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePortMirroring) {
		w.beginDeletePortMirroring.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeletePublicIP(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeletePublicIP == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePublicIP not implemented")}
	}
	beginDeletePublicIP := w.beginDeletePublicIP.get(req)
	if beginDeletePublicIP == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/publicIPs/(?P<publicIPId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publicIPIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIPId")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeletePublicIP(req.Context(), resourceGroupNameParam, publicIPIDParam, privateCloudNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePublicIP = &respr
		w.beginDeletePublicIP.add(req, beginDeletePublicIP)
	}

	resp, err := server.PollerResponderNext(beginDeletePublicIP, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeletePublicIP.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePublicIP) {
		w.beginDeletePublicIP.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeleteSegment(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeleteSegment == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSegment not implemented")}
	}
	beginDeleteSegment := w.beginDeleteSegment.get(req)
	if beginDeleteSegment == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/segments/(?P<segmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		segmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("segmentId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeleteSegment(req.Context(), resourceGroupNameParam, privateCloudNameParam, segmentIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSegment = &respr
		w.beginDeleteSegment.add(req, beginDeleteSegment)
	}

	resp, err := server.PollerResponderNext(beginDeleteSegment, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeleteSegment.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSegment) {
		w.beginDeleteSegment.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginDeleteVMGroup(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDeleteVMGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteVMGroup not implemented")}
	}
	beginDeleteVMGroup := w.beginDeleteVMGroup.get(req)
	if beginDeleteVMGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/vmGroups/(?P<vmGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmGroupId")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDeleteVMGroup(req.Context(), resourceGroupNameParam, vmGroupIDParam, privateCloudNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteVMGroup = &respr
		w.beginDeleteVMGroup.add(req, beginDeleteVMGroup)
	}

	resp, err := server.PollerResponderNext(beginDeleteVMGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDeleteVMGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteVMGroup) {
		w.beginDeleteVMGroup.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/(?P<workloadNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	workloadNetworkNameParam, err := parseWithCast(matches[regex.SubexpIndex("workloadNetworkName")], func(v string) (armavs.WorkloadNetworkName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armavs.WorkloadNetworkName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, privateCloudNameParam, workloadNetworkNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetwork, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetDNSService(req *http.Request) (*http.Response, error) {
	if w.srv.GetDNSService == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDNSService not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsServices/(?P<dnsServiceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	dnsServiceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsServiceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDNSService(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsServiceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkDNSService, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetDNSZone(req *http.Request) (*http.Response, error) {
	if w.srv.GetDNSZone == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDNSZone not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsZones/(?P<dnsZoneId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	dnsZoneIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsZoneId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDNSZone(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsZoneIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkDNSZone, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetDhcp(req *http.Request) (*http.Response, error) {
	if w.srv.GetDhcp == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDhcp not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dhcpConfigurations/(?P<dhcpId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dhcpIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dhcpId")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetDhcp(req.Context(), resourceGroupNameParam, dhcpIDParam, privateCloudNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkDhcp, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetGateway(req *http.Request) (*http.Response, error) {
	if w.srv.GetGateway == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGateway not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/gateways/(?P<gatewayId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	gatewayIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("gatewayId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetGateway(req.Context(), resourceGroupNameParam, privateCloudNameParam, gatewayIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetPortMirroring(req *http.Request) (*http.Response, error) {
	if w.srv.GetPortMirroring == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPortMirroring not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/portMirroringProfiles/(?P<portMirroringId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	portMirroringIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("portMirroringId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPortMirroring(req.Context(), resourceGroupNameParam, privateCloudNameParam, portMirroringIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkPortMirroring, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetPublicIP(req *http.Request) (*http.Response, error) {
	if w.srv.GetPublicIP == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPublicIP not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/publicIPs/(?P<publicIPId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	publicIPIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("publicIPId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetPublicIP(req.Context(), resourceGroupNameParam, privateCloudNameParam, publicIPIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkPublicIP, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetSegment(req *http.Request) (*http.Response, error) {
	if w.srv.GetSegment == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSegment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/segments/(?P<segmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	segmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("segmentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetSegment(req.Context(), resourceGroupNameParam, privateCloudNameParam, segmentIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkSegment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetVMGroup(req *http.Request) (*http.Response, error) {
	if w.srv.GetVMGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVMGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/vmGroups/(?P<vmGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	vmGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmGroupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVMGroup(req.Context(), resourceGroupNameParam, privateCloudNameParam, vmGroupIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkVMGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchGetVirtualMachine(req *http.Request) (*http.Response, error) {
	if w.srv.GetVirtualMachine == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetVirtualMachine not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/virtualMachines/(?P<virtualMachineId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
	if err != nil {
		return nil, err
	}
	virtualMachineIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualMachineId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetVirtualMachine(req.Context(), resourceGroupNameParam, privateCloudNameParam, virtualMachineIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadNetworkVirtualMachine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armavs.WorkloadNetworksClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListDNSServicesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDNSServicesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDNSServicesPager not implemented")}
	}
	newListDNSServicesPager := w.newListDNSServicesPager.get(req)
	if newListDNSServicesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDNSServicesPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListDNSServicesPager = &resp
		w.newListDNSServicesPager.add(req, newListDNSServicesPager)
		server.PagerResponderInjectNextLinks(newListDNSServicesPager, req, func(page *armavs.WorkloadNetworksClientListDNSServicesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDNSServicesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDNSServicesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDNSServicesPager) {
		w.newListDNSServicesPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListDNSZonesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDNSZonesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDNSZonesPager not implemented")}
	}
	newListDNSZonesPager := w.newListDNSZonesPager.get(req)
	if newListDNSZonesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsZones`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDNSZonesPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListDNSZonesPager = &resp
		w.newListDNSZonesPager.add(req, newListDNSZonesPager)
		server.PagerResponderInjectNextLinks(newListDNSZonesPager, req, func(page *armavs.WorkloadNetworksClientListDNSZonesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDNSZonesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDNSZonesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDNSZonesPager) {
		w.newListDNSZonesPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListDhcpPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListDhcpPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDhcpPager not implemented")}
	}
	newListDhcpPager := w.newListDhcpPager.get(req)
	if newListDhcpPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dhcpConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListDhcpPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListDhcpPager = &resp
		w.newListDhcpPager.add(req, newListDhcpPager)
		server.PagerResponderInjectNextLinks(newListDhcpPager, req, func(page *armavs.WorkloadNetworksClientListDhcpResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDhcpPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListDhcpPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDhcpPager) {
		w.newListDhcpPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListGatewaysPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListGatewaysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGatewaysPager not implemented")}
	}
	newListGatewaysPager := w.newListGatewaysPager.get(req)
	if newListGatewaysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/gateways`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListGatewaysPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListGatewaysPager = &resp
		w.newListGatewaysPager.add(req, newListGatewaysPager)
		server.PagerResponderInjectNextLinks(newListGatewaysPager, req, func(page *armavs.WorkloadNetworksClientListGatewaysResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGatewaysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListGatewaysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGatewaysPager) {
		w.newListGatewaysPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListPortMirroringPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPortMirroringPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPortMirroringPager not implemented")}
	}
	newListPortMirroringPager := w.newListPortMirroringPager.get(req)
	if newListPortMirroringPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/portMirroringProfiles`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPortMirroringPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListPortMirroringPager = &resp
		w.newListPortMirroringPager.add(req, newListPortMirroringPager)
		server.PagerResponderInjectNextLinks(newListPortMirroringPager, req, func(page *armavs.WorkloadNetworksClientListPortMirroringResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPortMirroringPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPortMirroringPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPortMirroringPager) {
		w.newListPortMirroringPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListPublicIPsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPublicIPsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPublicIPsPager not implemented")}
	}
	newListPublicIPsPager := w.newListPublicIPsPager.get(req)
	if newListPublicIPsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/publicIPs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPublicIPsPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListPublicIPsPager = &resp
		w.newListPublicIPsPager.add(req, newListPublicIPsPager)
		server.PagerResponderInjectNextLinks(newListPublicIPsPager, req, func(page *armavs.WorkloadNetworksClientListPublicIPsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPublicIPsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPublicIPsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPublicIPsPager) {
		w.newListPublicIPsPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListSegmentsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListSegmentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSegmentsPager not implemented")}
	}
	newListSegmentsPager := w.newListSegmentsPager.get(req)
	if newListSegmentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/segments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListSegmentsPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListSegmentsPager = &resp
		w.newListSegmentsPager.add(req, newListSegmentsPager)
		server.PagerResponderInjectNextLinks(newListSegmentsPager, req, func(page *armavs.WorkloadNetworksClientListSegmentsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSegmentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListSegmentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSegmentsPager) {
		w.newListSegmentsPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListVMGroupsPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListVMGroupsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVMGroupsPager not implemented")}
	}
	newListVMGroupsPager := w.newListVMGroupsPager.get(req)
	if newListVMGroupsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/vmGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListVMGroupsPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListVMGroupsPager = &resp
		w.newListVMGroupsPager.add(req, newListVMGroupsPager)
		server.PagerResponderInjectNextLinks(newListVMGroupsPager, req, func(page *armavs.WorkloadNetworksClientListVMGroupsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVMGroupsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListVMGroupsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVMGroupsPager) {
		w.newListVMGroupsPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchNewListVirtualMachinesPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListVirtualMachinesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVirtualMachinesPager not implemented")}
	}
	newListVirtualMachinesPager := w.newListVirtualMachinesPager.get(req)
	if newListVirtualMachinesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/virtualMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListVirtualMachinesPager(resourceGroupNameParam, privateCloudNameParam, nil)
		newListVirtualMachinesPager = &resp
		w.newListVirtualMachinesPager.add(req, newListVirtualMachinesPager)
		server.PagerResponderInjectNextLinks(newListVirtualMachinesPager, req, func(page *armavs.WorkloadNetworksClientListVirtualMachinesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVirtualMachinesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListVirtualMachinesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVirtualMachinesPager) {
		w.newListVirtualMachinesPager.remove(req)
	}
	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdateDNSService(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdateDNSService == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateDNSService not implemented")}
	}
	beginUpdateDNSService := w.beginUpdateDNSService.get(req)
	if beginUpdateDNSService == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsServices/(?P<dnsServiceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDNSService](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dnsServiceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsServiceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdateDNSService(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsServiceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateDNSService = &respr
		w.beginUpdateDNSService.add(req, beginUpdateDNSService)
	}

	resp, err := server.PollerResponderNext(beginUpdateDNSService, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdateDNSService.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateDNSService) {
		w.beginUpdateDNSService.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdateDNSZone(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdateDNSZone == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateDNSZone not implemented")}
	}
	beginUpdateDNSZone := w.beginUpdateDNSZone.get(req)
	if beginUpdateDNSZone == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dnsZones/(?P<dnsZoneId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDNSZone](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dnsZoneIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsZoneId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdateDNSZone(req.Context(), resourceGroupNameParam, privateCloudNameParam, dnsZoneIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateDNSZone = &respr
		w.beginUpdateDNSZone.add(req, beginUpdateDNSZone)
	}

	resp, err := server.PollerResponderNext(beginUpdateDNSZone, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdateDNSZone.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateDNSZone) {
		w.beginUpdateDNSZone.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdateDhcp(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdateDhcp == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateDhcp not implemented")}
	}
	beginUpdateDhcp := w.beginUpdateDhcp.get(req)
	if beginUpdateDhcp == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/dhcpConfigurations/(?P<dhcpId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkDhcp](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		dhcpIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("dhcpId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdateDhcp(req.Context(), resourceGroupNameParam, privateCloudNameParam, dhcpIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateDhcp = &respr
		w.beginUpdateDhcp.add(req, beginUpdateDhcp)
	}

	resp, err := server.PollerResponderNext(beginUpdateDhcp, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdateDhcp.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateDhcp) {
		w.beginUpdateDhcp.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdatePortMirroring(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdatePortMirroring == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdatePortMirroring not implemented")}
	}
	beginUpdatePortMirroring := w.beginUpdatePortMirroring.get(req)
	if beginUpdatePortMirroring == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/portMirroringProfiles/(?P<portMirroringId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkPortMirroring](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		portMirroringIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("portMirroringId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdatePortMirroring(req.Context(), resourceGroupNameParam, privateCloudNameParam, portMirroringIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdatePortMirroring = &respr
		w.beginUpdatePortMirroring.add(req, beginUpdatePortMirroring)
	}

	resp, err := server.PollerResponderNext(beginUpdatePortMirroring, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdatePortMirroring.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdatePortMirroring) {
		w.beginUpdatePortMirroring.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdateSegments(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdateSegments == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateSegments not implemented")}
	}
	beginUpdateSegments := w.beginUpdateSegments.get(req)
	if beginUpdateSegments == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/segments/(?P<segmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkSegment](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		segmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("segmentId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdateSegments(req.Context(), resourceGroupNameParam, privateCloudNameParam, segmentIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateSegments = &respr
		w.beginUpdateSegments.add(req, beginUpdateSegments)
	}

	resp, err := server.PollerResponderNext(beginUpdateSegments, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdateSegments.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateSegments) {
		w.beginUpdateSegments.remove(req)
	}

	return resp, nil
}

func (w *WorkloadNetworksServerTransport) dispatchBeginUpdateVMGroup(req *http.Request) (*http.Response, error) {
	if w.srv.BeginUpdateVMGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateVMGroup not implemented")}
	}
	beginUpdateVMGroup := w.beginUpdateVMGroup.get(req)
	if beginUpdateVMGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/privateClouds/(?P<privateCloudName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadNetworks/default/vmGroups/(?P<vmGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armavs.WorkloadNetworkVMGroup](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateCloudNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateCloudName")])
		if err != nil {
			return nil, err
		}
		vmGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmGroupId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginUpdateVMGroup(req.Context(), resourceGroupNameParam, privateCloudNameParam, vmGroupIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateVMGroup = &respr
		w.beginUpdateVMGroup.add(req, beginUpdateVMGroup)
	}

	resp, err := server.PollerResponderNext(beginUpdateVMGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		w.beginUpdateVMGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateVMGroup) {
		w.beginUpdateVMGroup.remove(req)
	}

	return resp, nil
}
