//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProviderClient contains the methods for the Provider group.
// Don't use this type directly, use NewProviderClient() instead.
type ProviderClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewProviderClient creates a new instance of ProviderClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewProviderClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ProviderClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ProviderClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewGetAvailableStacksPager - Description for Get available application frameworks and their versions
//
// Generated from API version 2023-01-01
//   - options - ProviderClientGetAvailableStacksOptions contains the optional parameters for the ProviderClient.NewGetAvailableStacksPager
//     method.
func (client *ProviderClient) NewGetAvailableStacksPager(options *ProviderClientGetAvailableStacksOptions) *runtime.Pager[ProviderClientGetAvailableStacksResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetAvailableStacksResponse]{
		More: func(page ProviderClientGetAvailableStacksResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetAvailableStacksResponse) (ProviderClientGetAvailableStacksResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetAvailableStacksPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getAvailableStacksCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderClientGetAvailableStacksResponse{}, err
			}
			return client.getAvailableStacksHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getAvailableStacksCreateRequest creates the GetAvailableStacks request.
func (client *ProviderClient) getAvailableStacksCreateRequest(ctx context.Context, options *ProviderClientGetAvailableStacksOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/availableStacks"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.OSTypeSelected != nil {
		reqQP.Set("osTypeSelected", string(*options.OSTypeSelected))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAvailableStacksHandleResponse handles the GetAvailableStacks response.
func (client *ProviderClient) getAvailableStacksHandleResponse(resp *http.Response) (ProviderClientGetAvailableStacksResponse, error) {
	result := ProviderClientGetAvailableStacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ApplicationStackCollection); err != nil {
		return ProviderClientGetAvailableStacksResponse{}, err
	}
	return result, nil
}

// NewGetAvailableStacksOnPremPager - Description for Get available application frameworks and their versions
//
// Generated from API version 2023-01-01
//   - options - ProviderClientGetAvailableStacksOnPremOptions contains the optional parameters for the ProviderClient.NewGetAvailableStacksOnPremPager
//     method.
func (client *ProviderClient) NewGetAvailableStacksOnPremPager(options *ProviderClientGetAvailableStacksOnPremOptions) *runtime.Pager[ProviderClientGetAvailableStacksOnPremResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetAvailableStacksOnPremResponse]{
		More: func(page ProviderClientGetAvailableStacksOnPremResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetAvailableStacksOnPremResponse) (ProviderClientGetAvailableStacksOnPremResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetAvailableStacksOnPremPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getAvailableStacksOnPremCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderClientGetAvailableStacksOnPremResponse{}, err
			}
			return client.getAvailableStacksOnPremHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getAvailableStacksOnPremCreateRequest creates the GetAvailableStacksOnPrem request.
func (client *ProviderClient) getAvailableStacksOnPremCreateRequest(ctx context.Context, options *ProviderClientGetAvailableStacksOnPremOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.OSTypeSelected != nil {
		reqQP.Set("osTypeSelected", string(*options.OSTypeSelected))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAvailableStacksOnPremHandleResponse handles the GetAvailableStacksOnPrem response.
func (client *ProviderClient) getAvailableStacksOnPremHandleResponse(resp *http.Response) (ProviderClientGetAvailableStacksOnPremResponse, error) {
	result := ProviderClientGetAvailableStacksOnPremResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ApplicationStackCollection); err != nil {
		return ProviderClientGetAvailableStacksOnPremResponse{}, err
	}
	return result, nil
}

// NewGetFunctionAppStacksPager - Description for Get available Function app frameworks and their versions
//
// Generated from API version 2023-01-01
//   - options - ProviderClientGetFunctionAppStacksOptions contains the optional parameters for the ProviderClient.NewGetFunctionAppStacksPager
//     method.
func (client *ProviderClient) NewGetFunctionAppStacksPager(options *ProviderClientGetFunctionAppStacksOptions) *runtime.Pager[ProviderClientGetFunctionAppStacksResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetFunctionAppStacksResponse]{
		More: func(page ProviderClientGetFunctionAppStacksResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetFunctionAppStacksResponse) (ProviderClientGetFunctionAppStacksResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetFunctionAppStacksPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getFunctionAppStacksCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderClientGetFunctionAppStacksResponse{}, err
			}
			return client.getFunctionAppStacksHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getFunctionAppStacksCreateRequest creates the GetFunctionAppStacks request.
func (client *ProviderClient) getFunctionAppStacksCreateRequest(ctx context.Context, options *ProviderClientGetFunctionAppStacksOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/functionAppStacks"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StackOsType != nil {
		reqQP.Set("stackOsType", string(*options.StackOsType))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFunctionAppStacksHandleResponse handles the GetFunctionAppStacks response.
func (client *ProviderClient) getFunctionAppStacksHandleResponse(resp *http.Response) (ProviderClientGetFunctionAppStacksResponse, error) {
	result := ProviderClientGetFunctionAppStacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionAppStackCollection); err != nil {
		return ProviderClientGetFunctionAppStacksResponse{}, err
	}
	return result, nil
}

// NewGetFunctionAppStacksForLocationPager - Description for Get available Function app frameworks and their versions for
// location
//
// Generated from API version 2023-01-01
//   - location - Function App stack location.
//   - options - ProviderClientGetFunctionAppStacksForLocationOptions contains the optional parameters for the ProviderClient.NewGetFunctionAppStacksForLocationPager
//     method.
func (client *ProviderClient) NewGetFunctionAppStacksForLocationPager(location string, options *ProviderClientGetFunctionAppStacksForLocationOptions) *runtime.Pager[ProviderClientGetFunctionAppStacksForLocationResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetFunctionAppStacksForLocationResponse]{
		More: func(page ProviderClientGetFunctionAppStacksForLocationResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetFunctionAppStacksForLocationResponse) (ProviderClientGetFunctionAppStacksForLocationResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetFunctionAppStacksForLocationPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getFunctionAppStacksForLocationCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return ProviderClientGetFunctionAppStacksForLocationResponse{}, err
			}
			return client.getFunctionAppStacksForLocationHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getFunctionAppStacksForLocationCreateRequest creates the GetFunctionAppStacksForLocation request.
func (client *ProviderClient) getFunctionAppStacksForLocationCreateRequest(ctx context.Context, location string, options *ProviderClientGetFunctionAppStacksForLocationOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/locations/{location}/functionAppStacks"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StackOsType != nil {
		reqQP.Set("stackOsType", string(*options.StackOsType))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getFunctionAppStacksForLocationHandleResponse handles the GetFunctionAppStacksForLocation response.
func (client *ProviderClient) getFunctionAppStacksForLocationHandleResponse(resp *http.Response) (ProviderClientGetFunctionAppStacksForLocationResponse, error) {
	result := ProviderClientGetFunctionAppStacksForLocationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FunctionAppStackCollection); err != nil {
		return ProviderClientGetFunctionAppStacksForLocationResponse{}, err
	}
	return result, nil
}

// NewGetWebAppStacksPager - Description for Get available Web app frameworks and their versions
//
// Generated from API version 2023-01-01
//   - options - ProviderClientGetWebAppStacksOptions contains the optional parameters for the ProviderClient.NewGetWebAppStacksPager
//     method.
func (client *ProviderClient) NewGetWebAppStacksPager(options *ProviderClientGetWebAppStacksOptions) *runtime.Pager[ProviderClientGetWebAppStacksResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetWebAppStacksResponse]{
		More: func(page ProviderClientGetWebAppStacksResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetWebAppStacksResponse) (ProviderClientGetWebAppStacksResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetWebAppStacksPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getWebAppStacksCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderClientGetWebAppStacksResponse{}, err
			}
			return client.getWebAppStacksHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getWebAppStacksCreateRequest creates the GetWebAppStacks request.
func (client *ProviderClient) getWebAppStacksCreateRequest(ctx context.Context, options *ProviderClientGetWebAppStacksOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/webAppStacks"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StackOsType != nil {
		reqQP.Set("stackOsType", string(*options.StackOsType))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWebAppStacksHandleResponse handles the GetWebAppStacks response.
func (client *ProviderClient) getWebAppStacksHandleResponse(resp *http.Response) (ProviderClientGetWebAppStacksResponse, error) {
	result := ProviderClientGetWebAppStacksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppStackCollection); err != nil {
		return ProviderClientGetWebAppStacksResponse{}, err
	}
	return result, nil
}

// NewGetWebAppStacksForLocationPager - Description for Get available Web app frameworks and their versions for location
//
// Generated from API version 2023-01-01
//   - location - Web App stack location.
//   - options - ProviderClientGetWebAppStacksForLocationOptions contains the optional parameters for the ProviderClient.NewGetWebAppStacksForLocationPager
//     method.
func (client *ProviderClient) NewGetWebAppStacksForLocationPager(location string, options *ProviderClientGetWebAppStacksForLocationOptions) *runtime.Pager[ProviderClientGetWebAppStacksForLocationResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientGetWebAppStacksForLocationResponse]{
		More: func(page ProviderClientGetWebAppStacksForLocationResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientGetWebAppStacksForLocationResponse) (ProviderClientGetWebAppStacksForLocationResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewGetWebAppStacksForLocationPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getWebAppStacksForLocationCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return ProviderClientGetWebAppStacksForLocationResponse{}, err
			}
			return client.getWebAppStacksForLocationHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getWebAppStacksForLocationCreateRequest creates the GetWebAppStacksForLocation request.
func (client *ProviderClient) getWebAppStacksForLocationCreateRequest(ctx context.Context, location string, options *ProviderClientGetWebAppStacksForLocationOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/locations/{location}/webAppStacks"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.StackOsType != nil {
		reqQP.Set("stackOsType", string(*options.StackOsType))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getWebAppStacksForLocationHandleResponse handles the GetWebAppStacksForLocation response.
func (client *ProviderClient) getWebAppStacksForLocationHandleResponse(resp *http.Response) (ProviderClientGetWebAppStacksForLocationResponse, error) {
	result := ProviderClientGetWebAppStacksForLocationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppStackCollection); err != nil {
		return ProviderClientGetWebAppStacksForLocationResponse{}, err
	}
	return result, nil
}

// NewListOperationsPager - Description for Gets all available operations for the Microsoft.Web resource provider. Also exposes
// resource metric definitions
//
// Generated from API version 2023-01-01
//   - options - ProviderClientListOperationsOptions contains the optional parameters for the ProviderClient.NewListOperationsPager
//     method.
func (client *ProviderClient) NewListOperationsPager(options *ProviderClientListOperationsOptions) *runtime.Pager[ProviderClientListOperationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderClientListOperationsResponse]{
		More: func(page ProviderClientListOperationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderClientListOperationsResponse) (ProviderClientListOperationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderClient.NewListOperationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listOperationsCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderClientListOperationsResponse{}, err
			}
			return client.listOperationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *ProviderClient) listOperationsCreateRequest(ctx context.Context, options *ProviderClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *ProviderClient) listOperationsHandleResponse(resp *http.Response) (ProviderClientListOperationsResponse, error) {
	result := ProviderClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmOperationCollection); err != nil {
		return ProviderClientListOperationsResponse{}, err
	}
	return result, nil
}
