//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// RecommendationsServer is a fake server for instances of the armappservice.RecommendationsClient type.
type RecommendationsServer struct {
	// DisableAllForHostingEnvironment is the fake for method RecommendationsClient.DisableAllForHostingEnvironment
	// HTTP status codes to indicate success: http.StatusNoContent
	DisableAllForHostingEnvironment func(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *armappservice.RecommendationsClientDisableAllForHostingEnvironmentOptions) (resp azfake.Responder[armappservice.RecommendationsClientDisableAllForHostingEnvironmentResponse], errResp azfake.ErrorResponder)

	// DisableAllForWebApp is the fake for method RecommendationsClient.DisableAllForWebApp
	// HTTP status codes to indicate success: http.StatusNoContent
	DisableAllForWebApp func(ctx context.Context, resourceGroupName string, siteName string, options *armappservice.RecommendationsClientDisableAllForWebAppOptions) (resp azfake.Responder[armappservice.RecommendationsClientDisableAllForWebAppResponse], errResp azfake.ErrorResponder)

	// DisableRecommendationForHostingEnvironment is the fake for method RecommendationsClient.DisableRecommendationForHostingEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	DisableRecommendationForHostingEnvironment func(ctx context.Context, resourceGroupName string, environmentName string, name string, hostingEnvironmentName string, options *armappservice.RecommendationsClientDisableRecommendationForHostingEnvironmentOptions) (resp azfake.Responder[armappservice.RecommendationsClientDisableRecommendationForHostingEnvironmentResponse], errResp azfake.ErrorResponder)

	// DisableRecommendationForSite is the fake for method RecommendationsClient.DisableRecommendationForSite
	// HTTP status codes to indicate success: http.StatusOK
	DisableRecommendationForSite func(ctx context.Context, resourceGroupName string, siteName string, name string, options *armappservice.RecommendationsClientDisableRecommendationForSiteOptions) (resp azfake.Responder[armappservice.RecommendationsClientDisableRecommendationForSiteResponse], errResp azfake.ErrorResponder)

	// DisableRecommendationForSubscription is the fake for method RecommendationsClient.DisableRecommendationForSubscription
	// HTTP status codes to indicate success: http.StatusOK
	DisableRecommendationForSubscription func(ctx context.Context, name string, options *armappservice.RecommendationsClientDisableRecommendationForSubscriptionOptions) (resp azfake.Responder[armappservice.RecommendationsClientDisableRecommendationForSubscriptionResponse], errResp azfake.ErrorResponder)

	// GetRuleDetailsByHostingEnvironment is the fake for method RecommendationsClient.GetRuleDetailsByHostingEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	GetRuleDetailsByHostingEnvironment func(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, name string, options *armappservice.RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions) (resp azfake.Responder[armappservice.RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse], errResp azfake.ErrorResponder)

	// GetRuleDetailsByWebApp is the fake for method RecommendationsClient.GetRuleDetailsByWebApp
	// HTTP status codes to indicate success: http.StatusOK
	GetRuleDetailsByWebApp func(ctx context.Context, resourceGroupName string, siteName string, name string, options *armappservice.RecommendationsClientGetRuleDetailsByWebAppOptions) (resp azfake.Responder[armappservice.RecommendationsClientGetRuleDetailsByWebAppResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method RecommendationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappservice.RecommendationsClientListOptions) (resp azfake.PagerResponder[armappservice.RecommendationsClientListResponse])

	// NewListHistoryForHostingEnvironmentPager is the fake for method RecommendationsClient.NewListHistoryForHostingEnvironmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHistoryForHostingEnvironmentPager func(resourceGroupName string, hostingEnvironmentName string, options *armappservice.RecommendationsClientListHistoryForHostingEnvironmentOptions) (resp azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForHostingEnvironmentResponse])

	// NewListHistoryForWebAppPager is the fake for method RecommendationsClient.NewListHistoryForWebAppPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHistoryForWebAppPager func(resourceGroupName string, siteName string, options *armappservice.RecommendationsClientListHistoryForWebAppOptions) (resp azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForWebAppResponse])

	// NewListRecommendedRulesForHostingEnvironmentPager is the fake for method RecommendationsClient.NewListRecommendedRulesForHostingEnvironmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRecommendedRulesForHostingEnvironmentPager func(resourceGroupName string, hostingEnvironmentName string, options *armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions) (resp azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse])

	// NewListRecommendedRulesForWebAppPager is the fake for method RecommendationsClient.NewListRecommendedRulesForWebAppPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListRecommendedRulesForWebAppPager func(resourceGroupName string, siteName string, options *armappservice.RecommendationsClientListRecommendedRulesForWebAppOptions) (resp azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForWebAppResponse])

	// ResetAllFilters is the fake for method RecommendationsClient.ResetAllFilters
	// HTTP status codes to indicate success: http.StatusNoContent
	ResetAllFilters func(ctx context.Context, options *armappservice.RecommendationsClientResetAllFiltersOptions) (resp azfake.Responder[armappservice.RecommendationsClientResetAllFiltersResponse], errResp azfake.ErrorResponder)

	// ResetAllFiltersForHostingEnvironment is the fake for method RecommendationsClient.ResetAllFiltersForHostingEnvironment
	// HTTP status codes to indicate success: http.StatusNoContent
	ResetAllFiltersForHostingEnvironment func(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string, options *armappservice.RecommendationsClientResetAllFiltersForHostingEnvironmentOptions) (resp azfake.Responder[armappservice.RecommendationsClientResetAllFiltersForHostingEnvironmentResponse], errResp azfake.ErrorResponder)

	// ResetAllFiltersForWebApp is the fake for method RecommendationsClient.ResetAllFiltersForWebApp
	// HTTP status codes to indicate success: http.StatusNoContent
	ResetAllFiltersForWebApp func(ctx context.Context, resourceGroupName string, siteName string, options *armappservice.RecommendationsClientResetAllFiltersForWebAppOptions) (resp azfake.Responder[armappservice.RecommendationsClientResetAllFiltersForWebAppResponse], errResp azfake.ErrorResponder)
}

// NewRecommendationsServerTransport creates a new instance of RecommendationsServerTransport with the provided implementation.
// The returned RecommendationsServerTransport instance is connected to an instance of armappservice.RecommendationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRecommendationsServerTransport(srv *RecommendationsServer) *RecommendationsServerTransport {
	return &RecommendationsServerTransport{
		srv:                                      srv,
		newListPager:                             newTracker[azfake.PagerResponder[armappservice.RecommendationsClientListResponse]](),
		newListHistoryForHostingEnvironmentPager: newTracker[azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForHostingEnvironmentResponse]](),
		newListHistoryForWebAppPager:             newTracker[azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForWebAppResponse]](),
		newListRecommendedRulesForHostingEnvironmentPager: newTracker[azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse]](),
		newListRecommendedRulesForWebAppPager:             newTracker[azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForWebAppResponse]](),
	}
}

// RecommendationsServerTransport connects instances of armappservice.RecommendationsClient to instances of RecommendationsServer.
// Don't use this type directly, use NewRecommendationsServerTransport instead.
type RecommendationsServerTransport struct {
	srv                                               *RecommendationsServer
	newListPager                                      *tracker[azfake.PagerResponder[armappservice.RecommendationsClientListResponse]]
	newListHistoryForHostingEnvironmentPager          *tracker[azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForHostingEnvironmentResponse]]
	newListHistoryForWebAppPager                      *tracker[azfake.PagerResponder[armappservice.RecommendationsClientListHistoryForWebAppResponse]]
	newListRecommendedRulesForHostingEnvironmentPager *tracker[azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse]]
	newListRecommendedRulesForWebAppPager             *tracker[azfake.PagerResponder[armappservice.RecommendationsClientListRecommendedRulesForWebAppResponse]]
}

// Do implements the policy.Transporter interface for RecommendationsServerTransport.
func (r *RecommendationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RecommendationsClient.DisableAllForHostingEnvironment":
		resp, err = r.dispatchDisableAllForHostingEnvironment(req)
	case "RecommendationsClient.DisableAllForWebApp":
		resp, err = r.dispatchDisableAllForWebApp(req)
	case "RecommendationsClient.DisableRecommendationForHostingEnvironment":
		resp, err = r.dispatchDisableRecommendationForHostingEnvironment(req)
	case "RecommendationsClient.DisableRecommendationForSite":
		resp, err = r.dispatchDisableRecommendationForSite(req)
	case "RecommendationsClient.DisableRecommendationForSubscription":
		resp, err = r.dispatchDisableRecommendationForSubscription(req)
	case "RecommendationsClient.GetRuleDetailsByHostingEnvironment":
		resp, err = r.dispatchGetRuleDetailsByHostingEnvironment(req)
	case "RecommendationsClient.GetRuleDetailsByWebApp":
		resp, err = r.dispatchGetRuleDetailsByWebApp(req)
	case "RecommendationsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "RecommendationsClient.NewListHistoryForHostingEnvironmentPager":
		resp, err = r.dispatchNewListHistoryForHostingEnvironmentPager(req)
	case "RecommendationsClient.NewListHistoryForWebAppPager":
		resp, err = r.dispatchNewListHistoryForWebAppPager(req)
	case "RecommendationsClient.NewListRecommendedRulesForHostingEnvironmentPager":
		resp, err = r.dispatchNewListRecommendedRulesForHostingEnvironmentPager(req)
	case "RecommendationsClient.NewListRecommendedRulesForWebAppPager":
		resp, err = r.dispatchNewListRecommendedRulesForWebAppPager(req)
	case "RecommendationsClient.ResetAllFilters":
		resp, err = r.dispatchResetAllFilters(req)
	case "RecommendationsClient.ResetAllFiltersForHostingEnvironment":
		resp, err = r.dispatchResetAllFiltersForHostingEnvironment(req)
	case "RecommendationsClient.ResetAllFiltersForWebApp":
		resp, err = r.dispatchResetAllFiltersForWebApp(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchDisableAllForHostingEnvironment(req *http.Request) (*http.Response, error) {
	if r.srv.DisableAllForHostingEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableAllForHostingEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/disable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.QueryUnescape(qp.Get("environmentName"))
	if err != nil {
		return nil, err
	}
	hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DisableAllForHostingEnvironment(req.Context(), resourceGroupNameParam, environmentNameParam, hostingEnvironmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchDisableAllForWebApp(req *http.Request) (*http.Response, error) {
	if r.srv.DisableAllForWebApp == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableAllForWebApp not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/disable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DisableAllForWebApp(req.Context(), resourceGroupNameParam, siteNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchDisableRecommendationForHostingEnvironment(req *http.Request) (*http.Response, error) {
	if r.srv.DisableRecommendationForHostingEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableRecommendationForHostingEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.QueryUnescape(qp.Get("environmentName"))
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DisableRecommendationForHostingEnvironment(req.Context(), resourceGroupNameParam, environmentNameParam, nameParam, hostingEnvironmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchDisableRecommendationForSite(req *http.Request) (*http.Response, error) {
	if r.srv.DisableRecommendationForSite == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableRecommendationForSite not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DisableRecommendationForSite(req.Context(), resourceGroupNameParam, siteNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchDisableRecommendationForSubscription(req *http.Request) (*http.Response, error) {
	if r.srv.DisableRecommendationForSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableRecommendationForSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/recommendations/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DisableRecommendationForSubscription(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchGetRuleDetailsByHostingEnvironment(req *http.Request) (*http.Response, error) {
	if r.srv.GetRuleDetailsByHostingEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRuleDetailsByHostingEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	updateSeenUnescaped, err := url.QueryUnescape(qp.Get("updateSeen"))
	if err != nil {
		return nil, err
	}
	updateSeenParam, err := parseOptional(updateSeenUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	recommendationIDUnescaped, err := url.QueryUnescape(qp.Get("recommendationId"))
	if err != nil {
		return nil, err
	}
	recommendationIDParam := getOptional(recommendationIDUnescaped)
	var options *armappservice.RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions
	if updateSeenParam != nil || recommendationIDParam != nil {
		options = &armappservice.RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions{
			UpdateSeen:       updateSeenParam,
			RecommendationID: recommendationIDParam,
		}
	}
	respr, errRespr := r.srv.GetRuleDetailsByHostingEnvironment(req.Context(), resourceGroupNameParam, hostingEnvironmentNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecommendationRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchGetRuleDetailsByWebApp(req *http.Request) (*http.Response, error) {
	if r.srv.GetRuleDetailsByWebApp == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRuleDetailsByWebApp not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	updateSeenUnescaped, err := url.QueryUnescape(qp.Get("updateSeen"))
	if err != nil {
		return nil, err
	}
	updateSeenParam, err := parseOptional(updateSeenUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	recommendationIDUnescaped, err := url.QueryUnescape(qp.Get("recommendationId"))
	if err != nil {
		return nil, err
	}
	recommendationIDParam := getOptional(recommendationIDUnescaped)
	var options *armappservice.RecommendationsClientGetRuleDetailsByWebAppOptions
	if updateSeenParam != nil || recommendationIDParam != nil {
		options = &armappservice.RecommendationsClientGetRuleDetailsByWebAppOptions{
			UpdateSeen:       updateSeenParam,
			RecommendationID: recommendationIDParam,
		}
	}
	respr, errRespr := r.srv.GetRuleDetailsByWebApp(req.Context(), resourceGroupNameParam, siteNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecommendationRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/recommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		featuredUnescaped, err := url.QueryUnescape(qp.Get("featured"))
		if err != nil {
			return nil, err
		}
		featuredParam, err := parseOptional(featuredUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.RecommendationsClientListOptions
		if featuredParam != nil || filterParam != nil {
			options = &armappservice.RecommendationsClientListOptions{
				Featured: featuredParam,
				Filter:   filterParam,
			}
		}
		resp := r.srv.NewListPager(options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappservice.RecommendationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchNewListHistoryForHostingEnvironmentPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListHistoryForHostingEnvironmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHistoryForHostingEnvironmentPager not implemented")}
	}
	newListHistoryForHostingEnvironmentPager := r.newListHistoryForHostingEnvironmentPager.get(req)
	if newListHistoryForHostingEnvironmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendationHistory`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
		if err != nil {
			return nil, err
		}
		expiredOnlyUnescaped, err := url.QueryUnescape(qp.Get("expiredOnly"))
		if err != nil {
			return nil, err
		}
		expiredOnlyParam, err := parseOptional(expiredOnlyUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.RecommendationsClientListHistoryForHostingEnvironmentOptions
		if expiredOnlyParam != nil || filterParam != nil {
			options = &armappservice.RecommendationsClientListHistoryForHostingEnvironmentOptions{
				ExpiredOnly: expiredOnlyParam,
				Filter:      filterParam,
			}
		}
		resp := r.srv.NewListHistoryForHostingEnvironmentPager(resourceGroupNameParam, hostingEnvironmentNameParam, options)
		newListHistoryForHostingEnvironmentPager = &resp
		r.newListHistoryForHostingEnvironmentPager.add(req, newListHistoryForHostingEnvironmentPager)
		server.PagerResponderInjectNextLinks(newListHistoryForHostingEnvironmentPager, req, func(page *armappservice.RecommendationsClientListHistoryForHostingEnvironmentResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHistoryForHostingEnvironmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListHistoryForHostingEnvironmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHistoryForHostingEnvironmentPager) {
		r.newListHistoryForHostingEnvironmentPager.remove(req)
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchNewListHistoryForWebAppPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListHistoryForWebAppPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHistoryForWebAppPager not implemented")}
	}
	newListHistoryForWebAppPager := r.newListHistoryForWebAppPager.get(req)
	if newListHistoryForWebAppPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendationHistory`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		expiredOnlyUnescaped, err := url.QueryUnescape(qp.Get("expiredOnly"))
		if err != nil {
			return nil, err
		}
		expiredOnlyParam, err := parseOptional(expiredOnlyUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.RecommendationsClientListHistoryForWebAppOptions
		if expiredOnlyParam != nil || filterParam != nil {
			options = &armappservice.RecommendationsClientListHistoryForWebAppOptions{
				ExpiredOnly: expiredOnlyParam,
				Filter:      filterParam,
			}
		}
		resp := r.srv.NewListHistoryForWebAppPager(resourceGroupNameParam, siteNameParam, options)
		newListHistoryForWebAppPager = &resp
		r.newListHistoryForWebAppPager.add(req, newListHistoryForWebAppPager)
		server.PagerResponderInjectNextLinks(newListHistoryForWebAppPager, req, func(page *armappservice.RecommendationsClientListHistoryForWebAppResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHistoryForWebAppPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListHistoryForWebAppPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHistoryForWebAppPager) {
		r.newListHistoryForWebAppPager.remove(req)
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchNewListRecommendedRulesForHostingEnvironmentPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListRecommendedRulesForHostingEnvironmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRecommendedRulesForHostingEnvironmentPager not implemented")}
	}
	newListRecommendedRulesForHostingEnvironmentPager := r.newListRecommendedRulesForHostingEnvironmentPager.get(req)
	if newListRecommendedRulesForHostingEnvironmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
		if err != nil {
			return nil, err
		}
		featuredUnescaped, err := url.QueryUnescape(qp.Get("featured"))
		if err != nil {
			return nil, err
		}
		featuredParam, err := parseOptional(featuredUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions
		if featuredParam != nil || filterParam != nil {
			options = &armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions{
				Featured: featuredParam,
				Filter:   filterParam,
			}
		}
		resp := r.srv.NewListRecommendedRulesForHostingEnvironmentPager(resourceGroupNameParam, hostingEnvironmentNameParam, options)
		newListRecommendedRulesForHostingEnvironmentPager = &resp
		r.newListRecommendedRulesForHostingEnvironmentPager.add(req, newListRecommendedRulesForHostingEnvironmentPager)
		server.PagerResponderInjectNextLinks(newListRecommendedRulesForHostingEnvironmentPager, req, func(page *armappservice.RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRecommendedRulesForHostingEnvironmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListRecommendedRulesForHostingEnvironmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRecommendedRulesForHostingEnvironmentPager) {
		r.newListRecommendedRulesForHostingEnvironmentPager.remove(req)
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchNewListRecommendedRulesForWebAppPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListRecommendedRulesForWebAppPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListRecommendedRulesForWebAppPager not implemented")}
	}
	newListRecommendedRulesForWebAppPager := r.newListRecommendedRulesForWebAppPager.get(req)
	if newListRecommendedRulesForWebAppPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
		if err != nil {
			return nil, err
		}
		featuredUnescaped, err := url.QueryUnescape(qp.Get("featured"))
		if err != nil {
			return nil, err
		}
		featuredParam, err := parseOptional(featuredUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armappservice.RecommendationsClientListRecommendedRulesForWebAppOptions
		if featuredParam != nil || filterParam != nil {
			options = &armappservice.RecommendationsClientListRecommendedRulesForWebAppOptions{
				Featured: featuredParam,
				Filter:   filterParam,
			}
		}
		resp := r.srv.NewListRecommendedRulesForWebAppPager(resourceGroupNameParam, siteNameParam, options)
		newListRecommendedRulesForWebAppPager = &resp
		r.newListRecommendedRulesForWebAppPager.add(req, newListRecommendedRulesForWebAppPager)
		server.PagerResponderInjectNextLinks(newListRecommendedRulesForWebAppPager, req, func(page *armappservice.RecommendationsClientListRecommendedRulesForWebAppResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListRecommendedRulesForWebAppPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListRecommendedRulesForWebAppPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListRecommendedRulesForWebAppPager) {
		r.newListRecommendedRulesForWebAppPager.remove(req)
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchResetAllFilters(req *http.Request) (*http.Response, error) {
	if r.srv.ResetAllFilters == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetAllFilters not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/recommendations/reset`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := r.srv.ResetAllFilters(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchResetAllFiltersForHostingEnvironment(req *http.Request) (*http.Response, error) {
	if r.srv.ResetAllFiltersForHostingEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetAllFiltersForHostingEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/hostingEnvironments/(?P<hostingEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/reset`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.QueryUnescape(qp.Get("environmentName"))
	if err != nil {
		return nil, err
	}
	hostingEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hostingEnvironmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ResetAllFiltersForHostingEnvironment(req.Context(), resourceGroupNameParam, environmentNameParam, hostingEnvironmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecommendationsServerTransport) dispatchResetAllFiltersForWebApp(req *http.Request) (*http.Response, error) {
	if r.srv.ResetAllFiltersForWebApp == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetAllFiltersForWebApp not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Web/sites/(?P<siteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendations/reset`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	siteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("siteName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ResetAllFiltersForWebApp(req.Context(), resourceGroupNameParam, siteNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
