//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappplatform

import "time"

// APIPortalCustomDomainProperties - The properties of custom domain for API portal
type APIPortalCustomDomainProperties struct {
	// The thumbprint of bound certificate.
	Thumbprint *string
}

// APIPortalCustomDomainResource - Custom domain of the API portal
type APIPortalCustomDomainResource struct {
	// The properties of custom domain for API portal
	Properties *APIPortalCustomDomainProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// APIPortalCustomDomainResourceCollection - Object that includes an array of API portal custom domain resources and a possible
// link for next set
type APIPortalCustomDomainResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of API portal custom domain resources
	Value []*APIPortalCustomDomainResource
}

// APIPortalInstance - Collection of instances belong to the API portal
type APIPortalInstance struct {
	// READ-ONLY; Name of the API portal instance
	Name *string

	// READ-ONLY; Status of the API portal instance
	Status *string
}

// APIPortalProperties - API portal properties payload
type APIPortalProperties struct {
	// Indicates whether the API try-out feature is enabled or disabled. When enabled, users can try out the API by sending requests
	// and viewing responses in API portal. When disabled, users cannot try out
	// the API.
	APITryOutEnabledState *APIPortalAPITryOutEnabledState

	// The array of resource Ids of gateway to integrate with API portal.
	GatewayIDs []*string

	// Indicate if only https is allowed.
	HTTPSOnly *bool

	// Indicates whether the API portal exposes endpoint.
	Public *bool

	// Collection of OpenAPI source URL locations.
	SourceUrls []*string

	// Single sign-on related configuration
	SsoProperties *SsoProperties

	// READ-ONLY; Collection of instances belong to API portal.
	Instances []*APIPortalInstance

	// READ-ONLY; State of the API portal.
	ProvisioningState *APIPortalProvisioningState

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *APIPortalResourceRequests

	// READ-ONLY; URL of the API portal, exposed when 'public' is true.
	URL *string
}

// APIPortalResource - API portal resource
type APIPortalResource struct {
	// API portal properties payload
	Properties *APIPortalProperties

	// Sku of the API portal resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// APIPortalResourceCollection - Object that includes an array of API portal resources and a possible link for next set
type APIPortalResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of API portal resources
	Value []*APIPortalResource
}

// APIPortalResourceRequests - Resource requests of the API portal
type APIPortalResourceRequests struct {
	// READ-ONLY; Cpu allocated to each API portal instance
	CPU *string

	// READ-ONLY; Memory allocated to each API portal instance
	Memory *string
}

// AcceleratorAuthSetting - Auth setting payload.
type AcceleratorAuthSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorAuthSetting.
func (a *AcceleratorAuthSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting { return a }

// AcceleratorBasicAuthSetting - Auth setting for basic auth.
type AcceleratorBasicAuthSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string

	// REQUIRED; Username of git repository basic auth.
	Username *string

	// Resource Id of CA certificate for https URL of Git repository.
	CaCertResourceID *string

	// Password of git repository basic auth.
	Password *string
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorBasicAuthSetting.
func (a *AcceleratorBasicAuthSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

type AcceleratorGitRepository struct {
	// REQUIRED; Properties of the auth setting payload.
	AuthSetting AcceleratorAuthSettingClassification

	// REQUIRED; Git repository URL for the accelerator.
	URL *string

	// Git repository branch to be used.
	Branch *string

	// Git repository commit to be used.
	Commit *string

	// Git repository tag to be used.
	GitTag *string

	// Interval for checking for updates to Git or image repository.
	IntervalInSeconds *int32

	// Folder path inside the git repository to consider as the root of the accelerator or fragment.
	SubPath *string
}

// AcceleratorPublicSetting - Auth setting for public url.
type AcceleratorPublicSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string

	// Resource Id of CA certificate for https URL of Git repository.
	CaCertResourceID *string
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorPublicSetting.
func (a *AcceleratorPublicSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

// AcceleratorSSHSetting - Auth setting for SSH auth.
type AcceleratorSSHSetting struct {
	// REQUIRED; The type of the auth setting.
	AuthType *string

	// Public SSH Key of git repository.
	HostKey *string

	// SSH Key algorithm of git repository.
	HostKeyAlgorithm *string

	// Private SSH Key algorithm of git repository.
	PrivateKey *string
}

// GetAcceleratorAuthSetting implements the AcceleratorAuthSettingClassification interface for type AcceleratorSSHSetting.
func (a *AcceleratorSSHSetting) GetAcceleratorAuthSetting() *AcceleratorAuthSetting {
	return &AcceleratorAuthSetting{
		AuthType: a.AuthType,
	}
}

// ActiveDeploymentCollection - Object that includes an array of Deployment resource name and set them as active.
type ActiveDeploymentCollection struct {
	// Collection of Deployment name.
	ActiveDeploymentNames []*string
}

// ApmProperties - Properties of an APM
type ApmProperties struct {
	// REQUIRED; APM Type
	Type *string

	// Non-sensitive properties for the APM
	Properties map[string]*string

	// Sensitive properties for the APM
	Secrets map[string]*string

	// READ-ONLY; State of the APM.
	ProvisioningState *ApmProvisioningState
}

// ApmReference - A reference to the APM
type ApmReference struct {
	// REQUIRED; Resource Id of the APM
	ResourceID *string
}

// ApmResource - APM Resource object
type ApmResource struct {
	// Properties of an APM
	Properties *ApmProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ApmResourceCollection - Object that includes an array of APM resources and a possible link for next set
type ApmResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of APM resources
	Value []*ApmResource
}

// ApmSecretKeys - Keys of APM sensitive properties
type ApmSecretKeys struct {
	// Collection of the keys for the APM sensitive properties
	Value []*string
}

// AppResource - App resource payload
type AppResource struct {
	// The Managed Identity type of the app resource
	Identity *ManagedIdentityProperties

	// The GEO location of the application, always the same with its parent resource
	Location *string

	// Properties of the App resource
	Properties *AppResourceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// AppResourceCollection - Object that includes an array of App resources and a possible link for next set
type AppResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of App resources
	Value []*AppResource
}

// AppResourceProperties - App resource properties payload
type AppResourceProperties struct {
	// Collection of addons
	AddonConfigs map[string]any

	// List of custom persistent disks
	CustomPersistentDisks []*CustomPersistentDiskResource

	// Indicate if end to end TLS is enabled.
	EnableEndToEndTLS *bool

	// Indicate if only https is allowed.
	HTTPSOnly *bool

	// App ingress settings payload.
	IngressSettings *IngressSettings

	// Collection of loaded certificates
	LoadedCertificates []*LoadedCertificate

	// Persistent disk settings
	PersistentDisk *PersistentDisk

	// Indicates whether the App exposes public endpoint
	Public *bool

	// Temporary disk settings
	TemporaryDisk *TemporaryDisk

	// Additional App settings in vnet injection instance
	VnetAddons *AppVNetAddons

	// READ-ONLY; Fully qualified dns Name.
	Fqdn *string

	// READ-ONLY; Provisioning state of the App
	ProvisioningState *AppResourceProvisioningState

	// READ-ONLY; URL of the App
	URL *string
}

// AppVNetAddons - Additional App settings in vnet injection instance
type AppVNetAddons struct {
	// Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
	PublicEndpoint *bool

	// READ-ONLY; URL of the App in vnet injection instance which could be accessed from internet
	PublicEndpointURL *string
}

type ApplicationAcceleratorComponent struct {
	ResourceRequests *ApplicationAcceleratorResourceRequests

	// READ-ONLY
	Instances []*ApplicationAcceleratorInstance

	// READ-ONLY
	Name *string
}

type ApplicationAcceleratorInstance struct {
	// READ-ONLY; Name of the Application Accelerator instance.
	Name *string

	// READ-ONLY; Status of the Application Accelerator instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string
}

// ApplicationAcceleratorProperties - Application accelerator properties payload
type ApplicationAcceleratorProperties struct {
	// READ-ONLY; Collection of components belong to application accelerator.
	Components []*ApplicationAcceleratorComponent

	// READ-ONLY; State of the application accelerator.
	ProvisioningState *ApplicationAcceleratorProvisioningState
}

// ApplicationAcceleratorResource - Application accelerator resource
type ApplicationAcceleratorResource struct {
	// Application accelerator properties payload
	Properties *ApplicationAcceleratorProperties

	// Sku of the application accelerator resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ApplicationAcceleratorResourceCollection - Object that includes an array of application accelerator resources and a possible
// link for next set
type ApplicationAcceleratorResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of application accelerator resources
	Value []*ApplicationAcceleratorResource
}

type ApplicationAcceleratorResourceRequests struct {
	// READ-ONLY; Cpu allocated to each application accelerator component. 1 core can be represented by 1 or 1000m
	CPU *string

	// READ-ONLY; Instance count of the application accelerator component.
	InstanceCount *int32

	// READ-ONLY; Memory allocated to each application accelerator component. 1 GB can be represented by 1Gi or 1024Mi.
	Memory *string
}

// ApplicationInsightsAgentVersions - Application Insights agent versions properties payload
type ApplicationInsightsAgentVersions struct {
	// READ-ONLY; Indicates the version of application insight java agent
	Java *string
}

// ApplicationLiveViewComponent - Application Live View properties payload
type ApplicationLiveViewComponent struct {
	// READ-ONLY; Collection of instances belong to Application Live View.
	Instances []*ApplicationLiveViewInstance

	// READ-ONLY; Name of the component.
	Name any

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ApplicationLiveViewResourceRequests
}

// ApplicationLiveViewInstance - Collection of instances belong to the Application Live View
type ApplicationLiveViewInstance struct {
	// READ-ONLY; Name of the Application Live View instance.
	Name *string

	// READ-ONLY; Status of the Application Live View instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string
}

// ApplicationLiveViewProperties - Application Live View properties payload
type ApplicationLiveViewProperties struct {
	// READ-ONLY; Component details of Application Live View
	Components []*ApplicationLiveViewComponent

	// READ-ONLY; State of the Application Live View.
	ProvisioningState *ApplicationLiveViewProvisioningState
}

// ApplicationLiveViewResource - Application Live View resource
type ApplicationLiveViewResource struct {
	// Application Live View properties payload
	Properties *ApplicationLiveViewProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ApplicationLiveViewResourceCollection - Object that includes an array of Application Live View resources and a possible
// link for next set
type ApplicationLiveViewResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Application Live View resources
	Value []*ApplicationLiveViewResource
}

// ApplicationLiveViewResourceRequests - The resource quantity for required CPU and Memory of Application Live View component
type ApplicationLiveViewResourceRequests struct {
	// READ-ONLY; Cpu quantity allocated to each Application Live View component instance. 1 core can be represented by 1 or 1000m.
	CPU *string

	// READ-ONLY; Desired instance count of Application Live View component instance.
	InstanceCount *int32

	// READ-ONLY; Memory quantity allocated to each Application Live View component instance. 1 GB can be represented by 1Gi or
	// 1024Mi.
	Memory *string
}

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of available operation details
	Value []*OperationDetail
}

type AvailableRuntimeVersions struct {
	// READ-ONLY; A list of all supported runtime versions.
	Value []*SupportedRuntimeVersion
}

// AzureFileVolume - The properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	// REQUIRED; The mount path of the persistent disk.
	MountPath *string

	// REQUIRED; The type of the underlying resource to mount as a persistent disk.
	Type *Type

	// If set to true, it will create and mount a dedicated directory for every individual app instance.
	EnableSubPath *bool

	// These are the mount options for a persistent disk.
	MountOptions []*string

	// Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool

	// The share name of the Azure File share.
	ShareName *string
}

// GetCustomPersistentDiskProperties implements the CustomPersistentDiskPropertiesClassification interface for type AzureFileVolume.
func (a *AzureFileVolume) GetCustomPersistentDiskProperties() *CustomPersistentDiskProperties {
	return &CustomPersistentDiskProperties{
		EnableSubPath: a.EnableSubPath,
		MountOptions:  a.MountOptions,
		MountPath:     a.MountPath,
		ReadOnly:      a.ReadOnly,
		Type:          a.Type,
	}
}

// BindingResource - Binding resource payload
type BindingResource struct {
	// Properties of the Binding resource
	Properties *BindingResourceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BindingResourceCollection - Object that includes an array of Binding resources and a possible link for next set
type BindingResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Binding resources
	Value []*BindingResource
}

// BindingResourceProperties - Binding resource properties payload
type BindingResourceProperties struct {
	// Binding parameters of the Binding resource
	BindingParameters map[string]*string

	// The key of the bound resource
	Key *string

	// The Azure resource id of the bound resource
	ResourceID *string

	// READ-ONLY; Creation time of the Binding resource
	CreatedAt *string

	// READ-ONLY; The generated Spring Boot property file for this binding. The secret will be deducted.
	GeneratedProperties *string

	// READ-ONLY; The name of the bound resource
	ResourceName *string

	// READ-ONLY; The standard Azure resource type of the bound resource
	ResourceType *string

	// READ-ONLY; Update time of the Binding resource
	UpdatedAt *string
}

// Build resource payload
type Build struct {
	// Properties of the build resource
	Properties *BuildProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuildCollection - Object that includes an array of Build resources and a possible link for next set
type BuildCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Build resources
	Value []*Build
}

// BuildProperties - Build resource properties payload
type BuildProperties struct {
	// The resource id of agent pool
	AgentPool *string

	// The APMs for this build
	Apms []*ApmReference

	// The resource id of builder to build the source code
	Builder *string

	// The CA Certificates for this build
	Certificates []*CertificateReference

	// The environment variables for this build
	Env map[string]*string

	// The relative path of source code
	RelativePath *string

	// The customized build resource for this build
	ResourceRequests *BuildResourceRequests

	// READ-ONLY; Provisioning state of the KPack build result
	ProvisioningState *BuildProvisioningState

	// READ-ONLY; The build result triggered by this build
	TriggeredBuildResult *TriggeredBuildResult
}

// BuildResourceRequests - Resource request payload of Build Resource.
type BuildResourceRequests struct {
	// Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m. The default value is 1, this should
	// not exceed build service agent pool cpu size.
	CPU *string

	// Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi. The default value is 2Gi, this
	// should not exceed build service agent pool memory size.
	Memory *string
}

// BuildResult - Build result resource payload
type BuildResult struct {
	// Properties of the build result resource
	Properties *BuildResultProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuildResultCollection - Object that includes an array of Build result resources and a possible link for next set
type BuildResultCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Build result resources
	Value []*BuildResult
}

// BuildResultLog - Build result log resource properties payload
type BuildResultLog struct {
	// The public download URL of this build result log
	BlobURL *string
}

// BuildResultProperties - Build result resource properties payload
type BuildResultProperties struct {
	// The build pod name which can be used to get the build log streaming.
	BuildPodName *string

	// Error when build is failed.
	Error *Error

	// The name of this build result
	Name *string

	// READ-ONLY; All of the build stage (init-container and container) resources in build pod.
	BuildStages []*BuildStageProperties

	// READ-ONLY; The container registry image of this build result.
	Image *string

	// READ-ONLY; Provisioning state of the KPack build result
	ProvisioningState *BuildResultProvisioningState
}

// BuildResultUserSourceInfo - Reference to a build result
type BuildResultUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// Resource id of an existing succeeded build result under the same Spring instance.
	BuildResultID *string

	// Version of the source
	Version *string
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type BuildResultUserSourceInfo.
func (b *BuildResultUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    b.Type,
		Version: b.Version,
	}
}

// BuildService - Build service resource payload
type BuildService struct {
	// Properties of the build resource
	Properties *BuildServiceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuildServiceAgentPoolProperties - Build service agent pool properties
type BuildServiceAgentPoolProperties struct {
	// build service agent pool size properties
	PoolSize *BuildServiceAgentPoolSizeProperties

	// READ-ONLY; Provisioning state of the build service agent pool
	ProvisioningState *string
}

// BuildServiceAgentPoolResource - The build service agent pool resource
type BuildServiceAgentPoolResource struct {
	// build service agent pool properties
	Properties *BuildServiceAgentPoolProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuildServiceAgentPoolResourceCollection - Object that includes an array of build service agent pool resources and a possible
// link for next set
type BuildServiceAgentPoolResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of build service agent pool resource
	Value []*BuildServiceAgentPoolResource
}

// BuildServiceAgentPoolSizeProperties - Build service agent pool size properties
type BuildServiceAgentPoolSizeProperties struct {
	// The name of build service agent pool size
	Name *string

	// READ-ONLY; The cpu property of build service agent pool size
	CPU *string

	// READ-ONLY; The memory property of build service agent pool size
	Memory *string
}

// BuildServiceCollection - Object that includes an array of Build service resources and a possible link for next set
type BuildServiceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Build service resources
	Value []*BuildService
}

// BuildServiceProperties - Build service resource properties payload
type BuildServiceProperties struct {
	// The resource id of the container registry used in this build service.
	ContainerRegistry *string

	// The runtime resource configuration of this build service.
	ResourceRequests *BuildServicePropertiesResourceRequests

	// READ-ONLY; The installed KPack version in this build service.
	KPackVersion *string

	// READ-ONLY; Provisioning state of the KPack build service
	ProvisioningState *BuildServiceProvisioningState
}

// BuildServicePropertiesResourceRequests - The runtime resource configuration of this build service.
type BuildServicePropertiesResourceRequests struct {
	// READ-ONLY; vCPU allocated to the entire build service node pool.
	CPU *string

	// READ-ONLY; Memory allocated to the entire build service node pool.
	Memory *string
}

// BuildStageProperties - The build stage (init-container and container) resources in build pod.
type BuildStageProperties struct {
	// READ-ONLY; The exit code of this build init container.
	ExitCode *string

	// READ-ONLY; The name of this build stage resource.
	Name *string

	// READ-ONLY; The reason of this build init container.
	Reason *string

	// READ-ONLY; The provisioning state of this build stage resource.
	Status *KPackBuildStageProvisioningState
}

// BuilderProperties - KPack Builder properties payload
type BuilderProperties struct {
	// Builder buildpack groups.
	BuildpackGroups []*BuildpacksGroupProperties

	// Builder cluster stack property.
	Stack *StackProperties

	// READ-ONLY; Builder provision status.
	ProvisioningState *BuilderProvisioningState
}

// BuilderResource - KPack Builder resource
type BuilderResource struct {
	// Property of the Builder resource.
	Properties *BuilderProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuilderResourceCollection - Object that includes an array of Builder resources and a possible link for next set
type BuilderResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Builder resources
	Value []*BuilderResource
}

// BuildpackBindingLaunchProperties - Buildpack Binding Launch Properties
type BuildpackBindingLaunchProperties struct {
	// Non-sensitive properties for launchProperties
	Properties map[string]*string

	// Sensitive properties for launchProperties
	Secrets map[string]*string
}

// BuildpackBindingProperties - Properties of a buildpack binding
type BuildpackBindingProperties struct {
	// Buildpack Binding Type
	BindingType *BindingType

	// The object describes the buildpack binding launch properties
	LaunchProperties *BuildpackBindingLaunchProperties

	// READ-ONLY; State of the Buildpack Binding.
	ProvisioningState *BuildpackBindingProvisioningState
}

// BuildpackBindingResource - Buildpack Binding Resource object
type BuildpackBindingResource struct {
	// Properties of a buildpack binding
	Properties *BuildpackBindingProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// BuildpackBindingResourceCollection - Object that includes an array of BuildpackBinding resources and a possible link for
// next set
type BuildpackBindingResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of BuildpackBinding resources
	Value []*BuildpackBindingResource
}

// BuildpackProperties - Buildpack properties payload
type BuildpackProperties struct {
	// Id of the buildpack
	ID *string
}

// BuildpacksGroupProperties - Buildpack group properties of the Builder
type BuildpacksGroupProperties struct {
	// Buildpacks in the buildpack group
	Buildpacks []*BuildpackProperties

	// Buildpack group name
	Name *string
}

// CertificateProperties - Certificate resource payload.
type CertificateProperties struct {
	// REQUIRED; The type of the certificate source.
	Type *string

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string

	// READ-ONLY; The issuer of certificate.
	Issuer *string

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState

	// READ-ONLY; The subject name of certificate.
	SubjectName *string

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type CertificateProperties.
func (c *CertificateProperties) GetCertificateProperties() *CertificateProperties { return c }

// CertificateReference - A reference to the certificate
type CertificateReference struct {
	// REQUIRED; Resource Id of the certificate
	ResourceID *string
}

// CertificateResource - Certificate resource payload.
type CertificateResource struct {
	// Properties of the certificate resource payload.
	Properties CertificatePropertiesClassification

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// CertificateResourceCollection - Collection compose of certificate resources list and a possible link for next page.
type CertificateResourceCollection struct {
	// The link to next page of certificate list.
	NextLink *string

	// The certificate resources list.
	Value []*CertificateResource
}

// ClusterResourceProperties - Service properties payload
type ClusterResourceProperties struct {
	// Purchasing 3rd party product of the Service resource.
	MarketplaceResource *MarketplaceResource

	// Network profile of the Service
	NetworkProfile *NetworkProfile

	// Additional Service settings in vnet injection instance
	VnetAddons    *ServiceVNetAddons
	ZoneRedundant *bool

	// READ-ONLY; Fully qualified dns name of the service instance
	Fqdn *string

	// READ-ONLY; Power state of the Service
	PowerState *PowerState

	// READ-ONLY; Provisioning state of the Service
	ProvisioningState *ProvisioningState

	// READ-ONLY; ServiceInstanceEntity Id which uniquely identifies a created resource
	ServiceID *string

	// READ-ONLY; Version of the Service
	Version *int32
}

// ConfigServerGitProperty - Property of git.
type ConfigServerGitProperty struct {
	// REQUIRED; URI of the repository
	URI *string

	// Public sshKey of git repository.
	HostKey *string

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string

	// Label of the repository
	Label *string

	// Password of git repository basic auth.
	Password *string

	// Private sshKey algorithm of git repository.
	PrivateKey *string

	// Repositories of git.
	Repositories []*GitPatternRepository

	// Searching path of the repository
	SearchPaths []*string

	// Strict host key checking or not.
	StrictHostKeyChecking *bool

	// Username of git repository basic auth.
	Username *string
}

// ConfigServerProperties - Config server git properties payload
type ConfigServerProperties struct {
	// Settings of config server.
	ConfigServer *ConfigServerSettings

	// Error when apply config server settings.
	Error *Error

	// READ-ONLY; State of the config server.
	ProvisioningState *ConfigServerState
}

// ConfigServerResource - Config Server resource
type ConfigServerResource struct {
	// Properties of the Config Server resource
	Properties *ConfigServerProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ConfigServerSettings - The settings of config server.
type ConfigServerSettings struct {
	// Property of git environment.
	GitProperty *ConfigServerGitProperty
}

// ConfigServerSettingsErrorRecord - Error record of the config server settings
type ConfigServerSettingsErrorRecord struct {
	// The detail error messages of the record
	Messages []*string

	// The name of the config server settings error record
	Name *string

	// The uri of the config server settings error record
	URI *string
}

// ConfigServerSettingsValidateResult - Validation result for config server settings
type ConfigServerSettingsValidateResult struct {
	// The detail validation results
	Details []*ConfigServerSettingsErrorRecord

	// Indicate if the config server settings are valid
	IsValid *bool
}

// ConfigurationServiceGitProperty - Property of git environment.
type ConfigurationServiceGitProperty struct {
	// Repositories of Application Configuration Service git property.
	Repositories []*ConfigurationServiceGitRepository
}

// ConfigurationServiceGitPropertyValidateResult - Validation result for configuration service settings
type ConfigurationServiceGitPropertyValidateResult struct {
	// The detail validation results
	GitReposValidationResult []*ValidationMessages

	// Indicate if the configuration service settings are valid
	IsValid *bool
}

// ConfigurationServiceGitRepository - Git repository property payload for Application Configuration Service
type ConfigurationServiceGitRepository struct {
	// REQUIRED; Label of the repository
	Label *string

	// REQUIRED; Name of the repository
	Name *string

	// REQUIRED; Collection of patterns of the repository
	Patterns []*string

	// REQUIRED; URI of the repository
	URI *string

	// Resource Id of CA certificate for https URL of Git repository.
	CaCertResourceID *string

	// Git libraries used to support various repository providers
	GitImplementation *GitImplementation

	// Public sshKey of git repository.
	HostKey *string

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string

	// Password of git repository basic auth.
	Password *string

	// Private sshKey algorithm of git repository.
	PrivateKey *string

	// Searching path of the repository
	SearchPaths []*string

	// Strict host key checking or not.
	StrictHostKeyChecking *bool

	// Username of git repository basic auth.
	Username *string
}

// ConfigurationServiceInstance - Collection of instances belong to the Application Configuration Service
type ConfigurationServiceInstance struct {
	// READ-ONLY; Name of the Application Configuration Service instance
	Name *string

	// READ-ONLY; Status of the Application Configuration Service instance
	Status *string
}

// ConfigurationServiceProperties - Application Configuration Service properties payload
type ConfigurationServiceProperties struct {
	// The generation of the Application Configuration Service.
	Generation *ConfigurationServiceGeneration

	// The settings of Application Configuration Service.
	Settings *ConfigurationServiceSettings

	// READ-ONLY; Collection of instances belong to Application Configuration Service.
	Instances []*ConfigurationServiceInstance

	// READ-ONLY; State of the Application Configuration Service.
	ProvisioningState *ConfigurationServiceProvisioningState

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ConfigurationServiceResourceRequests
}

// ConfigurationServiceResource - Application Configuration Service resource
type ConfigurationServiceResource struct {
	// Application Configuration Service properties payload
	Properties *ConfigurationServiceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ConfigurationServiceResourceCollection - Object that includes an array of configuration service resources and a possible
// link for next set
type ConfigurationServiceResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of configuration service resources
	Value []*ConfigurationServiceResource
}

// ConfigurationServiceResourceRequests - Resource request payload of Application Configuration Service
type ConfigurationServiceResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Application Configuration Service instance
	CPU *string

	// READ-ONLY; Instance count of the Application Configuration Service
	InstanceCount *int32

	// READ-ONLY; Memory allocated to each Application Configuration Service instance
	Memory *string
}

// ConfigurationServiceSettings - The settings of Application Configuration Service.
type ConfigurationServiceSettings struct {
	// Property of git environment.
	GitProperty *ConfigurationServiceGitProperty
}

// ConfigurationServiceSettingsValidateResult - Validation result for configuration service settings
type ConfigurationServiceSettingsValidateResult struct {
	// Validation result for configuration service settings
	GitPropertyValidationResult *ConfigurationServiceGitPropertyValidateResult
}

// ContainerProbeSettings - Container liveness and readiness probe settings
type ContainerProbeSettings struct {
	// Indicates whether disable the liveness and readiness probe
	DisableProbe *bool
}

// ContainerRegistryBasicCredentials - The basic authentication properties for the container registry resource.
type ContainerRegistryBasicCredentials struct {
	// REQUIRED; The password of the Container Registry.
	Password *string

	// REQUIRED; The login server of the Container Registry.
	Server *string

	// REQUIRED; The credential type of the container registry credentials.
	Type *string

	// REQUIRED; The username of the Container Registry.
	Username *string
}

// GetContainerRegistryCredentials implements the ContainerRegistryCredentialsClassification interface for type ContainerRegistryBasicCredentials.
func (c *ContainerRegistryBasicCredentials) GetContainerRegistryCredentials() *ContainerRegistryCredentials {
	return &ContainerRegistryCredentials{
		Type: c.Type,
	}
}

// ContainerRegistryCredentials - The credential for the container registry resource.
type ContainerRegistryCredentials struct {
	// REQUIRED; The credential type of the container registry credentials.
	Type *string
}

// GetContainerRegistryCredentials implements the ContainerRegistryCredentialsClassification interface for type ContainerRegistryCredentials.
func (c *ContainerRegistryCredentials) GetContainerRegistryCredentials() *ContainerRegistryCredentials {
	return c
}

// ContainerRegistryProperties - Container registry resource payload.
type ContainerRegistryProperties struct {
	// REQUIRED; The credentials of the container registry resource.
	Credentials ContainerRegistryCredentialsClassification

	// READ-ONLY; State of the Container Registry.
	ProvisioningState *ContainerRegistryProvisioningState
}

// ContainerRegistryResource - Container registry resource payload.
type ContainerRegistryResource struct {
	// Properties of the container registry resource payload.
	Properties *ContainerRegistryProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ContainerRegistryResourceCollection - Collection compose of container registry resources list and a possible link for next
// page.
type ContainerRegistryResourceCollection struct {
	// The link to next page of storage list.
	NextLink *string

	// The container registry resources list.
	Value []*ContainerRegistryResource
}

// ContainerRegistryValidateResult - Validation result for container registry properties
type ContainerRegistryValidateResult struct {
	// Indicate if the container registry properties are valid
	IsValid *bool

	// Detailed validation messages.
	Message *string
}

// ContentCertificateProperties - Properties of certificate imported from key vault.
type ContentCertificateProperties struct {
	// REQUIRED; The type of the certificate source.
	Type *string

	// The content of uploaded certificate.
	Content *string

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string

	// READ-ONLY; The issuer of certificate.
	Issuer *string

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState

	// READ-ONLY; The subject name of certificate.
	SubjectName *string

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type ContentCertificateProperties.
func (c *ContentCertificateProperties) GetCertificateProperties() *CertificateProperties {
	return &CertificateProperties{
		ActivateDate:      c.ActivateDate,
		DNSNames:          c.DNSNames,
		ExpirationDate:    c.ExpirationDate,
		IssuedDate:        c.IssuedDate,
		Issuer:            c.Issuer,
		ProvisioningState: c.ProvisioningState,
		SubjectName:       c.SubjectName,
		Thumbprint:        c.Thumbprint,
		Type:              c.Type,
	}
}

// CustomContainer - Custom container payload
type CustomContainer struct {
	// Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
	Args []*string

	// Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
	Command []*string

	// Container image of the custom container. This should be in the form of : without the server name of the registry
	ContainerImage *string

	// Credential of the image registry
	ImageRegistryCredential *ImageRegistryCredential

	// Language framework of the container image uploaded. Supported values: "springboot", "", null.
	LanguageFramework *string

	// The name of the registry that contains the container image
	Server *string
}

// CustomContainerUserSourceInfo - Custom container user source info
type CustomContainerUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// Custom container payload
	CustomContainer *CustomContainer

	// Version of the source
	Version *string
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type CustomContainerUserSourceInfo.
func (c *CustomContainerUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    c.Type,
		Version: c.Version,
	}
}

// CustomDomainProperties - Custom domain of app resource payload.
type CustomDomainProperties struct {
	// The bound certificate name of domain.
	CertName *string

	// The thumbprint of bound certificate.
	Thumbprint *string

	// READ-ONLY; The app name of domain.
	AppName *string

	// READ-ONLY; Provisioning state of the Domain
	ProvisioningState *CustomDomainResourceProvisioningState
}

// CustomDomainResource - Custom domain resource payload.
type CustomDomainResource struct {
	// Properties of the custom domain resource.
	Properties *CustomDomainProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// CustomDomainResourceCollection - Collection compose of a custom domain resources list and a possible link for next page.
type CustomDomainResourceCollection struct {
	// The link to next page of custom domain list.
	NextLink *string

	// The custom domain resources list.
	Value []*CustomDomainResource
}

// CustomDomainValidatePayload - Custom domain validate payload.
type CustomDomainValidatePayload struct {
	// REQUIRED; Name to be validated
	Name *string
}

// CustomDomainValidateResult - Validation result for custom domain.
type CustomDomainValidateResult struct {
	// Indicates if domain name is valid.
	IsValid *bool

	// Message of why domain name is invalid.
	Message *string
}

// CustomPersistentDiskProperties - Custom persistent disk resource payload.
type CustomPersistentDiskProperties struct {
	// REQUIRED; The mount path of the persistent disk.
	MountPath *string

	// REQUIRED; The type of the underlying resource to mount as a persistent disk.
	Type *Type

	// If set to true, it will create and mount a dedicated directory for every individual app instance.
	EnableSubPath *bool

	// These are the mount options for a persistent disk.
	MountOptions []*string

	// Indicates whether the persistent disk is a readOnly one.
	ReadOnly *bool
}

// GetCustomPersistentDiskProperties implements the CustomPersistentDiskPropertiesClassification interface for type CustomPersistentDiskProperties.
func (c *CustomPersistentDiskProperties) GetCustomPersistentDiskProperties() *CustomPersistentDiskProperties {
	return c
}

// CustomPersistentDiskResource - Custom persistent disk resource payload.
type CustomPersistentDiskResource struct {
	// REQUIRED; The resource id of Azure Spring Apps Storage resource.
	StorageID *string

	// Properties of the custom persistent disk resource payload.
	CustomPersistentDiskProperties CustomPersistentDiskPropertiesClassification
}

// CustomizedAcceleratorProperties - Customized accelerator properties payload
type CustomizedAcceleratorProperties struct {
	// REQUIRED
	GitRepository   *AcceleratorGitRepository
	AcceleratorTags []*string

	// Type of the customized accelerator.
	AcceleratorType *CustomizedAcceleratorType
	Description     *string
	DisplayName     *string
	IconURL         *string

	// READ-ONLY; Imports references all imports that this accelerator/fragment depends upon.
	Imports []*string

	// READ-ONLY; State of the customized accelerator.
	ProvisioningState *CustomizedAcceleratorProvisioningState
}

// CustomizedAcceleratorResource - Customized accelerator resource
type CustomizedAcceleratorResource struct {
	// Customized accelerator properties payload
	Properties *CustomizedAcceleratorProperties

	// Sku of the customized accelerator resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

type CustomizedAcceleratorResourceCollection struct {
	NextLink *string
	Value    []*CustomizedAcceleratorResource
}

// CustomizedAcceleratorValidateResult - Validation result for customized accelerator properties
type CustomizedAcceleratorValidateResult struct {
	// The detail validation results
	ErrorMessage *string

	// State of the customized accelerator validation result
	State *CustomizedAcceleratorValidateResultState
}

// DeploymentInstance - Deployment instance payload
type DeploymentInstance struct {
	// READ-ONLY; Discovery status of the deployment instance
	DiscoveryStatus *string

	// READ-ONLY; Name of the deployment instance
	Name *string

	// READ-ONLY; Failed reason of the deployment instance
	Reason *string

	// READ-ONLY; Start time of the deployment instance
	StartTime *string

	// READ-ONLY; Status of the deployment instance
	Status *string

	// READ-ONLY; Availability zone information of the deployment instance
	Zone *string
}

// DeploymentList - A list of deployments resource ids.
type DeploymentList struct {
	// A list of deployment resource ids.
	Deployments []*string
}

// DeploymentResource - Deployment resource payload
type DeploymentResource struct {
	// Properties of the Deployment resource
	Properties *DeploymentResourceProperties

	// Sku of the Deployment resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// DeploymentResourceCollection - Object that includes an array of App resources and a possible link for next set
type DeploymentResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Deployment resources
	Value []*DeploymentResource
}

// DeploymentResourceProperties - Deployment resource properties payload
type DeploymentResourceProperties struct {
	// Indicates whether the Deployment is active
	Active *bool

	// Deployment settings of the Deployment
	DeploymentSettings *DeploymentSettings

	// Uploaded source information of the deployment.
	Source UserSourceInfoClassification

	// READ-ONLY; Collection of instances belong to the Deployment
	Instances []*DeploymentInstance

	// READ-ONLY; Provisioning state of the Deployment
	ProvisioningState *DeploymentResourceProvisioningState

	// READ-ONLY; Status of the Deployment
	Status *DeploymentResourceStatus
}

// DeploymentSettings - Deployment settings payload
type DeploymentSettings struct {
	// Collection of addons
	AddonConfigs map[string]any

	// Collection of ApmReferences
	Apms []*ApmReference

	// Container liveness and readiness probe settings
	ContainerProbeSettings *ContainerProbeSettings

	// Collection of environment variables
	EnvironmentVariables map[string]*string

	// Periodic probe of App Instance liveness. App Instance will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	LivenessProbe *Probe

	// Periodic probe of App Instance service readiness. App Instance will be removed from service endpoints if the probe fails.
	// More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	ReadinessProbe *Probe

	// The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required
	// CPU and Memory, the old field cpu and memoryInGB will be deprecated
	// later.
	ResourceRequests *ResourceRequests

	// StartupProbe indicates that the App Instance has successfully initialized. If specified, no other probes are executed until
	// this completes successfully. If this probe fails, the Pod will be restarted,
	// just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a App Instance's
	// lifecycle, when it might take a long time to load data or warm a cache,
	// than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	StartupProbe *Probe

	// Optional duration in seconds the App Instance needs to terminate gracefully. May be decreased in delete request. Value
	// must be non-negative integer. The value zero indicates stop immediately via the
	// kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace
	// period is the duration in seconds after the processes running in the App
	// Instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this
	// value longer than the expected cleanup time for your process. Defaults to 90
	// seconds.
	TerminationGracePeriodSeconds *int32
}

type DevToolPortalComponent struct {
	// READ-ONLY; Collection of instances belong to Dev Tool Portal.
	Instances []*DevToolPortalInstance

	// READ-ONLY
	Name *string

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *DevToolPortalResourceRequests
}

// DevToolPortalFeatureDetail - Detail settings for Dev Tool Portal feature
type DevToolPortalFeatureDetail struct {
	// State of the plugin
	State *DevToolPortalFeatureState

	// READ-ONLY; Route path to visit the plugin
	Route *string
}

// DevToolPortalFeatureSettings - Settings for Dev Tool Portal
type DevToolPortalFeatureSettings struct {
	// Detail of Accelerator plugin
	ApplicationAccelerator *DevToolPortalFeatureDetail

	// Detail of App Live View plugin
	ApplicationLiveView *DevToolPortalFeatureDetail
}

// DevToolPortalInstance - Collection of instances belong to the Dev Tool Portal.
type DevToolPortalInstance struct {
	// READ-ONLY; Name of the Dev Tool Portal instance.
	Name *string

	// READ-ONLY; Status of the Dev Tool Portal instance. It can be Pending, Running, Succeeded, Failed, Unknown.
	Status *string
}

// DevToolPortalProperties - Dev Tool Portal properties payload
type DevToolPortalProperties struct {
	// Settings for Dev Tool Portal
	Features *DevToolPortalFeatureSettings

	// Indicates whether the resource exposes public endpoint
	Public *bool

	// Single sign-on related configuration
	SsoProperties *DevToolPortalSsoProperties

	// READ-ONLY; Collection of components belong to Dev Tool Portal.
	Components []*DevToolPortalComponent

	// READ-ONLY; State of the Dev Tool Portal.
	ProvisioningState *DevToolPortalProvisioningState

	// READ-ONLY; URL of the resource, exposed when 'public' is true.
	URL *string
}

// DevToolPortalResource - Dev Tool Portal resource
type DevToolPortalResource struct {
	// Dev Tool Portal properties payload
	Properties *DevToolPortalProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// DevToolPortalResourceCollection - Object that includes an array of Dev Tool Portal resources and a possible link for next
// set
type DevToolPortalResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Dev Tool Portal resources
	Value []*DevToolPortalResource
}

// DevToolPortalResourceRequests - The resource quantity for required CPU and Memory of Dev Tool Portal
type DevToolPortalResourceRequests struct {
	// READ-ONLY; Cpu quantity allocated to each Dev Tool Portal instance. 1 core can be represented by 1 or 1000m
	CPU *string

	// READ-ONLY; Desired instance count of Dev Tool Portal.
	InstanceCount *int32

	// READ-ONLY; Memory quantity allocated to each Dev Tool Portal instance. 1 GB can be represented by 1Gi or 1024Mi.
	Memory *string
}

// DevToolPortalSsoProperties - Single sign-on related configuration
type DevToolPortalSsoProperties struct {
	// The public identifier for the application
	ClientID *string

	// The secret known only to the application and the authorization server
	ClientSecret *string

	// The URI of a JSON file with generic OIDC provider configuration.
	MetadataURL *string

	// It defines the specific actions applications can be allowed to do on a user's behalf
	Scopes []*string
}

// DiagnosticParameters - Diagnostic parameters of diagnostic operations
type DiagnosticParameters struct {
	// App instance name
	AppInstance *string

	// Duration of your JFR. 1 min can be represented by 1m or 60s.
	Duration *string

	// Your target file path in your own BYOS
	FilePath *string
}

// Error - The error code compose of code and message.
type Error struct {
	// The code of error.
	Code *string

	// The message of error.
	Message *string
}

// ExecAction describes a "run in container" action.
type ExecAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType

	// Command is the command line to execute inside the container, the working directory for the command is root ('/') in the
	// container's filesystem. The command is not run inside a shell, so traditional
	// shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of
	// 0 is treated as live/healthy and non-zero is unhealthy.
	Command []*string
}

// GetProbeAction implements the ProbeActionClassification interface for type ExecAction.
func (e *ExecAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: e.Type,
	}
}

// GatewayAPIMetadataProperties - API metadata property for Spring Cloud Gateway
type GatewayAPIMetadataProperties struct {
	// Detailed description of the APIs available on the Gateway instance (default: Generated OpenAPI 3 document that describes
	// the API routes configured.)
	Description *string

	// Location of additional documentation for the APIs available on the Gateway instance
	Documentation *string

	// Base URL that API consumers will use to access APIs on the Gateway instance.
	ServerURL *string

	// Title describing the context of the APIs available on the Gateway instance (default: Spring Cloud Gateway for K8S)
	Title *string

	// Version of APIs available on this Gateway instance (default: unspecified).
	Version *string
}

// GatewayAPIRoute - API route config of the Spring Cloud Gateway
type GatewayAPIRoute struct {
	// A description, will be applied to methods in the generated OpenAPI documentation.
	Description *string

	// To modify the request before sending it to the target endpoint, or the received response.
	Filters []*string

	// Route processing order.
	Order *int32

	// A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and
	// parameter values. All of the predicates associated with a route must evaluate
	// to true for the route to be matched to the request.
	Predicates []*string

	// Enable sso validation.
	SsoEnabled *bool

	// Classification tags, will be applied to methods in the generated OpenAPI documentation.
	Tags []*string

	// A title, will be applied to methods in the generated OpenAPI documentation.
	Title *string

	// Pass currently-authenticated user's identity token to application service, default is 'false'
	TokenRelay *bool

	// Full uri, will override appName.
	URI *string
}

// GatewayCorsProperties - Cross-Origin Resource Sharing property
type GatewayCorsProperties struct {
	// Whether user credentials are supported on cross-site requests. Valid values: true, false.
	AllowCredentials *bool

	// Allowed headers in cross-site requests. The special value * allows actual requests to send any header.
	AllowedHeaders []*string

	// Allowed HTTP methods on cross-site requests. The special value * allows all methods. If not set, GET and HEAD are allowed
	// by default.
	AllowedMethods []*string

	// Allowed origin patterns to make cross-site requests.
	AllowedOriginPatterns []*string

	// Allowed origins to make cross-site requests. The special value * allows all domains.
	AllowedOrigins []*string

	// HTTP response headers to expose for cross-site requests.
	ExposedHeaders []*string

	// How long, in seconds, the response from a pre-flight request can be cached by clients.
	MaxAge *int32
}

// GatewayCustomDomainProperties - The properties of custom domain for Spring Cloud Gateway
type GatewayCustomDomainProperties struct {
	// The thumbprint of bound certificate.
	Thumbprint *string
}

// GatewayCustomDomainResource - Custom domain of the Spring Cloud Gateway
type GatewayCustomDomainResource struct {
	// The properties of custom domain for Spring Cloud Gateway
	Properties *GatewayCustomDomainProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// GatewayCustomDomainResourceCollection - Object that includes an array of Spring Cloud Gateway custom domain resources and
// a possible link for next set
type GatewayCustomDomainResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Spring Cloud Gateway custom domain resources
	Value []*GatewayCustomDomainResource
}

// GatewayInstance - Collection of instances belong to the Spring Cloud Gateway
type GatewayInstance struct {
	// READ-ONLY; Name of the Spring Cloud Gateway instance
	Name *string

	// READ-ONLY; Status of the Spring Cloud Gateway instance
	Status *string
}

// GatewayOperatorProperties - Properties of the Spring Cloud Gateway Operator.
type GatewayOperatorProperties struct {
	// READ-ONLY; Collection of instances belong to Spring Cloud Gateway operator.
	Instances []*GatewayInstance

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayOperatorResourceRequests
}

// GatewayOperatorResourceRequests - Properties of the Spring Cloud Gateway Operator.
type GatewayOperatorResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Spring Cloud Gateway Operator instance.
	CPU *string

	// READ-ONLY; Instance count of the Spring Cloud Gateway Operator.
	InstanceCount *int32

	// READ-ONLY; Memory allocated to each Spring Cloud Gateway Operator instance.
	Memory *string
}

// GatewayProperties - Spring Cloud Gateway properties payload
type GatewayProperties struct {
	// API metadata property for Spring Cloud Gateway
	APIMetadataProperties *GatewayAPIMetadataProperties

	// Collection of ApmReferences in service level
	Apms []*ApmReference

	// Client-Certification Authentication.
	ClientAuth *GatewayPropertiesClientAuth

	// Cross-Origin Resource Sharing property
	CorsProperties *GatewayCorsProperties

	// Environment variables of Spring Cloud Gateway
	EnvironmentVariables *GatewayPropertiesEnvironmentVariables

	// Indicate if only https is allowed.
	HTTPSOnly *bool

	// Indicates whether the Spring Cloud Gateway exposes endpoint.
	Public *bool

	// The requested resource quantity for required CPU and Memory.
	ResourceRequests *GatewayResourceRequests

	// Single sign-on related configuration
	SsoProperties *SsoProperties

	// READ-ONLY; Collection of instances belong to Spring Cloud Gateway.
	Instances []*GatewayInstance

	// READ-ONLY; Properties of the Spring Cloud Gateway Operator.
	OperatorProperties *GatewayOperatorProperties

	// READ-ONLY; State of the Spring Cloud Gateway.
	ProvisioningState *GatewayProvisioningState

	// READ-ONLY; URL of the Spring Cloud Gateway, exposed when 'public' is true.
	URL *string
}

// GatewayPropertiesClientAuth - Client-Certification Authentication.
type GatewayPropertiesClientAuth struct {
	// Whether to enable certificate verification or not
	CertificateVerification *GatewayCertificateVerification

	// Collection of certificate resource Ids in Azure Spring Apps.
	Certificates []*string
}

// GatewayPropertiesEnvironmentVariables - Environment variables of Spring Cloud Gateway
type GatewayPropertiesEnvironmentVariables struct {
	// Non-sensitive properties
	Properties map[string]*string

	// Sensitive properties
	Secrets map[string]*string
}

// GatewayResource - Spring Cloud Gateway resource
type GatewayResource struct {
	// Spring Cloud Gateway properties payload
	Properties *GatewayProperties

	// Sku of the Spring Cloud Gateway resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// GatewayResourceCollection - Object that includes an array of gateway resources and a possible link for next set
type GatewayResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of gateway resources
	Value []*GatewayResource
}

// GatewayResourceRequests - Resource request payload of Spring Cloud Gateway.
type GatewayResourceRequests struct {
	// Cpu allocated to each Spring Cloud Gateway instance.
	CPU *string

	// Memory allocated to each Spring Cloud Gateway instance.
	Memory *string
}

// GatewayRouteConfigOpenAPIProperties - OpenAPI properties of Spring Cloud Gateway route config.
type GatewayRouteConfigOpenAPIProperties struct {
	// The URI of OpenAPI specification.
	URI *string
}

// GatewayRouteConfigProperties - API route config of the Spring Cloud Gateway
type GatewayRouteConfigProperties struct {
	// The resource Id of the Azure Spring Apps app, required unless route defines uri.
	AppResourceID *string

	// To modify the request before sending it to the target endpoint, or the received response in app level.
	Filters []*string

	// OpenAPI properties of Spring Cloud Gateway route config.
	OpenAPI *GatewayRouteConfigOpenAPIProperties

	// A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request
	// headers and parameter values. All of the predicates associated with a route
	// must evaluate to true for the route to be matched to the request.
	Predicates []*string

	// Protocol of routed Azure Spring Apps applications.
	Protocol *GatewayRouteConfigProtocol

	// Array of API routes, each route contains properties such as title, uri, ssoEnabled, predicates, filters.
	Routes []*GatewayAPIRoute

	// Enable Single Sign-On in app level.
	SsoEnabled *bool

	// READ-ONLY; State of the Spring Cloud Gateway route config.
	ProvisioningState *GatewayProvisioningState
}

// GatewayRouteConfigResource - Spring Cloud Gateway route config resource
type GatewayRouteConfigResource struct {
	// API route config of the Spring Cloud Gateway
	Properties *GatewayRouteConfigProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// GatewayRouteConfigResourceCollection - Object that includes an array of Spring Cloud Gateway route config resources and
// a possible link for next set
type GatewayRouteConfigResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Spring Cloud Gateway route config resources
	Value []*GatewayRouteConfigResource
}

// GitPatternRepository - Git repository property payload for config server
type GitPatternRepository struct {
	// REQUIRED; Name of the repository
	Name *string

	// REQUIRED; URI of the repository
	URI *string

	// Public sshKey of git repository.
	HostKey *string

	// SshKey algorithm of git repository.
	HostKeyAlgorithm *string

	// Label of the repository
	Label *string

	// Password of git repository basic auth.
	Password *string

	// Collection of pattern of the repository
	Pattern []*string

	// Private sshKey algorithm of git repository.
	PrivateKey *string

	// Searching path of the repository
	SearchPaths []*string

	// Strict host key checking or not.
	StrictHostKeyChecking *bool

	// Username of git repository basic auth.
	Username *string
}

// GloballyEnabledApms - Globally enabled APMs payload
type GloballyEnabledApms struct {
	// Collection of the globally enabled APMs
	Value []*string
}

// HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType

	// Path to access on the HTTP server.
	Path *string

	// Scheme to use for connecting to the host. Defaults to HTTP.
	// Possible enum values:
	// * "HTTP" means that the scheme used will be http://
	// * "HTTPS" means that the scheme used will be https://
	Scheme *HTTPSchemeType
}

// GetProbeAction implements the ProbeActionClassification interface for type HTTPGetAction.
func (h *HTTPGetAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: h.Type,
	}
}

// ImageRegistryCredential - Credential of the image registry
type ImageRegistryCredential struct {
	// The password of the image registry credential
	Password *string

	// The username of the image registry credential
	Username *string
}

// IngressConfig - Ingress configuration payload for Azure Spring Apps resource.
type IngressConfig struct {
	// Ingress read time out in seconds.
	ReadTimeoutInSeconds *int32
}

// IngressSettings - App ingress settings payload.
type IngressSettings struct {
	// How ingress should communicate with this app backend service.
	BackendProtocol *BackendProtocol

	// Client-Certification Authentication.
	ClientAuth *IngressSettingsClientAuth

	// Ingress read time out in seconds.
	ReadTimeoutInSeconds *int32

	// Ingress send time out in seconds.
	SendTimeoutInSeconds *int32

	// Type of the affinity, set this to Cookie to enable session affinity.
	SessionAffinity *SessionAffinity

	// Time in seconds until the cookie expires.
	SessionCookieMaxAge *int32
}

// IngressSettingsClientAuth - Client-Certification Authentication.
type IngressSettingsClientAuth struct {
	// Collection of certificate resource id.
	Certificates []*string
}

// JarUploadedUserSourceInfo - Uploaded Jar binary for a deployment
type JarUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// JVM parameter
	JvmOptions *string

	// Relative path of the storage which stores the source
	RelativePath *string

	// Runtime version of the Jar file
	RuntimeVersion *string

	// Version of the source
	Version *string
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type JarUploadedUserSourceInfo.
func (j *JarUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: j.RelativePath,
		Type:         j.Type,
		Version:      j.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type JarUploadedUserSourceInfo.
func (j *JarUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    j.Type,
		Version: j.Version,
	}
}

// KeyVaultCertificateProperties - Properties of certificate imported from key vault.
type KeyVaultCertificateProperties struct {
	// REQUIRED; The certificate name of key vault.
	KeyVaultCertName *string

	// REQUIRED; The type of the certificate source.
	Type *string

	// REQUIRED; The vault uri of user key vault.
	VaultURI *string

	// Indicates whether to automatically synchronize certificate from key vault or not.
	AutoSync *KeyVaultCertificateAutoSync

	// The certificate version of key vault.
	CertVersion *string

	// Optional. If set to true, it will not import private key from key vault.
	ExcludePrivateKey *bool

	// READ-ONLY; The activate date of certificate.
	ActivateDate *string

	// READ-ONLY; The domain list of certificate.
	DNSNames []*string

	// READ-ONLY; The expiration date of certificate.
	ExpirationDate *string

	// READ-ONLY; The issue date of certificate.
	IssuedDate *string

	// READ-ONLY; The issuer of certificate.
	Issuer *string

	// READ-ONLY; Provisioning state of the Certificate
	ProvisioningState *CertificateResourceProvisioningState

	// READ-ONLY; The subject name of certificate.
	SubjectName *string

	// READ-ONLY; The thumbprint of certificate.
	Thumbprint *string
}

// GetCertificateProperties implements the CertificatePropertiesClassification interface for type KeyVaultCertificateProperties.
func (k *KeyVaultCertificateProperties) GetCertificateProperties() *CertificateProperties {
	return &CertificateProperties{
		ActivateDate:      k.ActivateDate,
		DNSNames:          k.DNSNames,
		ExpirationDate:    k.ExpirationDate,
		IssuedDate:        k.IssuedDate,
		Issuer:            k.Issuer,
		ProvisioningState: k.ProvisioningState,
		SubjectName:       k.SubjectName,
		Thumbprint:        k.Thumbprint,
		Type:              k.Type,
	}
}

// LoadedCertificate - Loaded certificate payload
type LoadedCertificate struct {
	// REQUIRED; Resource Id of loaded certificate
	ResourceID *string

	// Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
	LoadTrustStore *bool
}

// LogFileURLResponse - Log file URL payload
type LogFileURLResponse struct {
	// REQUIRED; URL of the log file
	URL *string
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string

	// Localized friendly display name of the log
	DisplayName *string

	// Name of the log
	Name *string
}

// ManagedIdentityProperties - Managed identity properties retrieved from ARM request headers.
type ManagedIdentityProperties struct {
	// Principal Id of system-assigned managed identity.
	PrincipalID *string

	// Tenant Id of system-assigned managed identity.
	TenantID *string

	// Type of the managed identity
	Type *ManagedIdentityType

	// Properties of user-assigned managed identities
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity
}

// MarketplaceResource - Purchasing 3rd Party product for one Azure Spring Apps instance
type MarketplaceResource struct {
	// The plan id of the 3rd Party Artifact that is being procured.
	Plan *string

	// The 3rd Party artifact that is being procured.
	Product *string

	// The publisher id of the 3rd Party Artifact that is being bought.
	Publisher *string
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string

	// Name of the dimension
	Name *string

	// Whether this dimension should be included for the Shoebox export scenario
	ToBeExportedForShoebox *bool
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string

	// Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string

	// Dimensions of the metric
	Dimensions []*MetricDimension

	// Localized friendly description of the metric
	DisplayDescription *string

	// Localized friendly display name of the metric
	DisplayName *string

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool

	// Name of the metric
	Name *string

	// Name of the MDM namespace. Optional.
	SourceMdmNamespace *string

	// Supported aggregation types
	SupportedAggregationTypes []*string

	// Supported time grain types
	SupportedTimeGrainTypes []*string

	// Unit that makes sense for the metric
	Unit *string
}

// MonitoringSettingProperties - Monitoring Setting properties payload
type MonitoringSettingProperties struct {
	// Indicates the versions of application insight agent
	AppInsightsAgentVersions *ApplicationInsightsAgentVersions

	// Target application insight instrumentation key, null or whitespace include empty will disable monitoringSettings
	AppInsightsInstrumentationKey *string

	// Indicates the sampling rate of application insight agent, should be in range [0.0, 100.0]
	AppInsightsSamplingRate *float64

	// Error when apply Monitoring Setting changes.
	Error *Error

	// Indicates whether enable the trace functionality, which will be deprecated since api version 2020-11-01-preview. Please
	// leverage appInsightsInstrumentationKey to indicate if monitoringSettings enabled
	// or not
	TraceEnabled *bool

	// READ-ONLY; State of the Monitoring Setting.
	ProvisioningState *MonitoringSettingState
}

// MonitoringSettingResource - Monitoring Setting resource
type MonitoringSettingResource struct {
	// Properties of the Monitoring Setting resource
	Properties *MonitoringSettingProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// NameAvailability - Name availability result payload
type NameAvailability struct {
	// Message why the name is not available
	Message *string

	// Indicates whether the name is available
	NameAvailable *bool

	// Reason why the name is not available
	Reason *string
}

// NameAvailabilityParameters - Name availability parameters payload
type NameAvailabilityParameters struct {
	// REQUIRED; Name to be checked
	Name *string

	// REQUIRED; Type of the resource to check name availability
	Type *string
}

// NetCoreZipUploadedUserSourceInfo - Uploaded Jar binary for a deployment
type NetCoreZipUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// The path to the .NET executable relative to zip root
	NetCoreMainEntryPath *string

	// Relative path of the storage which stores the source
	RelativePath *string

	// Runtime version of the .Net file
	RuntimeVersion *string

	// Version of the source
	Version *string
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type NetCoreZipUploadedUserSourceInfo.
func (n *NetCoreZipUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: n.RelativePath,
		Type:         n.Type,
		Version:      n.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type NetCoreZipUploadedUserSourceInfo.
func (n *NetCoreZipUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    n.Type,
		Version: n.Version,
	}
}

// NetworkProfile - Service network profile payload
type NetworkProfile struct {
	// Name of the resource group containing network resources for customer apps in Azure Spring Apps
	AppNetworkResourceGroup *string

	// Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
	AppSubnetID *string

	// Ingress configuration payload for Azure Spring Apps resource.
	IngressConfig *IngressConfig

	// The egress traffic type of Azure Spring Apps VNet instances.
	OutboundType *string

	// Azure Spring Apps service reserved CIDR
	ServiceCidr *string

	// Name of the resource group containing network resources of Azure Spring Apps Service Runtime
	ServiceRuntimeNetworkResourceGroup *string

	// Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
	ServiceRuntimeSubnetID *string

	// READ-ONLY; Desired outbound IP resources for Azure Spring Apps resource.
	OutboundIPs *NetworkProfileOutboundIPs

	// READ-ONLY; Required inbound or outbound traffics for Azure Spring Apps resource.
	RequiredTraffics []*RequiredTraffic
}

// NetworkProfileOutboundIPs - Desired outbound IP resources for Azure Spring Apps resource.
type NetworkProfileOutboundIPs struct {
	// READ-ONLY; A list of public IP addresses.
	PublicIPs []*string
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the operation
	Name *string

	// Origin of the operation
	Origin *string

	// Properties of the operation
	Properties *OperationProperties

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string

	// Localized friendly name for the operation
	Operation *string

	// Resource provider of the operation
	Provider *string

	// Resource of the operation
	Resource *string
}

// OperationProperties - Extra Operation properties
type OperationProperties struct {
	// Service specifications of the operation
	ServiceSpecification *ServiceSpecification
}

// PersistentDisk - Persistent disk payload
type PersistentDisk struct {
	// Mount path of the persistent disk
	MountPath *string

	// Size of the persistent disk in GB
	SizeInGB *int32

	// READ-ONLY; Size of the used persistent disk in GB
	UsedInGB *int32
}

// PredefinedAcceleratorProperties - Predefined accelerator properties payload
type PredefinedAcceleratorProperties struct {
	// State of the predefined accelerator.
	State *PredefinedAcceleratorState

	// READ-ONLY
	AcceleratorTags []*string

	// READ-ONLY
	Description *string

	// READ-ONLY
	DisplayName *string

	// READ-ONLY
	IconURL *string

	// READ-ONLY; Provisioning state of the predefined accelerator.
	ProvisioningState *PredefinedAcceleratorProvisioningState
}

// PredefinedAcceleratorResource - Predefined accelerator resource
type PredefinedAcceleratorResource struct {
	// Predefined accelerator properties payload
	Properties *PredefinedAcceleratorProperties

	// Sku of the predefined accelerator resource
	SKU *SKU

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

type PredefinedAcceleratorResourceCollection struct {
	NextLink *string
	Value    []*PredefinedAcceleratorResource
}

// Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive
// traffic.
type Probe struct {
	// REQUIRED; Indicate whether the probe is disabled.
	DisableProbe *bool

	// Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
	FailureThreshold *int32

	// Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	InitialDelaySeconds *int32

	// How often (in seconds) to perform the probe. Minimum value is 1.
	PeriodSeconds *int32

	// The action of the probe.
	ProbeAction ProbeActionClassification

	// Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and
	// startup. Minimum value is 1.
	SuccessThreshold *int32

	// Number of seconds after which the probe times out. Minimum value is 1.
	TimeoutSeconds *int32
}

// ProbeAction - The action of the probe.
type ProbeAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType
}

// GetProbeAction implements the ProbeActionClassification interface for type ProbeAction.
func (p *ProbeAction) GetProbeAction() *ProbeAction { return p }

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags.
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// RegenerateTestKeyRequestPayload - Regenerate test key request payload
type RegenerateTestKeyRequestPayload struct {
	// REQUIRED; Type of the test key
	KeyType *TestKeyType
}

// RemoteDebugging - Remote debugging config.
type RemoteDebugging struct {
	// Indicate if remote debugging is enabled
	Enabled *bool

	// Application debugging port
	Port *int32
}

// RemoteDebuggingPayload - Remote debugging payload.
type RemoteDebuggingPayload struct {
	// Application debugging port.
	Port *int32
}

// RequiredTraffic - Required inbound or outbound traffic for Azure Spring Apps resource.
type RequiredTraffic struct {
	// READ-ONLY; The direction of required traffic
	Direction *TrafficDirection

	// READ-ONLY; The FQDN list of required traffic
	Fqdns []*string

	// READ-ONLY; The ip list of required traffic
	IPs []*string

	// READ-ONLY; The port of required traffic
	Port *int32

	// READ-ONLY; The protocol of required traffic
	Protocol *string
}

// Resource - The core properties of ARM resources.
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ResourceRequests - Deployment resource request payload
type ResourceRequests struct {
	// Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4}
	// for Standard tier.
	CPU *string

	// Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi,
	// 1Gi, 2Gi, …, 8Gi} for Standard tier.
	Memory *string
}

// ResourceSKU - Describes an available Azure Spring Apps SKU.
type ResourceSKU struct {
	// Gets the capacity of SKU.
	Capacity *SKUCapacity

	// Gets a list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*ResourceSKULocationInfo

	// Gets the set of locations that the SKU is available.
	Locations []*string

	// Gets the name of SKU.
	Name *string

	// Gets the type of resource the SKU applies to.
	ResourceType *string

	// Gets the restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions

	// Gets the tier of SKU.
	Tier *string
}

type ResourceSKUCapabilities struct {
	// Gets an invariant to describe the feature.
	Name *string

	// Gets an invariant if the feature is measured by quantity.
	Value *string
}

// ResourceSKUCollection - Object that includes an array of Azure Spring Apps SKU and a possible link for next set
type ResourceSKUCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of resource SKU
	Value []*ResourceSKU
}

// ResourceSKULocationInfo - Locations and availability zones where the SKU is available
type ResourceSKULocationInfo struct {
	// Gets location of the SKU
	Location *string

	// Gets details of capabilities available to a SKU in specific zones.
	ZoneDetails []*ResourceSKUZoneDetails

	// Gets list of availability zones where the SKU is supported.
	Zones []*string
}

// ResourceSKURestrictionInfo - Information about the restriction where the SKU cannot be used
type ResourceSKURestrictionInfo struct {
	// Gets locations where the SKU is restricted
	Locations []*string

	// Gets list of availability zones where the SKU is restricted.
	Zones []*string
}

// ResourceSKURestrictions - Restrictions where the SKU cannot be used
type ResourceSKURestrictions struct {
	// Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'
	ReasonCode *ResourceSKURestrictionsReasonCode

	// Gets the information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSKURestrictionInfo

	// Gets the type of restrictions. Possible values include: 'Location', 'Zone'
	Type *ResourceSKURestrictionsType

	// Gets the value of restrictions. If the restriction type is set to location. This would be different locations where the
	// SKU is restricted.
	Values []*string
}

// ResourceSKUZoneDetails - Details of capabilities available to a SKU in specific zones
type ResourceSKUZoneDetails struct {
	// Gets a list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*ResourceSKUCapabilities

	// Gets the set of zones that the SKU is available in with the specified capabilities.
	Name []*string
}

// ResourceUploadDefinition - Resource upload definition payload
type ResourceUploadDefinition struct {
	// Source relative path
	RelativePath *string

	// Upload URL
	UploadURL *string
}

// SKU - Sku of Azure Spring Apps
type SKU struct {
	// Current capacity of the target resource
	Capacity *int32

	// Name of the Sku
	Name *string

	// Tier of the Sku
	Tier *string
}

// SKUCapacity - The SKU capacity
type SKUCapacity struct {
	// REQUIRED; Gets or sets the minimum.
	Minimum *int32

	// Gets or sets the default.
	Default *int32

	// Gets or sets the maximum.
	Maximum *int32

	// Gets or sets the type of the scale.
	ScaleType *SKUScaleType
}

// SKUObject - Resource Sku object used for scaling out and scaling in.
type SKUObject struct {
	// Sku of the Spring Cloud Gateway resource
	SKU *SKU
}

// ServiceRegistryInstance - Collection of instances belong to the Service Registry
type ServiceRegistryInstance struct {
	// READ-ONLY; Name of the Service Registry instance
	Name *string

	// READ-ONLY; Status of the Service Registry instance
	Status *string
}

// ServiceRegistryProperties - Service Registry properties payload
type ServiceRegistryProperties struct {
	// READ-ONLY; Collection of instances belong to Service Registry.
	Instances []*ServiceRegistryInstance

	// READ-ONLY; State of the Service Registry.
	ProvisioningState *ServiceRegistryProvisioningState

	// READ-ONLY; The requested resource quantity for required CPU and Memory.
	ResourceRequests *ServiceRegistryResourceRequests
}

// ServiceRegistryResource - Service Registry resource
type ServiceRegistryResource struct {
	// Service Registry properties payload
	Properties *ServiceRegistryProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ServiceRegistryResourceCollection - Object that includes an array of Service Registry resources and a possible link for
// next set
type ServiceRegistryResourceCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Service Registry resources
	Value []*ServiceRegistryResource
}

// ServiceRegistryResourceRequests - Resource request payload of Service Registry
type ServiceRegistryResourceRequests struct {
	// READ-ONLY; Cpu allocated to each Service Registry instance
	CPU *string

	// READ-ONLY; Instance count of the Service Registry
	InstanceCount *int32

	// READ-ONLY; Memory allocated to each Service Registry instance
	Memory *string
}

// ServiceResource - Service resource
type ServiceResource struct {
	// The GEO location of the resource.
	Location *string

	// Properties of the Service resource
	Properties *ClusterResourceProperties

	// Sku of the Service resource
	SKU *SKU

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// ServiceResourceList - Object that includes an array of Service resources and a possible link for next set
type ServiceResourceList struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of Service resources
	Value []*ServiceResource
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification
}

// ServiceVNetAddons - Additional Service settings in vnet injection instance
type ServiceVNetAddons struct {
	// Indicates whether the data plane components(log stream, app connect, remote debugging) in vnet injection instance could
	// be accessed from internet.
	DataPlanePublicEndpoint *bool

	// Indicates whether the log stream in vnet injection instance could be accessed from internet.
	LogStreamPublicEndpoint *bool
}

// SourceUploadedUserSourceInfo - Uploaded Java source code binary for a deployment
type SourceUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// Selector for the artifact to be used for the deployment for multi-module projects. This should be the relative path to
	// the target module/project.
	ArtifactSelector *string

	// Relative path of the storage which stores the source
	RelativePath *string

	// Runtime version of the source file
	RuntimeVersion *string

	// Version of the source
	Version *string
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type SourceUploadedUserSourceInfo.
func (s *SourceUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: s.RelativePath,
		Type:         s.Type,
		Version:      s.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type SourceUploadedUserSourceInfo.
func (s *SourceUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    s.Type,
		Version: s.Version,
	}
}

// SsoProperties - Single sign-on related configuration
type SsoProperties struct {
	// The public identifier for the application
	ClientID *string

	// The secret known only to the application and the authorization server
	ClientSecret *string

	// The URI of Issuer Identifier
	IssuerURI *string

	// It defines the specific actions applications can be allowed to do on a user's behalf
	Scope []*string
}

// StackProperties - KPack ClusterStack properties payload
type StackProperties struct {
	// Id of the ClusterStack.
	ID *string

	// Version of the ClusterStack
	Version *string
}

// StorageAccount - storage resource of type Azure Storage Account.
type StorageAccount struct {
	// REQUIRED; The account key of the Azure Storage Account.
	AccountKey *string

	// REQUIRED; The account name of the Azure Storage Account.
	AccountName *string

	// REQUIRED; The type of the storage.
	StorageType *StorageType
}

// GetStorageProperties implements the StoragePropertiesClassification interface for type StorageAccount.
func (s *StorageAccount) GetStorageProperties() *StorageProperties {
	return &StorageProperties{
		StorageType: s.StorageType,
	}
}

// StorageProperties - Storage resource payload.
type StorageProperties struct {
	// REQUIRED; The type of the storage.
	StorageType *StorageType
}

// GetStorageProperties implements the StoragePropertiesClassification interface for type StorageProperties.
func (s *StorageProperties) GetStorageProperties() *StorageProperties { return s }

// StorageResource - Storage resource payload.
type StorageResource struct {
	// Properties of the storage resource payload.
	Properties StoragePropertiesClassification

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// StorageResourceCollection - Collection compose of storage resources list and a possible link for next page.
type StorageResourceCollection struct {
	// The link to next page of storage list.
	NextLink *string

	// The storage resources list.
	Value []*StorageResource
}

// SupportedApmType - Supported APM type
type SupportedApmType struct {
	// The name of the supported APM type
	Name *string
}

// SupportedApmTypes - Supported APM types payload
type SupportedApmTypes struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of the supported APM type
	Value []*SupportedApmType
}

// SupportedBuildpackResource - Supported buildpack resource payload
type SupportedBuildpackResource struct {
	// Supported buildpack resource properties
	Properties *SupportedBuildpackResourceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// SupportedBuildpackResourceProperties - Supported buildpack resource properties
type SupportedBuildpackResourceProperties struct {
	// The id of supported buildpack
	BuildpackID *string
}

// SupportedBuildpacksCollection - Object that includes an array of supported buildpacks resources and a possible link for
// next set
type SupportedBuildpacksCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of supported buildpacks resources
	Value []*SupportedBuildpackResource
}

// SupportedRuntimeVersion - Supported deployment runtime version descriptor.
type SupportedRuntimeVersion struct {
	// The platform of this runtime version (possible values: "Java" or ".NET").
	Platform *SupportedRuntimePlatform

	// The raw value which could be passed to deployment CRUD operations.
	Value *SupportedRuntimeValue

	// The detailed version (major.minor) of the platform.
	Version *string
}

// SupportedServerVersion - Supported server version.
type SupportedServerVersion struct {
	// The server name.
	Server *string

	// The raw server version value which could be passed to deployment CRUD operations.
	Value *string

	// The Server version.
	Version *string
}

// SupportedServerVersions - Supported server versions.
type SupportedServerVersions struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of the supported server versions.
	Value []*SupportedServerVersion
}

// SupportedStackResource - Supported stack resource payload
type SupportedStackResource struct {
	// Supported stack resource properties
	Properties *SupportedStackResourceProperties

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// SupportedStackResourceProperties - Supported stack resource properties
type SupportedStackResourceProperties struct {
	// The id of supported stack
	StackID *string

	// The version of supported stack
	Version *string
}

// SupportedStacksCollection - Object that includes an array of supported stacks resources and a possible link for next set
type SupportedStacksCollection struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string

	// Collection of supported stacks resources
	Value []*SupportedStackResource
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType
}

// TCPSocketAction describes an action based on opening a socket
type TCPSocketAction struct {
	// REQUIRED; The type of the action to take to perform the health check.
	Type *ProbeActionType
}

// GetProbeAction implements the ProbeActionClassification interface for type TCPSocketAction.
func (t *TCPSocketAction) GetProbeAction() *ProbeAction {
	return &ProbeAction{
		Type: t.Type,
	}
}

// TemporaryDisk - Temporary disk payload
type TemporaryDisk struct {
	// Mount path of the temporary disk
	MountPath *string

	// Size of the temporary disk in GB
	SizeInGB *int32
}

// TestKeys - Test keys payload
type TestKeys struct {
	// Indicates whether the test endpoint feature enabled or not
	Enabled *bool

	// Primary key
	PrimaryKey *string

	// Primary test endpoint
	PrimaryTestEndpoint *string

	// Secondary key
	SecondaryKey *string

	// Secondary test endpoint
	SecondaryTestEndpoint *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// The GEO location of the resource.
	Location *string

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// TriggeredBuildResult - The build result triggered by a build
type TriggeredBuildResult struct {
	// The unique build id of this build result
	ID *string

	// The container image of this build result
	Image *string

	// The last transition reason of this build result
	LastTransitionReason *string

	// The last transition status of this build result
	LastTransitionStatus *string

	// The last transition time of this build result
	LastTransitionTime *time.Time

	// READ-ONLY; The provisioning state of this build result
	ProvisioningState *TriggeredBuildResultProvisioningState
}

// UploadedUserSourceInfo - Source with uploaded location
type UploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// Relative path of the storage which stores the source
	RelativePath *string

	// Version of the source
	Version *string
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type UploadedUserSourceInfo.
func (u *UploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo { return u }

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type UploadedUserSourceInfo.
func (u *UploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    u.Type,
		Version: u.Version,
	}
}

// UserAssignedManagedIdentity - The details of the user-assigned managed identity assigned to an App.
type UserAssignedManagedIdentity struct {
	// READ-ONLY; Client Id of user-assigned managed identity.
	ClientID *string

	// READ-ONLY; Principal Id of user-assigned managed identity.
	PrincipalID *string
}

// UserSourceInfo - Source information for a deployment
type UserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// Version of the source
	Version *string
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type UserSourceInfo.
func (u *UserSourceInfo) GetUserSourceInfo() *UserSourceInfo { return u }

// ValidationMessages - Validate messages of the configuration service git repositories
type ValidationMessages struct {
	// Detailed validation messages.
	Messages []*string

	// The name of the configuration service git repository.
	Name *string
}

// WarUploadedUserSourceInfo - Uploaded War binary for a deployment
type WarUploadedUserSourceInfo struct {
	// REQUIRED; Type of the source uploaded
	Type *string

	// JVM parameter
	JvmOptions *string

	// Relative path of the storage which stores the source
	RelativePath *string

	// Runtime version of the war file
	RuntimeVersion *string

	// Server version, currently only Apache Tomcat is supported
	ServerVersion *string

	// Version of the source
	Version *string
}

// GetUploadedUserSourceInfo implements the UploadedUserSourceInfoClassification interface for type WarUploadedUserSourceInfo.
func (w *WarUploadedUserSourceInfo) GetUploadedUserSourceInfo() *UploadedUserSourceInfo {
	return &UploadedUserSourceInfo{
		RelativePath: w.RelativePath,
		Type:         w.Type,
		Version:      w.Version,
	}
}

// GetUserSourceInfo implements the UserSourceInfoClassification interface for type WarUploadedUserSourceInfo.
func (w *WarUploadedUserSourceInfo) GetUserSourceInfo() *UserSourceInfo {
	return &UserSourceInfo{
		Type:    w.Type,
		Version: w.Version,
	}
}
