//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListNotificationRecipientEmails.json
func ExampleNotificationRecipientEmailClient_ListByNotification() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNotificationRecipientEmailClient().ListByNotification(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RecipientEmailCollection = armapimanagement.RecipientEmailCollection{
	// 	Count: to.Ptr[int64](3),
	// 	Value: []*armapimanagement.RecipientEmailContract{
	// 		{
	// 			Name: to.Ptr("contoso@live.com"),
	// 			Type: to.Ptr("Microsoft.ApiManagement/service/notifications/recipientEmails"),
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/contoso@live.com"),
	// 			Properties: &armapimanagement.RecipientEmailContractProperties{
	// 				Email: to.Ptr("contoso@live.com"),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("foobar!live"),
	// 			Type: to.Ptr("Microsoft.ApiManagement/service/notifications/recipientEmails"),
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/foobar!live"),
	// 			Properties: &armapimanagement.RecipientEmailContractProperties{
	// 				Email: to.Ptr("foobar!live"),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("foobar@live.com"),
	// 			Type: to.Ptr("Microsoft.ApiManagement/service/notifications/recipientEmails"),
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/foobar@live.com"),
	// 			Properties: &armapimanagement.RecipientEmailContractProperties{
	// 				Email: to.Ptr("foobar@live.com"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementHeadNotificationRecipientEmail.json
func ExampleNotificationRecipientEmailClient_CheckEntityExists() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNotificationRecipientEmailClient().CheckEntityExists(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, "contoso@live.com", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateNotificationRecipientEmail.json
func ExampleNotificationRecipientEmailClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNotificationRecipientEmailClient().CreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, "foobar@live.com", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RecipientEmailContract = armapimanagement.RecipientEmailContract{
	// 	Name: to.Ptr("foobar@live.com"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/notifications/recipientEmails"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/foobar@live.com"),
	// 	Properties: &armapimanagement.RecipientEmailContractProperties{
	// 		Email: to.Ptr("foobar@live.com"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementDeleteNotificationRecipientEmail.json
func ExampleNotificationRecipientEmailClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNotificationRecipientEmailClient().Delete(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, "contoso@live.com", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
