//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armaad

// ARMProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required
// location and tags
type ARMProxyResource struct {
	// READ-ONLY; The unique resource identifier of the Azure AD PrivateLink Policy.
	ID *string

	// READ-ONLY; The name of the Azure AD PrivateLink Policy.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// Name of this resource.
	Name *string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition

	// READ-ONLY; Description of the error.
	Message *string
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition
}

// PrivateEndpoint - Private endpoint object properties.
type PrivateEndpoint struct {
	// Full identifier of the private endpoint resource.
	ID *string
}

// PrivateEndpointConnection - Private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private link resources
type PrivateEndpointConnectionListResult struct {
	// URL to next page of results
	NextLink *string

	// Array of private link resources
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint

	// Updated tag information to set into the PrivateLinkConnection instance.
	PrivateLinkConnectionTags *TagsResource

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkPolicy - PrivateLink Policy configuration object.
type PrivateLinkPolicy struct {
	// Flag indicating whether all tenants are allowed
	AllTenants *bool

	// Name of this resource.
	Name *string

	// Guid of the owner tenant
	OwnerTenantID *string

	// Name of the resource group
	ResourceGroup *string

	// Name of the private link policy resource
	ResourceName *string

	// Subscription Identifier
	SubscriptionID *string

	// Resource tags.
	Tags map[string]*string

	// The list of tenantIds.
	Tenants []*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// PrivateLinkPolicyListResult - A list of private link policies
type PrivateLinkPolicyListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// Array of private link policies
	Value []*PrivateLinkPolicy
}

// PrivateLinkPolicyUpdateParameter - private Link policy parameters to be updated.
type PrivateLinkPolicyUpdateParameter struct {
	// Resource tags to be updated.
	Tags map[string]*string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; The unique resource identifier of the Azure AD PrivateLink Policy.
	ID *string

	// READ-ONLY; The name of the Azure AD PrivateLink Policy.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval or rejection.
	Description *string

	// Indicates whether the connection has been approved, rejected or removed by the given policy owner.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkConnection
// instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string
}
