!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_one2one_template
  use gbl_format
  use cube_types
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubetopology_cuberegion_types
  use cubecompute_messaging
  use cubecompute_one2one_act
  !
  public :: one2one_comm_t,one2one_user_t,one2one_prog_t
  private
  !
  type one2one_comm_t
     type(option_t), pointer :: comm
     type(cuberegion_comm_t) :: region
     type(cubeid_arg_t), pointer :: incube
     type(cube_prod_t),  pointer :: oucube
     type(one2one_act_comm_t) :: act
   contains
     procedure, public :: register_syntax => cubecompute_one2one_register_syntax
     procedure, public :: parse           => cubecompute_one2one_parse
     procedure, public :: main            => cubecompute_one2one_main
  end type one2one_comm_t
  !
  type one2one_user_t
     type(cubeid_user_t)     :: cubeids
     type(cuberegion_user_t) :: region
   contains
     procedure, private :: toprog => cubecompute_one2one_user_toprog
  end type one2one_user_t
  !
  type one2one_prog_t
     type(cuberegion_prog_t),  private :: region
     type(cube_t), pointer,    private :: incube
     type(cube_t), pointer,    private :: oucube
     type(one2one_act_prog_t), private :: act
     ! Dynamically resolved from the current input cube:
     integer(kind=code_k),     private :: type  ! Type of the output cube
     procedure(cubecompute_one2one_prog_loop), pointer, private :: loop => null()
   contains
     procedure, private :: header => cubecompute_one2one_prog_header
     procedure, private :: data   => cubecompute_one2one_prog_data
     procedure, private :: select_loop => cubecompute_one2one_prog_select_loop
  end type one2one_prog_t
  !
contains
  !
  subroutine cubecompute_one2one_register_syntax(comm,opername,cubename,access,  &
    operflags,opercomm,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_comm_t), intent(inout) :: comm
    character(len=*),      intent(in)    :: opername
    character(len=*),      intent(in)    :: cubename
    integer(kind=code_k),  intent(in)    :: access
    type(flag_t),          intent(in)    :: operflags(:)
    external                             :: opercomm
    logical,               intent(inout) :: error
    !
    type(cubeid_arg_t) :: incube
    type(cube_prod_t) :: oucube
    character(len=*), parameter :: rname='ONE2ONE>REGISTER>SYNTAX'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    ! Syntax
    call cubetools_register_command(&
         opername,trim(cubename),&
         'Compute the '//trim(opername)//' of a cube',&
         strg_id,&
         opercomm,&
         comm%comm,error)
    if (error) return
    call incube%register(&
         cubename,&
         trim(cubename)//' cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         access,&
         comm%incube,&
         error)
    if (error) return
    !
    call comm%region%register(error)
    if (error) return
    !
    ! Product
    call oucube%register(&
         opername,&
         'Output cube of the operation',&
         strg_id,&
         operflags,&
         comm%oucube,&
         error)
    if (error)  return
  end subroutine cubecompute_one2one_register_syntax
  !
  subroutine cubecompute_one2one_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! ONE2ONE cubename
    ! /SIZE sx [sy]
    ! /CENTER xcen ycen
    ! /RANGE zfirst zlast
    !----------------------------------------------------------------------
    class(one2one_comm_t), intent(in)    :: comm
    character(len=*),      intent(in)    :: line
    type(one2one_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>PARSE'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
    call comm%region%parse(line,user%region,error)
    if (error) return
  end subroutine cubecompute_one2one_parse
  !
  subroutine cubecompute_one2one_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_comm_t), intent(in)    :: comm
    type(one2one_user_t),  intent(inout) :: user
    logical,               intent(inout) :: error
    !
    type(one2one_prog_t) :: prog
    character(len=*), parameter :: rname='ONE2ONE>MAIN'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(comm,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubecompute_one2one_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_one2one_user_toprog(user,comm,prog,error)
    use cubetools_consistency_methods
    use cubeadm_get
    !----------------------------------------------------------------------
    ! Only the dimension of the cubes are checked here on purpose for
    ! this very basic command
    !----------------------------------------------------------------------
    class(one2one_user_t), intent(in)    :: user
    type(one2one_comm_t),  intent(in)    :: comm
    type(one2one_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>USER>TOPROG'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_get_header(comm%incube,user%cubeids,prog%incube,error)
    if (error) return
    !
    call user%region%toprog(prog%incube,prog%region,error)
    if (error) return
    call prog%region%list(error)
    if (error) return
    !
    prog%act%ima2ima => comm%act%ima2ima
    prog%act%vis2ima => comm%act%vis2ima
    prog%act%vis2vis => comm%act%vis2vis
    prog%act%spe2spe => comm%act%spe2spe
  end subroutine cubecompute_one2one_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_one2one_prog_header(prog,comm,error)
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------

    !----------------------------------------------------------------------
    class(one2one_prog_t), intent(inout) :: prog
    type(one2one_comm_t),  intent(in)    :: comm
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2ONE>PROG>HEADER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call prog%select_loop(error)
    if (error)  return
    !
    call cubeadm_clone_header_with_region(comm%oucube,  &
      prog%incube,prog%region,prog%oucube,error)
    if (error) return
    if (prog%type.eq.fmt_r4) then
      call cubetools_header_make_array_real(prog%oucube%head,error)
      if (error) return
    elseif (prog%type.eq.fmt_c4) then
      call cubetools_header_make_array_cplx(prog%oucube%head,error)
      if (error) return
    endif
  end subroutine cubecompute_one2one_prog_header
  !
  subroutine cubecompute_one2one_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(one2one_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='ONE2ONE>PROG>DATA'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,prog%region,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter,error)
       !$OMP END TASK
    enddo ! iter
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubecompute_one2one_prog_data
  !
  subroutine cubecompute_one2one_prog_select_loop(prog,error)
    !----------------------------------------------------------------------
    ! Dynamic selection of the loop engine: for the current input cube,
    ! select the loop which has proper argument (image_t vs visi_t).
    !----------------------------------------------------------------------
    class(one2one_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    character(len=2) :: combo
    character(len=12) :: datakind,dataaccess
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='ONE2ONE>PROG>SELECT>LOOP'
    !
    call hash_cube(prog%incube,combo,datakind,dataaccess)
    !
    prog%type = 0
    prog%loop => null()
    select case (combo)
    case ('CI')
      ! ZZZ We should check that only one of them is available
      if (associated(prog%act%vis2vis)) then
        prog%type = fmt_c4
        prog%loop => cubecompute_one2one_prog_loop_vis2vis
      elseif (associated(prog%act%vis2ima)) then
        prog%type = fmt_r4
        prog%loop => cubecompute_one2one_prog_loop_vis2ima
      endif
    case ('RI')
      if (associated(prog%act%ima2ima)) then
        prog%type = fmt_r4
        prog%loop => cubecompute_one2one_prog_loop_ima2ima
      endif
    case ('RS')
      if (associated(prog%act%spe2spe)) then
        prog%type = fmt_r4
        prog%loop => cubecompute_one2one_prog_loop_spe2spe
      endif
    end select
    if (prog%type.eq.0) then
      write(mess,'(5a)')  &
        'This command does not offer transformation from a ',  &
        trim(datakind),' cube (',trim(dataaccess),' access)'
      call cubecompute_message(seve%e,rname,mess)
      error = .true.
      return
    endif
    !
  contains
    subroutine hash_cube(incube,hash,datakind,dataaccess)
      use cubetools_access_types
      type(cube_t),     intent(in)  :: incube
      character(len=2), intent(out) :: hash
      character(len=*), intent(out) :: datakind
      character(len=*), intent(out) :: dataaccess
      !
      ! First letter: real/complex input cube
      if (incube%iscplx()) then
        hash(1:1) = 'C'
        datakind = 'C*4'
      else
        hash(1:1) = 'R'
        datakind = 'R*4'
      endif
      ! Second letter: imaset/speset access
      select case (incube%access())
      case (code_access_imaset)
        hash(2:2) = 'I'
      case (code_access_speset)
        hash(2:2) = 'S'
      case default
        hash(2:2) = '?'
      end select
      dataaccess = cubetools_accessname(incube%access())
    end subroutine hash_cube
  end subroutine cubecompute_one2one_prog_select_loop
  !
  subroutine cubecompute_one2one_prog_loop(prog,iter,error)
    use cubeadm_taskloop
    !----------------------------------------------------------------------
    ! Provides the interface for the prog loop subroutine
    !----------------------------------------------------------------------
    class(one2one_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
  end subroutine cubecompute_one2one_prog_loop
  !
  subroutine cubecompute_one2one_prog_loop_ima2ima(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(image_t) :: inima,ouima
    character(len=*), parameter :: rname='ONE2ONE>PROG>LOOP>IMA2IMA'
    !
    call inima%associate('input cube',prog%incube,iter,error)
    if (error) return
    call ouima%allocate('output cube',prog%oucube,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act%ima2ima(iter%ie,inima,ouima,error)
    enddo ! ie
  end subroutine cubecompute_one2one_prog_loop_ima2ima
  !
  subroutine cubecompute_one2one_prog_loop_vis2ima(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(visi_t) :: inima
    type(image_t) :: ouima
    character(len=*), parameter :: rname='ONE2ONE>PROG>LOOP>VIS2IMA'
    !
    call inima%associate('input cube',prog%incube,iter,error)
    if (error) return
    call ouima%allocate('output cube',prog%oucube,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act%vis2ima(iter%ie,inima,ouima,error)
    enddo ! ie
  end subroutine cubecompute_one2one_prog_loop_vis2ima
  !
  subroutine cubecompute_one2one_prog_loop_vis2vis(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(visi_t) :: inima,ouima
    character(len=*), parameter :: rname='ONE2ONE>PROG>LOOP>VIS2VIS'
    !
    call inima%associate('input cube',prog%incube,iter,error)
    if (error) return
    call ouima%allocate('output cube',prog%oucube,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act%vis2vis(iter%ie,inima,ouima,error)
    enddo ! ie
  end subroutine cubecompute_one2one_prog_loop_vis2vis
  !
  subroutine cubecompute_one2one_prog_loop_spe2spe(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2one_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(spectrum_t) :: inspe,ouspe
    character(len=*), parameter :: rname='ONE2ONE>PROG>LOOP>SPE2SPE'
    !
    call inspe%associate('input cube',prog%incube,iter,error)
    if (error) return
    call ouspe%allocate('output cube',prog%oucube,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act%spe2spe(iter%ie,inspe,ouspe,error)
    enddo ! ie
  end subroutine cubecompute_one2one_prog_loop_spe2spe
end module cubecompute_one2one_template
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
