searchData={"items":[{"type":"module","title":"ct","doc":"Main user interface for the `Common Test` framework.\n\nThis module implements the command-line interface for running tests and basic\nfunctions for `Common Test` case issues, such as configuration and logging.\n\nThe framework stores configuration values in a property list usually named\n`Config`. The list contains information about the test run added by the\nframework itself and may also contain user-provided values. The configuration is\npassed into individual test cases as well as support functions if defined.\n\nPossible configuration variables include:\n\n- `data_dir` \\- Data file directory\n- `priv_dir` \\- Scratch file directory\n- Whatever added by [`init_per_suite/1`](`c:ct_suite:init_per_suite/1`) or\n  [`init_per_testcase/2`](`c:ct_suite:init_per_testcase/2`) in the test suite.\n\n> #### Warning {: .warning }\n>\n> The `?config` macro, used to receive individual config values from the\n> `Config` property list, is deprecated. Please use `proplists:get_value/2-3`\n> instead.","ref":"ct.html"},{"type":"function","title":"ct.abort_current_testcase/1","doc":"Aborts the currently executing test case. The user must know with certainty\nwhich test case is currently executing. The function is therefore only safe to\ncall from a function that has been called (or synchronously invoked) by the test\ncase.\n\n`Reason`, the reason for aborting the test case, is printed in the test case\nlog.","ref":"ct.html#abort_current_testcase/1"},{"type":"function","title":"ct.add_config/2","doc":"Loads configuration variables using the specified callback module and\nconfiguration string. The callback module is to be either loaded or present in\nthe code path. Loaded configuration variables can later be removed using\nfunction [`ct:remove_config/2`](`remove_config/2`).","ref":"ct.html#add_config/2"},{"type":"function","title":"ct.break/1","doc":"Cancels any active timetrap and pauses the execution of the current test case\nuntil the user calls function `continue/0`. The user can then interact with the\nErlang node running the tests, for example, for debugging purposes or for\nmanually executing a part of the test case. If a parallel group is executing,\n[`ct:break/2`](`break/2`) is to be called instead.\n\nA cancelled timetrap is not automatically reactivated after the break, but must\nbe started explicitly with [`ct:timetrap/1`](`timetrap/1`).\n\nIn order for the break/continue functionality to work, `Common Test` must\nrelease the shell process controlling `stdin`. This is done by setting start\noption `release_shell` to `true`. For details, see section\n[Running Tests from the Erlang Shell or from an Erlang Program](run_test_chapter.md#erlang_shell_or_program)\nin the User's Guide.","ref":"ct.html#break/1"},{"type":"function","title":"ct.break/2","doc":"Works the same way as [`ct:break/1`](`break/1`), only argument `TestCase` makes\nit possible to pause a test case executing in a parallel group. Function\n[`ct:continue/1`](`continue/1`) is to be used to resume execution of `TestCase`.\n\nFor details, see [`ct:break/1`](`break/1`).","ref":"ct.html#break/2"},{"type":"function","title":"ct.capture_get/0","doc":"","ref":"ct.html#capture_get/0"},{"type":"function","title":"ct.capture_get/1","doc":"Returns and purges the list of text strings buffered during the latest session\nof capturing printouts to `stdout`. Log categories that are to be ignored in\n`ListOfStrings` can be specified with `ExclCategories`. If\n`ExclCategories = []`, no filtering takes place.\n\nSee also [`ct:capture_start/0`](`capture_start/0`),\n[`ct:capture_stop/0`](`capture_stop/0`), [`ct:log/3`](`log/3`).","ref":"ct.html#capture_get/1"},{"type":"function","title":"ct.capture_start/0","doc":"Starts capturing all text strings printed to `stdout` during execution of the\ntest case.\n\nSee also [`ct:capture_get/1`](`capture_get/1`),\n[`ct:capture_stop/0`](`capture_stop/0`).","ref":"ct.html#capture_start/0"},{"type":"function","title":"ct.capture_stop/0","doc":"Stops capturing text strings (a session started with `capture_start/0`).\n\nSee also [`ct:capture_get/1`](`capture_get/1`),\n[`ct:capture_start/0`](`capture_start/0`).","ref":"ct.html#capture_stop/0"},{"type":"function","title":"ct.comment/1","doc":"Prints the specified `Comment` in the comment field in the table on the test\nsuite result page.\n\nIf called several times, only the last comment is printed. The test case return\nvalue `{comment,Comment}` overwrites the string set by this function.","ref":"ct.html#comment/1"},{"type":"function","title":"ct.comment/2","doc":"Prints the formatted string in the comment field in the table on the test suite\nresult page.\n\nArguments `Format` and `Args` are used in a call to `io_lib:format/2` to create\nthe comment string. The behavior of [`comment/2`](`comment/2`) is otherwise the\nsame as function [`ct:comment/1`](`comment/1`).","ref":"ct.html#comment/2"},{"type":"function","title":"ct.continue/0","doc":"This function must be called to continue after a test case (not executing in a\nparallel group) has called function [`ct:break/1`](`break/1`).","ref":"ct.html#continue/0"},{"type":"function","title":"ct.continue/1","doc":"This function must be called to continue after a test case has called\n[`ct:break/2`](`break/2`). If the paused test case, `TestCase`, executes in a\nparallel group, this function, rather than `continue/0`, must be used to let the\ntest case proceed.","ref":"ct.html#continue/1"},{"type":"function","title":"ct.decrypt_config_file/2","doc":"Decrypts `EncryptFileName`, previously generated with\n[`ct:encrypt_config_file/2,3`](`encrypt_config_file/2`). The original file\ncontents is saved in the target file. The encryption key, a string, must be\navailable in a text file named `.ct_config.crypt`, either in the current\ndirectory, or the home directory of the user (it is searched for in that order).","ref":"ct.html#decrypt_config_file/2"},{"type":"function","title":"ct.decrypt_config_file/3","doc":"Decrypts `EncryptFileName`, previously generated with\n[`ct:encrypt_config_file/2,3`](`encrypt_config_file/2`). The original file\ncontents is saved in the target file. The key must have the same value as that\nused for encryption.","ref":"ct.html#decrypt_config_file/3"},{"type":"function","title":"ct.encrypt_config_file/2","doc":"Encrypts the source configuration file with DES3 and saves the result in file\n`EncryptFileName`. The key, a string, must be available in a text file named\n`.ct_config.crypt`, either in the current directory, or the home directory of\nthe user (it is searched for in that order).\n\nFor information about using encrypted configuration files when running tests,\nsee section\n[Encrypted Configuration Files](config_file_chapter.md#encrypted_config_files)\nin the User's Guide.\n\nFor details on DES3 encryption/decryption, see application\n[`Crypto`](`e:crypto:index.html`).","ref":"ct.html#encrypt_config_file/2"},{"type":"function","title":"ct.encrypt_config_file/3","doc":"Encrypts the source configuration file with DES3 and saves the result in the\ntarget file `EncryptFileName`. The encryption key to use is either the value in\n`{key,Key}` or the value stored in the file specified by `{file,File}`.\n\nFor information about using encrypted configuration files when running tests,\nsee section\n[Encrypted Configuration Files](config_file_chapter.md#encrypted_config_files)\nin the User's Guide.\n\nFor details on DES3 encryption/decryption, see application\n[`Crypto`](`e:crypto:index.html`).","ref":"ct.html#encrypt_config_file/3"},{"type":"function","title":"ct.fail/1","doc":"Terminates a test case with the specified error `Reason`.","ref":"ct.html#fail/1"},{"type":"function","title":"ct.fail/2","doc":"Terminates a test case with an error message specified by a format string and a\nlist of values (used as arguments to `io_lib:format/2`).","ref":"ct.html#fail/2"},{"type":"function","title":"ct.get_config/1","doc":"","ref":"ct.html#get_config/1"},{"type":"function","title":"ct.get_config/2","doc":"","ref":"ct.html#get_config/2"},{"type":"function","title":"ct.get_config/3","doc":"Reads configuration data values.\n\nReturns the matching values or configuration elements, given a configuration\nvariable key or its associated name (if one has been specified with\n[`ct:require/2`](`require/2`) or a `require` statement).\n\n_Example:_\n\nGiven the following configuration file:\n\n```erlang\n{unix,[{telnet,IpAddr},\n       {user,[{username,Username},\n              {password,Password}]}]}.\n```\n\nThen:\n\n```erlang\nct:get_config(unix,Default) -> [{telnet,IpAddr},\n {user, [{username,Username}, {password,Password}]}]\nct:get_config({unix,telnet},Default) -> IpAddr\nct:get_config({unix,user,username},Default) -> Username\nct:get_config({unix,ftp},Default) -> Default\nct:get_config(unknownkey,Default) -> Default\n```\n\nIf a configuration variable key has been associated with a name (by\n[`ct:require/2`](`require/2`) or a `require` statement), the name can be used\ninstead of the key to read the value:\n\n```erlang\nct:require(myuser,{unix,user}) -> ok.\nct:get_config(myuser,Default) -> [{username,Username}, {password,Password}]\n```\n\nIf a configuration variable is defined in multiple files, use option `all` to\naccess all possible values. The values are returned in a list. The order of the\nelements corresponds to the order that the configuration files were specified at\nstartup.\n\nIf configuration elements (key-value tuples) are to be returned as result\ninstead of values, use option `element`. The returned elements are then on the\nform `{Required,Value}`.\n\nSee also [`ct:get_config/1`](`get_config/1`),\n[`ct:get_config/2`](`get_config/2`), [`ct:require/1`](`require/1`),\n[`ct:require/2`](`require/2`).","ref":"ct.html#get_config/3"},{"type":"function","title":"ct.get_event_mgr_ref/0","doc":"Gets a reference to the `Common Test` event manager. The reference can be used\nto, for example, add a user-specific event handler while tests are running.\n\n_Example:_\n\n```erlang\ngen_event:add_handler(ct:get_event_mgr_ref(), my_ev_h, [])\n```","ref":"ct.html#get_event_mgr_ref/0"},{"type":"function","title":"ct.get_progname/0","doc":"Returns the command used to start this Erlang instance. If this information\ncould not be found, the string `\"no_prog_name\"` is returned.","ref":"ct.html#get_progname/0"},{"type":"function","title":"ct.get_status/0","doc":"Returns status of ongoing test. The returned list contains information about\nwhich test case is executing (a list of cases when a parallel test case group is\nexecuting), as well as counters for successful, failed, skipped, and total test\ncases so far.","ref":"ct.html#get_status/0"},{"type":"function","title":"ct.get_target_name/1","doc":"Returns the name of the target that the specified connection belongs to.","ref":"ct.html#get_target_name/1"},{"type":"function","title":"ct.get_testspec_terms/0","doc":"Gets a list of all test specification terms used to configure and run this test.","ref":"ct.html#get_testspec_terms/0"},{"type":"function","title":"ct.get_testspec_terms/1","doc":"Reads one or more terms from the test specification used to configure and run\nthis test. `Tag` is any valid test specification tag, for example, `label`,\n`config`, or `logdir`. User-specific terms are also available to read if option\n`allow_user_terms` is set.\n\nAll value tuples returned, except user terms, have the node name as first\nelement.\n\nTo read test terms, use `Tag = tests` (rather than `suites`, `groups`, or\n`cases`). `Value` is then the list of _all_ tests on the form\n`[{Node,Dir,[{TestSpec,GroupsAndCases1},...]},...]`, where\n`GroupsAndCases = [{Group,[Case]}] | [Case]`.","ref":"ct.html#get_testspec_terms/1"},{"type":"function","title":"ct.get_timetrap_info/0","doc":"Reads information about the timetrap set for the current test case. `Scaling`\nindicates if `Common Test` will attempt to compensate timetraps automatically\nfor runtime delays introduced by, for example, tools like cover. `ScaleVal` is\nthe value of the current scaling multiplier (always 1 if scaling is disabled).\nNote the `Time` is not the scaled result.","ref":"ct.html#get_timetrap_info/0"},{"type":"function","title":"ct.get_verbosity/1","doc":"This function returns the verbosity level for the specified logging category.\nSee the [User's Guide](write_test_chapter.md#logging) for details. Use the value\n`default` to read the general verbosity level.","ref":"ct.html#get_verbosity/1"},{"type":"function","title":"ct.install/1","doc":"Installs configuration files and event handlers.\n\nRun this function once before the first test.\n\n_Example:_\n\n```erlang\ninstall([{config,[\"config_node.ctc\",\"config_user.ctc\"]}])\n```\n\nThis function is automatically run by program `ct_run`.","ref":"ct.html#install/1"},{"type":"function","title":"ct.listenv/1","doc":"Performs command `listenv` on the specified Telnet connection and returns the\nresult as a list of key-value pairs.","ref":"ct.html#listenv/1"},{"type":"function","title":"ct.log/1","doc":"Equivalent to [`log(default, ?STD_IMPORTANCE, Format, [], [])`](`log/5`).","ref":"ct.html#log/1"},{"type":"function","title":"ct.log/2","doc":"","ref":"ct.html#log/2"},{"type":"function","title":"ct.log/3","doc":"","ref":"ct.html#log/3"},{"type":"function","title":"ct.log/4","doc":"","ref":"ct.html#log/4"},{"type":"function","title":"ct.log/5","doc":"Prints from a test case to the log file.\n\nThis function is meant for printing a string directly from a test case to the\ntest case log file.\n\nDefault `Category` is `default`, default `Importance` is `?STD_IMPORTANCE`, and\ndefault value for `FormatArgs` is `[]`.\n\nFor details on `Category`, `Importance` and the `no_css` option, see section\n[Logging - Categories and Verbosity Levels](write_test_chapter.md#logging) in\nthe User's Guide.\n\nCommon Test will not escape special HTML characters (<, > and &) in the text\nprinted with this function, unless the `esc_chars` option is used.","ref":"ct.html#log/5"},{"type":"function","title":"ct.make_priv_dir/0","doc":"If the test is started with option `create_priv_dir` set to `manual_per_tc`, in\norder for the test case to use the private directory, it must first create it by\ncalling this function.","ref":"ct.html#make_priv_dir/0"},{"type":"function","title":"ct.notify/2","doc":"Sends an asynchronous notification of type `Name` with `Data`to the Common Test\nevent manager. This can later be caught by any installed event manager.\n\nSee also `m:gen_event`.","ref":"ct.html#notify/2"},{"type":"function","title":"ct.pal/1","doc":"Equivalent to [`pal(default, ?STD_IMPORTANCE, Format, [])`](`pal/4`).","ref":"ct.html#pal/1"},{"type":"function","title":"ct.pal/2","doc":"","ref":"ct.html#pal/2"},{"type":"function","title":"ct.pal/3","doc":"","ref":"ct.html#pal/3"},{"type":"function","title":"ct.pal/4","doc":"","ref":"ct.html#pal/4"},{"type":"function","title":"ct.pal/5","doc":"Prints and logs from a test case.\n\nThis function is meant for printing a string from a test case, both to the test\ncase log file and to the console.\n\nDefault `Category` is `default`, default `Importance` is `?STD_IMPORTANCE`, and\ndefault value for `FormatArgs` is `[]`.\n\nFor details on `Category` and `Importance`, see section\n[Logging - Categories and Verbosity Levels](write_test_chapter.md#logging) in\nthe User's Guide.\n\nNote that special characters in the text (<, > and &) will be escaped by Common\nTest before the text is printed to the log file.","ref":"ct.html#pal/5"},{"type":"function","title":"ct.parse_table/1","doc":"Parses the printout from an SQL table and returns a list of tuples.\n\nThe printout to parse is typically the result of a `select` command in SQL. The\nreturned `Table` is a list of tuples, where each tuple is a row in the table.\n\n`Heading` is a tuple of strings representing the headings of each column in the\ntable.","ref":"ct.html#parse_table/1"},{"type":"function","title":"ct.print/1","doc":"Equivalent to [`print(default, ?STD_IMPORTANCE, Format, [], [])`](`print/5`).","ref":"ct.html#print/1"},{"type":"function","title":"ct.print/2","doc":"","ref":"ct.html#print/2"},{"type":"function","title":"ct.print/3","doc":"","ref":"ct.html#print/3"},{"type":"function","title":"ct.print/4","doc":"","ref":"ct.html#print/4"},{"type":"function","title":"ct.print/5","doc":"Prints from a test case to the console.\n\nThis function is meant for printing a string from a test case to the console.\n\nDefault `Category` is `default`, default `Importance` is `?STD_IMPORTANCE`, and\ndefault value for `FormatArgs` is `[]`.\n\nFor details on `Category` and `Importance`, see section\n[Logging - Categories and Verbosity Levels](write_test_chapter.md#logging) in\nthe User's Guide.","ref":"ct.html#print/5"},{"type":"function","title":"ct.reload_config/1","doc":"Reloads configuration file containing specified configuration key.\n\nThis function updates the configuration data from which the specified\nconfiguration variable was read, and returns the (possibly) new value of this\nvariable.\n\nIf some variables were present in the configuration, but are not loaded using\nthis function, they are removed from the configuration table together with their\naliases.","ref":"ct.html#reload_config/1"},{"type":"function","title":"ct.remaining_test_procs/0","doc":"This function will return the identity of test- and group leader processes that\nare still running at the time of this call. `TestProcs` are processes in the\nsystem that have a Common Test IO process as group leader. `SharedGL` is the\ncentral Common Test IO process, responsible for printing to log files for\nconfiguration functions and sequentially executing test cases. `OtherGLs` are\nCommon Test IO processes that print to log files for test cases in parallel test\ncase groups.\n\nThe process information returned by this function may be used to locate and\nterminate remaining processes after tests have finished executing. The function\nwould typically by called from Common Test Hook functions.\n\nNote that processes that execute configuration functions or test cases are never\nincluded in `TestProcs`. It is therefore safe to use post configuration hook\nfunctions (such as post_end_per_suite, post_end_per_group,\npost_end_per_testcase) to terminate all processes in `TestProcs` that have the\ncurrent group leader process as its group leader.\n\nNote also that the shared group leader (`SharedGL`) must never be terminated by\nthe user, only by Common Test. Group leader processes for parallel test case\ngroups (`OtherGLs`) may however be terminated in post_end_per_group hook\nfunctions.","ref":"ct.html#remaining_test_procs/0"},{"type":"function","title":"ct.remove_config/2","doc":"Removes configuration variables (together with their aliases) that were loaded\nwith specified callback module and configuration string.","ref":"ct.html#remove_config/2"},{"type":"function","title":"ct.require/1","doc":"Checks if the required configuration is available. Arbitrarily deep tuples can\nbe specified as `Required`. Only the last element of the tuple can be a list of\n`SubKey`s.\n\n_Example 1._ Require the variable `myvar`:\n\n```erlang\nok = ct:require(myvar).\n```\n\nIn this case the configuration file must at least contain:\n\n```erlang\n{myvar,Value}.\n```\n\n_Example 2._ Require key `myvar` with subkeys `sub1` and `sub2`:\n\n```erlang\nok = ct:require({myvar,[sub1,sub2]}).\n```\n\nIn this case the configuration file must at least contain:\n\n```erlang\n{myvar,[{sub1,Value},{sub2,Value}]}.\n```\n\n_Example 3._ Require key `myvar` with subkey `sub1` with `subsub1`:\n\n```erlang\nok = ct:require({myvar,sub1,sub2}).\n```\n\nIn this case the configuration file must at least contain:\n\n```erlang\n{myvar,[{sub1,[{sub2,Value}]}]}.\n```\n\nSee also [`ct:get_config/1`](`get_config/1`),\n[`ct:get_config/2`](`get_config/2`), [`ct:get_config/3`](`get_config/3`),\n[`ct:require/2`](`require/2`).","ref":"ct.html#require/1"},{"type":"function","title":"ct.require/2","doc":"Checks if the required configuration is available and gives it a name. The\nsemantics for `Required` is the same as in [`ct:require/1`](`require/1`) except\nthat a list of `SubKey`s cannot be specified.\n\nIf the requested data is available, the subentry is associated with `Name` so\nthat the value of the element can be read with\n[`ct:get_config/1,2`](`get_config/1`) provided `Name` is used instead of the\nwhole `Required` term.\n\n_Example:_\n\nRequire one node with a Telnet connection and an FTP connection. Name the node\n`a`:\n\n```erlang\nok = ct:require(a,{machine,node}).\n```\n\nAll references to this node can then use the node name. For example, a file over\nFTP is fetched like follows:\n\n```erlang\nok = ct:ftp_get(a,RemoteFile,LocalFile).\n```\n\nFor this to work, the configuration file must at least contain:\n\n```erlang\n{machine,[{node,[{telnet,IpAddr},{ftp,IpAddr}]}]}.\n```\n\n> #### Note {: .info }\n>\n> The behavior of this function changed radically in `Common Test` 1\\.6.2. To\n> keep some backwards compatibility, it is still possible to do:\n> `ct:require(a,{node,[telnet,ftp]}).` This associates the name `a` with the\n> top-level `node` entry. For this to work, the configuration file must at least\n> contain: `{node,[{telnet,IpAddr},{ftp,IpAddr}]}.`\n\nSee also [`ct:get_config/1`](`get_config/1`),\n[`ct:get_config/2`](`get_config/2`), [`ct:get_config/3`](`get_config/3`),\n[`ct:require/1`](`require/1`).","ref":"ct.html#require/2"},{"type":"function","title":"ct.run/1","doc":"Runs all test cases in all suites in the specified directories.\n\nSee also [`ct:run/3`](`run/3`).","ref":"ct.html#run/1"},{"type":"function","title":"ct.run/2","doc":"Runs all test cases in the specified suite.\n\nSee also [`ct:run/3`](`run/3`).","ref":"ct.html#run/2"},{"type":"function","title":"ct.run/3","doc":"Runs the specified test cases.\n\nRequires that [`ct:install/1`](`install/1`) has been run first.\n\nSuites (`*_SUITE.erl`) files must be stored in `TestDir` or `TestDir/test`. All\nsuites are compiled when the test is run.","ref":"ct.html#run/3"},{"type":"function","title":"ct.run_test/1","doc":"Runs tests as specified by the combination of options in `Opts`. The options are\nthe same as those used with program `ct_run`, see\n[Run Tests from Command Line](ct_run_cmd.md#ct_run) in the `ct_run` manual page.\n\nHere a `TestDir` can be used to point out the path to a `Suite`. Option\n`testcase` corresponds to option `-case` in program `ct_run`. Configuration\nfiles specified in `Opts` are installed automatically at startup.\n\n`TestRunnerPid` is returned if `release_shell == true`. For details, see\n[`ct:break/1`](`break/1`).\n\n`Reason` indicates the type of error encountered.","ref":"ct.html#run_test/1"},{"type":"function","title":"ct.run_testspec/1","doc":"Runs a test specified by `TestSpec`. The same terms are used as in test\nspecification files.\n\n`Reason` indicates the type of error encountered.","ref":"ct.html#run_testspec/1"},{"type":"function","title":"ct.set_verbosity/2","doc":"Use this function to set, or modify, the verbosity level for a logging category.\nSee the [User's Guide](write_test_chapter.md#logging) for details. Use the value\n`default` to set the general verbosity level.","ref":"ct.html#set_verbosity/2"},{"type":"function","title":"ct.sleep/1","doc":"This function, similar to `timer:sleep/1` in STDLIB, suspends the test case for\na specified time. However, this function also multiplies `Time` with the\n`multiply_timetraps` value (if set) and under certain circumstances also scales\nup the time automatically if `scale_timetraps` is set to `true` (default is\n`false`).","ref":"ct.html#sleep/1"},{"type":"function","title":"ct.start_interactive/0","doc":"Starts `Common Test` in interactive mode.\n\nFrom this mode, all test case support functions can be executed directly from\nthe Erlang shell. The interactive mode can also be started from the OS command\nline with `ct_run -shell [-config File...]`.\n\nIf any functions (for example, Telnet or FTP) using \"required configuration\ndata\" are to be called from the Erlang shell, configuration data must first be\nrequired with [`ct:require/2`](`require/2`).\n\n_Example:_\n\n```erlang\n> ct:require(unix_telnet, unix).\nok\n> ct_telnet:open(unix_telnet).\n{ok,<0.105.0>}\n> ct_telnet:cmd(unix_telnet, \"ls .\").\n{ok,[\"ls\",\"file1  ...\",...]}\n```","ref":"ct.html#start_interactive/0"},{"type":"function","title":"ct.step/3","doc":"Steps through a test case with the debugger.\n\nSee also [`ct:run/3`](`run/3`).","ref":"ct.html#step/3"},{"type":"function","title":"ct.step/4","doc":"Steps through a test case with the debugger. If option `config` has been\nspecified, breakpoints are also set on the configuration functions in `Suite`.\n\nSee also [`ct:run/3`](`run/3`).","ref":"ct.html#step/4"},{"type":"function","title":"ct.stop_interactive/0","doc":"Exits the interactive mode.\n\nSee also [`ct:start_interactive/0`](`start_interactive/0`).","ref":"ct.html#stop_interactive/0"},{"type":"function","title":"ct.sync_notify/2","doc":"Sends a synchronous notification of type `Name` with `Data` to the `Common Test`\nevent manager. This can later be caught by any installed event manager.\n\nSee also `m:gen_event`.","ref":"ct.html#sync_notify/2"},{"type":"function","title":"ct.testcases/2","doc":"Returns all test cases in the specified suite.","ref":"ct.html#testcases/2"},{"type":"function","title":"ct.timetrap/1","doc":"Sets a new timetrap for the running test case.\n\nIf the argument is `Func`, the timetrap is triggered when this function returns.\n`Func` can also return a new `Time` value, which in that case is the value for\nthe new timetrap.","ref":"ct.html#timetrap/1"},{"type":"function","title":"ct.userdata/2","doc":"Returns any data specified with tag `userdata` in the list of tuples returned\nfrom [`suite/0`](`c:ct_suite:suite/0`).","ref":"ct.html#userdata/2"},{"type":"function","title":"ct.userdata/3","doc":"Returns any data specified with tag `userdata` in the list of tuples returned\nfrom `Suite:group(GroupName)` or `Suite:Case()`.","ref":"ct.html#userdata/3"},{"type":"type","title":"ct.config_key/0","doc":"A configuration key which exists in a configuration file","ref":"ct.html#t:config_key/0"},{"type":"type","title":"ct.conn_log_mod/0","doc":"","ref":"ct.html#t:conn_log_mod/0"},{"type":"type","title":"ct.conn_log_option/0","doc":"","ref":"ct.html#t:conn_log_option/0"},{"type":"type","title":"ct.conn_log_options/0","doc":"Options that can be given to the `cth_conn_log` hook, which is used for logging\nof NETCONF and Telnet connections. See [ct_netconfc](`m:ct_netconfc#Logging`) or\n[ct_telnet](`m:ct_telnet#module-logging`) for description and examples of how to use\nthis hook.","ref":"ct.html#t:conn_log_options/0"},{"type":"type","title":"ct.conn_log_type/0","doc":"","ref":"ct.html#t:conn_log_type/0"},{"type":"type","title":"ct.handle/0","doc":"The identity (handle) of a connection.","ref":"ct.html#t:handle/0"},{"type":"type","title":"ct.key_or_name/0","doc":"","ref":"ct.html#t:key_or_name/0"},{"type":"type","title":"ct.target_name/0","doc":"A name and association to configuration data introduced through a require\nstatement, or a call to [`ct:require/2`](`require/2`), for example,\n`ct:require(mynodename,{node,[telnet]})`.","ref":"ct.html#t:target_name/0"},{"type":"module","title":"ct_cover","doc":"`Common Test` framework code coverage support module.\n\nThis module exports help functions for performing code coverage analysis.","ref":"ct_cover.html"},{"type":"function","title":"ct_cover.add_nodes/1","doc":"Adds nodes to current cover test. Notice that this only works if cover support\nis active.\n\nTo have effect, this function is to be called from `init_per_suite/1` (see\n`m:ct_suite`) before any tests are performed.","ref":"ct_cover.html#add_nodes/1"},{"type":"function","title":"ct_cover.cross_cover_analyse/2","doc":"Accumulates cover results over multiple tests. See section\n[Cross Cover Analysis](cover_chapter.md#cross_cover) in the User's Guide.","ref":"ct_cover.html#cross_cover_analyse/2"},{"type":"function","title":"ct_cover.remove_nodes/1","doc":"Removes nodes from the current cover test.\n\nCall this function to stop cover test on nodes previously added with\n[`ct_cover:add_nodes/1`](`add_nodes/1`). Results on the remote node are\ntransferred to the `Common Test` node.","ref":"ct_cover.html#remove_nodes/1"},{"type":"module","title":"ct_ftp","doc":"FTP client module (based on the `ftp` application).","ref":"ct_ftp.html"},{"type":"function","title":"ct_ftp.cd/2","doc":"Changes directory on remote host.","ref":"ct_ftp.html#cd/2"},{"type":"function","title":"ct_ftp.close/1","doc":"Closes the FTP connection.","ref":"ct_ftp.html#close/1"},{"type":"function","title":"ct_ftp.delete/2","doc":"Deletes a file on remote host.","ref":"ct_ftp.html#delete/2"},{"type":"function","title":"ct_ftp.get/3","doc":"Opens an FTP connection and fetches a file from the remote host.\n\n`RemoteFile` and `LocalFile` must be absolute paths.\n\nThe configuration file must be as for [`ct_ftp:put/3`](`put/3`).\n\nSee also `ct:require/2`.","ref":"ct_ftp.html#get/3"},{"type":"function","title":"ct_ftp.ls/2","doc":"Lists directory `Dir`.","ref":"ct_ftp.html#ls/2"},{"type":"function","title":"ct_ftp.open/1","doc":"Opens an FTP connection to the specified node.\n\nYou can open a connection for a particular `Name` and use the same name as\nreference for all following subsequent operations. If you want the connection to\nbe associated with `Handle` instead (if you, for example, need to open multiple\nconnections to a host), use `Key`, the configuration variable name, to specify\nthe target. A connection without an associated target name can only be closed\nwith the handle value.\n\nFor information on how to create a new `Name`, see `ct:require/2`.","ref":"ct_ftp.html#open/1"},{"type":"function","title":"ct_ftp.put/3","doc":"Opens an FTP connection and sends a file to the remote host.\n\n`LocalFile` and `RemoteFile` must be absolute paths.\n\nIf the target host is a \"special\" node, the FTP address must be specified in the\nconfiguration file as follows:\n\n```erlang\n{node,[{ftp,IpAddr}]}.\n```\n\nIf the target host is something else, for example, a UNIX host, the\nconfiguration file must also include the username and password (both strings):\n\n```erlang\n{unix,[{ftp,IpAddr},\n       {username,Username},\n       {password,Password}]}.\n```\n\nSee also `ct:require/2`.","ref":"ct_ftp.html#put/3"},{"type":"function","title":"ct_ftp.recv/2","doc":"Fetches a file over FTP.\n\nThe file gets the same name on the local host.\n\nSee also [`ct_ftp:recv/3`](`recv/3`).","ref":"ct_ftp.html#recv/2"},{"type":"function","title":"ct_ftp.recv/3","doc":"Fetches a file over FTP.\n\nThe file is named `LocalFile` on the local host.","ref":"ct_ftp.html#recv/3"},{"type":"function","title":"ct_ftp.send/2","doc":"Sends a file over FTP.\n\nThe file gets the same name on the remote host.\n\nSee also [`ct_ftp:send/3`](`send/3`).","ref":"ct_ftp.html#send/2"},{"type":"function","title":"ct_ftp.send/3","doc":"Sends a file over FTP.\n\nThe file is named `RemoteFile` on the remote host.","ref":"ct_ftp.html#send/3"},{"type":"function","title":"ct_ftp.type/2","doc":"Changes the file transfer type.","ref":"ct_ftp.html#type/2"},{"type":"type","title":"ct_ftp.connection/0","doc":"Reference to opened FTP connection associated to either a `handle` or `target_name`.","ref":"ct_ftp.html#t:connection/0"},{"type":"type","title":"ct_ftp.handle/0","doc":"Handle for a specific FTP connection, see module `m:ct`.","ref":"ct_ftp.html#t:handle/0"},{"type":"behaviour","title":"ct_hooks","doc":"A callback interface on top of Common Test.\n\nThe _Common Test Hook (CTH)_ framework allows extensions of the default behavior\nof `Common Test` by callbacks before and after all test suite calls. It is\nintended for advanced users of `Common Test` who want to abstract out behavior\nthat is common to multiple test suites.\n\nIn brief, CTH allows you to:\n\n- Manipulate the runtime configuration before each suite configuration call.\n- Manipulate the return of all suite configuration calls and by extension the\n  result of the test themselves.\n\nThe following sections describe the mandatory and optional CTH functions that\n`Common Test` calls during test execution. For more details, see section\n[Common Test Hooks](ct_hooks_chapter.md) in the User's Guide.\n\nFor information about how to add a CTH to your suite, see section\n[Installing a CTH](ct_hooks_chapter.md#installing) in the User's Guide.\n\n> #### Note {: .info }\n>\n> For a minimal example of a CTH, see section\n> [Example CTH](ct_hooks_chapter.md#example) in the User's Guide.","ref":"ct_hooks.html"},{"type":"callback","title":"ct_hooks.id/1","doc":"The `Id` identifies a CTH instance uniquely. If two CTHs return the same `Id`,\nthe second CTH is ignored and subsequent calls to the CTH are only made to the\nfirst instance. For details, see section\n[Installing a CTH](ct_hooks_chapter.md#installing) in the User's Guide.\n\nThis function is _not_ to have any side effects, as it can be called multiple\ntimes by `Common Test`.\n\nIf not implemented, the CTH acts as if this function returned a call to\n`make_ref/0`.","ref":"ct_hooks.html#c:id/1"},{"type":"callback","title":"ct_hooks.init/2","doc":"This function is always called before any other callback function. Use it to\ninitiate any common state. It is to return a state for this CTH.\n\n`Id` is either the return value of [`ct_hooks:id/1`](`c:id/1`), or a `reference`\n(created using `erlang:make_ref/0` in ERTS) if [`ct_hooks:id/1`](`c:id/1`) is\nnot implemented.\n\n`Priority` is the relative priority of this hook. Hooks with a lower priority\nare executed first. If no priority is specified, it is set to `0`.\n\nFor details about hook execution order, see section\n[CTH Execution Order](ct_hooks_chapter.md#cth_execution_order) in the User's\nGuide.\n\nFor details about when `init` is called, see section\n[CTH Scope](ct_hooks_chapter.md#scope) in the User's Guide.","ref":"ct_hooks.html#c:init/2"},{"type":"callback","title":"ct_hooks.on_tc_fail/4","doc":"This function is called whenever a test case (or configuration function) fails.\nIt is called after the post function is called for the failed test case.\n\nThat is:\n\n- If `init_per_suite` fails, this function is called after\n  [`post_init_per_suite`](`c:post_init_per_suite/4`).\n- If a test case fails, this function is called after\n  [`post_end_per_testcase`](`c:post_end_per_testcase/5`).\n\nIf the failed test case belongs to a test case group, the second argument is a\ntuple `{FuncName,GroupName}`, otherwise only the function name.\n\nThe data that comes with `Reason` follows the same format as\n[`FailReason`](event_handler_chapter.md#failreason) in event\n[`tc_done`](event_handler_chapter.md#tc_done). For details, see section\n[Event Handling](event_handler_chapter.md#events) in the User's Guide.\n\nIf [`Module:on_tc_fail/4`](`c:on_tc_fail/4`) is not exported, common_test will\nattempt to call `Module:on_tc_fail(TestName, Reason, CTHState)` instead. This is\nfor backwards compatibility.","ref":"ct_hooks.html#c:on_tc_fail/4"},{"type":"callback","title":"ct_hooks.on_tc_skip/4","doc":"This function is called whenever a test case (or configuration function) is\nskipped. It is called after the post function is called for the skipped test\ncase.\n\nThat is:\n\n- If `init_per_group` is skipped, this function is called after\n  [`post_init_per_group`](`c:post_init_per_group/5`).\n- If a test case is skipped, this function is called after\n  [`post_end_per_testcase`](`c:post_end_per_testcase/5`).\n\nIf the skipped test case belongs to a test case group, the second argument is a\ntuple `{FuncName,GroupName}`, otherwise only the function name.\n\nThe data that comes with `Reason` follows the same format as events\n[`tc_auto_skip`](event_handler_chapter.md#tc_auto_skip) and\n[`tc_user_skip`](event_handler_chapter.md#tc_user_skip) For details, see section\n[Event Handling](event_handler_chapter.md#events) in the User's Guide.\n\nIf [`Module:on_tc_skip/4`](`c:on_tc_skip/4`) is not exported, common_test will\nattempt to call `Module:on_tc_skip(TestName, Reason, CTHState)` instead. This is\nfor backwards compatibility.","ref":"ct_hooks.html#c:on_tc_skip/4"},{"type":"callback","title":"ct_hooks.post_all/3","doc":"This function is called after [`all/0`](`c:ct_suite:all/0`). It is used to\nmodify the set of test cases and test group to be executed, for instance to add\nor remove test cases and groups, change group properties, or even skip all tests\nin the suite.\n\n`Return` is what [`all/0`](`c:ct_suite:all/0`) returned, that is, a list of test\ncases and groups to be executed, or a tuple `{skip,Reason}`.\n\n`GroupDefs` is what [`groups/0`](`c:ct_suite:groups/0`) or the\n[`post_groups/2`](`c:post_groups/2`) hook returned, that is, a list of group\ndefinitions.\n\n`NewReturn` is the possibly modified version of `Return`.\n\nThis function is called only if the CTH is added before `init_per_suite` is run.\nFor details, see section [CTH Scope](ct_hooks_chapter.md#scope) in the User's\nGuide.\n\nNotice that for CTHs that are installed by means of the\n[`suite/0`](`c:ct_suite:suite/0`) function, `post_all/2` is called before the\n`c:init/2` hook function. However, for CTHs that are installed by means of the\nCT start flag, the `c:init/2` function is called first.\n\n> #### Note {: .info }\n>\n> Prior to each test execution, Common Test does a simulated test run in order\n> to count test suites, groups and cases for logging purposes. This causes the\n> [`post_all/3`](`c:post_all/3`) hook function to always be called twice. For\n> this reason, side effects are best avoided in this callback.","ref":"ct_hooks.html#c:post_all/3"},{"type":"callback","title":"ct_hooks.post_end_per_group/5","doc":"This function is called after [`end_per_group`](`c:ct_suite:end_per_group/2`) if\nit exists. It behaves the same way as\n[`post_init_per_suite`](`c:post_init_per_suite/4`), but for function\n[end_per_group](`c:ct_suite:end_per_group/2`) instead.\n\nIf [`Module:post_end_per_group/5`](`c:post_end_per_group/5`) is not exported,\ncommon_test will attempt to call\n`Module:post_end_per_group(GroupName, Config, Return, CTHState)` instead. This\nis for backwards compatibility.","ref":"ct_hooks.html#c:post_end_per_group/5"},{"type":"callback","title":"ct_hooks.post_end_per_suite/4","doc":"This function is called after [`end_per_suite`](`c:ct_suite:end_per_suite/1`) if\nit exists. It behaves the same way as\n[`post_init_per_suite`](`c:post_init_per_suite/4`), but for function\n[`end_per_suite`](`c:ct_suite:end_per_suite/1`) instead.","ref":"ct_hooks.html#c:post_end_per_suite/4"},{"type":"callback","title":"ct_hooks.post_end_per_testcase/5","doc":"This function is called after\n[`end_per_testcase`](`c:ct_suite:end_per_testcase/2`) if it exists. It behaves\nthe same way as [`post_end_per_suite`](`c:post_end_per_suite/4`), but for\nfunction [`end_per_testcase`](`c:ct_suite:end_per_testcase/2`) instead.\n\nIf [`Module:post_end_per_testcase/5`](`c:post_end_per_testcase/5`) is not\nexported, common_test will attempt to call\n`Module:post_end_per_testcase(TestcaseName, Config, Return, CTHState)` instead.\nThis is for backwards compatibility.","ref":"ct_hooks.html#c:post_end_per_testcase/5"},{"type":"callback","title":"ct_hooks.post_groups/2","doc":"This function is called after [`groups/0`](`c:ct_suite:groups/0`). It is used to\nmodify the test group definitions, for instance to add or remove groups or\nchange group properties.\n\n`GroupDefs` is what [`groups/0`](`c:ct_suite:groups/0`) returned, that is, a\nlist of group definitions.\n\n`NewGroupDefs` is the possibly modified version of this list.\n\nThis function is called only if the CTH is added before `init_per_suite` is run.\nFor details, see section [CTH Scope](ct_hooks_chapter.md#scope) in the User's\nGuide.\n\nNotice that for CTHs that are installed by means of the\n[`suite/0`](`c:ct_suite:suite/0`) function, [`post_groups/2`](`c:post_groups/2`)\nis called before the `c:init/2` hook function. However, for CTHs that are\ninstalled by means of the CT start flag, the `c:init/2` function is called\nfirst.\n\n> #### Note {: .info }\n>\n> Prior to each test execution, Common Test does a simulated test run in order\n> to count test suites, groups and cases for logging purposes. This causes the\n> [`post_groups/2`](`c:post_groups/2`) hook function to always be called twice.\n> For this reason, side effects are best avoided in this callback.","ref":"ct_hooks.html#c:post_groups/2"},{"type":"callback","title":"ct_hooks.post_init_per_group/5","doc":"This function is called after [`init_per_group`](`c:ct_suite:init_per_group/2`)\nif it exists. It behaves the same way as\n[`post_init_per_suite`](`c:post_init_per_suite/4`), but for function\n[`init_per_group`](`c:ct_suite:init_per_group/2`) instead.\n\nIf [`Module:post_init_per_group/5`](`c:post_init_per_group/5`) is not exported,\ncommon_test will attempt to call\n`Module:post_init_per_group(GroupName, Config, Return, CTHState)` instead. This\nis for backwards compatibility.","ref":"ct_hooks.html#c:post_init_per_group/5"},{"type":"callback","title":"ct_hooks.post_init_per_suite/4","doc":"This function is called after [`init_per_suite`](`c:ct_suite:init_per_suite/1`)\nif it exists. It typically contains extra checks to ensure that all the correct\ndependencies are started correctly.\n\n`Return` is what [`init_per_suite`](`c:ct_suite:init_per_suite/1`) returned,\nthat is, `{fail,Reason}`, `{skip,Reason}`, a `Config` list, or a term describing\nhow [`init_per_suite`](`c:ct_suite:init_per_suite/1`) failed.\n\n`NewReturn` is the possibly modified return value of\n[`init_per_suite`](`c:ct_suite:init_per_suite/1`). To recover from a failure in\n[`init_per_suite`](`c:ct_suite:init_per_suite/1`), return `ConfigList` with the\n`tc_status` element removed. For more details, see\n[Post Hooks](ct_hooks_chapter.md#post) in section \"Manipulating Tests\" in the\nUser's Guide.\n\n`CTHState` is the current internal state of the CTH.\n\nThis function is called only if the CTH is added before or in `init_per_suite`.\nFor details, see section [CTH Scope](ct_hooks_chapter.md#scope) in the User's\nGuide.","ref":"ct_hooks.html#c:post_init_per_suite/4"},{"type":"callback","title":"ct_hooks.post_init_per_testcase/5","doc":"This function is called after\n[`init_per_testcase`](`c:ct_suite:init_per_testcase/2`) if it exists. It behaves\nthe same way as [`post_init_per_suite`](`c:post_init_per_suite/4`), but for\nfunction [`init_per_testcase`](`c:ct_suite:init_per_testcase/2`) instead.\n\nIf [`Module:post_init_per_testcase/5`](`c:post_init_per_testcase/5`) is not\nexported, common_test will attempt to call\n`Module:post_init_per_testcase(TestcaseName, Config, Return, CTHState)` instead.\nThis is for backwards compatibility.","ref":"ct_hooks.html#c:post_init_per_testcase/5"},{"type":"callback","title":"ct_hooks.pre_end_per_group/4","doc":"This function is called before [`end_per_group`](`c:ct_suite:end_per_group/2`)\nif it exists. It behaves the same way as\n[`pre_init_per_suite`](`c:pre_init_per_suite/3`), but for function\n[`end_per_group`](`c:ct_suite:end_per_group/2`) instead.\n\nIf [`Module:pre_end_per_group/4`](`c:pre_end_per_group/4`) is not exported,\ncommon_test will attempt to call\n`Module:pre_end_per_group(GroupName, EndData, CTHState)` instead. This is for\nbackwards compatibility.","ref":"ct_hooks.html#c:pre_end_per_group/4"},{"type":"callback","title":"ct_hooks.pre_end_per_suite/3","doc":"This function is called before [`end_per_suite`](`c:ct_suite:end_per_suite/1`)\nif it exists. It behaves the same way as\n[`pre_init_per_suite`](`c:pre_init_per_suite/3`), but for function\n[`end_per_suite`](`c:ct_suite:end_per_suite/1`) instead.","ref":"ct_hooks.html#c:pre_end_per_suite/3"},{"type":"callback","title":"ct_hooks.pre_end_per_testcase/4","doc":"This function is called before\n[`end_per_testcase`](`c:ct_suite:end_per_testcase/2`) if it exists. It behaves\nthe same way as [`pre_end_per_suite`](`c:pre_end_per_suite/3`), but for function\n[`end_per_testcase`](`c:ct_suite:end_per_testcase/2`) instead.\n\nThis function cannot change the result of the test case by returning skip or\nfail tuples, but it may insert items in `Config` that can be read in\n`end_per_testcase/2` or in\n[`post_end_per_testcase/5`](`c:post_end_per_testcase/5`).\n\nIf [`Module:pre_end_per_testcase/4`](`c:pre_end_per_testcase/4`) is not\nexported, common_test will attempt to call\n`Module:pre_end_per_testcase(TestcaseName, EndData, CTHState)` instead. This is\nfor backwards compatibility.","ref":"ct_hooks.html#c:pre_end_per_testcase/4"},{"type":"callback","title":"ct_hooks.pre_init_per_group/4","doc":"This function is called before [`init_per_group`](`c:ct_suite:init_per_group/2`)\nif it exists. It behaves the same way as\n[`pre_init_per_suite`](`c:pre_init_per_suite/3`), but for function\n[`init_per_group`](`c:ct_suite:init_per_group/2`) instead.\n\nIf [`Module:pre_init_per_group/4`](`c:pre_init_per_group/4`) is not exported,\ncommon_test will attempt to call\n`Module:pre_init_per_group(GroupName, InitData, CTHState)` instead. This is for\nbackwards compatibility.","ref":"ct_hooks.html#c:pre_init_per_group/4"},{"type":"callback","title":"ct_hooks.pre_init_per_suite/3","doc":"This function is called before [`init_per_suite`](`c:ct_suite:init_per_suite/1`)\nif it exists. It typically contains initialization/logging that must be done\nbefore `init_per_suite` is called. If `{skip,Reason}` or `{fail,Reason}` is\nreturned, `init_per_suite` and all test cases of the suite are skipped and\n`Reason` printed in the overview log of the suite.\n\n`SuiteName` is the name of the suite to be run.\n\n`InitData` is the original configuration list of the test suite, or a\n`SkipOrFail` tuple if a previous CTH has returned this.\n\n`CTHState` is the current internal state of the CTH.\n\n`Return` is the result of the `init_per_suite` function. If it is\n`{skip,Reason}` or `{fail,Reason}`,\n[`init_per_suite`](`c:ct_suite:init_per_suite/1`) is never called, instead the\ninitiation is considered to be skipped or failed, respectively. If a `NewConfig`\nlist is returned, [`init_per_suite`](`c:ct_suite:init_per_suite/1`) is called\nwith that `NewConfig` list. For more details, see section\n[Pre Hooks](ct_hooks_chapter.md#pre) in the User's Guide.\n\nThis function is called only if the CTH is added before `init_per_suite is run`.\nFor details, see section [CTH Scope](ct_hooks_chapter.md#scope) in the User's\nGuide.","ref":"ct_hooks.html#c:pre_init_per_suite/3"},{"type":"callback","title":"ct_hooks.pre_init_per_testcase/4","doc":"This function is called before\n[`init_per_testcase`](`c:ct_suite:init_per_testcase/2`) if it exists. It behaves\nthe same way as [`pre_init_per_suite`](`c:pre_init_per_suite/3`), but for\nfunction [`init_per_testcase`](`c:ct_suite:init_per_testcase/2`) instead.\n\nIf [`Module:pre_init_per_testcase/4`](`c:pre_init_per_testcase/4`) is not\nexported, common_test will attempt to call\n`Module:pre_init_per_testcase(TestcaseName, InitData, CTHState)` instead. This\nis for backwards compatibility.\n\nCTHs cannot be added here right now. That feature may be added in a later\nrelease, but it would right now break backwards compatibility.","ref":"ct_hooks.html#c:pre_init_per_testcase/4"},{"type":"callback","title":"ct_hooks.terminate/1","doc":"This function is called at the end of a CTH [scope](ct_hooks_chapter.md#scope).\nThe returned term is ignored.","ref":"ct_hooks.html#c:terminate/1"},{"type":"module","title":"ct_master","doc":"Distributed test execution control for `Common Test`.\n\nThis module exports functions for running `Common Test` nodes on multiple hosts\nin parallel.","ref":"ct_master.html"},{"type":"function","title":"ct_master.abort/0","doc":"Stops all running tests.","ref":"ct_master.html#abort/0"},{"type":"function","title":"ct_master.abort/1","doc":"Stops tests on specified nodes.","ref":"ct_master.html#abort/1"},{"type":"function","title":"ct_master.basic_html/1","doc":"If set to `true`, the `ct_master logs` are written on a primitive HTML format,\nnot using the `Common Test` CSS style sheet.","ref":"ct_master.html#basic_html/1"},{"type":"function","title":"ct_master.get_event_mgr_ref/0","doc":"Gets a reference to the `Common Test` master event manager. The reference can be\nused to, for example, add a user-specific event handler while tests are running.\n\n_Example:_\n\n```erlang\ngen_event:add_handler(ct_master:get_event_mgr_ref(), my_ev_h, [])\n```","ref":"ct_master.html#get_event_mgr_ref/0"},{"type":"function","title":"ct_master.progress/0","doc":"Returns test progress. If `Status` is `ongoing`, tests are running on the node\nand are not yet finished.","ref":"ct_master.html#progress/0"},{"type":"function","title":"ct_master.run/1","doc":"Run tests on spawned nodes as specified in `TestSpecs` (see `run/4`).\n\nEquivalent to [`run(TestSpecs, false, [], [])`](`run/4`) if\ncalled with TestSpecs being list of strings;\n\nEquivalent to [`run([TS], false, [], [])`](`run/4`) if\ncalled with TS being string.","ref":"ct_master.html#run/1"},{"type":"function","title":"ct_master.run/3","doc":"","ref":"ct_master.html#run/3"},{"type":"function","title":"ct_master.run/4","doc":"Tests are spawned on the nodes as specified in `TestSpecs`. Each specification\nin `TestSpec` is handled separately. However, it is also possible to specify a\nlist of specifications to be merged into one specification before the tests are\nexecuted. Any test without a particular node specification is also executed on\nthe nodes in `InclNodes`. Nodes in the `ExclNodes` list are excluded from the\ntest.","ref":"ct_master.html#run/4"},{"type":"function","title":"ct_master.run_on_node/2","doc":"","ref":"ct_master.html#run_on_node/2"},{"type":"function","title":"ct_master.run_on_node/3","doc":"Tests are spawned on `Node` according to `TestSpecs`.","ref":"ct_master.html#run_on_node/3"},{"type":"function","title":"ct_master.run_test/2","doc":"Tests are spawned on `Node` using `ct:run_test/1`","ref":"ct_master.html#run_test/2"},{"type":"type","title":"ct_master.test_spec/0","doc":"Filename of test spec to be executed.","ref":"ct_master.html#t:test_spec/0"},{"type":"module","title":"ct_netconfc","doc":"NETCONF client module.\n\nNETCONF client module compliant with RFC 6241, NETCONF Configuration Protocol,\nand RFC 6242, Using the NETCONF Configuration Protocol over Secure SHell (SSH),\nand with support for RFC 5277, NETCONF Event Notifications.\n\n[](){: #Connecting }\n\n_Connecting to a NETCONF server_\n\nCall [`connect/1,2`](`connect/1`) to establish a connection to a server, then\npass the returned handle to [`session/1-3`](`session/1`) to establish a NETCONF\nsession on a new SSH channel. Each call to [`session/1-3`](`session/1`)\nestablishes a new session on the same connection, and results in a hello message\nto the server.\n\nAlternately, [`open/1,2`](`open/1`) can be used to establish a single session on\na dedicated connection. (Or, equivalently, [`only_open/1,2`](`only_open/1`)\nfollowed by [`hello/1-3`](`hello/1`).)\n\nConnect/session options can be specified in a configuration file with entries\nlike the following.\n\n```erlang\n{server_id(), [option()]}.\n```\n\nThe `t:server_id/0` or an associated `t:ct:target_name/0` can then be passed to\nthe aforementioned functions to use the referenced configuration.\n\n[](){: #Signaling }\n\n_Signaling_\n\nProtocol operations in the NETCONF protocol are realized as remote procedure\ncalls (RPCs) from client to server and a corresponding reply from server to\nclient. RPCs are sent using like-named functions (eg.\n[`edit_config/3-5`](`edit_config/3`) to send an edit-config RPC), with the\nserver reply as return value. There are functions for each RPC defined in RFC\n6241 and the create-subscription RPC from RFC 5277, all of which are wrappers on\n[`send_rpc/2,3`](`send_rpc/2`), that can be used to send an arbitrary RPC not\ndefined in RFC 6241 or RFC 5277.\n\nAll of the signaling functions have one variant with a `Timeout` argument and\none without, corresponding to an infinite timeout. The latter is inappropriate\nin most cases since a non-response by the server or a missing message-id causes\nthe call to hang indefinitely.\n\n[](){: #Logging }\n\n_Logging_\n\nThe NETCONF server uses `error_logger` for logging of NETCONF traffic. A special\npurpose error handler is implemented in `ct_conn_log_h`. To use this error\nhandler, add the `cth_conn_log` hook in the test suite, for example:\n\n```erlang\nsuite() ->\n    [{ct_hooks, [{cth_conn_log, [{ct:conn_log_mod(), ct:conn_log_options()}]}]}].\n```\n\n`conn_log_mod()` is the name of the `Common Test` module implementing the\nconnection protocol, for example, `ct_netconfc`.\n\nHook option `log_type` specifies the type of logging:\n\n- **`raw`** - The sent and received NETCONF data is logged to a separate text\n  file \"as is\" without any formatting. A link to the file is added to the test\n  case HTML log.\n\n- **`pretty`** - The sent and received NETCONF data is logged to a separate text\n  file with XML data nicely indented. A link to the file is added to the test\n  case HTML log.\n\n- **`html (default)`** - The sent and received NETCONF traffic is pretty printed\n  directly in the test case HTML log.\n\n- **`silent`** - NETCONF traffic is not logged.\n\nBy default, all NETCONF traffic is logged in one single log file. However,\ndifferent connections can be logged in separate files. To do this, use hook\noption `hosts` and list the names of the servers/connections to be used in the\nsuite. The connections must be named for this to work, that is, they must be\nopened with `open/2`.\n\nOption `hosts` has no effect if `log_type` is set to `html` or `silent`.\n\nThe hook options can also be specified in a configuration file with\nconfiguration variable `ct_conn_log`:\n\n```erlang\n{ct_conn_log,[{ct:conn_log_mod(), ct:conn_log_options()}]}.\n```\n\nFor example:\n\n```erlang\n{ct_conn_log,[{ct_netconfc,[{log_type,pretty},\n                            {hosts,[ct:key_or_name()]}]}]}\n```\n\n> #### Note {: .info }\n>\n> Hook options specified in a configuration file overwrite the hard-coded hook\n> options in the test suite.\n\n_Logging Example 1:_\n\n[](){: #Logging_example_1 }\n\nThe following `ct_hooks` statement causes pretty printing of NETCONF traffic to\nseparate logs for the connections named `nc_server1` and `nc_server2`. Any other\nconnections are logged to default NETCONF log.\n\n```erlang\nsuite() ->\n   [{ct_hooks, [{cth_conn_log, [{ct_netconfc,[{log_type,pretty}},\n                                              {hosts,[nc_server1,nc_server2]}]}\n                               ]}]}].\n```\n\nConnections must be opened as follows:\n\n```erlang\nopen(nc_server1,[...]),\nopen(nc_server2,[...]).\n```\n\n_Logging Example 2:_\n\n[](){: #Logging_example_2 }\n\nThe following configuration file causes raw logging of all NETCONF traffic in to\none single text file:\n\n```erlang\n{ct_conn_log,[{ct_netconfc,[{log_type,raw}]}]}.\n```\n\nThe `ct_hooks` statement must look as follows:\n\n```erlang\nsuite() ->\n    [{ct_hooks, [{cth_conn_log, []}]}].\n```\n\nThe same `ct_hooks` statement without the configuration file would cause HTML\nlogging of all NETCONF connections in to the test case HTML log.","ref":"ct_netconfc.html"},{"type":"function","title":"ct_netconfc.action/2","doc":"","ref":"ct_netconfc.html#action/2"},{"type":"function","title":"ct_netconfc.action/3","doc":"Executes an action. If the return type is void, `ok` is returned instead of\n`{ok,[simple_xml()]}`.","ref":"ct_netconfc.html#action/3"},{"type":"function","title":"ct_netconfc.close_session/1","doc":"","ref":"ct_netconfc.html#close_session/1"},{"type":"function","title":"ct_netconfc.close_session/2","doc":"Requests graceful termination of the session associated with the client.\n\nWhen a NETCONF server receives a `close-session` request, it gracefully closes\nthe session. The server releases any locks and resources associated with the\nsession and gracefully closes any associated connections. Any NETCONF requests\nreceived after a `close-session` request are ignored.","ref":"ct_netconfc.html#close_session/2"},{"type":"function","title":"ct_netconfc.connect/1","doc":"Opens an SSH connection to a NETCONF server.\n\nIf the server options are specified in a configuration file, use `connect/2`\ninstead.\n\nThe opaque `t:handle/0` reference returned from this function is required as\nconnection identifier when opening sessions over this connection, see\n[`session/1-3`](`session/1`).","ref":"ct_netconfc.html#connect/1"},{"type":"function","title":"ct_netconfc.connect/2","doc":"Open an SSH connection to a named NETCONF server.\n\nIf `KeyOrName` is a configured `t:server_id/0` or a `target_name()` associated\nwith such an Id, then the options for this server are fetched from the\nconfiguration file.\n\nThe options list is added to those of the configuration file. If an option is\nspecified in both lists, the configuration file takes precedence.\n\nIf the server is not specified in a configuration file, use `connect/1` instead.\n\nThe opaque `t:handle/0` reference returned from this function can be used as\nconnection identifier when opening sessions over this connection, see\n[`session/1-3`](`session/1`). However, if `KeyOrName` is a `target_name()`, that\nis, if the server is named through a call to `ct:require/2` or a `require`\nstatement in the test suite, then this name can be used instead of `t:handle/0`.","ref":"ct_netconfc.html#connect/2"},{"type":"function","title":"ct_netconfc.copy_config/3","doc":"","ref":"ct_netconfc.html#copy_config/3"},{"type":"function","title":"ct_netconfc.copy_config/4","doc":"Copies configuration data.\n\nWhich source and target options that can be issued depends on the capabilities\nsupported by the server. That is, `:candidate` and/or `:startup` are required.","ref":"ct_netconfc.html#copy_config/4"},{"type":"function","title":"ct_netconfc.create_subscription/2","doc":"","ref":"ct_netconfc.html#create_subscription/2"},{"type":"function","title":"ct_netconfc.create_subscription/3","doc":"Creates a subscription for event notifications by sending an RFC 5277\ncreate-subscription RPC to the server. The calling process receives events as\nmessages of type `t:notification/0`.\n\nFrom RFC 5722, 2.1 Subscribing to Receive Event Notifications:\n\n- **`Stream`** - Indicates which stream of event is of interest. If not present,\n  events in the default NETCONF stream are sent.\n\n- **`Filter`** - Indicates which subset of all possible events is of interest.\n  The parameter format is the same as that of the filter parameter in the\n  NETCONF protocol operations. If not present, all events not precluded by other\n  parameters are sent.\n\n- **`StartTime`** - Used to trigger the replay feature and indicate that the\n  replay is to start at the time specified. If `StartTime` is not present, this\n  is not a replay subscription. It is not valid to specify start times that are\n  later than the current time. If `StartTime` is specified earlier than the log\n  can support, the replay begins with the earliest available notification. This\n  parameter is of type `dateTime` and compliant to RFC 3339. Implementations\n  must support time zones.\n\n- **`StopTime`** - Used with the optional replay feature to indicate the newest\n  notifications of interest. If `StopTime` is not present, the notifications\n  continues until the subscription is terminated. Must be used with and be later\n  than `StartTime`. Values of `StopTime` in the future are valid. This parameter\n  is of type `dateTime` and compliant to RFC 3339. Implementations must support\n  time zones.\n\nSee RFC 5277 for more details. The requirement that `StopTime` must only be used\nwith `StartTime` is not enforced, to allow an invalid request to be sent to the\nserver.\n\nPrior to OTP 22.1, this function was documented as having 15 variants in 6\narities. These are still exported for backwards compatibility, but no longer\ndocumented. The map-based variants documented above provide the same\nfunctionality with simpler arguments.\n\n> #### Note {: .info }\n>\n> create-subscription is no longer the only RPC with which NETCONF notifications\n> can be ordered: RFC 8639 adds establish-subscription and future RFCs may add\n> other methods. Specify a `receiver` option at session creation to provide a\n> destination for incoming notifications independently of a call to\n> [`create_subscription/2,3`](`create_subscription/2`), and use\n> [`send_rpc/2,3`](`send_rpc/2`) to send establish-subscription and other\n> arbitrary RPCs.","ref":"ct_netconfc.html#create_subscription/3"},{"type":"function","title":"ct_netconfc.delete_config/2","doc":"","ref":"ct_netconfc.html#delete_config/2"},{"type":"function","title":"ct_netconfc.delete_config/3","doc":"Deletes configuration data.\n\nThe running configuration cannot be deleted and `:candidate` or `:startup` must\nbe advertised by the server.","ref":"ct_netconfc.html#delete_config/3"},{"type":"function","title":"ct_netconfc.disconnect/1","doc":"Closes the given SSH connection.\n\nIf there are open NETCONF sessions on the connection, these will be brutally\naborted. To avoid this, close each session with\n[`close_session/1,2`](`close_session/1`)","ref":"ct_netconfc.html#disconnect/1"},{"type":"function","title":"ct_netconfc.edit_config/3","doc":"","ref":"ct_netconfc.html#edit_config/3"},{"type":"function","title":"ct_netconfc.edit_config/4","doc":"","ref":"ct_netconfc.html#edit_config/4"},{"type":"function","title":"ct_netconfc.edit_config/5","doc":"Edits configuration data.\n\nBy default only the running target is available, unless the server includes\n`:candidate` or `:startup` in its list of capabilities.\n\n`OptParams` can be used for specifying optional parameters (`default-operation`,\n`test-option`, or `error-option`) to be added to the `edit-config` request. The\nvalue must be a list containing valid simple XML, for example:\n\n```erlang\n[{'default-operation', [\"none\"]},\n {'error-option', [\"rollback-on-error\"]}]\n```\n\nIf `OptParams` is not given, the default value `[]` is used.","ref":"ct_netconfc.html#edit_config/5"},{"type":"function","title":"ct_netconfc.get/2","doc":"","ref":"ct_netconfc.html#get/2"},{"type":"function","title":"ct_netconfc.get/3","doc":"Gets data.\n\nThis operation returns both configuration and state data from the server.\n\nFilter type `xpath` can be used only if the server supports `:xpath`.","ref":"ct_netconfc.html#get/3"},{"type":"function","title":"ct_netconfc.get_capabilities/1","doc":"","ref":"ct_netconfc.html#get_capabilities/1"},{"type":"function","title":"ct_netconfc.get_capabilities/2","doc":"Returns the server capabilities as received in its hello message.","ref":"ct_netconfc.html#get_capabilities/2"},{"type":"function","title":"ct_netconfc.get_config/3","doc":"","ref":"ct_netconfc.html#get_config/3"},{"type":"function","title":"ct_netconfc.get_config/4","doc":"Gets configuration data.\n\nTo be able to access another source than `running`, the server must advertise\n`:candidate` and/or `:startup`.\n\nFilter type `xpath` can be used only if the server supports `:xpath`.","ref":"ct_netconfc.html#get_config/4"},{"type":"function","title":"ct_netconfc.get_event_streams/1","doc":"","ref":"ct_netconfc.html#get_event_streams/1"},{"type":"function","title":"ct_netconfc.get_event_streams/2","doc":"","ref":"ct_netconfc.html#get_event_streams/2"},{"type":"function","title":"ct_netconfc.get_event_streams/3","doc":"Sends a request to get the specified event streams.\n\n`Streams` is a list of stream names. The following filter is sent to the NETCONF\nserver in a `get` request:\n\n```text\n \n   \n     \n       StreamName1 \n     \n     \n       StreamName2 \n     \n    ...\n   \n \n```\n\nIf `Streams` is an empty list, _all_ streams are requested by sending the\nfollowing filter:\n\n```text\n \n   \n \n```\n\nIf more complex filtering is needed, use [`ct_netconfc:get/2,3`](`get/2`) and\nspecify the exact filter according to \"XML Schema for Event Notifications\" in\nRFC 5277.","ref":"ct_netconfc.html#get_event_streams/3"},{"type":"function","title":"ct_netconfc.get_session_id/1","doc":"","ref":"ct_netconfc.html#get_session_id/1"},{"type":"function","title":"ct_netconfc.get_session_id/2","doc":"Returns the session Id associated with the specified client.","ref":"ct_netconfc.html#get_session_id/2"},{"type":"function","title":"ct_netconfc.hello/1","doc":"","ref":"ct_netconfc.html#hello/1"},{"type":"function","title":"ct_netconfc.hello/2","doc":"","ref":"ct_netconfc.html#hello/2"},{"type":"function","title":"ct_netconfc.hello/3","doc":"Exchanges `hello` messages with the server. Returns when the server hello has\nbeen received or after the specified timeout.\n\nNote that capabilities for an outgoing hello can be passed directly to `open/2`.","ref":"ct_netconfc.html#hello/3"},{"type":"function","title":"ct_netconfc.kill_session/2","doc":"","ref":"ct_netconfc.html#kill_session/2"},{"type":"function","title":"ct_netconfc.kill_session/3","doc":"Forces termination of the session associated with the supplied session Id.\n\nThe server side must abort any ongoing operations, release any locks and\nresources associated with the session, and close any associated connections.\n\nOnly if the server is in the confirmed commit phase, the configuration is\nrestored to its state before entering the confirmed commit phase. Otherwise, no\nconfiguration rollback is performed.\n\nIf the specified `SessionId` is equal to the current session Id, an error is\nreturned.","ref":"ct_netconfc.html#kill_session/3"},{"type":"function","title":"ct_netconfc.lock/2","doc":"","ref":"ct_netconfc.html#lock/2"},{"type":"function","title":"ct_netconfc.lock/3","doc":"Locks the configuration target.\n\nWhich target parameters that can be used depends on if `:candidate` and/or\n`:startup` are supported by the server. If successful, the configuration system\nof the device is unavailable to other clients (NETCONF, CORBA, SNMP, and so on).\nLocks are intended to be short-lived.\n\nOperation [`kill_session/2,3`](`kill_session/2`) can be used to force the\nrelease of a lock owned by another NETCONF session. How this is achieved by the\nserver side is implementation-specific.","ref":"ct_netconfc.html#lock/3"},{"type":"function","title":"ct_netconfc.only_open/1","doc":"Opens a NETCONF session, but does not send `hello`.\n\nAs `open/1`, but does not send a `hello` message.","ref":"ct_netconfc.html#only_open/1"},{"type":"function","title":"ct_netconfc.only_open/2","doc":"Opens a named NETCONF session, but does not send `hello`.\n\nAs `open/2`, but does not send a `hello` message.","ref":"ct_netconfc.html#only_open/2"},{"type":"function","title":"ct_netconfc.open/1","doc":"Opens a NETCONF session and exchanges `hello` messages.\n\nIf the server options are specified in a configuration file, or if a named\nclient is needed for logging purposes (see section\n[Logging](`m:ct_netconfc#Logging`) in this module), use `open/2` instead.\n\nThe opaque `t:handle/0` reference returned from this function is required as\nclient identifier when calling any other function in this module.","ref":"ct_netconfc.html#open/1"},{"type":"function","title":"ct_netconfc.open/2","doc":"Opens a named NETCONF session and exchanges `hello` messages.\n\nIf `KeyOrName` is a configured `t:server_id/0` or a `target_name()` associated\nwith such an Id, then the options for this server are fetched from the\nconfiguration file.\n\nThe options list is added to those of the configuration file. If an option is\nspecified in both lists, the configuration file take precedence.\n\nIf the server is not specified in a configuration file, use `open/1` instead.\n\nThe opaque `t:handle/0` reference returned from this function can be used as\nclient identifier when calling any other function in this module. However, if\n`KeyOrName` is a `target_name()`, that is, if the server is named through a call\nto `ct:require/2` or a `require` statement in the test suite, then this name can\nbe used instead of `t:handle/0`.\n\nSee also `ct:require/2`.","ref":"ct_netconfc.html#open/2"},{"type":"function","title":"ct_netconfc.send/2","doc":"","ref":"ct_netconfc.html#send/2"},{"type":"function","title":"ct_netconfc.send/3","doc":"Sends an XML document to the server.\n\nThe specified XML document is sent \"as is\" to the server. This function can be\nused for sending XML documents that cannot be expressed by other interface\nfunctions in this module.","ref":"ct_netconfc.html#send/3"},{"type":"function","title":"ct_netconfc.send_rpc/2","doc":"","ref":"ct_netconfc.html#send_rpc/2"},{"type":"function","title":"ct_netconfc.send_rpc/3","doc":"Sends a NETCONF `rpc` request to the server.\n\nThe specified XML document is wrapped in a valid NETCONF `rpc` request and sent\nto the server. The `message-id` and namespace attributes are added to element\n`rpc`.\n\nThis function can be used for sending `rpc` requests that cannot be expressed by\nother interface functions in this module.","ref":"ct_netconfc.html#send_rpc/3"},{"type":"function","title":"ct_netconfc.session/1","doc":"","ref":"ct_netconfc.html#session/1"},{"type":"function","title":"ct_netconfc.session/2","doc":"","ref":"ct_netconfc.html#session/2"},{"type":"function","title":"ct_netconfc.session/3","doc":"Opens a NETCONF session as a channel on the given SSH connection, and exchanges\nhello messages with the server.\n\nThe opaque `t:handle/0` reference returned from this function can be used as\nclient identifier when calling any other function in this module. However, if\n`KeyOrName` is used and it is a `target_name()`, that is, if the server is named\nthrough a call to `ct:require/2` or a `require` statement in the test suite,\nthen this name can be used instead of `t:handle/0`.","ref":"ct_netconfc.html#session/3"},{"type":"function","title":"ct_netconfc.unlock/2","doc":"","ref":"ct_netconfc.html#unlock/2"},{"type":"function","title":"ct_netconfc.unlock/3","doc":"Unlocks the configuration target.\n\nIf the client earlier has acquired a lock through [`lock/2,3`](`lock/2`), this\noperation releases the associated lock. To access another target than `running`,\nthe server must support `:candidate` and/or `:startup`.","ref":"ct_netconfc.html#unlock/3"},{"type":"type","title":"ct_netconfc.client/0","doc":"Handle to a NETCONF session, as required by signaling functions.","ref":"ct_netconfc.html#t:client/0"},{"type":"type","title":"ct_netconfc.error_reason/0","doc":"","ref":"ct_netconfc.html#t:error_reason/0"},{"type":"opaque","title":"ct_netconfc.handle/0","doc":"Handle to a connection to a NETCONF server as returned by\n[`connect/1,2`](`connect/1`), or to a session as returned by\n[`session/1-3`](`session/1`), [`open/1,2`](`open/1`), or\n[`only_open/1,2`](`only_open/1`).","ref":"ct_netconfc.html#t:handle/0"},{"type":"type","title":"ct_netconfc.host/0","doc":"","ref":"ct_netconfc.html#t:host/0"},{"type":"type","title":"ct_netconfc.netconf_db/0","doc":"","ref":"ct_netconfc.html#t:netconf_db/0"},{"type":"type","title":"ct_netconfc.notification/0","doc":"Event notification messages sent as a result of calls to\n[`create_subscription/2,3`](`create_subscription/2`).","ref":"ct_netconfc.html#t:notification/0"},{"type":"type","title":"ct_netconfc.option/0","doc":"Options `host` and `port` specify the server endpoint to which to connect, and\nare passed directly to [`ssh:connect/4`](`ssh:connect/3`), as are arbitrary ssh\noptions. Common options are `user`, `password` and `user_dir`.\n\nOption `timeout` specifies the number of milliseconds to allow for connection\nestablishment and, if the function in question results in an outgoing hello\nmessage, reception of the server hello. The timeout applies to connection and\nhello independently; one timeout for connection establishment, another for hello\nreception.\n\nOption `receiver` specifies a destination for incoming notification messages; a\nleft operand of the send operator (`!`). If not specified then a process calling\n[`create_subscription/2,3`](`create_subscription/2`) becomes the receiver, but\nexplicitly setting a receiver makes it possible to receive notifications that\nare not ordered by calling this function. Multiple receiver options can be\nspecified.\n\nReceiver options are ignored by connect/1-3.\n\nOption `capability` specifies the content of a corresponding element in an\noutgoing hello message, each option specifying the content of a single element.\nIf no base NETCONF capability is configured then the RFC 4741 1.0 capability,\n\"urn:ietf:params:netconf:base:1.0\", is added, otherwise not. In particular, the\nRFC 6241 1.1 capability must be explicitly configured. NETCONF capabilities can\nbe specified using the shorthand notation defined in RFC 6241, any capability\nstring starting with a colon being prefixed by either \"urn:ietf:params:netconf\"\nor \"urn:ietf:params:netconf:capability\", as appropriate.\n\nCapability options are ignored by connect/1-3 and only_open/1-2, which don't\nresult in an outgoing hello message.","ref":"ct_netconfc.html#t:option/0"},{"type":"type","title":"ct_netconfc.server_id/0","doc":"Identity of connection or session configuration in a configuration file.","ref":"ct_netconfc.html#t:server_id/0"},{"type":"type","title":"ct_netconfc.session_option/0","doc":"","ref":"ct_netconfc.html#t:session_option/0"},{"type":"type","title":"ct_netconfc.simple_xml/0","doc":"Representation of XML, as described in application\n[`xmerl`](`e:xmerl:index.html`).","ref":"ct_netconfc.html#t:simple_xml/0"},{"type":"type","title":"ct_netconfc.stream_data/0","doc":"","ref":"ct_netconfc.html#t:stream_data/0"},{"type":"type","title":"ct_netconfc.stream_name/0","doc":"","ref":"ct_netconfc.html#t:stream_name/0"},{"type":"type","title":"ct_netconfc.streams/0","doc":"Stream information as returned by\n[`get_event_streams/1-3`](`get_event_streams/1`). See RFC 5277, \"XML Schema for\nEvent Notifications\", for detail on the format of the string values.","ref":"ct_netconfc.html#t:streams/0"},{"type":"type","title":"ct_netconfc.xml_attribute_tag/0","doc":"","ref":"ct_netconfc.html#t:xml_attribute_tag/0"},{"type":"type","title":"ct_netconfc.xml_attribute_value/0","doc":"","ref":"ct_netconfc.html#t:xml_attribute_value/0"},{"type":"type","title":"ct_netconfc.xml_attributes/0","doc":"","ref":"ct_netconfc.html#t:xml_attributes/0"},{"type":"type","title":"ct_netconfc.xml_content/0","doc":"","ref":"ct_netconfc.html#t:xml_content/0"},{"type":"type","title":"ct_netconfc.xml_tag/0","doc":"","ref":"ct_netconfc.html#t:xml_tag/0"},{"type":"type","title":"ct_netconfc.xpath/0","doc":"","ref":"ct_netconfc.html#t:xpath/0"},{"type":"type","title":"ct_netconfc.xs_datetime/0","doc":"Date and time of a startTime/stopTime element in an RFC 5277 create-subscription\nrequest. Of XML primitive type `dateTime`, which has the (informal) form\n\n```text\n[-]YYYY-MM-DDThh:mm:ss[.s][Z|(+|-)hh:mm]\n```\n\nwhere `T` and `Z` are literal and `.s` is one or more fractional seconds.","ref":"ct_netconfc.html#t:xs_datetime/0"},{"type":"module","title":"ct_property_test","doc":"Support in Common Test for running property-based tests.\n\nThis module helps running property-based tests in the `Common Test` framework.\nOne (or more) of the property testing tools\n\n- [QuickCheck](http://www.quviq.com),\n- [PropEr](https://proper-testing.github.io) or\n- [Triq](https://github.com/krestenkrab/triq)\n\nis assumed to be installed.\n\nThe idea with this module is to have a `Common Test` test suite calling a\nproperty testing tool with special property test suites as defined by that tool.\nThe tests are collected in the `test` directory of the application. The `test`\ndirectory has a subdirectory `property_test`, where everything needed for the\nproperty tests are collected. The usual Erlang application directory structure\nis assumed.\n\nA typical `Common Test` test suite using `ct_property_test` is organized as\nfollows:\n\n```erlang\n-module(my_prop_test_SUITE).\n-compile(export_all).\n\n-include_lib(\"common_test/include/ct.hrl\").\n\nall() -> [prop_ftp_case].\n\ninit_per_suite(Config) ->\n    ct_property_test:init_per_suite(Config).\n\n%%%---- test case\nprop_ftp_case(Config) ->\n    ct_property_test:quickcheck(\n      ftp_simple_client_server:prop_ftp(),\n      Config\n     ).\n```\n\nand the the property test module (in this example\n`ftp_simple_client_server.erl`) as almost a usual property testing module (More\nexamples are in [the User's Guide](ct_property_test_chapter.md)):\n\n```erlang\n-module(ftp_simple_client_server).\n-export([prop_ftp/0...]).\n\n-include_lib(\"common_test/include/ct_property_test.hrl\").\n\nprop_ftp() ->\n    ?FORALL( ....\n```","ref":"ct_property_test.html"},{"type":"function","title":"ct_property_test.cmnd_names/1","doc":"Returns a list of commands (function calls) generated in the `Cmnd` sequence,\nwithout Module, Arguments and other details.\n\nFor more information see: `present_result/5`.","ref":"ct_property_test.html#cmnd_names/1"},{"type":"function","title":"ct_property_test.init_per_suite/1","doc":"Initializes and extends `Config` for property based testing.\n\nThis function investigates if support is available for either\n[QuickCheck](http://www.quviq.com), [PropEr](https://proper-testing.github.io)\nor [Triq](https://github.com/krestenkrab/triq) and compiles the properties with\nthe first tool found. It is supposed to be called in the\n[`init_per_suite/1`](`init_per_suite/1`) function in a CommonTest test suite.\n\nWhich tools to check for, and in which order could be set with the option\n`{prop_tools, list(eqc|proper|triq)}` in the CommonTest configuration `Config`.\nThe default value is `[eqc, proper, triq]` with `eqc` being the first one\nsearched for.\n\nIf no support is found for any tool, this function returns\n`{skip, Explanation}`.\n\nIn case of other errors, this function returns\n`{fail, Explanation}`.\n\nIf support is found, the option `{property_test_tool,ToolModule}` with the\nselected tool main module name (`eqc`, `proper` or `triq`) is added to the list\n`Config` which then is returned.\n\nThe property tests are assumed to be in a subdirectory named `property_test`.\nAll found Erlang files in that directory are compiled with one of the macros\n`'EQC'`, `'PROPER'` or `'TRIQ'` set, depending on which tool that is first\nfound. This could make parts of the Erlang property tests code to be included or\nexcluded with the macro directives `-ifdef(Macro).` or `-ifndef(Macro).`.\n\nThe file(s) in the `property_test` subdirectory could, or should, include the\nct_property_test include file:\n\n```erlang\n-include_lib(\"common_test/include/ct_property_test.hrl\").\n```\n\nThis included file will:\n\n- Include the correct tool's include file\n- Set the macro `'MOD_eqc'` to the correct module name for the selected tool.\n  That is, the macro `'MOD_eqc'` is set to either `eqc`, `proper` or `triq`.","ref":"ct_property_test.html#init_per_suite/1"},{"type":"function","title":"ct_property_test.num_calls/1","doc":"Returns number of command calls in a test case.\n\nFor more information see: `present_result/5`.","ref":"ct_property_test.html#num_calls/1"},{"type":"function","title":"ct_property_test.present_result/4","doc":"","ref":"ct_property_test.html#present_result/4"},{"type":"function","title":"ct_property_test.present_result/5","doc":"Presents the result of _stateful (statem) property testing_ using the aggregate\nfunction in PropEr, QuickCheck or other similar property testing tool.\n\nIt is assumed to be called inside the property called by `quickcheck/2`:\n\n```erlang\n...\nRunResult = run_parallel_commands(?MODULE, Cmds),\nct_property_test:present_result(?MODULE, Cmds, RunResult, Config)\n...\n```\n\nSee the [User's Guide](ct_property_test_chapter.md#stateful1) for an example of\nthe usage and of the default printout.\n\nThe `StatisticsSpec` is a list of the tuples:\n\n- `{Title::string(), CollectFun::fun/1}`\n- `{Title::string(), FrequencyFun::/0, CollectFun::fun/1}`\n\nEach tuple will produce one table in the order of their places in the list.\n\n- `Title` will be the title of one result table\n- `CollectFun` is called with one argument: the `Cmds`. It should return a list\n  of the values to be counted. The following pre-defined functions exist:\n  - `ct_property_test:cmnd_names/1` returns a list of commands (function calls)\n    generated in the `Cmnd` sequence, without Module, Arguments and other\n    details.\n  - `ct_property_test:num_calls/1` returns a list of the length of commands\n    lists\n  - `ct_property_test:sequential_parallel/1` returns a list with information\n    about sequential and parallel parts from `Tool:parallel_commands/1,2`\n- `FrequencyFun/0` returns a fun/1 which is supposed to take a list of items as\n  input, and return an iolist which will be printed as the table. Per default,\n  the number of each item is counted and the percentage is printed for each. The\n  list \\[a,b,a,a,c] could for example return\n\n  ```erlang\n  [\"a 60%\\n\",\"b 20%\\n\",\"c 20%\\n\"]\n  ```\n\n  which will be printed by the `print_fun`. The default `print_fun` will print\n  it as:\n\n  ```text\n  a 60%\n  b 20%\n  c 20%\n  ```\n\nThe default `StatisticsSpec` is:\n\n- For sequential commands:\n\n  ```erlang\n  [{\"Function calls\", fun cmnd_names/1},\n   {\"Length of command sequences\", fun print_frequency_ranges/0,\n                                                    fun num_calls/1}]\n  ```\n\n- For parallel commands:\n\n  ```erlang\n  [{\"Distribution sequential/parallel\", fun sequential_parallel/1},\n   {\"Function calls\", fun cmnd_names/1},\n   {\"Length of command sequences\", fun print_frequency_ranges/0,\n                                                    fun num_calls/1}]\n  ```","ref":"ct_property_test.html#present_result/5"},{"type":"function","title":"ct_property_test.quickcheck/2","doc":"Calls the selected tool's function for running the `Property`. It is usually and\nby historical reasons called quickcheck, and that is why that name is used in\nthis module (`ct_property_test`).\n\nThe result is returned in a form suitable for `Common Test` test suites.\n\nThis function is intended to be called in test cases in test suites.","ref":"ct_property_test.html#quickcheck/2"},{"type":"function","title":"ct_property_test.sequential_parallel/1","doc":"Returns a list with information about sequential and parallel parts.\n\nFor more information see: `present_result/5`.","ref":"ct_property_test.html#sequential_parallel/1"},{"type":"type","title":"ct_property_test.arguments/0","doc":"","ref":"ct_property_test.html#t:arguments/0"},{"type":"type","title":"ct_property_test.command/0","doc":"","ref":"ct_property_test.html#t:command/0"},{"type":"type","title":"ct_property_test.command_list/0","doc":"","ref":"ct_property_test.html#t:command_list/0"},{"type":"type","title":"ct_property_test.dynamic_state/0","doc":"","ref":"ct_property_test.html#t:dynamic_state/0"},{"type":"type","title":"ct_property_test.function_name/0","doc":"","ref":"ct_property_test.html#t:function_name/0"},{"type":"type","title":"ct_property_test.history/0","doc":"","ref":"ct_property_test.html#t:history/0"},{"type":"type","title":"ct_property_test.init_command/0","doc":"","ref":"ct_property_test.html#t:init_command/0"},{"type":"type","title":"ct_property_test.parallel_testcase/0","doc":"","ref":"ct_property_test.html#t:parallel_testcase/0"},{"type":"type","title":"ct_property_test.set_command/0","doc":"","ref":"ct_property_test.html#t:set_command/0"},{"type":"type","title":"ct_property_test.statem_result/0","doc":"","ref":"ct_property_test.html#t:statem_result/0"},{"type":"type","title":"ct_property_test.symbolic_call/0","doc":"","ref":"ct_property_test.html#t:symbolic_call/0"},{"type":"type","title":"ct_property_test.symbolic_state/0","doc":"","ref":"ct_property_test.html#t:symbolic_state/0"},{"type":"type","title":"ct_property_test.symbolic_var/0","doc":"","ref":"ct_property_test.html#t:symbolic_var/0"},{"type":"module","title":"ct_rpc","doc":"`Common Test` specific layer on Erlang/OTP `rpc`.","ref":"ct_rpc.html"},{"type":"function","title":"ct_rpc.app_node/2","doc":"From a set of candidate nodes determines which of them is running the\napplication `App`. If none of the candidate nodes is running `App`, the function\nmakes the test case calling this function to fail. This function is the same as\ncalling [`app_node(App, Candidates, true)`](`app_node/3`).","ref":"ct_rpc.html#app_node/2"},{"type":"function","title":"ct_rpc.app_node/3","doc":"Same as [`ct_rpc:app_node/2`](`app_node/2`), except that argument `FailOnBadRPC`\ndetermines if the search for a candidate node is to stop if `badrpc` is received\nat some point.","ref":"ct_rpc.html#app_node/3"},{"type":"function","title":"ct_rpc.app_node/4","doc":"Same as [`ct_rpc:app_node/2`](`app_node/2`), except that argument `FailOnBadRPC`\ndetermines if the search for a candidate node is to stop if `badrpc` is received\nat some point.\n\nThe cookie on the client node is set to `Cookie` for this `rpc` operation (used\nto match the server node cookie).","ref":"ct_rpc.html#app_node/4"},{"type":"function","title":"ct_rpc.call/4","doc":"","ref":"ct_rpc.html#call/4"},{"type":"function","title":"ct_rpc.call/5","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the node `Node`.\nReturns either whatever `Function` returns, or `{badrpc, Reason}` if the remote\nprocedure call fails. If `Node` is `{Fun, FunArgs}`, applying `Fun` to `FunArgs`\nis to return a node name.","ref":"ct_rpc.html#call/5"},{"type":"function","title":"ct_rpc.call/6","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the node `Node`.\nReturns either whatever `Function` returns, or `{badrpc, Reason}` if the remote\nprocedure call fails. If `Node` is `{Fun, FunArgs}`, applying `Fun` to `FunArgs`\nis to return a node name.\n\nThe cookie on the client node is set to `Cookie` for this `rpc` operation (used\nto match the server node cookie).","ref":"ct_rpc.html#call/6"},{"type":"function","title":"ct_rpc.cast/4","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the node `Node`. No\nresponse is delivered and the process that makes the call is not suspended until\nthe evaluation is completed as in the case of `call/3,4`. If `Node` is\n`{Fun, FunArgs}`, applying `Fun` to `FunArgs` is to return a node name.","ref":"ct_rpc.html#cast/4"},{"type":"function","title":"ct_rpc.cast/5","doc":"Evaluates [`apply(Module, Function, Args)`](`apply/3`) on the node `Node`. No\nresponse is delivered and the process that makes the call is not suspended until\nthe evaluation is completed as in the case of `call/3,4`. If `Node` is\n`{Fun, FunArgs}`, applying `Fun` to `FunArgs` is to return a node name.\n\nThe cookie on the client node is set to `Cookie` for this `rpc` operation (used\nto match the server node cookie).","ref":"ct_rpc.html#cast/5"},{"type":"module","title":"ct_slave","doc":"`Common Test` framework functions for starting and stopping nodes for\nLarge-Scale Testing.\n\nThis module exports functions used by the `Common Test` Master to start and stop\n\"slave\" nodes. It is the default callback module for the `{init, node_start}`\nterm in the Test Specification.","ref":"ct_slave.html"},{"type":"function","title":"ct_slave.start/1","doc":"Starts an Erlang node with name `Node` on the local host.\n\nSee also [`ct_slave:start/3`](`start/3`).","ref":"ct_slave.html#start/1"},{"type":"function","title":"ct_slave.start/2","doc":"Starts an Erlang node with default options on a specified host, or on the local\nhost with specified options. That is, the call is interpreted as\n[`start(Host, Node)`](`start/2`) when the second argument is atom-valued and\n[`start(Node, Opts)`](`start/2`) when it is list-valued.\n\nSee also [`ct_slave:start/3`](`start/3`).","ref":"ct_slave.html#start/2"},{"type":"function","title":"ct_slave.start/3","doc":"Starts an Erlang node with name `Node` on host `Host` as specified by the\ncombination of options in `Opts`.\n\nOptions `Username` and `Password` are used to log on to the remote host `Host`.\n`Username`, if omitted, defaults to the current username. `Password` is empty by\ndefault.\n\nA list of functions specified in option `Startup` are executed after startup of\nthe node. Notice that all used modules are to be present in the code path on\n`Host`.\n\nThe time-outs are applied as follows:\n\n- **`BootTimeout`** - The time to start the Erlang node, in seconds. Defaults to\n  3 seconds. If the node is not pingable within this time, the result\n  `{error, boot_timeout, NodeName}` is returned.\n\n- **`InitTimeout`** - The time to wait for the node until it calls the internal\n  callback function informing master about a successful startup. Defaults to 1\n  second. In case of a timed out message, the result\n  `{error, init_timeout, NodeName}` is returned.\n\n- **`StartupTimeout`** - The time to wait until the node stops to run\n  `StartupFunctions`. Defaults to 1 second. If this time-out occurs, the result\n  `{error, startup_timeout, NodeName}` is returned.\n\n_Options:_\n\n- **`monitor_master`** - Specifies if the slave node is to be stopped if the\n  master node stops. Defaults to `false`.\n\n- **`kill_if_fail`** - Specifies if the slave node is to be killed if a time-out\n  occurs during initialization or startup. Defaults to `true`. Notice that the\n  node can also be still alive it the boot time-out occurred, but it is not\n  killed in this case.\n\n- **`erl_flags`** - Specifies which flags are added to the parameters of the\n  executable `erl`.\n\n- **`env`** - Specifies a list of environment variables that will extend the\n  environment.\n\n_Special return values:_\n\n- `{error, already_started, NodeName}` if the node with the specified name is\n  already started on a specified host.\n- `{error, started_not_connected, NodeName}` if the node is started, but not\n  connected to the master node.\n- `{error, not_alive, NodeName}` if the node on which\n  [`ct_slave:start/3`](`start/3`) is called, is not alive. Notice that\n  `NodeName` is the name of the current node in this case.","ref":"ct_slave.html#start/3"},{"type":"function","title":"ct_slave.stop/1","doc":"Stops the running Erlang node with name `Node` on the local host.","ref":"ct_slave.html#stop/1"},{"type":"function","title":"ct_slave.stop/2","doc":"Stops the running Erlang node with name `Node` on host `Host`.","ref":"ct_slave.html#stop/2"},{"type":"type","title":"ct_slave.start_options/0","doc":"Options used for starting `ct_slave` node.","ref":"ct_slave.html#t:start_options/0"},{"type":"type","title":"ct_slave.stop_options/0","doc":"Options used for stopping `ct_slave` node.","ref":"ct_slave.html#t:stop_options/0"},{"type":"module","title":"ct_snmp","doc":"`Common Test` user interface module for the `SNMP` application.\n\nThe purpose of this module is to simplify SNMP configuration for the test case\nwriter. Many test cases can use default values for common operations and then no\nSNMP configuration files need to be supplied. When it is necessary to change\nparticular configuration parameters, a subset of the relevant SNMP configuration\nfiles can be passed to `ct_snmp` by `Common Test` configuration files. For more\nspecialized configuration parameters, a simple SNMP configuration file can be\nplaced in the test suite data directory. To simplify the test suite,\n`Common Test` keeps track of some of the SNMP manager information. This way the\ntest suite does not have to handle as many input parameters as if it had to\ninterface wthe OTP SNMP manager directly.\n\n_Configurable SNMP Manager and Agent Parameters:_\n\nManager configuration:\n\n- **`[{start_manager, boolean()}`** - Optional. Default is `true`.\n\n- **`{users, [{user_name(), [call_back_module(), user_data()]}]}`** - Optional.\n\n- **`{usm_users, [{usm_user_name(), [usm_config()]}]}`** - Optional. SNMPv3\n  only.\n\n- **`{managed_agents,[{agent_name(), [user_name(), agent_ip(), agent_port(), [agent_config()]]}]}`** -\n  `managed_agents` is optional.\n\n- **`{max_msg_size, integer()}`** - Optional. Default is `484`.\n\n- **`{mgr_port, integer()}`** - Optional. Default is `5000`.\n\n- **`{engine _id, string()}`** - Optional. Default is `\"mgrEngine\"`.\n\nAgent configuration:\n\n- **`{start_agent, boolean()}`** - Optional. Default is `false`.\n\n- **`{agent_sysname, string()}`** - Optional. Default is `\"ct_test\"`.\n\n- **`{agent_manager_ip, manager_ip()}`** - Optional. Default is `localhost`.\n\n- **`{agent_vsns, list()}`** - Optional. Default is `[v2]`.\n\n- **`{agent_trap_udp, integer()}`** - Optional. Default is `5000`.\n\n- **`{agent_udp, integer()}`** - Optional. Default is `4000`.\n\n- **`{agent_notify_type, atom()}`** - Optional. Default is `trap`.\n\n- **`{agent_sec_type, sec_type()}`** - Optional. Default is `none`.\n\n- **`{agent_passwd, string()}`** - Optional. Default is `\"\"`.\n\n- **`{agent_engine_id, string()}`** - Optional. Default is `\"agentEngine\"`.\n\n- **`{agent_max_msg_size, string()}`** - Optional. Default is `484`.\n\nThe following parameters represents the SNMP configuration files `context.conf`,\n`standard.conf`, `community.conf`, `vacm.conf`, `usm.conf`, `notify.conf`,\n`target_addr.conf`, and `target_params.conf`. Notice that all values in\n`agent.conf` can be modified by the parameters listed above. All these\nconfiguration files have default values set by the `SNMP` application. These\nvalues can be overridden by suppling a list of valid configuration values or a\nfile located in the test suites data directory, which can produce a list of\nvalid configuration values if you apply function `file:consult/1` to the file.\n\n- **`{agent_contexts, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_community, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_sysinfo, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_vacm, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_usm, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_notify_def, [term()] | {data_dir_file, rel_path()}}`** - Optional.\n\n- **`{agent_target_address_def, [term()] | {data_dir_file, rel_path()}}`** -\n  Optional.\n\n- **`{agent_target_param_def, [term()] | {data_dir_file, rel_path()}}`** -\n  Optional.\n\nParameter `MgrAgentConfName` in the functions is to be a name you allocate in\nyour test suite using a `require` statement. Example (where\n`MgrAgentConfName = snmp_mgr_agent`):\n\n```erlang\nsuite() -> [{require, snmp_mgr_agent, snmp}].\n```\n\nor\n\n```erlang\nct:require(snmp_mgr_agent, snmp).\n```\n\nNotice that USM users are needed for SNMPv3 configuration and are not to be\nconfused with users.\n\nSNMP traps, inform, and report messages are handled by the user callback module.\nFor details, see the [`SNMP`](`e:snmp:index.html`) application.\n\nIt is recommended to use the `.hrl` files created by the Erlang/OTP MIB compiler\nto define the Object Identifiers (OIDs). For example, to get the Erlang node\nname from `erlNodeTable` in the OTP-MIB:\n\n```erlang\nOid = ?erlNodeEntry ++ [?erlNodeName, 1]\n```\n\nFurthermore, values can be set for `SNMP` application configuration parameters,\n`config`, `server`, `net_if`, and so on (for a list of valid parameters and\ntypes, see the [`User's Guide for the SNMP application`](`e:snmp:index.html`)).\nThis is done by defining a configuration data variable on the following form:\n\n```erlang\n{snmp_app, [{manager, [snmp_app_manager_params()]},\n            {agent, [snmp_app_agent_params()]}]}.\n```\n\nA name for the data must be allocated in the suite using `require` (see the\nexample above). Pass this name as argument `SnmpAppConfName` to\n[`ct_snmp:start/3`](`start/3`). `ct_snmp` specifies default values for some\n`SNMP` application configuration parameters (such as `{verbosity,trace}` for\nparameter `config`). This set of defaults is merged with the parameters\nspecified by the user. The user values override `ct_snmp` defaults.","ref":"ct_snmp.html"},{"type":"function","title":"ct_snmp.get_next_values/3","doc":"Issues a synchronous SNMP `get next` request.","ref":"ct_snmp.html#get_next_values/3"},{"type":"function","title":"ct_snmp.get_values/3","doc":"Issues a synchronous SNMP `get` request.","ref":"ct_snmp.html#get_values/3"},{"type":"function","title":"ct_snmp.load_mibs/1","doc":"Loads the MIBs into agent `snmp_master_agent`.","ref":"ct_snmp.html#load_mibs/1"},{"type":"function","title":"ct_snmp.register_agents/2","doc":"Explicitly instructs the manager to handle this agent. Corresponds to making an\nentry in `agents.conf`.\n\nThis function tries to register the specified managed agents, without checking\nif any of them exist. To change a registered managed agent, the agent must first\nbe unregistered.","ref":"ct_snmp.html#register_agents/2"},{"type":"function","title":"ct_snmp.register_users/2","doc":"Registers the manager entity (=user) responsible for specific agent(s).\nCorresponds to making an entry in `users.conf`.\n\nThis function tries to register the specified users, without checking if any of\nthem exist. To change a registered user, the user must first be unregistered.","ref":"ct_snmp.html#register_users/2"},{"type":"function","title":"ct_snmp.register_usm_users/2","doc":"Explicitly instructs the manager to handle this USM user. Corresponds to making\nan entry in `usm.conf`.\n\nThis function tries to register the specified users, without checking if any of\nthem exist. To change a registered user, the user must first be unregistered.","ref":"ct_snmp.html#register_usm_users/2"},{"type":"function","title":"ct_snmp.set_info/1","doc":"Returns a list of all successful `set` requests performed in the test case in\nreverse order. The list contains the involved user and agent, the value before\n`set`, and the new value. This is intended to simplify the cleanup in function\n`end_per_testcase`, that is, the undoing of the `set` requests and their\npossible side-effects.","ref":"ct_snmp.html#set_info/1"},{"type":"function","title":"ct_snmp.set_values/4","doc":"Issues a synchronous SNMP `set` request.","ref":"ct_snmp.html#set_values/4"},{"type":"function","title":"ct_snmp.start/2","doc":"","ref":"ct_snmp.html#start/2"},{"type":"function","title":"ct_snmp.start/3","doc":"Starts an SNMP manager and/or agent. In the manager case, registrations of users\nand agents, as specified by the configuration `MgrAgentConfName`, are performed.\nWhen using SNMPv3, called USM users are also registered. Users, `usm_users`, and\nmanaged agents can also be registered later using\n[`ct_snmp:register_users/2`](`register_users/2`),\n[`ct_snmp:register_agents/2`](`register_agents/2`), and\n[`ct_snmp:register_usm_users/2`](`register_usm_users/2`).\n\nThe agent started is called `snmp_master_agent`. Use\n[`ct_snmp:load_mibs/1`](`load_mibs/1`) to load MIBs into the agent.\n\nWith `SnmpAppConfName` SNMP applications can be configured with parameters\n`config`, `mibs`, `net_if`, and so on. The values are merged with (and possibly\noverride) default values set by `ct_snmp`.","ref":"ct_snmp.html#start/3"},{"type":"function","title":"ct_snmp.stop/1","doc":"Stops the SNMP manager and/or agent, and removes all files created.","ref":"ct_snmp.html#stop/1"},{"type":"function","title":"ct_snmp.unload_mibs/1","doc":"Unloads the MIBs from agent `snmp_master_agent`.","ref":"ct_snmp.html#unload_mibs/1"},{"type":"function","title":"ct_snmp.unregister_agents/1","doc":"Unregisters all managed agents.","ref":"ct_snmp.html#unregister_agents/1"},{"type":"function","title":"ct_snmp.unregister_agents/2","doc":"Unregisters the specified managed agents.","ref":"ct_snmp.html#unregister_agents/2"},{"type":"function","title":"ct_snmp.unregister_users/1","doc":"Unregisters all users.","ref":"ct_snmp.html#unregister_users/1"},{"type":"function","title":"ct_snmp.unregister_users/2","doc":"Unregisters the specified users.","ref":"ct_snmp.html#unregister_users/2"},{"type":"function","title":"ct_snmp.unregister_usm_users/1","doc":"Unregisters all USM users.","ref":"ct_snmp.html#unregister_usm_users/1"},{"type":"function","title":"ct_snmp.unregister_usm_users/2","doc":"Unregisters the specified USM users.","ref":"ct_snmp.html#unregister_usm_users/2"},{"type":"type","title":"ct_snmp.agent_config/0","doc":"","ref":"ct_snmp.html#t:agent_config/0"},{"type":"type","title":"ct_snmp.agent_ip/0","doc":"","ref":"ct_snmp.html#t:agent_ip/0"},{"type":"type","title":"ct_snmp.agent_name/0","doc":"","ref":"ct_snmp.html#t:agent_name/0"},{"type":"type","title":"ct_snmp.agent_port/0","doc":"","ref":"ct_snmp.html#t:agent_port/0"},{"type":"type","title":"ct_snmp.call_back_module/0","doc":"","ref":"ct_snmp.html#t:call_back_module/0"},{"type":"type","title":"ct_snmp.error_index/0","doc":"","ref":"ct_snmp.html#t:error_index/0"},{"type":"type","title":"ct_snmp.error_status/0","doc":"","ref":"ct_snmp.html#t:error_status/0"},{"type":"type","title":"ct_snmp.ip/0","doc":"","ref":"ct_snmp.html#t:ip/0"},{"type":"type","title":"ct_snmp.manager_ip/0","doc":"","ref":"ct_snmp.html#t:manager_ip/0"},{"type":"type","title":"ct_snmp.oid/0","doc":"","ref":"ct_snmp.html#t:oid/0"},{"type":"type","title":"ct_snmp.oids/0","doc":"","ref":"ct_snmp.html#t:oids/0"},{"type":"type","title":"ct_snmp.rel_path/0","doc":"","ref":"ct_snmp.html#t:rel_path/0"},{"type":"type","title":"ct_snmp.sec_type/0","doc":"","ref":"ct_snmp.html#t:sec_type/0"},{"type":"type","title":"ct_snmp.snmp_app_agent_params/0","doc":"","ref":"ct_snmp.html#t:snmp_app_agent_params/0"},{"type":"type","title":"ct_snmp.snmp_app_manager_params/0","doc":"","ref":"ct_snmp.html#t:snmp_app_manager_params/0"},{"type":"type","title":"ct_snmp.snmpreply/0","doc":"","ref":"ct_snmp.html#t:snmpreply/0"},{"type":"type","title":"ct_snmp.user_data/0","doc":"","ref":"ct_snmp.html#t:user_data/0"},{"type":"type","title":"ct_snmp.user_name/0","doc":"","ref":"ct_snmp.html#t:user_name/0"},{"type":"type","title":"ct_snmp.usm_config/0","doc":"","ref":"ct_snmp.html#t:usm_config/0"},{"type":"type","title":"ct_snmp.usm_user_name/0","doc":"","ref":"ct_snmp.html#t:usm_user_name/0"},{"type":"type","title":"ct_snmp.value_type/0","doc":"","ref":"ct_snmp.html#t:value_type/0"},{"type":"type","title":"ct_snmp.var_and_val/0","doc":"","ref":"ct_snmp.html#t:var_and_val/0"},{"type":"type","title":"ct_snmp.varbind/0","doc":"","ref":"ct_snmp.html#t:varbind/0"},{"type":"type","title":"ct_snmp.varbinds/0","doc":"","ref":"ct_snmp.html#t:varbinds/0"},{"type":"type","title":"ct_snmp.varsandvals/0","doc":"These data types are described in the documentation for the\n[`SNMP`](`e:snmp:index.html`) application.","ref":"ct_snmp.html#t:varsandvals/0"},{"type":"module","title":"ct_ssh","doc":"SSH/SFTP client module.\n\nThis module uses application `SSH`, which provides detailed information about,\nfor example, functions, types, and options.\n\nArgument `Server` in the SFTP functions is only to be used for SFTP sessions\nthat have been started on existing SSH connections (that is, when the original\nconnection type is `ssh`). Whenever the connection type is `sftp`, use the SSH\nconnection reference only.\n\nThe following options are valid for specifying an SSH/SFTP connection (that is,\ncan be used as configuration elements):\n\n```erlang\n[{ConnType, Addr},\n {port, Port},\n {user, UserName}\n {password, Pwd}\n {user_dir, String}\n {public_key_alg, PubKeyAlg}\n {connect_timeout, Timeout}\n {key_cb, KeyCallbackMod}]\n```\n\n`ConnType = ssh | sftp`.\n\nFor other types, see `m:ssh`.\n\nAll time-out parameters in `ct_ssh` functions are values in milliseconds.","ref":"ct_ssh.html"},{"type":"function","title":"ct_ssh.apread/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#apread/4"},{"type":"function","title":"ct_ssh.apread/5","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#apread/5"},{"type":"function","title":"ct_ssh.apwrite/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#apwrite/4"},{"type":"function","title":"ct_ssh.apwrite/5","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#apwrite/5"},{"type":"function","title":"ct_ssh.aread/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#aread/3"},{"type":"function","title":"ct_ssh.aread/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#aread/4"},{"type":"function","title":"ct_ssh.awrite/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#awrite/3"},{"type":"function","title":"ct_ssh.awrite/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#awrite/4"},{"type":"function","title":"ct_ssh.close/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#close/2"},{"type":"function","title":"ct_ssh.close/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#close/3"},{"type":"function","title":"ct_ssh.connect/1","doc":"","ref":"ct_ssh.html#connect/1"},{"type":"function","title":"ct_ssh.connect/2","doc":"Opens an SSH or SFTP connection using the information associated with `KeyOrName`\n(see `connect/3`).\n\nEquivalent to [`connect(KeyOrName, ConnType, [])`](`connect/3`) if\ncalled with ConnType being atom.\n\nEquivalent to [`connect(KeyOrName, host, ExtraOpts)`](`connect/3`) if\ncalled with ExtraOpts being list.","ref":"ct_ssh.html#connect/2"},{"type":"function","title":"ct_ssh.connect/3","doc":"Opens an SSH or SFTP connection using the information associated with\n`KeyOrName`.\n\nIf `Name` (an alias name for `Key`) is used to identify the connection, this\nname can be used as connection reference for subsequent calls. Only one open\nconnection at a time associated with `Name` is possible. If `Key` is used, the\nreturned handle must be used for subsequent calls (multiple connections can be\nopened using the configuration data specified by `Key`).\n\nFor information on how to create a new `Name`, see `ct:require/2`.\n\n`ConnType` always overrides the type specified in the address tuple in the\nconfiguration data (and in `ExtraOpts`). So it is possible to, for example, open\nan SFTP connection directly using data originally specifying an SSH connection.\nValue `host` means that the connection type specified by the host option (either\nin the configuration data or in `ExtraOpts`) is used.\n\n`ExtraOpts` (optional) are extra SSH options to be added to the configuration\ndata for `KeyOrName`. The extra options override any existing options with the\nsame key in the configuration data. For details on valid SSH options, see\napplication [`SSH`](`e:ssh:index.html`).","ref":"ct_ssh.html#connect/3"},{"type":"function","title":"ct_ssh.del_dir/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#del_dir/2"},{"type":"function","title":"ct_ssh.del_dir/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#del_dir/3"},{"type":"function","title":"ct_ssh.delete/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#delete/2"},{"type":"function","title":"ct_ssh.delete/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#delete/3"},{"type":"function","title":"ct_ssh.disconnect/1","doc":"Closes an SSH/SFTP connection.","ref":"ct_ssh.html#disconnect/1"},{"type":"function","title":"ct_ssh.exec/2","doc":"","ref":"ct_ssh.html#exec/2"},{"type":"function","title":"ct_ssh.exec/3","doc":"Requests server to perform `Command`, (see `exec/4`).\n\nEquivalent to [`exec(SSH, undefined, Command, Timeout)`](`exec/4`) if\ncalled with Command being string.\n\nEquivalent to [`exec(SSH, ChannelId, Command, DefaultTimeout)`](`exec/4`) if\ncalled with ChannelId being integer.","ref":"ct_ssh.html#exec/3"},{"type":"function","title":"ct_ssh.exec/4","doc":"Requests server to perform `Command`. A previously opened session channel is\nused for the request. `Data` is received from the server as a result of the\ncommand.","ref":"ct_ssh.html#exec/4"},{"type":"function","title":"ct_ssh.get_file_info/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#get_file_info/2"},{"type":"function","title":"ct_ssh.get_file_info/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#get_file_info/3"},{"type":"function","title":"ct_ssh.list_dir/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#list_dir/2"},{"type":"function","title":"ct_ssh.list_dir/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#list_dir/3"},{"type":"function","title":"ct_ssh.make_dir/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#make_dir/2"},{"type":"function","title":"ct_ssh.make_dir/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#make_dir/3"},{"type":"function","title":"ct_ssh.make_symlink/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#make_symlink/3"},{"type":"function","title":"ct_ssh.make_symlink/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#make_symlink/4"},{"type":"function","title":"ct_ssh.open/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#open/3"},{"type":"function","title":"ct_ssh.open/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#open/4"},{"type":"function","title":"ct_ssh.opendir/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#opendir/2"},{"type":"function","title":"ct_ssh.opendir/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#opendir/3"},{"type":"function","title":"ct_ssh.position/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#position/3"},{"type":"function","title":"ct_ssh.position/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#position/4"},{"type":"function","title":"ct_ssh.pread/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#pread/4"},{"type":"function","title":"ct_ssh.pread/5","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#pread/5"},{"type":"function","title":"ct_ssh.pwrite/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#pwrite/4"},{"type":"function","title":"ct_ssh.pwrite/5","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#pwrite/5"},{"type":"function","title":"ct_ssh.read/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read/3"},{"type":"function","title":"ct_ssh.read/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read/4"},{"type":"function","title":"ct_ssh.read_file/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_file/2"},{"type":"function","title":"ct_ssh.read_file/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_file/3"},{"type":"function","title":"ct_ssh.read_file_info/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_file_info/2"},{"type":"function","title":"ct_ssh.read_file_info/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_file_info/3"},{"type":"function","title":"ct_ssh.read_link/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_link/2"},{"type":"function","title":"ct_ssh.read_link/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_link/3"},{"type":"function","title":"ct_ssh.read_link_info/2","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_link_info/2"},{"type":"function","title":"ct_ssh.read_link_info/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#read_link_info/3"},{"type":"function","title":"ct_ssh.receive_response/2","doc":"","ref":"ct_ssh.html#receive_response/2"},{"type":"function","title":"ct_ssh.receive_response/3","doc":"Receives expected data from server on the specified session channel\n(see `receive_response/4`).\n\nEquivalent to [`receive_response(SSH, ChannelId, End, DefaultTimeout)`](`receive_response/4`) if\ncalled with End being function.\n\nEquivalent to [`receive_response(SSH, ChannelId, close, Timeout)`](`receive_response/4`) if\ncalled with Timeout being integer.","ref":"ct_ssh.html#receive_response/3"},{"type":"function","title":"ct_ssh.receive_response/4","doc":"Receives expected data from server on the specified session channel.\n\nIf `End == close`, data is returned to the caller when the channel is closed by\nthe server. If a time-out occurs before this happens, the function returns\n`{timeout,Data}` (where `Data` is the data received so far).\n\nIf `End == timeout`, a time-out is expected and `{ok,Data}` is returned both in\nthe case of a time-out and when the channel is closed.\n\nIf `End` is a fun, this fun is called with one argument, the data value in a\nreceived `ssh_cm` message (see `m:ssh_connection`. The fun is to return either\n`true` to end the receiving operation (and have the so far collected data\nreturned) or `false` to wait for more data from the server. Even if a fun is\nsupplied, the function returns immediately if the server closes the channel).","ref":"ct_ssh.html#receive_response/4"},{"type":"function","title":"ct_ssh.rename/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#rename/3"},{"type":"function","title":"ct_ssh.rename/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#rename/4"},{"type":"function","title":"ct_ssh.send/3","doc":"","ref":"ct_ssh.html#send/3"},{"type":"function","title":"ct_ssh.send/4","doc":"Sends data to server on specified session channel (see `send/5`).\n\nEquivalent to [`send(SSH, ChannelId, 0, Data, Timeout)`](`send/5`) if\ncalled with Timeout being integer.\n\nEquivalent to [`send(SSH, ChannelId, Type, Data, DefaultTimeout)`](`send/5`) if\ncalled with Type being integer.","ref":"ct_ssh.html#send/4"},{"type":"function","title":"ct_ssh.send/5","doc":"Sends data to server on specified session channel.","ref":"ct_ssh.html#send/5"},{"type":"function","title":"ct_ssh.send_and_receive/3","doc":"","ref":"ct_ssh.html#send_and_receive/3"},{"type":"function","title":"ct_ssh.send_and_receive/4","doc":"Sends data to server on specified session channel and waits to receive the\nserver response (see `send_and_receive/6`).\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, 0, Data, End, DefaultTimeout)`](`send_and_receive/6`)\nif called with End being function.\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, 0, Data, close, Timeout)`](`send_and_receive/6`)\nif called with Timeout being integer.\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, Type, Data, close, DefaultTimeout)`](`send_and_receive/6`)\nif called with Type being integer.","ref":"ct_ssh.html#send_and_receive/4"},{"type":"function","title":"ct_ssh.send_and_receive/5","doc":"Sends data to server on specified session channel and waits to receive the\nserver response (see `send_and_receive/6`).\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, 0, Data, End, Timeout)`](`send_and_receive/6`) if\ncalled with Timeout being integer.\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, Type, Data, close, Timeout)`](`send_and_receive/6`) if\ncalled with Type being integer.\n\nEquivalent to\n[`send_and_receive(SSH, ChannelId, Type, Data, End, DefaultTimeout)`](`send_and_receive/6`) if\ncalled with End being function.","ref":"ct_ssh.html#send_and_receive/5"},{"type":"function","title":"ct_ssh.send_and_receive/6","doc":"Sends data to server on specified session channel and waits to receive the\nserver response.\n\nFor details on argument `End`, see\n[`ct_ssh:receive_response/4`](`receive_response/4`).","ref":"ct_ssh.html#send_and_receive/6"},{"type":"function","title":"ct_ssh.session_close/2","doc":"Closes an SSH session channel.","ref":"ct_ssh.html#session_close/2"},{"type":"function","title":"ct_ssh.session_open/1","doc":"","ref":"ct_ssh.html#session_open/1"},{"type":"function","title":"ct_ssh.session_open/2","doc":"Opens a channel for an SSH session.","ref":"ct_ssh.html#session_open/2"},{"type":"function","title":"ct_ssh.sftp_connect/1","doc":"Starts an SFTP session on an already existing SSH connection. `Server`\nidentifies the new session and must be specified whenever SFTP requests are to\nbe sent.","ref":"ct_ssh.html#sftp_connect/1"},{"type":"function","title":"ct_ssh.shell/2","doc":"","ref":"ct_ssh.html#shell/2"},{"type":"function","title":"ct_ssh.shell/3","doc":"Requests that the user's default shell (typically defined in `/etc/passwd` in Unix\nsystems) is executed at the server end.","ref":"ct_ssh.html#shell/3"},{"type":"function","title":"ct_ssh.subsystem/3","doc":"","ref":"ct_ssh.html#subsystem/3"},{"type":"function","title":"ct_ssh.subsystem/4","doc":"Sends a request to execute a predefined subsystem.","ref":"ct_ssh.html#subsystem/4"},{"type":"function","title":"ct_ssh.write/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write/3"},{"type":"function","title":"ct_ssh.write/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write/4"},{"type":"function","title":"ct_ssh.write_file/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write_file/3"},{"type":"function","title":"ct_ssh.write_file/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write_file/4"},{"type":"function","title":"ct_ssh.write_file_info/3","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write_file_info/3"},{"type":"function","title":"ct_ssh.write_file_info/4","doc":"For information and other types, see `m:ssh_sftp`.","ref":"ct_ssh.html#write_file_info/4"},{"type":"type","title":"ct_ssh.connection/0","doc":"Reference to opened SSH/SFTP connection associated to either a `handle` or `target_name`.","ref":"ct_ssh.html#t:connection/0"},{"type":"type","title":"ct_ssh.connection_type/0","doc":"Connection type used for connect.","ref":"ct_ssh.html#t:connection_type/0"},{"type":"type","title":"ct_ssh.handle/0","doc":"Handle for a specific SSH/SFTP connection, see module `m:ct`.","ref":"ct_ssh.html#t:handle/0"},{"type":"type","title":"ct_ssh.ssh_channel_id/0","doc":"Data type representing a channel inside a connection.\n\n\"For `ssh_channel_id`, see module `m:ssh`.\".","ref":"ct_ssh.html#t:ssh_channel_id/0"},{"type":"type","title":"ct_ssh.ssh_data_type_code/0","doc":"The valid values are `0` (\"normal\") and `1` (\"stderr\"), see\n[RFC 4254, Section 5.2](https://tools.ietf.org/html/rfc4254#page-8).","ref":"ct_ssh.html#t:ssh_data_type_code/0"},{"type":"behaviour","title":"ct_suite","doc":"The following section describes the mandatory and optional test suite functions\nthat `Common Test` calls during test execution. For more details, see section\n[Writing Test Suites](write_test_chapter.md) in the User's Guide.","ref":"ct_suite.html"},{"type":"callback","title":"ct_suite.all/0","doc":"Returns the list of all test cases and test case groups in the test suite module\nto be executed.\n\nThis list also specifies the order the cases and groups are\nexecuted by `Common Test`. A test case is represented by an atom, the name of\nthe test case function, or a `testcase` tuple indicating that the test case\nshall be repeated. A test case group is represented by a `group` tuple, where\n`GroupName`, an atom, is the name of the group (defined in\n[`Module:groups/0`](`c:groups/0`)). Execution properties for groups can also be\nspecified, both for a top-level group and for any of its subgroups. Group\nexecution properties specified here override properties in the group definition\n(see [`Module:groups/0`](`c:groups/0`)). (With value `default`, the group\ndefinition properties are used).\n\nIf `{skip, Reason}` is returned, all test cases in the module are skipped and\n`Reason` is printed on the HTML result page.\n\nFor details on groups, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups) in the User's Guide.","ref":"ct_suite.html#c:all/0"},{"type":"callback","title":"ct_suite.end_per_group/2","doc":"This function is called after the execution of a test case group is finished. It\nis meant to be used for cleaning up after [`Module:init_per_group/2`](`c:init_per_group/2`).\n\nA status value for a nested subgroup can be returned with `{return_group_result, Status}`.\nThe status can be retrieved in [`Module:end_per_group/2`](`c:end_per_group/2`) for the group on\nthe level above. The status is also used by `Common Test` for deciding if\nexecution of a group is to proceed if property `sequence` or `repeat_until_*` is\nset.\n\nFor details about test case groups, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups) in the User's Guide.\n\nIf this function is defined, then\n[`Module:init_per_group/2`](`c:init_per_group/2`) must also be defined.","ref":"ct_suite.html#c:end_per_group/2"},{"type":"callback","title":"ct_suite.end_per_suite/1","doc":"This function is called as the last test case in the suite. It is meant to be\nused for cleaning up after [`Module:init_per_suite/1`](`c:init_per_suite/1`).\n\nFor information on `save_config`, see section\n[Saving Configuration Data](dependencies_chapter.md#save_config) in the User's\nGuide.\n\nIf this function is defined, then\n[`Module:init_per_suite/1`](`c:init_per_suite/1`) must also be defined.","ref":"ct_suite.html#c:end_per_suite/1"},{"type":"callback","title":"ct_suite.end_per_testcase/2","doc":"This function is called after each test case, and can be used to clean up after\n[`Module:init_per_testcase/2`](`c:init_per_testcase/2`) and the test case.\n\nAny return value (besides `{fail, Reason}` and `{save_config, SaveConfig}`) is\nignored. By returning `{fail, Reason}`, `TestCase` is marked as faulty (even\nthough it was successful in the sense that it returned a value instead of\nterminating).\n\nFor information on `save_config`, see section\n[Saving Configuration Data](dependencies_chapter.md#save_config) in the User's\nGuide.\n\nIf this function is defined, then\n[`Module:init_per_testcase/2`](`c:init_per_testcase/2`) must also be defined.","ref":"ct_suite.html#c:end_per_testcase/2"},{"type":"callback","title":"ct_suite.group/1","doc":"The test case group information function. It is supposed to return a list of\ntagged tuples that specify various properties related to the execution of a test\ncase group (that is, its test cases and subgroups). Properties set by\n[`Module:group/1`](`c:group/1`) override properties with the same key that have\nbeen set previously by [`Module:suite/0`](`c:suite/0`).\n\nTag `timetrap` sets the maximum time that each test case is allowed to execute\n(including [`Module:init_per_testcase/2`](`c:init_per_testcase/2`) and\n[`Module:end_per_testcase/2`](`c:end_per_testcase/2`)). If the timetrap time is\nexceeded, the test case fails with reason `timetrap_timeout`. A `TimeFunc`\nfunction can be used to set a new timetrap by returning a `TimeVal`. It can also\nbe used to trigger a timetrap time-out by, at some point, returning a value\nother than a `TimeVal`. For details, see section\n[Timetrap Time-Outs](write_test_chapter.md#timetraps) in the User's Guide.\n\nTag `require` specifies configuration variables required by test cases (or\nconfiguration functions) in the suite. If the required configuration variables\nare not found in any of the configuration files, all test cases in this group\nare skipped. For details about the `require` functionality, see function\n[`ct:require/1,2`](`ct:require/1`).\n\nWith `userdata`, the user can specify any test case group related information\nthat can be read by calling `ct:userdata/2`.\n\nTag `ct_hooks` specifies the [Common Test Hooks](ct_hooks_chapter.md) to be run\nwith this suite.\n\nOther tuples than the ones defined are ignored.\n\nFor details about the test case group information function, see section\n[Group Information Function](write_test_chapter.md#group_info) in the User's\nGuide.","ref":"ct_suite.html#c:group/1"},{"type":"callback","title":"ct_suite.groups/0","doc":"Defines test case groups. For details, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups) in the User's Guide.","ref":"ct_suite.html#c:groups/0"},{"type":"callback","title":"ct_suite.init_per_group/2","doc":"This configuration function is called before execution of a test case group. It\ntypically contains initializations that are common for all test cases and\nsubgroups in the group, and that must only be performed once.\n\n`GroupName` is the name of the group, as specified in the group definition (see\n[`Module:groups/0`](`c:groups/0`)). Parameter `Config` is the configuration data\nthat can be modified. The return value of this function is given as `Config` to\nall test cases and subgroups in the group.\n\nIf `{skip, Reason}` is returned, all test cases in the group are skipped and\n`Reason` is printed in the overview log for the group.\n\nFor information about test case groups, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups) in the User's Guide.\n\nIf this function is defined, then\n[`Module:end_per_group/2`](`c:end_per_group/2`) must also be defined.","ref":"ct_suite.html#c:init_per_group/2"},{"type":"callback","title":"ct_suite.init_per_suite/1","doc":"This configuration function is called as the first function in the suite. It\ntypically contains initializations that are common for all test cases in the\nsuite, and that must only be done once.\n\nParameter `Config` is the configuration\ndata that can be modified. Whatever is returned from this function is specified\nas `Config` to all configuration functions and test cases in the suite.\n\nIf `{skip, Reason}` is returned, all test cases in the suite are skipped and\n`Reason` is printed in the overview log for the suite.\n\nFor information on `save_config` and `skip_and_save`, see section\n[Saving Configuration Data](dependencies_chapter.md#save_config) in the User's\nGuide.\n\nIf this function is defined, then\n[`Module:end_per_suite/1`](`c:end_per_suite/1`) must also be defined.","ref":"ct_suite.html#c:init_per_suite/1"},{"type":"callback","title":"ct_suite.init_per_testcase/2","doc":"This function is called before each test case.\n\nArgument `TestCase` is the test case name, and `Config` (list of key-value tuples)\nis the configuration data that can be modified. The `NewConfig` list returned from this\nfunction is given as `Config` to the test case.\n\nIf `{fail, Reason}` is returned, the test case is marked as failed without being executed.\n\nIf `{skip, Reason}` is returned, the test case is skipped and `Reason` is\nprinted in the overview log for the suite.\n\nIf this function is defined, then\n[`Module:end_per_testcase/2`](`c:end_per_testcase/2`) must also be defined.","ref":"ct_suite.html#c:init_per_testcase/2"},{"type":"callback","title":"ct_suite.suite/0","doc":"The test suite information function. Returns a list of tagged tuples specifying\nvarious properties related to the execution of this test suite (common for all\ntest cases in the suite).\n\nTag `timetrap` sets the maximum time that each test case is allowed to execute\n(including [`Module:init_per_testcase/2`](`c:init_per_testcase/2`) and\n[`Module:end_per_testcase/2`](`c:end_per_testcase/2`)). If the timetrap time is\nexceeded, the test case fails with reason `timetrap_timeout`. A `TimeFunc`\nfunction can be used to set a new timetrap by returning a `TimeVal`. It can also\nbe used to trigger a timetrap time-out by, at some point, returning a value\nother than a `TimeVal`. For details, see section\n[Timetrap Time-Outs](write_test_chapter.md#timetraps) in the User's Guide.\n\nTag `require` specifies configuration variables required by test cases (or\nconfiguration functions) in the suite. If the required configuration variables\nare not found in any of the configuration files, all test cases are skipped. For\ndetails about the `require` functionality, see function\n[`ct:require/1,2`](`ct:require/1`).\n\nWith `userdata`, the user can specify any test suite-related information, which\ncan be read by calling `ct:userdata/2`.\n\nTag `ct_hooks` specifies the [Common Test Hooks](ct_hooks_chapter.md) to be run\nwith this suite.\n\nOther tuples than the ones defined are ignored.\n\nFor details about the test suite information function, see section\n[Test Suite Information Function](write_test_chapter.md#suite) in the User's\nGuide.","ref":"ct_suite.html#c:suite/0"},{"type":"callback","title":"ct_suite.Testcase/0","doc":"The test case information function. It is supposed to return a list of tagged\ntuples that specify various properties related to the execution of this\nparticular test case. Properties set by [`Module:Testcase/0`](`c:'Testcase'/0`)\noverride properties set previously for the test case by\n[`Module:group/1`](`c:group/1`) or [`Module:suite/0`](`c:suite/0`).\n\nTag `timetrap` sets the maximum time that the test case is allowed to execute.\nIf the timetrap time is exceeded, the test case fails with reason\n`timetrap_timeout`. [`Module:init_per_testcase/2`](`c:init_per_testcase/2`) and\n[`Module:end_per_testcase/2`](`c:end_per_testcase/2`) are included in the\ntimetrap time. A `TimeFunc` function can be used to set a new timetrap by\nreturning a `TimeVal`. It can also be used to trigger a timetrap time-out by, at\nsome point, returning a value other than a `TimeVal`. For details, see section\n[Timetrap Time-Outs](write_test_chapter.md#timetraps) in the User's Guide.\n\nTag `require` specifies configuration variables that are required by the test\ncase (or [`init_per_testcase/2`](`c:init_per_testcase/2`) or\n[`end_per_testcase/2`](`c:end_per_testcase/2`)). If the required configuration\nvariables are not found in any of the configuration files, the test case is\nskipped. For details about the `require` functionality, see function\n[`ct:require/1,2`](`ct:require/1`).\n\nIf `timetrap` or `require` is not set, the default values specified by\n[`Module:suite/0`](`c:suite/0`) (or [`Module:group/1`](`c:group/1`)) are used.\n\nWith `userdata`, the user can specify any test case-related information that can\nbe read by calling `ct:userdata/3`.\n\nOther tuples than the ones defined are ignored.\n\nFor details about the test case information function, see section\n[Test Case Information Function](write_test_chapter.md#info_function) in the\nUser's Guide.","ref":"ct_suite.html#c:Testcase/0"},{"type":"callback","title":"ct_suite.Testcase/1","doc":"The implementation of a test case. Call the functions to test and check the\nresult. If something fails, ensure the function causes a runtime error or call\n[`ct:fail/1,2`](`ct:fail/1`) (which also causes the test case process to\nterminate).\n\nElements from the `Config` list can, for example, be read with\n`proplists:get_value/2` in STDLIB.\n\nPossible return values are:\n\n- **`{fail, Reason}`** - The test case is considered failed, and the `Reason`\n  will be logged.\n\n- **`{skip, Reason}`** - The test case is considered skipped, and the `Reason`\n  will be logged.\n\n- **`{comment, Comment}`** - The test case is considered successful, and the\n  `Comment` will be logged.\n\n- **`{save_config, SaveConfig}`** - The test case is considered successful, and\n  the `SaveConfig` will be stored in the `Config` (see section\n  [Saving Configuration Data](dependencies_chapter.md#save_config) in the User's\n  Guide).\n\n- **`{skip_and_save, Reason, SaveConfig}`** - The test case is considered\n  skipped, the `Reason` will be logged, and the `SaveConfig` will be stored in\n  the `Config` (see section\n  [Saving Configuration Data](dependencies_chapter.md#save_config) in the User's\n  Guide).\n\nIf the function returns any other term, the test case is considered successful.\n\nIf the test case function crashes, it is considered failed.\n\nFor details about test case implementation, see section\n[Test Cases](write_test_chapter.md#test_cases) in the User's Guide.","ref":"ct_suite.html#c:Testcase/1"},{"type":"type","title":"ct_suite.ct_config/0","doc":"The configuration data that can be modified.","ref":"ct_suite.html#t:ct_config/0"},{"type":"type","title":"ct_suite.ct_group_def/0","doc":"The test group definition, as returned by [`Module:groups/0`](`c:groups/0`).","ref":"ct_suite.html#t:ct_group_def/0"},{"type":"type","title":"ct_suite.ct_group_props/0","doc":"","ref":"ct_suite.html#t:ct_group_props/0"},{"type":"type","title":"ct_suite.ct_group_props_ref/0","doc":"","ref":"ct_suite.html#t:ct_group_props_ref/0"},{"type":"type","title":"ct_suite.ct_group_ref/0","doc":"","ref":"ct_suite.html#t:ct_group_ref/0"},{"type":"type","title":"ct_suite.ct_group_repeat_type/0","doc":"","ref":"ct_suite.html#t:ct_group_repeat_type/0"},{"type":"type","title":"ct_suite.ct_groupname/0","doc":"The name of the test group.","ref":"ct_suite.html#t:ct_groupname/0"},{"type":"type","title":"ct_suite.ct_hooks/0","doc":"","ref":"ct_suite.html#t:ct_hooks/0"},{"type":"type","title":"ct_suite.ct_info/0","doc":"The test suite information, as returned by [`Module:suite/0`](`c:suite/0`),\n[`Module:group/1`](`c:group/1`) and [`Module:Testcase/0`](`c:'Testcase'/0`).","ref":"ct_suite.html#t:ct_info/0"},{"type":"type","title":"ct_suite.ct_info_required/0","doc":"","ref":"ct_suite.html#t:ct_info_required/0"},{"type":"type","title":"ct_suite.ct_info_required_subkeys/0","doc":"","ref":"ct_suite.html#t:ct_info_required_subkeys/0"},{"type":"type","title":"ct_suite.ct_info_timetrap/0","doc":"","ref":"ct_suite.html#t:ct_info_timetrap/0"},{"type":"type","title":"ct_suite.ct_info_timetrap_fun/0","doc":"","ref":"ct_suite.html#t:ct_info_timetrap_fun/0"},{"type":"type","title":"ct_suite.ct_status/0","doc":"The status value for a nested subgroup.","ref":"ct_suite.html#t:ct_status/0"},{"type":"type","title":"ct_suite.ct_subgroups_def/0","doc":"","ref":"ct_suite.html#t:ct_subgroups_def/0"},{"type":"type","title":"ct_suite.ct_test_def/0","doc":"The test suite definition, as returned by [`Module:all/0`](`c:all/0`).","ref":"ct_suite.html#t:ct_test_def/0"},{"type":"type","title":"ct_suite.ct_test_repeat/0","doc":"","ref":"ct_suite.html#t:ct_test_repeat/0"},{"type":"type","title":"ct_suite.ct_testcase_ref/0","doc":"","ref":"ct_suite.html#t:ct_testcase_ref/0"},{"type":"type","title":"ct_suite.ct_testcase_repeat_prop/0","doc":"","ref":"ct_suite.html#t:ct_testcase_repeat_prop/0"},{"type":"type","title":"ct_suite.ct_testname/0","doc":"The name of the testcase function.","ref":"ct_suite.html#t:ct_testname/0"},{"type":"module","title":"ct_telnet","doc":"`Common Test` specific layer on top of Telnet client `ct_telnet_client.erl`.\n\nUse this module to set up Telnet connections, send commands, and perform string\nmatching on the result. For information about how to use `ct_telnet` and\nconfigure connections, specifically for UNIX hosts, see the `m:unix_telnet`\nmanual page.\n\nDefault values defined in `ct_telnet`:\n\n[](){: #Default_values }\n\n- Connection timeout (time to wait for connection) = 10 seconds\n- Command timeout (time to wait for a command to return) = 10 seconds\n- Max number of reconnection attempts = 3\n- Reconnection interval (time to wait in between reconnection attempts) = 5\n  seconds\n- Keep alive (sends NOP to the server every 8 sec if connection is idle) =\n  `true`\n- Polling limit (max number of times to poll to get a remaining string\n  terminated) = 0\n- Polling interval (sleep time between polls) = 1 second\n- The TCP_NODELAY option for the telnet socket is disabled (set to `false`) per\n  default\n\nThese parameters can be modified by the user with the following configuration\nterm:\n\n```erlang\n{telnet_settings, [{connect_timeout,Millisec},\n                   {command_timeout,Millisec},\n                   {reconnection_attempts,N},\n                   {reconnection_interval,Millisec},\n                   {keep_alive,Bool},\n                   {poll_limit,N},\n                   {poll_interval,Millisec},\n                   {tcp_nodelay,Bool}]}.\n```\n\n`Millisec = integer(), N = integer()`\n\nEnter the `telnet_settings` term in a configuration file included in the test\nand `ct_telnet` retrieves the information automatically.\n\n`keep_alive` can be specified per connection, if necessary. For details, see\n`m:unix_telnet`.","ref":"ct_telnet.html"},{"type":"module","title":"Logging - ct_telnet","doc":"[](){: #Logging }\n\nThe default logging behavior of `ct_telnet` is to print information about\nperformed operations, commands, and their corresponding results to the test case\nHTML log. The following is not printed to the HTML log: text strings sent from\nthe Telnet server that are not explicitly received by a `ct_telnet` function,\nsuch as [`expect/3`](`expect/3`). However, `ct_telnet` can be configured to use\na special purpose event handler, implemented in `ct_conn_log_h`, for logging\n_all_ Telnet traffic. To use this handler, install a `Common Test` hook named\n`cth_conn_log`. Example (using the test suite information function):\n\n```erlang\nsuite() ->\n    [{ct_hooks, [{cth_conn_log, [{conn_mod(),hook_options()}]}]}].\n```\n\n`conn_mod()` is the name of the `Common Test` module implementing the connection\nprotocol, that is, `ct_telnet`.\n\nThe `cth_conn_log` hook performs unformatted logging of Telnet data to a\nseparate text file. All Telnet communication is captured and printed, including\nany data sent from the server. The link to this text file is located at the top\nof the test case HTML log.\n\nBy default, data for all Telnet connections is logged in one common file (named\n`default`), which can get messy, for example, if multiple Telnet sessions are\nrunning in parallel. Therefore a separate log file can be created for each\nconnection. To configure this, use hook option `hosts` and list the names of the\nservers/connections to be used in the suite. The connections must be named for\nthis to work (see [`ct_telnet:open/1,2,3,4`](`open/1`)).\n\nHook option `log_type` can be used to change the `cth_conn_log` behavior. The\ndefault value of this option is `raw`, which results in the behavior described\nabove. If the value is set to `html`, all Telnet communication is printed to the\ntest case HTML log instead.\n\nAll `cth_conn_log` hook options described can also be specified in a\nconfiguration file with configuration variable `ct_conn_log`.\n\n_Example:_\n\n```erlang\n{ct_conn_log, [{ct_telnet,[{log_type,raw},\n                           {hosts,[key_or_name()]}]}]}\n```\n\n> #### Note {: .info }\n>\n> Hook options specified in a configuration file overwrite any hard-coded hook\n> options in the test suite.\n\n[](){: #Logging_example }\n\n_Logging Example:_\n\nThe following `ct_hooks` statement causes printing of Telnet traffic to separate\nlogs for the connections `server1` and `server2`. Traffic for any other\nconnections is logged in the default Telnet log.\n\n```erlang\nsuite() ->\n    [{ct_hooks,\n      [{cth_conn_log, [{ct_telnet,[{hosts,[server1,server2]}]}]}]}].\n```\n\nAs previously explained, this specification can also be provided by an entry\nlike the following in a configuration file:\n\n```erlang\n{ct_conn_log, [{ct_telnet,[{hosts,[server1,server2]}]}]}.\n```\n\nIn this case the `ct_hooks` statement in the test suite can look as follows:\n\n```erlang\nsuite() ->\n    [{ct_hooks, [{cth_conn_log, []}]}].\n```","ref":"ct_telnet.html#module-logging"},{"type":"module","title":"See Also - ct_telnet","doc":"`m:unix_telnet`","ref":"ct_telnet.html#module-see-also"},{"type":"function","title":"ct_telnet.close/1","doc":"Closes the Telnet connection and stops the process managing it.\n\nA connection can be associated with a target name and/or a handle. If\n`Connection` has no associated target name, it can only be closed with the\nhandle value (see [`ct_telnet:open/4`](`open/4`)).","ref":"ct_telnet.html#close/1"},{"type":"function","title":"ct_telnet.cmd/2","doc":"","ref":"ct_telnet.html#cmd/2"},{"type":"function","title":"ct_telnet.cmd/3","doc":"Sends a command through Telnet and waits for prompt.\n\nBy default, this function adds \"\\\\n\" to the end of the specified command. If\nthis is not desired, use option `{newline,false}`. This is necessary, for\nexample, when sending Telnet command sequences prefixed with character Interpret\nAs Command (IAC). Option `{newline,string()}` can also be used if a different\nline end than \"\\\\n\" is required, for instance `{newline,\"\\r\\n\"}`, to add both\ncarriage return and newline characters.\n\nOption `timeout` specifies how long the client must wait for prompt. If the time\nexpires, the function returns `{error,timeout}`. For information about the\ndefault value for the command timeout, see the\n[list of default values](`m:ct_telnet#Default_values`) in the beginning of this\nmodule.","ref":"ct_telnet.html#cmd/3"},{"type":"function","title":"ct_telnet.cmdf/3","doc":"","ref":"ct_telnet.html#cmdf/3"},{"type":"function","title":"ct_telnet.cmdf/4","doc":"Sends a Telnet command and waits for prompt (uses a format string and a list of\narguments to build the command).\n\nFor details, see [`ct_telnet:cmd/3`](`cmd/3`).","ref":"ct_telnet.html#cmdf/4"},{"type":"function","title":"ct_telnet.expect/2","doc":"","ref":"ct_telnet.html#expect/2"},{"type":"function","title":"ct_telnet.expect/3","doc":"Gets data from Telnet and waits for the expected pattern.\n\n`Pattern` can be a POSIX regular expression. The function returns when a pattern\nis successfully matched (at least one, in the case of multiple patterns).\n\n`RxMatch` is a list of matched strings. It looks as follows\n`[FullMatch, SubMatch1, SubMatch2, ...]`, where `FullMatch` is the string\nmatched by the whole regular expression, and `SubMatchN` is the string that\nmatched subexpression number `N`. Subexpressions are denoted with `'(' ')'` in\nthe regular expression.\n\nIf a `Tag` is specified, the returned `Match` also includes the matched `Tag`.\nOtherwise, only `RxMatch` is returned.\n\n_Options:_\n\n- **`idle_timeout`** - Indicates that the function must return if the Telnet\n  client is idle (that is, if no data is received) for more than `IdleTimeout`\n  milliseconds. Default time-out is 10 seconds.\n\n- **`total_timeout`** - Sets a time limit for the complete `expect` operation.\n  After `TotalTimeout` milliseconds, `{error,timeout}` is returned. Default is\n  `infinity` (that is, no time limit).\n\n- **`ignore_prompt | no_prompt_check`** - >The function returns when a prompt is\n  received, even if no pattern has yet been matched, and\n  `{error,{prompt,Prompt}}` is returned. However, this behavior can be modified\n  with option `ignore_prompt` or option `no_prompt_check`, which tells `expect`\n  to return only when a match is found or after a time-out.\n\n- **`ignore_prompt`** - `ct_telnet` ignores any prompt found. This option is\n  useful if data sent by the server can include a pattern matching prompt\n  `regexp` (as returned by `TargedMod:get_prompt_regexp/0`), but is not to not\n  cause the function to return.\n\n- **`no_prompt_check`** - `ct_telnet` does not search for a prompt at all. This\n  is useful if, for example, `Pattern` itself matches the prompt.\n\n- **`wait_for_prompt`** - Forces `ct_telnet` to wait until the prompt string is\n  received before returning (even if a pattern has already been matched). This\n  is equal to calling\n  [`expect(Conn, Patterns++[{prompt,Prompt}], [sequence|Opts])`](`expect/3`).\n  Notice that option `idle_timeout` and `total_timeout` can abort the operation\n  of waiting for prompt.\n\n- **`repeat | repeat, N`** - The pattern(s) must be matched multiple times. If\n  `N` is specified, the pattern(s) are matched `N` times, and the function\n  returns `HaltReason = done`. This option can be interrupted by one or more\n  `HaltPatterns`. `MatchList` is always returned, that is, a list of `Match`\n  instead of only one `Match`. Also `HaltReason` is returned.\n\n- **`sequence`** - All patterns must be matched in a sequence. A match is not\n  concluded until all patterns are matched. This option can be interrupted by\n  one or more `HaltPatterns`. `MatchList` is always returned, that is, a list of\n  `Match` instead of only one `Match`. Also `HaltReason` is returned.\n\n_Example 1:_\n\n```erlang\nexpect(Connection,[{abc,\"ABC\"},{xyz,\"XYZ\"}],[sequence,{halt,[{nnn,\"NNN\"}]}])\n```\n\nFirst this tries to match `\"ABC\"`, and then `\"XYZ\"`, but if `\"NNN\"` appears, the\nfunction returns `{error,{nnn,[\"NNN\"]}}`. If both `\"ABC\"` and `\"XYZ\"` are\nmatched, the function returns `{ok,[AbcMatch,XyzMatch]}`.\n\n_Example 2:_\n\n```erlang\nexpect(Connection,[{abc,\"ABC\"},{xyz,\"XYZ\"}],[{repeat,2},{halt,[{nnn,\"NNN\"}]}])\n```\n\nThis tries to match `\"ABC\"` or `\"XYZ\"` twice. If `\"NNN\"` appears, the function\nreturns `HaltReason = {nnn,[\"NNN\"]}`.\n\nOptions `repeat` and `sequence` can be combined to match a sequence multiple\ntimes.","ref":"ct_telnet.html#expect/3"},{"type":"function","title":"ct_telnet.get_data/1","doc":"Gets all data received by the Telnet client since the last command was sent.\nOnly newline-terminated strings are returned. If the last received string has\nnot yet been terminated, the connection can be polled automatically until the\nstring is complete.\n\nThe polling feature is controlled by the configuration values `poll_limit` and\n`poll_interval` and is by default disabled. This means that the function\nimmediately returns all complete strings received and saves a remaining\nnon-terminated string for a later `get_data` call.","ref":"ct_telnet.html#get_data/1"},{"type":"function","title":"ct_telnet.open/1","doc":"","ref":"ct_telnet.html#open/1"},{"type":"function","title":"ct_telnet.open/2","doc":"Opens a Telnet connection to the specified target host.","ref":"ct_telnet.html#open/2"},{"type":"function","title":"ct_telnet.open/3","doc":"","ref":"ct_telnet.html#open/3"},{"type":"function","title":"ct_telnet.open/4","doc":"Opens a Telnet connection to the specified target host.\n\nThe target data must exist in a configuration file. The connection can be\nassociated with `Name` and/or the returned `Handle`. To allocate a name for the\ntarget, use one of the following alternatives:\n\n- `ct:require/2` in a test case\n- A `require` statement in the suite information function (`suite/0`)\n- A `require` statement in a test case information function\n\nIf you want the connection to be associated with `Handle` only (if you, for\nexample, need to open multiple connections to a host), use `Key`, the\nconfiguration variable name, to specify the target. Notice that a connection\nwithout an associated target name can only be closed with the `Handle` value.\n\n`TargetMod` is a module that exports the functions\n`connect(Ip, Port, KeepAlive, Extra)` and `get_prompt_regexp()` for the\nspecified `TargetType` (for example, `unix_telnet`).\n\nSee also `ct:require/2`.","ref":"ct_telnet.html#open/4"},{"type":"function","title":"ct_telnet.send/2","doc":"","ref":"ct_telnet.html#send/2"},{"type":"function","title":"ct_telnet.send/3","doc":"Sends a Telnet command and returns immediately.\n\nBy default, this function adds \"\\\\n\" to the end of the specified command. If\nthis is not desired, option `{newline,false}` can be used. This is necessary,\nfor example, when sending Telnet command sequences prefixed with character\nInterpret As Command (IAC). Option `{newline,string()}` can also be used if a\ndifferent line end than \"\\\\n\" is required, for instance `{newline,\"\\r\\n\"}`, to\nadd both carriage return and newline characters.\n\nThe resulting output from the command can be read with\n[`ct_telnet:get_data/2`](`get_data/1`) or [`ct_telnet:expect/2,3`](`expect/2`).","ref":"ct_telnet.html#send/3"},{"type":"function","title":"ct_telnet.sendf/3","doc":"","ref":"ct_telnet.html#sendf/3"},{"type":"function","title":"ct_telnet.sendf/4","doc":"Sends a Telnet command and returns immediately (uses a format string and a list\nof arguments to build the command).\n\nFor details, see [`ct_telnet:send/3`](`send/3`).","ref":"ct_telnet.html#sendf/4"},{"type":"type","title":"ct_telnet.connection/0","doc":"Reference to opened Telnet connection associated to either a `handle` or `target_name`.","ref":"ct_telnet.html#t:connection/0"},{"type":"type","title":"ct_telnet.connection_type/0","doc":"Telnet connection_type, valid values: 'telnet' | 'ts1' | 'ts2'.","ref":"ct_telnet.html#t:connection_type/0"},{"type":"type","title":"ct_telnet.handle/0","doc":"Handle for a specific Telnet connection, see module `m:ct`.","ref":"ct_telnet.html#t:handle/0"},{"type":"type","title":"ct_telnet.newline_option/0","doc":"See `cmd/3` for explanation.","ref":"ct_telnet.html#t:newline_option/0"},{"type":"type","title":"ct_telnet.prompt_regexp/0","doc":"Regular expression matching all possible prompts for a specific target type.\n`regexp` must not have any groups, that is, when matching, `re:run/3` (in\nSTDLIB) must return a list with one single element.","ref":"ct_telnet.html#t:prompt_regexp/0"},{"type":"module","title":"ct_testspec","doc":"Parsing of test specifications for `Common Test`.\n\nThis module exports help functions for parsing of test specifications.","ref":"ct_testspec.html"},{"type":"function","title":"ct_testspec.get_tests/1","doc":"Parse the given test specification files and return the tests to run and skip.\n\n[](){: #add_nodes-1 }\n\nIf `SpecsIn=[Spec1,Spec2,...]`, separate tests will be created per\nspecification. If `SpecsIn=[[Spec1,Spec2,...]]`, all specifications will be\nmerge into one test.\n\nFor each test, a `{Specs,Tests}` element is returned, where `Specs` is a list of\nall included test specifications, and `Tests` specifies actual tests to run/skip\nper node.","ref":"ct_testspec.html#get_tests/1"},{"type":"module","title":"unix_telnet","doc":"Callback module for `m:ct_telnet`, for connecting to a Telnet server on a UNIX\nhost.\n\nIt requires the following entry in the configuration file:\n\n```erlang\n{unix,[{telnet,HostNameOrIpAddress},\n       {port,PortNum},                 % optional\n       {username,UserName},\n       {password,Password},\n       {keep_alive,Bool}]}.            % optional\n```\n\nTo communicate through Telnet to the host specified by `HostNameOrIpAddress`,\nuse the interface functions in `m:ct_telnet`, for example, `open(Name)` and\n`cmd(Name,Cmd)`.\n\n`Name` is the name you allocated to the Unix host in your `require` statement,\nfor example:\n\n```erlang\nsuite() -> [{require,Name,{unix,[telnet]}}].\n```\n\nor\n\n```erlang\nct:require(Name,{unix,[telnet]}).\n```\n\nThe \"keep alive\" activity (that is, that `Common Test` sends NOP to the server\nevery 10 seconds if the connection is idle) can be enabled or disabled for one\nparticular connection as described here. It can be disabled for all connections\nusing `telnet_settings` (see `m:ct_telnet`).\n\nThe `{port,PortNum}` tuple is optional and if omitted, default Telnet port 23 is\nused. Also the `keep_alive` tuple is optional, and the value default to `true`\n(enabled).","ref":"unix_telnet.html"},{"type":"module","title":"See Also - unix_telnet","doc":"`m:ct`, `m:ct_telnet`","ref":"unix_telnet.html#module-see-also"},{"type":"function","title":"unix_telnet.connect/7","doc":"Callback for `ct_telnet.erl`.\n\n[](){: #connect-6 }\n\nSetup Telnet connection to a Unix host.","ref":"unix_telnet.html#connect/7"},{"type":"function","title":"unix_telnet.get_prompt_regexp/0","doc":"Callback for `ct_telnet.erl`.\n\nReturns a suitable `regexp` string matching common prompts for users on Unix\nhosts.","ref":"unix_telnet.html#get_prompt_regexp/0"},{"type":"extras","title":"Common Test Application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Test Application\n\nA framework for automated testing of any target nodes.","ref":"common_test_app.html"},{"type":"extras","title":"Description - Common Test Application","doc":"The `Common Test` framework is an environment for implementing and performing\nautomatic and semi-automatic execution of test cases.\n\nIn brief, `Common Test` supports:\n\n- Automated execution of test suites (sets of test cases)\n- Logging of events during execution\n- HTML presentation of test suite results\n- HTML presentation of test suite code\n- Support functions for test suite authors\n- Step-by-step execution of test cases","ref":"common_test_app.html#description"},{"type":"extras","title":"Common Test Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Test Release Notes","ref":"notes.html"},{"type":"extras","title":"Common_Test 1.27.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-27-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- With this change, jquery and tablesorter licenses are added to COPYRIGHT file.\n  Also tablesorter is updated to version 2.32.\n\n  Own Id: OTP-19265 Aux Id: [PR-8876]\n\n[PR-8876]: https://github.com/erlang/otp/pull/8876","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.27.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-27-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- With this change, HTML reports include jQuery version 3.7.1.\n\n  Own Id: OTP-19252 Aux Id: [PR-8858]\n\n[PR-8858]: https://github.com/erlang/otp/pull/8858","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.27.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-27-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Groups with empty list specifying groups and test cases no longer crash execution.\n\n  Own Id: OTP-19032 Aux Id: [PR-7919], [GH-4362]\n\n- The Common_Test documentation and type specs have been polished.\n\n  Own Id: OTP-19148 Aux Id: [PR-8516]\n\n- Man pages are now available for `erl`, `erlc`, `dialyzer`, and all other programs that are included in Erlang/OTP.\n\n  Own Id: OTP-19201 Aux Id: [PR-8740]\n\n[PR-7919]: https://github.com/erlang/otp/pull/7919\n[GH-4362]: https://github.com/erlang/otp/issues/4362\n[PR-8516]: https://github.com/erlang/otp/pull/8516\n[PR-8740]: https://github.com/erlang/otp/pull/8740","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.27 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-27"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Calls to `ct:capture_start/0` and `ct:capture_stop/0` are now synchronous to ensure that all output is captured.\n\n  Own Id: OTP-18658 Aux Id: [PR-7380]\n\n- The order in which multiple hooks are executed can now be reversed after each config function. See [CTH Execution Order](`e:common_test:ct_hooks_chapter.md#cth_execution_order`).\n\n  Own Id: OTP-18682 Aux Id: [GH-7397], [PR-7496], ERIERL-43\n\n- The default CSS will now include a basic dark mode handling if it is preferred by the browser.\n\n  Own Id: OTP-18761 Aux Id: [PR-7428]\n\n- `-callback` attributes have been added to `m:ct_suite` and `m:ct_hooks`.\n\n  Own Id: OTP-18781 Aux Id: [PR-7701]\n\n- The built-in [cth_log_redirect](`e:common_test:ct_hooks_chapter.md#built-in-cths`) hook can now be configured to replace default logger reports in terminal with HTML logs.\n\n  Own Id: OTP-18875 Aux Id: [PR-7891]\n\n- Error handling for the `m:ct_property_test` framework has been enhanced.\n\n  Own Id: OTP-18881 Aux Id: [PR-7824]\n\n- Enhance test case documentation, making it clear how a test case can be failed.\n\n  Own Id: OTP-18892 Aux Id: [PR-7869]\n\n- The failing line in the test source code is now colored to make it easier to find on the screen.\n\n  Own Id: OTP-18898 Aux Id: [PR-7917]\n\n- Function specifications and types have been added to all public API functions.\n\n  Own Id: OTP-18913\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- The suite execution elapsed time is now included in the index page.\n\n  Own Id: OTP-18981 Aux Id: [GH-7972], [PR-8112]\n\n[PR-7380]: https://github.com/erlang/otp/pull/7380\n[GH-7397]: https://github.com/erlang/otp/issues/7397\n[PR-7496]: https://github.com/erlang/otp/pull/7496\n[PR-7428]: https://github.com/erlang/otp/pull/7428\n[PR-7701]: https://github.com/erlang/otp/pull/7701\n[PR-7891]: https://github.com/erlang/otp/pull/7891\n[PR-7824]: https://github.com/erlang/otp/pull/7824\n[PR-7869]: https://github.com/erlang/otp/pull/7869\n[PR-7917]: https://github.com/erlang/otp/pull/7917\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[GH-7972]: https://github.com/erlang/otp/issues/7972\n[PR-8112]: https://github.com/erlang/otp/pull/8112","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.26.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-26-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* With this change, the last column in common_test testcase log file is modified to now show the total sum of each time in the table rows, and Elapsed Time which is a clock time spent to run above functions. The Elapsed Time is the same time that was previously a total.\n\n  Own Id: OTP-18960","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.26.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-26-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* Fix how CT finds Erlang/OTP releases for compatability testing. This functionality is only used to test Erlang/OTP.\n\n  Own Id: OTP-18932","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.26 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-26"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- With this change, common_test returns an error when suite with a badly defined\n  group is executed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18728 Aux Id: PR-7487, PR-7674\n\n- With this change, stylesheet option is applied to all HTML report pages.\n\n  Own Id: OTP-18760\n\n- Update all   html tags to be   instead.\n\n  Own Id: OTP-18799 Aux Id: PR-7695","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- This change fixes docs, so that historically deprecated ?config macro is no\n  longer recommended to be used.\n\n  Own Id: OTP-18858 Aux Id: PR-7825","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.25.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-25-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- With this change, ct_hooks manual refers to CTH execution order section in\n  user guide.\n\n  Own Id: OTP-14480 Aux Id: ERIERL-43, OTP-11894, PR-7455\n\n- With this change, Config data from pre_end_per_testcase hook is delivered to\n  post_end_per_testcase callback in case of testcase timetrap or linked process\n  crash.\n\n  Own Id: OTP-18579 Aux Id: GH-7119\n\n- With this change, remaining references to not supported vts tool in ct_run are\n  removed (mainly relates to docs and ct_run help message).\n\n  Own Id: OTP-18615 Aux Id: PR-7234\n\n- With this change, prompt search functionality in ct_telnet handles unicode\n  input.\n\n  Own Id: OTP-18664 Aux Id: ERIERL-959\n\n- Expanded the documentation about how to use the `standard_io`,\n  `standard_error` and `user` I/O devices.\n\n  Added the types [`io:standard_io/0`](`t:io:standard_io/0`),\n  `io:standard:error/0` and [`io:user/0`](`t:io:user/0`).\n\n  Own Id: OTP-18676 Aux Id: PR-7473 GH-7459","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.25 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-25"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- This change improves Common Test docs (CT hook example code) and adds Emacs\n  skeleton with hook code.\n\n  Own Id: OTP-18377 Aux Id: PR-6437","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Updated common_test with a more robust way to fetch old releases, while\n  ignoring the current release.\n\n  Own Id: OTP-18259 Aux Id: PR-5924\n\n- \\- re-write the XML `ct` module documentation into erlang types to make\n  Dialyzer able to catch more precise errors\n\n  Own Id: OTP-18340\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.24.0.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-24-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* With this change, the last column in common_test testcase log file is modified to now show the total sum of each time in the table rows, and Elapsed Time which is a clock time spent to run above functions. The Elapsed Time is the same time that was previously a total.\n\n  Own Id: OTP-18960","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.24.0.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-24-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* Fix how CT finds Erlang/OTP releases for compatability testing. This functionality is only used to test Erlang/OTP.\n\n  Own Id: OTP-18932","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.24.0.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-24-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- With this change, prompt search functionality in ct_telnet handles unicode\n  input.\n\n  Own Id: OTP-18664 Aux Id: ERIERL-959","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.24 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-24"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Renamed undocumented macro `CT_PEER/3` to `CT_PEER_REL/3`.\n\n  Own Id: OTP-18460","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.23.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-23-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Change timeout to infinity for gen_server calls in cth_log_redirect\n\n  Own Id: OTP-18363 Aux Id: ERIERL-879","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.23.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-23-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Fix starting of peer nodes on old releases when the compile server was active\n  and the current Erlang installation contained non-latin1 characters in its\n  path.\n\n  Own Id: OTP-18255 Aux Id: PR-6314","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.23.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-23-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Fix cth_surefire to handle when a suite is not compiled with `debug_info`.\n  This bug has been present since Erlang/OTP 25.0.\n\n  Own Id: OTP-18208 Aux Id: ERIERL-852 PR-6229","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Common Test now preserves stack traces for throws.\n\n  Own Id: OTP-18138 Aux Id: GH-5719, PR-6029","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.23 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-23"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Fix bug when running parallel test cases and together with one or more ct\n  hooks that would cause the hook lock process to crash and produce printouts in\n  the ct logs.\n\n  Own Id: OTP-17881 Aux Id: PR-5581","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967\n\n- Remove unused and undocumented tracer node functionality.\n\n  Own Id: OTP-17676 Aux Id: PR-5021\n\n- The new module `peer` supersedes the `slave` module. The `slave` module is now\n  deprecated and will be removed in OTP 27.\n\n  `peer` contains an extended and more robust API for starting erlang nodes.\n\n  Own Id: OTP-17720 Aux Id: PR-5162\n\n- The cth_surefire ct hook has been updated to include the file and line number\n  of the executed test case in the xml output.\n\n  The performance of the hook has also been improved greatly for test runs with\n  many test cases.\n\n  Own Id: OTP-17882 Aux Id: PR-5581","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.22.1.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-22-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* With this change, the last column in common_test testcase log file is modified to now show the total sum of each time in the table rows, and Elapsed Time which is a clock time spent to run above functions. The Elapsed Time is the same time that was previously a total.\n\n  Own Id: OTP-18960","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.22.1.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-22-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"* Fix how CT finds Erlang/OTP releases for compatability testing. This functionality is only used to test Erlang/OTP.\n\n  Own Id: OTP-18932","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.22.1.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-22-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Change timeout to infinity for gen_server calls in cth_log_redirect\n\n  Own Id: OTP-18363 Aux Id: ERIERL-879","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.22.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-22-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- OTP internal test fix.\n\n  Own Id: OTP-17888","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.22 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-22"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Before this change, group handling grammar was ambiguous and also group paths\n  did not support test specs.\n\n  Own Id: OTP-17664 Aux Id: GH-5088, PR-5242\n\n- Before this change, it was not possible to link to a particular header entry\n  in Common Test log. Change adds right aligned anchor icons in HTML test logs.\n\n  Own Id: OTP-17790 Aux Id: PR-5375","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.21 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-21"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Float allowed as multiply_timetraps parameter.\n\n  Own Id: OTP-17413 Aux Id: PR-4767\n\n- Remove usage of legacy API macro and functions.\n\n  Own Id: OTP-17632 Aux Id: PR-5022","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.20.5 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- An incoming NETCONF notification received before a call to\n  ct_netconfc:create_subscription/\\* caused the connection process to fail with\n  badarg. Unexpected notifications are now logged in the same way as other\n  unexpected messages.\n\n  Own Id: OTP-17506","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Add 'receiver' option to ct_netconfc\n\n  To allow a destination for incoming NETCONF notifications to be specified at\n  sessions creation. Previously, a caller of create_subscription/\\* became the\n  destination, but RFC 5277 create-subscription is no longer the only way in\n  which NETCONF notifications can be ordered.\n\n  Own Id: OTP-17509","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.20.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.20.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The option `release_shell` could crash when used together with the `spec`\n  option.\n\n  Own Id: OTP-16940 Aux Id: ERL-1335","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- Fixed warnings in code matching on underscore prefixed variables.\n\n  Own Id: OTP-17385 Aux Id: OTP-17123","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.20.2.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- OTP internal test fix.\n\n  Own Id: OTP-17888","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.20.2.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- An incoming NETCONF notification received before a call to\n  ct_netconfc:create_subscription/\\* caused the connection process to fail with\n  badarg. Unexpected notifications are now logged in the same way as other\n  unexpected messages.\n\n  Own Id: OTP-17506","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Add 'receiver' option to ct_netconfc\n\n  To allow a destination for incoming NETCONF notifications to be specified at\n  sessions creation. Previously, a caller of create_subscription/\\* became the\n  destination, but RFC 5277 create-subscription is no longer the only way in\n  which NETCONF notifications can be ordered.\n\n  Own Id: OTP-17509","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.20.2.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.20.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Before this change Config leaked between test groups in case of a subgroup was\n  skipped (GH-3480).\n\n  Own Id: OTP-17347 Aux Id: GH-3480,ERL-1439","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.20.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- A race condition could cause ct_netconfc:open/_ to return a dysfunctional\n  handle, resulting in errors when invoking other api functions on it, and\n  making it impossible to establish a new connection to the server in question.\n  Similar symptoms were possible with open/_ in modules ct_ssh and ct_telnet.\n\n  Internal messages from common_test processes could be left in the caller's\n  message queue after a timeout when invoking call/\\* in modules ct_netconfc and\n  ct_ssh. An internal process used by module ct_telnet could leak memory due to\n  stray messages.\n\n  Calls to ct_telnet:open/\\* and ct_telnet:get_data/1 could hang indefinitely if\n  the TCP connection to the server was lost.\n\n  Own Id: OTP-17328 Aux Id: ERIERL-631","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.20 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-20"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Various address sanitizer support.\n\n  Own Id: OTP-16959 Aux Id: PR-2965","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.19.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-19-1"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Add behaviour for test suites\n\n  Own Id: OTP-17070","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.19 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-19"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The function `ct_property_test:init_tool/1` is added for the cases when the\n  user does not want ct_property_test to compile properties. init_tool/1 can be\n  used to set the property_test_tool config value.\n\n  Own Id: OTP-16029 Aux Id: PR-2145\n\n- The built-in Common Test Hook, `cth_log_redirect`, has been updated to use the\n  system `default` Logger handler's configuration instead of its own. See the\n  section on [Built-in Hooks](ct_hooks_chapter.md#built-in-cths) in the Common\n  Test User's Guide.\n\n  Own Id: OTP-16273\n\n- Calls of deprecated functions in the\n  [Old Crypto API](`e:crypto:new_api.md#the-old-api`) are replaced by calls of\n  their [substitutions](`e:crypto:new_api.md#the-new-api`).\n\n  Own Id: OTP-16346","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.18.2.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-18-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- OTP internal test fix.\n\n  Own Id: OTP-17888","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.18.2.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-18-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.18.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-18-2"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Document incl_apps cover option\n\n  Own Id: OTP-16039 Aux Id: ERL-795\n\n- The `ct_property_test` has now a report function for results of stateful\n  testing.\n\n  Own Id: OTP-16340\n\n- Don't hide error reasons from user\n\n  Own Id: OTP-16364 Aux Id: PR-2480","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.18.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-18-1"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The ct_property_test logging is improved.\n\n  Own Id: OTP-16287","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.18 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If a ct hook is installed in the `suite/0` function in a test suite, then the\n  hook's `terminate/1` function would be called several times without it's\n  `init/2` function being called first. This is now corrected.\n\n  Own Id: OTP-15863 Aux Id: ERIERL-370\n\n- If `init_per_testcase` fails, the test itself is skipped. According to the\n  documentation, it should be possible to change the result to failed in a hook\n  function. The only available hook function in this case is\n  `post_init_per_testcase`, but changing the return value there did not affect\n  the test case result. This is now corrected.\n\n  Own Id: OTP-15869 Aux Id: ERIERL-350","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Add ct_netconfc support for NETCONF 1.1 (RFC 6241). The 1.1 base capability\n  can be sent in hello, and RFC 6242 chunk framing is applied when both client\n  and server advertise 1.1 support.\n\n  Own Id: OTP-15789\n\n- Correct lib_dir paths in common_tests opaque data structure that is passed to\n  ct_release_test callback modules in functions upgrade_init/2,\n  upgrade_upgraded/2 and upgrade_downgraded/2. The incorrect paths may cause\n  confusion when debugging although it will not cause any incorrect behavior on\n  the part of common_test as it is currently not used.\n\n  Own Id: OTP-15934","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.17.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-17-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Use `ssh` instead of `rsh` as the default remote shell.\n\n  Own Id: OTP-15633 Aux Id: PR-1787","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.17.2.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-17-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If a ct hook is installed in the `suite/0` function in a test suite, then the\n  hook's `terminate/1` function would be called several times without it's\n  `init/2` function being called first. This is now corrected.\n\n  Own Id: OTP-15863 Aux Id: ERIERL-370\n\n- If `init_per_testcase` fails, the test itself is skipped. According to the\n  documentation, it should be possible to change the result to failed in a hook\n  function. The only available hook function in this case is\n  `post_init_per_testcase`, but changing the return value there did not affect\n  the test case result. This is now corrected.\n\n  Own Id: OTP-15869 Aux Id: ERIERL-350","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.17.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-17-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The test result when a hook function fails is in general the same as if the\n  function that the hook is associated with fails. For example, if\n  `post_init_per_testcase` fails the result is that the test case is skipped, as\n  is the case when `init_per_testcase` fails.This, however, was earlier not true\n  for timetrap timeouts or other error situations where the process running the\n  hook function was killed. This is now corrected, so the error handling should\n  be the same no matter how the hook function fails.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15717 Aux Id: ERIERL-334\n\n- In some rare cases, when two common_test nodes used the same log directory, a\n  timing problem could occur which caused common_test to crash because it's log\n  cache file was unexpectedly empty. This is now corrected.\n\n  Own Id: OTP-15758 Aux Id: ERIERL-342","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Two new common_test hook functions are introduced:\n\n  `post_groups/2`, which is called after `Suite:groups/0`  \n  `post_all/3`, which is called after `Suite:all/0`\n\n  These functions allow modifying the return values from the `groups/0` and\n  `all/0` functions, respectively.\n\n  A new term, `{testcase,TestCase,RepeatProperties}` is now also allowed in the\n  return from `all/0`. This can be used for repeating a single test case a\n  specific number of times, or until it fails or succeeds once.\n\n  Own Id: OTP-14746 Aux Id: ERIERL-143","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.17.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-17-1"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- OTP internal test improvements.\n\n  Own Id: OTP-15716","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.17 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- A bug caused `ct:encrypt_config_file/3` and `ct:decrypt_config_file/3` to fail\n  with `badmatch` if input parameter `KeyOrFile` was `{key,string()}`. This is\n  now corrected.\n\n  Own Id: OTP-15540\n\n- The status of a test case which failed with timetrap timeout in\n  `end_per_testcase` could not be modified by returning `{fail,Reason}` from a\n  `post_end_per_testcase` hook function. This is now corrected.\n\n  Own Id: OTP-15584 Aux Id: ERIERL-282","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new variant of the `newline` option to `ct_telnet:cmd/3` and\n  `ct_telnet:send/3` is added, which allows to specify a string to append as\n  newline indicator on a command. By default, the value is \"\\\\n\", but in some\n  cases it is required to be \"\\\\r\\\\n\", which this option allows.\n\n  A faulty regular expression given as parameter to `ct_telnet:expect/2,3` would\n  earlier crash and look like an internal error in common_test. A better error\n  indication is now given, but the test case will still fail.\n\n  Own Id: OTP-15229 Aux Id: ERIERL-203\n\n- Since the yang RFC allows more than one top element of config data in an\n  `edit-config` element, `ct_netconfc:edit_config/3,4,5` can now take a list of\n  XML elements.\n\n  Own Id: OTP-15298","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.16.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-16-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The Logger handler cth_log_redirect earlier called the report callback\n  (report_cb) before calling the logger formatter. In some cases this would\n  fail, since cth_log_redirect could not handle report callbacks with two\n  arguments. This is now corrected, so only the formatter will call the report\n  callback.\n\n  Own Id: OTP-15307","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.16 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-16"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Use the compiler option `nowarn_export_all` to disable `export_all` warnings\n  when automatically compiling test suites.\n\n  Own Id: OTP-14810\n\n- Use uri_string module instead of http_uri.\n\n  Own Id: OTP-14902","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.15.4.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4-4"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The ct_property_test logging is improved.\n\n  Own Id: OTP-16287","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.15.4.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If a ct hook is installed in the `suite/0` function in a test suite, then the\n  hook's `terminate/1` function would be called several times without it's\n  `init/2` function being called first. This is now corrected.\n\n  Own Id: OTP-15863 Aux Id: ERIERL-370\n\n- If `init_per_testcase` fails, the test itself is skipped. According to the\n  documentation, it should be possible to change the result to failed in a hook\n  function. The only available hook function in this case is\n  `post_init_per_testcase`, but changing the return value there did not affect\n  the test case result. This is now corrected.\n\n  Own Id: OTP-15869 Aux Id: ERIERL-350","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.15.4.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The test result when a hook function fails is in general the same as if the\n  function that the hook is associated with fails. For example, if\n  `post_init_per_testcase` fails the result is that the test case is skipped, as\n  is the case when `init_per_testcase` fails.This, however, was earlier not true\n  for timetrap timeouts or other error situations where the process running the\n  hook function was killed. This is now corrected, so the error handling should\n  be the same no matter how the hook function fails.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15717 Aux Id: ERIERL-334\n\n- In some rare cases, when two common_test nodes used the same log directory, a\n  timing problem could occur which caused common_test to crash because it's log\n  cache file was unexpectedly empty. This is now corrected.\n\n  Own Id: OTP-15758 Aux Id: ERIERL-342","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Two new common_test hook functions are introduced:\n\n  `post_groups/2`, which is called after `Suite:groups/0`  \n  `post_all/3`, which is called after `Suite:all/0`\n\n  These functions allow modifying the return values from the `groups/0` and\n  `all/0` functions, respectively.\n\n  A new term, `{testcase,TestCase,RepeatProperties}` is now also allowed in the\n  return from `all/0`. This can be used for repeating a single test case a\n  specific number of times, or until it fails or succeeds once.\n\n  Own Id: OTP-14746 Aux Id: ERIERL-143\n\n- OTP internal test improvements.\n\n  Own Id: OTP-15716","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.15.4.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The status of a test case which failed with timetrap timeout in\n  `end_per_testcase` could not be modified by returning `{fail,Reason}` from a\n  `post_end_per_testcase` hook function. This is now corrected.\n\n  Own Id: OTP-15584 Aux Id: ERIERL-282","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.15.4.0.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The status of a test case which failed with timetrap timeout in\n  `end_per_testcase` could not be modified by returning `{fail,Reason}` from a\n  `post_end_per_testcase` hook function. This is now corrected.\n\n  Own Id: OTP-15584 Aux Id: ERIERL-282","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.15.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Fixed problem with 'skip_groups' in combination with 'all suites' option in\n  test specification.\n\n  Own Id: OTP-14953","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.15.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-3"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new function, `ct:remaining_test_procs/0`, returns the identity of test- and\n  group leader processes that are still running at the time of the call.\n\n  Own Id: OTP-13832\n\n- A \"latest test result\" link is now displayed in the footer of each test index\n  page, which performs a jump to the most recently generated test index. This is\n  useful for making quick comparisons of results between test runs without\n  having to traverse the log file tree.\n\n  Own Id: OTP-14281","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.15.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-2"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- General Unicode improvements.\n\n  Own Id: OTP-14462","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.15.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- In OTP-20.0, the behavior of c, make, and ct_make was changed so that in some\n  cases the beam files by default would be written to the directory where the\n  source files were found. This is now changed back to the old behavior so beam\n  files are by default written to current directory.\n\n  Own Id: OTP-14489 Aux Id: ERL-438","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.15 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Errors in the documentation for user HTML stylesheets have been corrected.\n\n  Own Id: OTP-14332 Aux Id: seq13299\n\n- Internal code change: Calls to `catch` followed by a call to\n  `erlang:get_stacktrace/0` has been rewritten to use `try` instead of `catch`\n  to make the code future-proof.\n\n  Own Id: OTP-14400","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The `ct_slave` modules now handle nodenames in the same way as nodenames\n  passed to `-sname`. That means `ct_slave:start('b@127.0.0.1').` will now work.\n\n  Own Id: OTP-13806\n\n- Added the new option, `keep_logs`. If setting the value for this option to an\n  integer, N, common_test will remove all ct_run.\\* directories in the current\n  log directory, except the N newest.\n\n  Own Id: OTP-14179\n\n- The existing `ct_netconfc:open/1,2` opens an SSH connection with one SSH\n  channel realizing one Netconf session. To allow testing of multiple sessions\n  over the same SSH connection, the following functions are added to\n  `ct_netconfc`:\n\n  \\* `connect/1,2` \\- establish an SSH connection _ `disconnect/1` \\- close the\n  given SSH connection _ `session/1,2,3` \\- open an ssh channel on the given\n  connection and send 'hello' to start a Netconf session\n\n  Own Id: OTP-14284\n\n- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285\n\n- The function ct_ssh:shell/2,3 is added.\n\n  Own Id: OTP-14415 Aux Id: seq13315","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.14 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The following corrections and improvements are done in the common_test hook\n  handling:\n\n  - An extra argument, `Suite`, is added as the first argument to each of the\n    following hook callback functions:\n\n    - `pre_init_per_group`\n    - `post_init_per_group`\n    - `pre_end_per_group`\n    - `post_end_per_group`\n    - `pre_init_per_testcase`\n    - `post_init_per_testcase`\n    - `pre_end_per_testcase`\n    - `post_end_per_testcase`\n    - `on_tc_fail`\n    - `on_tc_skip`\n\n    For backwards compatibility, if the new function is not exported from a hook\n    callback module, `common_test` will fall back to the old interface and call\n    the function without the `Suite` argument.\n\n  - If either `init_per_suite` or `end_per_suite` exists, but not the other,\n    then the non-existing function will be reported as failed with reason\n    `undef` in the test log. The same goes for `init/end_per_group`. This has\n    always been a requirement according to the user's guide, but now\n    `common_test` is more explicit in the report.\n  - If `init_per_suite` was exported from a test suite, but not `end_per_suite`,\n    then `pre/post_end_per_suite` was called with `Suite=ct_framework` instead\n    of the correct suite name. This is now corrected.\n  - If `end_per_group` was exported from a suite, but not `init_per_group`, then\n    `end_per_group` was never called. This is now corrected.\n  - Tests that were skipped before calling `pre_init_per_*` got faulty calls to\n    the corresponding `post_init_per_*`. E.g. if a test was skipped because\n    `suite/0` failed, then `post_init_per_suite` would be called even though\n    `pre_init_per_suite` and `init_per_suite` were not called. This is now\n    corrected so a `post_*` callback will never be called unless the\n    corresponding `pre_*` callback has been called first.\n  - Tests that were skipped before or in `init_per_testcase` got faulty calls to\n    `pre_end_per_testcase` and `post_end_per_testcase`. This is now corrected so\n    `pre/post_end_per_testcase` are not called when `end_per_testcase` is not\n    called.\n  - If an exit signal causes the test case process to die while running\n    `init_per_testcase`, the case was earlier reported as failed with reason\n    `{skip,...}`. This is now corrected so the case will be marked as skipped.\n  - If an exist signal causes the test case process to die while running\n    `end_per_testcase`, the case was earlier marked as failed. This is now\n    corrected so the status of the test case is not changed - there is only a\n    warning added to the comment field.\n  - If a test case was skipped because of option `{force_stop,skip_rest}` or\n    because of a failed sequence, then no `tc_start` event would be sent, only\n    `tc_done`. This is now corrected so both events are sent.\n  - When skipping or failing in a configuration function, the configuration\n    function itself would get `{auto_skipped,Reason}`, `{skipped,Reason}` or\n    `{failed,Reason}` in the hook callbacks `on_tc_skip` or `on_tc_fail`. The\n    other test cases that were skipped as a result of this would only get\n    `Reason` in `on_tc_skip`. This is now corrected so even the configuration\n    function that caused the skip/fail will only get `Reason` in the hook\n    callback.\n\n  Own Id: OTP-10599 Aux Id: kunagi-344 \\[255]\n\n- When a test case was skipped by a `skip_cases` statement in a test spec, then\n  `cth_surefire` would erroneously mark the previous test case as skipped in the\n  xml report. The actually skipped test case would not be present in the xml\n  report at all. This is now corrected.\n\n  Own Id: OTP-14129 Aux Id: seq13244\n\n- The `multiply_timetraps` and `scale_timetraps` options did not work with test\n  specifications, which has been corrected.\n\n  Own Id: OTP-14210","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- ct_testspec:get_tests/1 is added. This is used by rebar3 to get all\n  directories that must be compiled when running tests from testspec - instead\n  of implementing testspec parsing in rebar3.\n\n  Own Id: OTP-14132","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.13 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Some types of printouts to screen during test runs (including\n  `ct:print/1,2,3,4`) used the local `user` process as IO device and these\n  printouts would not be visible when e.g. running tests via a shell on a remote\n  node. A default Common Test group leader process has been introduced to solve\n  the problem. This process routes printouts to the group leader of the starting\n  process, if available, otherwise to `user`.\n\n  Own Id: OTP-13973 Aux Id: ERL-279\n\n- Some Common Test processes, that act as I/O group leaders for test cases,\n  would not terminate as expected at the end of test runs. This error has been\n  corrected.\n\n  Own Id: OTP-14026 Aux Id: ERL-287\n\n- The logging verbosity feature was incorrectly documented. The default\n  verbosity levels for test runs is e.g. not 50 (`?STD_VERBOSITY`), but 100\n  (`?MAX_VERBOSITY`). Also, some of the examples had errors and flaws. The\n  corresponding chapter (5.18) in the User's Guide has been updated.\n\n  Own Id: OTP-14044 Aux Id: seq13223","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A feature to let the user specify headings to log printouts has been added.\n  The heading is specified as `{heading,string()}` in the `Opts` list argument\n  to `ct:pal/3,4,5`, `ct:print/3,4,5`, or `ct:log/3,4,5`. If the heading option\n  is omitted, the category name, or `\"User\"`, is used as the heading instead.\n\n  Own Id: OTP-14043 Aux Id: seq13226","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.12.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-12-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If the telnet server would pause during transmission of a line of text before\n  terminating the line, the `ct_telnet:expect/3` function would print the line\n  twice in the test case HTML log. This problem has been fixed.\n\n  Own Id: OTP-13730 Aux Id: seq13135\n\n- The functions `ct:set_verbosity/2` and `ct:get_verbosity/1` have been added in\n  order to make it possible for test cases, CT Hooks, or test framework\n  functions, to modify and read verbosity levels for logging.\n\n  Own Id: OTP-13841\n\n- `make` (tools) and `ct_make` (common_test) would crash if an Erlang source\n  file contained a `-warning()` directive.\n\n  Own Id: OTP-13855","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.12.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-12-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The following modules were missing in common_test.app.src: ct_groups,\n  ct_property_test, ct_release_test, ct_webtool, ct_webtool_sup, test_server_gl.\n  They have now been added.\n\n  Own Id: OTP-13475\n\n- Common Test printed incorrect timestamps for received error reports.\n\n  Own Id: OTP-13615 Aux Id: seq13124","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.12.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-12-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The `nodelay` option used to be enabled (`true`) by default for sockets opened\n  by the Common Test telnet client. This appeared to cause communication\n  problems with telnet servers on some systems, and therefore the option is no\n  longer used. Its value may instead be specified in the telnet connection\n  settings. See the man page for `ct_telnet` for details. Please note that the\n  interface function `connect` in `unix_telnet` has been updated with an extra\n  argument and is now `unix_telnet:connect/7`.\n\n  Own Id: OTP-13462 Aux Id: seq13077\n\n- Fix bug in cth_surefire: When a pre_init_per_suite hook fails before reaching\n  the cth_surefire:pre_init_per_suite, cth_surefire produced incorrect XML.\n\n  Own Id: OTP-13513\n\n- The `ct:get_timetrap_info/0` function has been updated to return more\n  information about timetrap scaling.\n\n  Own Id: OTP-13535\n\n- A problem with stylesheet HTML tags getting incorrectly escaped by Common Test\n  has been corrected.\n\n  Own Id: OTP-13536\n\n- The `ct_run` start flag `-no_esc_chars` and `ct:run_test/1` start option\n  `{esc_chars,Bool}` have been introduced to make it possible to disable\n  automatic escaping of characters. Automatic escaping of special HTML\n  characters printed with `io:format/1,2` and `ct:pal/1,2,3,4` was introduced in\n  Common Test 1.12. The new flag/option may be used to disable this feature for\n  backwards compatibility reasons. (The option is also supported in test\n  specifications).\n\n  Own Id: OTP-13537","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.12 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- This update fixes the problem with generic printouts in the html log file not\n  having special characters escaped. Printouts made with `io:format/2` and\n  `ct:pal/2` will now get special characters escaped automatically. Common Test\n  will not attempt to escape characters printed with `ct:log/2` since it is\n  assumed that the user may want to print html tagged data using this function.\n  A new function, `ct:log/5`, has been added, which offers optional escaping of\n  characters. The latter function may also be used to print text to the log\n  without headers and CSS class wrapping (analogue to `io:format/2`).\n\n  Own Id: OTP-13003 Aux Id: seq13005\n\n- Commit 4cf832f1ad163f5b25dd8a6f2d314c169c23c82f erroneously removed logging of\n  open and close of netconf connections. This is now corrected.\n\n  Own Id: OTP-13386\n\n- The directory to which nodes started with `test_server:start_node/3` writes\n  their erl_crash.dump is changed. The crashdumps were earlier written to the\n  directory of test_server.beam, but in later versions of Microsoft Windows this\n  is no longer writable (even for administrators). The framework (common_test)\n  log directory is now used instead.\n\n  Own Id: OTP-13388","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- This update makes it possible to specify multiple instances of the same group\n  or test case in one test specification term in order to repeat execution.\n  Example:\n  `{groups, \"./\", my_SUITE, [my_group, my_group], {cases, all}}, or {cases, \"./\", my_SUITE, [my_tc, my_tc, my_tc]}.`\n\n  Own Id: OTP-13241 Aux Id: seq12979\n\n- Two new CT hook functions have been added: `post_init_per_testcase/4` and\n  `pre_end_per_testcase/3`. With these hook functions, it is possible to perform\n  arbitrary actions (including modifications of test execution, test state and\n  results) immediately before and after the execution of the test case.\n\n  Own Id: OTP-13242 Aux Id: seq12991\n\n- The `ct_netconfc` was earlier very restrictive as to which SSH options the\n  user could set. This is now changed, and any SSH option is now allowed. The\n  netconf client will simply pass on any option, which it does not recognize, to\n  SSH.\n\n  Own Id: OTP-13338 Aux Id: seq13053,seq13069","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.11.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If a ssh package contained more than one netconf end tag, then the second end\n  tag was never detected in ct_netconfc:handle_data. Instead it was included in\n  the XML data given to the xmerl parser, which then failed. The problem was\n  introduced by OTP-13007, and has now been corrected.\n\n  Own Id: OTP-13323","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.11.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- When data from the netconf server was split into many ssh packages, the\n  netconf client performed really bad. This is now improved.\n\n  Own Id: OTP-13007\n\n- In ct_netconfc, if a timer expired 'at the same time' as the server sent the\n  rpc-reply, the timeout message might already be in the client's message queue\n  when the client removed the timer ref from its 'pending' list. This caused a\n  crash in the client since the timer ref could no longer be found when handling\n  the timeout message. This problem is now fixed by always flushing the timeout\n  message from the message queue when canceling a timer.\n\n  Own Id: OTP-13008\n\n- The error logger handler ct_conn_log_h did not respect the 'silent' option,\n  and tried to print to an undefined file descriptor. This has been corrected.\n\n  Own Id: OTP-13035\n\n- If the user would let the test run proceed after test suite compilation\n  failure, Common Test did not set the exit status to indicate failure as\n  expected. This has been corrected. Also, the 'abort_if_missing_suites' option\n  now makes Common Test abort the test run without asking the user if\n  compilation fails, even if access to stdin/stdout exists.\n\n  Own Id: OTP-13173 Aux Id: seq12978\n\n- With the Common Test 'create_priv_dir' start option set to 'auto_per_tc', the\n  name of the priv directory for a configuration function could clash with the\n  name of the priv directory for a test case, which would cause Test Server\n  failure. This error has been corrected.\n\n  Own Id: OTP-13181","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.11 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The status of an aborted test due to test suite compilation error has changed\n  from 'auto_skipped' to 'failed'. This affects both the textual log file, event\n  handling and CT hook callbacks. The logging of compilation failures has also\n  been improved, especially in the case of multiple test suites failing\n  compilation.\n\n  Own Id: OTP-10816\n\n- The Test Server source code parser (erl2html2) failed to handle the macro\n  tuple in the syntax tree returned by epp_dodger. This error has been\n  corrected.\n\n  Own Id: OTP-12740\n\n- New options to make it possible to specify ssh_port in a .spec file:\n  \\[\\{node_start, [\\{ssh_port, 9999\\}]\\}].\n\n  And also to specify additional ssh options like paths to public-key files:\n  \\[\\{node_start, [\\{ssh_opts, [\\{user_dir, \"/home/shrek/e2/\"\\}]\\}]\\}].\n\n  Own Id: OTP-12809","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Earlier there was no way to add optional parameters like default-operation to\n  an edit-config request sent with ct_netconfc:edit_config/3,4, you had to use\n  ct_netconfc:send_rpc/2,3. For simplicity and completion, a new optional\n  argument, OptParams, is now added to the edit_config function.\n\n  Own Id: OTP-10446 Aux Id: kunagi-266 \\[177]\n\n- When running OTP tests using the ts interface, it is now possible to specify\n  so called test categories per OTP application. A test category is represented\n  by a CT test specification and defines an arbitrary subset of existing test\n  suites, groups and cases. Examples of test categories are 'smoke' (smoke\n  tests) and 'bench' (benchmarks). (Call ts:help() for more info). Also,\n  functions for reading terms from the current test specification during test,\n  ct:get_testspec_terms/0 and ct:get_testspec_terms/1, have been implemented.\n\n  Own Id: OTP-11962\n\n- Obsolete scripts and make file operations have been removed and the\n  installation chapter in the Common Test User's Guide has been updated.\n\n  Own Id: OTP-12421\n\n- The 'keep_alive' interval has been reduced to 8 seconds, which is two seconds\n  shorter than the default 'idle_timeout' value for ct_telnet:expect/3. This\n  way, the telnet server receives a NOP message (which might trigger an action)\n  before the operation times out. Also the TCP option 'nodelay' has been enabled\n  per default for all telnet connections, in order to reduce the risk for\n  communication timeouts.\n\n  Own Id: OTP-12678 Aux Id: seq12818\n\n- When the ct_run program is executed without any flags, \"-dir .\" is now used as\n  default start flag. Similarly, the option \\{dir,\".\"\\} is used by ct:run_test/1\n  if called with an empty list. Also, the help text (ct_run -help) has been\n  updated, as well as the Running Tests chapter in the Common Test User's Guide.\n\n  Own Id: OTP-12684 Aux Id: seq12865","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.10.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- A fault in the Common Test logger process, that caused the application to\n  crash when running on a long name node, has been corrected.\n\n  Own Id: OTP-12643\n\n- A 'wait_for_prompt' option in ct_telnet:expect/3 has been introduced which\n  forces the function to not return until a prompt string has been received,\n  even if other expect patterns have already been found.\n\n  Own Id: OTP-12688 Aux Id: seq12818\n\n- If the last expression in a test case causes a timetrap timeout, the stack\n  trace is ignored and not printed to the test case log file. This happens\n  because the \\{Suite,TestCase,Line\\} info is not available in the stack trace\n  in this scenario, due to tail call elimination. Common Test has been modified\n  to handle this situation by inserting a \\{Suite,TestCase,last_expr\\} tuple in\n  the correct place and printing the stack trace as expected.\n\n  Own Id: OTP-12697 Aux Id: seq12848\n\n- Fixed a buffer problem in ct_netconfc which could cause that some messages\n  where buffered forever.\n\n  Own Id: OTP-12698 Aux Id: seq12844\n\n- The VTS mode in Common Test has been modified to use a private version of the\n  Webtool application (ct_webtool).\n\n  Own Id: OTP-12704 Aux Id: OTP-10922\n\n- Add possibility to add user capabilities in `ct_netconfc:hello/3`.\n\n  Own Id: OTP-12707 Aux Id: seq12846","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.10 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The tests overview file, index.html, did not always get updated correctly\n  after a new test run. This was because of a bug in the Common Test log cache\n  mechanism which has now been corrected.\n\n  Own Id: OTP-11400\n\n- When a successful test case returns, Common Test should, according to the\n  documentation, send a tc_done event to the event handlers with Result = ok in\n  the data field. However, Common Test sets Result to the return value of the\n  test case instead. Common Test has been modified now to comply with the\n  documentation.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12279 Aux Id: seq12737, OTP-12531\n\n- A ct_telnet:expect/3 call could never be aborted before an idle_timeout, even\n  if total_timeout had been set to a lower value (i.e. a shorter time). This\n  problem has been fixed.\n\n  Own Id: OTP-12335\n\n- The undocumented return value \\{skipped,Reason\\} from config functions and\n  test cases was handled inconsistently. Test cases were e.g. reported as\n  \"skipped\" to CT Hook functions, but \"successful\" to event handlers. Now, the\n  above return value is consistently handled the same way as \\{skip,Reason\\} and\n  this has also been documented.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12359 Aux Id: seq12760\n\n- The Erlang source code to HTML generator would sometimes fail because\n  epp:parse_erl_form/1 could not find and expand required macros in included\n  header files. The problem has been solved by making sure common_test always\n  passes the full include path to epp. Also, a bug that could cause\n  erl_syntax:revert/1 to fail because of a badly formed syntax tree has been\n  corrected.\n\n  Own Id: OTP-12419\n\n- A missing group option in the ct_run help text has been added.\n\n  Own Id: OTP-12433 Aux Id: seq12788\n\n- Printouts by means of ct:log/2/3 or ct:pal/2/3 from the hook functions\n  on_tc_fail/2 and on_tc_skip/2 would (quite unexpectedly) end up in the\n  \"unexpected i/o\" log file instead of in the test case log file. This behaviour\n  has been changed so that now, all printouts (including stdio printouts) from\n  these hook functions will be routed to the test case log file.\n\n  Own Id: OTP-12468\n\n- ct_netconfc:action/3 will now - if the return type is void - accept an RPC\n  reply on the form \\{ok,\\[simple_xml()]\\}, and in this event return only the\n  atom ok.\n\n  Own Id: OTP-12491 Aux Id: seq12797\n\n- OTP-11971 erroneously changed the handling of relative paths for incl_dirs\n  specified in the cover spec file. This is now corrected so these are expected\n  to be relative to the directory where the cover spec file itself is stored\n\n  Own Id: OTP-12498 Aux Id: OTP-11971\n\n- Some test cases have been updated to use ct:sleep/1 instead of timer:sleep/1.\n  The reason being that the sleep times need to be scaled to compensate for slow\n  execution (e.g. when cover is running).\n\n  Own Id: OTP-12574","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Common Test now exports a function, ct:get_event_mgr_ref/0, that returns the\n  name of the Common Test event manager. This makes it possible to plug in event\n  handlers to the event manager while tests are running (using the gen_event\n  API).\n\n  Own Id: OTP-12506 Aux Id: seq12802\n\n- When a test case (or configuration function) fails because of an exit signal\n  from a linked process, Common Test previously passed only the reason for\n  process termination to the CT post hook functions and the event handlers (in\n  the tc_done event). This has been changed so that now the tuple\n  \\{'EXIT',ReasonForProcessTermination\\} is passed instead. This makes it much\n  easier in the CT post hook functions to distinguish a failure of this sort\n  from other types of errors and from the return value of a successful test\n  case.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12531 Aux Id: OTP-12279\n\n- A new feature has been introduced in ct_telnet:get_data/1 that makes it\n  possible to automatically poll the telnet connection in case an incomplete\n  string (one that has not yet been terminated by a newline) remains in the\n  receive buffer. The polling is controlled by two new telnet config values,\n  which are documented in the ct_telnet reference manual. The polling mechanism\n  is disabled by default (making the get_data/1 function backwards compatible).\n\n  Own Id: OTP-12627","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.9 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The source code to html code generator in Test Server (and Common Test) would\n  fail to generate anchors in the html code for functions with non-expandable\n  macros, resulting in bad html links to such functions. This correction lets\n  the code generator ignore macros that can't be expanded (i.e. not pre-process\n  them), so that correct anchors will always be produced.\n\n  Own Id: OTP-11766 Aux Id: seq12556\n\n- OTP-11971 erroneously changed the handling of relative paths (import/export\n  files) specified in the cover spec file. This is now corrected so these are\n  expected to be relative to the directory where the cover spec file itself is\n  stored.\n\n  Own Id: OTP-12031\n\n- Common Test would sometimes crash while trying to print large amounts of SASL\n  reports to log on a computer with a slow file system. This problem (due to an\n  error in IO message buffering in ct_logs) has been fixed.\n\n  Own Id: OTP-12159\n\n- The common_test telnet client, ct_telnet and friends, had some unstable test\n  cases. Some of these were caused by the unix_telnet callback sending an extra\n  newline after sending the password. This caused the sever to send an extra\n  prompt back which confused the tests. The extra newline is no longer sent.\n\n  Also, debug printouts and logging from the telnet client is improved, and some\n  test cases are slightly modified in order to stabilize the test.\n\n  Own Id: OTP-12329\n\n- ct_netconfc did not expect the return value \\{error,timeout\\} from\n  ssh_connection:subsystem/4. This has been corrected.\n\n  Own Id: OTP-12334","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new option, `{newline,boolean()}` is added to all functions in `ct_telnet`\n  that send data (command strings) to the telnet server. By default, `ct_telnet`\n  adds a newline to all command strings, and by setting the new option to\n  `false` this behavior is turned off.\n\n  Own Id: OTP-12252 Aux Id: seq12730\n\n- Distribute `autoconf` helpers to applications at build time instead of having\n  multiple identical copies committed in the repository.\n\n  Own Id: OTP-12348","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.8.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Ticket OTP-11971 introduced a runtime dependency towards test_server-3.7.1,\n  since the interface between test_server and common_test was changed.\n  Erroneously, the common_test.app file was not updated according to this. This\n  has now been corrected.\n\n  Own Id: OTP-12037","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Warning: this is experimental and may disappear or change without previous\n  warning.\n\n  Experimental support for running Quickcheck and PropEr tests from common_test\n  suites is added to common_test. See the reference manual for the new module\n  `ct_property_testing`.\n\n  Experimental property tests are added under\n  `lib/{inet,ssh}/test/property_test`. They can be run directly or from the\n  commont_test suites `inet/ftp_property_test_SUITE.erl` and\n  `ssh/test/ssh_property_test_SUITE.erl`.\n\n  See the code in the `test` directories and the man page for details.\n\n  (Thanks to Tuncer Ayaz for a patch adding Triq)\n\n  Own Id: OTP-12119","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.8.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Substrings in long telnet messages would sometimes get wrongly reversed. This\n  error has been corrected.\n\n  Own Id: OTP-11871 Aux Id: seq12581\n\n- The basic_html logging mode in Common Test (for compatibility with old\n  browsers) generated HTML code with unbalanced tags. This has been fixed.\n\n  Own Id: OTP-11917 Aux Id: seq12598\n\n- The mechanism for running code cover analysis with common_test has been\n  improved. Earlier, if a test run consisted of multiple tests, cover would be\n  started and stopped for each test. This would give \"intermediate\" cover logs\n  available from the \"Coverage log\" link on the test suite result pages. To\n  accumulate cover data over all tests, the 'export' option had to be used in\n  the cover spec file. This was not well documented, and the functionality was\n  quite confusing.\n\n  Using the 'nodes' option in the cover spec file would fail when the test run\n  consisted of multiple tests, since the specified nodes would only be included\n  in the cover analysis of the first test.\n\n  The repeated compilation and analysis of the same modules was also very time\n  consuming.\n\n  To overcome these problems, ct will now only cover compile and analyze modules\n  once per test run, i.e. once for each cover spec file. The log file is\n  available via a new button on the top level index page. The old \"Coverage log\"\n  links on the test suite result pages still exist, but they all point to the\n  same log containing the accumulated result.\n\n  Own Id: OTP-11971\n\n- If multiple tests would run simultaneously on different Erlang nodes, writing\n  their logs to the same directory, then there would often be entries in the\n  all_runs.html log file showing incomplete results (all zeroes) upon\n  completion. This problem was caused by a bug in the Common Test log cache\n  mechanism, which has been fixed.\n\n  Own Id: OTP-11988 Aux Id: seq12611","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.8 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The error generated if a test case process received an exit from a linked\n  process while executing init_per_testcase/2, was handled incorrectly by Common\n  Test. The problem has been solved, and Common Test now reports this type of\n  error correctly, with proper error reason and exit location as well.\n\n  Own Id: OTP-11643\n\n- Running a parallel test case group with two or more instances of the same test\n  case would result in identical log file names, and one test case instance\n  would overwrite the log file of another. This problem has been solved.\n\n  Own Id: OTP-11644\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- The `cth_surefire` hook would crash in `pre_init_per_suite/3` if a previous\n  hook returned `{skip,Reason}` or `{fail,Reason}` instead of a `Config` list.\n  This error has been corrected, and `cth_surefire` will now simply propagate\n  the received `InitData` value instead.\n\n  Own Id: OTP-11811\n\n- Specs of return values are corrected for `ct_netconfc:get/2,3`,\n  `ct_netconfc:get_config/3,4`, `ct_netconfc:action/2,3`,\n  `ct_netconfc:send_rpc/2,3` and `ct_netconfc:send/2,3`.\n\n  Own Id: OTP-11834 Aux Id: seq12574","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- ct_telnet can now log all communication taking place during a telnet session.\n  Previously, only information about ct_telnet operations and commands, as well\n  as explicitly requested data from the server, was logged.\n\n  Furthermore, a logging mechanism based on an Error Logger event handler and a\n  dedicated Common Test hook, `cth_conn_log`, now makes it possible to print\n  data for individual connections to separate log files. Please see the\n  `ct_telnet` reference manual for more information and examples.\n\n  Important note: A new argument, `ConnName` has been added to the\n  `unix_telnet:connect/5` callback function. This forces users that use private\n  ct_telnet callback modules to update their code according to\n  `unix_telnet:connect/6`. Please see the `unix_telnet` reference manual and\n  source code module for details.\n\n  Own Id: OTP-11440 Aux Id: seq12457\n\n- A new timeout option has been introduced for the `ct_telnet:expect/3`\n  function. With `{total_timeout,Time}` it's possible to set a time limit for\n  the complete expect operation. After `Time` milliseconds, `expect/3` returns\n  `{error,timeout}`. The default value used if `total_timeout` is not specified,\n  is infinity (i.e. no time limit). Please see the `ct_telnet` reference manual\n  for more information.\n\n  Own Id: OTP-11689\n\n- Some function specs are corrected or moved and some edoc comments are\n  corrected in order to allow use of edoc. (Thanks to Pierre Fenoll)\n\n  Own Id: OTP-11702\n\n- Test case group name information has been added to the data sent with\n  `tc_user_skip` and `tc_auto_skip` event messages, as well as the data passed\n  in calls to the CT Hook functions `on_tc_skip/3` and `on_tc_fail/3`. The\n  modification only affects the function name element/argument. This value\n  remains an atom if the test case in question does not belong to a test case\n  group. Otherwise a tuple `{FuncName,GroupName}` (`{atom(),atom()}`) is passed\n  instead.\n\n  Note that this change may (depending on the patterns used for matching)\n  require modifications of user event handlers and hook modules. Please see the\n  Event Handling chapter in the Common Test User's Guide, and the reference\n  manual for `ct_hooks`, for details.\n\n  Note also that the Test Server framework callback function `report/2` has been\n  modified. This change only affects users with test frameworks interfacing Test\n  Server rather than Common Test. See the `test_server_ctrl` reference manual\n  for details.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11732 Aux Id: seq12541\n\n- If Common Test can't prompt the user to abort or continue the test run when\n  one or more test suites fail to compile, a new option,\n  `{abort_if_missing_suites,Bool}`, can be used to specify whether it should\n  proceed with the test run, or stop execution. The default value of `Bool` is\n  `false` (i.e. to proceed even if suites are missing).\n\n  Own Id: OTP-11769","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- common_test: Fix problems reported by Dialyzer.\n\n  Own Id: OTP-11525","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.7.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Return values from group and testcase info functions are now properly checked,\n  and associated test cases are auto skipped if a return value is invalid.\n\n  Own Id: OTP-10631 Aux Id: kunagi-345 \\[256]\n\n- The way Common Test handles skipping of test cases has been updated. In\n  previous versions, returning `{skip,Reason}` from a configuration function\n  (such as init_per_suite or init_per_group), resulted in all affected test\n  cases getting skipped with status `auto_skipped`. This was inappropriate,\n  since this status is supposed to be used to inform that Common Test has taken\n  the initiative to skip something (e.g. a test case group if init_per_group\n  failed). Therefore, in this version of Common Test, whenever the user skips a\n  suite, group, or individual test case (by means of a configuration function or\n  test specification term), the affected test cases get the status\n  `user_skipped` instead.\n\n  This update has meant a few changes that may affect Common Test users in\n  various ways:\n\n  - The test results and statistics will be affected, which is important to know\n    when running regression tests and comparing results to previous test runs.\n  - Users that read or parse the textual log file `suite.log` will notice that\n    an auto skipped function is now reported as `auto_skipped` rather than\n    `skipped` as before.\n  - When `require` fails in an info function (such as suite/0 or group/1), all\n    affected configuration functions and test cases are marked as\n    `auto_skipped`.\n  - If Common Test detects an error in the test suite (such as e.g. an invalid\n    all/0 function), all affected configuration functions and test cases are\n    marked as `auto_skipped`.\n  - If a repeated test run session reaches a deadline with `force_stop` enabled,\n    all remaining test cases are marked as `auto_skipped` rather than\n    `user_skipped` as before.\n  - The event messages that Common Test generates during test runs have been\n    affected by this update. For details see OTP-11524.\n\n  Own Id: OTP-11305 Aux Id: OTP-11524\n\n- Returning \\{skip, Reason\\} from a pre_end_per_group/3 user hook function would\n  result in an exit in the Common Test cth_log_redirect hook. This problem has\n  been solved.\n\n  Own Id: OTP-11409 Aux Id: seq12446\n\n- When the netconf server did not respond to the close-session request, the call\n  to ct_netconfc:close_session/2 would hang forever waiting for the netconf\n  client to terminate. This has been corrected. The client will now always\n  terminate (and take down the connection) if the close-session request times\n  out.\n\n  Own Id: OTP-11478","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Fix cth_log_redirect.erl to fulfill gen_event behaviour. Thanks to Roberto\n  Aloi.\n\n  Own Id: OTP-11401\n\n- The first argument of the CT hook callback function `on_tc_skip/3` has been\n  modified. When this function is called for `init_per_group` or\n  `end_per_group`, the value of the first argument is now\n  `{init_per_group,GroupName}` or `{end_per_group,GroupName}`.\n\n  Own Id: OTP-11523\n\n- The following modifications have been made to the event messages that Common\n  Test sends during test execution:\n\n  - For the `tc_auto_skip` event, the value of the `Func` element has changed\n    from `end_per_group` to `{end_per_group,GroupName}`.\n  - When `require` fails in an info function, such as suite/0 or group/1, the\n    init configuration function is now reported as `auto_skipped` instead of\n    `skipped`, with the `tc_done` event.\n  - When `require` fails in an info function because of a configuration name\n    already in use, the `tc_done` event now reports the error with a tuple (of\n    size 2) tagged `failed` instead of `skipped`.\n\n  Please see the Event Handling chapter in the Common Test User's Guide for\n  reference.\n\n  Own Id: OTP-11524 Aux Id: OTP-11305","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.7.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Documentation is added for ct_netconfc:send and ct_netconfc:send_rpc.\n\n  Own Id: OTP-11132\n\n- ct_netconfc:create_subscription only allowed one XML element inside the\n  'filter' element. According to RFC5277 it should be allowed to add any number\n  of elements inside the filter, so this is now corrected.\n\n  Own Id: OTP-11166\n\n- The error handler installed by the Common Test hook cth_log_redirect did not\n  respond to init:stop/1/2. This has been corrected.\n\n  Own Id: OTP-11175 Aux Id: seq12356\n\n- Calling ct:pal/2 or ct:print/2 when Common Test was not running, would cause\n  an exit. This has been changed and the string is now simply printed to stdout\n  instead.\n\n  Own Id: OTP-11176\n\n- Fixed problem with the cth_log_redirect hook making calls to an undefined\n  function in ct_logs.\n\n  Own Id: OTP-11238\n\n- When running tests with the 'repeat' option, the Common Test utility process\n  did not always terminate quickly enough after a test run, causing the start of\n  the next run to fail. A monitor is now used to ensure termination of the\n  utility process after each test run.\n\n  Own Id: OTP-11244 Aux Id: seq12396\n\n- Test Server installed an error handler (test_server_h) only to be able to\n  write the name of the current test case to stdout whenever it received an\n  error- or progress report. This functionality was not useful and has been\n  removed. The built-in Common Test hook, cth_log_redirect, has instead been\n  improved to now also tag all error- and progress reports in the log with\n  suite-, group-, and/or test case name.\n\n  Own Id: OTP-11263 Aux Id: seq12251","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new log, the \"Pre- and Post Test I/O Log\", has been introduced, which makes\n  it possible to capture error- and progress reports, as well as printouts made\n  with ct:log/2 and ct:pal/2, before and after a test run. (Some minor\n  improvements of the logging system have been made at the same time). Links to\n  the new log are found on the Common Test Framework Log page. The Common Test\n  User's Guide has been updated with information about the new log and also with\n  a new section on how to synchronize external applications with Common Test by\n  means of the CT Hook init and terminate functions.\n\n  Own Id: OTP-11272","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.7.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- A design flaw in the generic connection handling in Common Test made it\n  impossible to implement a connection handler that could map multiple\n  connection names (i.e. configuration variable aliases) to single connection\n  pids. This problem has been solved.\n\n  Own Id: OTP-10126 Aux Id: kunagi-178 \\[89]\n\n- If a telnet connection is hanging, then a call to ct_telnet:close/1 will time\n  out after 5 seconds and the connection process is brutally killed. In some\n  cases the connection would not be unregistered and attempts at opening a new\n  connection with the same name would make common_test try to reuse the same\n  connection since it believed that it was still alive. This has been\n  corrected - a killed connection is now always unregistered.\n\n  Own Id: OTP-10648 Aux Id: seq12212\n\n- Test performance has been improved by means of a cache for the top level HTML\n  index logs (all_runs.html and index.html, in the logdir directory). This\n  solves problems with slow start up times and test execution times increasing\n  with the number of ct_run directories stored in logdir. The cached index\n  entries are stored in RAM during test execution and are saved to file in\n  logdir (for faster start up times) whenever a test run finishes.\n\n  Own Id: OTP-10855\n\n- Testing of the test specification functionality has been improved and a couple\n  of minor bugs have been discovered and corrected.\n\n  Own Id: OTP-10857\n\n- Links to the top level index files in some HTML footers had disappeared. This\n  error has been corrected. Also, a problem with the suite overview log file not\n  being closed properly has been solved.\n\n  Own Id: OTP-11046\n\n- Common Test would, in case of timetrap error, print a warning in the log if\n  end_per_testcase wasn't implemented in the suite, even though it's an optional\n  function. This printout has been removed.\n\n  Own Id: OTP-11052","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- If it could not be decided which test case a certain log printout belonged to,\n  the common test framework log was earlier used. Such printouts are now instead\n  sent to unexpected_io.log.html in test_server so that there is only one place\n  to look for \"missing\" printouts.\n\n  Own Id: OTP-10494 Aux Id: kunagi-319 \\[230]\n\n- Make cover smarter about finding source from beam.\n\n  In particular, search using the source path in module_info if the current\n  heuristic fails.\n\n  Own Id: OTP-10902\n\n- Add a variant of ct_slave:start/2 that starts a node with specified options on\n  the local host.\n\n  Own Id: OTP-10920\n\n- Integrate elliptic curve contribution from Andreas Schultz\n\n  In order to be able to support elliptic curve cipher suites in SSL/TLS,\n  additions to handle elliptic curve infrastructure has been added to public_key\n  and crypto.\n\n  This also has resulted in a rewrite of the crypto API to gain consistency and\n  remove unnecessary overhead. All OTP applications using crypto has been\n  updated to use the new API.\n\n  Impact: Elliptic curve cryptography (ECC) offers equivalent security with\n  smaller key sizes than other public key algorithms. Smaller key sizes result\n  in savings for power, memory, bandwidth, and computational cost that make ECC\n  especially attractive for constrained environments.\n\n  Own Id: OTP-11009\n\n- Postscript files no longer needed for the generation of PDF files have been\n  removed.\n\n  Own Id: OTP-11016\n\n- A link is added from the red error printout in a test case log (for a failed\n  test case) to the full error description at the end of the log. The reason for\n  this is that the error description in the red field is sometimes truncated at\n  50 characters in order to keep the log as short and easy to read as possible.\n\n  Own Id: OTP-11044 Aux Id: seq12304\n\n- A new option 'no_prompt_check' is added to ct_telnet:expect/3. If this option\n  is used, ct_telnet will not wait for a prompt or a newline before attempting\n  to match the given pattern.\n\n  Own Id: OTP-11095","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.7.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If an event handler installed in the CT Master event manager took too long to\n  respond during the termination phase, CT Master crashed because of a timeout\n  after 5 secs. This would leave the system in a bad state. The problem has been\n  solved by means of a 30 min timeout value and if CT Master gets a timeout\n  after that time, it now kills the event manager and shuts down properly.\n\n  Own Id: OTP-10634 Aux Id: kunagi-347 \\[258]\n\n- Printing with any of the ct printout functions from an event handler installed\n  by Common Test, would cause a deadlock. This problem has been solved.\n\n  Own Id: OTP-10826 Aux Id: seq12250\n\n- Using the force_stop flag/option to interrupt a test run caused a crash in\n  Common Test. This problem has been solved.\n\n  Own Id: OTP-10832","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Removed deprecated run_test program, use ct_run instead.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9052","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- Test case execution time increases with size of test run.\n\n  Own Id: OTP-10855","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.7 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Severe errors detected by `test_server` (e.g. if log files directories cannot\n  be created) will now be reported to `common_test` and noted in the\n  `common_test` logs.\n\n  Own Id: OTP-9769 Aux Id: kunagi-202 \\[113]\n\n- The earlier undocumented cross cover feature for accumulating cover data over\n  multiple tests has now been fixed and documented.\n\n  Own Id: OTP-9870 Aux Id: kunagi-206 \\[117]\n\n- If a busy test case generated lots of error messages,\n  cth_log_redirect:post_end_per_testcase would crash with a timeout while\n  waiting for the error logger to finish handling all error reports. The default\n  timer was 5 seconds. This has now been extended to 5 minutes.\n\n  Own Id: OTP-10040 Aux Id: kunagi-173 \\[84]\n\n- When a test case failed because of a timetrap time out, the `Config` data for\n  the case was lost in the following call to `end_per_testcase/2`, and also in\n  calls to the CT Hook function `post_end_per_testcase/4`. This problem has been\n  solved and the `Config` data is now correctly passed to the above functions\n  after a timetrap timeout failure.\n\n  Own Id: OTP-10070 Aux Id: kunagi-175 \\[86]\n\n- Some calls to deprecated and removed functions in snmp are removed from\n  ct_snmp.\n\n  Own Id: OTP-10088 Aux Id: kunagi-176 \\[87]\n\n- In test_server, the same process would supervise the currently running test\n  case and be group leader (and IO server) for the test case. Furthermore, when\n  running parallel test cases, new temporary supervisor/group leader processes\n  were spawned and the process that was group leader for sequential test cases\n  would not be active. That would lead to several problems:\n\n  \\* Processes started by init_per_suite will inherit the group leader of the\n  init_per_suite process (and that group leader would not process IO requests\n  when parallel test cases was running). If later a parallel test case caused\n  such a processto print using (for example) io:format/2, the calling would\n  hang.\n\n  \\* Similarly, if a process was spawned from a parallel test case, it would\n  inherit the temporary group leader for that parallel test case. If that\n  spawned process later - when the group of parallel tests have finished -\n  attempted to print something, its group leader would be dead and there would\n  be `badarg` exception.\n\n  Those problems have been solved by having group leaders separate from the\n  processes that supervises the test cases, and keeping temporary group leader\n  process for parallel test cases alive until no more process in the system use\n  them as group leaders.\n\n  Also, a new `unexpected_io.log` log file (reachable from the summary page of\n  each test suite) has been introduced. All unexpected IO will be printed into\n  it(for example, IO to a group leader for a parallel test case that has\n  finished).\n\n  Own Id: OTP-10101 Aux Id: OTP-10125\n\n- Some bugfixes in `ct_snmp:`\n\n  - ct_snmp will now use the value of the 'agent_vsns' config variable when\n    setting the 'variables' parameter to snmp application agent configuration.\n    Earlier this had to be done separately - i.e. the supported versions had to\n    be specified twice.\n  - Snmp application failed to write notify.conf since ct_snmp gave the notify\n    type as a string instead of an atom. This has been corrected.\n\n  Own Id: OTP-10432\n\n- Some bugfixes in `ct_snmp`:\n\n  - Functions `register_users/2`, `register_agents/2` and\n    `register_usm_users/2`, and the corresponding `unregister_*/1` functions\n    were not executable. These are corrected/rewritten.\n  - Function `update_usm_users/2` is removed, and an unregister function is\n    added instead. Update can now be done with unregister_usm_users and then\n    register_usm_users.\n  - Functions `unregister_*/2` are added, so specific users/agents/usm users can\n    be unregistered.\n  - Function `unload_mibs/1` is added for completeness.\n  - Overriding configuration files did not work, since the files were written in\n    priv_dir instead of in the configuration dir (priv_dir/conf). This has been\n    corrected.\n  - Arguments to `register_usm_users/2` were faulty documented. This has been\n    corrected.\n\n  Own Id: OTP-10434 Aux Id: kunagi-264 \\[175]\n\n- Faulty exported specs in common test has been corrected to\n  `ct_netconfc:hook_options/0` and [`inet:hostname/0`](`t:inet:hostname/0`)\n\n  Own Id: OTP-10601\n\n- The netconf client in common_test did not adjust the window after receiving\n  data. Due to this, the client stopped receiving data after a while. This has\n  been corrected.\n\n  Own Id: OTP-10646","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- It is now possible to let a test specification include other test\n  specifications. Included specs can either be joined with the source spec (and\n  all other joined specs), resulting in one single test run, or they can be\n  executed in separate test runs. Also, a start flag/option, `join_specs`, has\n  been introduced, to be used in combination with the `spec` option. With\n  `join_specs`, Common Test can be told to either join multiple test\n  specifications, or run them separately. Without `join_specs`, the latter\n  behaviour is default. Note that this is a change compared to earlier versions\n  of Common Test, where specifications could only be joined. More information\n  can be found in the Running Tests chapter in the User's Guide (see the Test\n  Specifications section).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9881 Aux Id: kunagi-350 \\[261]\n\n- The `ct_slave:start/3` function now supports an `{env,[{Var,Value}]}` option\n  to extend environment for the slave node.\n\n  Own Id: OTP-10469 Aux Id: kunagi-317 \\[228]\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Update common test modules to handle unicode:\n\n  - Use UTF-8 encoding for all HTML files, except the HTML version of the test\n    suite generated with erl2html2:convert, which will have the same encoding as\n    the original test suite (.erl) file.\n  - Encode link targets in HTML files with test_server_ctrl:uri_encode/1.\n  - Use unicode modifier 't' with ~s when appropriate.\n  - Use unicode:characters_to_list and unicode:characters_to_binary for\n    conversion between binaries and strings instead of binary_to_list and\n    list_to_binary.\n\n  Own Id: OTP-10783","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- CT drops error reason when groups/0 crashes.\n\n  Own Id: OTP-10631 Aux Id: kunagi-345 \\[256]\n\n- Event handler on a ct_master node causes hanging.\n\n  Own Id: OTP-10634 Aux Id: kunagi-347 \\[258]\n\n- CT fails to open telnet conn after a timetrap timeout.\n\n  Own Id: OTP-10648 Aux Id: seq12212","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.6.3.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6-3-1"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- The following corrections/changes are done in the cth_surefire hook:\n\n  - Earlier there would always be a 'properties' element under the 'testsuites'\n    element. This would exist even if there were no 'property' element inside\n    it. This has been changed so if there are no 'property' elements to display,\n    then there will not be a 'properties' element either.\n  - The XML file will now (unless other is specified) be stored in the top log\n    directory. Earlier, the default directory would be the current working\n    directory for the erlang node, which would mostly, but not always, be the\n    top log directory.\n  - The 'hostname' attribute in the 'testsuite' element would earlier never have\n    the correct value. This has been corrected.\n  - The 'errors' attribute in the 'testsuite' element would earlier display the\n    number of failed testcases. This has been changed and will now always have\n    the value 0, while the 'failures' attribute will show the number of failed\n    testcases.\n  - A new attribute 'skipped' is added to the 'testsuite' element. This will\n    display the number of skipped testcases. These would earlier be included in\n    the number of failed test cases.\n  - The total number of tests displayed by the 'tests' attribute in the\n    'testsuite' element would earlier include init/end_per_suite and\n    init/end_per_group. This is no longer the case. The 'tests' attribute will\n    now only count \"real\" test cases.\n  - Earlier, auto skipped test cases would have no value in the 'log' attribute.\n    This is now corrected.\n  - A new attributes 'log' is added to the 'testsuite' element.\n  - A new option named 'url_base' is added for this hook. If this option is\n    used, a new attribute named 'url' will be added to the 'testcase' and\n    'testsuite' elements.\n\n  Own Id: OTP-10589","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.6.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The ct:run_test/1 option 'config' only worked with a single config file, not a\n  list of files. This has been fixed.\n\n  Own Id: OTP-10495\n\n- ct_netconfc:close_session sometimes returned \\{error,closed\\} because the ssh\n  connection was closed (from the server side) before the rpc-reply was received\n  by the client. This is normal and cannot be helped. It has been corrected so\n  the return will be 'ok' in this case. Other error situations will still give\n  \\{error,Reason\\}.\n\n  Own Id: OTP-10510 Aux Id: kunagi-320 \\[231]\n\n- ct_netconfc:close_session sometimes returned \\{error,closed\\} or (if the\n  connection was named) \\{error,\\{process_down,Pid,normal\\}\\} because the ssh\n  connection was closed (from the server side) before the rpc-reply was received\n  by the client. This is normal and cannot be helped. It has been corrected so\n  the return will be 'ok' in this situation.\n\n  Own Id: OTP-10570\n\n- Fix bug where ct:require of same name with same config would return\n  name_in_use.\n\n  Own Id: OTP-10572","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new test case group search functionality has been implemented that makes\n  Common Test search automatically through the group definitions tree (the\n  return value of groups/0) and create tests for all paths of nested groups that\n  match the specification. It also allows for specifying unique paths to sub\n  groups in order to avoid execution of unwanted tests. This new feature can be\n  used whenever starting a test run by means of the ct_run program, the\n  ct:run_test/1 API function, or a Test Specification. Details can be found in\n  the Test Case Group Execution section in the Running Tests chapter.\n\n  Own Id: OTP-10466 Aux Id: kunagi-276 \\[187]","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- Restore Config data if lost when test case fails.\n\n  Own Id: OTP-10070 Aux Id: kunagi-175 \\[86]\n\n- IO server error in test_server.\n\n  Own Id: OTP-10125 Aux Id: OTP-10101, kunagi-177 \\[88]\n\n- Faulty connection handling in common_test.\n\n  Own Id: OTP-10126 Aux Id: kunagi-178 \\[89]","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.6.2.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The interactive mode (ct_run -shell) would not start properly. This error has\n  been fixed.\n\n  Own Id: OTP-10414","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Common_Test 1.6.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If a CT hook function caused a crash, this could in some situations cause\n  Common Test to terminate due to an illegal IO operation. This error has been\n  corrected.\n\n  Own Id: OTP-10050 Aux Id: seq12039\n\n- The Common Test documentation states that timetraps are never active during\n  execution of CT hook functions. This was only true for post hook functions,\n  not for pre hook functions. The code for CT hooks has been modified to behave\n  according to the documentation.\n\n  Own Id: OTP-10069\n\n- If a CT hook function would call the exit/1 or throw/1 BIF (possibly\n  indirectly, e.g. as a result of a timeout in gen_server:call/3), Common Test\n  would hang. This problem has been fixed.\n\n  Own Id: OTP-10072 Aux Id: seq12053\n\n- The documentation has been updated with information about how to deal with\n  chaining of hooks which return fail/skip.\n\n  Own Id: OTP-10077 Aux Id: seq12048\n\n- When ct_hooks called the id/1 functions of multiple hooks, it would reverse\n  the order of the hooks and call the proceeding init/2 calls in the wrong\n  order. This has been fixed.\n\n  Own Id: OTP-10135\n\n- The surefire hook now correctly handles autoskipped initialization and test\n  functions.\n\n  Own Id: OTP-10158\n\n- The ct:get_status/0 function failed to report status if a parallel test case\n  group was running at the time of the call. This has been fixed and the return\n  value for the function has been updated. Please see the ct reference manual\n  for details.\n\n  Own Id: OTP-10172","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The support for \"silent connections\" has been updated to include ssh. Also, a\n  silent_connections term has been added to the set of test specification terms.\n\n  Own Id: OTP-9625 Aux Id: seq11918\n\n- It is now possible to specify an arbitrarily large tuple as the requires\n  config data when using require and ct:get_config. See the ct:get_config and\n  ct:require reference manual pages for details about which keys are allowed.\n\n  This change introduces a backwards incompatibility in the `ct:require/2`\n  interface. Previously when doing `ct:require(a_name,{key,subkey})`, a_name\n  would be associated with key. This has been changed to that `a_name` is\n  associated with `subkey`. This change also effects using `require` in an\n  suite/group/testcase info function.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9626 Aux Id: seq11920\n\n- The ct_run program now sets the OS process exit status before it ends. Value 0\n  indicates a successful test result, 1 indicates one or more failed or\n  auto-skipped test cases, and 2 indicates test execution failure.\n\n  Own Id: OTP-9865 Aux Id: OTP-10087\n\n- It is now possible to sort the HTML tables by clicking on the header elements.\n  In order to reset a sorted table, the browser window should simply be\n  refreshed. This feature requires that the browser supports javascript, and has\n  javascript execution enabled. If the 'ct_run -basic_html' flag is used, no\n  javascript code is included in the generated HTML code.\n\n  Own Id: OTP-9896 Aux Id: seq12034, OTP-9835\n\n- A netconf client, ct_netconfc, is added to common_test. It supports basic\n  netconf functionality over SSH. In order to allow testing of both success and\n  failure cases, it is intentionally written to allow non-standard behavior.\n\n  Own Id: OTP-10025\n\n- The test specification term \\{define,Constant,Value\\} has been introduced,\n  which makes it possible to replace constant names (atom()) with values\n  (term()) in arbitrary test specification terms. The 'define' makes the (now\n  deprecated) 'alias' term obsolete. More details, including examples, can be\n  found in the Test Specifications chapter in the Common Test User's Guide.\n\n  Own Id: OTP-10049\n\n- Verbosity levels for log printouts has been added. This makes it possible to\n  specify preferred verbosity for different categories of log printouts, as well\n  as general printouts (such as standard IO), to allow control over which\n  strings get printed and which get ignored. New versions of the Common Test\n  logging functions, ct:log, ct:pal and ct:print, have been introduced, with a\n  new Importance argument added. The Importance value is compared to the\n  verbosity level at runtime. More information can be found in the chapter about\n  Logging in the Common Test User's Guide.\n\n  Own Id: OTP-10067 Aux Id: seq12050\n\n- The return values of ct:run_test/1 and ct:run_testspec/1 have been changed\n  from an uninformative 'ok' (independent of the test outcome) to a value,\n  \\{Ok,Failed,\\{UserSkipped,AutoSkipped\\}\\} (all integers), that presents the\n  final test case result, or a value, \\{error,Reason\\}, that informs about fatal\n  test execution failure. See details in the reference manual for ct.\n\n  Own Id: OTP-10087 Aux Id: OTP-9865\n\n- The test specification syntax has been updated with new and missing terms,\n  such as 'define', 'verbosity', 'auto_compile', 'stylesheet',\n  'silent_connections', 'basic_html' and 'release_shell'. See the Test\n  Specification chapter in the Common Test User's Guide for details.\n\n  Own Id: OTP-10089 Aux Id: OTP-10049\n\n- It is now possible to pause execution of a test case, by calling the\n  ct:break/1/2 function. Execution is resumed with a call to ct:continue/0/1.\n  Break/continue also works for test cases executing in parallel. See the ct\n  reference manual for details.\n\n  Own Id: OTP-10127\n\n- It is now possible to send user defined events from a testcase which will be\n  picked up by the installed event handler.\n\n  Own Id: OTP-10157\n\n- A new start option, release_shell, for ct:run_test/1, has been added, which\n  makes Common Test release the shell process after the test suite compilation\n  phase is finished. For details, see the Running Tests chapter in the User's\n  Guide.\n\n  Own Id: OTP-10248 Aux Id: OTP-10127","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.6.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Common Test adds the test suite directories to the code path before executing\n  the tests. These directories should also be removed from the code path at the\n  end of the test run, which, prior to this fix, was not performed.\n\n  Own Id: OTP-9595\n\n- An entry is now created in the index.html file (i.e. the overview file for the\n  test run) for each repeated test during a test run. This was previously not\n  the case. Note that in the top level (logdir) index file, however, only the\n  last test result is listed. For example, given the test spec:\n  \\[\\{merge_tests,false\\},\\{dirs,\"test1\"\\},\\{dirs,\"test1\"\\}]. In the index file\n  for the test run (under Logdir/ct_run.Node.Date.Time), both tests are listed.\n  In the top level index file (under Logdir), only the last test is listed (one\n  has to find the previous results through the all_runs.html file).\n\n  Own Id: OTP-9634 Aux Id: seq11924\n\n- After a test case timeout or abortion, the end_per_testcase function executes\n  on a new dedicated process. The group leader for this process should be set to\n  the IO server for the test case, which was not done properly. The result of\n  this error was that no warnings about end_per_testcase failing or timing out\n  were ever printed in the test case log. Also, help functions such as e.g.\n  test_server:stop_node/1, attempting to synchronize with the IO server, would\n  hang. The fault has been corrected.\n\n  Own Id: OTP-9666\n\n- The ct:get_status/0 function would cause the calling process to receive 'DOWN'\n  messages if no tests were running at the time of the call. This bug has been\n  fixed.\n\n  Own Id: OTP-9830 Aux Id: seq11975\n\n- A deadlock situation could occur if Common Test is forwarding error_handler\n  printouts to Test Server at the same time a new test case is starting. This\n  error has been fixed.\n\n  Own Id: OTP-9894\n\n- A link to the ct_run program is now created, as expected, in the installation\n  bin directory (default /usr/local/bin) during 'make install'.\n\n  Own Id: OTP-9898\n\n- Using the repeat, duration or until option with ct:run_test/1, would cause an\n  infinite loop. This has been fixed.\n\n  Own Id: OTP-9899\n\n- Two or more test cases executing in parallel and printing to screen at the\n  same time with ct:pal/2/3 or ct:print/2/3 could write into each other's\n  \"slots\" and create a mess of mixed strings. In order to avoid this, only a\n  single IO message is now ever sent per printout call.\n\n  Own Id: OTP-9900 Aux Id: OTP-9904\n\n- When a test case was killed because of a timetrap timeout, the current\n  location (suite, case and line) was not printed correctly in the log files.\n  This has been corrected.\n\n  Own Id: OTP-9930 Aux Id: seq12002\n\n- The wrong exit location was printed in the log file when ct:fail/1 or\n  ct_fail/2 was called.\n\n  Own Id: OTP-9933 Aux Id: seq12002\n\n- Test Server and Common Test would add new error handlers with each test run\n  and fail to remove previously added ones. In the case of Test Server, this\n  would only happen if SASL was not running on the test node. This has been\n  fixed.\n\n  Own Id: OTP-9941 Aux Id: seq12009\n\n- If a test case process was terminated due to an exit signal from a linked\n  process, Test Server failed to report the correct name of the suite and case\n  to the framework. This has been corrected.\n\n  Own Id: OTP-9958 Aux Id: OTP-9855\n\n- When starting a test with ct_run and adding a directory to the code path using\n  -pa or -pz (preceding -erl_args), Common Test would delete any existing\n  directory in the code path with the same base name (see filename:basename/1)\n  as the directory being added. This has been fixed.\n\n  Own Id: OTP-9964\n\n- If passing two or more directories with the same base name (see\n  filename:basename/1) to Common Test with ct_run -pa, only one of the\n  directories would actually be added.\n\n  Own Id: OTP-9975 Aux Id: seq12019\n\n- Configuration data required by the group info function was deleted before the\n  call to post_end_per_group, which made it impossible for the hook function to\n  read and use the data in question. This has been fixed.\n\n  Own Id: OTP-9989\n\n- Disabling built-in hooks in a test specification was ignored, this has now\n  been fixed.\n\n  Own Id: OTP-10009\n\n- Various typographical errors corrected in documentation for common_test,\n  driver, erl_driver and windows installation instructions. (Thanks to Tuncer\n  Ayaz)\n\n  Own Id: OTP-10037","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A new optional feature has been introduced that enables Common Test to\n  generate priv_dir directory names that are unique for each test case or config\n  function. The name of the option/flag is 'create_priv_dir' and it can be set\n  to value 'auto_per_run' (which is the default, existing, behaviour), or\n  'auto_per_tc' or 'manual_per_tc'. If 'auto_per_tc' is used, Test Server\n  creates a dedicated priv_dir automatically for each test case (which can be\n  very expensive in case of many and/or repeated cases). If 'manual_per_tc' is\n  used, the user needs to create the priv_dir explicitly by calling the new\n  function ct:make_priv_dir/0.\n\n  Own Id: OTP-9659 Aux Id: seq11930\n\n- A column for test case group name has been added to the suite overview HTML\n  log file.\n\n  Own Id: OTP-9730 Aux Id: seq11952\n\n- It is now possible to use the post_end_per_testcase CT hook function to print\n  a comment for a test case in the overview log file, even if the test case gets\n  killed by a timetrap or unknown exit signal, or if the end_per_testcase\n  function times out.\n\n  Own Id: OTP-9855 Aux Id: seq11979\n\n- The pre- and post CT hook functions are now always called for all\n  configuration functions, even for configuration functions that are not\n  implemented in the test suite.\n\n  Own Id: OTP-9880 Aux Id: seq11993\n\n- Common Test will now print error information (with a time stamp) in the test\n  case log file immediately when a test case fails. This makes it easier to see\n  when, in time, the fault actually occurred, and aid the job of locating\n  relevant trace and debug printouts in the log.\n\n  Own Id: OTP-9904 Aux Id: seq11985, OTP-9900\n\n- Test Server has been modified to check the SASL errlog_type parameter when\n  receiving an error logger event, so that it doesn't print reports of type that\n  the user has disabled.\n\n  Own Id: OTP-9955 Aux Id: seq12013\n\n- The test specification term 'skip_groups' was implemented in Common Test v1.6.\n  It was never documented however, which has now been attended to. Please see\n  the Test Specifications chapter in the User's Guide for information.\n\n  Own Id: OTP-9972\n\n- The Common Test Master has been updated to use a CSS style sheet for the html\n  log files.\n\n  Own Id: OTP-9973\n\n- If the init_per_group/2 and end_per_group/2 functions are not implemented in\n  the test suite, Common Test calls it's own local init- and end functions -\n  previously named ct_init_per_group/2 and ct_end_per_group/2 - when a group is\n  executed. These functions have been renamed init_per_group/2 and\n  end_per_group/2 respectively. Note that this may affect any user event handler\n  identifying events by the old names.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9986 Aux Id: OTP-9992\n\n- By specifying a user defined function (\\{M,F,A\\} or fun) as timetrap value,\n  either by means of an info function or by calling ct:timetrap/1, it is now\n  possible to set a timetrap that will be triggered when the user function\n  returns.\n\n  Own Id: OTP-9988 Aux Id: OTP-9501, seq11894\n\n- If the optional configuration functions init_per_suite/1 and end_per_suite/1\n  are not implemented in the test suite, local Common Test versions of these\n  functions are called instead, and will be displayed in the overview log file.\n  Any printouts made by the pre- or post_init_per_suite and pre- or\n  post_end_per_suite hook functions are saved in the log files for these\n  functions.\n\n  Own Id: OTP-9992\n\n- A hook has been added to common test which outputs surefire XML for usage\n  together with CI tools such as Jenkins. To enable the hook pass '-ct_hooks\n  cth_surefire' to ct_run. See the CTH documentation for more details.\n\n  Own Id: OTP-9995","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.6 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-6"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A Getting Started chapter has been added to the Common Test User's Guide.\n\n  Own Id: OTP-9156\n\n- The test case group info function has been implemented in Common Test. Before\n  execution of a test case group, a call is now made to\n  `TestSuite:group(GroupName)`. The function returns a list of test properties,\n  e.g. to specify timetrap values, require configuration data, etc (analogue to\n  the test suite- and test case info function). The scope of the properties set\n  by `group(GroupName)` is all test cases and sub-groups of group `GroupName`.\n\n  Own Id: OTP-9235\n\n- Common Test hooks are now in a final supported version. The Common Test hooks\n  allow you to abstract out initialization behaviour that is common to multiple\n  test suites into one place and also extend the behaviour of a suite without\n  changing the suite itself. For more information see the Common Test user's\n  guide.\n\n  Own Id: OTP-9449\n\n- A new built-in common test hook has been added which captures error_logger and\n  SASL event and prints them in the testcase log. To disable this (and any other\n  built-in hooks) pass 'enable_builtin_hooks false' to common test.\n\n  Own Id: OTP-9543\n\n- Common Test now calls info functions also for the `init/end_per_suite/1` and\n  `init/end_per_group/2` configuration functions. These can be used e.g. to set\n  timetraps and require external configuration data relevant only for the\n  configuration functions in question (without affecting properties set for\n  groups and test cases in the suite). The info function for\n  `init/end_per_suite(Config)` is `init/end_per_suite()`, and for\n  `init/end_per_group(GroupName,Config)` it's `init/end_per_group(GroupName)`.\n  Info functions cannot be used with `init/end_per_testcase(TestCase, Config)`,\n  since these configuration functions execute on the test case process and will\n  use the same properties as the test case (i.e. properties set by the test case\n  info function, `TestCase()`).\n\n  Own Id: OTP-9569\n\n- It's now possible to read the full name of the test case log file during\n  execution. One way to do this is to lookup it up as value of the key\n  `tc_logfile` in the test case `Config` list (which means it can also be read\n  by a pre- or post Common Test hook function). The data is also sent with the\n  event `#event{name=tc_logfile,data={{Suite,Func},LogFileName}}`, and can be\n  read by any installed event handler.\n\n  Own Id: OTP-9676 Aux Id: seq11941\n\n- The look of the HTML log files generated by Common Test and Test Server has\n  been improved (and made easier to customize) by means of a CSS file.\n\n  Own Id: OTP-9706\n\n- Functions ct:fail(Format, Args) and ct:comment(Format, Args) have been added\n  in order to make printouts of formatted error and comment strings easier (no\n  need for the user to call io_lib:format/2 explicitly).\n\n  Own Id: OTP-9709 Aux Id: seq11951\n\n- The order in which ct hooks are executed for cleanup hooks (i.e. _*end_per*_\n  hooks) has been reversed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9774 Aux Id: seq11913\n\n- Printouts to stdout may be captured during test case execution. This is useful\n  in order to e.g. read and parse tty printouts from the SUT during test case\n  execution (if necessary, say, to determine the outcome of the test). The\n  capturing session is started with `ct:capture_start/0`, and stopped with\n  `ct:capture_stop/0`. The list of buffered strings is read and purged with\n  `ct:capture_get/0/1`. It's possible to filter out printouts made with\n  `ct:log/2/3` and `ct:pal/2/3` from the captured list of strings. This is done\n  by calling `capture_get/1` with a list of log categories to exclude.\n\n  Own Id: OTP-9775\n\n- The syntax for specifying test case groups in the all/0 list has been extended\n  to include execution properties for both groups and sub-groups. The properties\n  specified in all/0 for a group overrides the properties specified in the group\n  declaration (in groups/0). The main purpose of this extension is to make it\n  possible to run the same set of tests, but with different properties, without\n  having to declare copies of the group in question. Also, the same syntax may\n  be used in test specifications in order to change properties of groups at the\n  time of execution, without having to edit the test suite. Please see the\n  User's Guide for details and examples.\n\n  Own Id: OTP-9809 Aux Id: OTP-9235","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Common Test Release Notes","doc":"- Fix problems in CT/TS due to line numbers in exceptions.\n\n  Own Id: OTP-9203","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Common_Test 1.5.5 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- An error in how comments are colored in the test suite overview html log file\n  has been corrected. As result, a new framework callback function,\n  format_comment/1, has been introduced.\n\n  Own Id: OTP-9237\n\n- Automatically generated init- and end-configuration functions for test case\n  groups caused incorrect execution order of test cases. This has been\n  corrected.\n\n  Own Id: OTP-9369\n\n- If multiple directories were specified with the 'logdir' flag/option, Common\n  Test would crash. This has been fixed so that an error is properly reported\n  instead.\n\n  Own Id: OTP-9370\n\n- If ct:log/2 was called with bad arguments, this could cause the Common Test IO\n  handling process to crash. This fault has been corrected.\n\n  Own Id: OTP-9371 Aux Id: OTP-8933\n\n- A bug has been fixed that made Test Server call the end_tc/3 framework\n  function with an incorrect module name as first argument.\n\n  Own Id: OTP-9379 Aux Id: seq11863\n\n- If a timetrap timeout occurred during execution of a function in a lib module\n  (i.e. a function called directly or indirectly from a test case), the Suite\n  argument in the end_tc/3 framework callback function would not correctly\n  contain the name of the test suite, but the lib module. (This would only\n  happen if the lib module was compiled with ct.hrl included). This error has\n  been solved.\n\n  Own Id: OTP-9398\n\n- Corrections of the vts mode. It will now report errors (about e.g. incorrect\n  config files) instead of crashing or hanging. Furthermore, the requirement\n  that the test directory name must have a \"\\_test\" suffix has been removed.\n  Also, a workaround has been implemented for the limitation that the file\n  browser (in many web browsers) will only return the basic file name, not the\n  full directory path (which made it impossible to have config files in other\n  directories than the main test directory).\n\n  Own Id: OTP-9429\n\n- Add a proplist() type\n\n  Recently I was adding specs to an API and found that there is no canonical\n  proplist() type defined. (Thanks to Ryan Zezeski)\n\n  Own Id: OTP-9499\n\n- It is now possible to use the 'step' flag/option to run the debugger for test\n  suites that contain test case groups. This previously caused Common Test to\n  crash. If 'step config' is specified, breakpoints are now also automatically\n  set on init_per_group and end_per_group. Note that breakpoints are always set\n  automatically on test case functions and this is true also for grouped cases.\n\n  Own Id: OTP-9518 Aux Id: OTP-8933\n\n- The test index page was not refreshed at the start of each test suite which\n  made it impossible to follow test execution by means of refreshing the browser\n  window (no links to follow). This has been fixed.\n\n  Own Id: OTP-9520 Aux Id: OTP-8933\n\n- If a test suite would start with a test case group defined without the\n  init_per_group/2 and end_per_group/2 function, init_per_suite/1 would not\n  execute initially and logging of the test run would fail. This error has been\n  fixed.\n\n  Own Id: OTP-9584\n\n- The \"Missing Suites\" link from the top level index page was incorrect and has\n  been fixed.\n\n  Own Id: OTP-9592","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Various corrections and updates to improve the handling and reporting of\n  errors.\n\n  Own Id: OTP-8933\n\n- The dir and suite start option can now be used in combination. E.g. executing\n  my_SUITE in directory my_tests can either be specified as \"ct_run -suite\n  my_tests/my_SUITE\" or as \"ct_run -dir my_tests -suite my_SUITE\". Furthermore,\n  the specification: ct:run_test(\\[\\{suite,[\"./my_SUITE\"]\\},\\{testcase,t1\\}]) is\n  now interpreted as ct:run_test(\\[\\{suite,\"./my_SUITE\"\\},\\{testcase,t1\\}]),\n  i.e. only testcase t1 in test suite my_SUITE - not all cases - will be\n  executed.\n\n  Own Id: OTP-9155\n\n- A new option, 'logopts', has been introduced, to make it possible to modify\n  some aspects of the logging behaviour in Common Test (or Test Server). For\n  example, whenever an io printout is made, test_server adds newline (\\\\n) to\n  the end of the output string. This may not always be a preferred action and\n  can therefore be disabled by means of \"ct_run ... -logopts no_nl\" (or\n  ct:run_test(\\[..., \\{logopts,[no_nl]\\}])). A new framework callback function,\n  get_logopts/0, has been introduced (see the ct_framework module for details).\n\n  Own Id: OTP-9372 Aux Id: OTP-9396\n\n- A new option, 'logopts', has been introduced, to make it possible to modify\n  some aspects of the logging behaviour in Common Test (or Test Server). For\n  example, if the html version of the test suite source code should not be\n  generated during the test run (and consequently be unavailable in the log file\n  system), the feature may be disabled by means of \"ct_run ... -logopts no_src\"\n  (or ct:run_test(\\[..., \\{logopts,[no_src]\\}])). A new framework callback\n  function, get_logopts/0, has been introduced (see the ct_framework module for\n  details).\n\n  Own Id: OTP-9396 Aux Id: seq11869, OTP-9372\n\n- CT Hooks can now be assigned a priority. The priority of a CTH determines when\n  it should execute in relation to other CTHs. The CTH with the lowest priority\n  will be executed first, CTHs with equal priority will be executed in the order\n  which they were installed.\n\n  Own Id: OTP-9445\n\n- It is now possible to use a tuple \\{M,F,A\\}, or a fun, as timetrap\n  specification in the suite info function or test case info functions. The\n  function must return a valid timeout value, as documented in the common_test\n  man page and in the User's Guide.\n\n  Own Id: OTP-9501 Aux Id: seq11894\n\n- A new built-in common test hook has been added which captures error_logger and\n  SASL event and prints them in the testcase log. To disable this (and any other\n  built-in hooks) pass 'enable_builtin_hooks false' to common test.\n\n  Own Id: OTP-9543\n\n- Common Test now has the possibility to have built-in hooks which are started\n  by default when any test is run. To disable built-in hooks pass\n  'enable_builtin_hooks false' to common test. See the common test hooks\n  documentation for more details.\n\n  Own Id: OTP-9564","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.5.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- It was previously not possible to use timetrap value 'infinity' with\n  ct:timetrap/1. This has been fixed.\n\n  Own Id: OTP-9159\n\n- The Common Test VTS mode has been updated to be able to report test results of\n  suites that include test case groups (when it would previously crash).\n\n  Own Id: OTP-9195\n\n- Common Test now refreshes the very top level index.html page at the start of\n  each individual test in a test run, so that progress of the ongoing test can\n  be tracked by following the link to its overview page.\n\n  Own Id: OTP-9210 Aux Id: OTP-9054\n\n- A bug that made it impossible to cancel the previous timetrap when calling\n  ct:timetrap/1 has been corrected.\n\n  Own Id: OTP-9233 Aux Id: OTP-9159\n\n- Fix bug which would make cth's to not be removed when out of scope when adding\n  a cth in suite/0 and crashing in pre_init_per_suite.\n\n  Own Id: OTP-9264","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- It is now possible to return a tuple \\{fail,Reason\\} from init_per_testcase/2.\n  The result is that the associated test case gets logged as failed without ever\n  executing.\n\n  Own Id: OTP-9160 Aux Id: seq11502\n\n- Common Test now accepts, but ignores, empty test case group specifications.\n\n  Own Id: OTP-9161","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.5.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Added an option to test specs which allow the execution of tests as is,\n  instead of doing merging of tests on the same \"level\". See the merge_tests\n  directive the test specification documentation.\n\n  Own Id: OTP-9026 Aux Id: seq11768","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Alpha release of Common Test Hooks (CTH). CTHs allow the users of common test\n  to abstract out common behaviours from test suites in a much more elegant and\n  flexible way than was possible before. Note that the addition of this feature\n  may introduce minor changes in the undocumented behaviour of the interface\n  between common_test and test_server.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8851","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.5.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Updated ct:get_status documentation to describe no_tests_running return value.\n\n  Own Id: OTP-8895 Aux Id: seq11701\n\n- Fixed race condition test failures in the test suites testing common test's\n  parallel groups feature.\n\n  Own Id: OTP-8921\n\n- The include directive of testspecs now work when used on a remote node.\n\n  Own Id: OTP-8935 Aux Id: seq11731","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- ct:parse_table can now handle multiline sql rows\n\n  Own Id: OTP-8907 Aux Id: seq11702\n\n- The run_test executable has been renamed to the less generic ct_run to better\n  work with other applications. run_test will remain until R16B at which point\n  it will be removed.\n\n  Own Id: OTP-8936","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.5.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Returning \\{return_group_result,failed\\} from end_per_group in a group that is\n  part of a sequence, did not cause the proceeding cases (or groups) to get\n  skipped. This has been fixed.\n\n  Own Id: OTP-8753 Aux Id: seq11644\n\n- ct:install now works as the documentation describes.\n\n  Own Id: OTP-8818 Aux Id: seq-11666","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Common Test has been updated to handle start options and test specification\n  terms for test case groups (and test cases in groups). Also, an option named\n  'label', has been added that associates the test run with a name that Common\n  Test prints in the overview HTML logs.\n\n  Own Id: OTP-8725 Aux Id: OTP-8727\n\n- Andrey Pampukha has been added to the AUTHORS file. Thank you Andrey for your\n  work on configuration data handling, Large Scale Testing improvements, and\n  other useful updates and fixes.\n\n  Own Id: OTP-8803\n\n- The Configuration Data chapter in the User's Guide has been updated.\n\n  Own Id: OTP-8804\n\n- Milliseconds are now included in timestamps in Common Test log entries.\n  (Thanks to Tomas Johansson.)\n\n  Own Id: OTP-8808","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.5 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- Process calls using monitors in Common Test would not clear the inbox of\n  remaining DOWN messages. This has been fixed.\n\n  Own Id: OTP-8621 Aux Id: seq11560","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- It is now possible for the user to provide specific callback modules that\n  handle test configuration data, so that data on arbitrary form can be accessed\n  (e.g. by reading files or by communicating with a configuration server\n  process). Two default callback modules have been introduced in Common Test:\n  ct_config_plain and ct_config_xml. The former is used to handle the\n  traditional Common Test configuration files (with terms on key-value tuple\n  form) and the latter to handle configuration data on XML representation.\n\n  Own Id: OTP-8485\n\n- It is now possible to execute test suites that are not necessarily available\n  on the local file system, but have been loaded on the test node in advance\n  (e.g. sent as binaries from a remote node and loaded by RPC). A requirement is\n  that the no_auto_compile (or \\{auto_compile,false\\}) parameter has been set.\n\n  Own Id: OTP-8490 Aux Id: seq11500\n\n- Test Server will now call the end_per_testcase/2 function even if the test\n  case has been terminated explicitly (with abort_current_testcase/1), or after\n  a timetrap timeout. Under these circumstances the return value of\n  end_per_testcase is completely ignored. Therefore the function will not be\n  able to change the reason for test case termination by returning\n  \\{fail,Reason\\}, nor will it be able to save data with \\{save_config,Data\\}.\n\n  Own Id: OTP-8500 Aux Id: seq11521\n\n- It is now possible to use the test specification term 'init' to start Common\n  Test nodes automatically, as well as have initial function calls evaluated on\n  the nodes. A default callback module for the 'init' term, ct_slave, has been\n  introduced to enable Common Test Master to perform host login and node startup\n  operations over ssh.\n\n  Own Id: OTP-8570\n\n- The run_test script has been replaced by a program (with the same name) which\n  can be executed without explicit installation. The start flags are the same as\n  for the legacy start script.\n\n  Own Id: OTP-8650\n\n- Previously, a repeat property of a test case group specified the number of\n  times the group should be repeated after the main test run. I.e. \\{repeat,N\\}\n  would case the group to execute 1+N times. To be consistent with the behaviour\n  of the run_test repeat option, this has been changed. N now specifies the\n  absolute number of executions instead.\n\n  Own Id: OTP-8689 Aux Id: seq11502\n\n- With the run_test -erl_args option, it's possible to divide the options on the\n  run_test command line into ones that Common Test should process (those\n  preceding -erl_args, and ones it should ignore (those succeeding -erl_args).\n  Options preceding -erl_args that Common Test doesn't recognize are also\n  ignored (i.e. the same behaviour as earlier versions of Common Test).\n\n  Own Id: OTP-8690 Aux Id: OTP-8650\n\n- Directories added with -pa or -pz in the pre-erl_args part of the run_test\n  command line will be converted from relative to absolute, this to avoid\n  problems loading user modules when Common Test switches working directory\n  during the test run.\n\n  Own Id: OTP-8691 Aux Id: OTP-8650\n\n- The timetrap handling has been made more user controllable by means of new\n  start options and new ct interface functions. With the 'multiply_timetraps'\n  start option, it's possible to specify a value which all timetrap timeout\n  values get multiplied by. This is useful e.g. to extend the timetraps\n  temporarily while running cover or trace. The 'scale_timetraps' start option\n  switches on or off the Test Server timetrap scaling feature (which tries to\n  detect if the tests may benefit from extended timetraps, e.g. due to running\n  certain test tools, and performs the scaling automatically). Furthermore, the\n  ct:timetrap/1 function has been introduced, which makes it possible to\n  set/reset timetraps during test execution. Also, a ct:sleep/1 function is now\n  available, which takes the timetrap parameters into account when calculating\n  the time to suspend the process.\n\n  Own Id: OTP-8693\n\n- A new run_test start option, event_handler_init, has been added that takes a\n  start argument which gets passed to the init function of the event handler.\n\n  Own Id: OTP-8694","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4.7 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The auto compilation feature of Common Test did not recognize if a header file\n  included in a test suite was modified (if the dir start flag/option was used).\n  This has been fixed.\n\n  Own Id: OTP-8396 Aux Id: seq11488, OTP-8311","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The tc_status value in the Config list for a test case that has failed because\n  of a timetrap timeout, has changed from \\{tc_status,timeout\\} to\n  \\{tc_status,timetrap_timeout\\}.\n\n  Own Id: OTP-8302\n\n- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343\n\n- It is now possible to include the `ct.hrl` using the -include_lib directive.\n  (Thanks to Fred Hebert.)\n\n  Own Id: OTP-8379\n\n- The telnet client in Common Test sent \\[IAC,DO,NOP] to the server in attempt\n  to keep the connection alive. This is not a valid sequence according to the\n  standard, and some telnet servers would terminate the connection because of\n  it. The client has been changed to send \\[IAC,NOP] every 10 secs instead,\n  which should be a valid sequence. The client does not negotiate this type of\n  \"keep alive\" message with the server, and if it causes problems, the user may\n  disable the keep alive feature by adding \\{keep_alive,false\\} to the telnet\n  configuration data for the server/connection. Please see the ct_telnet and\n  unix_telnet manual pages for details.\n\n  Own Id: OTP-8450 Aux Id: OTP-8311","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4.6 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If the init_per_testcase/2 function fails, the test case now gets marked and\n  counted as auto skipped, not user skipped (which would previously happen).\n\n  Own Id: OTP-8289","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201\n\n- For a failed test case, the tc_done event is supposed to report info on the\n  form \\{failed,Error\\}. Only Error was reported, however, which has now been\n  fixed.\n\n  Own Id: OTP-8235 Aux Id: seq-11414\n\n- It is now possible to fail a test case from the end_per_testcase/2 function,\n  by returning \\{fail,Reason\\}.\n\n  Own Id: OTP-8284\n\n- It is now possible to fail a test case by having the end_tc/3 framework\n  function return \\{fail,Reason\\} for the test case.\n\n  Own Id: OTP-8285\n\n- The test_server framework API (e.g. the end_tc/3 function) has been modified.\n  See the test_server_ctrl documentation for details.\n\n  Own Id: OTP-8286 Aux Id: OTP-8285, OTP-8287\n\n- Various updates of the test events have been implemented. The data field for\n  some events, such as tc_done and tc_auto_skip has been modified to make\n  pattern matching on the data easier and more consistent. Also the order in\n  which some events are received has been altered. E.g. the tc_auto_skip event\n  for a test case now comes after the tc_done for the failed configuration\n  function (not before) which makes more sense. Note that no new events have\n  been added and that the event record remains unchanged.\n\n  Own Id: OTP-8287 Aux Id: OTP-8235\n\n- The marquee used for test names on the all_runs.html page has been removed on\n  request. Note that the test name field has the full text string in a title\n  tag, which is displayed when hovering the mouse pointer over it (i.e. if the\n  web browser supports title tags).\n\n  Own Id: OTP-8288\n\n- It is now possible to refresh the top level index files in an arbitrary log\n  directory by specifying a \\{refresh_logs,LogDir\\} tuple in the ct:run_test/1\n  options list. Also the -refresh_logs flag for the run_test script has been\n  extended to take an optional LogDir argument, i.e. -refresh_logs \\[LogDir]. If\n  no LogDir is specified, current working directory is assumed, unless the log\n  directory is set with the -logdir flag.\n\n  Own Id: OTP-8290\n\n- It was previously required that test suites were located under a test object\n  (or OTP application) sub-directory named \"test\" (or under a directory named\n  \" \\_test\"). This has been changed so that Common Test now looks for\n  suites primarily in a test sub-directory only if the directory exists.\n  Otherwise it will assume the suites are stored in the same directory the user\n  specifies with e.g. the 'dir' start flag/option.\n\n  Own Id: OTP-8294","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4.5 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- The Common Test logger process crashed if a test case in a sequence (declared\n  with sequences/0) failed. This fault has been corrected.\n\n  Own Id: OTP-8089 Aux Id: seq11334","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Various updates and fixes in Common Test and Test Server.\n\n  Own Id: OTP-8045 Aux Id: OTP-8089,OTP-8105,OTP-8163\n\n- Errors in coverage data collection and analysis were difficult to detect. The\n  logging has been improved so that more information about e.g. imported and\n  missing modules is printed to the html log files.\n\n  Own Id: OTP-8163 Aux Id: seq11374\n\n- The Common Test HTML overview pages have been improved. It is now possible to\n  see if a test case has been skipped explicitly or because a configuration\n  function has failed. Also, the history page (all_runs.html) now has scrolling\n  text displaying the test names. The old format (showing names as a truncated\n  string) can still be generated by means of the flag/option 'basic_html'.\n\n  Own Id: OTP-8177","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4-2"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Various corrections and improvements of Common Test and Test Server.\n\n  Own Id: OTP-7981","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4-1"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Minor updates and corrections.\n\n  Own Id: OTP-7897","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-4"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- A support client module for SSH and SFTP, ct_ssh, has been introduced in\n  Common Test.\n\n  Own Id: OTP-7838\n\n- Test case groups have been introduced. With this feature it's possible to\n  execute groups (possibly nested) of test cases, each group wrapped with a call\n  to function init_per_group/2 and end_per_group/2. Group definitions are done\n  by means of the new call-back function groups/0, which should return a list of\n  definitions. A group definition contains a name tag, a list of properties and\n  a list of test cases (including possible nested group definitions). The\n  properties make it possible to execute test cases in parallel, in sequence and\n  in shuffled order. It is also possible to repeat test cases according to\n  different criteria. The properties can be combined, making it possible to e.g.\n  repeat a conf case a certain number of times and execute the test cases in\n  different (random) order every time. Available properties are: parallel,\n  sequence, shuffle, repeat, repeat_until_all_ok, repeat_until_any_ok,\n  repeat_until_any_fail and repeat_until_all_fail. Please see the Common Test\n  User's Guide for details.\n\n  Own Id: OTP-7839 Aux Id: OTP-7511\n\n- It is now possible to use DES3 encrypted configuration files with Common Test.\n\n  Own Id: OTP-7842 Aux Id: OTP-7838\n\n- In previous versions of Common Test, only one FTP connection could be opened\n  per configuration target name. This has been updated so that multiple\n  connections may be opened. The possibility to use named connections is still\n  supported.\n\n  Own Id: OTP-7853 Aux Id: OTP-7838\n\n- The Erlang mode for Emacs has been updated with new and modified skeletons for\n  Common Test and TS. Syntax for test case groups in Common Test (and conf cases\n  with properties in TS) has been added and a new minimal Common Test suite\n  skeleton has been introduced.\n\n  Own Id: OTP-7856","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.6 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- When running a test which includes all suites in a test directory, if the auto\n  compilation would fail for one suite, all following suites would be excluded\n  from the test. This was an unwanted behaviour and has been corrected. Now all\n  suites will always be compiled and only the failing ones excluded from the\n  test (and logged as missing).\n\n  Own Id: OTP-7750 Aux Id: OTP-7803\n\n- The step functionality in Common Test (based on interaction with Debugger) was\n  broken. This has been fixed, and some new step features have also been added.\n  Please see the Common Test User's Guide for details.\n\n  Own Id: OTP-7800 Aux Id: seq11106","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- It is now possible for the user to specify include directories that Common\n  Test will pass along to the compiler when suite and help modules are being\n  compiled (which Common Test performs automatically before running tests).\n\n  Own Id: OTP-7803 Aux Id: OTP-7750","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.5 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Common Test Release Notes","doc":"- If the Erlang runtime system was started without access to an erlang shell\n  (e.g. -noshell), compilation errors would cause a crash in the Common Test\n  application. Without access to a shell, Common Test cannot prompt the user to\n  choose to continue or abort the test session, but must assume that the session\n  should proceed.\n\n  Own Id: OTP-7749 Aux Id: seq11175, seq11180","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- It is now possible for the Common Test user to disable the auto-compile\n  feature. This is done by specifying the run_test flag -no_auto_compile, or the\n  ct:run_test/1 option \\{auto_compile,false\\}.\n\n  Own Id: OTP-7663\n\n- A new function, ct:get_config/3, has been added to Common Test that makes it\n  possible to - if a particular config variable has been defined in multiple\n  config files - return all matching values for the variable. The order of the\n  elements in the returned list is the same as the specified order of the config\n  files.\n\n  Own Id: OTP-7758 Aux Id: seq11158\n\n- Because a telnet connection was always identified by a config variable alias,\n  it was impossible to open multiple connections using the same telnet host data\n  entry in the config file. This limitation has been removed by making it\n  possible to associate a connection with handle value only (i.e. multiple\n  connections may be opened using the same config variable). See\n  ct_telnet:open/4 for details.\n\n  Own Id: OTP-7781\n\n- A new syntax for defining default config data values has been introduced. In\n  previous versions of Common Test, to define and access a default value for a\n  config variable (in the suite info- or test case info function), an alias name\n  had to be used. With the new syntax you may define default values without\n  reference to aliases, like this: \\{default_config,VarName,DefaultValue\\}.\n  Please see the User's Guide for more info.\n\n  Own Id: OTP-7782\n\n- In previous versions of Common Test, whenever a config variable got associated\n  with a name (by means of a require statement), the config variable name was\n  replaced with the new name. This introduced unwanted dependencies between test\n  cases (e.g. if one test case would introduce a new name, the following test\n  cases could no longer access the config data by means of the original\n  variable). This functionality has now been updated so that when new names are\n  introduced with require, they become aliases (references) instead of\n  replacements. Hence, config data elements can always, at any time, be accessed\n  by means of the original config variable names.\n\n  Own Id: OTP-7783","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.4 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-4"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Common Test now uses the re application instead of the previous rx driver to\n  perform regular expression matching on telnet strings. Since re works on all\n  supported operating systems, it is now possible to run telnet sessions also on\n  platforms such as e.g. Windows (which was not the case with the previous rx\n  driver). Note that the rx driver is obsolete from now on, and will be removed\n  from Common Test after OTP R12B.\n\n  Own Id: OTP-7528","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.3 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-3"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- Various updates and improvements, plus some minor bug fixes, have been\n  implemented in Common Test and Test Server.\n\n  Own Id: OTP-7112\n\n- It is now possible, by means of the new function ct:abort_current_testcase/1\n  or test_server_ctrl:abort_current_testcase/1, to abort the currently executing\n  test case.\n\n  Own Id: OTP-7518 Aux Id: OTP-7112","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.2 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-2"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The configure test of the rx lib in Common Test was not performed during the\n  general OTP application configuration phase. This made e.g. autoconf\n  impossible. This has been changed to correspond with the normal OTP build\n  procedure.\n\n  Own Id: OTP-7379","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Common_Test 1.3.1 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-1"},{"type":"extras","title":"Improvements and New Features - Common Test Release Notes","doc":"- The rx library, included with common_test, failed to build on some\n  architectures because the -fPIC compiler option was missing.\n\n  Own Id: OTP-7111","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"common_test 1.3.0 - Common Test Release Notes","doc":"","ref":"notes.html#common_test-1-3-0"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","ref":"introduction.html"},{"type":"extras","title":"Scope - Introduction","doc":"`Common Test` is a portable application for automated testing. It is suitable\nfor:\n\n- Black-box testing of target systems of any type (that is, not necessarily\n  implemented in Erlang). This is performed through standard O&M interfaces\n  (such as SNMP, HTTP, CORBA, and Telnet) and, if necessary, through\n  user-specific interfaces (often called test ports).\n- White-box testing of Erlang/OTP programs. This is easily done by calling the\n  target API functions directly from the test case functions.\n\n`Common Test` also integrates use of the OTP `m:cover` tool in application Tools\nfor code coverage analysis of Erlang/OTP programs.\n\n`Common Test` executes test suite programs automatically, without operator\ninteraction. Test progress and results are printed to logs in HTML format,\neasily browsed with a standard web browser. `Common Test` also sends\nnotifications about progress and results through an OTP event manager to event\nhandlers plugged in to the system. This way, users can integrate their own\nprograms for, for example, logging, database storing, or supervision with\n`Common Test`.\n\n`Common Test` provides libraries with useful support functions to fill various\ntesting needs and requirements. There is, for example, support for flexible test\ndeclarations through test specifications. There is also support for central\nconfiguration and control of multiple independent test sessions (to different\ntarget systems) running in parallel.","ref":"introduction.html#scope"},{"type":"extras","title":"Prerequisites - Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language.","ref":"introduction.html#prerequisites"},{"type":"extras","title":"Common Test Basics","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Test Basics\n\n[](){: #basics }","ref":"basics_chapter.html"},{"type":"extras","title":"General - Common Test Basics","doc":"The `Common Test` framework is a tool that supports implementation and automated\nexecution of test cases to any types of target systems. `Common Test` is the\nmain tool being used in all testing- and verification activities that are part\nof Erlang/OTP system development and maintenance.\n\nTest cases can be executed individually or in batches. `Common Test` also\nfeatures a distributed testing mode with central control and logging. With this\nfeature, multiple systems can be tested independently in one common session.\nThis is useful, for example, when running automated large-scale regression\ntests.\n\nThe System Under Test (SUT) can consist of one or more target nodes.\n`Common Test` contains a generic test server that, together with other test\nutilities, is used to perform test case execution. The tests can be started from\na GUI, from the OS shell, or from an Erlang shell. _Test suites_ are files\n(Erlang modules) that contain the _test cases_ (Erlang functions) to be\nexecuted. _Support modules_ provide functions that the test cases use to do the\ntests.\n\nIn a black-box testing scenario, `Common Test`\\-based test programs connect to\nthe target system(s) through standard O&M and CLI protocols. `Common Test`\nprovides implementations of, and wrapper interfaces to, some of these protocols\n(most of which exist as standalone components and applications in OTP). The\nwrappers simplify configuration and add verbosity for logging purposes.\n`Common Test` is continuously extended with useful support modules. However,\nnotice that it is a straightforward task to use any Erlang/OTP component for\ntesting purposes with `Common Test`, without needing a `Common Test` wrapper for\nit. It is as simple as calling Erlang functions. A number of target-independent\ninterfaces are supported in `Common Test`, such as Generic Telnet and FTP. These\ncan be specialized or used directly for controlling instruments, traffic load\ngenerators, and so on.\n\n`Common Test` is also a very useful tool for white-box testing Erlang code (for\nexample, module testing), as the test programs can call exported Erlang\nfunctions directly. There is very little overhead required for implementing\nbasic test suites and executing simple tests. For black-box testing Erlang\nsoftware, Erlang RPC and standard O&M interfaces can be used for example.\n\nA test case can handle several connections to one or more target systems,\ninstruments, and traffic generators in parallel to perform the necessary actions\nfor a test. The handling of many connections in parallel is one of the major\nstrengths of `Common Test`, thanks to the efficient support for concurrency in\nthe Erlang runtime system, which `Common Test` users can take great advantage\nof.","ref":"basics_chapter.html#general"},{"type":"extras","title":"Test Suite Organization - Common Test Basics","doc":"Test suites are organized in test directories and each test suite can have a\nseparate data directory. Typically, these files and directories are\nversion-controlled similar to other forms of source code (possibly by a version\ncontrol system like GIT or Subversion). However, `Common Test` does not itself\nput any requirements on (or has any awareness of) possible file and directory\nversions.","ref":"basics_chapter.html#test-suite-organization"},{"type":"extras","title":"Support Libraries - Common Test Basics","doc":"Support libraries contain functions that are useful for all test suites, or for\ntest suites in a specific functional area or subsystem. In addition to the\ngeneral support libraries provided by the `Common Test` framework, and the\nvarious libraries and applications provided by Erlang/OTP, there can also be a\nneed for customized (user specific) support libraries.","ref":"basics_chapter.html#support-libraries"},{"type":"extras","title":"Suites and Test Cases - Common Test Basics","doc":"Testing is performed by running test suites (sets of test cases) or individual\ntest cases. A test suite is implemented as an Erlang module named\n` _SUITE.erl` which contains a number of test cases. A test case is\nan Erlang function that tests one or more things. The test case is the smallest\nunit that the `Common Test` test server deals with.\n\nSets of test cases, called test case groups, can also be defined. A test case\ngroup can have execution properties associated with it. Execution properties\nspecify if the test cases in the group are to be executed in random order, in\nparallel, or in sequence, and if the execution of the group is to be repeated.\nTest case groups can also be nested (that is, a group can, besides test cases,\ncontain subgroups).\n\nBesides test cases and groups, the test suite can also contain configuration\nfunctions. These functions are meant to be used for setting up (and verifying)\nenvironment and state in the SUT (and/or the `Common Test` host node), required\nfor the tests to execute correctly. Examples of operations are: Opening a\nconnection to the SUT, initializing a database, running an installation script,\nand so on. Configuration can be performed per suite, per test case group, and\nper individual test case.\n\nThe test suite module must conform to a [callback interface](`m:ct_suite`)\nspecified by the `Common Test` test server. For details, see section\n[Writing Test Suites](write_test_chapter.md#intro).\n\nA test case is considered successful if it returns to the caller, no matter what\nthe returned value is. However, a few return values have special meaning as\nfollows:\n\n- `{skip,Reason}` indicates that the test case is skipped.\n- `{comment,Comment}` prints a comment in the log for the test case.\n- `{save_config,Config}` makes the `Common Test` test server pass `Config` to\n  the next test case.\n\nA test case failure is specified as a runtime error (a crash), no matter what\nthe reason for termination is. If you use Erlang pattern matching effectively,\nyou can take advantage of this property. The result is concise and readable test\ncase functions that look much more like scripts than actual programs. A simple\nexample:\n\n```erlang\nsession(_Config) ->\n    {started,ServerId} = my_server:start(),\n    {clients,[]} = my_server:get_clients(ServerId),\n    MyId = self(),\n    connected = my_server:connect(ServerId, MyId),\n    {clients,[MyId]} = my_server:get_clients(ServerId),\n    disconnected = my_server:disconnect(ServerId, MyId),\n    {clients,[]} = my_server:get_clients(ServerId),\n    stopped = my_server:stop(ServerId).\n```\n\nAs a test suite runs, all information (including output to `stdout`) is recorded\nin many different log files. A minimum of information is displayed in the user\nconsole (only start and stop information, plus a note for each failed test\ncase).\n\nThe result from each test case is recorded in a dedicated HTML log file, created\nfor the particular test run. An overview page displays each test case\nrepresented by a table row showing total execution time, if the case was\nsuccessful, failed, or skipped, plus an optional user comment. For a failed test\ncase, the reason for termination is also printed in the comment field. The\noverview page has a link to each test case log file, providing simple navigation\nwith any standard HTML browser.\n\n> #### Note {: .info }\n>\n> In the last row where totals are presented the time shown here is a sum of\n> rows, which are above (not accounting for parallel testcases).\n> On the other hand \"Elapsed Time\" is a clock time spent to run testcases.\n>\n\n[](){: #External_Interfaces }","ref":"basics_chapter.html#suites-and-test-cases"},{"type":"extras","title":"External Interfaces - Common Test Basics","doc":"The `Common Test` test server requires that the test suite defines and exports\nthe following mandatory or optional callback functions:\n\n- **`all()`** - Returns a list of all test cases and groups in the suite.\n  (Mandatory)\n\n- **`suite()`** - Information function used to return properties for the suite.\n  (Optional)\n\n- **`groups()`** - For declaring test case groups. (Optional)\n\n- **`init_per_suite(Config)`** - Suite level configuration function, executed\n  before the first test case. (Optional)\n\n- **`end_per_suite(Config)`** - Suite level configuration function, executed\n  after the last test case. (Optional)\n\n- **`group(GroupName)`** - Information function used to return properties for a\n  test case group. (Optional)\n\n- **`init_per_group(GroupName, Config)`** - Configuration function for a group,\n  executed before the first test case. (Optional)\n\n- **`end_per_group(GroupName, Config)`** - Configuration function for a group,\n  executed after the last test case. (Optional)\n\n- **`init_per_testcase(TestCase, Config)`** - Configuration function for a\n  testcase, executed before each test case. (Optional)\n\n- **`end_per_testcase(TestCase, Config)`** - Configuration function for a\n  testcase, executed after each test case. (Optional)\n\nFor each test case, the `Common Test` test server expects the following\nfunctions:\n\n- **Testcasename()** - Information function that returns a list of test case\n  properties. (Optional)\n\n- **Testcasename(Config)** - The test case function.","ref":"basics_chapter.html#external-interfaces"},{"type":"extras","title":"Getting Started","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Getting Started","ref":"getting_started_chapter.html"},{"type":"extras","title":"Introduction for Newcomers - Getting Started","doc":"The purpose of this section is to let the newcomer get started in quickly\nwriting and executing some first simple tests with a \"learning by example\"\napproach. Most explanations are left for later sections. If you are not much\ninto \"learning by example\" and prefer more technical details, go ahead and skip\nto the next section.\n\nThis section demonstrates how simple it is to write a basic (yet for many module\ntesting purposes, often sufficiently complex) test suite and execute its test\ncases. This is not necessarily obvious when you read the remaining sections in\nthis User's Guide.\n\n> #### Note {: .info }\n>\n> To understand what is discussed and examplified here, we recommended you to\n> first read section [Common Test Basics](basics_chapter.md#basics).","ref":"getting_started_chapter.html#introduction-for-newcomers"},{"type":"extras","title":"Test Case Execution - Getting Started","doc":"Execution of test cases is handled as follows:\n\n![Successful and Unsuccessful Test Case Execution](assets/tc_execution.gif \"Successful and Unsuccessful Test Case Execution\")\n\nFor each test case that `Common Test` is ordered to execute, it spawns a\ndedicated process on which the test case function starts running. (In parallel\nto the test case process, an idle waiting timer process is started, which is\nlinked to the test case process. If the timer process runs out of waiting time,\nit sends an exit signal to terminate the test case process. This is called a\n_timetrap_).\n\nIn scenario 1, the test case process terminates normally after `case A` has\nfinished executing its test code without detecting any errors. The test case\nfunction returns a value and `Common Test` logs the test case as successful.\n\nIn scenario 2, an error is detected during test `case B` execution. This causes\nthe test `case B` function to generate an exception and, as a result, the test\ncase process exits with reason other than normal. `Common Test` logs this as an\nunsuccessful (Failed) test case.\n\nAs you can understand from the illustration, `Common Test` requires a test case\nto generate a runtime error to indicate failure (for example, by causing a bad\nmatch error or by calling [`exit/1`](`exit/1`), preferably through the help\nfunction [`ct:fail/1,2`](`ct:fail/1`)). A successful execution is indicated by a\nnormal return from the test case function.","ref":"getting_started_chapter.html#test-case-execution"},{"type":"extras","title":"A Simple Test Suite - Getting Started","doc":"As shown in section [Common Test Basics](basics_chapter.md#External_Interfaces),\nthe test suite module implements [callback functions](`m:ct_suite`) (mandatory\nor optional) for various purposes, for example:\n\n- Init/end configuration function for the test suite\n- Init/end configuration function for a test case\n- Init/end configuration function for a test case group\n- Test cases\n\nThe configuration functions are optional. The following example is a test suite\nwithout configuration functions, including one simple test case, to check that\nmodule `mymod` exists (that is, can be successfully loaded by the code server):\n\n```erlang\n-module(my1st_SUITE).\n-compile(export_all).\n\nall() ->\n    [mod_exists].\n\nmod_exists(_) ->\n    {module,mymod} = code:load_file(mymod).\n```\n\nIf the operation fails, a bad match error occurs that terminates the test case.","ref":"getting_started_chapter.html#a-simple-test-suite"},{"type":"extras","title":"A Test Suite with Configuration Functions - Getting Started","doc":"If you need to perform configuration operations to run your test, you can\nimplement configuration functions in your suite. The result from a configuration\nfunction is configuration data, or `Config`. This is a list of key-value tuples\nthat get passed from the configuration function to the test cases (possibly\nthrough configuration functions on \"lower level\"). The data flow looks as\nfollows:\n\n![Configuration Data Flow in a Suite](assets/config.gif \"Configuration Data Flow in a Suite\")\n\nThe following example shows a test suite that uses configuration functions to\nopen and close a log file for the test cases (an operation that is unnecessary\nand irrelevant to perform by each test case):\n\n```erlang\n-module(check_log_SUITE).\n-export([all/0, init_per_suite/1, end_per_suite/1]).\n-export([check_restart_result/1, check_no_errors/1]).\n\n-define(value(Key,Config), proplists:get_value(Key,Config)).\n\nall() -> [check_restart_result, check_no_errors].\n\ninit_per_suite(InitConfigData) ->\n    [{logref,open_log()} | InitConfigData].\n\nend_per_suite(ConfigData) ->\n    close_log(?value(logref, ConfigData)).\n\ncheck_restart_result(ConfigData) ->\n    TestData = read_log(restart, ?value(logref, ConfigData)),\n    {match,_Line} = search_for(\"restart successful\", TestData).\n\ncheck_no_errors(ConfigData) ->\n    TestData = read_log(all, ?value(logref, ConfigData)),\n    case search_for(\"error\", TestData) of\n        {match,Line} -> ct:fail({error_found_in_log,Line});\n        nomatch -> ok\n    end.\n```\n\nThe test cases verify, by parsing a log file, that our SUT has performed a\nsuccessful restart and that no unexpected errors are printed.\n\nTo execute the test cases in the recent test suite, type the following on the\nUNIX/Linux command line (assuming that the suite module is in the current\nworking directory):\n\n```text\n$ ct_run -dir .\n```\n\nor:\n\n```text\n$ ct_run -suite check_log_SUITE\n```\n\nTo use the Erlang shell to run our test, you can evaluate the following call:\n\n```erlang\n1> ct:run_test([{dir, \".\"}]).\n```\n\nor:\n\n```erlang\n1> ct:run_test([{suite, \"check_log_SUITE\"}]).\n```\n\nThe result from running the test is printed in log files in HTML format (stored\nin unique log directories on a different level). The following illustration\nshows the log file structure:\n\n![HTML Log File Structure](assets/html_logs.gif \"HTML Log File Structure\")","ref":"getting_started_chapter.html#a-test-suite-with-configuration-functions"},{"type":"extras","title":"Questions and Answers - Getting Started","doc":"Here follows some questions that you might have after reading this section with\ncorresponding tips and links to the answers:\n\n- _Question:_ \"How and where can I specify variable data for my tests that must\n  not be hard-coded in the test suites (such as hostnames, addresses, and user\n  login data)?\"\n\n  _Answer:_ See section\n  [External Configuration Data](config_file_chapter.md#top).\n\n- _Question:_ \"Is there a way to declare different tests and run them in one\n  session without having to write my own scripts? Also, can such declarations be\n  used for regression testing?\"\n\n  _Answer:_ See section\n  [Test Specifications](run_test_chapter.md#test_specifications) in section\n  Running Tests and Analyzing Results.\n\n- _Question:_ \"Can test cases and/or test runs be automatically repeated?\"\n\n  _Answer:_ Learn more about\n  [Test Case Groups](write_test_chapter.md#test_case_groups) and read about\n  start flags/options in section [Running Tests](run_test_chapter.md#ct_run) and\n  in the Reference Manual.\n\n- _Question:_ \"Does `Common Test` execute my test cases in sequence or in\n  parallel?\"\n\n  _Answer:_ See [Test Case Groups](write_test_chapter.md#test_case_groups) in\n  section Writing Test Suites.\n\n- _Question:_ \"What is the syntax for timetraps (mentioned earlier), and how do\n  I set them?\"\n\n  _Answer:_ This is explained in the\n  [Timetrap Time-Outs](write_test_chapter.md#timetraps) part of section Writing\n  Test Suites.\n\n- _Question:_ \"What functions are available for logging and printing?\"\n\n  _Answer:_ See [Logging](write_test_chapter.md#logging) in section Writing Test\n  Suites.\n\n- _Question:_ \"I need data files for my tests. Where do I store them\n  preferably?\"\n\n  _Answer:_ See\n  [Data and Private Directories](write_test_chapter.md#data_priv_dir).\n\n- _Question:_ \"Can I start with a test suite example, please?\"\n\n  _Answer:_ [Welcome\\!](example_chapter.md#top)\n\nYou probably want to get started on your own first test suites now, while at the\nsame time digging deeper into the `Common Test` User's Guide and Reference\nManual. There are much more to learn about the things that have been introduced\nin this section. There are also many other useful features to learn, so please\ncontinue to the other sections and have fun.","ref":"getting_started_chapter.html#questions-and-answers"},{"type":"extras","title":"Installation","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Installation\n\n[](){: #general }","ref":"install_chapter.html"},{"type":"extras","title":"General Information - Installation","doc":"The two main interfaces for running tests with `Common Test` are an executable\nprogram named [`ct_run`](ct_run_cmd.md) and the Erlang module `m:ct`. `ct_run`\nis compiled for the underlying operating system (for example, Unix/Linux or\nWindows) during the build of the Erlang/OTP system, and is installed\nautomatically with other executable programs in the top level `bin` directory of\nErlang/OTP. The `ct` interface functions can be called from the Erlang shell, or\nfrom any Erlang function, on any supported platform.\n\nThe `Common Test` application is installed with the Erlang/OTP system. No extra\ninstallation step is required to start using `Common Test` through the `ct_run`\nexecutable program, and/or the interface functions in the `ct` module.","ref":"install_chapter.html#general-information"},{"type":"extras","title":"Writing Test Suites","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Writing Test Suites\n\n[](){: #intro }","ref":"write_test_chapter.html"},{"type":"extras","title":"Support for Test Suite Authors - Writing Test Suites","doc":"The `m:ct` module provides the main interface for writing test cases. This\nincludes for example, the following:\n\n- Functions for printing and logging\n- Functions for reading configuration data\n- Function for terminating a test case with error reason\n- Function for adding comments to the HTML overview page\n\nFor details about these functions, see module `m:ct`.\n\nThe `Common Test` application also includes other modules named\n`ct_ `, which provide various support, mainly simplified use of\ncommunication protocols such as RPC, SNMP, FTP, Telnet, and others.","ref":"write_test_chapter.html#support-for-test-suite-authors"},{"type":"extras","title":"Test Suites - Writing Test Suites","doc":"A test suite is an ordinary Erlang module that contains test cases. It is\nrecommended that the module has a name on the form `*_SUITE.erl`. Otherwise, the\ndirectory and auto compilation function in `Common Test` cannot locate it (at\nleast not by default).\n\nIt is also recommended that the `ct.hrl` header file is included in all test\nsuite modules.\n\nEach test suite module must export function [`all/0`](`c:ct_suite:all/0`), which\nreturns the list of all test case groups and test cases to be executed in that\nmodule.\n\nThe callback functions to be implemented by the test suite are all listed in\nmodule [ct_suite ](`m:ct_suite`). They are also described in more detail later\nin this User's Guide.","ref":"write_test_chapter.html#test-suites"},{"type":"extras","title":"Init and End per Suite - Writing Test Suites","doc":"Each test suite module can contain the optional configuration functions\n[`init_per_suite/1`](`c:ct_suite:init_per_suite/1`) and\n[`end_per_suite/1`](`c:ct_suite:end_per_suite/1`). If the init function is\ndefined, so must the end function be.\n\nIf `init_per_suite` exists, it is called initially before the test cases are\nexecuted. It typically contains initializations common for all test cases in the\nsuite, which are only to be performed once. `init_per_suite` is recommended for\nsetting up and verifying state and environment on the System Under Test (SUT) or\nthe `Common Test` host node, or both, so that the test cases in the suite\nexecutes correctly. The following are examples of initial configuration\noperations:\n\n- Opening a connection to the SUT\n- Initializing a database\n- Running an installation script\n\n`end_per_suite` is called as the final stage of the test suite execution (after\nthe last test case has finished). The function is meant to be used for cleaning\nup after `init_per_suite`.\n\n`init_per_suite` and `end_per_suite` execute on dedicated Erlang processes, just\nlike the test cases do. The result of these functions is however not included in\nthe test run statistics of successful, failed, and skipped cases.\n\nThe argument to `init_per_suite` is `Config`, that is, the same key-value list\nof runtime configuration data that each test case takes as input argument.\n`init_per_suite` can modify this parameter with information that the test cases\nneed. The possibly modified `Config` list is the return value of the function.\n\nIf `init_per_suite` fails, all test cases in the test suite are skipped\nautomatically (so called _auto skipped_), including `end_per_suite`.\n\nNotice that if `init_per_suite` and `end_per_suite` do not exist in the suite,\n`Common Test` calls dummy functions (with the same names) instead, so that\noutput generated by hook functions can be saved to the log files for these\ndummies. For details, see [Common Test Hooks](ct_hooks_chapter.md#manipulating).\n\n[](){: #per_testcase }","ref":"write_test_chapter.html#init-and-end-per-suite"},{"type":"extras","title":"Init and End per Test Case - Writing Test Suites","doc":"Each test suite module can contain the optional configuration functions\n[`init_per_testcase/2`](`c:ct_suite:init_per_testcase/2`) and\n[`end_per_testcase/2`](`c:ct_suite:end_per_testcase/2`). If the init function is\ndefined, so must the end function be.\n\nIf `init_per_testcase` exists, it is called before each test case in the suite.\nIt typically contains initialization that must be done for each test case\n(analog to `init_per_suite` for the suite).\n\n`end_per_testcase/2` is called after each test case has finished, enabling\ncleanup after `init_per_testcase`.\n\n> #### Note {: .info }\n>\n> If `end_per_testcase` crashes, however, test results are unaffected. At the\n> same time, this occurrence is reported in the test execution logs.\n\nThe first argument to these functions is the name of the test case. This value\ncan be used with pattern matching in function clauses or conditional expressions\nto choose different initialization and cleanup routines for different test\ncases, or perform the same routine for many, or all, test cases.\n\nThe second argument is the `Config` key-value list of runtime configuration\ndata, which has the same value as the list returned by `init_per_suite`.\n`init_per_testcase/2` can modify this parameter or return it \"as is\". The return\nvalue of `init_per_testcase/2` is passed as parameter `Config` to the test case\nitself.\n\nThe return value of `end_per_testcase/2` is ignored by the test server, with\nexception of the [`save_config`](dependencies_chapter.md#save_config) and `fail`\ntuple.\n\n`end_per_testcase` can check if the test case was successful. (which in turn can\ndetermine how cleanup is to be performed). This is done by reading the value\ntagged with `tc_status` from `Config`. The value is one of the following:\n\n- `ok`\n- `{failed,Reason}`\n\n  where `Reason` is `timetrap_timeout`, information from [`exit/1`](`exit/1`),\n  or details of a runtime error\n\n- `{skipped,Reason}`\n\n  where `Reason` is a user-specific term\n\nFunction `end_per_testcase/2` is even called if a test case terminates because\nof a call to `ct:abort_current_testcase/1`, or after a timetrap time-out.\nHowever, `end_per_testcase` then executes on a different process than the test\ncase function. In this situation, `end_per_testcase` cannot change the reason\nfor test case termination by returning `{fail,Reason}` or save data with\n`{save_config,Data}`.\n\nThe test case is skipped in the following two cases:\n\n- If `init_per_testcase` crashes (called _auto skipped_).\n- If `init_per_testcase` returns a tuple `{skip,Reason}` (called _user\n  skipped_).\n\nThe test case can also be marked as failed without executing it by returning a\ntuple `{fail,Reason}` from `init_per_testcase`.\n\n> #### Note {: .info }\n>\n> If `init_per_testcase` crashes, or returns `{skip,Reason}` or `{fail,Reason}`,\n> function `end_per_testcase` is not called.\n\nIf it is determined during execution of `end_per_testcase` that the status of a\nsuccessful test case is to be changed to failed, `end_per_testcase` can return\nthe tuple `{fail,Reason}` (where `Reason` describes why the test case fails).\n\nAs `init_per_testcase` and `end_per_testcase` execute on the same Erlang process\nas the test case, printouts from these configuration functions are included in\nthe test case log file.\n\n[](){: #test_cases }","ref":"write_test_chapter.html#init-and-end-per-test-case"},{"type":"extras","title":"Test Cases - Writing Test Suites","doc":"The smallest unit that the test server is concerned with is a test case. Each\ntest case can test many things, for example, make several calls to the same\ninterface function with different parameters.\n\nThe author can choose to put many or few tests into each test case. Some things\nto keep in mind follows:\n\n- Many small test cases tend to result in extra, and possibly duplicated code,\n  as well as slow test execution because of large overhead for initializations\n  and cleanups. Avoid duplicated code, for example, by using common help\n  functions. Otherwise, the resulting suite becomes difficult to read and\n  understand, and expensive to maintain.\n- Larger test cases make it harder to tell what went wrong if it fails. Also,\n  large portions of test code risk being skipped when errors occur.\n- Readability and maintainability suffer when test cases become too large and\n  extensive. It is not certain that the resulting log files reflect very well\n  the number of tests performed.\n\nThe test case function takes one argument, `Config`, which contains\nconfiguration information such as `data_dir` and `priv_dir`. (For details about\nthese, see section\n[Data and Private Directories](write_test_chapter.md#data_priv_dir). The value\nof `Config` at the time of the call, is the same as the return value from\n`init_per_testcase`, mentioned earlier.\n\n> #### Note {: .info }\n>\n> The test case function argument `Config` is not to be confused with the\n> information that can be retrieved from the configuration files (using\n> [`ct:get_config/1/2`](`ct:get_config/1`)). The test case argument `Config` is\n> to be used for runtime configuration of the test suite and the test cases,\n> while configuration files are to contain data related to the SUT. These two\n> types of configuration data are handled differently.\n\nAs parameter `Config` is a list of key-value tuples, that is, a data type called\na property list, it can be handled by the `m:proplists` module. A value can, for\nexample, be searched for and returned with function `proplists:get_value/2`.\nAlso, or alternatively, the general `m:lists` module contains useful functions.\nNormally, the only operations performed on `Config` are insertion (adding a\ntuple to the head of the list) and lookup. To look up a value in the config,\n`proplists:get_value` can be used. For example:\n`PrivDir = proplists:get_value(priv_dir, Config)`.\n\nThe test case result can be customized in several ways. See the manual for\n[`Module:Testcase/1`](`c:ct_suite:'Testcase'/1`) in the `m:ct_suite` module for\ndetails.\n\n[](){: #info_function }","ref":"write_test_chapter.html#test-cases"},{"type":"extras","title":"Test Case Information Function - Writing Test Suites","doc":"For each test case function there can be an extra function with the same name\nbut without arguments. This is the test case information function. It is\nexpected to return a list of tagged tuples that specifies various properties\nregarding the test case.\n\nThe following tags have special meaning:\n\n- **`timetrap`** - Sets the maximum time the test case is allowed to execute. If\n  this time is exceeded, the test case fails with reason `timetrap_timeout`.\n  Notice that `init_per_testcase` and `end_per_testcase` are included in the\n  timetrap time. For details, see section\n  [Timetrap Time-Outs](write_test_chapter.md#timetraps).\n\n- **`userdata`** - Specifies any data related to the test case. This data can be\n  retrieved at any time using the `ct:userdata/3` utility function.\n\n- **`silent_connections`** - For details, see section\n  [Silent Connections](run_test_chapter.md#silent_connections).\n\n- **`require`** - Specifies configuration variables required by the test case.\n  If the required configuration variables are not found in any of the test\n  system configuration files, the test case is skipped.\n\n  A required variable can also be given a default value to be used if the\n  variable is not found in any configuration file. To specify a default value,\n  add a tuple on the form `{default_config,ConfigVariableName,Value}` to the\n  test case information list (the position in the list is irrelevant).\n\n  _Examples:_\n\n  ```erlang\n  testcase1() ->\n      [{require, ftp},\n       {default_config, ftp, [{ftp, \"my_ftp_host\"},\n                              {username, \"aladdin\"},\n                              {password, \"sesame\"}]}}].\n  ```\n\n  ```erlang\n  testcase2() ->\n      [{require, unix_telnet, unix},\n       {require, {unix, [telnet, username, password]}},\n       {default_config, unix, [{telnet, \"my_telnet_host\"},\n                               {username, \"aladdin\"},\n                               {password, \"sesame\"}]}}].\n  ```\n\nFor more information about `require`, see section\n[Requiring and Reading Configuration Data](config_file_chapter.md#require_config_data)\nin section External Configuration Data and function\n[`ct:require/1/2`](`ct:require/1`).\n\n> #### Note {: .info }\n>\n> Specifying a default value for a required variable can result in a test case\n> always getting executed. This might not be a desired behavior.\n\nIf `timetrap` or `require`, or both, is not set specifically for a particular\ntest case, default values specified by function\n[`suite/0`](`c:ct_suite:suite/0`) are used.\n\nTags other than the earlier mentioned are ignored by the test server.\n\nAn example of a test case information function follows:\n\n```erlang\nreboot_node() ->\n    [\n     {timetrap,{seconds,60}},\n     {require,interfaces},\n     {userdata,\n         [{description,\"System Upgrade: RpuAddition Normal RebootNode\"},\n          {fts,\"http://someserver.ericsson.se/test_doc4711.pdf\"}]}\n    ].\n```\n\n[](){: #suite }","ref":"write_test_chapter.html#test-case-information-function"},{"type":"extras","title":"Test Suite Information Function - Writing Test Suites","doc":"Function [`suite/0`](`c:ct_suite:suite/0`) can, for example, be used in a test\nsuite module to set a default `timetrap` value and to `require` external\nconfiguration data. If a test case, or a group information function also\nspecifies any of the information tags, it overrides the default values set by\n`suite/0`. For details, see\n[Test Case Information Function](write_test_chapter.md#info_function) and\n[Test Case Groups](write_test_chapter.md#test_case_groups).\n\nThe following options can also be specified with the suite information list:\n\n- `stylesheet`, see [HTML Style Sheets](run_test_chapter.md#html_stylesheet)\n- `userdata`, see\n  [Test Case Information Function](write_test_chapter.md#info_function)\n- `silent_connections`, see\n  [Silent Connections](run_test_chapter.md#silent_connections)\n\nAn example of the suite information function follows:\n\n```erlang\nsuite() ->\n    [\n     {timetrap,{minutes,10}},\n     {require,global_names},\n     {userdata,[{info,\"This suite tests database transactions.\"}]},\n     {silent_connections,[telnet]},\n     {stylesheet,\"db_testing.css\"}\n    ].\n```\n\n[](){: #test_case_groups }","ref":"write_test_chapter.html#test-suite-information-function"},{"type":"extras","title":"Test Case Groups - Writing Test Suites","doc":"A test case group is a set of test cases sharing configuration functions and\nexecution properties. Test case groups are defined by function\n[`groups/0`](`c:ct_suite:groups/0`) that should return a term having the\nfollowing syntax:\n\n```text\ngroups() -> GroupDefs\n\nTypes:\n\nGroupDefs = [GroupDef]\nGroupDef = {GroupName,Properties,GroupsAndTestCases}\nGroupName = atom()\nGroupsAndTestCases = [GroupDef | {group,GroupName} | TestCase |\n                     {testcase,TestCase,TCRepeatProps}]\nTestCase = atom()\nTCRepeatProps = [{repeat,N} | {repeat_until_ok,N} | {repeat_until_fail,N}]\n```\n\n`GroupName` is the name of the group and must be unique within the test suite\nmodule. Groups can be nested, by including a group definition within the\n`GroupsAndTestCases` list of another group. `Properties` is the list of\nexecution properties for the group. The possible values are as follows:\n\n```erlang\nProperties = [parallel | sequence | Shuffle | {GroupRepeatType,N}]\nShuffle = shuffle | {shuffle,Seed}\nSeed = {integer(),integer(),integer()}\nGroupRepeatType = repeat | repeat_until_all_ok | repeat_until_all_fail |\n                  repeat_until_any_ok | repeat_until_any_fail\nN = integer() | forever\n```\n\n_Explanations:_\n\n- **`parallel`** - `Common Test` executes all test cases in the group in\n  parallel.\n\n- **`sequence`** - The cases are executed in a sequence as described in section\n  [Sequences](dependencies_chapter.md#sequences) in section Dependencies Between\n  Test Cases and Suites.\n\n- **`shuffle`** - The cases in the group are executed in random order.\n\n- **`repeat, repeat_until_*`** - Orders `Common Test` to repeat execution of all\n  the cases in the group a given number of times, or until any, or all, cases\n  fail or succeed.\n\n_Example:_\n\n```erlang\ngroups() -> [{group1, [parallel], [test1a,test1b]},\n             {group2, [shuffle,sequence], [test2a,test2b,test2c]}].\n```\n\nTo specify in which order groups are to be executed (also with respect to test\ncases that are not part of any group), add tuples on the form\n`{group,GroupName}` to the `all/0` list.\n\n_Example:_\n\n```erlang\nall() -> [testcase1, {group,group1}, {testcase,testcase2,[{repeat,10}]}, {group,group2}].\n```\n\nExecution properties with a group tuple in `all/0`:\n`{group,GroupName,Properties}` can also be specified. These properties override\nthose specified in the group definition (see `groups/0` earlier). This way, the\nsame set of tests can be run, but with different properties, without having to\nmake copies of the group definition in question.\n\nIf a group contains subgroups, the execution properties for these can also be\nspecified in the group tuple: `{group,GroupName,Properties,SubGroups}` Where,\n`SubGroups` is a list of tuples, `{GroupName,Properties}` or\n`{GroupName,Properties,SubGroups}` representing the subgroups. Any subgroups\ndefined in `groups/0` for a group, that are not specified in the `SubGroups`\nlist, executes with their predefined properties.\n\n_Example:_\n\n```erlang\ngroups() -> [{tests1, [], [{tests2, [], [t2a,t2b]},\n                          {tests3, [], [t31,t3b]}]}].\n```\n\nTo execute group `tests1` twice with different properties for `tests2` each\ntime:\n\n```erlang\nall() ->\n   [{group, tests1, default, [{tests2, [parallel]}]},\n    {group, tests1, default, [{tests2, [shuffle,{repeat,10}]}]}].\n```\n\nThis is equivalent to the following specification:\n\n```erlang\nall() ->\n   [{group, tests1, default, [{tests2, [parallel]},\n                              {tests3, default}]},\n    {group, tests1, default, [{tests2, [shuffle,{repeat,10}]},\n                              {tests3, default}]}].\n```\n\nValue `default` states that the predefined properties are to be used.\n\nThe following example shows how to override properties in a scenario with deeply\nnested groups:\n\n```erlang\ngroups() ->\n   [{tests1, [], [{group, tests2}]},\n    {tests2, [], [{group, tests3}]},\n    {tests3, [{repeat,2}], [t3a,t3b,t3c]}].\n\nall() ->\n   [{group, tests1, default,\n     [{tests2, default,\n       [{tests3, [parallel,{repeat,100}]}]}]}].\n```\n\nFor ease of readability, all syntax definitions can be replaced by a function\ncall whose return value should match the expected syntax case.\n\n_Example:_\n\n```erlang\nall() ->\n   [{group, tests1, default, test_cases()},\n    {group, tests1, default, [shuffle_test(),\n                              {tests3, default}]}].\ntest_cases() ->\n   [{tests2, [parallel]}, {tests3, default}].\n\nshuffle_test() ->\n   {tests2, [shuffle,{repeat,10}]}.\n```\n\nThe described syntax can also be used in test specifications to change group\nproperties at the time of execution, without having to edit the test suite. For\nmore information, see section\n[Test Specifications](run_test_chapter.md#test_specifications) in section\nRunning Tests and Analyzing Results.\n\nAs illustrated, properties can be combined. If, for example, `shuffle`,\n`repeat_until_any_fail`, and `sequence` are all specified, the test cases in the\ngroup are executed repeatedly, and in random order, until a test case fails.\nThen execution is immediately stopped and the remaining cases are skipped.\n\nBefore execution of a group begins, the configuration function\n[`init_per_group(GroupName, Config)`](`c:ct_suite:init_per_group/2`) is called.\nThe list of tuples returned from this function is passed to the test cases in\nthe usual manner by argument `Config`. `init_per_group/2` is meant to be used\nfor initializations common for the test cases in the group. After execution of\nthe group is finished, function\n[`end_per_group(GroupName, Config)`](`c:ct_suite:end_per_group/2`) is called.\nThis function is meant to be used for cleaning up after `init_per_group/2`. If\nthe init function is defined, so must the end function be.\n\nWhenever a group is executed, if `init_per_group` and `end_per_group` do not\nexist in the suite, `Common Test` calls dummy functions (with the same names)\ninstead. Output generated by hook functions are saved to the log files for these\ndummies. For more information, see section\n[Manipulating Tests](ct_hooks_chapter.md#manipulating) in section Common Test\nHooks.\n\n> #### Note {: .info }\n>\n> `init_per_testcase/2` and `end_per_testcase/2` are always called for each\n> individual test case, no matter if the case belongs to a group or not.\n\nThe properties for a group are always printed in the top of the HTML log for\n`init_per_group/2`. The total execution time for a group is included at the\nbottom of the log for `end_per_group/2`.\n\nTest case groups can be nested so sets of groups can be configured with the same\n`init_per_group/2` and `end_per_group/2` functions. Nested groups can be defined\nby including a group definition, or a group name reference, in the test case\nlist of another group.\n\n_Example:_\n\n```erlang\ngroups() -> [{group1, [shuffle], [test1a,\n                                  {group2, [], [test2a,test2b]},\n                                  test1b]},\n             {group3, [], [{group,group4},\n                           {group,group5}]},\n             {group4, [parallel], [test4a,test4b]},\n             {group5, [sequence], [test5a,test5b,test5c]}].\n```\n\nIn the previous example, if `all/0` returns group name references in the order\n`[{group,group1},{group,group3}]`, the order of the configuration functions and\ntest cases becomes the following (notice that `init_per_testcase/2` and\n`end_per_testcase/2:` are also always called, but not included in this example\nfor simplification):\n\n```text\ninit_per_group(group1, Config) -> Config1  (*)\n     test1a(Config1)\n     init_per_group(group2, Config1) -> Config2\n          test2a(Config2), test2b(Config2)\n     end_per_group(group2, Config2)\n     test1b(Config1)\nend_per_group(group1, Config1)\ninit_per_group(group3, Config) -> Config3\n     init_per_group(group4, Config3) -> Config4\n          test4a(Config4), test4b(Config4)  (**)\n     end_per_group(group4, Config4)\n     init_per_group(group5, Config3) -> Config5\n          test5a(Config5), test5b(Config5), test5c(Config5)\n     end_per_group(group5, Config5)\nend_per_group(group3, Config3)\n```\n\n(\\*) The order of test case `test1a`, `test1b`, and `group2` is undefined, as\n`group1` has a shuffle property.\n\n(\\*\\*) These cases are not executed in order, but in parallel.\n\nProperties are not inherited from top-level groups to nested subgroups. For\ninstance, in the previous example, the test cases in `group2` are not executed\nin random order (which is the property of `group1`).","ref":"write_test_chapter.html#test-case-groups"},{"type":"extras","title":"Parallel Property and Nested Groups - Writing Test Suites","doc":"If a group has a parallel property, its test cases are spawned simultaneously\nand get executed in parallel. However, a test case is not allowed to execute in\nparallel with `end_per_group/2`, which means that the time to execute a parallel\ngroup is equal to the execution time of the slowest test case in the group. A\nnegative side effect of running test cases in parallel is that the HTML summary\npages are not updated with links to the individual test case logs until function\n`end_per_group/2` for the group has finished.\n\nA group nested under a parallel group starts executing in parallel with previous\n(parallel) test cases (no matter what properties the nested group has). However,\nas test cases are never executed in parallel with `init_per_group/2` or\n`end_per_group/2` of the same group, it is only after a nested group has\nfinished that remaining parallel cases in the previous group become spawned.","ref":"write_test_chapter.html#parallel-property-and-nested-groups"},{"type":"extras","title":"Parallel Test Cases and I/O - Writing Test Suites","doc":"A parallel test case has a private I/O server as its group leader. (For a\ndescription of the group leader concept, see [ERTS](`e:erts:index.html`)). The\ncentral I/O server process, which handles the output from regular test cases and\nconfiguration functions, does not respond to I/O messages during execution of\nparallel groups. This is important to understand to avoid certain traps, like\nthe following:\n\nIf a process, `P`, is spawned during execution of, for example,\n`init_per_suite/1`, it inherits the group leader of the `init_per_suite`\nprocess. This group leader is the central I/O server process mentioned earlier.\nIf, at a later time, _during parallel test case execution_, some event triggers\nprocess `P` to call [`io:format/1/2`](`io:format/1`), that call never returns\n(as the group leader is in a non-responsive state) and causes `P` to hang.","ref":"write_test_chapter.html#parallel-test-cases-and-i-o"},{"type":"extras","title":"Repeated Groups - Writing Test Suites","doc":"[](){: #repeated_groups }\n\nA test case group can be repeated a certain number of times (specified by an\ninteger) or indefinitely (specified by `forever`). The repetition can also be\nstopped too early if any or all cases fail or succeed, that is, if any of the\nproperties `repeat_until_any_fail`, `repeat_until_any_ok`,\n`repeat_until_all_fail`, or `repeat_until_all_ok` is used. If the basic `repeat`\nproperty is used, status of test cases is irrelevant for the repeat operation.\n\nThe status of a subgroup can be returned (`ok` or `failed`), to affect the\nexecution of the group on the level above. This is accomplished by, in\n`end_per_group/2`, looking up the value of `tc_group_properties` in the `Config`\nlist and checking the result of the test cases in the group. If status `failed`\nis to be returned from the group as a result, `end_per_group/2` is to return the\nvalue `{return_group_result,failed}`. The status of a subgroup is taken into\naccount by `Common Test` when evaluating if execution of a group is to be\nrepeated or not (unless the basic `repeat` property is used).\n\nThe value of `tc_group_properties` is a list of status tuples, each with the key\n`ok`, `skipped`, and `failed`. The value of a status tuple is a list with names\nof test cases that have been executed with the corresponding status as result.\n\nThe following is an example of how to return the status from a group:\n\n```erlang\nend_per_group(_Group, Config) ->\n    Status = proplists:get_value(tc_group_result, Config),\n    case proplists:get_value(failed, Status) of\n        [] ->                                   % no failed cases\n            {return_group_result,ok};\n        _Failed ->                              % one or more failed\n            {return_group_result,failed}\n    end.\n```\n\nIt is also possible, in `end_per_group/2`, to check the status of a subgroup\n(maybe to determine what status the current group is to return). This is as\nsimple as illustrated in the previous example, only the group name is stored in\na tuple `{group_result,GroupName}`, which can be searched for in the status\nlists.\n\n_Example:_\n\n```erlang\nend_per_group(group1, Config) ->\n    Status = proplists:get_value(tc_group_result, Config),\n    Failed = proplists:get_value(failed, Status),\n    case lists:member({group_result,group2}, Failed) of\n          true ->\n              {return_group_result,failed};\n          false ->\n              {return_group_result,ok}\n    end;\n...\n```\n\n> #### Note {: .info }\n>\n> When a test case group is repeated, the configuration functions\n> `init_per_group/2` and `end_per_group/2` are also always called with each\n> repetition.","ref":"write_test_chapter.html#repeated-groups"},{"type":"extras","title":"Shuffled Test Case Order - Writing Test Suites","doc":"The order in which test cases in a group are executed is under normal\ncircumstances the same as the order specified in the test case list in the group\ndefinition. With property `shuffle` set, however, `Common Test` instead executes\nthe test cases in random order.\n\nYou can provide a seed value (a tuple of three integers) with the shuffle\nproperty `{shuffle,Seed}`. This way, the same shuffling order can be created\nevery time the group is executed. If no seed value is specified, `Common Test`\ncreates a \"random\" seed for the shuffling operation (using the return value of\n`erlang:timestamp/0`). The seed value is always printed to the\n`init_per_group/2` log file so that it can be used to recreate the same\nexecution order in a subsequent test run.\n\n> #### Note {: .info }\n>\n> If a shuffled test case group is repeated, the seed is not reset between\n> turns.\n\nIf a subgroup is specified in a group with a `shuffle` property, the execution\norder of this subgroup in relation to the test cases (and other subgroups) in\nthe group, is random. The order of the test cases in the subgroup is however not\nrandom (unless the subgroup has a `shuffle` property).\n\n[](){: #group_info }","ref":"write_test_chapter.html#shuffled-test-case-order"},{"type":"extras","title":"Group Information Function - Writing Test Suites","doc":"The test case group information function, `group(GroupName)`, serves the same\npurpose as the suite- and test case information functions previously described.\nHowever, the scope for the group information function, is all test cases and\nsubgroups in the group in question (`GroupName`).\n\n_Example:_\n\n```erlang\ngroup(connection_tests) ->\n   [{require,login_data},\n    {timetrap,1000}].\n```\n\nThe group information properties override those set with the suite information\nfunction, and can in turn be overridden by test case information properties. For\na list of valid information properties and more general information, see the\n[Test Case Information Function](write_test_chapter.md#info_function).","ref":"write_test_chapter.html#group-information-function"},{"type":"extras","title":"Information Functions for Init- and End-Configuration - Writing Test Suites","doc":"Information functions can also be used for functions `init_per_suite`,\n`end_per_suite`, `init_per_group`, and `end_per_group`, and they work the same\nway as with the\n[Test Case Information Function](write_test_chapter.md#info_function). This is\nuseful, for example, for setting timetraps and requiring external configuration\ndata relevant only for the configuration function in question (without affecting\nproperties set for groups and test cases in the suite).\n\nThe information function `init/end_per_suite()` is called for\n`init/end_per_suite(Config)`, and information function\n`init/end_per_group(GroupName)` is called for\n`init/end_per_group(GroupName,Config)`. However, information functions cannot be\nused with `init/end_per_testcase(TestCase, Config)`, as these configuration\nfunctions execute on the test case process and use the same properties as the\ntest case (that is, the properties set by the test case information function,\n`TestCase()`). For a list of valid information properties and more general\ninformation, see the\n[Test Case Information Function](write_test_chapter.md#info_function).\n\n[](){: #data_priv_dir }","ref":"write_test_chapter.html#information-functions-for-init-and-end-configuration"},{"type":"extras","title":"Data and Private Directories - Writing Test Suites","doc":"In the data directory, `data_dir`, the test module has its own files needed for\nthe testing. The name of `data_dir` is the name of the test suite followed by\n`\"_data\"`. For example, `\"some_path/foo_SUITE.beam\"` has the data directory\n`\"some_path/foo_SUITE_data/\"`. Use this directory for portability, that is, to\navoid hardcoding directory names in your suite. As the data directory is stored\nin the same directory as your test suite, you can rely on its existence at\nruntime, even if the path to your test suite directory has changed between test\nsuite implementation and execution.\n\n`priv_dir` is the private directory for the test cases. This directory can be\nused whenever a test case (or configuration function) needs to write something\nto file. The name of the private directory is generated by `Common Test`, which\nalso creates the directory.\n\nBy default, `Common Test` creates one central private directory per test run,\nshared by all test cases. This is not always suitable. Especially if the same\ntest cases are executed multiple times during a test run (that is, if they\nbelong to a test case group with property `repeat`) and there is a risk that\nfiles in the private directory get overwritten. Under these circumstances,\n`Common Test` can be configured to create one dedicated private directory per\ntest case and execution instead. This is accomplished with the flag/option\n`create_priv_dir` (to be used with the [`ct_run`](ct_run_cmd.md) program, the\n`ct:run_test/1` function, or as test specification term). There are three\npossible values for this option as follows:\n\n- `auto_per_run`\n- `auto_per_tc`\n- `manual_per_tc`\n\nThe first value indicates the default `priv_dir` behavior, that is, one private\ndirectory created per test run. The two latter values tell `Common Test` to\ngenerate a unique test directory name per test case and execution. If the auto\nversion is used, _all_ private directories are created automatically. This can\nbecome very inefficient for test runs with many test cases or repetitions, or\nboth. Therefore, if the manual version is used instead, the test case must tell\n`Common Test` to create `priv_dir` when it needs it. It does this by calling the\nfunction `ct:make_priv_dir/0`.\n\n> #### Note {: .info }\n>\n> Do not depend on the current working directory for reading and writing data\n> files, as this is not portable. All scratch files are to be written in the\n> `priv_dir` and all data files are to be located in `data_dir`. Also, the\n> `Common Test` server sets the current working directory to the test case log\n> directory at the start of every case.","ref":"write_test_chapter.html#data-and-private-directories"},{"type":"extras","title":"Execution Environment - Writing Test Suites","doc":"Each test case is executed by a dedicated Erlang process. The process is spawned\nwhen the test case starts, and terminated when the test case is finished. The\nconfiguration functions `init_per_testcase` and `end_per_testcase` execute on\nthe same process as the test case.\n\nThe configuration functions `init_per_suite` and `end_per_suite` execute, like\ntest cases, on dedicated Erlang processes.\n\n[](){: #timetraps }","ref":"write_test_chapter.html#execution-environment"},{"type":"extras","title":"Timetrap Time-Outs - Writing Test Suites","doc":"The default time limit for a test case is 30 minutes, unless a `timetrap` is\nspecified either by the suite-, group-, or test case information function. The\ntimetrap time-out value defined by `suite/0` is the value that is used for each\ntest case in the suite (and for the configuration functions `init_per_suite/1`,\n`end_per_suite/1`, `init_per_group/2`, and `end_per_group/2`). A timetrap value\ndefined by `group(GroupName)` overrides one defined by `suite()` and is used for\neach test case in group `GroupName`, and any of its subgroups. If a timetrap\nvalue is defined by `group/1` for a subgroup, it overrides that of its higher\nlevel groups. Timetrap values set by individual test cases (by the test case\ninformation function) override both group- and suite- level timetraps.\n\nA timetrap can also be set or reset dynamically during the execution of a test\ncase, or configuration function. This is done by calling `ct:timetrap/1`. This\nfunction cancels the current timetrap and starts a new one (that stays active\nuntil time-out, or end of the current function).\n\nTimetrap values can be extended with a multiplier value specified at startup\nwith option `multiply_timetraps`. It is also possible to let the test server\ndecide to scale up timetrap time-out values automatically. That is, if tools\nsuch as `cover` or `trace` are running during the test. This feature is disabled\nby default and can be enabled with start option `scale_timetraps`.\n\nIf a test case needs to suspend itself for a time that also gets multiplied by\n`multiply_timetraps` (and possibly also scaled up if `scale_timetraps` is\nenabled), the function `ct:sleep/1` can be used (instead of, for example,\n`timer:sleep/1`).\n\nA function (`fun/0` or `{Mod,Func,Args}` (MFA) tuple) can be specified as\ntimetrap value in the suite-, group- and test case information function, and as\nargument to function `ct:timetrap/1`.\n\n_Examples:_\n\n`{timetrap,{my_test_utils,timetrap,[?MODULE,system_start]}}`\n\n`ct:timetrap(fun() -> my_timetrap(TestCaseName, Config) end)`\n\nThe user timetrap function can be used for two things as follows:\n\n- To act as a timetrap. The time-out is triggered when the function returns.\n- To return a timetrap time value (other than a function).\n\nBefore execution of the timetrap function (which is performed on a parallel,\ndedicated timetrap process), `Common Test` cancels any previously set timer for\nthe test case or configuration function. When the timetrap function returns, the\ntime-out is triggered, _unless_ the return value is a valid timetrap time, such\nas an integer, or a `{SecMinOrHourTag,Time}` tuple (for details, see module\n`m:ct_suite`). If a time value is returned, a new timetrap is started to\ngenerate a time-out after the specified time.\n\nThe user timetrap function can return a time value after a delay. The effective\ntimetrap time is then the delay time _plus_ the returned time.\n\n[](){: #logging }","ref":"write_test_chapter.html#timetrap-time-outs"},{"type":"extras","title":"Logging - Categories and Verbosity Levels - Writing Test Suites","doc":"`Common Test` provides the following three main functions for printing strings:\n\n- `ct:log(Category, Importance, Format, FormatArgs, Opts)`\n- `ct:print(Category, Importance, Format, FormatArgs)`\n- `ct:pal(Category, Importance, Format, FormatArgs)`\n\nThe [`log/1,2,3,4,5`](`ct:log/1`) function prints a string to the test case log\nfile. The [`print/1,2,3,4`](`ct:print/1`) function prints the string to screen.\nThe [`pal/1,2,3,4`](`ct:pal/1`) function prints the same string both to file and\nscreen. The functions are described in module `m:ct`.\n\nThe optional `Category` argument can be used to categorize the log printout.\nCategories can be used for two things as follows:\n\n- To compare the importance of the printout to a specific verbosity level.\n- To format the printout according to a user-specific HTML Style Sheet (CSS).\n\nArgument `Importance` specifies a level of importance that, compared to a\nverbosity level (general and/or set per category), determines if the printout is\nto be visible. `Importance` is any integer in the range 0..99. Predefined\nconstants exist in the `ct.hrl` header file. The default importance level,\n`?STD_IMPORTANCE` (used if argument `Importance` is not provided), is 50. This\nis also the importance used for standard I/O, for example, from printouts made\nwith `io:format/2`, `io:put_chars/1`, and so on.\n\n`Importance` is compared to a verbosity level set by the `verbosity` start\nflag/option. The level can be set per category or generally, or both. If\n`verbosity` is not set by the user, a level of 100 (`?MAX_VERBOSITY` = all\nprintouts visible) is used as default value. `Common Test` performs the\nfollowing test:\n\n```text\nImportance >= (100-VerbosityLevel)\n```\n\nThe constant `?STD_VERBOSITY` has value 50 (see `ct.hrl`). At this level, all\nstandard I/O gets printed. If a lower verbosity level is set, standard I/O\nprintouts are ignored. Verbosity level 0 effectively turns all logging off\n(except from printouts made by `Common Test` itself).\n\nThe general verbosity level is not associated with any particular category. This\nlevel sets the threshold for the standard I/O printouts, uncategorized\n`ct:log/print/pal` printouts, and printouts for categories with undefined\nverbosity level.\n\n_Examples:_\n\nSome printouts during test case execution:\n\n```erlang\nio:format(\"1. Standard IO, importance = ~w~n\", [?STD_IMPORTANCE]),\nct:log(\"2. Uncategorized, importance = ~w\", [?STD_IMPORTANCE]),\n ct:log(info, \"3. Categorized info, importance = ~w\", [?STD_IMPORTANCE]),\n ct:log(info, ?LOW_IMPORTANCE, \"4. Categorized info, importance = ~w\", [?LOW_IMPORTANCE]),\n ct:log(error, ?HI_IMPORTANCE, \"5. Categorized error, importance = ~w\", [?HI_IMPORTANCE]),\n ct:log(error, ?MAX_IMPORTANCE, \"6. Categorized error, importance = ~w\", [?MAX_IMPORTANCE]),\n```\n\nIf starting the test with a general verbosity level of 50 (`?STD_VERBOSITY`):\n\n```text\n$ ct_run -verbosity 50\n```\n\nthe following is printed:\n\n```text\n1. Standard IO, importance = 50\n2. Uncategorized, importance = 50\n3. Categorized info, importance = 50\n5. Categorized error, importance = 75\n6. Categorized error, importance = 99\n```\n\nIf starting the test with:\n\n```text\n$ ct_run -verbosity 1 and info 75\n```\n\nthe following is printed:\n\n```erlang\n3. Categorized info, importance = 50\n4. Categorized info, importance = 25\n6. Categorized error, importance = 99\n```\n\nNote that the category argument is not required in order to only specify the\nimportance of a printout. Example:\n\n```erlang\nct:pal(?LOW_IMPORTANCE, \"Info report: ~p\", [Info])\n```\n\nOr perhaps in combination with constants:\n\n```erlang\n-define(INFO, ?LOW_IMPORTANCE).\n-define(ERROR, ?HI_IMPORTANCE).\n\nct:log(?INFO, \"Info report: ~p\", [Info])\nct:pal(?ERROR, \"Error report: ~p\", [Error])\n```\n\nThe functions `ct:set_verbosity/2` and `ct:get_verbosity/1` may be used to\nmodify and read verbosity levels during test execution.\n\nThe arguments `Format` and `FormatArgs` in `ct:log/print/pal` are always passed\non to the STDLIB function `io:format/3` (For details, see the `m:io` manual\npage).\n\n`ct:pal/4` and `ct:log/5` add headers to strings being printed to the log file.\nThe strings are also wrapped in div tags with a CSS class attribute, so that\nstylesheet formatting can be applied. To disable this feature for a printout\n(i.e. to get a result similar to using `io:format/2`), call `ct:log/5` with the\n`no_css` option.\n\nHow categories can be mapped to CSS tags is documented in section\n[HTML Style Sheets](run_test_chapter.md#html_stylesheet) in section Running\nTests and Analyzing Results.\n\nCommon Test will escape special HTML characters (<, > and &) in printouts to the\nlog file made with `ct:pal/4` and `io:format/2`. In order to print strings with\nHTML tags to the log, use the `ct:log/3,4,5` function. The character escaping\nfeature is per default disabled for `ct:log/3,4,5` but can be enabled with the\n`esc_chars` option in the `Opts` list, see [`ct:log/3,4,5`](`ct:log/5`).\n\nIf the character escaping feature needs to be disabled (typically for backwards\ncompatibility reasons), use the `ct_run` start flag `-no_esc_chars`, or the\n`ct:run_test/1` start option `{esc_chars,Bool}` (this start option is also\nsupported in test specifications).\n\nFor more information about log files, see section\n[Log Files](run_test_chapter.md#log_files) in section Running Tests and\nAnalyzing Results.","ref":"write_test_chapter.html#logging-categories-and-verbosity-levels"},{"type":"extras","title":"Illegal Dependencies - Writing Test Suites","doc":"Even though it is highly efficient to write test suites with the `Common Test`\nframework, mistakes can be made, mainly because of illegal dependencies. Some of\nthe more frequent mistakes from our own experience with running the Erlang/OTP\ntest suites follows:\n\n- Depending on current directory, and writing there:\n\n  This is a common error in test suites. It is assumed that the current\n  directory is the same as the author used as current directory when the test\n  case was developed. Many test cases even try to write scratch files to this\n  directory. Instead `data_dir` and `priv_dir` are to be used to locate data and\n  for writing scratch files.\n\n- Depending on execution order:\n\n  During development of test suites, make no assumptions on the execution order\n  of the test cases or suites. For example, a test case must not assume that a\n  server it depends on is already started by a previous test case. Reasons for\n  this follows:\n\n  - The user/operator can specify the order at will, and maybe a different\n    execution order is sometimes more relevant or efficient.\n  - If the user specifies a whole directory of test suites for the test, the\n    execution order of the suites depends on how the files are listed by the\n    operating system, which varies between systems.\n  - If a user wants to run only a subset of a test suite, there is no way one\n    test case could successfully depend on another.\n\n- Depending on Unix:\n\n  Running Unix commands through `os:cmd` are likely not to work on non-Unix\n  platforms.\n\n- Nested test cases:\n\n  Starting a test case from another not only tests the same thing twice, but\n  also makes it harder to follow what is being tested. Also, if the called test\n  case fails for some reason, so do the caller. This way, one error gives cause\n  to several error reports, which is to be avoided.\n\n  Functionality common for many test case functions can be implemented in common\n  help functions. If these functions are useful for test cases across suites,\n  put the help functions into common help modules.\n\n- Failure to crash or exit when things go wrong:\n\n  Making requests without checking that the return value indicates success can\n  be OK if the test case fails later, but it is never acceptable just to print\n  an error message (into the log file) and return successfully. Such test cases\n  do harm, as they create a false sense of security when overviewing the test\n  results.\n\n- Messing up for subsequent test cases:\n\n  Test cases are to restore as much of the execution environment as possible, so\n  that subsequent test cases do not crash because of their execution order. The\n  function [`end_per_testcase`](`c:ct_suite:end_per_testcase/2`) is suitable for\n  this.","ref":"write_test_chapter.html#illegal-dependencies"},{"type":"extras","title":"Test Structure","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Test Structure","ref":"test_structure_chapter.html"},{"type":"extras","title":"General - Test Structure","doc":"A test is performed by running one or more test suites. A test suite consists of\ntest cases, configuration functions, and information functions. Test cases can\nbe grouped in so called test case groups. A test suite is an Erlang module and\ntest cases are implemented as Erlang functions. Test suites are stored in test\ndirectories.\n\n[](){: #skipping_test_cases }","ref":"test_structure_chapter.html#general"},{"type":"extras","title":"Skipping Test Cases - Test Structure","doc":"Certain test cases can be skipped, for example, if you know beforehand that a\nspecific test case fails. The reason can be functionality that is not yet\nimplemented, a bug that is known but not yet fixed, or some functionality that\ndoes not work or is not applicable on a specific platform.\n\nTest cases can be skipped in the following ways:\n\n- Using `skip_suites` and `skip_cases` terms in\n  [test specifications](run_test_chapter.md#test_specifications).\n- Returning `{skip,Reason}` from function\n  [`init_per_testcase/2`](`c:ct_suite:init_per_testcase/2`) or\n  [`init_per_suite/1`](`c:ct_suite:init_per_suite/1`).\n- Returning `{skip,Reason}` from the execution clause of the test case. The\n  execution clause is called, so the author must ensure that the test case does\n  not run.\n\nWhen a test case is skipped, it is noted as `SKIPPED` in the HTML log.","ref":"test_structure_chapter.html#skipping-test-cases"},{"type":"extras","title":"Definition of Terms - Test Structure","doc":"- **_Auto-skipped test case_** - When a configuration function fails (that is,\n  terminates unexpectedly), the test cases depending on the configuration\n  function are skipped automatically by `Common Test`. The status of the test\n  cases is then \"auto-skipped\". Test cases are also \"auto-skipped\" by\n  `Common Test` if the required configuration data is unavailable at runtime.\n\n- **_Configuration function_** - A function in a test suite that is meant to be\n  used for setting up, cleaning up, and/or verifying the state and environment\n  on the System Under Test (SUT) and/or the `Common Test` host node, so that a\n  test case (or a set of test cases) can execute correctly.\n\n- **_Configuration file_** - A file containing data related to a test and/or an\n  SUT, for example, protocol server addresses, client login details, and\n  hardware interface addresses. That is, any data that is to be handled as\n  variable in the suite and not be hard-coded.\n\n- **_Configuration variable_** - A name (an Erlang atom) associated with a data\n  value read from a configuration file.\n\n- **`data_dir`** - Data directory for a test suite. This directory contains any\n  files used by the test suite, for example, extra Erlang modules, binaries, or\n  data files.\n\n- **_Information function_** - A function in a test suite that returns a list of\n  properties (read by the `Common Test` server) that describes the conditions\n  for executing the test cases in the suite.\n\n- **_Major log file_** - An overview and summary log file for one or more test\n  suites.\n\n- **_Minor log file_** - A log file for one particular test case. Also called\n  the test case log file.\n\n- **`priv_dir`** - Private directory for a test suite. This directory is to be\n  used when the test suite needs to write to files.\n\n- **`ct_run`** - The name of an executable program that can be used as an\n  interface for specifying and running tests with `Common Test`.\n\n- **_Test case_** - A single test included in a test suite. A test case is\n  implemented as a function in a test suite module.\n\n- **_Test case group_** - A set of test cases sharing configuration functions\n  and execution properties. The execution properties specify if the test cases\n  in the group are to be executed in random order, in parallel, or in sequence,\n  and if the execution of the group is be repeated. Test case groups can also be\n  nested. That is, a group can, besides test cases, contain subgroups.\n\n- **_Test suite_** - An Erlang module containing a collection of test cases for\n  a specific functional area.\n\n- **_Test directory_** - A directory containing one or more test suite modules,\n  that is, a group of test suites.\n\n- **_Argument_ `Config`** - A list of key-value tuples (that is, a property\n  list) containing runtime configuration data passed from the configuration\n  functions to the test cases.\n\n- **_User-skipped test case_** - The status of a test case explicitly skipped in\n  any of the ways described in section\n  [Skipping Test Cases](test_structure_chapter.md#skipping_test_cases).","ref":"test_structure_chapter.html#definition-of-terms"},{"type":"extras","title":"Examples and Templates","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Examples and Templates\n\n[](){: #top }","ref":"example_chapter.html"},{"type":"extras","title":"Test Suite Example - Examples and Templates","doc":"The following example test suite shows some tests of a database server:\n\n```erlang\n-module(db_data_type_SUITE).\n\n-include_lib(\"common_test/include/ct.hrl\").\n\n%% Test server callbacks\n-export([suite/0, all/0,\n         init_per_suite/1, end_per_suite/1,\n         init_per_testcase/2, end_per_testcase/2]).\n\n%% Test cases\n-export([string/1, integer/1]).\n\n-define(CONNECT_STR, \"DSN=sqlserver;UID=alladin;PWD=sesame\").\n\n%%--------------------------------------------------------------------\n%% COMMON TEST CALLBACK FUNCTIONS\n%%--------------------------------------------------------------------\n\n%%--------------------------------------------------------------------\n%% Function: suite() -> Info\n%%\n%% Info = [tuple()]\n%%   List of key/value pairs.\n%%\n%% Description: Returns list of tuples to set default properties\n%%              for the suite.\n%%--------------------------------------------------------------------\nsuite() ->\n    [{timetrap,{minutes,1}}].\n\n%%--------------------------------------------------------------------\n%% Function: init_per_suite(Config0) -> Config1\n%%\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%%\n%% Description: Initialization before the suite.\n%%--------------------------------------------------------------------\ninit_per_suite(Config) ->\n    {ok, Ref} = db:connect(?CONNECT_STR, []),\n    TableName = db_lib:unique_table_name(),\n    [{con_ref, Ref },{table_name, TableName}| Config].\n\n%%--------------------------------------------------------------------\n%% Function: end_per_suite(Config) -> term()\n%%\n%% Config = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%%\n%% Description: Cleanup after the suite.\n%%--------------------------------------------------------------------\nend_per_suite(Config) ->\n    Ref = proplists:get_value(con_ref, Config),\n    db:disconnect(Ref),\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: init_per_testcase(TestCase, Config0) -> Config1\n%%\n%% TestCase = atom()\n%%   Name of the test case that is about to run.\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%%\n%% Description: Initialization before each test case.\n%%--------------------------------------------------------------------\ninit_per_testcase(Case, Config) ->\n    Ref = proplists:get_value(con_ref, Config),\n    TableName = proplists:get_value(table_name, Config),\n    ok = db:create_table(Ref, TableName, table_type(Case)),\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_testcase(TestCase, Config) -> term()\n%%\n%% TestCase = atom()\n%%   Name of the test case that is finished.\n%% Config = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%%\n%% Description: Cleanup after each test case.\n%%--------------------------------------------------------------------\nend_per_testcase(_Case, Config) ->\n    Ref = proplists:get_value(con_ref, Config),\n    TableName = proplists:get_value(table_name, Config),\n    ok = db:delete_table(Ref, TableName),\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: all() -> GroupsAndTestCases\n%%\n%% GroupsAndTestCases = [{group,GroupName} | TestCase]\n%% GroupName = atom()\n%%   Name of a test case group.\n%% TestCase = atom()\n%%   Name of a test case.\n%%\n%% Description: Returns the list of groups and test cases that\n%%              are to be executed.\n%%--------------------------------------------------------------------\nall() ->\n    [string, integer].\n\n\n%%--------------------------------------------------------------------\n%% TEST CASES\n%%--------------------------------------------------------------------\n\nstring(Config) ->\n    insert_and_lookup(dummy_key, \"Dummy string\", Config).\n\ninteger(Config) ->\n    insert_and_lookup(dummy_key, 42, Config).\n\n\ninsert_and_lookup(Key, Value, Config) ->\n    Ref = proplists:get_value(con_ref, Config),\n    TableName = proplists:get_value(table_name, Config),\n    ok = db:insert(Ref, TableName, Key, Value),\n    [Value] = db:lookup(Ref, TableName, Key),\n    ok = db:delete(Ref, TableName, Key),\n    [] = db:lookup(Ref, TableName, Key),\n    ok.\n```","ref":"example_chapter.html#test-suite-example"},{"type":"extras","title":"Test Suite Templates - Examples and Templates","doc":"The Erlang mode for the Emacs editor includes two `Common Test` test suite\ntemplates, one with extensive information in the function headers, and one with\nminimal information. A test suite template provides a quick start for\nimplementing a suite from scratch and gives a good overview of the available\ncallback functions. The two templates follows:\n\n_Large Common Test Suite_\n\n```erlang\n%%%-------------------------------------------------------------------\n%%% File    : example_SUITE.erl\n%%% Author  :\n%%% Description :\n%%%\n%%% Created :\n%%%-------------------------------------------------------------------\n-module(example_SUITE).\n\n%% Note: This directive should only be used in test suites.\n-compile(export_all).\n\n-include_lib(\"common_test/include/ct.hrl\").\n\n%%--------------------------------------------------------------------\n%% COMMON TEST CALLBACK FUNCTIONS\n%%--------------------------------------------------------------------\n\n%%--------------------------------------------------------------------\n%% Function: suite() -> Info\n%%\n%% Info = [tuple()]\n%%   List of key/value pairs.\n%%\n%% Description: Returns list of tuples to set default properties\n%%              for the suite.\n%%\n%% Note: The suite/0 function is only meant to be used to return\n%% default data values, not perform any other operations.\n%%--------------------------------------------------------------------\nsuite() ->\n    [{timetrap,{minutes,10}}].\n\n%%--------------------------------------------------------------------\n%% Function: init_per_suite(Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%%\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%% Reason = term()\n%%   The reason for skipping the suite.\n%%\n%% Description: Initialization before the suite.\n%%\n%% Note: This function is free to add any key/value pairs to the Config\n%% variable, but should NOT alter/remove any existing entries.\n%%--------------------------------------------------------------------\ninit_per_suite(Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_suite(Config0) -> term() | {save_config,Config1}\n%%\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%%\n%% Description: Cleanup after the suite.\n%%--------------------------------------------------------------------\nend_per_suite(_Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: init_per_group(GroupName, Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%%\n%% GroupName = atom()\n%%   Name of the test case group that is about to run.\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding configuration data for the group.\n%% Reason = term()\n%%   The reason for skipping all test cases and subgroups in the group.\n%%\n%% Description: Initialization before each test case group.\n%%--------------------------------------------------------------------\ninit_per_group(_GroupName, Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_group(GroupName, Config0) ->\n%%               term() | {save_config,Config1}\n%%\n%% GroupName = atom()\n%%   Name of the test case group that is finished.\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding configuration data for the group.\n%%\n%% Description: Cleanup after each test case group.\n%%--------------------------------------------------------------------\nend_per_group(_GroupName, _Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: init_per_testcase(TestCase, Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%%\n%% TestCase = atom()\n%%   Name of the test case that is about to run.\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%% Reason = term()\n%%   The reason for skipping the test case.\n%%\n%% Description: Initialization before each test case.\n%%\n%% Note: This function is free to add any key/value pairs to the Config\n%% variable, but should NOT alter/remove any existing entries.\n%%--------------------------------------------------------------------\ninit_per_testcase(_TestCase, Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_testcase(TestCase, Config0) ->\n%%               term() | {save_config,Config1} | {fail,Reason}\n%%\n%% TestCase = atom()\n%%   Name of the test case that is finished.\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%% Reason = term()\n%%   The reason for failing the test case.\n%%\n%% Description: Cleanup after each test case.\n%%--------------------------------------------------------------------\nend_per_testcase(_TestCase, _Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: groups() -> [Group]\n%%\n%% Group = {GroupName,Properties,GroupsAndTestCases}\n%% GroupName = atom()\n%%   The name of the group.\n%% Properties = [parallel | sequence | Shuffle | {RepeatType,N}]\n%%   Group properties that may be combined.\n%% GroupsAndTestCases = [Group | {group,GroupName} | TestCase]\n%% TestCase = atom()\n%%   The name of a test case.\n%% Shuffle = shuffle | {shuffle,Seed}\n%%   To get cases executed in random order.\n%% Seed = {integer(),integer(),integer()}\n%% RepeatType = repeat | repeat_until_all_ok | repeat_until_all_fail |\n%%              repeat_until_any_ok | repeat_until_any_fail\n%%   To get execution of cases repeated.\n%% N = integer() | forever\n%%\n%% Description: Returns a list of test case group definitions.\n%%--------------------------------------------------------------------\ngroups() ->\n    [].\n\n%%--------------------------------------------------------------------\n%% Function: all() -> GroupsAndTestCases | {skip,Reason}\n%%\n%% GroupsAndTestCases = [{group,GroupName} | TestCase]\n%% GroupName = atom()\n%%   Name of a test case group.\n%% TestCase = atom()\n%%   Name of a test case.\n%% Reason = term()\n%%   The reason for skipping all groups and test cases.\n%%\n%% Description: Returns the list of groups and test cases that\n%%              are to be executed.\n%%--------------------------------------------------------------------\nall() ->\n    [my_test_case].\n\n\n%%--------------------------------------------------------------------\n%% TEST CASES\n%%--------------------------------------------------------------------\n\n%%--------------------------------------------------------------------\n%% Function: TestCase() -> Info\n%%\n%% Info = [tuple()]\n%%   List of key/value pairs.\n%%\n%% Description: Test case info function - returns list of tuples to set\n%%              properties for the test case.\n%%\n%% Note: This function is only meant to be used to return a list of\n%% values, not perform any other operations.\n%%--------------------------------------------------------------------\nmy_test_case() ->\n    [].\n\n%%--------------------------------------------------------------------\n%% Function: TestCase(Config0) ->\n%%               ok | exit() | {skip,Reason} | {comment,Comment} |\n%%               {save_config,Config1} | {skip_and_save,Reason,Config1}\n%%\n%% Config0 = Config1 = [tuple()]\n%%   A list of key/value pairs, holding the test case configuration.\n%% Reason = term()\n%%   The reason for skipping the test case.\n%% Comment = term()\n%%   A comment about the test case that will be printed in the html log.\n%%\n%% Description: Test case function. (The name of it must be specified in\n%%              the all/0 list or in a test case group for the test case\n%%              to be executed).\n%%--------------------------------------------------------------------\nmy_test_case(_Config) ->\n    ok.\n```\n\n_Small Common Test Suite_\n\n```erlang\n%%%-------------------------------------------------------------------\n%%% File    : example_SUITE.erl\n%%% Author  :\n%%% Description :\n%%%\n%%% Created :\n%%%-------------------------------------------------------------------\n-module(example_SUITE).\n\n-compile(export_all).\n\n-include_lib(\"common_test/include/ct.hrl\").\n\n%%--------------------------------------------------------------------\n%% Function: suite() -> Info\n%% Info = [tuple()]\n%%--------------------------------------------------------------------\nsuite() ->\n    [{timetrap,{seconds,30}}].\n\n%%--------------------------------------------------------------------\n%% Function: init_per_suite(Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%% Config0 = Config1 = [tuple()]\n%% Reason = term()\n%%--------------------------------------------------------------------\ninit_per_suite(Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_suite(Config0) -> term() | {save_config,Config1}\n%% Config0 = Config1 = [tuple()]\n%%--------------------------------------------------------------------\nend_per_suite(_Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: init_per_group(GroupName, Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%% GroupName = atom()\n%% Config0 = Config1 = [tuple()]\n%% Reason = term()\n%%--------------------------------------------------------------------\ninit_per_group(_GroupName, Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_group(GroupName, Config0) ->\n%%               term() | {save_config,Config1}\n%% GroupName = atom()\n%% Config0 = Config1 = [tuple()]\n%%--------------------------------------------------------------------\nend_per_group(_GroupName, _Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: init_per_testcase(TestCase, Config0) ->\n%%               Config1 | {skip,Reason} | {skip_and_save,Reason,Config1}\n%% TestCase = atom()\n%% Config0 = Config1 = [tuple()]\n%% Reason = term()\n%%--------------------------------------------------------------------\ninit_per_testcase(_TestCase, Config) ->\n    Config.\n\n%%--------------------------------------------------------------------\n%% Function: end_per_testcase(TestCase, Config0) ->\n%%               term() | {save_config,Config1} | {fail,Reason}\n%% TestCase = atom()\n%% Config0 = Config1 = [tuple()]\n%% Reason = term()\n%%--------------------------------------------------------------------\nend_per_testcase(_TestCase, _Config) ->\n    ok.\n\n%%--------------------------------------------------------------------\n%% Function: groups() -> [Group]\n%% Group = {GroupName,Properties,GroupsAndTestCases}\n%% GroupName = atom()\n%% Properties = [parallel | sequence | Shuffle | {RepeatType,N}]\n%% GroupsAndTestCases = [Group | {group,GroupName} | TestCase]\n%% TestCase = atom()\n%% Shuffle = shuffle | {shuffle,{integer(),integer(),integer()}}\n%% RepeatType = repeat | repeat_until_all_ok | repeat_until_all_fail |\n%%              repeat_until_any_ok | repeat_until_any_fail\n%% N = integer() | forever\n%%--------------------------------------------------------------------\ngroups() ->\n    [].\n\n%%--------------------------------------------------------------------\n%% Function: all() -> GroupsAndTestCases | {skip,Reason}\n%% GroupsAndTestCases = [{group,GroupName} | TestCase]\n%% GroupName = atom()\n%% TestCase = atom()\n%% Reason = term()\n%%--------------------------------------------------------------------\nall() ->\n    [my_test_case].\n\n%%--------------------------------------------------------------------\n%% Function: TestCase() -> Info\n%% Info = [tuple()]\n%%--------------------------------------------------------------------\nmy_test_case() ->\n    [].\n\n%%--------------------------------------------------------------------\n%% Function: TestCase(Config0) ->\n%%               ok | exit() | {skip,Reason} | {comment,Comment} |\n%%               {save_config,Config1} | {skip_and_save,Reason,Config1}\n%% Config0 = Config1 = [tuple()]\n%% Reason = term()\n%% Comment = term()\n%%--------------------------------------------------------------------\nmy_test_case(_Config) ->\n    ok.\n```","ref":"example_chapter.html#test-suite-templates"},{"type":"extras","title":"Running Tests and Analyzing Results","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Running Tests and Analyzing Results","ref":"run_test_chapter.html"},{"type":"extras","title":"Using the Common Test Framework - Running Tests and Analyzing Results","doc":"The `Common Test` framework provides a high-level operator interface for\ntesting, providing the following features:\n\n- Automatic compilation of test suites (and help modules)\n- Creation of extra HTML pages for improved overview.\n- Single-command interface for running all available tests\n- Handling of configuration files specifying data related to the System Under\n  Test (SUT) (and any other variable data)\n- Mode for running multiple independent test sessions in parallel with central\n  control and configuration","ref":"run_test_chapter.html#using-the-common-test-framework"},{"type":"extras","title":"Automatic Compilation of Test Suites and Help Modules - Running Tests and Analyzing Results","doc":"When `Common Test` starts, it automatically attempts to compile any suites\nincluded in the specified tests. If particular suites are specified, only those\nsuites are compiled. If a particular test object directory is specified (meaning\nall suites in this directory are to be part of the test), `Common Test` runs\nfunction `make:all/1` in the directory to compile the suites.\n\nIf compilation fails for one or more suites, the compilation errors are printed\nto tty and the operator is asked if the test run is to proceed without the\nmissing suites, or be aborted. If the operator chooses to proceed, the tests\nhaving missing suites are noted in the HTML log. If `Common Test` is unable to\nprompt the user after compilation failure (if `Common Test` does not control\n`stdin`), the test run proceeds automatically without the missing suites. This\nbehavior can however be modified with the `ct_run` flag\n`-abort_if_missing_suites`, or the `ct:run_test/1` option\n`{abort_if_missing_suites,TrueOrFalse}`. If `abort_if_missing_suites` is set to\n`true`, the test run stops immediately if some suites fail to compile.\n\nAny help module (that is, regular Erlang module with name not ending with\n\"\\_SUITE\") that resides in the same test object directory as a suite, which is\npart of the test, is also automatically compiled. A help module is not mistaken\nfor a test suite (unless it has a \"\\_SUITE\" name). All help modules in a\nparticular test object directory are compiled, no matter if all or only\nparticular suites in the directory are part of the test.\n\nIf test suites or help modules include header files stored in other locations\nthan the test directory, these include directories can be specified by using\nflag `-include` with [`ct_run`](ct_run_cmd.md), or option `include` with\n`ct:run_test/1`. Also, an include path can be specified with an OS environment\nvariable, `CT_INCLUDE_PATH`.\n\n_Example (bash):_\n\n`$ export CT_INCLUDE_PATH=~testuser/common_suite_files/include:~testuser/common_lib_files/include`\n\n`Common Test` passes all include directories (specified either with flag/option\n`include`, or variable `CT_INCLUDE_PATH` , or both, to the compiler.\n\nInclude directories can also be specified in test specifications, see\n[Test Specifications](run_test_chapter.md#test_specifications).\n\nIf the user wants to run all test suites for a test object (or an OTP\napplication) by specifying only the top directory (for example, with start\nflag/option `dir`), `Common Test` primarily looks for test suite modules in a\nsubdirectory named `test`. If this subdirectory does not exist, the specified\ntop directory is assumed to be the test directory, and test suites are read from\nthere instead.\n\nTo disable the automatic compilation feature, use flag `-no_auto_compile` with\n`ct_run`, or option `{auto_compile,false}` with `ct:run_test/1`. With automatic\ncompilation disabled, the user is responsible for compiling the test suite\nmodules (and any help modules) before the test run. If the modules cannot be\nloaded from the local file system during startup of `Common Test`, the user must\npreload the modules before starting the test. `Common Test` only verifies that\nthe specified test suites exist (that is, that they are, or can be, loaded).\nThis is useful, for example, if the test suites are transferred and loaded as\nbinaries through RPC from a remote node.\n\n[](){: #ct_run }","ref":"run_test_chapter.html#automatic-compilation-of-test-suites-and-help-modules"},{"type":"extras","title":"Running Tests from the OS Command Line - Running Tests and Analyzing Results","doc":"The [`ct_run`](ct_run_cmd.md) program can be used for running tests from the OS\ncommand line, for example, as follows:\n\n- `ct_run -config   -dir  `\n- `ct_run -config   -suite  `\n- `ct_run -userconfig     -suite  `\n- `ct_run -config   -suite   -group   -case  `\n\n_Examples:_\n\n```text\n$ ct_run -config $CFGS/sys1.cfg $CFGS/sys2.cfg -dir $SYS1_TEST $SYS2_TEST\n$ ct_run -userconfig ct_config_xml $CFGS/sys1.xml $CFGS/sys2.xml -dir $SYS1_TEST $SYS2_TEST\n$ ct_run -suite $SYS1_TEST/setup_SUITE $SYS2_TEST/config_SUITE\n$ ct_run -suite $SYS1_TEST/setup_SUITE -case start stop\n$ ct_run -suite $SYS1_TEST/setup_SUITE -group installation -case start stop\n```\n\nThe flags `dir`, `suite`, and `group/case` can be combined. For example, to run\n`x_SUITE` and `y_SUITE` in directory `testdir`, as follows:\n\n```text\n$ ct_run -dir ./testdir -suite x_SUITE y_SUITE\n```\n\nThis has the same effect as the following:\n\n```text\n$ ct_run -suite ./testdir/x_SUITE ./testdir/y_SUITE\n```\n\nFor details, see\n[Test Case Group Execution](run_test_chapter.md#group_execution).\n\nThe following flags can also be used with [`ct_run`](ct_run_cmd.md):\n\n- **`-help`** - Lists all available start flags.\n\n- **`-logdir  `** - Specifies where the HTML log files are to be written.\n\n- **`-label  `** - Associates the test run with a name that\n  gets printed in the overview HTML log files.\n\n- **`-refresh_logs`** - Refreshes the top-level HTML index files.\n\n- **`-shell`** - Starts interactive shell mode (described later).\n\n- **`-step [step_opts]`** - Steps through test cases using the Erlang Debugger\n  (described later).\n\n- **`-spec  `** - Uses test specification as input (described later).\n\n- **`-allow_user_terms`** - Allows user-specific terms in a test specification\n  (described later).\n\n- **`-silent_connections [conn_types]`** - , tells `Common Test` to suppress\n  printouts for specified connections (described later).\n\n- **`-stylesheet  `** - Points out a user HTML style sheet (described\n  later).\n\n- **`-cover  `** - To perform code coverage test (see\n  [Code Coverage Analysis](cover_chapter.md#cover)).\n\n- **`-cover_stop  `** - To specify if the `cover` tool is to be stopped\n  after the test is completed (see\n  [Code Coverage Analysis](cover_chapter.md#cover_stop)).\n\n- **`-event_handler  `** - To install\n  [event handlers](event_handler_chapter.md#event_handling).\n\n- **`-event_handler_init  `** - To install\n  [event handlers](event_handler_chapter.md#event_handling) including start\n  arguments.\n\n- **`-ct_hooks  `** - To install\n  [Common Test Hooks](ct_hooks_chapter.md#installing) including start arguments.\n\n- **`-ct_hooks_order [test|config]`** - To modify\n  [Common Test Hooks](ct_hooks_chapter.md#installing) execution order.\n\n- **`-enable_builtin_hooks  `** - To enable or disable\n  [Built-in Common Test Hooks](ct_hooks_chapter.md#builtin_cths). Default is\n  `true`.\n\n- **`-include`** - Specifies include directories (described earlier).\n\n- **`-no_auto_compile`** - Disables the automatic test suite compilation feature\n  (described earlier).\n\n- **`-abort_if_missing_suites`** - Aborts the test run if one or more suites\n  fail to compile (described earlier).\n\n- **`-multiply_timetraps  `** - Extends\n  [timetrap time-out](write_test_chapter.md#timetraps) values.\n\n- **`-scale_timetraps  `** - Enables automatic\n  [timetrap time-out](write_test_chapter.md#timetraps) scaling.\n\n- **`-repeat  `** - Tells `Common Test` to repeat the tests `n` times\n  (described later).\n\n- **`-duration  `** - Tells `Common Test` to repeat the tests for duration\n  of time (described later).\n\n- **`-until  `** - Tells `Common Test` to repeat the tests until\n  `stop_time` (described later).\n\n- **`-force_stop [skip_rest]`** - On time-out, the test run is aborted when the\n  current test job is finished. If `skip_rest` is provided, the remaining test\n  cases in the current test job are skipped (described later).\n\n- **`-decrypt_key  `** - Provides a decryption key for\n  [encrypted configuration files](config_file_chapter.md#encrypted_config_files).\n\n- **`-decrypt_file  `** - Points out a file containing a decryption key\n  for\n  [encrypted configuration files](config_file_chapter.md#encrypted_config_files).\n\n- **`-basic_html`** - Switches off HTML enhancements that can be incompatible\n  with older browsers.\n\n- **`-logopts  `** - Enables modification of the logging behavior, see\n  [Log options](run_test_chapter.md#logopts).\n\n- **`-verbosity  `** - Sets\n  [verbosity levels for printouts](write_test_chapter.md#logging).\n\n- **`-no_esc_chars`** - Disables automatic escaping of special HTML characters.\n  See the [Logging chapter](write_test_chapter.md#logging).\n\n> #### Note {: .info }\n>\n> Directories passed to `Common Test` can have either relative or absolute\n> paths.\n\n> #### Note {: .info }\n>\n> Any start flags to the Erlang runtime system (application ERTS) can also be\n> passed as parameters to `ct_run`. It is, for example, useful to be able to\n> pass directories to be added to the Erlang code server search path with flag\n> `-pa` or `-pz`. If you have common help- or library modules for test suites\n> (separately compiled), stored in other directories than the test suite\n> directories, these `help/lib` directories are preferably added to the code\n> path this way.\n>\n> _Example:_\n>\n> `$ ct_run -dir ./chat_server -logdir ./chat_server/testlogs -pa $PWD/chat_server/ebin`\n>\n> The absolute path of directory `chat_server/ebin` is here passed to the code\n> server. This is essential because relative paths are stored by the code server\n> as relative, and `Common Test` changes the current working directory of ERTS\n> during the test run.\n\nThe `ct_run` program sets the exit status before shutting down. The following\nvalues are defined:\n\n- `0` indicates a successful testrun, that is, without failed or auto-skipped\n  test cases.\n- `1` indicates that one or more test cases have failed, or have been\n  auto-skipped.\n- `2` indicates that the test execution has failed because of, for example,\n  compilation errors, or an illegal return value from an information function.\n\nIf auto-skipped test cases do not affect the exit status. The default behavior\ncan be changed using start flag:\n\n```text\n-exit_status ignore_config\n```\n\n> #### Note {: .info }\n>\n> Executing `ct_run` without start flags is equal to the command:\n> `ct_run -dir ./`\n\nFor more information about the `ct_run` program, see module\n[`ct_run`](ct_run_cmd.md) and section\n[Installation](install_chapter.md#general).\n\n[](){: #erlang_shell_or_program }","ref":"run_test_chapter.html#running-tests-from-the-os-command-line"},{"type":"extras","title":"Running Tests from the Erlang Shell or from an Erlang Program - Running Tests and Analyzing Results","doc":"`Common Test` provides an Erlang API for running tests. The main (and most\nflexible) function for specifying and executing tests is `ct:run_test/1`. It\ntakes the same start parameters as [`ct_run`](run_test_chapter.md#ct_run), but\nthe flags are instead specified as options in a list of key-value tuples. For\nexample, a test specified with `ct_run` as follows:\n\n`$ ct_run -suite ./my_SUITE -logdir ./results`\n\nis with `ct:run_test/1` specified as:\n\n`1> ct:run_test([{suite,\"./my_SUITE\"},{logdir,\"./results\"}]).`\n\nThe function returns the test result, represented by the tuple\n`{Ok,Failed,{UserSkipped,AutoSkipped}}`, where each element is an integer. If\ntest execution fails, the function returns the tuple `{error,Reason}`, where the\nterm `Reason` explains the failure.\n\nThe default start option `{dir,Cwd}` (to run all suites in the current working\ndirectory) is used if the function is called with an empty list of options.","ref":"run_test_chapter.html#running-tests-from-the-erlang-shell-or-from-an-erlang-program"},{"type":"extras","title":"Releasing the Erlang Shell - Running Tests and Analyzing Results","doc":"During execution of tests started with `ct:run_test/1`, the Erlang shell\nprocess, controlling `stdin`, remains the top-level process of the `Common Test`\nsystem of processes. Consequently, the Erlang shell is not available for\ninteraction during the test run. If this is not desirable, for example, because\nthe shell is needed for debugging purposes or for interaction with the SUT\nduring test execution, set start option `release_shell` to `true` (in the call\nto `ct:run_test/1` or by using the corresponding test specification term,\ndescribed later). This makes `Common Test` release the shell immediately after\nthe test suite compilation stage. To accomplish this, a test runner process is\nspawned to take control of the test execution. The effect is that\n`ct:run_test/1` returns the pid of this process rather than the test result,\nwhich instead is printed to tty at the end of the test run.\n\n> #### Note {: .info }\n>\n> To use the functions [`ct:break/1,2`](`ct:break/1`) and\n> [`ct:continue/0,1`](`ct:continue/0`), `release_shell` _must_ be set to `true`.\n\nFor details, see `ct:run_test/1` manual page.\n\n[](){: #group_execution }","ref":"run_test_chapter.html#releasing-the-erlang-shell"},{"type":"extras","title":"Test Case Group Execution - Running Tests and Analyzing Results","doc":"With the `ct_run` flag, or `ct:run_test/1` option `group`, one or more test case\ngroups can be specified, optionally in combination with specific test cases. The\nsyntax for specifying groups on the command line is as follows:\n\n```text\n$ ct_run -group   [-case  ]\n```\n\nThe syntax in the Erlang shell is as follows:\n\n```erlang\n1> ct:run_test([{group,GroupsNamesOrPaths}, {case,Cases}]).\n```\n\nParameter `group_names_or_paths` specifies one or more group names and/or one or\nmore group paths. At startup, `Common Test` searches for matching groups in the\ngroup definitions tree (that is, the list returned from `Suite:groups/0`; for\ndetails, see section [Test Case Groups](write_test_chapter.md#test_case_groups).\n\nGiven a group name, say `g`, `Common Test` searches for all paths leading to\n`g`. By path is meant a sequence of nested groups, which must be followed to get\nfrom the top-level group to `g`. To execute the test cases in group `g`,\n`Common Test` must call the `init_per_group/2` function for each group in the\npath to `g`, and all corresponding `end_per_group/2` functions afterwards. This\nis because the configuration of a test case in `g` (and its `Config` input data)\ndepends on `init_per_testcase(TestCase, Config)` and its return value, which in\nturn depends on `init_per_group(g, Config)` and its return value, which in turn\ndepends on `init_per_group/2` of the group above `g`, and so on, all the way up\nto the top-level group.\n\nThis means that if there is more than one way to locate a group (and its test\ncases) in a path, the result of the group search operation is a number of tests,\nall of which are to be performed. `Common Test` interprets a group specification\nthat consists of a single name as follows:\n\n\"Search and find all paths in the group definitions tree that lead to the\nspecified group and, for each path, create a test that does the following, in\norder:\n\n1. Executes all configuration functions in the path to the specified group.\n1. Executes all, or all matching, test cases in this group.\n1. Executes all, or all matching, test cases in all subgroups of the group.\"\n\nThe user can specify a specific group path with parameter\n`group_names_or_paths`. With this type of specification execution of unwanted\ngroups (in otherwise matching paths), and/or the execution of subgroups can be\navoided. The command line syntax of the group path is a list of group names in\nthe path, for example:\n\n`$ ct_run -suite \"./x_SUITE\" -group [g1,g3,g4] -case tc1 tc5`\n\nThe syntax in the Erlang shell is as follows (requires a list within the groups\nlist):\n\n`1> ct:run_test([{suite,\"./x_SUITE\"}, {group,[[g1,g3,g4]]}, {testcase,[tc1,tc5]}]).`\n\nThe last group in the specified path is the terminating group in the test, that\nis, no subgroups following this group are executed. In the previous example,\n`g4` is the terminating group. Hence, `Common Test` executes a test that calls\nall `init` configuration functions in the path to `g4`, that is, `g1..g3..g4`.\nIt then calls test cases `tc1` and `tc5` in `g4`, and finally all `end`\nconfiguration functions in order `g4..g3..g1`.\n\n> #### Note {: .info }\n>\n> The group path specification does not necessarily have to include _all_ groups\n> in the path to the terminating group. `Common Test` searches for all matching\n> paths if an incomplete group path is specified.\n\n> #### Note {: .info }\n>\n> Group names and group paths can be combined with parameter\n> `group_names_or_paths`. Each element is treated as an individual specification\n> in combination with parameter `cases`. The following examples illustrates\n> this.\n\n_Examples:_\n\n```erlang\n-module(x_SUITE).\n...\n%% The group definitions:\ngroups() ->\n  [{top1,[],[tc11,tc12,\n             {sub11,[],[tc12,tc13]},\n             {sub12,[],[tc14,tc15,\n       \t\t {sub121,[],[tc12,tc16]}]}]},\n\n   {top2,[],[{group,sub21},{group,sub22}]},\n   {sub21,[],[tc21,{group,sub2X2}]},\n   {sub22,[],[{group,sub221},tc21,tc22,{group,sub2X2}]},\n   {sub221,[],[tc21,tc23]},\n   {sub2X2,[],[tc21,tc24]}].\n```\n\nThe following executes two tests, one for all cases and all subgroups under\n`top1`, and one for all under `top2`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group all\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,all}]).\n```\n\nUsing `-group top1 top2`, or `{group,[top1,top2]}` gives the same result.\n\nThe following executes one test for all cases and subgroups under `top1`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group top1\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[top1]}]).\n```\n\nThe following runs a test executing `tc12` in `top1` and any subgroup under\n`top1` where it can be found (`sub11` and `sub121`):\n\n```text\n$ ct_run -suite \"x_SUITE\" -group top1 -case tc12\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[top1]}, {testcase,[tc12]}]).\n```\n\nThe following executes `tc12` _only_ in group `top1`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group [top1] -case tc12\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[[top1]]}, {testcase,[tc12]}]).\n```\n\nThe following searches `top1` and all its subgroups for `tc16` resulting in that\nthis test case executes in group `sub121`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group top1 -case tc16\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[top1]}, {testcase,[tc16]}]).\n```\n\nUsing the specific path `-group [sub121]` or `{group,[[sub121]]}` gives the same\nresult in this example.\n\nThe following executes two tests, one including all cases and subgroups under\n`sub12`, and one with _only_ the test cases in `sub12`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group sub12 [sub12]\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[sub12,[sub12]]}]).\n```\n\nIn the following example, `Common Test` finds and executes two tests, one for\nthe path from `top2` to `sub2X2` through `sub21`, and one from `top2` to\n`sub2X2` through `sub22`:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group sub2X2\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[sub2X2]}]).\n```\n\nIn the following example, by specifying the unique path\n`top2 -> sub21 -> sub2X2`, only one test is executed. The second possible path,\nfrom `top2` to `sub2X2` (from the former example) is discarded:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group [sub21,sub2X2]\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[[sub21,sub2X2]]}]).\n```\n\nThe following executes only the test cases for `sub22` and in reverse order\ncompared to the group definition:\n\n```text\n$ ct_run -suite \"x_SUITE\" -group [sub22] -case tc22 tc21\n```\n```erlang\n1> ct:run_test([{suite,\"x_SUITE\"}, {group,[[sub22]]}, {testcase,[tc22,tc21]}]).\n```\n\nIf a test case belonging to a group (according to the group definition) is\nexecuted without a group specification, that is, simply by (using the command\nline):\n\n`$ ct_run -suite \"my_SUITE\" -case my_tc`\n\nor (using the Erlang shell):\n\n`1> ct:run_test([{suite,\"my_SUITE\"}, {testcase,my_tc}]).`\n\nthen `Common Test` ignores the group definition and executes the test case in\nthe scope of the test suite only (no group configuration functions are called).\n\nThe group specification feature, as presented in this section, can also be used\nin [Test Specifications](run_test_chapter.md#test_specifications) (with some\nextra features added).","ref":"run_test_chapter.html#test-case-group-execution"},{"type":"extras","title":"Running the Interactive Shell Mode - Running Tests and Analyzing Results","doc":"You can start `Common Test` in an interactive shell mode where no automatic\ntesting is performed. Instead, `Common Test` starts its utility processes,\ninstalls configuration data (if any), and waits for the user to call functions\n(typically test case support functions) from the Erlang shell.\n\nThe shell mode is useful, for example, for debugging test suites, analyzing and\ndebugging the SUT during \"simulated\" test case execution, and trying out various\noperations during test suite development.\n\nTo start the interactive shell mode, start an Erlang shell manually and call\n`ct:install/1` to install any configuration data you might need (use `[]` as\nargument otherwise). Then call `ct:start_interactive/0` to start `Common Test`.\n\nIf you use the `ct_run` program, you can start the Erlang shell and\n`Common Test` in one go by using the flag `-shell` and, optionally, flag\n`-config` and/or `-userconfig`.\n\n_Examples:_\n\n- `ct_run -shell`\n- `ct_run -shell -config cfg/db.cfg`\n- `ct_run -shell -userconfig db_login testuser x523qZ`\n\nIf no configuration file is specified with command `ct_run`, a warning is\ndisplayed. If `Common Test` has been run from the same directory earlier, the\nsame configuration file(s) are used again. If `Common Test` has not been run\nfrom this directory before, no configuration files are available.\n\nIf any functions using \"required configuration data\" (for example, functions\n`ct_telnet` or `ct_ftp`) are to be called from the Erlang shell, first require\nconfiguration data with [`ct:require/1,2`](`ct:require/1`). This is equivalent\nto a `require` statement in the\n[Test Suite Information Function](write_test_chapter.md#suite) or in the\n[Test Case Information Function](write_test_chapter.md#info_function).\n\n_Example:_\n\n```erlang\n1> ct:require(unix_telnet, unix).\nok\n2> ct_telnet:open(unix_telnet).\n{ok,<0.105.0>}\n4> ct_telnet:cmd(unix_telnet, \"ls .\").\n{ok,[\"ls .\",\"file1  ...\",...]}\n```\n\nEverything that `Common Test` normally prints in the test case logs, are in the\ninteractive mode written to a log named `ctlog.html` in directory\n`ct_run. `. A link to this file is available in the file named\n`last_interactive.html` in the directory from which you execute `ct_run`.\nSpecifying a different root directory for the logs than the current working\ndirectory is not supported.\n\nIf you wish to exit the interactive mode (for example, to start an automated\ntest run with `ct:run_test/1`), call function `ct:stop_interactive/0`. This\nshuts down the running `ct` application. Associations between configuration\nnames and data created with `require` are consequently deleted. Function\n`ct:start_interactive/0` takes you back into interactive mode, but the previous\nstate is not restored.","ref":"run_test_chapter.html#running-the-interactive-shell-mode"},{"type":"extras","title":"Step-by-Step Execution of Test Cases with the Erlang Debugger - Running Tests and Analyzing Results","doc":"Using `ct_run -step [opts]`, or by passing option `{step,Opts}` to\n`ct:run_test/1`, the following is possible:\n\n- Get the Erlang Debugger started automatically.\n- Use its graphical interface to investigate the state of the current test case.\n- Execute the test case step-by-step and/or set execution breakpoints.\n\nIf no extra options are specified with flag/option `step`, breakpoints are set\nautomatically on the test cases that are to be executed by `Common Test`, and\nthose functions only. If step option `config` is specified, breakpoints are also\ninitially set on the configuration functions in the suite, that is,\n`init_per_suite/1`, `end_per_suite/1`, `init_per_group/2`, `end_per_group/2`,\n`init_per_testcase/2` and `end_per_testcase/2`.\n\n`Common Test` enables the Debugger auto-attach feature, which means that for\nevery new interpreted test case function that starts to execute, a new trace\nwindow automatically pops up (as each test case executes on a dedicated Erlang\nprocess). Whenever a new test case starts, `Common Test` attempts to close the\ninactive trace window of the previous test case. However, if you prefer\n`Common Test` to leave inactive trace windows, use option `keep_inactive`.\n\nThe step functionality can be used together with flag/option `suite` and `suite`\n\\+ `case/testcase`, but not together with `dir`.\n\n[](){: #test_specifications }","ref":"run_test_chapter.html#step-by-step-execution-of-test-cases-with-the-erlang-debugger"},{"type":"extras","title":"Test Specifications - Running Tests and Analyzing Results","doc":"","ref":"run_test_chapter.html#test-specifications"},{"type":"extras","title":"General Description - Running Tests and Analyzing Results","doc":"The most flexible way to specify what to test, is to use a test specification,\nwhich is a sequence of Erlang terms. The terms are normally declared in one or\nmore text files (see `ct:run_test/1`), but can also be passed to `Common Test`\non the form of a list (see `ct:run_testspec/1`). There are two general types of\nterms: configuration terms and test specification terms.\n\nWith configuration terms it is, for example, possible to do the following:\n\n- Label the test run (similar to `ct_run -label`).\n- Evaluate any expressions before starting the test.\n- Import configuration data (similar to `ct_run -config/-userconfig`).\n- Specify the top-level HTML log directory (similar to `ct_run -logdir`).\n- Enable code coverage analysis (similar to `ct_run -cover`).\n- Install `Common Test Hooks` (similar to `ct_run -ch_hooks`).\n- Install `event_handler` plugins (similar to `ct_run -event_handler`).\n- Specify include directories to be passed to the compiler for automatic\n  compilation (similar to `ct_run -include`).\n- Disable the auto-compilation feature (similar to `ct_run -no_auto_compile`).\n- Set verbosity levels (similar to `ct_run -verbosity`).\n\nConfiguration terms can be combined with `ct_run` start flags or `ct:run_test/1`\noptions. The result is, for some flags/options and terms, that the values are\nmerged (for example, configuration files, include directories, verbosity levels,\nand silent connections) and for others that the start flags/options override the\ntest specification terms (for example, log directory, label, style sheet, and\nauto-compilation).\n\nWith test specification terms, it is possible to state exactly which tests to\nrun and in which order. A test term specifies either one or more suites, one or\nmore test case groups (possibly nested), or one or more test cases in a group\n(or in multiple groups) or in a suite.\n\nAny number of test terms can be declared in sequence. `Common Test` compiles by\ndefault the terms into one or more tests to be performed in one resulting test\nrun. A term that specifies a set of test cases \"swallows\" one that only\nspecifies a subset of these cases. For example, the result of merging one term\nspecifying that all cases in suite S are to be executed, with another term\nspecifying only test case X and Y in S, is a test of all cases in S. However, if\na term specifying test case X and Y in S is merged with a term specifying case Z\nin S, the result is a test of X, Y, and Z in S. To disable this behavior, that\nis, to instead perform each test sequentially in a \"script-like\" manner, set\nterm `merge_tests` to `false` in the test specification.\n\nA test term can also specify one or more test suites, groups, or test cases to\nbe skipped. Skipped suites, groups, and cases are not executed and show up in\nthe HTML log files as `SKIPPED`.","ref":"run_test_chapter.html#general-description"},{"type":"extras","title":"Using Multiple Test Specification Files - Running Tests and Analyzing Results","doc":"When multiple test specification files are specified at startup (either with\n`ct_run -spec file1 file2 ...` or `ct:run_test([{spec, [File1,File2,...]}])`),\n`Common Test` either executes one test run per specification file, or joins the\nfiles and performs all tests within one single test run. The first behavior is\nthe default one. The latter requires that start flag/option `join_specs` is\nprovided, for example,\n`run_test -spec ./my_tests1.ts ./my_tests2.ts -join_specs`.\n\nJoining a number of specifications, or running them separately, can also be\naccomplished with (and can be combined with) test specification file inclusion.","ref":"run_test_chapter.html#using-multiple-test-specification-files"},{"type":"extras","title":"Test Specification File Inclusion - Running Tests and Analyzing Results","doc":"With the term `specs`, a test specification can include other specifications. An\nincluded specification can either be joined with the source specification or\nused to produce a separate test run (as with start flag/option `join_specs`\nabove).\n\n_Example:_\n\n```erlang\n%% In specification file \"a.spec\"\n{specs, join, [\"b.spec\", \"c.spec\"]}.\n{specs, separate, [\"d.spec\", \"e.spec\"]}.\n%% Config and test terms follow\n...\n```\n\nIn this example, the test terms defined in files \"b.spec\" and \"c.spec\" are\njoined with the terms in source specification \"a.spec\" (if any). The inclusion\nof specifications \"d.spec\" and \"e.spec\" results in two separate, and\nindependent, test runs (one for each included specification).\n\nOption `join` does not imply that the test terms are merged, only that all tests\nare executed in one single test run.\n\nJoined specifications share common configuration settings, such as the list of\n`config` files or `include` directories. For configurations that cannot be\ncombined, such as settings for `logdir` or `verbosity`, it is up to the user to\nensure there are no clashes when the test specifications are joined.\nSpecifications included with option `separate` do not share configuration\nsettings with the source specification. This is useful, for example, if there\nare clashing configuration settings in included specifications, making it them\nimpossible to join.\n\nIf `{merge_tests,true}` is set in the source specification (which is the default\nsetting), terms in joined specifications are merged with terms in the source\nspecification (according to the description of `merge_tests` earlier).\n\nNotice that it is always the `merge_tests` setting in the source specification\nthat is used when joined with other specifications. Say, for example, that a\nsource specification A, with tests TA1 and TA2, has `{merge_tests,false}` set,\nand that it includes another specification, B, with tests TB1 and TB2, that has\n`{merge_tests,true}` set. The result is that the test series\n`TA1,TA2,merge(TB1,TB2)` is executed. The opposite `merge_tests` settings would\nresult in the test series `merge(merge(TA1,TA2),TB1,TB2)`.\n\nThe term `specs` can be used to nest specifications, that is, have one\nspecification include other specifications, which in turn include others, and so\nno","ref":"run_test_chapter.html#test-specification-file-inclusion"},{"type":"extras","title":"Test Case Groups - Running Tests and Analyzing Results","doc":"When a test case group is specified, the resulting test executes function\n`init_per_group`, followed by all test cases and subgroups (including their\nconfiguration functions), and finally function `end_per_group`. Also, if\nparticular test cases in a group are specified, `init_per_group` and\n`end_per_group`, for the group in question, are called. If a group defined (in\n`Suite:groups/0`) as a subgroup of another group, is specified (or if particular\ntest cases of a subgroup are), `Common Test` calls the configuration functions\nfor the top-level groups and for the subgroup in question (making it possible to\npass configuration data all the way from `init_per_suite` down to the test cases\nin the subgroup).\n\nThe test specification uses the same mechanism for specifying test case groups\nthrough names and paths, as explained in section\n[Test Case Group Execution](run_test_chapter.md#group_execution), with the\naddition of element `GroupSpec`.\n\nElement `GroupSpec` makes it possible to specify group execution properties that\noverrides those in the group definition (that is, in `groups/0`). Execution\nproperties for subgroups might be overridden as well. This feature makes it\npossible to change properties of groups at the time of execution, without having\nto edit the test suite. The same feature is available for `group` elements in\nthe `Suite:all/0` list. For details and examples, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups).","ref":"run_test_chapter.html#test-case-groups"},{"type":"extras","title":"Test Specification Syntax - Running Tests and Analyzing Results","doc":"Test specifications can be used to run tests both in a single test host\nenvironment and in a distributed `Common Test` environment (Large Scale\nTesting). The node parameters in term `init` are only relevant in the latter\n(see section [Test Specifications](ct_master_chapter.md#test_specifications) in\nLarge Scale Testing). For details about the various terms, see the corresponding\nsections in the User's Guide, for example, the following:\n\n- The [`ct_run` program](run_test_chapter.md#ct_run) for an overview of\n  available start flags (as most flags have a corresponding configuration term)\n- [Logging](write_test_chapter.md#logging) (for terms `verbosity`, `stylesheet`,\n  `basic_html` and `esc_chars`)\n- [External Configuration Data](config_file_chapter.md#top) (for terms `config`\n  and `userconfig`)\n- [Event Handling](event_handler_chapter.md#event_handling) (for the\n  `event_handler` term)\n- [Common Test Hooks](ct_hooks_chapter.md#installing) (for term `ct_hooks`)\n\n_Configuration terms:_\n\n```erlang\n{merge_tests, Bool}.\n\n{define, Constant, Value}.\n\n{specs, InclSpecsOption, TestSpecs}.\n\n{node, NodeAlias, Node}.\n\n{init, InitOptions}.\n{init, [NodeAlias], InitOptions}.\n\n{label, Label}.\n{label, NodeRefs, Label}.\n\n{verbosity, VerbosityLevels}.\n{verbosity, NodeRefs, VerbosityLevels}.\n\n{stylesheet, CSSFile}.\n{stylesheet, NodeRefs, CSSFile}.\n\n{silent_connections, ConnTypes}.\n{silent_connections, NodeRefs, ConnTypes}.\n\n{multiply_timetraps, N}.\n{multiply_timetraps, NodeRefs, N}.\n\n{scale_timetraps, Bool}.\n{scale_timetraps, NodeRefs, Bool}.\n\n{cover, CoverSpecFile}.\n{cover, NodeRefs, CoverSpecFile}.\n\n{cover_stop, Bool}.\n{cover_stop, NodeRefs, Bool}.\n\n{include, IncludeDirs}.\n{include, NodeRefs, IncludeDirs}.\n\n{auto_compile, Bool},\n{auto_compile, NodeRefs, Bool},\n\n{abort_if_missing_suites, Bool},\n{abort_if_missing_suites, NodeRefs, Bool},\n\n{config, ConfigFiles}.\n{config, ConfigDir, ConfigBaseNames}.\n{config, NodeRefs, ConfigFiles}.\n{config, NodeRefs, ConfigDir, ConfigBaseNames}.\n\n{userconfig, {CallbackModule, ConfigStrings}}.\n{userconfig, NodeRefs, {CallbackModule, ConfigStrings}}.\n\n{logdir, LogDir}.\n{logdir, NodeRefs, LogDir}.\n\n{logopts, LogOpts}.\n{logopts, NodeRefs, LogOpts}.\n\n{create_priv_dir, PrivDirOption}.\n{create_priv_dir, NodeRefs, PrivDirOption}.\n\n{event_handler, EventHandlers}.\n{event_handler, NodeRefs, EventHandlers}.\n{event_handler, EventHandlers, InitArgs}.\n{event_handler, NodeRefs, EventHandlers, InitArgs}.\n\n{ct_hooks, CTHModules}.\n{ct_hooks, NodeRefs, CTHModules}.\n\n{ct_hooks_order, CTHOrder}.\n\n{enable_builtin_hooks, Bool}.\n\n{basic_html, Bool}.\n{basic_html, NodeRefs, Bool}.\n\n{esc_chars, Bool}.\n{esc_chars, NodeRefs, Bool}.\n\n{release_shell, Bool}.\n```\n\n_Test terms:_\n\n```erlang\n{suites, Dir, Suites}.\n{suites, NodeRefs, Dir, Suites}.\n\n{groups, Dir, Suite, Groups}.\n{groups, NodeRefs, Dir, Suite, Groups}.\n\n{groups, Dir, Suite, Groups, {cases,Cases}}.\n{groups, NodeRefs, Dir, Suite, Groups, {cases,Cases}}.\n\n{cases, Dir, Suite, Cases}.\n{cases, NodeRefs, Dir, Suite, Cases}.\n\n{skip_suites, Dir, Suites, Comment}.\n{skip_suites, NodeRefs, Dir, Suites, Comment}.\n\n{skip_groups, Dir, Suite, GroupNames, Comment}.\n{skip_groups, NodeRefs, Dir, Suite, GroupNames, Comment}.\n\n{skip_cases, Dir, Suite, Cases, Comment}.\n{skip_cases, NodeRefs, Dir, Suite, Cases, Comment}.\n```\n\n[](){: #types } _Types:_\n\n```erlang\nBool            = true | false\nConstant        = atom()\nValue           = term()\nInclSpecsOption = join | separate\nTestSpecs       = string() | [string()]\nNodeAlias       = atom()\nNode            = node()\nNodeRef         = NodeAlias | Node | master\nNodeRefs        = all_nodes | [NodeRef] | NodeRef\nInitOptions     = term()\nLabel           = atom() | string()\nVerbosityLevels = integer() | [{Category,integer()}]\nCategory        = atom()\nCSSFile         = string()\nConnTypes       = all | [atom()]\nN               = integer()\nCoverSpecFile   = string()\nIncludeDirs     = string() | [string()]\nConfigFiles     = string() | [string()]\nConfigDir       = string()\nConfigBaseNames = string() | [string()]\nCallbackModule  = atom()\nConfigStrings   = string() | [string()]\nLogDir          = string()\nLogOpts         = [term()]\nPrivDirOption   = auto_per_run | auto_per_tc | manual_per_tc\nEventHandlers   = atom() | [atom()]\nInitArgs        = [term()]\nCTHModules      = [CTHModule |\n       \t    {CTHModule, CTHInitArgs} |\n       \t    {CTHModule, CTHInitArgs, CTHPriority}]\nCTHModule       = atom()\nCTHInitArgs     = term()\nCTHOrder        = test | config\nDir             = string()\nSuites          = atom() | [atom()] | all\nSuite           = atom()\nGroups          = GroupPath | GroupSpec | [GroupSpec] | all\nGroupPath       = [[GroupSpec]]\nGroupSpec       = GroupName | {GroupName,Properties} | {GroupName,Properties,[GroupSpec]}\nGroupName       = atom()\nGroupNames      = GroupName | [GroupName]\nCases           = atom() | [atom()] | all\nComment         = string() | \"\"\n```\n\nThe difference between the `config` terms above is that with `ConfigDir`,\n`ConfigBaseNames` is a list of base names, that is, without directory paths.\n`ConfigFiles` must be full names, including paths. For example, the following\ntwo terms have the same meaning:\n\n```erlang\n{config, [\"/home/testuser/tests/config/nodeA.cfg\",\n          \"/home/testuser/tests/config/nodeB.cfg\"]}.\n\n{config, \"/home/testuser/tests/config\", [\"nodeA.cfg\",\"nodeB.cfg\"]}.\n```\n\n> #### Note {: .info }\n>\n> Any relative paths, specified in the test specification, are relative to the\n> directory containing the test specification file if\n> `ct_run -spec TestSpecFile ...` or `ct:run:test([{spec,TestSpecFile},...])`\n> executes the test.\n>\n> The path is relative to the top-level log directory if\n> `ct:run:testspec(TestSpec)` executes the test.","ref":"run_test_chapter.html#test-specification-syntax"},{"type":"extras","title":"Constants - Running Tests and Analyzing Results","doc":"The term `define` introduces a constant that is used to replace the name\n`Constant` with `Value`, wherever it is found in the test specification. This\nreplacement occurs during an initial iteration through the test specification.\nConstants can be used anywhere in the test specification, for example, in any\nlists and tuples, and even in strings and inside the value part of other\nconstant definitions. A constant can also be part of a node name, but that is\nthe only place where a constant can be part of an atom.\n\n> #### Note {: .info }\n>\n> For the sake of readability, the name of the constant must always begin with\n> an uppercase letter, or a `$`, `?`, or `_`. This means that it must always be\n> single quoted (as the constant name is an atom, not text).\n\nThe main benefit of constants is that they can be used to reduce the size (and\navoid repetition) of long strings, such as file paths.\n\n_Examples:_\n\n```erlang\n%% 1a. no constant\n{config, \"/home/testuser/tests/config\", [\"nodeA.cfg\",\"nodeB.cfg\"]}.\n{suites, \"/home/testuser/tests/suites\", all}.\n\n%% 1b. with constant\n{define, 'TESTDIR', \"/home/testuser/tests\"}.\n{config, \"'TESTDIR'/config\", [\"nodeA.cfg\",\"nodeB.cfg\"]}.\n{suites, \"'TESTDIR'/suites\", all}.\n\n%% 2a. no constants\n{config, [testnode@host1, testnode@host2], \"../config\", [\"nodeA.cfg\",\"nodeB.cfg\"]}.\n{suites, [testnode@host1, testnode@host2], \"../suites\", [x_SUITE, y_SUITE]}.\n\n%% 2b. with constants\n{define, 'NODE', testnode}.\n{define, 'NODES', ['NODE'@host1, 'NODE'@host2]}.\n{config, 'NODES', \"../config\", [\"nodeA.cfg\",\"nodeB.cfg\"]}.\n{suites, 'NODES', \"../suites\", [x_SUITE, y_SUITE]}.\n```\n\nConstants make the test specification term `alias`, in previous versions of\n`Common Test`, redundant. This term is deprecated but remains supported in\nupcoming `Common Test` releases. Replacing `alias` terms with `define` is\nstrongly recommended though. An example of such replacement follows:\n\n```erlang\n%% using the old alias term\n{config, \"/home/testuser/tests/config/nodeA.cfg\"}.\n{alias, suite_dir, \"/home/testuser/tests/suites\"}.\n{groups, suite_dir, x_SUITE, group1}.\n\n%% replacing with constants\n{define, 'TestDir', \"/home/testuser/tests\"}.\n{define, 'CfgDir', \"'TestDir'/config\"}.\n{define, 'SuiteDir', \"'TestDir'/suites\"}.\n{config, 'CfgDir', \"nodeA.cfg\"}.\n{groups, 'SuiteDir', x_SUITE, group1}.\n```\n\nConstants can well replace term `node` also, but this still has a declarative\nvalue, mainly when used in combination with `NodeRefs == all_nodes` (see\n[Types](run_test_chapter.md#types)).","ref":"run_test_chapter.html#constants"},{"type":"extras","title":"Example - Running Tests and Analyzing Results","doc":"Here follows a simple test specification example:\n\n```erlang\n{define, 'Top', \"/home/test\"}.\n{define, 'T1', \"'Top'/t1\"}.\n{define, 'T2', \"'Top'/t2\"}.\n{define, 'T3', \"'Top'/t3\"}.\n{define, 'CfgFile', \"config.cfg\"}.\n\n{logdir, \"'Top'/logs\"}.\n\n{config, [\"'T1'/'CfgFile'\", \"'T2'/'CfgFile'\", \"'T3'/'CfgFile'\"]}.\n\n{suites, 'T1', all}.\n{skip_suites, 'T1', [t1B_SUITE,t1D_SUITE], \"Not implemented\"}.\n{skip_cases, 'T1', t1A_SUITE, [test3,test4], \"Irrelevant\"}.\n{skip_cases, 'T1', t1C_SUITE, [test1], \"Ignore\"}.\n\n{suites, 'T2', [t2B_SUITE,t2C_SUITE]}.\n{cases, 'T2', t2A_SUITE, [test4,test1,test7]}.\n\n{skip_suites, 'T3', all, \"Not implemented\"}.\n```\n\nThe example specifies the following:\n\n- The specified `logdir` directory is used for storing the HTML log files (in\n  subdirectories tagged with node name, date, and time).\n- The variables in the specified test system configuration files are imported\n  for the test.\n- The first test to run includes all suites for system `t1`. Suites `t1B` and\n  `t1D` are excluded from the test. Test cases `test3` and `test4` in `t1A` and\n  `test1` case in `t1C` are also excluded from the test.\n- The second test to run is for system `t2`. The included suites are `t2B` and\n  `t2C`. Test cases `test4`, `test1`, and `test7` in suite `t2A` are also\n  included. The test cases are executed in the specified order.\n- The last test to run is for system `t3`. Here, all suites are skipped and this\n  is explicitly noted in the log files.","ref":"run_test_chapter.html#example"},{"type":"extras","title":"The init Term - Running Tests and Analyzing Results","doc":"With term `init` it is possible to specify initialization options for nodes\ndefined in the test specification. There are options to start the node and to\nevaluate any function on the node. For details, see section\n[Automatic Startup of Test Target Nodes](ct_master_chapter.md#ct_slave) in\nsection Using Common Test for Large Scale Testing.","ref":"run_test_chapter.html#the-init-term"},{"type":"extras","title":"User-Specific Terms - Running Tests and Analyzing Results","doc":"The user can provide a test specification including (for `Common Test`)\nunrecognizable terms. If this is desired, use flag `-allow_user_terms` when\nstarting tests with `ct_run`. This forces `Common Test` to ignore unrecognizable\nterms. In this mode, `Common Test` is not able to check the specification for\nerrors as efficiently as if the scanner runs in default mode. If `ct:run_test/1`\nis used for starting the tests, the relaxed scanner mode is enabled by tuple\n`{allow_user_terms,true}`.","ref":"run_test_chapter.html#user-specific-terms"},{"type":"extras","title":"Reading Test Specification Terms - Running Tests and Analyzing Results","doc":"Terms in the current test specification (that is, the specification that has\nbeen used to configure and run the current test) can be looked up. The function\n[`get_testspec_terms()`](`ct:get_testspec_terms/0`) returns a list of all test\nspecification terms (both configuration terms and test terms), and\n`get_testspec_terms(Tags)` returns the term (or a list of terms) matching the\ntag (or tags) in `Tags`.\n\nFor example, in the test specification:\n\n```erlang\n...\n{label, my_server_smoke_test}.\n{config, \"../../my_server_setup.cfg\"}.\n{config, \"../../my_server_interface.cfg\"}.\n...\n```\n\nAnd in, for example, a test suite or a `Common Test Hook` function:\n\n```erlang\n...\n[{label,[{_Node,TestType}]}, {config,CfgFiles}] =\n    ct:get_testspec_terms([label,config]),\n\n[verify_my_server_cfg(TestType, CfgFile) || {Node,CfgFile} <- CfgFiles,\n                                            Node == node()];\n...\n```\n\n[](){: #log_files }","ref":"run_test_chapter.html#reading-test-specification-terms"},{"type":"extras","title":"Log Files - Running Tests and Analyzing Results","doc":"As the execution of the test suites proceed, events are logged in the following\nfour different ways:\n\n- Text to the operator console.\n- Suite-related information is sent to the major log file.\n- Case-related information is sent to the minor log file.\n- The HTML overview log file is updated with test results.\n- A link to all runs executed from a certain directory is written in the log\n  named `all_runs.html` and direct links to all tests (the latest results) are\n  written to the top-level `index.html`.\n\nTypically the operator, possibly running hundreds or thousands of test cases,\ndoes not want to fill the console with details about, or printouts from,\nspecific test cases. By default, the operator only sees the following:\n\n- A confirmation that the test has started and information about how many test\n  cases are executed in total.\n- A small note about each failed test case.\n- A summary of all the run test cases.\n- A confirmation when the test run is complete.\n- Some special information, such as error reports, progress reports, and\n  printouts written with `erlang:display/1`, or `io:format/3` specifically\n  addressed to a receiver other than [`standard_io`](`t:io:standard_io/0`) (for\n  example, the default group leader process `user`).\n\nTo dig deeper into the general results, or the result of a specific test case,\nthe operator can do so by following the links in the HTML presentation and read\nthe major or minor log files. The \"all_runs.html\" page is a good starting point.\nIt is located in `logdir` and contains a link to each test run, including a\nquick overview (with date and time, node name, number of tests, test names, and\ntest result totals).\n\nAn \"index.html\" page is written for each test run (that is, stored in the\n`ct_run` directory tagged with node name, date, and time). This file provides an\noverview of all individual tests performed in the same test run. The test names\nfollow the following convention:\n\n- `TopLevelDir.TestDir` (all suites in `TestDir` executed)\n- `TopLevelDir.TestDir:suites` (specific suites executed)\n- `TopLevelDir.TestDir.Suite` (all cases in `Suite` executed)\n- `TopLevelDir.TestDir.Suite:cases` (specific test cases executed)\n- `TopLevelDir.TestDir.Suite.Case` (only `Case` executed)\n\nThe \"test run index\" page includes a link to the `Common Test` Framework Log\nfile in which information about imported configuration data and general test\nprogress is written. This log file is useful to get snapshot information about\nthe test run during execution. It can also be helpful when analyzing test\nresults or debugging test suites.\n\nThe \"test run index\" page indicates if a test has missing suites (that is,\nsuites that `Common Test` failed to compile). Names of the missing suites can be\nfound in the `Common Test` Framework Log file.\n\nThe major log file shows a detailed report of the test run. It includes test\nsuite and test case names, execution time, the exact reason for failures, and so\non. The information is available in both a file with textual and with HTML\nrepresentation. The HTML file shows a summary that gives a good overview of the\ntest run. It also has links to each individual test case log file for quick\nviewing with an HTML browser.\n\nThe minor log files contain full details of every single test case, each in a\nseparate file. This way, it is straightforward to compare the latest results to\nthat of previous test runs, even if the set of test cases changes. If\napplication SASL is running, its logs are also printed to the current minor log\nfile by the [cth_log_redirect built-in hook](ct_hooks_chapter.md#builtin_cths).\n\nThe full name of the minor log file (that is, the name of the file including the\nabsolute directory path) can be read during execution of the test case. It comes\nas value in tuple `{tc_logfile,LogFileName}` in the `Config` list (which means\nit can also be read by a pre- or post `Common Test Hook` function). Also, at the\nstart of a test case, this data is sent with an event to any installed event\nhandler. For details, see section\n[Event Handling](event_handler_chapter.md#event_handling).\n\nThe log files are written continuously during a test run and links are always\ncreated initially when a test starts. Thevtest progress can therefore be\nfollowed simply by refreshing pages in the HTML browser. Statistics totals are\nnot presented until a test is complete however.\n\n[](){: #logopts }","ref":"run_test_chapter.html#log-files"},{"type":"extras","title":"Log Options - Running Tests and Analyzing Results","doc":"With start flag `logopts` options that modify some aspects of the logging\nbehavior can be specified. The following options are available:\n\n- **`no_src`** - The HTML version of the test suite source code is not generated\n  during the test run (and is consequently not available in the log file\n  system).\n\n- **`no_nl`** - `Common Test` does not add a newline character `(\\n)` to the end\n  of an output string that it receives from a call to, for example,\n  `io:format/2`, and which it prints to the test case log.\n\nFor example, if a test is started with:\n\n`$ ct_run -suite my_SUITE -logopts no_nl`\n\nthen printouts during the test made by successive calls to `io:format(\"x\")`,\nappears in the test case log as:\n\n`xxx`\n\ninstead of each `x` printed on a new line, which is the default behavior.\n\n[](){: #table_sorting }","ref":"run_test_chapter.html#log-options"},{"type":"extras","title":"Sorting HTML Table Columns - Running Tests and Analyzing Results","doc":"By clicking the name in the column header of any table (for example, \"Ok\",\n\"Case\", \"Time\", and so on), the table rows are sorted in whatever order makes\nsense for the type of value (for example, numerical for \"Ok\" or \"Time\", and\nalphabetical for \"Case\"). The sorting is performed through JavaScript code,\nautomatically inserted into the HTML log files. `Common Test` uses the\n[jQuery](http://jquery.com) library and the\n[tablesorter](https://mottie.github.io/tablesorter/docs/) plugin, with\ncustomized sorting functions, for this implementation.","ref":"run_test_chapter.html#sorting-html-table-columns"},{"type":"extras","title":"The Unexpected I/O Log - Running Tests and Analyzing Results","doc":"The test suites overview page includes a link to the Unexpected I/O Log. In this\nlog, `Common Test` saves printouts made with [`ct:log/1,2,3,4,5`](`ct:log/2`)\nand [`ct:pal/1,2,3,4,5`](`ct:pal/2`), as well as captured system error- and\nprogress reports, which cannot be associated with particular test cases and\ntherefore cannot be written to individual test case log files. This occurs, for\nexample, if a log printout is made from an external process (not a test case\nprocess), _or_ if an error- or progress report comes in, during a short interval\nwhile `Common Test` is not executing a test case or configuration function, _or_\nwhile `Common Test` is currently executing a parallel test case group.\n\n[](){: #pre_post_test_io_log }","ref":"run_test_chapter.html#the-unexpected-i-o-log"},{"type":"extras","title":"The Pre- and Post Test I/O Log - Running Tests and Analyzing Results","doc":"The `Common Test` Framework Log page includes links to the Pre- and Post Test\nI/O Log. In this log, `Common Test` saves printouts made with `ct:log/1,2,3,4,5`\nand `ct:pal/1,2,3,4,5`, as well as captured system error- and progress reports,\nwhich take place before, and after, the test run. Examples of this are printouts\nfrom a CT hook init- or terminate function, or progress reports generated when\nan OTP application is started from a CT hook init function. Another example is\nan error report generated because of a failure when an external application is\nstopped from a CT hook terminate function. All information in these examples\nends up in the Pre- and Post Test I/O Log. For more information on how to\nsynchronize test runs with external user applications, see section\n[Synchronizing](ct_hooks_chapter.md#synchronizing) in section Common Test Hooks.\n\n> #### Note {: .info }\n>\n> Logging to file with `ct:log/1,2,3,4,5` or `ct:pal/1,2,3,4,5` only works when\n> `Common Test` is running. Printouts with `ct:pal/1,2,3,4,5` are however always\n> displayed on screen.\n\n[](){: #delete_old_logs }","ref":"run_test_chapter.html#the-pre-and-post-test-i-o-log"},{"type":"extras","title":"Delete Old Logs - Running Tests and Analyzing Results","doc":"`Common Test` can automatically delete old log. This is specified with the\n`keep_logs` option. The default value for this option is `all`, which means that\nno logs are deleted. If the value is set to an integer, `N`, `Common Test`\ndeletes all `ct_run. ` directories, except the `N` newest.\n\n[](){: #html_stylesheet }","ref":"run_test_chapter.html#delete-old-logs"},{"type":"extras","title":"HTML Style Sheets - Running Tests and Analyzing Results","doc":"`Common Test` uses an HTML Style Sheet (CSS file) to control the look of the\nHTML log files generated during test runs. If the log files are not displayed\ncorrectly in the browser of your choice, or you prefer a more primitive (\"pre\n`Common Test` v1.6\") look of the logs, use the start flag/option:\n\n```text\nbasic_html\n```\n\nThis disables the use of style sheets and JavaScripts (see\n[Sorting HTML Table Columns](run_test_chapter.md#table_sorting)).\n\n`Common Test` includes an _optional_ feature to allow user HTML style sheets for\ncustomizing printouts. The functions in `ct` that print to a test case HTML log\nfile (`log/3,4,5` and `pal/3,4,5`) accept `Category` as first argument. With\nthis argument a category can be specified that can be mapped to a named `div`\nselector in a CSS rule-set. This is useful, especially for coloring text\ndifferently depending on the type of (or reason for) the printout. Say you want\none particular background color for test system configuration information, a\ndifferent one for test system state information, and finally one for errors\ndetected by the test case functions. The corresponding style sheet can look as\nfollows:\n\n```css\ndiv.sys_config  { background:blue }\ndiv.sys_state   { background:yellow }\ndiv.error       { background:red }\n```\n\nCommon Test prints the text from `ct:log/3,4,5` or `ct:pal/3,4,5` inside a `pre`\nelement nested under the named `div` element. Since the `pre` selector has a\npredefined CSS rule (in file `ct_default.css`) for the attributes `color`,\n`font-family` and `font-size`, if a user wants to change any of the predefined\nattribute settings, a new rule for `pre` must be added to the user stylesheet.\nExample:\n\n```text\ndiv.error pre { color:white }\n```\n\nHere, white text is used instead of the default black for `div.error` printouts\n(and no other attribute settings for `pre` are affected).\n\nTo install the CSS file (`Common Test` inlines the definition in the HTML code),\nthe file name can be provided when executing `ct_run`.\n\n_Example:_\n\n```text\n$ ct_run -dir $TEST/prog -stylesheet $TEST/styles/test_categories.css\n```\n\nCategories in a CSS file installed with flag `-stylesheet` are on a global test\nlevel in the sense that they can be used in any suite that is part of the test\nrun.\n\nStyle sheets can also be installed on a per suite and per test case basis.\n\n_Example:_\n\n```erlang\n-module(my_SUITE).\n...\nsuite() -> [..., {stylesheet,\"suite_categories.css\"}, ...].\n...\nmy_testcase(_) ->\n    ...\n    ct:log(sys_config, \"Test node version: ~p\", [VersionInfo]),\n    ...\n    ct:log(sys_state, \"Connections: ~p\", [ConnectionInfo]),\n    ...\n    ct:pal(error, \"Error ~p detected! Info: ~p\", [SomeFault,ErrorInfo]),\n    ct:fail(SomeFault).\n```\n\nIf the style sheet is installed as in this example, the categories are private\nto the suite in question. They can be used by all test cases in the suite, but\ncannot be used by other suites. A suite private style sheet, if specified, is\nused in favor of a global style sheet (one specified with flag `-stylesheet`). A\nstylesheet tuple (as returned by `suite/0` above) can also be returned from a\ntest case information function. In this case the categories specified in the\nstyle sheet can only be used in that particular test case. A test case private\nstyle sheet is used in favor of a suite or global level style sheet.\n\nIn a tuple `{stylesheet,CSSFile}`, if `CSSFile` is specified with a path, for\nexample, `\"$TEST/styles/categories.css\"`, this full name is used to locate the\nfile. However, if only the file name is specified, for example,\n`categories.css`, the CSS file is assumed to be located in the data directory,\n`data_dir`, of the suite. The latter use is recommended, as it is portable\ncompared to hard coding path names in the suite.\n\nArgument `Category` in the previous example can have the value (atom)\n`sys_config` (blue background), `sys_state` (yellow background), or `error`\n(white text on red background).\n\n[](){: #repeating_tests }","ref":"run_test_chapter.html#html-style-sheets"},{"type":"extras","title":"Repeating Tests - Running Tests and Analyzing Results","doc":"You can order `Common Test` to repeat the tests you specify. You can choose to\nrepeat tests a number of times, repeat tests for a specific period of time, or\nrepeat tests until a particular stop time is reached. If repetition is\ncontrolled by time, an action for `Common Test` to take upon time-out can be\nspecified. Either `Common Test` performs all tests in the current run before\nstopping, or it stops when the current test job is finished. Repetition can be\nactivated by `ct_run` start flags, or tuples in the `ct:run:test/1` option list\nargument. The flags (options in parentheses) are the following:\n\n- `-repeat N ({repeat,N})`, where `N` is a positive integer\n- `-duration DurTime ({duration,DurTime})`, where `DurTime` is the duration\n- `-until StopTime ({until,StopTime})`, where `StopTime` is finish time\n- `-force_stop ({force_stop,true})`\n- `-force_stop skip_rest ({force_stop,skip_rest})`\n\n- **`DurTime`** - The duration time is specified as `HHMMSS`, for example,\n  `-duration 012030` or `{duration,\"012030\"}`\n\n  , which means that the tests are executed and (if time allows) repeated until\n  time-out occurs after 1 hour, 20 minutes, and 30 seconds.\n\n- **`StopTime`** - The finish time can be specified as `HHMMSS` and is then\n  interpreted as a time today (or possibly tomorrow), but can also be specified\n  as `YYMoMoDDHHMMSS`, for example, `-until 071001120000` or\n  `{until,\"071001120000\"}`. This means that the tests are executed and (if time\n  allows) repeated, until 12 o'clock on the 1st of October 2007.\n\nWhen time-out occurs, `Common Test` never aborts the ongoing test case, as this\ncan leave the SUT in an undefined, and possibly bad, state. Instead\n`Common Test`, by default, finishes the current test run before stopping. If\nflag `force_stop` is specified, `Common Test` stops when the current test job is\nfinished. If flag `force_stop` is specified with `skip_rest`, `Common Test` only\ncompletes the current test case and skips the remaining tests in the test job.\n\n> #### Note {: .info }\n>\n> As `Common Test` always finishes at least the current test case, the time\n> specified with `duration` or `until` is never definitive.\n\nLog files from every repeated test run is saved in normal `Common Test` fashion\n(described earlier).\n\n`Common Test` might later support an optional feature to only store the last\n(and possibly the first) set of logs of repeated test runs, but for now the user\nmust be careful not to run out of disk space if tests are repeated during long\nperiods of time.\n\nFor each test run that is part of a repeated session, information about the\nparticular test run is printed in the `Common Test` Framework Log. The\ninformation includes the repetition number, remaining time, and so on.\n\n_Example 1:_\n\n```text\n$ ct_run -dir $TEST_ROOT/to1 $TEST_ROOT/to2 -duration 001000 -force_stop\n```\n\nHere, the suites in test directory `to1`, followed by the suites in `to2`, are\nexecuted in one test run. A time-out event occurs after 10 minutes. As long as\nthere is time left, `Common Test` repeats the test run (that is, starting over\nwith test `to1`). After time-out, `Common Test` stops when the current job is\nfinished (because of flag `force_stop`). As a result, the specified test run can\nbe aborted after test `to1` and before test `to2`.\n\n_Example 2:_\n\n```text\n$ ct_run -dir $TEST_ROOT/to1 $TEST_ROOT/to2 -duration 001000 -forces_stop skip_rest\n```\n\nHere, the same tests as in Example 1 are run, but with flag `force_stop` set to\n`skip_rest`. If time-out occurs while executing tests in directory `to1`, the\nremaining test cases in `to1` are skipped and the test is aborted without\nrunning the tests in `to2` another time. If time-out occurs while executing\ntests in directory `to2`, the remaining test cases in `to2` are skipped and the\ntest is aborted.\n\n_Example 3:_\n\n```text\n$ date\nFri Sep 28 15:00:00 MEST 2007\n\n$ ct_run -dir $TEST_ROOT/to1 $TEST_ROOT/to2 -until 160000\n```\n\nHere, the same test run as in the previous examples are executed (and possibly\nrepeated). However, when the time-out occurs, after 1 hour, `Common Test`\nfinishes the entire test run before stopping (that is, both `to1` and `to2` are\nalways executed in the same test run).\n\n_Example 4:_\n\n```text\n$ ct_run -dir $TEST_ROOT/to1 $TEST_ROOT/to2 -repeat 5\n```\n\nHere, the test run, including both the `to1` and the `to2` test, is repeated\nfive times.\n\n> #### Note {: .info }\n>\n> Do not confuse this feature with the `repeat` property of a test case group.\n> The options described here are used to repeat execution of entire test runs,\n> while the `repeat` property of a test case group makes it possible to repeat\n> execution of sets of test cases within a suite. For more information about the\n> latter, see section\n> [Test Case Groups ](write_test_chapter.md#test_case_groups)in section Writing\n> Test Suites.\n\n[](){: #silent_connections }","ref":"run_test_chapter.html#repeating-tests"},{"type":"extras","title":"Silent Connections - Running Tests and Analyzing Results","doc":"The protocol handling processes in `Common Test`, implemented by `ct_telnet`,\n`ct_ssh`, `ct_ftp`, and so on, do verbose printing to the test case logs. This\ncan be switched off with flag `-silent_connections`:\n\n```text\nct_run -silent_connections [conn_types]\n```\n\nHere, `conn_types` specifies SSH, Telnet, FTP, RPC, and/or SNMP.\n\n_Example 1:_\n\n```text\nct_run ... -silent_connections ssh telnet\n```\n\nThis switches off logging for SSH and Telnet connections.\n\n_Example 2:_\n\n```text\nct_run ... -silent_connections\n```\n\nThis switches off logging for all connection types.\n\nFatal communication error and reconnection attempts are always printed, even if\nlogging has been suppressed for the connection type in question. However,\noperations such as sending and receiving data are performed silently.\n\n`silent_connections` can also be specified in a test suite. This is accomplished\nby returning a tuple, `{silent_connections,ConnTypes}`, in the `suite/0` or test\ncase information list. If `ConnTypes` is a list of atoms (SSH, Telnet, FTP, RPC\nand/or SNMP), output for any corresponding connections are suppressed. Full\nlogging is by default enabled for any connection of type not specified in\n`ConnTypes`. Hence, if `ConnTypes` is the empty list, logging is enabled for all\nconnections.\n\n_Example 3:_\n\n```erlang\n-module(my_SUITE).\n\nsuite() -> [..., {silent_connections,[telnet,ssh]}, ...].\n\n...\n\nmy_testcase1() ->\n    [{silent_connections,[ssh]}].\n\nmy_testcase1(_) ->\n    ...\n\nmy_testcase2(_) ->\n    ...\n```\n\nIn this example, `suite/0` tells `Common Test` to suppress printouts from Telnet\nand SSH connections. This is valid for all test cases. However, `my_testcase1/0`\nspecifies that for this test case, only SSH is to be silent. The result is that\n`my_testcase1` gets Telnet information (if any) printed in the log, but not SSH\ninformation. `my_testcase2` gets no information from either connection printed.\n\n`silent_connections` can also be specified with a term in a test specification\n(see section [Test Specifications](run_test_chapter.md#test_specifications) in\nsection Running Tests and Analyzing Results). Connections provided with start\nflag/option `silent_connections` are merged with any connections listed in the\ntest specification.\n\nStart flag/option `silent_connections` and the test specification term override\nany settings made by the information functions inside the test suite.\n\n> #### Note {: .info }\n>\n> In the current `Common Test` version, the `silent_connections` feature only\n> works for Telnet and SSH connections. Support for other connection types can\n> be added in future `Common Test` versions.","ref":"run_test_chapter.html#silent-connections"},{"type":"extras","title":"External Configuration Data","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# External Configuration Data\n\n[](){: #top }","ref":"config_file_chapter.html"},{"type":"extras","title":"General - External Configuration Data","doc":"To avoid hard-coding data values related to the test and/or System Under Test\n(SUT) in the test suites, the data can instead be specified through\nconfiguration files or strings that `Common Test` reads before the start of a\ntest run. External configuration data makes it possible to change test\nproperties without modifying the test suites using the data. Examples of\nconfiguration data follows:\n\n- Addresses to the test plant or other instruments\n- User login information\n- Names of files needed by the test\n- Names of programs to be executed during the test\n- Any other variable needed by the test","ref":"config_file_chapter.html#general"},{"type":"extras","title":"Syntax - External Configuration Data","doc":"A configuration file can contain any number of elements of the type:\n\n```erlang\n{CfgVarName,Value}.\n```\n\nwhere\n\n```erlang\nCfgVarName = atom()\nValue = term() | [{CfgVarName,Value}]\n```","ref":"config_file_chapter.html#syntax"},{"type":"extras","title":"Requiring and Reading Configuration Data - External Configuration Data","doc":"[](){: #require_config_data }\n\nIn a test suite, one must _require_ that a configuration variable (`CfgVarName`\nin the previous definition) exists before attempting to read the associated\nvalue in a test case or configuration function.\n\n`require` is an assert statement, which can be part of the\n[Test Suite Information Function](write_test_chapter.md#suite) or\n[Test Case Information Function](write_test_chapter.md#info_function). If the\nrequired variable is unavailable, the test is skipped (unless a default value\nhas been specified, see section\n[Test Case Information Function](write_test_chapter.md#info_function) for\ndetails). Also, function [`ct:require/1/2`](`ct:require/1`) can be called from a\ntest case to check if a specific variable is available. The return value from\nthis function must be checked explicitly and appropriate action be taken\ndepending on the result (for example, to skip the test case if the variable in\nquestion does not exist).\n\nA `require` statement in the test suite information case or test case\ninformation-list is to look like `{require,CfgVarName}` or\n`{require,AliasName,CfgVarName}`. The arguments `AliasName` and `CfgVarName` are\nthe same as the arguments to [`ct:require/1,2`](`ct:require/1`). `AliasName`\nbecomes an alias for the configuration variable, and can be used as reference to\nthe configuration data value. The configuration variable can be associated with\nany number of alias names, but each name must be unique within the same test\nsuite. The two main uses for alias names follows:\n\n- To identify connections (described later).\n- To help adapt configuration data to a test suite (or test case) and improve\n  readability.\n\nTo read the value of a configuration variable, use function\n[`get_config/1,2,3`](`ct:get_config/1`).\n\n_Example:_\n\n```erlang\nsuite() ->\n    [{require, domain, 'CONN_SPEC_DNS_SUFFIX'}].\n\n...\n\ntestcase(Config) ->\n    Domain = ct:get_config(domain),\n    ...\n```","ref":"config_file_chapter.html#requiring-and-reading-configuration-data"},{"type":"extras","title":"Using Configuration Variables Defined in Multiple Files - External Configuration Data","doc":"If a configuration variable is defined in multiple files and you want to access\nall possible values, use function `ct:get_config/3` and specify `all` in the\noptions list. The values are then returned in a list and the order of the\nelements corresponds to the order that the configuration files were specified at\nstartup.","ref":"config_file_chapter.html#using-configuration-variables-defined-in-multiple-files"},{"type":"extras","title":"Encrypted Configuration Files - External Configuration Data","doc":"[](){: #encrypted_config_files }\n\nConfiguration files containing sensitive data can be encrypted if they must be\nstored in open and shared directories.\n\nTo have `Common Test` encrypt a specified file using function `DES3` in\napplication `Crypto`, call\n[`ct:encrypt_config_file/2,3`](`ct:encrypt_config_file/2`) The encrypted file\ncan then be used as a regular configuration file in combination with other\nencrypted files or normal text files. However, the key for decrypting the\nconfiguration file must be provided when running the test. This can be done with\nflag/option `decrypt_key` or `decrypt_file`, or a key file in a predefined\nlocation.\n\n`Common Test` also provides decryption functions,\n[`ct:decrypt_config_file/2,3`](`ct:decrypt_config_file/2`), for recreating the\noriginal text files.","ref":"config_file_chapter.html#encrypted-configuration-files"},{"type":"extras","title":"Opening Connections Using Configuration Data - External Configuration Data","doc":"Two different methods for opening a connection using the support functions in,\nfor example, `m:ct_ssh`, `m:ct_ftp`, and `m:ct_telnet` follows:\n\n- Using a configuration target name (an alias) as reference.\n- Using the configuration variable as reference.\n\nWhen a target name is used for referencing the configuration data (that\nspecifies the connection to be opened), the same name can be used as connection\nidentity in all subsequent calls related to the connection (also for closing\nit). Only one open connection per target name is possible. If you attempt to\nopen a new connection using a name already associated with an open connection,\n`Common Test` returns the already existing handle so the previously opened\nconnection is used. This feature makes it possible to call the function for\nopening a particular connection whenever useful. An action like this does not\nnecessarily open any new connections unless it is required (which could be the\ncase if, for example, the previous connection has been closed unexpectedly by\nthe server). Using named connections also removes the need to pass handle\nreferences around in the suite for these connections.\n\nWhen a configuration variable name is used as reference to the data specifying\nthe connection, the handle returned as a result of opening the connection must\nbe used in all subsequent calls (also for closing the connection). Repeated\ncalls to the open function with the same variable name as reference results in\nmultiple connections being opened. This can be useful, for example, if a test\ncase needs to open multiple connections to the same server on the target node\n(using the same configuration data for each connection).","ref":"config_file_chapter.html#opening-connections-using-configuration-data"},{"type":"extras","title":"User-Specific Configuration Data Formats - External Configuration Data","doc":"The user can specify configuration data on a different format than key-value\ntuples in a text file, as described so far. The data can, for example, be read\nfrom any files, fetched from the web over HTTP, or requested from a\nuser-specific process. To support this, `Common Test` provides a callback module\nplugin mechanism to handle configuration data.","ref":"config_file_chapter.html#user-specific-configuration-data-formats"},{"type":"extras","title":"Default Callback Modules for Handling Configuration Data - External Configuration Data","doc":"`Common Test` includes default callback modules for handling configuration data\nspecified in standard configuration files (described earlier) and in XML files\nas follows:\n\n- `ct_config_plain` \\- for reading configuration files with key-value tuples\n  (standard format). This handler is used to parse configuration files if no\n  user callback is specified.\n- `ct_config_xml` \\- for reading configuration data from XML files.","ref":"config_file_chapter.html#default-callback-modules-for-handling-configuration-data"},{"type":"extras","title":"Using XML Configuration Files - External Configuration Data","doc":"An example of an XML configuration file follows:\n\n```xml\n \n    \n        \"targethost\" \n        \"tester\" \n        \"letmein\" \n    \n    \"/test/loadmodules\" \n \n```\n\nOnce read, this file produces the same configuration variables as the following\ntext file:\n\n```erlang\n{ftp_host, [{ftp,\"targethost\"},\n            {username,\"tester\"},\n            {password,\"letmein\"}]}.\n\n{lm_directory, \"/test/loadmodules\"}.\n```","ref":"config_file_chapter.html#using-xml-configuration-files"},{"type":"extras","title":"Implement a User-Specific Handler - External Configuration Data","doc":"The user-specific handler can be written to handle special configuration file\nformats. The parameter can be either file names or configuration strings (the\nempty list is valid).\n\nThe callback module implementing the handler is responsible for checking the\ncorrectness of configuration strings.\n\nTo validate the configuration strings, the callback module is to have function\n`Callback:check_parameter/1` exported.\n\nThe input argument is passed from `Common Test`, as defined in the test\nspecification, or specified as an option to `ct_run` or `ct:run_test`.\n\nThe return value is to be any of the following values, indicating if the\nspecified configuration parameter is valid:\n\n- `{ok, {file, FileName}}` \\- the parameter is a file name and the file exists.\n- `{ok, {config, ConfigString}}` \\- the parameter is a configuration string and\n  it is correct.\n- `{error, {nofile, FileName}}` \\- there is no file with the specified name in\n  the current directory.\n- `{error, {wrong_config, ConfigString}}` \\- the configuration string is wrong.\n\nThe function `Callback:read_config/1` is to be exported from the callback module\nto read configuration data, initially before the tests start, or as a result of\ndata being reloaded during test execution. The input argument is the same as for\nfunction `check_parameter/1`.\n\nThe return value is to be either of the following:\n\n- `{ok, Config}` \\- if the configuration variables are read successfully.\n- `{error, {Error, ErrorDetails}}` \\- if the callback module fails to proceed\n  with the specified configuration parameters.\n\n`Config` is the proper Erlang key-value list, with possible key-value sublists\nas values, like the earlier configuration file example:\n\n```erlang\n[{ftp_host, [{ftp, \"targethost\"}, {username, \"tester\"}, {password, \"letmein\"}]},\n {lm_directory, \"/test/loadmodules\"}]\n```","ref":"config_file_chapter.html#implement-a-user-specific-handler"},{"type":"extras","title":"Examples of Configuration Data Handling - External Configuration Data","doc":"A configuration file for using the FTP client to access files on a remote host\ncan look as follows:\n\n```erlang\n{ftp_host, [{ftp,\"targethost\"},\n            {username,\"tester\"},\n            {password,\"letmein\"}]}.\n\n{lm_directory, \"/test/loadmodules\"}.\n```\n\nThe XML version shown earlier can also be used, but it is to be explicitly\nspecified that the `ct_config_xml` callback module is to be used by\n`Common Test`.\n\nThe following is an example of how to assert that the configuration data is\navailable and can be used for an FTP session:\n\n```erlang\ninit_per_testcase(ftptest, Config) ->\n    {ok,_} = ct_ftp:open(ftp),\n    Config.\n\nend_per_testcase(ftptest, _Config) ->\n    ct_ftp:close(ftp).\n\nftptest() ->\n    [{require,ftp,ftp_host},\n     {require,lm_directory}].\n\nftptest(Config) ->\n    Remote = filename:join(ct:get_config(lm_directory), \"loadmodX\"),\n    Local = filename:join(proplists:get_value(priv_dir,Config), \"loadmodule\"),\n    ok = ct_ftp:recv(ftp, Remote, Local),\n    ...\n```\n\nThe following is an example of how the functions in the previous example can be\nrewritten if it is necessary to open multiple connections to the FTP server:\n\n```erlang\ninit_per_testcase(ftptest, Config) ->\n    {ok,Handle1} = ct_ftp:open(ftp_host),\n    {ok,Handle2} = ct_ftp:open(ftp_host),\n    [{ftp_handles,[Handle1,Handle2]} | Config].\n\nend_per_testcase(ftptest, Config) ->\n    lists:foreach(fun(Handle) -> ct_ftp:close(Handle) end,\n                  proplists:get_value(ftp_handles,Config)).\n\nftptest() ->\n    [{require,ftp_host},\n     {require,lm_directory}].\n\nftptest(Config) ->\n    Remote = filename:join(ct:get_config(lm_directory), \"loadmodX\"),\n    Local = filename:join(proplists:get_value(priv_dir,Config), \"loadmodule\"),\n    [Handle | MoreHandles] = proplists:get_value(ftp_handles,Config),\n    ok = ct_ftp:recv(Handle, Remote, Local),\n    ...\n```","ref":"config_file_chapter.html#examples-of-configuration-data-handling"},{"type":"extras","title":"Example of User-Specific Configuration Handler - External Configuration Data","doc":"A simple configuration handling driver, asking an external server for\nconfiguration data, can be implemented as follows:\n\n```erlang\n-module(config_driver).\n-export([read_config/1, check_parameter/1]).\n\nread_config(ServerName)->\n    ServerModule = list_to_atom(ServerName),\n    ServerModule:start(),\n    ServerModule:get_config().\n\ncheck_parameter(ServerName)->\n    ServerModule = list_to_atom(ServerName),\n    case code:is_loaded(ServerModule) of\n        {file, _}->\n            {ok, {config, ServerName}};\n        false->\n            case code:load_file(ServerModule) of\n                {module, ServerModule}->\n                    {ok, {config, ServerName}};\n                {error, nofile}->\n                    {error, {wrong_config, \"File not found: \" ++ ServerName ++ \".beam\"}}\n            end\n    end.\n```\n\nThe configuration string for this driver can be `config_server`, if the\n`config_server.erl` module that follows is compiled and exists in the code path\nduring test execution:\n\n```erlang\n-module(config_server).\n-export([start/0, stop/0, init/1, get_config/0, loop/0]).\n\n-define(REGISTERED_NAME, ct_test_config_server).\n\nstart()->\n    case whereis(?REGISTERED_NAME) of\n        undefined->\n            spawn(?MODULE, init, [?REGISTERED_NAME]),\n            wait();\n        _Pid->\n        ok\n    end,\n    ?REGISTERED_NAME.\n\ninit(Name)->\n    register(Name, self()),\n    loop().\n\nget_config()->\n    call(self(), get_config).\n\nstop()->\n    call(self(), stop).\n\ncall(Client, Request)->\n    case whereis(?REGISTERED_NAME) of\n        undefined->\n            {error, {not_started, Request}};\n        Pid->\n            Pid ! {Client, Request},\n            receive\n                Reply->\n                    {ok, Reply}\n            after 4000->\n                {error, {timeout, Request}}\n            end\n    end.\n\nloop()->\n    receive\n        {Pid, stop}->\n            Pid ! ok;\n        {Pid, get_config}->\n            {D,T} = erlang:localtime(),\n            Pid !\n                [{localtime, [{date, D}, {time, T}]},\n                 {node, erlang:node()},\n                 {now, erlang:now()},\n                 {config_server_pid, self()},\n                 {config_server_vsn, ?vsn}],\n            ?MODULE:loop()\n    end.\n\nwait()->\n    case whereis(?REGISTERED_NAME) of\n        undefined->\n            wait();\n        _Pid->\n            ok\n    end.\n```\n\nHere, the handler also provides for dynamically reloading of configuration\nvariables. If [`ct:reload_config(localtime)`](`ct:reload_config/1`) is called\nfrom the test case function, all variables loaded with\n`config_driver:read_config/1` are updated with their latest values, and the new\nvalue for variable `localtime` is returned.","ref":"config_file_chapter.html#example-of-user-specific-configuration-handler"},{"type":"extras","title":"Code Coverage Analysis","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Code Coverage Analysis\n\n[](){: #cover }","ref":"cover_chapter.html"},{"type":"extras","title":"General - Code Coverage Analysis","doc":"Although `Common Test` was created primarily for black-box testing, nothing\nprevents it from working perfectly as a white-box testing tool as well. This is\nespecially true when the application to test is written in Erlang. Then the test\nports are easily realized with Erlang function calls.\n\nWhen white-box testing an Erlang application, it is useful to be able to measure\nthe code coverage of the test. `Common Test` provides simple access to the OTP\nCover tool for this purpose. `Common Test` handles all necessary communication\nwith the Cover tool (starting, compiling, analysing, and so on). The\n`Common Test` user only needs to specify the extent of the code coverage\nanalysis.","ref":"cover_chapter.html#general"},{"type":"extras","title":"Use - Code Coverage Analysis","doc":"To specify the modules to be included in the code coverage test, provide a cover\nspecification file. With this file you can point out specific modules or specify\ndirectories containing modules to be included in the analysis. You can also\nspecify modules to be excluded from the analysis.\n\nIf you are testing a distributed Erlang application, it is likely that code you\nwant included in the code coverage analysis gets executed on another Erlang node\nthan the one `Common Test` is running on. If so, you must specify these other\nnodes in the cover specification file or add them dynamically to the code\ncoverage set of nodes. For details on the latter, see module `m:ct_cover`.\n\nIn the cover specification file you can also specify your required level of the\ncode coverage analysis; `details` or `overview`. In detailed mode, you get a\ncoverage overview page, showing per module and total coverage percentages. You\nalso get an HTML file printed for each module included in the analysis showing\nexactly what parts of the code have been executed during the test. In overview\nmode, only the code coverage overview page is printed.\n\nYou can choose to export and import code coverage data between tests. If you\nspecify the name of an export file in the cover specification file,\n`Common Test` exports collected coverage data to this file at the end of the\ntest. You can similarly specify previously exported data to be imported and\nincluded in the analysis for a test (multiple import files can be specified).\nThis way, the total code coverage can be analyzed without necessarily running\nall tests at once.\n\nTo activate the code coverage support, specify the name of the cover\nspecification file as you start `Common Test`. Do this by using flag `-cover`\nwith [`ct_run`](ct_run_cmd.md), for example:\n\n```text\n$ ct_run -dir $TESTOBJS/db -cover $TESTOBJS/db/config/db.coverspec\n```\n\nYou can also pass the cover specification file name in a call to\n`ct:run_test/1`, by adding a `{cover,CoverSpec}` tuple to argument `Opts`.\n\nYou can also enable code coverage in your test specifications (see section\n[Test Specifications](run_test_chapter.md#test_specifications) in section\nRunning Tests and Analyzing Results).\n\n[](){: #cover_stop }","ref":"cover_chapter.html#use"},{"type":"extras","title":"Stopping the Cover Tool When Tests Are Completed - Code Coverage Analysis","doc":"By default, the Cover tool is automatically stopped when the tests are\ncompleted. This causes the original (non-cover compiled) modules to be loaded\nback into the test node. If a process at this point still runs old code of any\nof the modules that are cover compiled, meaning that it has not done any fully\nqualified function call after the cover compilation, the process is killed. To\navoid this, set the value of option `cover_stop` to `false`. This means that the\nmodules stay cover compiled. Therefore, this is only recommended if the Erlang\nnodes under test are terminated after the test is completed, or if cover can be\nmanually stopped.\n\nThe option can be set by using flag `-cover_stop` with `ct_run`, by adding\n`{cover_stop,true|false}` to argument `Opts` to `ct:run_test/1`, or by adding a\n`cover_stop` term in the test specification (see section\n[Test Specifications](run_test_chapter.md#test_specifications) in section\nRunning Tests and Analyzing Results).","ref":"cover_chapter.html#stopping-the-cover-tool-when-tests-are-completed"},{"type":"extras","title":"The Cover Specification File - Code Coverage Analysis","doc":"","ref":"cover_chapter.html#the-cover-specification-file"},{"type":"extras","title":"General Config - Code Coverage Analysis","doc":"Here follows the general configuration terms that are allowed in a cover\nspecification file:\n\n```erlang\n%% List of Nodes on which cover will be active during test.\n%% Nodes = [atom()]\n{nodes, Nodes}.\n\n%% Files with previously exported cover data to include in analysis.\n%% CoverDataFiles = [string()]\n{import, CoverDataFiles}.\n\n%% Cover data file to export from this session.\n%% CoverDataFile = string()\n{export, CoverDataFile}.\n\n%% Cover analysis level.\n%% Level = details | overview\n{level, Level}.\n\n%% Directories to include in cover.\n%% Dirs = [string()]\n{incl_dirs, Dirs}.\n\n%% Directories, including subdirectories, to include.\n{incl_dirs_r, Dirs}.\n\n%% Specific modules to include in cover.\n%% Mods = [atom()]\n{incl_mods, Mods}.\n\n%% Directories to exclude in cover.\n{excl_dirs, Dirs}.\n\n%% Directories, including subdirectories, to exclude.\n{excl_dirs_r, Dirs}.\n\n%% Specific modules to exclude in cover.\n{excl_mods, Mods}.\n\n%% Cross cover compilation\n%% Tag = atom(), an identifier for a test run\n%% Mod = [atom()], modules to compile for accumulated analysis\n{cross,[{Tag,Mods}]}.\n```\n\nThe terms `incl_dirs_r` and `excl_dirs_r` tell `Common Test` to search the\nspecified directories recursively and include or exclude any module found during\nthe search. The terms `incl_dirs` and `excl_dirs` result in a non-recursive\nsearch for modules (that is, only modules found in the specified directories are\nincluded or excluded).\n\n> #### Note {: .info }\n>\n> Directories containing Erlang modules to be included in a code coverage test\n> must exist in the code server path. Otherwise, the Cover tool fails to\n> recompile the modules. It is not sufficient to specify these directories in\n> the cover specification file for `Common Test`.","ref":"cover_chapter.html#general-config"},{"type":"extras","title":"OTP application Config - Code Coverage Analysis","doc":"When using a cover specification in the testing of an OTP application itself,\nthere is a special incl_app directive that includes the applications modules for\nthe cover compilation.\n\n```erlang\n{incl_app, AppName, Cover :: overview | details}.\n```\n\n> #### Note {: .info }\n>\n> If you desire to also use some other general cover configuration together with\n> this option you should insert the AppName in between the option and its value\n> creating a three tuple.\n\n[](){: #cross_cover }","ref":"cover_chapter.html#otp-application-config"},{"type":"extras","title":"Cross Cover Analysis - Code Coverage Analysis","doc":"The cross cover mechanism allows cover analysis of modules across multiple\ntests. It is useful if some code, for example, a library module, is used by many\ndifferent tests and the accumulated cover result is desirable.\n\nThis can also be achieved in a more customized way by using parameter `export`\nin the cover specification and analysing the result off line. However, the cross\ncover mechanism is a built-in solution that also provides logging.\n\nThe mechanism is easiest explained by an example:\n\nAssume that there are two systems, `s1` and `s2`, that are tested in separate\ntest runs. System `s1` contains a library module `m1` tested by test run `s1`\nand is included in the cover specification of `s1` as follows:\n\n```text\ns1.cover:\n  {incl_mods,[m1]}.\n```\n\nWhen analysing code coverage, the result for `m1` can be seen in the cover log\nin the `s1` test result.\n\nNow, imagine that as `m1` is a library module, it is also often used by system\n`s2`. Test run `s2` does not specifically test `m1`, but it can still be\ninteresting to see which parts of `m1` that are covered by the `s2` tests. To do\nthis, `m1` can be included also in the cover specification of `s2` as follows:\n\n```text\ns2.cover:\n  {incl_mods,[m1]}.\n```\n\nThis gives an entry for `m1` also in the cover log for test run `s2`. The\nproblem is that this only reflects the coverage by `s2` tests, not the\naccumulated result over `s1` and `s2`. This is where the cross cover mechanism\ncomes in handy.\n\nIf instead the cover specification for `s2` is like the following:\n\n```text\ns2.cover:\n  {cross,[{s1,[m1]}]}.\n```\n\nThen `m1` is cover compiled in test run `s2`, but not shown in the coverage log.\nInstead, if `ct_cover:cross_cover_analyse/2` is called after both `s1` and `s2`\ntest runs are completed, the accumulated result for `m1` is available in the\ncross cover log for test run `s1`.\n\nThe call to the analyze function must be as follows:\n\n```erlang\nct_cover:cross_cover_analyse(Level, [{s1,S1LogDir},{s2,S2LogDir}]).\n```\n\nHere, `S1LogDir` and `S2LogDir` are the directories named ` .logs` for\neach test respectively.\n\nNotice the tags `s1` and `s2`, which are used in the cover specification file\nand in the call to `ct_cover:cross_cover_analyse/2`. The purpose of these is\nonly to map the modules specified in the cover specification to the log\ndirectory specified in the call to the analyze function. The tag name has no\nmeaning beyond this.","ref":"cover_chapter.html#cross-cover-analysis"},{"type":"extras","title":"Logging - Code Coverage Analysis","doc":"To view the result of a code coverage test, click the button labeled \"COVER LOG\"\nin the top-level index page for the test run.\n\nBefore Erlang/OTP 17.1, if your test run consisted of multiple tests, cover\nwould be started and stopped for each test within the test run. Separate logs\nwould be available through the \"Coverage log\" link on the test suite result\npages. These links are still available, but now they all point to the same page\nas the button on the top-level index page. The log contains the accumulated\nresults for the complete test run. For details about this change, see the\nrelease notes.\n\nThe button takes you to the code coverage overview page. If you have\nsuccessfully performed a detailed coverage analysis, links to each individual\nmodule coverage page are found here.\n\nIf cross cover analysis is performed, and there are accumulated coverage results\nfor the current test, the link \"Coverdata collected over all tests\" takes you to\nthese results.","ref":"cover_chapter.html#logging"},{"type":"extras","title":"Using Common Test for Large-Scale Testing","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Using Common Test for Large-Scale Testing","ref":"ct_master_chapter.html"},{"type":"extras","title":"General - Using Common Test for Large-Scale Testing","doc":"Large-scale automated testing requires running multiple independent test\nsessions in parallel. This is accomplished by running some `Common Test` nodes\non one or more hosts, testing different target systems. Configuring, starting,\nand controlling the test nodes independently can be a cumbersome operation. To\naid this kind of automated large-scale testing, `Common Test` offers a master\ntest node component, `Common Test` Master, which handles central configuration\nand control in a system of distributed `Common Test` nodes.\n\nThe `Common Test` Master server runs on one dedicated Erlang node and uses\ndistributed Erlang to communicate with any number of `Common Test` test nodes,\neach hosting a regular `Common Test` server. Test specifications are used as\ninput to specify what to test on which test nodes, using what configuration.\n\nThe `Common Test` Master server writes progress information to HTML log files\nsimilarly to the regular `Common Test` server. The logs contain test statistics\nand links to the log files written by each independent `Common Test` server.\n\nThe `Common Test` Master API is exported by module `m:ct_master`.","ref":"ct_master_chapter.html#general"},{"type":"extras","title":"Use - Using Common Test for Large-Scale Testing","doc":"`Common Test` Master requires all test nodes to be on the same network and share\na common file system. `Common Test` Master cannot start test nodes\nautomatically. The nodes must be started in advance for `Common Test` Master to\nbe able to start test sessions on them.\n\nTests are started by calling [`ct_master:run(TestSpecs)`](`ct_master:run/1`) or\n[`ct_master:run(TestSpecs, InclNodes, ExclNodes)`](`ct_master:run/3`)\n\n`TestSpecs` is either the name of a test specification file (string) or a list\nof test specifications. If it is a list, the specifications are handled (and the\ncorresponding tests executed) in sequence. An element in a `TestSpecs` list can\nalso be list of test specifications. The specifications in such a list are\nmerged into one combined specification before test execution.\n\n_Example:_\n\n```erlang\nct_master:run([\"ts1\",\"ts2\",[\"ts3\",\"ts4\"]])\n```\n\nHere, the tests specified by \"ts1\" run first, then the tests specified by \"ts2\",\nand finally the tests specified by both \"ts3\" and \"ts4\".\n\nThe `InclNodes` argument to `run/3` is a list of node names. Function `run/3`\nruns the tests in `TestSpecs` just like `run/1`, but also takes any test in\n`TestSpecs`, which is not explicitly tagged with a particular node name, and\nexecute it on the nodes listed in `InclNodes`. By using `run/3` this way, any\ntest specification can be used, with or without node information, in a\nlarge-scale test environment.\n\n`ExclNodes` is a list of nodes to be excluded from the test. That is, tests that\nare specified in the test specification to run on a particular node are not\nperformed if that node is listed in `ExclNodes` at runtime.\n\nIf `Common Test` Master fails initially to connect to any of the test nodes\nspecified in a test specification or in the `InclNodes` list, the operator is\nprompted with the option to either start over again (after manually checking the\nstatus of the nodes in question), to run without the missing nodes, or to abort\nthe operation.\n\nWhen tests start, `Common Test` Master displays information to console about the\ninvolved nodes. `Common Test` Master also reports when tests finish,\nsuccessfully or unsuccessfully. If connection is lost to a node, the test on\nthat node is considered finished. `Common Test` Master does not attempt to\nre-establish contact with the failing node.\n\nAt any time, to get the current status of the test nodes, call function\n[`ct_master:progress()`](`ct_master:progress/0`).\n\nTo stop one or more tests, use function\n[`ct_master:abort()`](`ct_master:abort/0`) (to stop all) or\n[`ct_master:abort(Nodes)`](`ct_master:abort/1`).\n\nFor details about the `Common Test` Master API, see module `m:ct_master`.\n\n[](){: #test_specifications }","ref":"ct_master_chapter.html#use"},{"type":"extras","title":"Test Specifications - Using Common Test for Large-Scale Testing","doc":"The test specifications used as input to `Common Test` Master are fully\ncompatible with the specifications used as input to the regular `Common Test`\nserver. The syntax is described in section\n[Test Specifications](run_test_chapter.md#test_specifications) in section\nRunning Tests and Analyzing Results.\n\nAll test specification terms can have a `NodeRefs` element. This element\nspecifies which node or nodes a configuration operation or a test is to be\nexecuted on. `NodeRefs` is defined as follows:\n\n`NodeRefs = all_nodes | [NodeRef] | NodeRef`\n\n`NodeRef = NodeAlias | node() | master`\n\nA `NodeAlias` (`t:atom/0`) is used in a test specification as a reference to a\nnode name (so the node name only needs to be declared once, which also can be\nachieved using constants). The alias is declared with a `node` term as follows:\n\n`{node, NodeAlias, NodeName}`\n\nIf `NodeRefs` has the value `all_nodes`, the operation or test is performed on\nall specified test nodes. (Declaring a term without a `NodeRefs` element has the\nsame effect). If `NodeRefs` has the value `master`, the operation is only\nperformed on the `Common Test` Master node (namely set the log directory or\ninstall an event handler).\n\nConsider the example in section\n[Test Specifications](run_test_chapter.md#test_specifications) in section\nRunning Tests and Analysing Results, now extended with node information and\nintended to be executed by `Common Test` Master:\n\n```erlang\n{define, 'Top', \"/home/test\"}.\n{define, 'T1', \"'Top'/t1\"}.\n{define, 'T2', \"'Top'/t2\"}.\n{define, 'T3', \"'Top'/t3\"}.\n{define, 'CfgFile', \"config.cfg\"}.\n{define, 'Node', ct_node}.\n\n{node, node1, 'Node@host_x'}.\n{node, node2, 'Node@host_y'}.\n\n{logdir, master, \"'Top'/master_logs\"}.\n{logdir, \"'Top'/logs\"}.\n\n{config, node1, \"'T1'/'CfgFile'\"}.\n{config, node2, \"'T2'/'CfgFile'\"}.\n{config, \"'T3'/'CfgFile'\"}.\n\n{suites, node1, 'T1', all}.\n{skip_suites, node1, 'T1', [t1B_SUITE,t1D_SUITE], \"Not implemented\"}.\n{skip_cases, node1, 'T1', t1A_SUITE, [test3,test4], \"Irrelevant\"}.\n{skip_cases, node1, 'T1', t1C_SUITE, [test1], \"Ignore\"}.\n\n{suites, node2, 'T2', [t2B_SUITE,t2C_SUITE]}.\n{cases, node2, 'T2', t2A_SUITE, [test4,test1,test7]}.\n\n{skip_suites, 'T3', all, \"Not implemented\"}.\n```\n\nThis example specifies the same tests as the original example. But now if\nstarted with a call to `ct_master:run(TestSpecName)`, test `t1` is executed on\nnode `ct_node@host_x` (`node1`), test `t2` on `ct_node@host_y` (`node2`) and\ntest `t3` on both `node1` and `node2`. Configuration file `t1` is only read on\n`node1` and configuration file `t2` only on `node2`, while the configuration\nfile `t3` is read on both `node1` and `node2`. Both test nodes write log files\nto the same directory. (However, the `Common Test` Master node uses a different\nlog directory than the test nodes.)\n\nIf the test session is instead started with a call to\n`ct_master:run(TestSpecName, [ct_node@host_z], [ct_node@host_x])`, the result is\nthat test `t1` does not run on `ct_node@host_x` (or any other node) while test\n`t3` runs on both `ct_node@host_y` and `ct_node@host_z`.\n\nA nice feature is that a test specification that includes node information can\nstill be used as input to the regular `Common Test` server (as described in\nsection [Test Specifications](run_test_chapter.md#test_specifications)). The\nresult is that any test specified to run on a node with the same name as the\n`Common Test` node in question (typically `ct@somehost` if started with the\n`ct_run` program), is performed. Tests without explicit node association are\nalways performed too, of course.","ref":"ct_master_chapter.html#test-specifications"},{"type":"extras","title":"Automatic Startup of Test Target Nodes - Using Common Test for Large-Scale Testing","doc":"[](){: #ct_slave }\n\nInitial actions can be started and performed automatically on test target nodes\nusing test specification term `init`.\n\nTwo subterms are supported, `node_start` and `eval`.\n\n_Example:_\n\n```erlang\n{node, node1, node1@host1}.\n{node, node2, node1@host2}.\n{node, node3, node2@host2}.\n{node, node4, node1@host3}.\n{init, node1, [{node_start, [{callback_module, my_slave_callback}]}]}.\n{init, [node2, node3], {node_start, [{username, \"ct_user\"}, {password, \"ct_password\"}]}}.\n{init, node4, {eval, {module, function, []}}}.\n```\n\nThis test specification declares that `node1@host1` is to be started using the\nuser callback function `callback_module:my_slave_callback/0`, and nodes\n`node1@host2` and `node2@host2` are to be started with the default callback\nmodule `ct_slave`. The specified username and password are used to log on to\nremote host `host2`. Also, function `module:function/0` is evaluated on\n`node1@host3`, and the result of this call is printed to the log.\n\nThe default callback module `m:ct_slave`, has the following features:\n\n- Starting Erlang target nodes on local or remote hosts (application `SSH` is\n  used for communication).\n- Ability to start an Erlang emulator with more flags (any flags supported by\n  `erl` are supported).\n- Supervision of a node being started using internal callback functions. Used to\n  prevent hanging nodes. (Configurable.)\n- Monitoring of the master node by the slaves. A slave node can be stopped if\n  the master node terminates. (Configurable.)\n- Execution of user functions after a slave node is started. Functions can be\n  specified as a list of `{Module, Function, Arguments}` tuples.\n\n> #### Note {: .info }\n>\n> An `eval` term for the node and `startup_functions` in the `node_start`\n> options list can be specified. In this case, the node is started first, then\n> the `startup_functions` are executed, and finally functions specified with\n> `eval` are called.","ref":"ct_master_chapter.html#automatic-startup-of-test-target-nodes"},{"type":"extras","title":"Event Handling","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Event Handling\n\n[](){: #event_handling }","ref":"event_handler_chapter.html"},{"type":"extras","title":"General - Event Handling","doc":"The operator of a `Common Test` system can receive event notifications\ncontinuously during a test run. For example, `Common Test` reports when a test\ncase starts and stops, the current count of successful, failed, and skipped\ncases, and so on. This information can be used for different purposes such as\nlogging progress and results in another format than HTML, saving statistics to a\ndatabase for report generation, and test system supervision.\n\n`Common Test` has a framework for event handling based on the OTP event manager\nconcept and `gen_event` behavior. When the `Common Test` server starts, it\nspawns an event manager. During test execution the manager gets a notification\nfrom the server when something of potential interest happens. Any event handler\nplugged into the event manager can match on events of interest, take action, or\npass the information on. The event handlers are Erlang modules implemented by\nthe `Common Test` user according to the `gen_event` behavior (for details, see\nmodule `m:gen_event` and section [`gen_event Behaviour`](`e:system:events.md`)\nin OTP Design Principles in the System Documentation).\n\nA `Common Test` server always starts an event manager. The server also plugs in\na default event handler, which only purpose is to relay notifications to a\nglobally registered `Common Test` Master event manager (if a `Common Test`\nMaster server is running in the system). The `Common Test` Master also spawns an\nevent manager at startup. Event handlers plugged into this manager receives the\nevents from all the test nodes, plus information from the `Common Test` Master\nserver.\n\nUser-specific event handlers can be plugged into a `Common Test` event manager,\neither by telling `Common Test` to install them before the test run (described\nlater), or by adding the handlers dynamically during the test run using\n`gen_event:add_handler/3` or `gen_event:add_sup_handler/3`. In the latter\nscenario, the reference of the `Common Test` event manager is required. To get\nit, call `ct:get_event_mgr_ref/0` or (on the `Common Test` Master node)\n`ct_master:get_event_mgr_ref/0`.\n\n[](){: #usage }","ref":"event_handler_chapter.html#general"},{"type":"extras","title":"Use - Event Handling","doc":"Event handlers can be installed by an `event_handler` start flag\n([`ct_run`](ct_run_cmd.md)) or option `ct:run_test/1`, where the argument\nspecifies the names of one or more event handler modules.\n\n_Example:_\n\n`$ ct_run -suite test/my_SUITE -event_handler handlers/my_evh1 handlers/my_evh2 -pa $PWD/handlers`\n\nTo pass start arguments to the event handler init function, use option\n`ct_run -event_handler_init` instead of `-event_handler`.\n\n> #### Note {: .info }\n>\n> All event handler modules must have `gen_event` behavior. These modules must\n> be precompiled and their locations must be added explicitly to the Erlang code\n> server search path (as in the previous example).\n\nAn event_handler tuple in argument `Opts` has the following definition (see\n`ct:run_test/1`):\n\n```erlang\n{event_handler,EventHandlers}\n\nEventHandlers = EH | [EH]\nEH = atom() | {atom(),InitArgs} | {[atom()],InitArgs}\nInitArgs = [term()]\n```\n\nIn the following example, two event handlers for the `my_SUITE` test are\ninstalled:\n\n```erlang\n1> ct:run_test([{suite,\"test/my_SUITE\"},{event_handler,[my_evh1,{my_evh2,[node()]}]}]).\n```\n\nEvent handler `my_evh1` is started with `[]` as argument to the init function.\nEvent handler `my_evh2` is started with the name of the current node in the init\nargument list.\n\nEvent handlers can also be plugged in using one of the following\n[test specification](run_test_chapter.md#test_specifications) terms:\n\n- `{event_handler, EventHandlers}`\n- `{event_handler, EventHandlers, InitArgs}`\n- `{event_handler, NodeRefs, EventHandlers}`\n- `{event_handler, NodeRefs, EventHandlers, InitArgs}`\n\n`EventHandlers` is a list of module names. Before a test session starts, the\ninit function of each plugged in event handler is called (with the `InitArgs`\nlist as argument or `[]` if no start arguments are specified).\n\nTo plug in a handler to the `Common Test` Master event manager, specify `master`\nas the node in `NodeRefs`.\n\nTo be able to match on events, the event handler module must include the header\nfile `ct_event.hrl`. An event is a record with the following definition:\n\n`#event{name, node, data}`\n\n- **`name`** - Label (type) of the event.\n\n- **`node`** - Name of the node that the event originated from (only relevant\n  for `Common Test` Master event handlers).\n\n- **`data`** - Specific for the event.\n\n[](){: #events }","ref":"event_handler_chapter.html#use"},{"type":"extras","title":"General Events - Event Handling","doc":"The general events are as follows:\n\n- **`#event{name = start_logging, data = LogDir}`** - `LogDir = string()`,\n  top-level log directory for the test run.\n\n  This event indicates that the logging process of `Common Test` has started\n  successfully and is ready to receive I/O messages.\n\n- **`#event{name = stop_logging, data = []}`** - This event indicates that the\n  logging process of `Common Test` was shut down at the end of the test run.\n\n- **`#event{name = test_start, data = {StartTime,LogDir}}`** -\n  `StartTime = {date(),time()}`, test run start date and time.\n\n  `LogDir = string()`, top-level log directory for the test run.\n\n  This event indicates that `Common Test` has finished initial preparations and\n  begins executing test cases.\n\n- **`#event{name = test_done, data = EndTime}`** - `EndTime = {date(),time()}`,\n  date and time the test run finished.\n\n  This event indicates that the last test case has been executed and\n  `Common Test` is shutting down.\n\n- **`#event{name = start_info, data = {Tests,Suites,Cases}}`** -\n  `Tests = integer()`, number of tests.\n\n  `Suites = integer()`, total number of suites.\n\n  `Cases = integer() | unknown`, total number of test cases.\n\n  This event gives initial test run information that can be interpreted as:\n  \"This test run will execute `Tests` separate tests, in total containing\n  `Cases` number of test cases, in `Suites` number of suites\". However, if a\n  test case group with a repeat property exists in any test, the total number of\n  test cases cannot be calculated (unknown).\n\n- **`#event{name = tc_start, data = {Suite,FuncOrGroup}}`** - `Suite = atom()`,\n  name of the test suite.\n\n  `FuncOrGroup = Func | {Conf,GroupName,GroupProperties}`\n\n  `Func = atom()`, name of test case or configuration function.\n\n  `Conf = init_per_group | end_per_group`, group configuration function.\n\n  `GroupName = atom()`, name of the group.\n\n  `GroupProperties = list()`, list of execution properties for the group.\n\n  This event informs about the start of a test case, or a group configuration\n  function. The event is sent also for `init_per_suite` and `end_per_suite`, but\n  not for `init_per_testcase` and `end_per_testcase`. If a group configuration\n  function starts, the group name and execution properties are also specified.\n\n- **`#event{name = tc_logfile, data = {{Suite,Func},LogFileName}}`** -\n  `Suite = atom()`, name of the test suite.\n\n  `Func = atom()`, name of test case or configuration function.\n\n  `LogFileName = string()`, full name of the test case log file.\n\n  This event is sent at the start of each test case (and configuration function\n  except `init/end_per_testcase`) and carries information about the full name\n  (that is, the file name including the absolute directory path) of the current\n  test case log file.\n\n- **`#event{name = tc_done, data = {Suite,FuncOrGroup,Result}}`** - [](){:\n  #tc_done } `Suite = atom()`, name of the suite.\n\n  `FuncOrGroup = Func | {Conf,GroupName,GroupProperties}`\n\n  `Func = atom()`, name of test case or configuration function.\n\n  `Conf = init_per_group | end_per_group`, group configuration function.\n\n  `GroupName = unknown | atom()`, name of the group (unknown if init- or end\n  function times out).\n\n  `GroupProperties = list()`, list of execution properties for the group.\n\n  `Result = ok | {auto_skipped,SkipReason} | {skipped,SkipReason} | {failed,FailReason}`,\n  the result.\n\n  [](){: #skipreason }\n  `SkipReason = {require_failed,RequireInfo} | {require_failed_in_suite0,RequireInfo} | {failed,{Suite,init_per_testcase,FailInfo}} | UserTerm`,\n  why the case was skipped.\n\n  [](){: #failreason }\n  `FailReason = {error,FailInfo} | {error,{RunTimeError,StackTrace}} | {timetrap_timeout,integer()} | {failed,{Suite,end_per_testcase,FailInfo}}`,\n  reason for failure.\n\n  `RequireInfo = {not_available,atom() | tuple()}`, why require failed.\n\n  `FailInfo = {timetrap_timeout,integer()} | {RunTimeError,StackTrace} | UserTerm`,\n  error details.\n\n  `RunTimeError = term()`, a runtime error, for example, `badmatch` or `undef`.\n\n  `StackTrace = list()`, list of function calls preceding a runtime error.\n\n  `UserTerm = term()`, any data specified by user, or [`exit/1`](`exit/1`)\n  information.\n\n  This event informs about the end of a test case or a configuration function\n  (see event `tc_start` for details on element `FuncOrGroup`). With this event\n  comes the final result of the function in question. It is possible to\n  determine on the top level of `Result` if the function was successful, skipped\n  (by the user), or if it failed.\n\n  It is also possible to dig deeper and, for example, perform pattern matching\n  on the various reasons for skipped or failed. Notice that `{'EXIT',Reason}`\n  tuples are translated into `{error,Reason}`. Notice also that if a\n  `{failed,{Suite,end_per_testcase,FailInfo}` result is received, the test case\n  was successful, but `end_per_testcase` for the case failed.\n\n- **`#event{name = tc_auto_skip, data = {Suite,TestName,Reason}}`** - [](){:\n  #tc_auto_skip } `Suite = atom()`, the name of the suite.\n\n  `TestName = init_per_suite | end_per_suite | {init_per_group,GroupName} | {end_per_group,GroupName} | {FuncName,GroupName} | FuncName`\n\n  `FuncName = atom()`, the name of the test case or configuration function.\n\n  `GroupName = atom()`, the name of the test case group.\n\n  `Reason = {failed,FailReason} | {require_failed_in_suite0,RequireInfo}`,\n  reason for auto-skipping `Func`.\n\n  `FailReason = {Suite,ConfigFunc,FailInfo}} | {Suite,FailedCaseInSequence}`,\n  reason for failure.\n\n  `RequireInfo = {not_available,atom() | tuple()}`, why require failed.\n\n  `ConfigFunc = init_per_suite | init_per_group`\n\n  `FailInfo = {timetrap_timeout,integer()} | {RunTimeError,StackTrace} | bad_return | UserTerm`,\n  error details.\n\n  `FailedCaseInSequence = atom()`, the name of a case that failed in a sequence.\n\n  `RunTimeError = term()`, a runtime error, for example `badmatch` or `undef`.\n\n  `StackTrace = list()`, list of function calls preceding a runtime error.\n\n  `UserTerm = term()`, any data specified by user, or [`exit/1`](`exit/1`)\n  information.\n\n  This event is sent for every test case or configuration function that\n  `Common Test` has skipped automatically because of either a failed\n  `init_per_suite` or `init_per_group`, a failed `require` in `suite/0`, or a\n  failed test case in a sequence. Notice that this event is never received as a\n  result of a test case getting skipped because of `init_per_testcase` failing,\n  as that information is carried with event `tc_done`. If a failed test case\n  belongs to a test case group, the second data element is a tuple\n  `{FuncName,GroupName}`, otherwise only the function name.\n\n- **`#event{name = tc_user_skip, data = {Suite,TestName,Comment}}`** - [](){:\n  #tc_user_skip } `Suite = atom()`, the name of the suite.\n\n  `TestName = init_per_suite | end_per_suite | {init_per_group,GroupName} | {end_per_group,GroupName} | {FuncName,GroupName} | FuncName`\n\n  `FuncName = atom()`, the name of the test case or configuration function.\n\n  `GroupName = atom()`, the name of the test case group.\n\n  `Comment = string()`, why the test case was skipped.\n\n  This event specifies that a test case was skipped by the user. It is only\n  received if the skip is declared in a test specification. Otherwise, user skip\n  information is received as a `{skipped,SkipReason}` result in event `tc_done`\n  for the test case. If a skipped test case belongs to a test case group, the\n  second data element is a tuple `{FuncName,GroupName}`, otherwise only the\n  function name.\n\n- **`#event{name = test_stats, data = {Ok,Failed,Skipped}}`** -\n  `Ok = integer()`, current number of successful test cases.\n\n  `Failed = integer()`, current number of failed test cases.\n\n  `Skipped = {UserSkipped,AutoSkipped}`\n\n  `UserSkipped = integer()`, current number of user-skipped test cases.\n\n  `AutoSkipped = integer()`, current number of auto-skipped test cases.\n\n  This is a statistics event with current count of successful, skipped, and\n  failed test cases so far. This event is sent after the end of each test case,\n  immediately following event `tc_done`.","ref":"event_handler_chapter.html#general-events"},{"type":"extras","title":"Internal Events - Event Handling","doc":"The internal events are as follows:\n\n- **`#event{name = start_make, data = Dir}`** - `Dir = string()`, running make\n  in this directory.\n\n  This internal event says that `Common Test` starts compiling modules in\n  directory `Dir`.\n\n- **`#event{name = finished_make, data = Dir}`** - `Dir = string()`, finished\n  running make in this directory.\n\n  This internal event says that `Common Test` is finished compiling modules in\n  directory `Dir`.\n\n- **`#event{name = start_write_file, data = FullNameFile}`** -\n  `FullNameFile = string(), full name of the file.`\n\n  This internal event is used by the `Common Test` Master process to synchronize\n  particular file operations.\n\n- **`#event{name = finished_write_file, data = FullNameFile}`** -\n  `FullNameFile = string(), full name of the file.`\n\n  This internal event is used by the `Common Test` Master process to synchronize\n  particular file operations.","ref":"event_handler_chapter.html#internal-events"},{"type":"extras","title":"Notes - Event Handling","doc":"The events are also documented in `ct_event.erl`. This module can serve as an\nexample of what an event handler for the `Common Test` event manager can look\nlike.\n\n> #### Note {: .info }\n>\n> To ensure that printouts to `stdout` (or printouts made with\n> [`ct:log/2,3`](`ct:log/2`) or [`ct:pal,2,3`](`ct:pal/2`)) get written to the\n> test case log file, and not to the `Common Test` framework log, you can\n> synchronize with the `Common Test` server by matching on events `tc_start` and\n> `tc_done`. In the period between these events, all I/O is directed to the test\n> case log file. These events are sent synchronously to avoid potential timing\n> problems (for example, that the test case log file is closed just before an\n> I/O message from an external process gets through). Knowing this, you need to\n> be careful that your `handle_event/2` callback function does not stall the\n> test execution, possibly causing unexpected behavior as a result.","ref":"event_handler_chapter.html#notes"},{"type":"extras","title":"Dependencies between Test Cases and Suites","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Dependencies between Test Cases and Suites","ref":"dependencies_chapter.html"},{"type":"extras","title":"General - Dependencies between Test Cases and Suites","doc":"When creating test suites, it is strongly recommended to not create dependencies\nbetween test cases, that is, letting test cases depend on the result of previous\ntest cases. There are various reasons for this, such as, the following:\n\n- It makes it impossible to run test cases individually.\n- It makes it impossible to run test cases in a different order.\n- It makes debugging difficult (as a fault can be the result of a problem in a\n  different test case than the one failing).\n- There are no good and explicit ways to declare dependencies, so it can be\n  difficult to see and understand these in test suite code and in test logs.\n- Extending, restructuring, and maintaining test suites with test case\n  dependencies is difficult.\n\nThere are often sufficient means to work around the need for test case\ndependencies. Generally, the problem is related to the state of the System Under\nTest (SUT). The action of one test case can change the system state. For some\nother test case to run properly, this new state must be known.\n\nInstead of passing data between test cases, it is recommended that the test\ncases read the state from the SUT and perform assertions (that is, let the test\ncase run if the state is as expected, otherwise reset or fail). It is also\nrecommended to use the state to set variables necessary for the test case to\nexecute properly. Common actions can often be implemented as library functions\nfor test cases to call to set the SUT in a required state. (Such common actions\ncan also be separately tested, if necessary, to ensure that they work as\nexpected). It is sometimes also possible, but not always desirable, to group\ntests together in one test case, that is, let a test case perform a \"scenario\"\ntest (a test consisting of subtests).\n\nConsider, for example, a server application under test. The following\nfunctionality is to be tested:\n\n- Starting the server\n- Configuring the server\n- Connecting a client to the server\n- Disconnecting a client from the server\n- Stopping the server\n\nThere are obvious dependencies between the listed functions. The server cannot\nbe configured if it has not first been started, a client cannot be connected\nuntil the server is properly configured, and so on. If we want to have one test\ncase for each function, we might be tempted to try to always run the test cases\nin the stated order and carry possible data (identities, handles, and so on)\nbetween the cases and therefore introduce dependencies between them.\n\nTo avoid this, we can consider starting and stopping the server for every test.\nWe can thus implement the start and stop action as common functions to be called\nfrom [`init_per_testcase`](`c:ct_suite:init_per_testcase/2`) and\n[`end_per_testcase`](`c:ct_suite:end_per_testcase/2`). (Remember to test the\nstart and stop functionality separately.) The configuration can also be\nimplemented as a common function, maybe grouped with the start function.\nFinally, the testing of connecting and disconnecting a client can be grouped\ninto one test case. The resulting suite can look as follows:\n\n```erlang\n-module(my_server_SUITE).\n-compile(export_all).\n-include_lib(\"ct.hrl\").\n\n%%% init and end functions...\n\nsuite() -> [{require,my_server_cfg}].\n\ninit_per_testcase(start_and_stop, Config) ->\n    Config;\n\ninit_per_testcase(config, Config) ->\n    [{server_pid,start_server()} | Config];\n\ninit_per_testcase(_, Config) ->\n    ServerPid = start_server(),\n    configure_server(),\n    [{server_pid,ServerPid} | Config].\n\nend_per_testcase(start_and_stop, _) ->\n    ok;\n\nend_per_testcase(_, Config) ->\n    ServerPid = proplists:get_value(server_pid, Config),\n    stop_server(ServerPid).\n\n%%% test cases...\n\nall() -> [start_and_stop, config, connect_and_disconnect].\n\n%% test that starting and stopping works\nstart_and_stop(_) ->\n    ServerPid = start_server(),\n    stop_server(ServerPid).\n\n%% configuration test\nconfig(Config) ->\n    ServerPid = proplists:get_value(server_pid, Config),\n    configure_server(ServerPid).\n\n%% test connecting and disconnecting client\nconnect_and_disconnect(Config) ->\n    ServerPid = proplists:get_value(server_pid, Config),\n    {ok,SessionId} = my_server:connect(ServerPid),\n    ok = my_server:disconnect(ServerPid, SessionId).\n\n%%% common functions...\n\nstart_server() ->\n    {ok,ServerPid} = my_server:start(),\n    ServerPid.\n\nstop_server(ServerPid) ->\n    ok = my_server:stop(),\n    ok.\n\nconfigure_server(ServerPid) ->\n    ServerCfgData = ct:get_config(my_server_cfg),\n    ok = my_server:configure(ServerPid, ServerCfgData),\n    ok.\n```\n\n[](){: #save_config }","ref":"dependencies_chapter.html#general"},{"type":"extras","title":"Saving Configuration Data - Dependencies between Test Cases and Suites","doc":"Sometimes it is impossible, or infeasible, to implement independent test cases.\nMaybe it is not possible to read the SUT state. Maybe resetting the SUT is\nimpossible and it takes too long time to restart the system. In situations where\ntest case dependency is necessary, CT offers a structured way to carry data from\none test case to the next. The same mechanism can also be used to carry data\nfrom one test suite to the next.\n\nThe mechanism for passing data is called `save_config`. The idea is that one\ntest case (or suite) can save the current value of `Config`, or any list of\nkey-value tuples, so that the next executing test case (or test suite) can read\nit. The configuration data is not saved permanently but can only be passed from\none case (or suite) to the next.\n\nTo save `Config` data, return tuple `{save_config,ConfigList}` from\n`end_per_testcase` or from the main test case function.\n\nTo read data saved by a previous test case, use `proplists:get_value` with a\n`saved_config` key as follows:\n\n`{Saver,ConfigList} = proplists:get_value(saved_config, Config)`\n\n`Saver` (`t:atom/0`) is the name of the previous test case (where the data was\nsaved). The `proplists:get_value` function can be used to extract particular\ndata also from the recalled `ConfigList`. It is strongly recommended that\n`Saver` is always matched to the expected name of the saving test case. This\nway, problems because of restructuring of the test suite can be avoided. Also,\nit makes the dependency more explicit and the test suite easier to read and\nmaintain.\n\nTo pass data from one test suite to another, the same mechanism is used. The\ndata is to be saved by finction [`end_per_suite`](`c:ct_suite:end_per_suite/1`)\nand read by function [`init_per_suite`](`c:ct_suite:init_per_suite/1`) in the\nsuite that follows. When passing data between suites, `Saver` carries the name\nof the test suite.\n\n_Example:_\n\n```erlang\n-module(server_b_SUITE).\n-compile(export_all).\n-include_lib(\"ct.hrl\").\n\n%%% init and end functions...\n\ninit_per_suite(Config) ->\n    %% read config saved by previous test suite\n    {server_a_SUITE,OldConfig} = proplists:get_value(saved_config, Config),\n    %% extract server identity (comes from server_a_SUITE)\n    ServerId = proplists:get_value(server_id, OldConfig),\n    SessionId = connect_to_server(ServerId),\n    [{ids,{ServerId,SessionId}} | Config].\n\nend_per_suite(Config) ->\n    %% save config for server_c_SUITE (session_id and server_id)\n    {save_config,Config}\n\n%%% test cases...\n\nall() -> [allocate, deallocate].\n\nallocate(Config) ->\n    {ServerId,SessionId} = proplists:get_value(ids, Config),\n    {ok,Handle} = allocate_resource(ServerId, SessionId),\n    %% save handle for deallocation test\n    NewConfig = [{handle,Handle}],\n    {save_config,NewConfig}.\n\ndeallocate(Config) ->\n    {ServerId,SessionId} = proplists:get_value(ids, Config),\n    {allocate,OldConfig} = proplists:get_value(saved_config, Config),\n    Handle = proplists:get_value(handle, OldConfig),\n    ok = deallocate_resource(ServerId, SessionId, Handle).\n```\n\nTo save `Config` data from a test case that is to be skipped, return tuple\n`{skip_and_save,Reason,ConfigList}`.\n\nThe result is that the test case is skipped with `Reason` printed to the log\nfile (as described earlier) and `ConfigList` is saved for the next test case.\n`ConfigList` can be read using `proplists:get_value(saved_config, Config)`, as\ndescribed earlier. `skip_and_save` can also be returned from `init_per_suite`.\nIn this case, the saved data can be read by `init_per_suite` in the suite that\nfollows.","ref":"dependencies_chapter.html#saving-configuration-data"},{"type":"extras","title":"Sequences - Dependencies between Test Cases and Suites","doc":"Sometimes test cases depend on each other so that if one case fails, the\nfollowing tests are not to be executed. Typically, if the `save_config` facility\nis used and a test case that is expected to save data crashes, the following\ncase cannot run. `Common Test` offers a way to declare such dependencies, called\nsequences.\n\nA sequence of test cases is defined as a test case group with a `sequence`\nproperty. Test case groups are defined through function `groups/0` in the test\nsuite (for details, see section\n[Test Case Groups](write_test_chapter.md#test_case_groups).\n\nFor example, to ensure that if `allocate` in `server_b_SUITE` crashes,\n`deallocate` is skipped, the following sequence can be defined:\n\n```erlang\ngroups() -> [{alloc_and_dealloc, [sequence], [alloc,dealloc]}].\n```\n\nAssume that the suite contains the test case `get_resource_status` that is\nindependent of the other two cases, then function `all` can look as follows:\n\n```erlang\nall() -> [{group,alloc_and_dealloc}, get_resource_status].\n```\n\nIf `alloc` succeeds, `dealloc` is also executed. If `alloc` fails however,\n`dealloc` is not executed but marked as `SKIPPED` in the HTML log.\n`get_resource_status` runs no matter what happens to the `alloc_and_dealloc`\ncases.\n\nTest cases in a sequence are executed in order until all succeed or one fails.\nIf one fails, all following cases in the sequence are skipped. The cases in the\nsequence that have succeeded up to that point are reported as successful in the\nlog. Any number of sequences can be specified.\n\n_Example:_\n\n```erlang\ngroups() -> [{scenarioA, [sequence], [testA1, testA2]},\n             {scenarioB, [sequence], [testB1, testB2, testB3]}].\n\nall() -> [test1,\n          test2,\n          {group,scenarioA},\n          test3,\n          {group,scenarioB},\n          test4].\n```\n\nA sequence group can have subgroups. Such subgroups can have any property, that\nis, they are not required to also be sequences. If you want the status of the\nsubgroup to affect the sequence on the level above, return\n`{return_group_result,Status}` from\n[`end_per_group/2`](`c:ct_suite:end_per_group/2`), as described in section\n[Repeated Groups](write_test_chapter.md#repeated_groups) in Writing Test Suites.\nA failed subgroup (`Status == failed`) causes the execution of a sequence to\nfail in the same way a test case does.","ref":"dependencies_chapter.html#sequences"},{"type":"extras","title":"Common Test Hooks","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Test Hooks","ref":"ct_hooks_chapter.html"},{"type":"extras","title":"General - Common Test Hooks","doc":"The _Common Test Hook (CTH)_ framework allows extensions of the default behavior\nof `Common Test` using hooks before and after all test suite calls. CTHs allow\nadvanced `Common Test` users to abstract out behavior that is common to multiple\ntest suites without littering all test suites with library calls. This can be\nused for logging, starting, and monitoring external systems, building C files\nneeded by the tests, and so on.\n\nIn brief, CTH allows you to do the following:\n\n- Manipulate the runtime configuration before each suite configuration call.\n- Manipulate the return of all suite configuration calls, and in extension, the\n  result of the tests themselves.\n\nThe following sections describe how to use CTHs, when they are run, and how to\nmanipulate the test results in a CTH.\n\n> #### Warning {: .warning }\n>\n> When executing within a CTH, all timetraps are shut off. So if your CTH never\n> returns, the entire test run is stalled.\n\n[](){: #installing }","ref":"ct_hooks_chapter.html#general"},{"type":"extras","title":"Installing a CTH - Common Test Hooks","doc":"A CTH can be installed in multiple ways in your test run. You can do it for all\ntests in a run, for specific test suites, and for specific groups within a test\nsuite. If you want a CTH to be present in all test suites within your test run,\nthere are three ways to accomplish that, as follows:\n\n- Add `-ct_hooks` as an argument to [ct_run](run_test_chapter.md#ct_run). To add\n  multiple CTHs using this method, append them to each other using the keyword\n  `and`, that is, `ct_run -ct_hooks cth1 [{debug,true}] and cth2 ...`.\n- Add tag `ct_hooks` to your\n  [Test Specification](run_test_chapter.md#test_specifications).\n- Add tag `ct_hooks` to your call to `ct:run_test/1`.\n\nCTHs can also be added within a test suite. This is done by returning\n`{ct_hooks,[CTH]}` in the configuration list from\n[suite/0](`c:ct_suite:suite/0`),\n[init_per_suite/1](`c:ct_suite:init_per_suite/1`), or\n[init_per_group/2](`c:ct_suite:init_per_group/2`).\n\nIn this case, `CTH` can either be only the module name of the CTH or a tuple\nwith the module name and the initial arguments, and optionally the hook priority\nof the CTH. For example, one of the following:\n\n- `{ct_hooks,[my_cth_module]}`\n- `{ct_hooks,[{my_cth_module,[{debug,true}]}]}`\n- `{ct_hooks,[{my_cth_module,[{debug,true}],500}]}`\n\nNote that regardless of how you install a CTH, its BEAM file must be available\nin the code path when Common Test runs. `ct_run` accepts the `-pa` command line\noption.","ref":"ct_hooks_chapter.html#installing-a-cth"},{"type":"extras","title":"Overriding CTHs - Common Test Hooks","doc":"By default, each installation of a CTH causes a new instance of it to be\nactivated. This can cause problems if you want to override CTHs in test\nspecifications while still having them in the suite information function. The\n[id/1](`c:ct_hooks:id/1`) callback exists to address this problem. By returning\nthe same `id` in both places, `Common Test` knows that this CTH is already\ninstalled and does not try to install it again.\n\n[](){: #cth_execution_order }","ref":"ct_hooks_chapter.html#overriding-cths"},{"type":"extras","title":"CTH Execution Order - Common Test Hooks","doc":"By default, each installed CTH is executed in the order in which they are\ninstalled for init calls, and then reversed for end calls. This order can be\nreferred to as test-centric, as the order is reversed after a testcase is\nexecuted and corresponds to the default value (`test`) of `ct_hooks_order`\noption.\n\nThe installation-based order is not always desired, so `Common Test` allows the\nuser to specify a priority for each hook. The priority can be specified in the\nCTH function [init/2](`c:ct_hooks:init/2`) or when installing the hook. The\npriority specified at installation overrides the priority returned by the CTH.\n\nIn some cases, the reversed order for all end calls is not desired, and instead,\nthe user might prefer the reversed order for post hook calls. Such behavior can\nbe enabled with `ct_hooks_order` option with `config` value. When this option is\nenabled, the execution order is configuration-centric, as the reversed order\nhappens after each configuration function and not in relation to testcase.\n\nNote that the `ct_hooks_order` option is considered as a global framework\nsetting. In case when option is configured multiple times framework with process\nonly the first value.\n\nThe `ct_hooks_order` option can be set as: `ct_run` argument, in test\nspecification or [suite/0](`c:ct_suite:suite/0`) return value.\n\n[](){: #scope }","ref":"ct_hooks_chapter.html#cth-execution-order"},{"type":"extras","title":"CTH Scope - Common Test Hooks","doc":"Once the CTH is installed into a certain test run it remains there until its\nscope is expired. The scope of a CTH depends on when it is installed, see the\nfollowing table. Function [init/2](`c:ct_hooks:init/2`) is called at the\nbeginning of the scope and function [terminate/1](`c:ct_hooks:terminate/1`) is\ncalled when the scope ends.\n\n| _CTH installed in_                                            | _CTH scope begins before_                                             | _CTH scope ends after_                                                                        |\n| ------------------------------------------------------------- | --------------------------------------------------------------------- | --------------------------------------------------------------------------------------------- |\n| [ct_run](run_test_chapter.md#ct_run)                          | the first test suite is to be run                                     | the last test suite has been run                                                              |\n| [ct:run_test](`ct:run_test/1`)                                | the first test suite is run                                           | the last test suite has been run                                                              |\n| [Test Specification](run_test_chapter.md#test_specifications) | the first test suite is run                                           | the last test suite has been run                                                              |\n| [suite/0](`c:ct_suite:suite/0`)                               | [pre_init_per_suite/3](`c:ct_hooks:pre_init_per_suite/3`) is called   | [post_end_per_suite/4](`c:ct_hooks:post_end_per_suite/4`) has been called for that test suite |\n| [init_per_suite/1](`c:ct_suite:init_per_suite/1`)             | [post_init_per_suite/4](`c:ct_hooks:post_init_per_suite/4`) is called | [post_end_per_suite/4](`c:ct_hooks:post_end_per_suite/4`) has been called for that test suite |\n| [init_per_group/2](`c:ct_suite:init_per_group/2`)             | [post_init_per_group/5](`c:ct_hooks:post_init_per_group/5`) is called | [post_end_per_group/5](`c:ct_hooks:post_end_per_group/5`) has been called for that group      |\n\n_Table: Scope of a CTH_","ref":"ct_hooks_chapter.html#cth-scope"},{"type":"extras","title":"CTH Processes and Tables - Common Test Hooks","doc":"CTHs are run with the same process scoping as normal test suites, that is, a\ndifferent process executes the `init_per_suite` hooks then the `init_per_group`\nor `per_testcase` hooks. So if you want to spawn a process in the CTH, you\ncannot link with the CTH process, as it exits after the post hook ends. Also, if\nyou for some reason need an ETS table with your CTH, you must spawn a process\nthat handles it.","ref":"ct_hooks_chapter.html#cth-processes-and-tables"},{"type":"extras","title":"External Configuration Data and Logging - Common Test Hooks","doc":"Configuration data values in the CTH can be read by calling\n[`ct:get_config/1,2,3`](`ct:get_config/1`) (as explained in section\n[Requiring and Reading Configuration Data](config_file_chapter.md#require_config_data)).\nThe configuration variables in question must, as always, first have been\nrequired by a suite-, group-, or test case information function, or by function\n[`ct:require/1/2`](`ct:require/1`). The latter can also be used in CT hook\nfunctions.\n\nThe CT hook functions can call any logging function in the `ct` interface to\nprint information to the log files, or to add comments in the suite overview\npage.\n\n[](){: #manipulating }","ref":"ct_hooks_chapter.html#external-configuration-data-and-logging"},{"type":"extras","title":"Manipulating Tests - Common Test Hooks","doc":"Through CTHs the results of tests and configuration functions can be\nmanipulated. The main purpose to do this with CTHs is to allow common patterns\nto be abstracted out from test suites and applied to multiple test suites\nwithout duplicating any code. All the callback functions for a CTH follow a\ncommon interface described hereafter.\n\n`Common Test` always calls all available hook functions, even pre- and post\nhooks for configuration functions that are not implemented in the suite. For\nexample, `pre_init_per_suite(x_SUITE, ...)` and\n`post_init_per_suite(x_SUITE, ...)` are called for test suite `x_SUITE`, even if\nit does not export `init_per_suite/1`. With this feature hooks can be used as\nconfiguration fallbacks, and all configuration functions can be replaced with\nhook functions.\n\n[](){: #pre }","ref":"ct_hooks_chapter.html#manipulating-tests"},{"type":"extras","title":"Pre Hooks - Common Test Hooks","doc":"In a CTH, the behavior can be hooked in before the following functions:\n\n- [`init_per_suite`](`c:ct_suite:init_per_suite/1`)\n- [`init_per_group`](`c:ct_suite:init_per_group/2`)\n- [`init_per_testcase`](`c:ct_suite:init_per_testcase/2`)\n- [`end_per_testcase`](`c:ct_suite:end_per_testcase/2`)\n- [`end_per_group`](`c:ct_suite:end_per_group/2`)\n- [`end_per_suite`](`c:ct_suite:end_per_suite/1`)\n\nThis is done in the CTH functions called `pre_ `. These\nfunctions take the arguments `SuiteName`, `Name` (group or test case name, if\napplicable), `Config`, and `CTHState`. The return value of the CTH function is\nalways a combination of a result for the suite/group/test and an updated\n`CTHState`.\n\nTo let the test suite continue on executing, return the configuration list that\nyou want the test to use as the result.\n\nAll pre hooks, except `pre_end_per_testcase/4`, can skip or fail the test by\nreturning a tuple with `skip` or `fail`, and a reason as the result.\n\n_Example:_\n\n```erlang\npre_init_per_suite(SuiteName, Config, CTHState) ->\n  case db:connect() of\n    {error,_Reason} ->\n      {{fail, \"Could not connect to DB\"}, CTHState};\n    {ok, Handle} ->\n      {[{db_handle, Handle} | Config], CTHState#state{ handle = Handle }}\n  end.\n```\n\n> #### Note {: .info }\n>\n> If you use multiple CTHs, the first part of the return tuple is used as input\n> for the next CTH. So in the previous example the next CTH can get\n> `{fail,Reason}` as the second parameter. If you have many CTHs interacting, do\n> not let each CTH return `fail` or `skip`. Instead, return that an action is to\n> be taken through the `Config` list and implement a CTH that, at the end, takes\n> the correct action.\n\n[](){: #post }","ref":"ct_hooks_chapter.html#pre-hooks"},{"type":"extras","title":"Post Hooks - Common Test Hooks","doc":"In a CTH, behavior can be hooked in after the following functions:\n\n- [`init_per_suite`](`c:ct_suite:init_per_suite/1`)\n- [`init_per_group`](`c:ct_suite:init_per_group/2`)\n- [`init_per_testcase`](`c:ct_suite:init_per_testcase/2`)\n- [`end_per_testcase`](`c:ct_suite:end_per_testcase/2`)\n- [`end_per_group`](`c:ct_suite:end_per_group/2`)\n- [`end_per_suite`](`c:ct_suite:end_per_suite/1`)\n\nThis is done in the CTH functions called `post_ `. These\nfunctions take the arguments `SuiteName`, `Name` (group or test case name, if\napplicable), `Config`, `Return`, and `CTHState`. `Config` in this case is the\nsame `Config` as the testcase is called with. `Return` is the value returned by\nthe testcase. If the testcase fails by crashing, `Return` is\n`{'EXIT',{{Error,Reason},Stacktrace}}`.\n\nThe return value of the CTH function is always a combination of a result for the\nsuite/group/test and an updated `CTHState`. If you do not want the callback to\naffect the outcome of the test, return the `Return` data as it is given to the\nCTH. You can also modify the test result. By returning the `Config` list with\nelement `tc_status` removed, you can recover from a test failure. As in all the\npre hooks, it is also possible to fail/skip the test case in the post hook.\n\n_Example:_\n\n```erlang\npost_end_per_testcase(_Suite, _TC, Config, {'EXIT',{_,_}}, CTHState) ->\n  case db:check_consistency() of\n    true ->\n      %% DB is good, pass the test.\n      {proplists:delete(tc_status, Config), CTHState};\n    false ->\n      %% DB is not good, mark as skipped instead of failing\n      {{skip, \"DB is inconsistent!\"}, CTHState}\n  end;\npost_end_per_testcase(_Suite, _TC, Config, Return, CTHState) ->\n  %% Do nothing if tc does not crash.\n  {Return, CTHState}.\n```\n\n> #### Note {: .info }\n>\n> Do recover from a testcase failure using CTHs only a last resort. If used\n> wrongly, it can be very difficult to determine which tests that pass or fail\n> in a test run.","ref":"ct_hooks_chapter.html#post-hooks"},{"type":"extras","title":"Skip and Fail Hooks - Common Test Hooks","doc":"After any post hook has been executed for all installed CTHs,\n[on_tc_fail](`c:ct_hooks:on_tc_fail/4`) or\n[on_tc_skip](`c:ct_hooks:on_tc_skip/4`) is called if the testcase failed or was\nskipped, respectively. You cannot affect the outcome of the tests any further at\nthis point.\n\n[](){: #synchronizing }","ref":"ct_hooks_chapter.html#skip-and-fail-hooks"},{"type":"extras","title":"Synchronizing External User Applications with Common Test - Common Test Hooks","doc":"CTHs can be used to synchronize test runs with external user applications. The\ninit function can, for example, start and/or communicate with an application\nthat has the purpose of preparing the SUT for an upcoming test run, or\ninitialize a database for saving test data to during the test run. The terminate\nfunction can similarly order such an application to reset the SUT after the test\nrun, and/or tell the application to finish active sessions and terminate. Any\nsystem error- or progress reports generated during the init- or termination\nstage are saved in the\n[Pre- and Post Test I/O Log](run_test_chapter.md#pre_post_test_io_log). (This is\nalso true for any printouts made with `ct:log/2` and `ct:pal/2`).\n\nTo ensure that `Common Test` does not start executing tests, or closes its log\nfiles and shuts down, before the external application is ready for it,\n`Common Test` can be synchronized with the application. During startup and\nshutdown, `Common Test` can be suspended, simply by having a CTH evaluate a\n`receive` expression in the init- or terminate function. The macros\n`?CT_HOOK_INIT_PROCESS` (the process executing the hook init function) and\n`?CT_HOOK_TERMINATE_PROCESS` (the process executing the hook terminate function)\neach specifies the name of the correct `Common Test` process to send a message\nto. This is done to return from the `receive`. These macros are defined in\n`ct.hrl`.\n\n[](){: #example }","ref":"ct_hooks_chapter.html#synchronizing-external-user-applications-with-common-test"},{"type":"extras","title":"Example CTH - Common Test Hooks","doc":"The following CTH logs information about a test run into a format parseable by\n`file:consult/1` (in Kernel):\n\n```erlang\n%%% Common Test Example Common Test Hook module.\n%%%\n%%% To use this hook, on the command line:\n%%%     ct_run -suite example_SUITE -pa . -ct_hooks example_cth\n%%%\n%%% Note `-pa .`: the hook beam file must be in the code path when installing.\n-module(example_cth).\n\n%% Mandatory Callbacks\n-export([init/2]).\n\n%% Optional Callbacks\n-export([id/1]).\n\n-export([pre_init_per_suite/3]).\n-export([post_end_per_suite/4]).\n\n-export([pre_init_per_testcase/4]).\n-export([post_end_per_testcase/5]).\n\n-export([on_tc_skip/4]).\n\n-export([terminate/1]).\n\n%% This hook state is threaded through all the callbacks.\n-record(state, {filename, total, suite_total, ts, tcs, data, skipped}).\n%% This example hook prints its results to a file, see terminate/1.\n-record(test_run, {total, skipped, suites}).\n\n%% Return a unique id for this CTH.\n%% Using the filename means the hook can be used with different\n%% log files to separate timing data within the same test run.\n%% See Installing a CTH for more information.\nid(Opts) ->\n    %% the path is relative to the test run directory\n    proplists:get_value(filename, Opts, \"example_cth.log\").\n\n%% Always called before any other callback function. Use this to initiate\n%% any common state.\ninit(Id, _Opts) ->\n    {ok, #state{filename = Id, total = 0, data = []}}.\n\n%% Called before init_per_suite is called.\npre_init_per_suite(_Suite,Config,State) ->\n    {Config, State#state{suite_total = 0, tcs = []}}.\n\n%% Called after end_per_suite.\npost_end_per_suite(Suite,_Config,Return,State) ->\n    Data = {suites, Suite, State#state.suite_total,\n            lists:reverse(State#state.tcs)},\n    {Return, State#state{data = [Data | State#state.data],\n                         total = State#state.total + State#state.suite_total}}.\n\n%% Called before each init_per_testcase.\npre_init_per_testcase(_Suite,_TC,Config,State) ->\n    Now = erlang:monotonic_time(microsecond),\n    {Config, State#state{ts = Now, suite_total = State#state.suite_total + 1}}.\n\n%% Called after each end_per_testcase.\npost_end_per_testcase(Suite,TC,_Config,Return,State) ->\n    Now = erlang:monotonic_time(microsecond),\n    TCInfo = {testcase, Suite, TC, Return, Now - State#state.ts},\n    {Return, State#state{ts = undefined, tcs = [TCInfo | State#state.tcs]}}.\n\n%% Called when a test case is skipped by either user action\n%% or due to an init function failing.\non_tc_skip(_Suite, _TC, _Reason, State) ->\n    State#state{skipped = State#state.skipped + 1}.\n\n%% Called when the scope of the CTH is done.\nterminate(State) ->\n    %% use append to avoid data loss if the path is reused\n    {ok, File} = file:open(State#state.filename, [write, append]),\n    io:format(File, \"~p.~n\", [results(State)]),\n    file:close(File),\n    ok.\n\nresults(State) ->\n    #state{skipped = Skipped, data = Data, total = Total} = State,\n    #test_run{total = Total, skipped = Skipped, suites = lists:reverse(Data)}.\n```\n\n[](){: #builtin_cths }","ref":"ct_hooks_chapter.html#example-cth"},{"type":"extras","title":"Built-In CTHs - Common Test Hooks","doc":"`Common Test` is delivered with some general-purpose CTHs that can be enabled by\nthe user to provide generic testing functionality. Some of these CTHs are\nenabled by default when `common_test` is started to run. They can be disabled by\nsetting `enable_builtin_hooks` to `false` on the command line or in the test\nspecification. The following two CTHs are delivered with `Common Test`:\n\n- **`cth_log_redirect`** - Built-in\n\n  Captures all log events that would normally be printed by the default logger\n  handler, and prints them to the current test case log. If an event cannot be\n  associated with a test case, it is printed in the `Common Test` framework log.\n  This happens for test cases running in parallel and events occurring\n  in-between test cases.\n\n  The log events are handled using a [Logger](`m:logger`) handler called\n  cth_log_redirect. The formatting and level is copied from the current\n  `default` handler when the cth is started. If you want to use another level\n  either change the `default` handler level before starting common_test, or use\n  the `logger:set_handler_config/3` API.\n\n  This hook supports the following options:\n\n  - **`{mode, add}`** - Add `cth_log_redirect` to the default logging handler:\n    Logs will be emitted to both standard output via the default handler, and\n    into the Common Test HTML logs. This is the default behaviour.\n\n  - **`{mode, replace}`** - Replace the `default` logging handler with\n    `cth_log_redirect` instead of logging to both the default handler and this\n    handler. This effectively silences any logger output which would normally be\n    printed to standard output during test runs. To enable this mode, you can\n    pass the following options to `ct_run`:\n\n    `-enable_builtin_hooks false -ct_hooks cth_log_redirect [{mode,replace}]`\n\n- **`cth_surefire`** - Not built-in\n\n  Captures all test results and outputs them as surefire XML into a file. The\n  created file is by default called `junit_report.xml`. The file name can be\n  changed by setting option `path` for this hook, for example:\n\n  `-ct_hooks cth_surefire [{path,\"/tmp/report.xml\"}]`\n\n  If option `url_base` is set, an extra attribute named `url` is added to each\n  `testsuite` and `testcase` XML element. The value is constructed from\n  `url_base` and a relative path to the test suite or test case log,\n  respectively, for example:\n\n  `-ct_hooks cth_surefire [{url_base, \"http://myserver.com/\"}]`\n\n  gives an URL attribute value similar to\n\n  `\"http://myserver.com/ct_run.ct@myhost.2012-12-12_11.19.39/ x86_64-unknown-linux-gnu.my_test.logs/run.2012-12-12_11.19.39/suite.log.html\"`\n\n  Surefire XML can, for example, be used by Jenkins to display test results.","ref":"ct_hooks_chapter.html#built-in-cths"},{"type":"extras","title":"Some Thoughts about Testing","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Some Thoughts about Testing","ref":"why_test_chapter.html"},{"type":"extras","title":"Goals - Some Thoughts about Testing","doc":"It is not possible to prove that a program is correct by testing. On the\ncontrary, it has been formally proven that it is impossible to prove programs in\ngeneral by testing. Theoretical program proofs or plain examination of code can\nbe viable options for those wishing to certify that a program is correct. The\ntest server, as it is based on testing, cannot be used for certification. Its\nintended use is instead to (cost effectively) _find bugs_. A successful test\nsuite is one that reveals a bug. If a test suite results in OK, then we know\nvery little that we did not know before.","ref":"why_test_chapter.html#goals"},{"type":"extras","title":"What to Test - Some Thoughts about Testing","doc":"There are many kinds of test suites. Some concentrate on calling every function\nor command (in the documented way) in a certain interface. Some others do the\nsame, but use all kinds of illegal parameters, and verify that the server stays\nalive and rejects the requests with reasonable error codes. Some test suites\nsimulate an application (typically consisting of a few modules of an\napplication), some try to do tricky requests in general, and some test suites\neven test internal functions with help of special Load Modules on target.\n\nAnother interesting category of test suites is the one checking that fixed bugs\ndo not reoccur. When a bugfix is introduced, a test case that checks for that\nspecific bug is written and submitted to the affected test suites.\n\nAim for finding bugs. Write whatever test that has the highest probability of\nfinding a bug, now or in the future. Concentrate more on the critical parts.\nBugs in critical subsystems are much more expensive than others.\n\nAim for functionality testing rather than implementation details. Implementation\ndetails change quite often, and the test suites are to be long lived.\nImplementation details often differ on different platforms and versions. If\nimplementation details must be tested, try to factor them out into separate test\ncases. These test cases can later be rewritten or skipped.\n\nAlso, aim for testing everything once, no less, no more. It is not effective\nhaving every test case fail only because one function in the interface changed.","ref":"why_test_chapter.html#what-to-test"},{"type":"extras","title":"Common Test's Property Testing Support: ct_property_test","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Test's Property Testing Support: ct_property_test","ref":"ct_property_test_chapter.html"},{"type":"extras","title":"General - Common Test's Property Testing Support: ct_property_test","doc":"The _Common Test Property Testing Support (ct_property_test)_ is an aid to run\nproperty based testing tools in Common Test test suites.\n\nBasic knowledge of property based testing is assumed in the following. It is\nalso assumed that at least one of the following property based testing tools is\ninstalled and available in the library path:\n\n- [QuickCheck](http://www.quviq.com),\n- [PropEr](https://proper-testing.github.io) or\n- [Triq](https://github.com/krestenkrab/triq)\n\n[](){: #supported }","ref":"ct_property_test_chapter.html#general"},{"type":"extras","title":"What Is Supported? - Common Test's Property Testing Support: ct_property_test","doc":"The [ct_property_test](`m:ct_property_test#`) module does the following:\n\n- Compiles the files with property tests in the subdirectory `property_test`\n- Tests properties in those files using the first found Property Testing Tool.\n- Saves the results - that is the printouts - in the usual Common Test Log","ref":"ct_property_test_chapter.html#what-is-supported"},{"type":"extras","title":"Introductory Example - Common Test's Property Testing Support: ct_property_test","doc":"Assume that we want to test the lists:sort/1 function.\n\nWe need a property to test the function. In normal way, we create\n`property_test/ct_prop.erl` module in the `test` directory in our application:\n\n```erlang\n-module(ct_prop).\n-export([prop_sort/0]).\n\n%%% This will include the .hrl file for the installed testing tool:\n-include_lib(\"common_test/include/ct_property_test.hrl\").\n\n%%% The property we want to check:\n%%%   For all possibly unsorted lists,\n%%%   the result of lists:sort/1 is sorted.\nprop_sort() ->\n    ?FORALL(UnSorted, list(),\n            is_sorted(lists:sort(UnSorted))\n           ).\n\n%%% Function to check that a list is sorted:\nis_sorted([]) ->\n    true;\nis_sorted([_]) ->\n    true;\nis_sorted([H1,H2|SortedTail]) when H1 = \n    is_sorted([H2|SortedTail]);\nis_sorted(_) ->\n    false.\n```\n\nWe also need a CommonTest test suite:\n\n```erlang\n-module(ct_property_test_SUITE).\n-compile(export_all). % Only in tests!\n\n-include_lib(\"common_test/include/ct.hrl\").\n\nall() -> [prop_sort\n         ].\n\n%%% First prepare Config and compile the property tests for the found tool:\ninit_per_suite(Config) ->\n    ct_property_test:init_per_suite(Config).\n\nend_per_suite(Config) ->\n    Config.\n\n%%%================================================================\n%%% Test suites\n%%%\nprop_sort(Config) ->\n    ct_property_test:quickcheck(\n      ct_prop:prop_sort(),\n      Config\n     ).\n```\n\nWe run it as usual, for example with ct_run in the OS shell:\n\n```text\n..../test$ ct_run -suite ct_property_test_SUITE\n.....\nCommon Test: Running make in test directories...\n\nTEST INFO: 1 test(s), 1 case(s) in 1 suite(s)\n\nTesting lib.common_test.ct_property_test_SUITE: Starting test, 1 test cases\n\n----------------------------------------------------\n2019-12-18 10:44:46.293\nFound property tester proper\nat \"/home/X/lib/proper/ebin/proper.beam\"\n\n\n----------------------------------------------------\n2019-12-18 10:44:46.294\nCompiling in \"/home/..../test/property_test\"\n  Deleted:   [\"ct_prop.beam\"]\n  ErlFiles:  [\"ct_prop.erl\"]\n  MacroDefs: [{d,'PROPER'}]\n\nTesting lib.common_test.ct_property_test_SUITE: TEST COMPLETE, 1 ok, 0 failed of 1 test cases\n\n....\n```\n\n[](){: #stateful1 }","ref":"ct_property_test_chapter.html#introductory-example"},{"type":"extras","title":"A stateful testing example - Common Test's Property Testing Support: ct_property_test","doc":"Assume a test that generates some parallel stateful commands, and runs 300\ntests:\n\n```erlang\nprop_parallel(Config) ->\n    numtests(300,\n             ?FORALL(Cmds, parallel_commands(?MODULE),\n                     begin\n                         RunResult = run_parallel_commands(?MODULE, Cmds),\n                         ct_property_test:present_result(?MODULE, Cmds, RunResult, Config)\n                     end)).\n```\n\nThe `ct_property_test:present_result/4` is a help function for printing some\nstatistics in the CommonTest log file.\n\nOur example test could for example be a simple test of an ftp server, where we\nperform get, put and delete requests, some of them in parallel. Per default, the\nresult has three sections:\n\n```text\n*** User 2019-12-11 13:28:17.504 ***\n\nDistribution sequential/parallel\n\n 57.7% sequential\n 28.0% parallel_2\n 14.3% parallel_1\n\n\n\n*** User 2019-12-11 13:28:17.505 ***\n\nFunction calls\n\n 44.4% get\n 39.3% put\n 16.3% delete\n\n\n\n*** User 2019-12-11 13:28:17.505 ***\n\nLength of command sequences\n\nRange  : Number in range\n-------:----------------\n 0 -  4:    8    2.7%  <-- min=3\n 5 -  9:   44   14.7%\n10 - 14:   74   24.7%\n15 - 19:   60   20.0%  <-- mean=18.7 <-- median=16.0\n20 - 24:   38   12.7%\n25 - 29:   26    8.7%\n30 - 34:   19    6.3%\n35 - 39:   19    6.3%\n40 - 44:    8    2.7%\n45 - 49:    4    1.3%  <-- max=47\n        ------\n          300\n```\n\nThe first part - _Distribution sequential/parallel_ \\- shows the distribution in\nthe sequential and parallel part of the result of parallel_commands/1. See any\nproperty testing tool for an explanation of this function. The table shows that\nof all commands (get and put in our case), 57.7% are executed in the sequential\npart prior to the parallel part, 28.0% are executed in the first parallel list\nand the rest in the second parallel list.\n\nThe second part - _Function calls_ \\- shows the distribution of the three calls\nin the generated command lists. We see that all of the three calls are executed.\nIf it was so that we thought that we also generated a fourth call, a table like\nthis shows that we failed with that.\n\nThe third and final part - _Length of command sequences_ \\- show statistics of\nthe generated command sequences. We see that the shortest list has three\nelementes while the longest has 47 elements. The mean and median values are also\nshown. Further we could for example see that only 2.7% of the lists (that is\neight lists) only has three or four elements.","ref":"ct_property_test_chapter.html#a-stateful-testing-example"},{"type":"extras","title":"ct_run","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ct_run\n\nProgram used for starting Common Test from the OS command line.","ref":"ct_run_cmd.html"},{"type":"extras","title":"Description - ct_run","doc":"The `ct_run` program is automatically installed with Erlang/OTP and the\n`Common Test` application (for more information, see section\n[Installation](install_chapter.md) in the User's Guide). The program accepts\ndifferent start flags. Some flags trigger `ct_run` to start `Common Test` and\npass on data to it. Some flags start an Erlang node prepared for running\n`Common Test` in a particular mode.\n\nThe interface function `ct:run_test/1`, corresponding to the `ct_run` program,\nis used for starting `Common Test` from the Erlang shell (or an Erlang program).\nFor details, see the `m:ct` manual page.\n\n`ct_run` also accepts Erlang emulator flags. These are used when `ct_run` calls\n`erl` to start the Erlang node (this makes it possible to add directories to the\ncode server path, change the cookie on the node, start more applications, and so\non).\n\nWith the optional flag `-erl_args`, options on the `ct_run` command line can be\ndivided into two groups:\n\n- One group that `Common Test` is to process (those preceding `-erl_args`).\n- One group that `Common Test` is to ignore and pass on directly to the emulator\n  (those following `-erl_args`).\n\nOptions preceding `-erl_args` that `Common Test` does not recognize are also\npassed on to the emulator untouched. By `-erl_args` the user can specify flags\nwith the same name, but with different destinations, on the `ct_run` command\nline.\n\nIf flags `-pa` or `-pz` are specified in the `Common Test` group of options\n(preceding `-erl_args`), relative directories are converted to absolute and\nreinserted into the code path by `Common Test`. This is to avoid problems\nloading user modules when `Common Test` changes working directory during test\nruns. However, `Common Test` ignores flags `-pa` and `-pz` following `-erl_args`\non the command line. These directories are added to the code path normally (that\nis, on specified form).\n\nExit status is set before the program ends. Value `0` indicates a successful\ntest result, `1` indicates one or more failed or auto-skipped test cases, and\n`2` indicates test execution failure.\n\nIf `ct_run` is called with option `-help`, it prints all valid start flags to\n`stdout`.\n\n[](){: #ct_run }","ref":"ct_run_cmd.html#description"},{"type":"extras","title":"Run Tests from Command Line - ct_run","doc":"```text\n ct_run -dir TestDir1 TestDir2 .. TestDirN |\n  [-dir TestDir] -suite Suite1 Suite2 .. SuiteN\n  [-group Groups1 Groups2 .. GroupsN] [-case Case1 Case2 .. CaseN]\n  [-step [config | keep_inactive]]\n  [-config ConfigFile1 ConfigFile2 .. ConfigFileN]\n  [-userconfig CallbackModule1 ConfigString1 and CallbackModule2\n   ConfigString2 and .. CallbackModuleN ConfigStringN]\n  [-decrypt_key Key] | [-decrypt_file KeyFile]\n  [-label Label]\n  [-logdir LogDir]\n  [-logopts LogOpts]\n  [-verbosity GenVLevel | [Category1 VLevel1 and\n   Category2 VLevel2 and .. CategoryN VLevelN]]\n  [-silent_connections [ConnType1 ConnType2 .. ConnTypeN]]\n  [-stylesheet CSSFile]\n  [-cover CoverCfgFile]\n  [-cover_stop Bool]\n  [-event_handler EvHandler1 EvHandler2 .. EvHandlerN] |\n  [-event_handler_init EvHandler1 InitArg1 and\n   EvHandler2 InitArg2 and .. EvHandlerN InitArgN]\n  [-include InclDir1 InclDir2 .. InclDirN]\n  [-no_auto_compile]\n  [-abort_if_missing_suites]\n  [-multiply_timetraps Multiplier]\n  [-scale_timetraps]\n  [-create_priv_dir auto_per_run | auto_per_tc | manual_per_tc]\n  [-repeat N] |\n  [-duration HHMMSS [-force_stop [skip_rest]]] |\n  [-until [YYMoMoDD]HHMMSS [-force_stop [skip_rest]]]\n  [-basic_html]\n  [-no_esc_chars]\n  [-keep_logs all | NLogs]\n  [-ct_hooks CTHModule1 CTHOpts1 and CTHModule2 CTHOpts2 and ..\n   CTHModuleN CTHOptsN]\n  [-ct_hooks_order test | config]\n  [-exit_status ignore_config]\n  [-help]\n```","ref":"ct_run_cmd.html#run-tests-from-command-line"},{"type":"extras","title":"Run Tests using Test Specification - ct_run","doc":"```text\n ct_run -spec TestSpec1 TestSpec2 .. TestSpecN\n  [-join_specs]\n  [-config ConfigFile1 ConfigFile2 .. ConfigFileN]\n  [-userconfig CallbackModule1 ConfigString1 and CallbackModule2\n   ConfigString2 and .. and CallbackModuleN ConfigStringN]\n  [-decrypt_key Key] | [-decrypt_file KeyFile]\n  [-label Label]\n  [-logdir LogDir]\n  [-logopts LogOpts]\n  [-verbosity GenVLevel | [Category1 VLevel1 and\n   Category2 VLevel2 and .. CategoryN VLevelN]]\n  [-allow_user_terms]\n  [-silent_connections [ConnType1 ConnType2 .. ConnTypeN]]\n  [-stylesheet CSSFile]\n  [-cover CoverCfgFile]\n  [-cover_stop Bool]\n  [-event_handler EvHandler1 EvHandler2 .. EvHandlerN] |\n  [-event_handler_init EvHandler1 InitArg1 and\n   EvHandler2 InitArg2 and .. EvHandlerN InitArgN]\n  [-include InclDir1 InclDir2 .. InclDirN]\n  [-no_auto_compile]\n  [-abort_if_missing_suites]\n  [-multiply_timetraps Multiplier]\n  [-scale_timetraps]\n  [-create_priv_dir auto_per_run | auto_per_tc | manual_per_tc]\n  [-repeat N] |\n  [-duration HHMMSS [-force_stop [skip_rest]]] |\n  [-until [YYMoMoDD]HHMMSS [-force_stop [skip_rest]]]\n  [-basic_html]\n  [-no_esc_chars]\n  [-keep_logs all | NLogs]\n  [-ct_hooks CTHModule1 CTHOpts1 and CTHModule2 CTHOpts2 and ..\n   CTHModuleN CTHOptsN]\n  [-ct_hooks_order test | config]\n  [-exit_status ignore_config]\n```","ref":"ct_run_cmd.html#run-tests-using-test-specification"},{"type":"extras","title":"Refresh HTML Index Files - ct_run","doc":"```text\n ct_run -refresh_logs [-logdir LogDir] [-basic_html]\n  [-keep_logs all | NLogs]\n```","ref":"ct_run_cmd.html#refresh-html-index-files"},{"type":"extras","title":"Run Common Test in Interactive Mode - ct_run","doc":"```erlang\n ct_run -shell\n  [-config ConfigFile1 ConfigFile2 ... ConfigFileN]\n  [-userconfig CallbackModule1 ConfigString1 and CallbackModule2\n   ConfigString2 and .. and CallbackModuleN ConfigStringN]\n  [-decrypt_key Key] | [-decrypt_file KeyFile]\n```","ref":"ct_run_cmd.html#run-common-test-in-interactive-mode"},{"type":"extras","title":"Start a Common Test Master Node - ct_run","doc":"```text\n ct_run -ctmaster\n```","ref":"ct_run_cmd.html#start-a-common-test-master-node"},{"type":"extras","title":"See Also - ct_run","doc":"For information about the start flags, see section\n[Running Tests and Analyzing Results](run_test_chapter.md) in the User's Guide.","ref":"ct_run_cmd.html#see-also"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}