;;; clean/elc.el --- Remove byte compiled files generated by eask compile  -*- lexical-binding: t; -*-

;;; Commentary:
;;
;; Remove byte compiled files generated by eask compile
;;
;;   $ eask clean elc
;;

;;; Code:

(let ((dir (file-name-directory (nth 1 (member "-scriptload" command-line-args)))))
  (load (expand-file-name "_prepare.el"
                          (locate-dominating-file dir "_prepare.el"))
        nil t))

(eask-start
  (if-let ((files (eask-package-elc-files)))
      (progn
        (mapc #'eask-delete-file files)
        (eask-msg "")
        (eask-info "(Total of %s .elc file%s deleted)" (length files)
                   (eask--sinr files "" "s")))
    (eask-info "(No .elc file found in workspace)")
    (setq eask-no-cleaning-operation-p t)))

;;; clean/elc.el ends here
