/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.B64Lazy;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.Blake3;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class FnHash
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        String algorithm = this.toStringOrNull(this.arg(1), qc);
        return value.isEmpty() ? Empty.VALUE : new Hex(this.hash(value, algorithm, qc));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] hash(Item value, String algorithm, QueryContext qc) throws QueryException {
        MessageDigest md;
        if ("CRC-32".equals(algorithm)) {
            CRC32 crc = new CRC32();
            crc.update(this.toBytes(value));
            byte[] result = new byte[4];
            int i = result.length;
            int c = (int)crc.getValue();
            while (i-- > 0) {
                result[i] = (byte)c;
                c >>>= 8;
            }
            return result;
        }
        if ("BLAKE3".equals(algorithm)) {
            return new Blake3().digest(this.toBytes(value));
        }
        try {
            md = MessageDigest.getInstance(algorithm != null ? algorithm : "MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            Util.debug(ex);
            throw QueryError.HASH_ALGORITHM_X.get(this.info, algorithm);
        }
        if (!(value instanceof B64Lazy)) return md.digest(this.toBytes(value));
        try (BufferInput bi = value.input(this.info);){
            byte[] tmp = new byte[4096];
            while (true) {
                qc.checkStop();
                int n = bi.read(tmp);
                if (n == -1) {
                    byte[] byArray = md.digest();
                    return byArray;
                }
                md.update(tmp, 0, n);
            }
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }
}

