/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Locale;
import org.basex.query.value.node.ANode;
import org.basex.util.Enums;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CmpOp {
    LE("<=", new String[]{"precedes-or-is"}){

        @Override
        public boolean eval(int v) {
            return v != Integer.MIN_VALUE && v <= 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return node1.compare(node2) <= 0;
        }

        @Override
        public CmpOp swap() {
            return GE;
        }

        @Override
        public CmpOp invert() {
            return GT;
        }
    }
    ,
    LT("<", new String[]{"<<", "precedes"}){

        @Override
        public boolean eval(int v) {
            return v != Integer.MIN_VALUE && v < 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return node1.compare(node2) < 0;
        }

        @Override
        public CmpOp swap() {
            return GT;
        }

        @Override
        public CmpOp invert() {
            return GE;
        }
    }
    ,
    GE(">=", new String[]{"follows-or-is"}){

        @Override
        public boolean eval(int v) {
            return v >= 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return node1.compare(node2) >= 0;
        }

        @Override
        public CmpOp swap() {
            return LE;
        }

        @Override
        public CmpOp invert() {
            return LT;
        }
    }
    ,
    GT(">", new String[]{">>", "follows"}){

        @Override
        public boolean eval(int v) {
            return v > 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return node1.compare(node2) > 0;
        }

        @Override
        public CmpOp swap() {
            return LT;
        }

        @Override
        public CmpOp invert() {
            return LE;
        }
    }
    ,
    EQ("=", new String[]{"is"}){

        @Override
        public boolean eval(int v) {
            return v == 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return node1.is(node2);
        }

        @Override
        public CmpOp swap() {
            return EQ;
        }

        @Override
        public CmpOp invert() {
            return NE;
        }
    }
    ,
    NE("!=", new String[]{"is-not"}){

        @Override
        public boolean eval(int v) {
            return v != 0;
        }

        @Override
        public boolean eval(ANode node1, ANode node2) {
            return !node1.is(node2);
        }

        @Override
        public CmpOp swap() {
            return NE;
        }

        @Override
        public CmpOp invert() {
            return EQ;
        }
    };

    public final String general;
    public final String value;
    public final String[] nodes;

    private CmpOp(String general, String ... nodes) {
        this.general = general;
        this.nodes = nodes;
        this.value = this.name().toLowerCase(Locale.ENGLISH);
    }

    public abstract boolean eval(int var1);

    public abstract boolean eval(ANode var1, ANode var2);

    public abstract CmpOp swap();

    public abstract CmpOp invert();

    public String toValueString() {
        return this.value;
    }

    public String toNodeString() {
        return this.nodes[0];
    }

    public String toString() {
        return this.general;
    }

    public boolean oneOf(CmpOp ... candidates) {
        return Enums.oneOf((Enum)this, (Enum[])candidates);
    }
}

