/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.util.function.Supplier;
import org.basex.build.csv.CsvOptions;
import org.basex.build.json.JsonSerialOptions;
import org.basex.core.BaseXException;
import org.basex.io.IO;
import org.basex.io.serial.SerialMethod;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.path.NameTest;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class SerializerOptions
extends Options {
    public static final EnumOption<Options.YesNo> BYTE_ORDER_MARK = new EnumOption<Options.YesNo>("byte-order-mark", Options.YesNo.NO);
    public static final StringOption CDATA_SECTION_ELEMENTS = new StringOption("cdata-section-elements", "");
    public static final StringOption DOCTYPE_PUBLIC = new StringOption("doctype-public", "");
    public static final StringOption DOCTYPE_SYSTEM = new StringOption("doctype-system", "");
    public static final StringOption ENCODING = new StringOption("encoding", "UTF-8");
    public static final EnumOption<Options.YesNo> ESCAPE_SOLIDUS = new EnumOption<Options.YesNo>("escape-solidus", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> ESCAPE_URI_ATTRIBUTES = new EnumOption<Options.YesNo>("escape-uri-attributes", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> INCLUDE_CONTENT_TYPE = new EnumOption<Options.YesNo>("include-content-type", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> INDENT = new EnumOption<Options.YesNo>("indent", Options.YesNo.NO);
    public static final StringOption SUPPRESS_INDENTATION = new StringOption("suppress-indentation", "");
    public static final StringOption MEDIA_TYPE = new StringOption("media-type", "");
    public static final EnumOption<SerialMethod> METHOD = new EnumOption<SerialMethod>("method", SerialMethod.BASEX);
    public static final StringOption NORMALIZATION_FORM = new StringOption("normalization-form", "none");
    public static final EnumOption<Options.YesNo> OMIT_XML_DECLARATION = new EnumOption<Options.YesNo>("omit-xml-declaration", Options.YesNo.YES);
    public static final EnumOption<Options.YesNoOmit> STANDALONE = new EnumOption<Options.YesNoOmit>("standalone", Options.YesNoOmit.OMIT);
    public static final EnumOption<Options.YesNo> UNDECLARE_PREFIXES = new EnumOption<Options.YesNo>("undeclare-prefixes", Options.YesNo.NO);
    public static final StringOption USE_CHARACTER_MAPS = new StringOption("use-character-maps", "");
    public static final StringOption ITEM_SEPARATOR = new StringOption("item-separator");
    public static final StringOption VERSION = new StringOption("version", "");
    public static final StringOption HTML_VERSION = new StringOption("html-version", "");
    public static final StringOption PARAMETER_DOCUMENT = new StringOption("parameter-document", "");
    public static final EnumOption<Options.YesNo> ALLOW_DUPLICATE_NAMES = new EnumOption<Options.YesNo>("allow-duplicate-names", Options.YesNo.NO);
    public static final EnumOption<SerialMethod> JSON_NODE_OUTPUT_METHOD = new EnumOption<SerialMethod>("json-node-output-method", SerialMethod.XML);
    public static final EnumOption<Options.YesNo> JSON_LINES = new EnumOption<Options.YesNo>("json-lines", Options.YesNo.NO);
    public static final OptionsOption<CsvOptions> CSV = new OptionsOption<CsvOptions>("csv", new CsvOptions());
    public static final OptionsOption<JsonSerialOptions> JSON = new OptionsOption<JsonSerialOptions>("json", new JsonSerialOptions());
    public static final EnumOption<Newline> NEWLINE = new EnumOption<Newline>("newline", "\r".equals(Prop.NL) ? Newline.CR : ("\n".equals(Prop.NL) ? Newline.NL : Newline.CRNL));
    public static final EnumOption<Options.YesNo> TABULATOR = new EnumOption<Options.YesNo>("tabulator", Options.YesNo.NO);
    public static final NumberOption INDENTS = new NumberOption("indents", 2);
    public static final NumberOption LIMIT = new NumberOption("limit", -1);
    public static final EnumOption<Options.YesNo> BINARY = new EnumOption<Options.YesNo>("binary", Options.YesNo.YES);
    public static final EnumOption<Options.YesNo> INDENT_ATTRIBUTES = new EnumOption<Options.YesNo>("indent-attributes", Options.YesNo.NO);
    public static final QNm Q_ROOT = new QNm(QueryText.OUTPUT_PREFIX, "serialization-parameters", QueryText.OUTPUT_URI);
    public static final NameTest T_ROOT = NameTest.get(Q_ROOT);
    private static final QNm Q_VALUE = new QNm("value");

    public boolean yes(EnumOption<Options.YesNo> option) {
        return this.get(option) == Options.YesNo.YES;
    }

    public SerializerOptions() {
    }

    public SerializerOptions(SerializerOptions opts) {
        super(opts);
    }

    public void assign(Item item, InputInfo info) throws QueryException {
        if (!T_ROOT.matches(item)) {
            throw QueryError.ELMMAP_X_X_X.get(info, Q_ROOT.prefixId(Token.XML), item.type, item);
        }
        try {
            this.assign(this.toString((ANode)item, new QNmSet(), info));
        }
        catch (BaseXException ex) {
            throw QueryError.SERDOC_X.get(info, ex);
        }
    }

    public void parse(String name, String value, InputInfo info) throws QueryException {
        Option<?> option = this.option(name);
        if (option == PARAMETER_DOCUMENT) {
            ANode root;
            Uri uri = Uri.get(value);
            if (!uri.isValid()) {
                throw QueryError.INVURI_X.get(info, value);
            }
            if (!uri.isAbsolute()) {
                uri = info.sc().baseURI().resolve(uri, info);
            }
            IO io = IO.get(Token.string(uri.string()));
            try {
                root = new DBNode(io).childIter().next();
            }
            catch (IOException ex) {
                throw QueryError.PARAMDOC_X.get(info, ex);
            }
            if (root != null) {
                this.assign(root, info);
            }
            for (ANode child : root.childIter()) {
                if (child.type != NodeType.ELEMENT || this.option(Token.string(child.qname().local())) != USE_CHARACTER_MAPS) continue;
                this.set(USE_CHARACTER_MAPS, SerializerOptions.characterMap(child, info));
            }
        } else {
            try {
                this.assign(name, value);
            }
            catch (BaseXException ex) {
                throw (option != null ? QueryError.SERPARAM_X : QueryError.OUTPUT_X).get(info, ex);
            }
        }
    }

    public static String characterMap(ANode elem, InputInfo info) throws QueryException {
        Supplier<QueryException> error = () -> QueryError.SERDOC_X.get(info, Util.info("Serialization parameter '%' is invalid.", USE_CHARACTER_MAPS.name()));
        if (elem.attributeIter().next() != null) {
            throw error.get();
        }
        TokenObjectMap<byte[]> map = new TokenObjectMap<byte[]>();
        for (ANode child : elem.childIter()) {
            if (child.type != NodeType.ELEMENT) continue;
            byte[] name = child.qname().local();
            if (Token.eq(name, QueryText.CHARACTER_MAP)) {
                byte[] key = null;
                byte[] val = null;
                for (ANode attr : child.attributeIter()) {
                    byte[] att = attr.name();
                    if (Token.eq(att, QueryText.CHARACTER)) {
                        key = attr.string();
                        continue;
                    }
                    if (Token.eq(att, QueryText.MAP_STRING)) {
                        val = attr.string();
                        continue;
                    }
                    throw error.get();
                }
                if (key == null || val == null) {
                    throw error.get();
                }
                if (map.get(key) != null) {
                    throw QueryError.SERCHARDUP_X.get(info, new Object[]{key});
                }
                if (Token.length(key) != 1) {
                    throw QueryError.SERDOC_X.get(info, Util.info("Key in character map is not a single character: %.", new Object[]{key}));
                }
                map.put(key, val);
                continue;
            }
            throw error.get();
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : map) {
            if (!tb.isEmpty()) {
                tb.add(44);
            }
            tb.add(key).add(61).add(Token.string((byte[])map.get(key)).replace(",", ",,"));
        }
        return tb.toString();
    }

    private String toString(ANode node, QNmSet cache, InputInfo info) throws QueryException {
        ANode att = node.attributeIter().next();
        if (att != null) {
            throw QueryError.SERDOC_X.get(info, Util.info("Invalid attribute: '%'", new Object[]{att.name()}));
        }
        StringBuilder sb = new StringBuilder();
        for (ANode child : node.childIter()) {
            if (child.type != NodeType.ELEMENT) continue;
            QNm qname = child.qname();
            if (!cache.add(qname)) {
                throw QueryError.SERDUP_X.get(info, qname);
            }
            if (!Token.eq(qname.uri(), Q_ROOT.uri())) {
                if (qname.uri().length != 0) continue;
                throw QueryError.SERDOC_X.get(info, Util.info("Element has no namespace: '%'", qname));
            }
            String name = Token.string(qname.local());
            Option<?> option = this.option(name);
            String value = null;
            if (option == USE_CHARACTER_MAPS) {
                value = SerializerOptions.characterMap(child, info);
            } else if (SerializerOptions.hasElements(child)) {
                value = this.toString(child, cache, info);
            } else {
                for (ANode attr : child.attributeIter()) {
                    if (attr.qname().eq(Q_VALUE)) {
                        value = Token.string(attr.string());
                        if (option != CDATA_SECTION_ELEMENTS) continue;
                        value = SerializerOptions.cdataSectionElements(child, value);
                        continue;
                    }
                    throw QueryError.SERDOC_X.get(info, Util.info("Invalid attribute: '%'", new Object[]{attr.name()}));
                }
                if (value == null) {
                    throw QueryError.SERDOC_X.get(info, "Missing 'value' attribute.");
                }
            }
            sb.append(name).append('=').append(value.trim().replace(",", ",,")).append(',');
        }
        return sb.toString();
    }

    private static String cdataSectionElements(ANode elem, String value) {
        if (!Strings.contains(value, ':')) {
            return value;
        }
        TokenBuilder tb = new TokenBuilder();
        byte[][] byArray = Token.distinctTokens(Token.token(value));
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] uri;
            byte[] name;
            byte[] qname = name = byArray[i];
            int i2 = Token.indexOf(name, 58);
            if (i2 != -1 && (uri = elem.nsScope(null).value(Token.substring(name, 0, i2))) != null) {
                qname = QNm.eqName(uri, Token.substring(name, i2 + 1));
            }
            tb.add(qname).add(32);
        }
        return tb.toString();
    }

    private static boolean hasElements(ANode node) {
        for (ANode nd : node.childIter()) {
            if (nd.type != NodeType.ELEMENT) continue;
            return true;
        }
        return false;
    }

    public static enum Newline {
        NL("\\n", "\n"),
        CR("\\r", "\r"),
        CRNL("\\r\\n", "\r\n");

        private final String name;
        private final String newline;

        private Newline(String name, String newline) {
            this.name = name;
            this.newline = newline;
        }

        String newline() {
            return this.newline;
        }

        public String toString() {
            return this.name;
        }
    }
}

