/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;

public final class SyntaxXML
extends Syntax {
    private int quote;
    private boolean name;
    private boolean elem;
    private int comment;
    private int pi;

    @Override
    public void init(Color color) {
        super.init(color);
        this.quote = 0;
        this.name = false;
        this.elem = false;
        this.comment = 0;
        this.pi = 0;
    }

    @Override
    public Color getColor(TextIterator iter) {
        int ch = iter.curr();
        if (this.comment > 0) {
            return this.comment(ch);
        }
        if (this.pi > 0) {
            return this.pi(ch);
        }
        if (this.name) {
            if (this.quote != 0) {
                if (this.quote == ch) {
                    this.quote = 0;
                }
                return GUIConstants.DGRAY;
            }
            if (ch == 34 || ch == 39) {
                this.quote = ch;
                return GUIConstants.DGRAY;
            }
            if (ch == 62) {
                this.name = false;
                return GUIConstants.BLUE;
            }
            if (ch == 61 || ch == 47) {
                return GUIConstants.BLUE;
            }
            if (ch == 33) {
                this.comment = 1;
                this.name = false;
                return GUIConstants.GRAY;
            }
            if (ch == 63) {
                this.pi = 1;
                this.name = false;
                return GUIConstants.GRAY;
            }
            if (this.elem) {
                if (ch <= 32) {
                    this.elem = false;
                }
                return GUIConstants.BLUE;
            }
            return GUIConstants.PURPLE;
        }
        if (ch == 60) {
            this.name = true;
            this.elem = true;
            return GUIConstants.BLUE;
        }
        return this.plain;
    }

    private Color comment(int ch) {
        switch (this.comment) {
            case 1: 
            case 2: {
                this.comment = ch == 45 ? this.comment + 1 : 6;
                break;
            }
            case 3: {
                if (ch != 45) break;
                this.comment = 4;
                break;
            }
            case 4: {
                this.comment = ch == 45 ? this.comment + 1 : 3;
                break;
            }
            case 5: {
                this.comment = ch == 62 ? 0 : 3;
                break;
            }
            case 6: {
                if (ch != 62) break;
                this.comment = 0;
            }
        }
        return this.comment > 0 ? GUIConstants.GRAY : GUIConstants.BLUE;
    }

    private Color pi(int ch) {
        switch (this.pi) {
            case 1: {
                if (ch != 63) break;
                this.pi = 2;
                break;
            }
            case 2: {
                this.pi = ch == 62 ? 0 : 1;
            }
        }
        return this.pi > 0 ? GUIConstants.GRAY : GUIConstants.BLUE;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.COMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.COMM_C;
    }
}

