/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQStaticContext;
import net.xqj.basic.BasicConnection;
import net.xqj.basic.BasicQuery;
import net.xqj.core.Factory;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQDynamicContextImpl;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqparser.XQueryStatement;

public class XQExpression3
extends XQDynamicContextImpl
implements XQExpression {
    private static int instanceCounter = 0;
    private final int instanceId = ++instanceCounter;

    private XQExpression3(GenericXQConnection connection, XQStaticContext staticContext) throws XQException {
        super(connection, staticContext);
    }

    static XQExpression3 newInstance(GenericXQConnection connection, XQStaticContext staticContext) throws XQException {
        return new XQExpression3(connection, staticContext);
    }

    public void executeCommand(Reader command) throws XQException {
        XQToolkit.nullValueTest(command, "Reader", "XQJEX003");
        this.checkIfClosed();
        BasicConnection bc = this.conn.getBasicConnection();
        BasicQuery query = bc.createQuery();
        try {
            char[] heapBuffer = XQToolkit.forceRead(command);
            query.write(heapBuffer);
            query.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl("XQJEX001", "Issue whilst trying to turn execute command into char array.", e);
        }
        try {
            bc.executeCommand(query);
        }
        catch (XQException e) {
            throw e;
        }
        finally {
            this.queryFinishedTrigger();
        }
    }

    public void executeCommand(String command) throws XQException {
        XQToolkit.nullValueTest(command, "String", "XQJEX004");
        this.executeCommand(new StringReader(command));
    }

    public XQResultSequence executeQuery(InputStream query) throws XQException {
        XQToolkit.nullValueTest(query, "InputStream", "XQJEX005");
        return this.executeQuery(Factory.newUTF8Reader(query));
    }

    public XQResultSequence executeQuery(Reader query) throws XQException {
        XQToolkit.nullValueTest(query, "Reader", "XQJEX006");
        this.checkIfClosed();
        BasicConnection bc = this.conn.getBasicConnection();
        BasicQuery outputQuery = bc.createQuery();
        XQueryStatement queryStatement = XQueryStatement.compile(query, this.staticContext);
        try {
            this.resolveQuery(queryStatement, outputQuery);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("IOException occurred.", "XQJEX002", e);
        }
        if (this.conn.getDataSource().getLogger().isTraceLoggable()) {
            ByteBuffer buffer = outputQuery.getCompleteQuery();
            byte[] b = new byte[buffer.limit()];
            buffer.get(b);
            this.conn.getDataSource().getLogger().log(5, XQToolkit.formatMessage(15, this.toString(), XQToolkit.getUTF8String(b)));
        }
        return this.executeQuery(bc, outputQuery);
    }

    public XQResultSequence executeQuery(String query) throws XQException {
        XQToolkit.nullValueTest(query, "String", "XQJEX007");
        return this.executeQuery(new StringReader(query));
    }

    public String toString() {
        return "XQExpression-" + this.instanceId;
    }
}

