/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;

public interface Type {
    public Value cast(Item var1, QueryContext var2, InputInfo var3) throws QueryException;

    public Value cast(Object var1, QueryContext var2, InputInfo var3) throws QueryException;

    public Item read(DataInput var1, QueryContext var2) throws IOException, QueryException;

    default public SeqType seqType() {
        return this.seqType(Occ.EXACTLY_ONE);
    }

    public SeqType seqType(Occ var1);

    default public boolean oneOf(Type ... types) {
        for (Type type : types) {
            if (this != type) continue;
            return true;
        }
        return false;
    }

    default public FuncType funcType() {
        return null;
    }

    public boolean eq(Type var1);

    public boolean instanceOf(Type var1);

    public Type union(Type var1);

    public Type intersect(Type var1);

    public boolean isNumber();

    public boolean isUntyped();

    public boolean isNumberOrUntyped();

    public boolean isStringOrUntyped();

    public boolean isSortable();

    public AtomType atomic();

    public ID id();

    default public byte index() {
        return this.id().asByte();
    }

    public boolean nsSensitive();

    default public boolean refinable() {
        return false;
    }

    default public Type refine(Expr expr) {
        Type tp;
        if (expr != null && (tp = expr.seqType().type.intersect(this)) != null) {
            return tp;
        }
        return this;
    }

    public static String similar(QNm qname) {
        byte[] ln = Token.lc(qname.local());
        TokenList list = new TokenList();
        list.add("item").add("function").add("fn");
        list.add("map").add("array");
        for (NodeType type : NodeType.values()) {
            list.add(type.test());
        }
        byte[][] values = (byte[][])list.finish();
        Object similar = Levenshtein.similar(ln, (Object[])values);
        if (similar == null) {
            for (byte[] value : values) {
                if (!Token.startsWith(value, ln)) continue;
                similar = value;
                break;
            }
        }
        return QueryError.similar(qname.prefixId(Token.XML), similar);
    }

    public String toString();

    public static enum ID {
        FUN(7),
        MAP(30),
        ARRAY(31),
        NOD(8),
        TXT(9),
        PI(10),
        ELM(11),
        DOC(12, true),
        DEL(13, true),
        ATT(14, true),
        COM(15),
        NSP(16),
        SCE(17),
        SCA(18),
        CIT(29),
        ITEM(32),
        UTY(33),
        ATY(34),
        AST(35),
        AAT(36),
        ATM(37),
        STR(38),
        NST(39),
        TOK(40),
        LAN(41),
        NMT(42),
        NAM(43),
        NCN(44),
        ID(45),
        IDR(46),
        ENT(47),
        FLT(48),
        DBL(49),
        DEC(50),
        PDC(51),
        ITR(52),
        NPI(53),
        NIN(54),
        LNG(55),
        INT(56),
        SHR(57),
        BYT(58),
        NNI(59),
        ULN(60),
        UIN(61),
        USH(62),
        UBY(63),
        PIN(64),
        DUR(65),
        YMD(66),
        DTD(67),
        DTM(68),
        DTS(69),
        DAT(70),
        TIM(71),
        YMO(72),
        YEA(73),
        MDA(74),
        DAY(75),
        MON(76),
        BLN(77),
        BIN(78),
        B64(79),
        HEX(80),
        URI(81),
        QNM(82, true),
        NOT(83),
        NUM(84),
        JAVA(86),
        ENM(87),
        ERR(88),
        LAST(89);

        private final byte index;
        private final boolean extended;

        private ID(int index) {
            this(index, false);
        }

        private ID(int index, boolean extended) {
            this.index = (byte)index;
            this.extended = extended;
        }

        public byte asByte() {
            return this.index;
        }

        public boolean isExtended() {
            return this.extended;
        }
    }
}

