/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.math;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.math.MathFn;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;

public final class MathPow
extends MathFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item x = this.arg(0).atomItem(qc, this.info);
        double y = this.toDouble(this.arg(1), qc);
        return x.isEmpty() ? Empty.VALUE : Dbl.get(MathPow.power(this.toDouble(x), y));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        ANum num;
        Expr base = this.arg(0);
        if (base instanceof ANum && (num = (ANum)base).dbl() == 1.0) {
            return Dbl.ONE;
        }
        Expr exp = this.arg(1);
        if (exp instanceof ANum) {
            ANum num2 = (ANum)exp;
            double e = num2.dbl();
            if (e == 0.0) {
                return Dbl.ONE;
            }
            if (e == 1.0) {
                return new Cast(this.info, base, Types.DOUBLE_O).optimize(cc);
            }
            if (e == -1.0) {
                return new Arith(this.info, Dbl.ONE, base, Calc.DIVIDE).optimize(cc);
            }
        }
        if (Function._MATH_POW.is(base)) {
            Expr factor = new Arith(this.info, base.arg(1), exp, Calc.MULTIPLY).optimize(cc);
            return cc.function(Function._MATH_POW, this.info, base.arg(0), factor);
        }
        return super.opt(cc);
    }

    private static double power(double base, double exp) {
        if (base == 1.0) {
            return 1.0;
        }
        if (base == -1.0) {
            if (Double.isNaN(exp)) {
                return -1.0;
            }
            if (Double.isInfinite(exp)) {
                return 1.0;
            }
        }
        return StrictMath.pow(base, exp);
    }
}

