/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.MainOptions;
import org.basex.core.users.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.java.DynJavaConstr;
import org.basex.query.func.java.DynJavaFunc;
import org.basex.query.func.java.JavaCandidate;
import org.basex.query.func.java.JavaMapping;
import org.basex.query.func.java.StaticJavaCall;
import org.basex.query.iter.Iter;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.ItemList;
import org.basex.query.util.list.ValueList;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQJava;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.ShrSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Checks;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JavaCall
extends Arr {
    private static final Object INVALID = new Object();
    public final boolean updating;
    final Perm perm;
    boolean[] xquery;

    JavaCall(Expr[] args, Perm perm, boolean updating, InputInfo info) {
        super(info, Types.ITEM_ZM, args);
        this.updating = updating;
        this.perm = perm;
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        if (!qc.user.has(this.perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{this.perm, this});
        }
        Value value = this.eval(qc, qc.context.options.get(MainOptions.WRAPJAVA));
        if (!this.updating) {
            return value;
        }
        qc.updates().addOutput(value, qc);
        return Empty.VALUE;
    }

    protected abstract Value eval(QueryContext var1, MainOptions.WrapOptions var2) throws QueryException;

    final Value[] values(QueryContext qc) throws QueryException {
        ValueList list = new ValueList(this.exprs.length);
        for (Expr expr : this.exprs) {
            list.add(expr.value(qc));
        }
        return (Value[])list.finish();
    }

    final JavaCandidate candidate(Value[] args, Class<?>[] params, boolean stat) throws QueryException {
        int pl = params.length;
        int s = stat ? 0 : 1;
        if (pl != args.length - s) {
            return null;
        }
        JavaCandidate jc = new JavaCandidate(pl);
        for (int p = 0; p < pl; ++p) {
            Value arg = args[p + s];
            Class<?> param = params[p];
            Object value = this.convert(arg, param, p);
            if (value == INVALID) {
                return null;
            }
            jc.exact = jc.exact && JavaMapping.type(param, false) == arg.seqType().type;
            jc.arguments[p] = value;
        }
        return jc;
    }

    private Object convert(Value arg, Class<?> param, int p) throws QueryException {
        Object value;
        if (param == Expr.class) {
            return arg;
        }
        Type type = JavaMapping.type(param, true);
        if (type != null && arg.type.instanceOf(type)) {
            return arg.toJava();
        }
        if (arg instanceof XQArray && arg.structSize() == 0L && param.isArray()) {
            Class<?> atype = param.getComponentType();
            if (atype == Boolean.TYPE) {
                return new boolean[0];
            }
            if (atype == Byte.TYPE) {
                return new byte[0];
            }
            if (atype == Short.TYPE) {
                return new short[0];
            }
            if (atype == Character.TYPE) {
                return new char[0];
            }
            if (atype == Integer.TYPE) {
                return new int[0];
            }
            if (atype == Long.TYPE) {
                return new long[0];
            }
            if (atype == Float.TYPE) {
                return new float[0];
            }
            if (atype == Double.TYPE) {
                return new double[0];
            }
            if (atype == String.class) {
                return new String[0];
            }
            return new Object[0];
        }
        if (arg instanceof ANum) {
            ANum num = (ANum)arg;
            double d = num.dbl();
            if ((param == Byte.TYPE || param == Byte.class) && (double)((byte)d) == d) {
                return (byte)d;
            }
            if ((param == Short.TYPE || param == Short.class) && (double)((short)d) == d) {
                return (short)d;
            }
            if ((param == Character.TYPE || param == Character.class) && (double)((char)d) == d) {
                return Character.valueOf((char)d);
            }
            if ((param == Integer.TYPE || param == Integer.class) && (double)((int)d) == d) {
                return (int)d;
            }
            if ((param == Float.TYPE || param == Float.class) && (double)((float)d) == d) {
                return Float.valueOf((float)d);
            }
            if (param == Double.TYPE || param == Double.class) {
                return d;
            }
        }
        Object object = arg instanceof XQJava || !(this.xquery == null ? Value.class.isAssignableFrom(param) : this.xquery[p]) ? arg.toJava() : (value = arg);
        if (param.isInstance(value) || value == null && !param.isPrimitive()) {
            return value;
        }
        return INVALID;
    }

    static JavaCandidate bestCandidate(ArrayList<JavaCandidate> candidates) {
        if (((Checks<JavaCandidate>)jc -> jc.exact).any(candidates)) {
            for (int c = candidates.size() - 1; c >= 0; --c) {
                if (candidates.get((int)c).exact) continue;
                candidates.remove(c);
            }
        }
        return candidates.size() == 1 ? candidates.get(0) : null;
    }

    final QueryException executionError(Throwable th, Object[] args) {
        QueryException queryException;
        Util.debug(th);
        Throwable root = Util.rootException(th);
        if (root instanceof QueryException) {
            QueryException qe = (QueryException)root;
            queryException = qe.info(this.info);
        } else {
            queryException = QueryError.JAVAEXEC_X_X_X.get(this.info, root, this.name(), JavaCall.argTypes(args));
        }
        return queryException;
    }

    public static Value toValue(Object object, QueryContext qc, InputInfo info) throws QueryException {
        return JavaCall.toValue(object, qc, info, qc.context.options.get(MainOptions.WRAPJAVA));
    }

    public static Value toValue(Object object, QueryContext qc, InputInfo info, MainOptions.WrapOptions wrap) throws QueryException {
        if (object instanceof Value) {
            Value value = (Value)object;
            return value;
        }
        if (object instanceof Iter) {
            Iter iter = (Iter)object;
            return iter.value(qc, null);
        }
        if (wrap != MainOptions.WrapOptions.ALL) {
            if (object == null) {
                return Empty.VALUE;
            }
            Type type = JavaCall.type(object);
            if (type != null) {
                return type.cast(object, qc, null);
            }
            if (object.getClass().isArray()) {
                int s = Array.getLength(object);
                if (s == 0) {
                    return Empty.VALUE;
                }
                if (object instanceof boolean[]) {
                    boolean[] values = (boolean[])object;
                    return BlnSeq.get(values);
                }
                if (object instanceof byte[]) {
                    byte[] values = (byte[])object;
                    return BytSeq.get(values);
                }
                if (object instanceof short[]) {
                    short[] values = (short[])object;
                    return ShrSeq.get(values);
                }
                if (object instanceof int[]) {
                    int[] values = (int[])object;
                    return IntSeq.get(values);
                }
                if (object instanceof float[]) {
                    float[] values = (float[])object;
                    return FltSeq.get(values);
                }
                if (object instanceof double[]) {
                    double[] values = (double[])object;
                    return DblSeq.get(values);
                }
                if (object instanceof char[]) {
                    char[] values = (char[])object;
                    IntList list = new IntList(values.length);
                    for (char value : values) {
                        list.add((int)value);
                    }
                    return IntSeq.get(list.finish(), AtomType.UNSIGNED_LONG);
                }
                if (object instanceof long[]) {
                    long[] values = (long[])object;
                    ItemList list = new ItemList(values.length);
                    for (long value : values) {
                        list.add(Itr.get(value));
                    }
                    return list.value();
                }
                for (Object obj : (Object[])object) {
                    if (obj != null) continue;
                    throw QueryError.JAVANULL.get(info, new Object[0]);
                }
                if (object instanceof String[]) {
                    Object[] values = (String[])object;
                    TokenList list = new TokenList(values.length);
                    for (Object string : values) {
                        list.add((String)string);
                    }
                    return StrSeq.get(list);
                }
                Object[] array = (Object[])object;
                ValueBuilder vb = new ValueBuilder(qc, array.length);
                for (Object value : array) {
                    vb.add(JavaCall.toValue(value, qc, info, wrap));
                }
                return vb.value();
            }
            if (wrap == MainOptions.WrapOptions.NONE) {
                ValueBuilder vb = new ValueBuilder(qc);
                if (object instanceof Iterable) {
                    Iterable iter = (Iterable)object;
                    for (Object obj : iter) {
                        vb.add(JavaCall.toValue(obj, qc, info, wrap));
                    }
                } else if (object instanceof Iterator) {
                    Iterator ir = (Iterator)object;
                    while (ir.hasNext()) {
                        vb.add(JavaCall.toValue(ir.next(), qc, info, wrap));
                    }
                } else if (object instanceof Map) {
                    MapBuilder mb = new MapBuilder();
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        Item key = JavaCall.toValue(entry.getKey(), qc, info, wrap).item(qc, info);
                        Value value = JavaCall.toValue(entry.getValue(), qc, info, wrap);
                        mb.put(key, value);
                    }
                    vb.add(mb.map());
                } else {
                    vb.add(Str.get(object.toString()));
                }
                return vb.value();
            }
        }
        return new XQJava(object);
    }

    public static JavaCall get(QNm qname, Expr[] args, QueryContext qc, InputInfo info) throws QueryException {
        String uri;
        boolean enforce;
        String name = Strings.camelCase(Token.string(qname.local()));
        String[] types = null;
        int n = name.indexOf(183);
        if (n != -1) {
            StringList list = new StringList();
            for (String type : Strings.split(name.substring(n + 1), '\u00b7')) {
                list.add(JavaCall.classPath(type.replace("...", "[]")));
            }
            types = (String[])list.finish();
            name = name.substring(0, n);
        }
        String className = JavaCall.classPath((enforce = (uri = Token.string(qname.uri())).startsWith("java:")) ? uri.substring("java:".length()) : Strings.uriToClasspath(Strings.uri2path(uri)));
        ModuleLoader modules = qc.resources.modules();
        Object module = modules.findModule(className);
        if (module != null) {
            boolean updating;
            Method meth = JavaCall.moduleMethod(module, name, args.length, types, qname, qc, info);
            QueryModule.Requires req = meth.getAnnotation(QueryModule.Requires.class);
            Perm perm = req == null ? Perm.ADMIN : Enums.get(Perm.class, req.value().name().toLowerCase(Locale.ENGLISH));
            boolean bl = updating = meth.getAnnotation(QueryModule.Updating.class) != null;
            if (updating) {
                qc.updating();
            }
            return new StaticJavaCall(module, meth, args, perm, updating, info);
        }
        if (enforce || (info.sc().module == null || !Token.eq(info.sc().module.uri(), qname.uri())) && NSGlobal.prefix(qname.uri()).length == 0) {
            Class<?> clazz = null;
            try {
                clazz = modules.findClass(className);
            }
            catch (ClassNotFoundException ex) {
                Util.debug(ex);
            }
            catch (Throwable th) {
                throw QueryError.JAVAINIT_X_X.get(info, Util.className(th), th);
            }
            if (clazz == null) {
                if (enforce) {
                    throw QueryError.JAVACLASS_X.get(info, className);
                }
            } else {
                DynJavaConstr djc;
                if (name.equals("new") && (djc = new DynJavaConstr(clazz, types, args, info)).init(enforce)) {
                    return djc;
                }
                DynJavaFunc djf = new DynJavaFunc(clazz, name, types, args, info);
                if (djf.init(enforce)) {
                    return djf;
                }
            }
        }
        return null;
    }

    private static Method moduleMethod(Object module, String name, int arity, String[] types, QNm qname, QueryContext qc, InputInfo info) throws QueryException {
        IntList arities = new IntList();
        HashMap<String, ArrayList<Method>> allMethods = JavaCall.methods(module.getClass());
        ArrayList<Method> candidates = JavaCall.candidates(allMethods, name, types, arity, arities, true);
        int cs = candidates.size();
        if (cs == 0) {
            TokenList names = new TokenList();
            for (String method : allMethods.keySet()) {
                names.add(method);
            }
            throw JavaCall.noMember(name, types, arity, arities, (byte[][])names.finish(), info, Token.string(qname.string()));
        }
        if (cs > 1) {
            throw QueryError.JAVAMULTIPLE_X_X.get(info, qname.string(), JavaCall.paramTypes((Executable[])candidates.toArray(Executable[]::new), false));
        }
        Method method = candidates.get(0);
        QueryModule.Lock lock = method.getAnnotation(QueryModule.Lock.class);
        if (lock != null) {
            qc.locks.add("basex:" + lock.value());
        }
        return method;
    }

    static QueryException noMember(String name, String[] types, int arity, IntList arities, byte[][] names, InputInfo info, String member) {
        if (!arities.isEmpty()) {
            return Functions.wrongArity(arity, arities, false, info, member);
        }
        byte[] nm = Token.token(name);
        Object similar = Levenshtein.similar(nm, (Object[])names);
        if (similar != null && Token.eq(nm, (byte[])similar)) {
            StringJoiner sj = new StringJoiner(", ", "(", ")");
            for (String type : types) {
                sj.add(JavaCall.className(type));
            }
            return QueryError.JAVAARGS_X_X.get(info, member, sj);
        }
        return QueryError.JAVAMEMBER_X.get(info, QueryError.similar(member, similar));
    }

    static HashMap<String, ArrayList<Method>> methods(Class<?> clazz) {
        HashSet<String> names = new HashSet<String>();
        HashMap<String, ArrayList<Method>> list = new HashMap<String, ArrayList<Method>>();
        for (boolean bridge : new boolean[]{false, true}) {
            for (Method method : clazz.getMethods()) {
                if (bridge != method.isBridge()) continue;
                StringBuilder id = new StringBuilder().append(method.getName()).append('-');
                for (Class<?> type : method.getParameterTypes()) {
                    id.append(type.getName()).append('-');
                }
                if (!names.add(id.toString())) continue;
                list.computeIfAbsent(method.getName(), n -> new ArrayList(1)).add(method);
            }
        }
        return list;
    }

    static ArrayList<Method> candidates(HashMap<String, ArrayList<Method>> methods, String name, String[] types, int arity, IntList arities, boolean stat) {
        ArrayList<Method> list = new ArrayList<Method>(1);
        ArrayList<Method> mthds = methods.get(name);
        if (mthds != null) {
            for (Method method : mthds) {
                Class<?>[] params = method.getParameterTypes();
                int al = params.length + (stat || JavaCall.isStatic(method) ? 0 : 1);
                if (al == arity) {
                    if (!JavaCall.typesMatch(params, types)) continue;
                    list.add(method);
                    continue;
                }
                arities.add(al);
            }
        }
        return list;
    }

    public static String classPath(String name) {
        return name.replaceAll("^([A-Z][^.]+)$", "java.lang.$1");
    }

    static String className(Class<?> clazz) {
        return JavaCall.className(clazz.getCanonicalName());
    }

    static String className(String name) {
        return name.startsWith("java.lang.") ? name.substring("java.lang.".length()) : name;
    }

    static boolean isStatic(Executable exec) {
        return exec instanceof Constructor || Modifier.isStatic(exec.getModifiers());
    }

    static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    static String paramTypes(Executable[] execs, boolean xquery) {
        StringJoiner sj = new StringJoiner(", ");
        for (Executable exec : execs) {
            sj.add(JavaCall.paramTypes(exec, xquery));
        }
        return sj.toString();
    }

    static String paramTypes(Executable exec, boolean xquery) {
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        for (Class<?> param : exec.getParameterTypes()) {
            Type type = xquery ? JavaMapping.type(param, false) : null;
            sj.add(type != null ? type.toString() : JavaCall.className(param));
        }
        return sj.toString();
    }

    static String argTypes(Object[] args) {
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        for (Object arg : args) {
            sj.add(JavaCall.argType(arg));
        }
        return sj.toString();
    }

    static String argType(Object argument) {
        String string;
        Object object;
        if (argument instanceof XQJava) {
            XQJava java = (XQJava)argument;
            v0 = java.toJava();
        } else {
            v0 = object = argument;
        }
        if (object instanceof Value) {
            Value value = (Value)object;
            string = value.seqType().toString();
        } else {
            string = object == null ? Util.info(null, new Object[0]) : Util.className(object);
        }
        return string;
    }

    static boolean typesMatch(Class<?>[] pTypes, String[] qTypes) {
        if (qTypes == null) {
            return true;
        }
        int pl = pTypes.length;
        if (pl != qTypes.length) {
            return false;
        }
        for (int p = 0; p < pl; ++p) {
            if (qTypes[p].equals(pTypes[p].getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    private static Type type(Object object) {
        Type type = JavaMapping.type(object.getClass(), true);
        if (type != null) {
            return type;
        }
        if (object instanceof Element) {
            return NodeType.ELEMENT;
        }
        if (object instanceof Document || object instanceof DocumentFragment) {
            return NodeType.DOCUMENT_NODE;
        }
        if (object instanceof Attr) {
            return NodeType.ATTRIBUTE;
        }
        if (object instanceof Comment) {
            return NodeType.COMMENT;
        }
        if (object instanceof ProcessingInstruction) {
            return NodeType.PROCESSING_INSTRUCTION;
        }
        if (object instanceof Text) {
            return NodeType.TEXT;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return !duration.isSet(DatatypeConstants.YEARS) && !duration.isSet(DatatypeConstants.MONTHS) ? AtomType.DAY_TIME_DURATION : (!duration.isSet(DatatypeConstants.HOURS) && !duration.isSet(DatatypeConstants.MINUTES) && !duration.isSet(DatatypeConstants.SECONDS) ? AtomType.YEAR_MONTH_DURATION : AtomType.DURATION);
        }
        if (object instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar calendar = (XMLGregorianCalendar)object;
            QName qnm = calendar.getXMLSchemaType();
            if (qnm == DatatypeConstants.DATE) {
                return AtomType.DATE;
            }
            if (qnm == DatatypeConstants.DATETIME) {
                return AtomType.DATE_TIME;
            }
            if (qnm == DatatypeConstants.TIME) {
                return AtomType.TIME;
            }
            if (qnm == DatatypeConstants.GYEARMONTH) {
                return AtomType.G_YEAR_MONTH;
            }
            if (qnm == DatatypeConstants.GMONTHDAY) {
                return AtomType.G_MONTH_DAY;
            }
            if (qnm == DatatypeConstants.GYEAR) {
                return AtomType.G_YEAR;
            }
            if (qnm == DatatypeConstants.GMONTH) {
                return AtomType.G_MONTH;
            }
            if (qnm == DatatypeConstants.GDAY) {
                return AtomType.G_DAY;
            }
        }
        return null;
    }

    abstract String desc();

    abstract String name();

    @Override
    public final String description() {
        return this.desc() + "(...)";
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name()), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.desc()).params(this.exprs);
    }
}

