/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigDecimal;
import java.math.MathContext;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class FnParseIetfDate
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value = this.arg(0).atomItem(qc, this.info);
        return value.isEmpty() ? Empty.VALUE : new DateParser(this.toToken(value), this.info).parse();
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optFirst();
    }

    private static final class DateParser
    extends InputParser {
        private static final String[] DAYS = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "mon", "tue", "wed", "thu", "fri", "sat", "sun"};
        private static final String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        private static final String[] TZNAMES = new String[]{"utc", "ut", "gmt", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        private static final int[] TIMES = new int[]{0, 0, 0, -300, -240, -360, -300, -420, -360, -480, -420};
        private final byte[] original;
        private final InputInfo info;
        private int day;
        private int month;
        private int year;
        private int hours;
        private int minutes;
        private BigDecimal seconds = BigDecimal.ZERO;
        private Integer zone;

        private DateParser(byte[] input, InputInfo info) {
            super(Token.string(Token.lc(input)).trim());
            this.original = input;
            this.info = info;
        }

        private Dtm parse() throws QueryException {
            int z;
            this.input();
            TokenBuilder tb = new TokenBuilder();
            DateParser.addNumber(tb, this.year, 4).add(45);
            DateParser.addNumber(tb, this.month, 2).add(45);
            DateParser.addNumber(tb, this.day, 2).add(84);
            DateParser.addNumber(tb, this.hours, 2).add(58);
            DateParser.addNumber(tb, this.minutes, 2).add(58);
            int sec = this.seconds.intValue();
            DateParser.addNumber(tb, sec, 2);
            if (this.seconds.scale() > 0) {
                tb.add(this.seconds.subtract(BigDecimal.valueOf(sec)).toString().substring(1));
            }
            int n = z = this.zone == null ? 0 : this.zone;
            if (z == 0) {
                tb.add(90);
            } else {
                tb.add(z < 0 ? 45 : 43);
                DateParser.addNumber(tb, Math.abs(z / 60), 2).add(58);
                DateParser.addNumber(tb, Math.abs(z % 60), 2);
            }
            try {
                return new Dtm(tb.finish(), (Type)AtomType.DATE_TIME, this.info);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.IETF_INV_X.get(this.info, new Object[]{this.original});
            }
        }

        private void input() throws QueryException {
            this.skipWs();
            boolean f = false;
            for (String d : DAYS) {
                if (!this.consume(d)) continue;
                f = true;
                break;
            }
            this.consume(44);
            if (f && !this.skipWs()) {
                throw this.error("whitespace");
            }
            if (this.datespec()) {
                if (!this.skipWs()) {
                    throw this.error("whitespace");
                }
                if (!this.time()) {
                    throw this.error("time");
                }
            } else if (!this.asctime()) {
                throw this.error("day, or name of month");
            }
            this.skipWs();
            if (this.more()) {
                throw this.error("end of input");
            }
        }

        private boolean datespec() throws QueryException {
            if (!this.daynum()) {
                return false;
            }
            if (!this.dsep()) {
                throw this.error("'-'");
            }
            if (!this.monthname()) {
                throw this.error("name of month");
            }
            if (!this.dsep()) {
                throw this.error("'-'");
            }
            if (!this.year()) {
                throw this.error("year");
            }
            return true;
        }

        private boolean asctime() throws QueryException {
            if (!this.monthname()) {
                return false;
            }
            if (!this.dsep()) {
                throw this.error("'-'");
            }
            if (!this.daynum()) {
                throw this.error("day");
            }
            if (!this.skipWs()) {
                throw this.error("whitespace");
            }
            if (!this.time()) {
                throw this.error("time");
            }
            if (!this.skipWs()) {
                throw this.error("whitespace");
            }
            if (!this.year()) {
                throw this.error("year");
            }
            return true;
        }

        private boolean time() throws QueryException {
            if (!this.hours()) {
                return false;
            }
            if (!this.consume(58) || !this.minutes()) {
                throw this.error("minutes");
            }
            if (this.consume(58) && !this.seconds()) {
                throw this.error("seconds");
            }
            int ip = this.pos;
            this.skipWs();
            if (!this.timezone()) {
                this.pos = ip;
            }
            return true;
        }

        private boolean daynum() {
            this.day = this.oneOrTwoDigits();
            return this.day != -1;
        }

        private boolean dsep() {
            boolean s = this.skipWs();
            if (this.consume(45)) {
                this.skipWs();
                return true;
            }
            return s;
        }

        private boolean monthname() {
            int ml = MONTHS.length;
            int m = -1;
            while (++m < ml && !this.consume(MONTHS[m])) {
            }
            if (m == ml) {
                return false;
            }
            this.month = m + 1;
            return true;
        }

        private boolean year() {
            int d1 = this.twoDigits();
            if (d1 == -1) {
                return false;
            }
            int d2 = this.twoDigits();
            this.year = d2 == -1 ? d1 + 1900 : d1 * 100 + d2;
            return true;
        }

        private boolean hours() {
            this.hours = this.oneOrTwoDigits();
            return this.hours != -1;
        }

        private boolean minutes() {
            this.minutes = this.twoDigits();
            return this.minutes != -1;
        }

        private boolean seconds() throws QueryException {
            int d = this.twoDigits();
            if (d == -1) {
                return false;
            }
            BigDecimal bd = BigDecimal.valueOf(d);
            if (this.consume(46)) {
                if (!Token.digit(this.current())) {
                    throw this.error("digit");
                }
                BigDecimal f = BigDecimal.TEN;
                while (Token.digit(this.current())) {
                    bd = bd.add(BigDecimal.valueOf(this.number()).divide(f, MathContext.DECIMAL64));
                    f = f.multiply(BigDecimal.TEN);
                }
            }
            this.seconds = bd;
            return true;
        }

        private boolean timezone() throws QueryException {
            if (this.tzname()) {
                return true;
            }
            if (!this.tzoffset()) {
                return false;
            }
            int ip = this.pos;
            this.skipWs();
            if (this.consume(40)) {
                this.skipWs();
                if (!this.tzname()) {
                    throw this.error("timezone");
                }
                this.skipWs();
                if (!this.consume(41)) {
                    throw this.error("')'");
                }
            } else {
                this.pos = ip;
            }
            return true;
        }

        private boolean tzname() {
            int tl = TZNAMES.length;
            int t = -1;
            while (++t < tl && !this.consume(TZNAMES[t])) {
            }
            if (t == tl) {
                return false;
            }
            if (this.zone == null) {
                this.zone = TIMES[t];
            }
            return true;
        }

        private boolean tzoffset() throws QueryException {
            int s;
            int n = s = this.consume(45) ? -1 : 1;
            if (s == 1 && !this.consume(43)) {
                return false;
            }
            if (!Token.digit(this.current())) {
                throw this.error("timezone digits");
            }
            int h = this.number();
            int m = 0;
            if (this.consume(58)) {
                int n2 = this.twoDigits();
                if (n2 != -1) {
                    m = n2;
                }
            } else if (Token.digit(this.current())) {
                int n3 = this.number();
                if (Token.digit(this.current())) {
                    int n2 = this.number();
                    if (Token.digit(this.current())) {
                        h = h * 10 + n3;
                        m = n2 * 10 + this.number();
                    } else {
                        m = n3 * 10 + n2;
                    }
                } else {
                    int n2;
                    h = h * 10 + n3;
                    if (this.consume(58) && (n2 = this.twoDigits()) != -1) {
                        m = n2;
                    }
                }
            }
            if (m >= 60) {
                throw QueryError.IETF_INV_X.get(this.info, m);
            }
            this.zone = s * (h * 60 + m);
            return true;
        }

        private int twoDigits() {
            return Token.digit(this.current()) && Token.digit(this.next()) ? this.number() * 10 + this.number() : -1;
        }

        private int oneOrTwoDigits() {
            if (!Token.digit(this.current())) {
                return -1;
            }
            int d = this.number();
            return Token.digit(this.current()) ? d * 10 + this.number() : d;
        }

        private boolean skipWs() {
            if (!this.more() || !Token.ws(this.current())) {
                return false;
            }
            do {
                this.consume();
            } while (this.more() && Token.ws(this.current()));
            return true;
        }

        private static TokenBuilder addNumber(TokenBuilder tb, int num, int digits) {
            byte[] tmp = Token.token(num);
            for (int n = tmp.length; n < digits; ++n) {
                tb.add(48);
            }
            return tb.add(tmp);
        }

        private QueryException error(String msg) {
            return QueryError.IETF_PARSE_X_X_X.get(this.info, msg, this.current(), this.original);
        }

        private int number() {
            return this.consume() - 48;
        }
    }
}

