/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.ListIterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.HofArgs;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;

public final class ArrayForEachPair
extends ArrayFn {
    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        XQArray array1 = this.toArray(this.arg(0), qc);
        XQArray array2 = this.toArray(this.arg(1), qc);
        FItem action = this.toFunction(this.arg(2), 3, qc);
        HofArgs args = new HofArgs(3, action);
        long as = Math.min(array1.structSize(), array2.structSize());
        ArrayBuilder ab = new ArrayBuilder(qc, as);
        ListIterator<Value> iter1 = array1.iterator(0L);
        ListIterator<Value> iter2 = array2.iterator(0L);
        while (iter1.hasNext() && iter2.hasNext()) {
            ab.add(this.invoke(action, args.set(0, (Value)iter1.next()).set(1, (Value)iter2.next()).inc(), qc));
        }
        return ab.array(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        FuncType ft;
        Expr array1 = this.arg(0);
        Expr array2 = this.arg(1);
        if (array1 == XQArray.empty()) {
            return array1;
        }
        if (array2 == XQArray.empty()) {
            return array2;
        }
        Type type1 = array1.seqType().type;
        Type type2 = array2.seqType().type;
        if (type1 instanceof ArrayType) {
            ArrayType at1 = (ArrayType)type1;
            if (type2 instanceof ArrayType) {
                ArrayType at2 = (ArrayType)type2;
                this.arg(2, arg -> ArrayForEachPair.refineFunc(arg, cc, at1.valueType(), at2.valueType(), Types.INTEGER_O));
            }
        }
        if ((ft = this.arg(2).funcType()) != null) {
            this.exprType.assign(ArrayType.get(ft.declType));
        }
        return this;
    }

    @Override
    public long structSize() {
        long as1 = this.structSize(0);
        long as2 = this.structSize(1);
        return as1 != -1L && as2 != -1L ? Math.min(as1, as2) : -1L;
    }

    @Override
    public int hofIndex() {
        return 2;
    }
}

