/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class FuncLit
extends Single
implements Scope,
XQFunctionExpr {
    private final VarScope vs;
    private final QNm name;
    private final Var[] params;
    private final AnnList anns;

    FuncLit(InputInfo info, Expr expr, Var[] params, AnnList anns, SeqType seqType, QNm name, VarScope vs) {
        super(info, expr, seqType);
        this.name = name;
        this.params = params;
        this.anns = anns;
        this.vs = vs;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) {
        return null;
    }

    @Override
    public boolean vacuousBody() {
        return false;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        cc.pushScope(this.vs);
        try {
            this.expr = cc.compileOrError(this.expr, false);
        }
        finally {
            cc.removeScope(this);
        }
        this.expr.markTailCalls(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        return this.expr instanceof Value || !this.expr.has(Flag.CTX) ? cc.preEval(this) : this;
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public FuncItem item(QueryContext qc, InputInfo ii) {
        return new FuncItem(this.info, this.expr, this.params, this.anns, this.funcType(), this.vs.stackSize(), this.name, qc.focus.copy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        VarScope vsc = new VarScope();
        cc.pushScope(vsc);
        try {
            int pl = this.params.length;
            Var[] vars = new Var[pl];
            for (int p = 0; p < pl; ++p) {
                vars[p] = cc.copy(this.params[p], vm);
            }
            Expr ex = this.expr.copy(cc, vm);
            FuncLit funcLit = this.copyType(new FuncLit(this.info, ex, vars, this.anns, this.seqType(), this.name, vsc));
            return funcLit;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.inlineFunc(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String description() {
        return "function literal";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.anns).concat("(: ", this.name.prefixId(), "#", this.params.length, " :)");
        qs.token("fn").params(this.params).token("as").token(this.funcType().declType).brace(this.expr);
    }
}

