/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.lang.invoke.LambdaMetafactory;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class List
extends Arr {
    public List(InputInfo info, Expr ... exprs) {
        super(info, Types.ITEM_ZM, exprs);
    }

    public static Expr get(CompileContext cc, InputInfo info, Expr ... exprs) throws QueryException {
        int el = exprs.length;
        return el > 1 ? new List(info, exprs).optimize(cc) : (el > 0 ? exprs[0] : Empty.VALUE);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        this.removeEmpty(cc);
        this.toRange(cc);
        this.toReplicate(cc);
        int el = this.exprs.length;
        if (el == 0) {
            return cc.emptySeq(this);
        }
        if (el == 1) {
            return this.exprs[0];
        }
        SeqType st = SeqType.union(this.exprs, false);
        Occ occ = Occ.ZERO;
        long size = 0L;
        for (Expr expr : this.exprs) {
            long sz = expr.size();
            if (size != -1L) {
                size = sz == -1L ? -1L : size + sz;
            }
            occ = occ.add(expr.seqType().occ);
        }
        this.exprType.assign(st != null ? st : Types.EMPTY_SEQUENCE_Z, occ, size).data(this.exprs);
        return this.values(true, cc) ? cc.preEval(this).shrink(cc.qc) : this;
    }

    private void toReplicate(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        ExprList list = new ExprList(el);
        int s = 0;
        int e = 0;
        while (++e <= el) {
            if (e != el && this.exprs[e].equals(this.exprs[s])) continue;
            if (e - s > 1) {
                list.add(cc.replicate(this.exprs[s], Itr.get(e - s), this.info));
                cc.info("merge: %", list.peek());
            } else {
                while (s < e) {
                    list.add(this.exprs[s++]);
                }
            }
            s = e;
        }
        this.exprs = (Expr[])list.finish();
    }

    /*
     * Unable to fully structure code
     */
    private void toRange(CompileContext cc) {
        if (!(Checks<Expr>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$toRange$0(org.basex.query.expr.Expr ), (Lorg/basex/query/expr/Expr;)Z)().any((Expr[])this.exprs)) {
            return;
        }
        min = -9223372036854775808L;
        max = 0L;
        el = this.exprs.length;
        list = new ExprList(el);
        for (e = 0; e <= el; ++e) {
            expr = e < el ? this.exprs[e] : null;
            mn = -9223372036854775808L;
            mx = 0L;
            if (!(expr instanceof Itr)) ** GOTO lbl-1000
            itr = (Itr)expr;
            if (itr.type == AtomType.INTEGER) {
                mn = l = itr.itr();
                mx = l;
            } else if (expr instanceof RangeSeq && (rs = (RangeSeq)expr).ascending()) {
                mn = rs.min();
                mx = rs.max();
            }
            v0 = add = mn == -9223372036854775808L;
            if (!add) {
                if (min == -9223372036854775808L) {
                    min = mn;
                    max = mx;
                } else if (mn == max + 1L) {
                    max = mx;
                } else {
                    add = true;
                }
            }
            if (!add) continue;
            if (min != -9223372036854775808L) {
                s = max - min + 1L;
                list.add(RangeSeq.get(min, s, true));
                if (s > 1L) {
                    cc.info("merge: %", new Object[]{list.peek()});
                }
                min = mn;
                max = mx;
            }
            if (min != -9223372036854775808L || expr == null) continue;
            list.add(expr);
        }
        this.exprs = (Expr[])list.finish();
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final int el;
            private final Iter[] iters;
            private long[] offsets;
            private long size;
            private int e;
            {
                this.el = List.this.exprs.length;
                this.iters = new Iter[this.el];
            }

            @Override
            public Item next() throws QueryException {
                while (this.e < this.el) {
                    Item item = qc.next(this.iter(this.e));
                    if (item != null) {
                        return item;
                    }
                    ++this.e;
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                int o;
                for (o = 0; o < this.el - 1 && this.offsets[o + 1] <= i; ++o) {
                }
                return this.iter(o).get(i - this.offsets[o]);
            }

            @Override
            public long size() throws QueryException {
                if (this.offsets == null) {
                    this.offsets = new long[this.el];
                    for (int o = 0; o < this.el && this.size != -1L; ++o) {
                        this.offsets[o] = this.size;
                        long s = this.iter(o).size();
                        this.size = s == -1L || this.size + s < 0L ? -1L : this.size + s;
                    }
                }
                return this.size;
            }

            private Iter iter(int i) throws QueryException {
                Iter iter = this.iters[i];
                if (iter == null) {
                    this.iters[i] = iter = List.this.exprs[i].iter(qc);
                }
                return iter;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long size = this.size();
        if (size != -1L) {
            ValueBuilder vb = new ValueBuilder(qc, size);
            for (Expr expr : this.exprs) {
                vb.add(expr.value(qc));
            }
            return vb.value(this);
        }
        Value value = null;
        for (Expr expr : this.exprs) {
            Value v = expr.value(qc);
            value = value != null ? value.append(v, qc) : v;
        }
        return value;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.toUnion(cc);
        } else if (mode == CompileContext.Simplify.DISTINCT) {
            int el = this.exprs.length;
            ExprList list = new ExprList(el);
            for (Expr ex : this.exprs) {
                list.addUnique(ex.simplifyFor(mode, cc));
            }
            this.exprs = (Expr[])list.finish();
            if (this.exprs.length != el) {
                expr = List.get(cc, this.info, this.exprs);
            } else if (this.seqType().type == AtomType.INTEGER) {
                expr = this.toRange();
            }
        } else {
            Expr[] ex = this.simplifyAll(mode, cc);
            if (ex != this.exprs) {
                expr = List.get(cc, this.info, ex);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    public Expr toUnion(CompileContext cc) throws QueryException {
        return this.seqType().type instanceof NodeType ? cc.replaceWith(this, new Union(this.info, this.exprs)).optimize(cc) : this;
    }

    private Expr toRange() {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        for (Expr expr : this.exprs) {
            RangeSeq rs;
            long e;
            long s;
            if (expr instanceof Itr) {
                Itr itr = (Itr)expr;
                e = s = itr.itr();
            } else if (expr instanceof RangeSeq && (rs = (RangeSeq)expr).ascending()) {
                s = rs.min();
                e = rs.max();
            } else {
                return this;
            }
            if (start > end) {
                start = s;
                end = e;
                continue;
            }
            if (s < start || s > end + 1L) {
                return this;
            }
            if (e <= end) continue;
            end = e;
        }
        return RangeSeq.get(start, end - start + 1L, true);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new List(this.info, List.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean vacuous() {
        return ((Checks<Expr>)Expr::vacuous).all((Expr[])this.exprs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof List && super.equals(obj);
    }

    @Override
    public String description() {
        return "list";
    }

    @Override
    public void toString(QueryString qs) {
        qs.params(this.exprs);
    }

    private static /* synthetic */ boolean lambda$toRange$0(Expr expr) {
        return expr instanceof Itr || expr instanceof RangeSeq;
    }
}

