/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CmpN
extends Cmp {
    private final OpN op;

    public CmpN(InputInfo info, Expr expr1, Expr expr2, OpN op) {
        super(info, expr1, expr2, Types.BOOLEAN_ZO);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        if (st1.oneOrMore() && st2.oneOrMore()) {
            this.exprType.assign(Occ.EXACTLY_ONE);
        }
        return (expr = this.emptyExpr()) == this && this.values(false, cc) ? cc.preEval(this) : cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode n1 = this.toNodeOrNull(this.exprs[0], qc);
        if (n1 == null) {
            return Empty.VALUE;
        }
        ANode n2 = this.toNodeOrNull(this.exprs[1], qc);
        if (n2 == null) {
            return Empty.VALUE;
        }
        return Bln.get(this.op.eval(n1, n2));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        ANode n1 = this.toNodeOrNull(this.exprs[0], qc);
        if (n1 == null) {
            return false;
        }
        ANode n2 = this.toNodeOrNull(this.exprs[1], qc);
        if (n2 == null) {
            return false;
        }
        return this.op.eval(n1, n2);
    }

    @Override
    public Expr invert() {
        return null;
    }

    @Override
    public CmpV.OpV opV() {
        return null;
    }

    @Override
    public CmpG.OpG opG() {
        return null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CmpN(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpN)) return false;
        CmpN cmp = (CmpN)obj;
        if (this.op != cmp.op) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "'" + String.valueOf((Object)this.op) + "' comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.op.names[0]), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + String.valueOf((Object)this.op) + " ", true);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OpN {
        EQ(new String[]{"is"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.is(node2);
            }
        }
        ,
        NE(new String[]{"is-not"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return !node1.is(node2);
            }
        }
        ,
        LT(new String[]{"<<", "precedes"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.compare(node2) < 0;
            }
        }
        ,
        LE(new String[]{"precedes-or-is"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.compare(node2) <= 0;
            }
        }
        ,
        GE(new String[]{"follows-or-is"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.compare(node2) >= 0;
            }
        }
        ,
        GT(new String[]{">>", "follows"}){

            @Override
            public boolean eval(ANode node1, ANode node2) {
                return node1.compare(node2) > 0;
            }
        };

        public final String[] names;

        private OpN(String ... names) {
            this.names = names;
        }

        public abstract boolean eval(ANode var1, ANode var2);

        public String toString() {
            return this.names[0];
        }
    }
}

