/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.query.value.Value;
import org.basex.util.list.TokenList;

public final class Caches {
    private final HashMap<String, LinkedHashMap<String, Value>> caches = new HashMap();
    private final Context context;

    public Caches(Context context) {
        this.context = context;
    }

    public synchronized Value get(String key, String name) {
        return this.caches.containsKey(name) ? this.caches.get(name).get(key) : null;
    }

    public synchronized void put(String key, Value value, String name) {
        this.caches.computeIfAbsent(name, n -> this.create()).put(key, value);
    }

    public synchronized int size(String name) {
        return this.caches.containsKey(name) ? this.caches.get(name).size() : 0;
    }

    public synchronized void delete(String name) {
        this.caches.remove(name);
    }

    public synchronized TokenList list() {
        TokenList list = new TokenList(this.caches.size());
        for (String name : this.caches.keySet()) {
            if (name.isEmpty()) continue;
            list.add(name);
        }
        return list;
    }

    public synchronized void clear() {
        this.caches.clear();
    }

    private LinkedHashMap<String, Value> create() {
        final int max = this.context.soptions.get(StaticOptions.CACHEMAX);
        return new LinkedHashMap<String, Value>(8, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Value> eldest) {
                return this.size() > max;
            }
        };
    }
}

