
Изменения в Angie 1.8.1                                           28.12.2024

    *) Исправление: использование директивы "status_zone" в блоке "server"
       HTTP-модуля приводило к избыточному логированию пустых запросов в
       "access_log" во время TLS-согласований; проблема появилась в 1.8.0.

    *) Исправление: ошибки декодирования потока HTTP/3 могли приводить к
       падению рабочего процесса при закрытии QUIC-соединения; исправление
       портировано из nginx 1.27.4.

    *) Исправление: отправка пакетов с согласованием версии протокола QUIC
       могла привести к бесконечному циклу обмена пакетами; исправление
       портировано из nginx 1.27.4.

    *) Исправление: использование DNS-валидации без хуков в ACME-модуле на
       некоторых конфигурациях могло привести к падению рабочего процесса.


Изменения в Angie 1.8.0                                           19.12.2024

    *) Изменение: при плавном завершении старых рабочих процессов
       keepalive-соединения теперь закрываются только после истечения
       таймаута, заданного директивой "lingering_timeout"; такое поведение
       позволяет предотвратить возможные ошибки на клиенте при получении
       ответа в этот момент.
       Спасибо Максиму Дунину (freenginx).

    *) Изменение: отключено кэширование значений переменных stream-модуля
       "$ssl_server_name", "$ssl_server_cert_type", "$ssl_preread_protocol"
       и "$ssl_preread_server_name", что позволит получить актуальные
       значения при использовании виртуальных серверов.

    *) Добавление: поддержка валидации "DNS-01" посредством ответа на
       DNS-запрос от ACME-сервера, что позволяет автоматически запрашивать
       сертификаты любых типов, в том числе wildcard.

    *) Добавление: система внешних вызовов в модуле ACME, настраиваемая с
       помощью директивы "acme_hook", которая позволяет обеспечить валидацию
       доменных имен посредством внешнего обработчика для интеграции с
       различными сервисами и провайдерами DNS-хостинга.

    *) Добавление: ACME-модуль выводит в лог дополнительную информацию:
       точная причина обновления сертификата, полный список доменов,
       идентификатор аккаунта пользователя, длительные периоды неактивности
       (например, во время опросов), какой домен выполняет валидацию; такая
       информация позволяет легче диагностировать проблемы на этапе
       перевыпуска сертификатов, а также прописывать DNS-запись CAA.

    *) Добавление: параметр "account_key" в директиве "acme_client",
       позволяющий переиспользовать существующий ключ аккаунта ACME-сервера,
       а не генерировать новый автоматически.

    *) Добавление: поддержка переменных в директиве "status_zone" в модулях
       HTTP и stream позволяет динамически распределять статистику по
       нескольким зонам в рамках одного блока "location" или "server"; это,
       в частности, пригодится для случая, когда один блок "server"
       обрабатывает несколько виртуальных хостов.

    *) Добавление: совместимость HTTP-модуля сжатия GZip с версиями
       библиотеки zlib-ng 2.2.0 и выше, которые ранее могли приводить к
       появлению в логе ошибок вида "[alert] gzip filter failed to use
       preallocated memory".

    *) Добавление: директива "max_headers", ограничивающая максимальное
       количество полей заголовка в HTTP-запросе для лучшей защиты от
       DoS-атак.
       Спасибо Максиму Дунину (freenginx) и Максиму Евменкину.

    *) Добавление: директивы "http3_max_table_capacity" и
       "proxy_http3_max_table_capacity" для настройки ограничения на размер
       динамической таблицы сжатия заголовка в HTTP/3.

    *) Добавление: поддержка кросс-компиляции - система сборки теперь может
       использовать скрипт-обертку для запуска автотестов, что позволяет
       подготовить сборку без запуска тестовых программ непосредственно на
       целевой платформе.

    *) Добавление: вся функциональность nginx 1.27.3.

    *) Исправление: HTTP/3-клиенты могли отключаться по таймауту при
       использовании 0-RTT; исправление портировано из nginx 1.27.4.

    *) Исправление: проксирование по HTTP/3 с использованием переменных в
       директиве "proxy_pass" и без указания блока "upstream" могло
       приводить к падению рабочего процесса.

    *) Исправление: кэширование HTTP/3-ответов при использовании
       динамической таблицы сжатия заголовка могло привести к падению
       рабочего процесса.

    *) Исправление: некоторые SSL-рукопожатия могли не учитываться в
       счетчиках статистики для stream-модуля.

    *) Исправление: настройки HTTP/3-проксирования указанные на уровне
       "http" или "server" могли игнорироваться.

    *) Исправление: при проксировании по протоколу HTTP/3 c включенной
       поддержкой NTLS директива "proxy_client_certificate" не работала.


Изменения в Angie 1.7.0                                           19.09.2024

    *) Изменение: обновлены текстовые описания кодов HTTP-ответов в
       соответствии с RFC 9110.
       Спасибо Максиму Дунину (freenginx) и Михилу В. Бейену.

    *) Изменение: теперь перед HTTP-запросом допускается не более одной
       пустой строки для улучшения защиты против DoS-атак.
       Спасибо Максиму Дунину (freenginx).

    *) Изменение: запрещены имена полей заголовка HTTP/1.x без двоеточия на
       конце; такие некорректные заголовки от клиента или проксируемого
       сервера теперь будут приводить к возврату ошибки.
       Спасибо Максиму Дунину (freenginx) и Максиму Евменкину.

    *) Изменение: при чтении тела запроса с использованием HTTP/1.1 "chunked
       transfer encoding" суммарный размер игнорируемых "chunk extensions" и
       полей "trailer header" теперь ограничен директивой
       "client_max_body_size" для улучшения защиты против DoS-атак.
       Спасибо Максиму Дунину (freenginx) и Бартеку Новотарскому.

    *) Изменение: MIME-тип в файле конфигурации "mime.types" для расширения
       bmp изменён на "image/bmp", для расширения rar - на
       "application/vnd.rar", а для расширений deb и udeb теперь указан
       "application/vnd.debian.binary-package".
       Спасибо Юрию Изоркину.

    *) Добавление: принудительное закрытие соединений к проксируемому
       серверу при удалении его из группы, настраиваемое с помощью директив
       "proxy_connection_drop", "grpc_connection_drop",
       "fastcgi_connection_drop", "scgi_connection_drop" и
       "uwsgi_connection_drop".

    *) Добавление: счетчики отдельных типов отправленных DNS-запросов в API
       статистики резолвера, собираемой параметром "status_zone" директивы
       "resolver".

    *) Добавление: переменная "$ssl_server_cert_type", содержащая тип
       выбранного сертификата при приеме TLS-соединения.

    *) Добавление: отключение создания PID-файла с помощью параметра "off" в
       директиве "pid", что может быть полезным для неизменяемых образов и
       при непосредственном управлении менеджером процессов.
       Спасибо Максиму Дунину (freenginx).

    *) Добавление: создание PID-файла теперь выполняется атомарно через
       промежуточный временный файл, что исключает момент, когда файл уже
       появился в директории, но еще пуст, и позволяет внешним программам
       проще и надежнее с ним работать.

    *) Добавление: теперь при переконфигурации не делается попытка
       пересоздать PID-файл, если имя в директиве "pid" изменилось, но
       указывает на тот же файл через симлинки, что, в частности, позволяет
       избежать проблем в системах во время миграции с "/var/run/angie.pid"
       на "/run/angie.pid".
       Спасибо Максиму Дунину (freenginx).

    *) Добавление: ошибки записи в syslog теперь логгируются не чаще одного
       раза в секунду, что помогает предотвратить засорение логов подобными
       сообщениями в случаях перегрузки или сбоя syslog-сервера.
       Спасибо Максиму Дунину (freenginx).

    *) Добавление: в почтовом прокси-сервере ограничено максимальное
       количество команд в процессе аутентификации, задаваемое директивой
       "max_commands", для улучшения защиты против DoS-атак.
       Спасибо Максиму Дунину (freenginx).

    *) Добавление: опция "--feature-cache" скрипта ./configure для
       кэширования результатов его работы с целью оптимизации массовой
       сборки модулей или кросс-компиляции.

    *) Добавление: вся функциональность nginx 1.27.1.

    *) Исправление: при запуске под systemd могли возникать ошибки "PID file
       ... not readable (yet?) after start" и "Failed to parse PID from
       file...".
       Спасибо Максиму Дунину (freenginx).


Изменения в Angie 1.6.2                                           16.08.2024

    *) Безопасность: обработка специально созданного mp4-файла модулем
       ngx_http_mp4_module могла приводить к падению рабочего процесса
       (CVE-2024-7347); исправление портировано из nginx 1.27.1.


Изменения в Angie 1.6.1                                           08.08.2024

    *) Добавление: новый счётчик "passed" в статистике API директивы
       "status_zone" модуля "stream" отслеживает соединения, передаваемые на
       другие сокеты с помощью директив "pass".

    *) Исправление: при использовании виртуальных серверов или директивы
       "pass" в модуле "stream" соединения могли учитываться некорректно в
       API статистики.

    *) Исправление: на конфигурациях с 5 ACME-клиентами и более могли
       происходить падения рабочих процессов; проблема появилась в 1.6.0.

    *) Исправление: обработка закэшированных ответов с заголовком
       "X-Accel-Redirect" могла приводить к падению рабочего процесса.
       Спасибо Максиму Дунину (freenginx) и Иржи Сетничке.


Изменения в Angie 1.6.0                                           28.06.2024

    *) Добавление: директива "sticky" и сопутствующие настройки в блоке
       "upstream" stream-модуля, позволяющие задать режим привязки сессий,
       при котором все соединения в рамках сессии будут направляться на один
       и тот же сервер.

    *) Добавление: извлечение значений Cookie из RDP-соединений с помощью
       директивы "rdp_preread" stream-модуля в переменные "$rdp_cookie" и
       "$rdp_cookie_NAME", что позволяет логгировать и привязывать
       RDP-сеансы клиентов к одним и тем же серверам при балансировке
       нагрузки.

    *) Добавление: возможность указать несколько директив "acme" в одном
       блоке "server", что позволяет настраивать получение сертификатов
       сразу двух типов в рамках данного виртуального сервера.

    *) Добавление: ключи командной строки "-m" и "-M" для отображения списка
       встроенных и загруженных модулей.

    *) Добавление: поддержка BoringSSL в модуле ACME.

    *) Добавление: вся функциональность nginx 1.27.0, включая поддержку
       виртуальных серверов в модуле "stream" и директиву "pass",
       позволяющую передавать принятые соединения на обработку в другие
       слушающие сокеты, в том числе модулей HTTP и Mail.

    *) Исправление: запрос сертификата по протоколу ACME мог завершаться
       ошибкой в некоторых конфигурациях с сообщением в логе вида "[alert]
       getsockname() failed (9: Bad file descriptor)".

    *) Исправление: запрос сертификата с большим количеством доменных имен
       по протоколу ACME мог завершаться ошибкой с сообщением в логе вида
       "[error] JSON parser error".

    *) Исправление: ACME-клиенты в конфигурациях с несколькими директивами
       "error_log" могли выводить сообщения в несоответствующие логи.


Изменения в Angie 1.5.2                                           31.05.2024

    *) Безопасность: при использовании HTTP/3 обработка специально созданной
       QUIC-сессии могла приводить к падению рабочего процесса, отправке
       клиенту содержимого памяти рабочего процесса на системах с MTU больше
       4096 байт и иметь другие последствия (CVE-2024-32760, CVE-2024-31079,
       CVE-2024-35200, CVE-2024-34161); исправление портировано из nginx
       1.26.1.


Изменения в Angie 1.5.1                                           16.05.2024

    *) Изменение: теперь ACME-клиенты не игнорируют ранее сохраненные
       сертификаты, если они просрочены или выпущены для отличающегося
       списка доменных имён, а используют их, пока идет обновление.

    *) Исправление: механизм "proxy_next_upstream" работал некорректно при
       использовании опции "resolve" директивы "server" в блоке "upstream",
       если количество полученных IP-адресов отличалось от числа заданных
       серверов.

    *) Исправление: при запросе сертификата по протоколу ACME могла
       произойти ошибка сегментации в рабочем процессе.

    *) Исправление: механизм "slow_start" не срабатывал при проксировании
       TCP-соединений в модуле "stream".

    *) Исправление: запросы HTTP/3 могли завершаться с ошибкой, если они
       были присланы как TLS 1.3 early data; проблема появилась в 1.4.0.

    *) Исправление: HTTP/3-соединение могло закрываться преждевременно при
       использовании 0-RTT в QUIC.

    *) Исправление: при чтении тела запроса из быстрого соединения было
       возможно чтение в течение долгого времени.
       Спасибо Максиму Дунину (freenginx).


Изменения в Angie 1.5.0                                           27.03.2024

    *) Добавление: начальная поддержка автоматического получения и
       обновления сертификатов по протоколу ACME, конфигурируемая с помощью
       директив "acme_client" и "acme", а также переменных вида
       "$acme_cert_*" и "$acme_cert_key_*".

    *) Добавление: настройка автоматического перенаправления для добавления
       слеша в конец URI запроса с помощью директивы "auto_redirect".

    *) Добавление: вывод содержащих даты метрик в формате временных меток
       Unix вместо ISO 8601 для использования в Prometheus, а также в JSON
       API при запросе с аргументом "?date=epoch".

    *) Добавление: новый статус "recovering" у проксируемых серверов в API
       статистики, означающий, что сервер медленно восстанавливается после
       сбоя согласно опции "slow_start".

    *) Добавление: теперь ключ "-V" показывает также релевантную версию
       nginx, что полезно для совместимости со сторонними утилитами, в
       частности certbot.
       Спасибо AdvTechnoKing.

    *) Добавление: вся функциональность nginx 1.25.4.

    *) Исправление: если был зайдествован механизм переиспользования
       SSL-сессий ("proxy_ssl_session_reuse"), то при динамическом
       обновлении списка проксируемых серверов могла происходить утечка из
       зоны разделяемой памяти ("zone"), настроенной для соответствующего
       блока "upstream".


Изменения в Angie 1.4.1                                           15.02.2024

    *) Безопасность: при использовании HTTP/3 в рабочем процессе во время
       обработки специально созданной QUIC-сессии могла произойти ошибка
       сегментации (CVE-2024-24989); при этом Angie, начиная ещё с версии
       1.4.0, не подвержен уязвимости CVE-2024-24990.


Изменения в Angie 1.4.0                                           12.12.2023

    *) Добавление: поддержка HTTP/3-соединений с upstream-серверами в
       прокси-модуле HTTP, допускающая использование клиентами произвольных
       версий HTTP. Конфигурация осуществляется с помощью директивы
       "proxy_http_version" и набора директив "proxy_quic_" и
       "proxy_http3_".

    *) Добавление: механизм плавного ввода проксируемого сервера в работу
       после сбоя с помощью опции "slow_start" директивы "server" в блоке
       "upstream".

    *) Добавление: директива "mqtt_preread" модуля "stream", позволяющая
       помещать имя пользователя и идентификатор клиента из пакета CONNECT
       протокола MQTT в переменные $mqtt_preread_username и
       $mqtt_preread_clientid.

    *) Добавление: ограничение скорости отдачи MP4-файлов клиенту
       пропорционально битрейту с помощью директив "mp4_limit_rate" и
       "mp4_limit_rate_after", снижающее нагрузку на полосу пропускания.

    *) Добавление: вся функциональность nginx 1.25.3.

    *) Исправление: если проксируемый сервер был единственным в группе, то
       он мог некорректно учитываться как "unavailable" в API статистики
       даже после восстановления работоспособности.


Изменения в Angie 1.3.2                                           23.11.2023

    *) Исправление: были возможны некорректные значения метрик в формате
       Prometheus, в значениях которых использовались отличные от $p8s_value
       переменные; на практике проблема могла наблюдаться с
       "angie_http_upstreams_peers_state" и
       "angie_stream_upstreams_peers_state" из стандартного шаблона
       "prometheus_all.conf".

    *) Исправление: некоторые попытки соединения с проксируемыми серверами
       могли не учитываться соответствующим образом в API статистики, если
       ошибка происходила моментально; проблема появилась в 1.3.0.


Изменения в Angie 1.3.1                                           18.10.2023

    *) Безопасность: добавлены дополнительные ограничения при обработке
       потоков HTTP/2, чтобы лучше противостоять DoS-атаке "HTTP/2 Rapid
       Reset" (CVE-2023-44487).


Изменения в Angie 1.3.0                                           19.09.2023

    *) Добавление: возможность указывать в директиве "location" несколько
       строк для сопоставления, что позволяет объединить несколько блоков
       "location" с одинаковыми настройками и, таким образом, упростить
       конфигурацию за счет уменьшения дублирования.

    *) Добавление: экспорт различных метрик статистики в формате Prometheus
       с гибко настраиваемыми шаблонами при помощи новых директив
       "prometheus" и "prometheus_template".

    *) Добавление: детальная информация и метрики по группам проксируемых
       stream-серверов в интерфейсе статистики, предоставляемом директивой
       "api".

    *) Добавление: опция "resolve" директивы "server" в блоке "upstream"
       модуля "stream", позволяющая отслеживать изменения списка IP-адресов,
       соответствующего доменному имени, и автоматически обновлять его без
       перезагрузки конфигурации.

    *) Добавление: опция "service" директивы "server" в блоке "upstream"
       модуля "stream", позволяющая получать списки адресов из DNS-записей
       SRV, с базовой поддержкой приоритета.

    *) Добавление: получение содержимого конфигурационных файлов, с которыми
       было запущено текущее поколение рабочих процессов, в интерфейсе,
       предоставляемом директивой "api" при включении директивы
       "api_config_files".

    *) Добавление: отображение номера поколения конфигурации в именах
       процессов, что позволяет с помощью утилиты "ps" отслеживать успех
       перезагрузок конфигурации и количество поколений рабочих процессов с
       предыдущими версиями конфигурации.

    *) Добавление: вся функциональность nginx 1.25.2.

    *) Исправление: сборка завершалась ошибкой при использовании опций
       ./configure "--without-http_upstream_zone_module" или
       "--without-stream_upstream_zone_module"; проблема появилась в 1.2.0.

    *) Изменение: теперь при загрузке конфигурации OpenSSL используется
       appname "angie".


Изменения в Angie 1.2.0                                           30.05.2023

    *) Добавление: директива "sticky" и сопутствующие настройки в блоке
       "upstream" HTTP-модуля, позволяющие задать режим привязки сессий, при
       котором все запросы в рамках сессии будут направляться на один и тот
       же сервер.

    *) Добавление: переменная $upstream_sticky_status, принимающая значения
       "NEW", "HIT" или "MISS" в зависимости от успеха направления запроса
       на релевантный проксируемый сервер с включенной привязкой сессий.

    *) Добавление: поддержка NTLS в HTTP и stream модулях при использовании
       TLS библиотеки TongSuo, которую можно включить опцией сборки
       "--with-ntls" и сконфигурировать с помощью соответствующих директив
       "ssl_ntls" и "proxy_ssl_ntls".

    *) Добавление: в HTTP и stream прокси-модулях теперь можно настраивать
       несколько сертификатов разного типа (RSA и ECDSA) и соответствующих
       им ключей, используя директивы "proxy_ssl_certificate" и
       "proxy_ssl_certificate_key".

    *) Добавление: вывод версии и сборки в отображаемом имени "master"
       процесса, что позволяет с помощью утилиты "ps" получить эту
       информацию о работающем экземпляре сервера.

    *) Добавление: возможность сжатия модулем gzip ответов со статусом "207
       Multi-Status".
       Спасибо DBotThePony.

    *) Добавление: вся функциональность nginx 1.25.0, включая поддержку
       HTTP/3.


Изменения в Angie 1.1.0                                           24.01.2023

    *) Добавление: опция "resolve" директивы "server" в блоке "upstream"
       HTTP-модуля, позволяющая отслеживать изменения списка IP-адресов,
       соответствующего доменному имени, и автоматически обновлять его без
       перезагрузки конфигурации.

    *) Добавление: опция "service" директивы "server" в блоке "upstream"
       HTTP-модуля, позволяющая получать списки адресов из DNS SRV записей,
       с базовой поддержкой приоритета.

    *) Добавление: детальная информация и метрики по группам проксируемых
       HTTP-серверов в интерфейсе статистики, предоставляемом директивой
       "api".

    *) Добавление: autoindex выводит листинги директорий в естественном
       порядке.

    *) Добавление: вся функциональность nginx 1.23.3.

    *) Исправление: сборка завершалась ошибкой из-за ложного предупреждение
       компилятора при использовании GCC 9 и старее с оптимизацией -O2 и
       выше.


Изменения в Angie 1.0.0                                           27.10.2022

    *) Добавление: директива "api", реализующая HTTP RESTful интерфейс для
       получения в формате JSON базовой информации о веб-сервере, а также
       статистики по клиентским соединениям, зонам разделяемой памяти,
       DNS-запросам, HTTP-запросам, кэшу HTTP-ответов, сессиям модуля stream
       и зонам модулей limit_conn/limit_req.

    *) Добавление: директива "status_zone" в модуле http для указания зоны
       сбора статистики по запросам в "server" и "location" контекстах.

    *) Добавление: директива "status_zone" в модуле stream для указания зоны
       сбора статистики по TCP/UDP сессиям.

    *) Добавление: параметр status_zone директивы resolver для указания зоны
       сбора статистики по DNS-запросам.

    *) Добавление: переменная $angie_version, содержащая версию Angie.

    *) Добавление: вся функциональность nginx 1.23.2.

